/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime;

import org.mockito.Mockito;
import org.neo4j.cypher.internal.runtime.ResourceManager;
import org.neo4j.cypher.internal.runtime.ResourceMonitor;
import org.neo4j.cypher.internal.v3_5.util.test_helpers.CypherFunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001}2A!\u0001\u0002\u0001\u001b\t\u0019\"+Z:pkJ\u001cW-T1oC\u001e,'\u000fV3ti*\u00111\u0001B\u0001\beVtG/[7f\u0015\t)a!\u0001\u0005j]R,'O\\1m\u0015\t9\u0001\"\u0001\u0004dsBDWM\u001d\u0006\u0003\u0013)\tQA\\3pi)T\u0011aC\u0001\u0004_J<7\u0001A\n\u0003\u00019\u0001\"a\u0004\f\u000e\u0003AQ!!\u0005\n\u0002\u0019Q,7\u000f^0iK2\u0004XM]:\u000b\u0005M!\u0012\u0001B;uS2T!!\u0006\u0003\u0002\tY\u001ct,N\u0005\u0003/A\u0011abQ=qQ\u0016\u0014h)\u001e8Tk&$X\rC\u0003\u001a\u0001\u0011\u0005!$\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011A\u0004A\u0007\u0002\u0005!)a\u0004\u0001C\u0005?\u0005)AO]1dKR!\u0001E\n\u00196!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\u0011)f.\u001b;\t\u000b\u001dj\u0002\u0019\u0001\u0015\u0002\u0011I,7o\\;sG\u0016\u0004\"!\u000b\u0018\u000e\u0003)R!a\u000b\u0017\u0002\t1\fgn\u001a\u0006\u0002[\u0005!!.\u0019<b\u0013\ty#FA\u0007BkR|7\t\\8tK\u0006\u0014G.\u001a\u0005\u0006cu\u0001\rAM\u0001\b[>t\u0017\u000e^8s!\ta2'\u0003\u00025\u0005\ty!+Z:pkJ\u001cW-T8oSR|'\u000fC\u00037;\u0001\u0007q'A\u0005sKN|WO]2fgB\u0011A\u0004O\u0005\u0003s\t\u0011qBU3t_V\u00148-Z'b]\u0006<WM\u001d\u0005\u0006w\u0001!I\u0001P\u0001\u0006G2|7/\u001a\u000b\u0004Aur\u0004\"B\u0014;\u0001\u0004A\u0003\"B\u0019;\u0001\u0004\u0011\u0004")
public class ResourceManagerTest
extends CypherFunSuite {
    public void org$neo4j$cypher$internal$runtime$ResourceManagerTest$$trace(AutoCloseable resource, ResourceMonitor monitor, ResourceManager resources) {
        resources.trace(resource);
        ((ResourceMonitor)Mockito.verify((Object)monitor)).trace(resource);
    }

    public void org$neo4j$cypher$internal$runtime$ResourceManagerTest$$close(AutoCloseable resource, ResourceMonitor monitor) {
        ((ResourceMonitor)Mockito.verify((Object)monitor)).close(resource);
        ((AutoCloseable)Mockito.verify((Object)resource)).close();
    }

    public ResourceManagerTest() {
        this.test("should be able to trace and release a resource", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResourceManagerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AutoCloseable resource = (AutoCloseable)this.$outer.mock(ManifestFactory$.MODULE$.classType(AutoCloseable.class));
                ResourceMonitor monitor = (ResourceMonitor)this.$outer.mock(ManifestFactory$.MODULE$.classType(ResourceMonitor.class));
                ResourceManager resources = new ResourceManager(monitor);
                this.$outer.org$neo4j$cypher$internal$runtime$ResourceManagerTest$$trace(resource, monitor, resources);
                resources.release(resource);
                this.$outer.org$neo4j$cypher$internal$runtime$ResourceManagerTest$$close(resource, monitor);
                resources.close(true);
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{resource, monitor});
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should close the unreleased resource when closed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResourceManagerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AutoCloseable resource = (AutoCloseable)this.$outer.mock(ManifestFactory$.MODULE$.classType(AutoCloseable.class));
                ResourceMonitor monitor = (ResourceMonitor)this.$outer.mock(ManifestFactory$.MODULE$.classType(ResourceMonitor.class));
                ResourceManager resources = new ResourceManager(monitor);
                this.$outer.org$neo4j$cypher$internal$runtime$ResourceManagerTest$$trace(resource, monitor, resources);
                resources.close(true);
                this.$outer.org$neo4j$cypher$internal$runtime$ResourceManagerTest$$close(resource, monitor);
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{resource, monitor});
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not close resources multiple times when closed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResourceManagerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AutoCloseable resource = (AutoCloseable)this.$outer.mock(ManifestFactory$.MODULE$.classType(AutoCloseable.class));
                ResourceMonitor monitor = (ResourceMonitor)this.$outer.mock(ManifestFactory$.MODULE$.classType(ResourceMonitor.class));
                ResourceManager resources = new ResourceManager(monitor);
                this.$outer.org$neo4j$cypher$internal$runtime$ResourceManagerTest$$trace(resource, monitor, resources);
                resources.close(true);
                this.$outer.org$neo4j$cypher$internal$runtime$ResourceManagerTest$$close(resource, monitor);
                resources.close(true);
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{resource, monitor});
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should be able to trace and release multiple resources", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResourceManagerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AutoCloseable resource1 = (AutoCloseable)this.$outer.mock(ManifestFactory$.MODULE$.classType(AutoCloseable.class));
                AutoCloseable resource2 = (AutoCloseable)this.$outer.mock(ManifestFactory$.MODULE$.classType(AutoCloseable.class));
                ResourceMonitor monitor = (ResourceMonitor)this.$outer.mock(ManifestFactory$.MODULE$.classType(ResourceMonitor.class));
                ResourceManager resources = new ResourceManager(monitor);
                this.$outer.org$neo4j$cypher$internal$runtime$ResourceManagerTest$$trace(resource1, monitor, resources);
                this.$outer.org$neo4j$cypher$internal$runtime$ResourceManagerTest$$trace(resource2, monitor, resources);
                resources.release(resource1);
                this.$outer.org$neo4j$cypher$internal$runtime$ResourceManagerTest$$close(resource1, monitor);
                resources.release(resource2);
                this.$outer.org$neo4j$cypher$internal$runtime$ResourceManagerTest$$close(resource2, monitor);
                resources.close(true);
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{resource1, resource2, monitor});
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should close the unreleased resources when closed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResourceManagerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AutoCloseable resource1 = (AutoCloseable)this.$outer.mock(ManifestFactory$.MODULE$.classType(AutoCloseable.class));
                AutoCloseable resource2 = (AutoCloseable)this.$outer.mock(ManifestFactory$.MODULE$.classType(AutoCloseable.class));
                ResourceMonitor monitor = (ResourceMonitor)this.$outer.mock(ManifestFactory$.MODULE$.classType(ResourceMonitor.class));
                ResourceManager resources = new ResourceManager(monitor);
                this.$outer.org$neo4j$cypher$internal$runtime$ResourceManagerTest$$trace(resource1, monitor, resources);
                this.$outer.org$neo4j$cypher$internal$runtime$ResourceManagerTest$$trace(resource2, monitor, resources);
                resources.close(true);
                this.$outer.org$neo4j$cypher$internal$runtime$ResourceManagerTest$$close(resource1, monitor);
                this.$outer.org$neo4j$cypher$internal$runtime$ResourceManagerTest$$close(resource2, monitor);
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{resource1, resource2, monitor});
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should close only the unreleased resources when closed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResourceManagerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AutoCloseable resource1 = (AutoCloseable)this.$outer.mock(ManifestFactory$.MODULE$.classType(AutoCloseable.class));
                AutoCloseable resource2 = (AutoCloseable)this.$outer.mock(ManifestFactory$.MODULE$.classType(AutoCloseable.class));
                ResourceMonitor monitor = (ResourceMonitor)this.$outer.mock(ManifestFactory$.MODULE$.classType(ResourceMonitor.class));
                ResourceManager resources = new ResourceManager(monitor);
                this.$outer.org$neo4j$cypher$internal$runtime$ResourceManagerTest$$trace(resource1, monitor, resources);
                this.$outer.org$neo4j$cypher$internal$runtime$ResourceManagerTest$$trace(resource2, monitor, resources);
                resources.release(resource2);
                this.$outer.org$neo4j$cypher$internal$runtime$ResourceManagerTest$$close(resource2, monitor);
                resources.close(true);
                this.$outer.org$neo4j$cypher$internal$runtime$ResourceManagerTest$$close(resource1, monitor);
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{resource1, resource2, monitor});
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should close all the resources even in case of exceptions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResourceManagerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AutoCloseable resource1 = (AutoCloseable)this.$outer.mock(ManifestFactory$.MODULE$.classType(AutoCloseable.class));
                AutoCloseable resource2 = (AutoCloseable)this.$outer.mock(ManifestFactory$.MODULE$.classType(AutoCloseable.class));
                AutoCloseable resource3 = (AutoCloseable)this.$outer.mock(ManifestFactory$.MODULE$.classType(AutoCloseable.class));
                ResourceMonitor monitor = (ResourceMonitor)this.$outer.mock(ManifestFactory$.MODULE$.classType(ResourceMonitor.class));
                ResourceManager resources = new ResourceManager(monitor);
                this.$outer.org$neo4j$cypher$internal$runtime$ResourceManagerTest$$trace(resource1, monitor, resources);
                this.$outer.org$neo4j$cypher$internal$runtime$ResourceManagerTest$$trace(resource2, monitor, resources);
                this.$outer.org$neo4j$cypher$internal$runtime$ResourceManagerTest$$trace(resource3, monitor, resources);
                RuntimeException exception1 = new RuntimeException();
                resource1.close();
                Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{exception1});
                RuntimeException exception2 = new RuntimeException();
                resource2.close();
                Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{exception2});
                Throwable throwable = (Throwable)Try$.MODULE$.apply((Function0)new Serializable(this, resources){
                    public static final long serialVersionUID = 0L;
                    private final ResourceManager resources$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.resources$1.close(true);
                    }
                    {
                        this.resources$1 = resources$1;
                    }
                }).failed().get();
                this.$outer.org$neo4j$cypher$internal$runtime$ResourceManagerTest$$close(resource1, monitor);
                this.$outer.org$neo4j$cypher$internal$runtime$ResourceManagerTest$$close(resource2, monitor);
                this.$outer.org$neo4j$cypher$internal$runtime$ResourceManagerTest$$close(resource3, monitor);
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{resource1, resource2, resource3, monitor});
                this.$outer.convertToAnyShouldWrapper(((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Throwable[]{throwable}))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])throwable.getSuppressed()))).shouldBe((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RuntimeException[]{exception1, exception2})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

