/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import java.util.Comparator;
import org.neo4j.collection.trackable.HeapTrackingSkipList;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.GlobalState;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.NodeState;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.hooks.PPBFSHooks;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;

public final class Propagator
implements AutoCloseable {
    private final HeapTrackingSkipList<QueuedPropagation> nodesToPropagate;
    private final MemoryTracker memoryTracker;
    private final PPBFSHooks hooks;

    public Propagator(MemoryTracker memoryTracker, PPBFSHooks hooks) {
        this.memoryTracker = memoryTracker;
        this.hooks = hooks;
        this.nodesToPropagate = new HeapTrackingSkipList(memoryTracker, QueuedPropagation.COMPARATOR);
    }

    public void schedule(NodeState nodeState, int sourceLength, int targetLength, GlobalState.ScheduleSource source) {
        this.hooks.schedule(nodeState, sourceLength, targetLength, source);
        this.nodesToPropagate.insert((Object)new QueuedPropagation(sourceLength + targetLength, sourceLength, nodeState));
        this.memoryTracker.allocateHeap(QueuedPropagation.SHALLOW_SIZE);
    }

    public void propagate(int totalLength) {
        this.hooks.propagate(this.nodesToPropagate, totalLength);
        while (!this.nodesToPropagate.isEmpty() && ((QueuedPropagation)this.nodesToPropagate.peek()).totalLength <= totalLength) {
            QueuedPropagation node = (QueuedPropagation)this.nodesToPropagate.pop();
            node.propagate();
            this.memoryTracker.releaseHeap(QueuedPropagation.SHALLOW_SIZE);
        }
    }

    public boolean hasScheduled() {
        return !this.nodesToPropagate.isEmpty();
    }

    @Override
    public void close() throws Exception {
        this.nodesToPropagate.close();
    }

    public static class QueuedPropagation {
        private final int totalLength;
        private final int sourceLength;
        private final NodeState nodeState;
        public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(QueuedPropagation.class);
        static Comparator<QueuedPropagation> COMPARATOR = (a, b) -> {
            int tl = Integer.compare(a.totalLength, b.totalLength);
            if (tl != 0) {
                return tl;
            }
            int sl = Integer.compare(a.sourceLength, b.sourceLength);
            if (sl != 0) {
                return sl;
            }
            int nid = Long.compare(a.nodeState.id(), b.nodeState.id());
            if (nid != 0) {
                return nid;
            }
            return Integer.compare(a.nodeState.state().id(), b.nodeState.state().id());
        };

        public QueuedPropagation(int totalLength, int sourceLength, NodeState nodeState) {
            this.totalLength = totalLength;
            this.sourceLength = sourceLength;
            this.nodeState = nodeState;
        }

        public String toString() {
            return "QueuedPropagation{totalLength=" + this.totalLength + ", sourceLength=" + this.sourceLength + ", nodeState=" + String.valueOf(this.nodeState) + "}";
        }

        void propagate() {
            this.nodeState.propagateLengthPair(this.sourceLength, this.totalLength - this.sourceLength);
        }
    }
}

