/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.operations;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import org.neo4j.cypher.operations.CypherTypeValueMapper;
import org.neo4j.exceptions.ArithmeticException;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.ByteArray;
import org.neo4j.values.storable.DoubleArray;
import org.neo4j.values.storable.FloatArray;
import org.neo4j.values.storable.IntArray;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LongArray;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.ShortArray;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.storable.VectorValue;
import org.neo4j.values.virtual.ListValue;

final class VectorUtils {
    private VectorUtils() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    static VectorValue vectorFromListValue(ListValue listValue) {
        try {
            return VectorUtils.vectorFromArrayValue(listValue.toStorableArray());
        }
        catch (CypherTypeException e) {
            throw CypherTypeException.functionArgumentWrongType((String)String.format("Invalid input for function 'vector()': Expected a List of Numbers but got %s", listValue), (String)"vector", (String)listValue.toString(), List.of("LIST<INTEGER | FLOAT>"), (String)listValue.getTypeName());
        }
    }

    private static VectorValue vectorFromArrayValue(ArrayValue arrayValue) {
        ArrayValue arrayValue2 = arrayValue;
        Objects.requireNonNull(arrayValue2);
        ArrayValue arrayValue3 = arrayValue2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ByteArray.class, ShortArray.class, IntArray.class, LongArray.class, FloatArray.class, DoubleArray.class}, (Object)arrayValue3, n)) {
            case 0 -> {
                ByteArray byteArray = (ByteArray)arrayValue3;
                yield Values.int8Vector((byte[])byteArray.asObject());
            }
            case 1 -> {
                ShortArray shortArray = (ShortArray)arrayValue3;
                yield Values.int16Vector((short[])shortArray.asObject());
            }
            case 2 -> {
                IntArray intArray = (IntArray)arrayValue3;
                yield Values.int32Vector((int[])intArray.asObject());
            }
            case 3 -> {
                LongArray longArray = (LongArray)arrayValue3;
                yield Values.int64Vector((long[])longArray.asObject());
            }
            case 4 -> {
                FloatArray floatArray = (FloatArray)arrayValue3;
                yield Values.float32Vector((float[])floatArray.asObject());
            }
            case 5 -> {
                DoubleArray doubleArray = (DoubleArray)arrayValue3;
                yield Values.float64Vector((double[])doubleArray.asObject());
            }
            default -> throw VectorUtils.invalidVectorType((AnyValue)arrayValue);
        };
    }

    static VectorValue int8Vector(SequenceValue vectorSequence) {
        if (vectorSequence instanceof ByteArray) {
            ByteArray bytes = (ByteArray)vectorSequence;
            return Values.int8Vector((byte[])bytes.asObjectCopy());
        }
        int index = 0;
        int length = vectorSequence.intSize();
        byte[] values = new byte[length];
        for (AnyValue value : vectorSequence) {
            if (value instanceof NumberValue) {
                NumberValue number = (NumberValue)value;
                values[index++] = (byte)number.longValue();
                continue;
            }
            throw VectorUtils.invalidVectorType(value);
        }
        return Values.int8Vector((byte[])values);
    }

    static VectorValue int16Vector(SequenceValue vectorSequence) {
        if (vectorSequence instanceof ShortArray) {
            ShortArray shorts = (ShortArray)vectorSequence;
            return Values.int16Vector((short[])shorts.asObjectCopy());
        }
        int index = 0;
        int length = vectorSequence.intSize();
        short[] values = new short[length];
        for (AnyValue value : vectorSequence) {
            if (value instanceof NumberValue) {
                NumberValue number = (NumberValue)value;
                values[index++] = (short)number.longValue();
                continue;
            }
            throw VectorUtils.invalidVectorType(value);
        }
        return Values.int16Vector((short[])values);
    }

    static VectorValue int32Vector(SequenceValue vectorSequence) {
        if (vectorSequence instanceof IntArray) {
            IntArray ints = (IntArray)vectorSequence;
            return Values.int32Vector((int[])ints.asObjectCopy());
        }
        int index = 0;
        int length = vectorSequence.intSize();
        int[] values = new int[length];
        for (AnyValue value : vectorSequence) {
            if (value instanceof NumberValue) {
                NumberValue number = (NumberValue)value;
                values[index++] = (int)number.longValue();
                continue;
            }
            throw VectorUtils.invalidVectorType(value);
        }
        return Values.int32Vector((int[])values);
    }

    static VectorValue int64Vector(SequenceValue vectorSequence) {
        if (vectorSequence instanceof LongArray) {
            LongArray longs = (LongArray)vectorSequence;
            return Values.int64Vector((long[])longs.asObjectCopy());
        }
        int index = 0;
        int length = vectorSequence.intSize();
        long[] values = new long[length];
        for (AnyValue value : vectorSequence) {
            if (value instanceof NumberValue) {
                NumberValue number = (NumberValue)value;
                values[index++] = number.longValue();
                continue;
            }
            throw VectorUtils.invalidVectorType(value);
        }
        return Values.int64Vector((long[])values);
    }

    static VectorValue float32Vector(SequenceValue vectorSequence) {
        if (vectorSequence instanceof FloatArray) {
            FloatArray floats = (FloatArray)vectorSequence;
            return Values.float32Vector((float[])floats.asObjectCopy());
        }
        int index = 0;
        int length = vectorSequence.intSize();
        float[] values = new float[length];
        for (AnyValue value : vectorSequence) {
            if (value instanceof NumberValue) {
                NumberValue number = (NumberValue)value;
                values[index++] = VectorUtils.assertNoOverflow((float)number.doubleValue());
                continue;
            }
            throw VectorUtils.invalidVectorType(value);
        }
        return Values.float32Vector((float[])values);
    }

    static VectorValue float64Vector(SequenceValue vectorSequence) {
        if (vectorSequence instanceof DoubleArray) {
            DoubleArray doubles = (DoubleArray)vectorSequence;
            return Values.float64Vector((double[])doubles.asObjectCopy());
        }
        int index = 0;
        int length = vectorSequence.intSize();
        double[] values = new double[length];
        for (AnyValue value : vectorSequence) {
            if (value instanceof NumberValue) {
                NumberValue number = (NumberValue)value;
                values[index++] = VectorUtils.assertNoOverflow(number.doubleValue());
                continue;
            }
            throw VectorUtils.invalidVectorType(value);
        }
        return Values.float64Vector((double[])values);
    }

    static float assertNoOverflow(float value) {
        if (!Float.isFinite(value)) {
            throw ArithmeticException.floatOverflow((String)Float.toString(value), (String)"Coercing to a 32 bit Float");
        }
        return value;
    }

    static double assertNoOverflow(double value) {
        if (!Double.isFinite(value)) {
            throw ArithmeticException.floatOverflow((String)Double.toString(value), (String)"Coercing to a 64 bit Float");
        }
        return value;
    }

    static Value assertDimension(VectorValue vectorValue, AnyValue dimension) {
        long dimensionValue = VectorUtils.getDimension(dimension);
        if ((long)vectorValue.dimensions() != dimensionValue) {
            throw CypherTypeException.wrongVectorDimension((String)vectorValue.prettyPrint(), (String)vectorValue.nestedTypeName(), (long)dimensionValue, (int)vectorValue.dimensions());
        }
        return vectorValue;
    }

    static long getDimension(AnyValue dimension) {
        if (!(dimension instanceof IntegralValue)) {
            throw CypherTypeException.functionArgumentWrongType((String)String.format("Invalid input for function 'vector()': Expected an integer but got %s", dimension), (String)"vector", (String)dimension.toString(), List.of("INTEGER"), (String)dimension.getTypeName());
        }
        IntegralValue dimensionValue = (IntegralValue)dimension;
        if (dimensionValue.longValue() < 1L || dimensionValue.longValue() > 4096L) {
            throw InvalidArgumentException.argumentOutOfRange((String)"vector", (String)"dimension", (long)1L, (long)4096L, (long)dimensionValue.longValue());
        }
        return dimensionValue.longValue();
    }

    static CypherTypeException invalidVectorType(AnyValue value) {
        return CypherTypeException.functionArgumentWrongType((String)("Invalid input for function 'vector()': Expected a NUMBER, got: " + String.valueOf(value)), (String)"vector", (String)value.prettyPrint(), List.of("INTEGER", "FLOAT"), (String)CypherTypeValueMapper.valueType(value));
    }

    static CypherTypeException invalidVector(AnyValue vector) {
        return CypherTypeException.functionArgumentWrongType((String)String.format("Invalid input for function 'vector()': Expected a string or list but got %s", vector), (String)"vector", (String)vector.toString(), List.of("STRING", "LIST<INTEGER | FLOAT>"), (String)vector.getTypeName());
    }
}

