/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime;

import java.io.Serializable;
import org.neo4j.cypher.internal.logical.plans.TraversalPathMode;
import org.neo4j.cypher.internal.runtime.HeapTrackingLongImmutableSet;
import org.neo4j.cypher.internal.runtime.RelationshipContainer$;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import scala.Function1;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005mca\u0002\u0013&!\u0003\r\n\u0001\r\u0005\u0006y\u00011\t!\u0010\u0005\u0006\u0015\u00021\ta\u0013\u0005\u0006\u0015\u00021\ta\u0015\u0005\u00063\u00021\tA\u0017\u0005\u00067\u00021\t\u0001\u0018\u0005\u0006A\u00021\t!Y\u0004\u0006K\u0016B\tA\u001a\u0004\u0006I\u0015B\ta\u001a\u0005\u0006W\"!\t\u0001\u001c\u0004\u0005[\"!a\u000e\u0003\u0005p\u0015\t\u0015\r\u0011\"\u0003q\u0011!!(B!A!\u0002\u0013\t\b\u0002C.\u000b\u0005\u000b\u0007I\u0011\u0001/\t\u0011UT!\u0011!Q\u0001\nuC\u0001B\u001e\u0006\u0003\u0002\u0003\u0006Ia\u001e\u0005\u0007W*!\t\u0001\u0003>\t\u000b\u0001TA\u0011I1\t\rqRA\u0011IA\u0001\u0011\u0019Q%\u0002\"\u0011\u0002\u0006!1!J\u0003C!\u0003\u0013AQ!\u0017\u0006\u0005BiCq!!\u0004\u000b\t\u0003\nyA\u0002\u0004\u0002\u0018!!\u0011\u0011\u0004\u0005\t_^\u0011)\u0019!C\u0005a\"AAo\u0006B\u0001B\u0003%\u0011\u000f\u0003\u0005\\/\t\u0015\r\u0011\"\u0001]\u0011!)xC!A!\u0002\u0013i\u0006bB6\u0018\t\u0003A\u00111\u0004\u0005\u0006A^!\t%\u0019\u0005\u0007y]!\t%a\t\t\r);B\u0011IA\u0014\u0011\u0019Qu\u0003\"\u0011\u0002,!)\u0011l\u0006C!5\"9\u0011QB\f\u0005B\u0005=\u0001bBA\u0018\u0011\u0011\u0005\u0011\u0011\u0007\u0002\u0016%\u0016d\u0017\r^5p]ND\u0017\u000e]\"p]R\f\u0017N\\3s\u0015\t1s%A\u0004sk:$\u0018.\\3\u000b\u0005!J\u0013\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005)Z\u0013AB2za\",'O\u0003\u0002-[\u0005)a.Z85U*\ta&A\u0002pe\u001e\u001c\u0001aE\u0002\u0001ce\u0002\"AM\u001c\u000e\u0003MR!\u0001N\u001b\u0002\t1\fgn\u001a\u0006\u0002m\u0005!!.\u0019<b\u0013\tA4G\u0001\u0004PE*,7\r\u001e\t\u0003eiJ!aO\u001a\u0003\u001b\u0005+Ho\\\"m_N,\u0017M\u00197f\u0003\u0019\t\u0007\u000f]3oIR\u0011a\b\u0011\t\u0003\u007f\u0001i\u0011!\n\u0005\u0006\u0003\u0006\u0001\rAQ\u0001\u0004e\u0016d\u0007CA\"I\u001b\u0005!%BA#G\u0003\u001d1\u0018N\u001d;vC2T!aR\u0016\u0002\rY\fG.^3t\u0013\tIEI\u0001\rWSJ$X/\u00197SK2\fG/[8og\"L\u0007OV1mk\u0016\faaY1o\u0003\u0012$GC\u0001'S!\ti\u0005+D\u0001O\u0015\u0005y\u0015!B:dC2\f\u0017BA)O\u0005\u001d\u0011un\u001c7fC:DQ!\u0011\u0002A\u0002\t#\"\u0001\u0014+\t\u000bU\u001b\u0001\u0019\u0001,\u0002\u000bI,G.\u00133\u0011\u00055;\u0016B\u0001-O\u0005\u0011auN\\4\u0002\u000fI,g/\u001a:tKV\ta(\u0001\u0003tSj,W#A/\u0011\u00055s\u0016BA0O\u0005\rIe\u000e^\u0001\u0007CNd\u0015n\u001d;\u0016\u0003\t\u0004\"aQ2\n\u0005\u0011$%!\u0003'jgR4\u0016\r\\;f\u0003U\u0011V\r\\1uS>t7\u000f[5q\u0007>tG/Y5oKJ\u0004\"a\u0010\u0005\u0014\u0005!A\u0007CA'j\u0013\tQgJ\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0019\u0014a\u0004\u0016:bS2lu\u000eZ3SK2\fG/[8og\"L\u0007oQ8oi\u0006Lg.\u001a:\u0014\u0007)\td(A\u0005nCf\u0014W\rT5tiV\t\u0011\u000fE\u0002Ne\nL!a\u001d(\u0003\r=\u0003H/[8o\u0003)i\u0017-\u001f2f\u0019&\u001cH\u000fI\u0001\u0006g&TX\rI\u0001\u0004g\u0016$\bCA y\u0013\tIXE\u0001\u000fIK\u0006\u0004HK]1dW&tw\rT8oO&kW.\u001e;bE2,7+\u001a;\u0015\tmlhp \t\u0003y*i\u0011\u0001\u0003\u0005\u0006_B\u0001\r!\u001d\u0005\u00067B\u0001\r!\u0018\u0005\u0006mB\u0001\ra\u001e\u000b\u0004}\u0005\r\u0001\"B!\u0013\u0001\u0004\u0011Ec\u0001'\u0002\b!)\u0011i\u0005a\u0001\u0005R\u0019A*a\u0003\t\u000bU#\u0002\u0019\u0001,\u0002\u000b\rdwn]3\u0015\u0005\u0005E\u0001cA'\u0002\u0014%\u0019\u0011Q\u0003(\u0003\tUs\u0017\u000e\u001e\u0002\u001e/\u0006d7.T8eKJ+G.\u0019;j_:\u001c\b.\u001b9D_:$\u0018-\u001b8feN\u0019q#\r \u0015\r\u0005u\u0011qDA\u0011!\tax\u0003C\u0003p9\u0001\u0007\u0011\u000fC\u0003\\9\u0001\u0007Q\fF\u0002?\u0003KAQ!\u0011\u0010A\u0002\t#2\u0001TA\u0015\u0011\u0015\tu\u00041\u0001C)\ra\u0015Q\u0006\u0005\u0006+\u0002\u0002\rAV\u0001\u0006K6\u0004H/\u001f\u000b\b}\u0005M\u00121IA,\u0011\u001d\t)d\ta\u0001\u0003o\tQ\"\\3n_JLHK]1dW\u0016\u0014\b\u0003BA\u001d\u0003\u007fi!!a\u000f\u000b\u0007\u0005u2&\u0001\u0004nK6|'/_\u0005\u0005\u0003\u0003\nYDA\u0007NK6|'/\u001f+sC\u000e\\WM\u001d\u0005\b\u0003\u000b\u001a\u0003\u0019AA$\u0003E!(/\u0019<feN\fG\u000eU1uQ6{G-\u001a\t\u0005\u0003\u0013\n\u0019&\u0004\u0002\u0002L)!\u0011QJA(\u0003\u0015\u0001H.\u00198t\u0015\r\t\tfJ\u0001\bY><\u0017nY1m\u0013\u0011\t)&a\u0013\u0003#Q\u0013\u0018M^3sg\u0006d\u0007+\u0019;i\u001b>$W\r\u0003\u0004\u0002Z\r\u0002\r\u0001T\u0001\ngR|'/\u001a'jgR\u0004")
public interface RelationshipContainer
extends AutoCloseable {
    public static RelationshipContainer empty(MemoryTracker memoryTracker, TraversalPathMode traversalPathMode, boolean storeList) {
        return RelationshipContainer$.MODULE$.empty(memoryTracker, traversalPathMode, storeList);
    }

    public RelationshipContainer append(VirtualRelationshipValue var1);

    public boolean canAdd(VirtualRelationshipValue var1);

    public boolean canAdd(long var1);

    public RelationshipContainer reverse();

    public int size();

    public ListValue asList();

    private static class TrailModeRelationshipContainer
    implements RelationshipContainer {
        private final Option<ListValue> maybeList;
        private final int size;
        private final HeapTrackingLongImmutableSet set;

        private Option<ListValue> maybeList() {
            return this.maybeList;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public ListValue asList() {
            return (ListValue)this.maybeList().get();
        }

        @Override
        public RelationshipContainer append(VirtualRelationshipValue rel) {
            return new TrailModeRelationshipContainer((Option<ListValue>)this.maybeList().map((Function1 & Serializable)x$1 -> x$1.append((AnyValue)rel)), this.size() + 1, this.set.$plus(rel.id()));
        }

        @Override
        public boolean canAdd(VirtualRelationshipValue rel) {
            return !this.set.contains(rel.id());
        }

        @Override
        public boolean canAdd(long relId) {
            return !this.set.contains(relId);
        }

        @Override
        public RelationshipContainer reverse() {
            return new TrailModeRelationshipContainer((Option<ListValue>)this.maybeList().map((Function1 & Serializable)x$2 -> x$2.reverse()), this.size(), this.set);
        }

        @Override
        public void close() {
            this.set.close();
        }

        public TrailModeRelationshipContainer(Option<ListValue> maybeList, int size, HeapTrackingLongImmutableSet set) {
            this.maybeList = maybeList;
            this.size = size;
            this.set = set;
        }
    }

    private static class WalkModeRelationshipContainer
    implements RelationshipContainer {
        private final Option<ListValue> maybeList;
        private final int size;

        private Option<ListValue> maybeList() {
            return this.maybeList;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public ListValue asList() {
            return (ListValue)this.maybeList().get();
        }

        @Override
        public RelationshipContainer append(VirtualRelationshipValue rel) {
            return new WalkModeRelationshipContainer((Option<ListValue>)this.maybeList().map((Function1 & Serializable)x$3 -> x$3.append((AnyValue)rel)), this.size() + 1);
        }

        @Override
        public boolean canAdd(VirtualRelationshipValue rel) {
            return true;
        }

        @Override
        public boolean canAdd(long relId) {
            return true;
        }

        @Override
        public RelationshipContainer reverse() {
            return new WalkModeRelationshipContainer((Option<ListValue>)this.maybeList().map((Function1 & Serializable)x$4 -> x$4.reverse()), this.size());
        }

        @Override
        public void close() {
        }

        public WalkModeRelationshipContainer(Option<ListValue> maybeList, int size) {
            this.maybeList = maybeList;
            this.size = size;
        }
    }
}

