/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.collection.trackable.HeapTrackingIntArrayList;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.NodeState;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.PathWriter;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.SignpostTracking;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.TwoWaySignpost;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.hooks.PPBFSHooks;
import org.neo4j.memory.MemoryTracker;

public class SignpostStack {
    private final HeapTrackingArrayList<TwoWaySignpost> activeSignposts;
    private final HeapTrackingIntArrayList nodeSourceSignpostIndices;
    private final PPBFSHooks hooks;
    private NodeState targetNode = null;
    private int dgLength = -1;
    private int dgLengthToTarget = -1;
    private final SignpostTracking signpostTracking;

    SignpostStack(MemoryTracker memoryTracker, SignpostTracking signpostTracking, PPBFSHooks hooks) {
        this.activeSignposts = HeapTrackingArrayList.newArrayList((MemoryTracker)memoryTracker);
        this.nodeSourceSignpostIndices = HeapTrackingIntArrayList.newIntArrayList((MemoryTracker)memoryTracker);
        this.signpostTracking = signpostTracking;
        this.hooks = hooks;
        this.nodeSourceSignpostIndices.add(-1);
    }

    public boolean hasNext() {
        return this.nodeSourceSignpostIndices.notEmpty();
    }

    public boolean isProtectedFromPruning() {
        return this.signpostTracking.isProtectedFromPruning(this);
    }

    public void reset() {
        this.targetNode = null;
        this.signpostTracking.clear();
        this.activeSignposts.clear();
        this.nodeSourceSignpostIndices.clear();
        this.dgLength = -1;
        this.dgLengthToTarget = -1;
    }

    public void initialize(NodeState targetNode, int dgLength) {
        this.targetNode = targetNode;
        this.dgLength = dgLength;
        this.nodeSourceSignpostIndices.add(-1);
        this.dgLengthToTarget = 0;
    }

    public TwoWaySignpost headSignpost() {
        return (TwoWaySignpost)this.activeSignposts.last();
    }

    public NodeState headNode() {
        return this.activeSignposts.isEmpty() ? this.targetNode : ((TwoWaySignpost)this.activeSignposts.last()).prevNode;
    }

    public NodeState target() {
        return this.targetNode;
    }

    public int size() {
        return this.activeSignposts.size();
    }

    public TwoWaySignpost signpost(int index) {
        return (TwoWaySignpost)this.activeSignposts.get(index);
    }

    public NodeState node(int index) {
        return index == 0 ? this.targetNode : this.signpost((int)(index - 1)).prevNode;
    }

    public int lengthToTarget() {
        return this.dgLengthToTarget;
    }

    public int lengthFromSource() {
        return this.dgLength - this.dgLengthToTarget;
    }

    int dgLength() {
        return this.dgLength;
    }

    public void materialize(PathWriter writer) {
        for (int i = this.activeSignposts.size() - 1; i >= 0; --i) {
            TwoWaySignpost signpost = (TwoWaySignpost)this.activeSignposts.get(i);
            signpost.materialize(writer);
        }
        writer.writeNode(this.targetNode.state().slotOrName(), this.targetNode.id());
    }

    public boolean pushNext() {
        int currentIndex;
        NodeState current = this.headNode();
        int nextIndex = current.nextSignpostIndexForLength(currentIndex = this.nodeSourceSignpostIndices.last(), this.lengthFromSource());
        if (nextIndex == -1) {
            return false;
        }
        TwoWaySignpost signpost = current.getSourceSignpost(nextIndex);
        this.activeSignposts.add((Object)signpost);
        this.dgLengthToTarget += signpost.dataGraphLength();
        this.nodeSourceSignpostIndices.set(this.nodeSourceSignpostIndices.size() - 1, nextIndex);
        this.nodeSourceSignpostIndices.add(-1);
        this.signpostTracking.onPushed(signpost, this);
        this.hooks.activateSignpost(this.lengthFromSource(), signpost);
        return true;
    }

    public boolean validate() {
        return this.signpostTracking.validate(this);
    }

    public TwoWaySignpost pop() {
        this.nodeSourceSignpostIndices.removeLast();
        if (this.activeSignposts.isEmpty()) {
            return null;
        }
        TwoWaySignpost signpost = (TwoWaySignpost)this.activeSignposts.removeLast();
        this.signpostTracking.onPopped(signpost, this);
        this.dgLengthToTarget -= signpost.dataGraphLength();
        this.hooks.deactivateSignpost(this.lengthFromSource(), signpost);
        return signpost;
    }

    public boolean isValid() {
        return this.signpostTracking.isValid(this);
    }

    public boolean canAbandonTraceBranch() {
        return this.signpostTracking.canAbandonTraceBranch(this);
    }
}

