/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.operations;

import java.util.HashSet;
import org.neo4j.cypher.internal.util.InputPosition;
import org.neo4j.cypher.internal.util.symbols.BooleanType;
import org.neo4j.cypher.internal.util.symbols.ClosedDynamicUnionType;
import org.neo4j.cypher.internal.util.symbols.CypherType;
import org.neo4j.cypher.internal.util.symbols.DateType;
import org.neo4j.cypher.internal.util.symbols.DurationType;
import org.neo4j.cypher.internal.util.symbols.Float32Type;
import org.neo4j.cypher.internal.util.symbols.FloatType;
import org.neo4j.cypher.internal.util.symbols.Integer16Type;
import org.neo4j.cypher.internal.util.symbols.Integer32Type;
import org.neo4j.cypher.internal.util.symbols.Integer8Type;
import org.neo4j.cypher.internal.util.symbols.IntegerType;
import org.neo4j.cypher.internal.util.symbols.ListType;
import org.neo4j.cypher.internal.util.symbols.LocalDateTimeType;
import org.neo4j.cypher.internal.util.symbols.LocalTimeType;
import org.neo4j.cypher.internal.util.symbols.MapType;
import org.neo4j.cypher.internal.util.symbols.NodeType;
import org.neo4j.cypher.internal.util.symbols.NothingType;
import org.neo4j.cypher.internal.util.symbols.NullType;
import org.neo4j.cypher.internal.util.symbols.PathType;
import org.neo4j.cypher.internal.util.symbols.PointType;
import org.neo4j.cypher.internal.util.symbols.RelationshipType;
import org.neo4j.cypher.internal.util.symbols.StringType;
import org.neo4j.cypher.internal.util.symbols.VectorType;
import org.neo4j.cypher.internal.util.symbols.ZonedDateTimeType;
import org.neo4j.cypher.internal.util.symbols.ZonedTimeType;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.BooleanArray;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.DateArray;
import org.neo4j.values.storable.DateTimeArray;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationArray;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.Float32Vector;
import org.neo4j.values.storable.Float64Vector;
import org.neo4j.values.storable.FloatingPointArray;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.Int16Vector;
import org.neo4j.values.storable.Int32Vector;
import org.neo4j.values.storable.Int64Vector;
import org.neo4j.values.storable.Int8Vector;
import org.neo4j.values.storable.IntegralArray;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LocalDateTimeArray;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeArray;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.NumberArray;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointArray;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeArray;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.VectorValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualPathValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import scala.Option;
import scala.jdk.javaapi.CollectionConverters;

public final class CypherTypeValueMapper
implements ValueMapper<CypherType> {
    private static final InputPosition dummyPos = InputPosition.NONE();
    private static final NullType NULL_CYPHER_TYPE_NAME = new NullType(dummyPos);
    private static final BooleanType BOOLEAN_CYPHER_TYPE_NAME = new BooleanType(false, dummyPos);
    private static final StringType STRING_CYPHER_TYPE_NAME = new StringType(false, dummyPos);
    private static final Integer8Type INTEGER8_CYPHER_TYPE_NAME = new Integer8Type(false, dummyPos);
    private static final Integer16Type INTEGER16_CYPHER_TYPE_NAME = new Integer16Type(false, dummyPos);
    private static final Integer32Type INTEGER32_CYPHER_TYPE_NAME = new Integer32Type(false, dummyPos);
    private static final IntegerType INTEGER_CYPHER_TYPE_NAME = new IntegerType(false, dummyPos);
    private static final Float32Type FLOAT32_CYPHER_TYPE_NAME = new Float32Type(false, dummyPos);
    private static final FloatType FLOAT_CYPHER_TYPE_NAME = new FloatType(false, dummyPos);
    private static final DateType DATE_CYPHER_TYPE_NAME = new DateType(false, dummyPos);
    private static final LocalTimeType LOCAL_TIME_CYPHER_TYPE_NAME = new LocalTimeType(false, dummyPos);
    private static final ZonedTimeType ZONED_TIME_CYPHER_TYPE_NAME = new ZonedTimeType(false, dummyPos);
    private static final LocalDateTimeType LOCAL_DATETIME_CYPHER_TYPE_NAME = new LocalDateTimeType(false, dummyPos);
    private static final ZonedDateTimeType ZONED_DATETIME_CYPHER_TYPE_NAME = new ZonedDateTimeType(false, dummyPos);
    private static final DurationType DURATION_CYPHER_TYPE_NAME = new DurationType(false, dummyPos);
    private static final PointType POINT_CYPHER_TYPE_NAME = new PointType(false, dummyPos);
    private static final NodeType NODE_CYPHER_TYPE_NAME = new NodeType(false, dummyPos);
    private static final RelationshipType RELATIONSHIP_CYPHER_TYPE_NAME = new RelationshipType(false, dummyPos);
    private static final MapType MAP_CYPHER_TYPE_NAME = new MapType(false, dummyPos);
    private static final PathType PATH_CYPHER_TYPE_NAME = new PathType(false, dummyPos);
    private static final VectorType INTEGER8_VECTOR_CYPHER_TYPE_NAME = new VectorType(Option.apply((Object)INTEGER8_CYPHER_TYPE_NAME), Option.empty(), false, dummyPos);
    private static final VectorType INTEGER16_VECTOR_CYPHER_TYPE_NAME = new VectorType(Option.apply((Object)INTEGER16_CYPHER_TYPE_NAME), Option.empty(), false, dummyPos);
    private static final VectorType INTEGER32_VECTOR_CYPHER_TYPE_NAME = new VectorType(Option.apply((Object)INTEGER32_CYPHER_TYPE_NAME), Option.empty(), false, dummyPos);
    private static final VectorType INTEGER64_VECTOR_CYPHER_TYPE_NAME = new VectorType(Option.apply((Object)INTEGER_CYPHER_TYPE_NAME), Option.empty(), false, dummyPos);
    private static final VectorType FLOAT32_VECTOR_CYPHER_TYPE_NAME = new VectorType(Option.apply((Object)FLOAT32_CYPHER_TYPE_NAME), Option.empty(), false, dummyPos);
    private static final VectorType FLOAT64_VECTOR_CYPHER_TYPE_NAME = new VectorType(Option.apply((Object)FLOAT_CYPHER_TYPE_NAME), Option.empty(), false, dummyPos);
    private static final VectorType ANY_VECTOR_CYPHER_TYPE_NAME = new VectorType(Option.empty(), Option.empty(), false, dummyPos);
    private static final ListType LIST_BOOLEAN_CYPHER_TYPE_NAME = new ListType((CypherType)BOOLEAN_CYPHER_TYPE_NAME, false, dummyPos);
    private static final ListType LIST_STRING_CYPHER_TYPE_NAME = new ListType((CypherType)STRING_CYPHER_TYPE_NAME, false, dummyPos);
    private static final ListType LIST_INTEGER_CYPHER_TYPE_NAME = new ListType((CypherType)INTEGER_CYPHER_TYPE_NAME, false, dummyPos);
    private static final ListType LIST_FLOAT_CYPHER_TYPE_NAME = new ListType((CypherType)FLOAT_CYPHER_TYPE_NAME, false, dummyPos);
    private static final ListType LIST_DATE_CYPHER_TYPE_NAME = new ListType((CypherType)DATE_CYPHER_TYPE_NAME, false, dummyPos);
    private static final ListType LIST_LOCAL_TIME_CYPHER_TYPE_NAME = new ListType((CypherType)LOCAL_TIME_CYPHER_TYPE_NAME, false, dummyPos);
    private static final ListType LIST_ZONED_TIME_CYPHER_TYPE_NAME = new ListType((CypherType)ZONED_TIME_CYPHER_TYPE_NAME, false, dummyPos);
    private static final ListType LIST_LOCAL_DATETIME_CYPHER_TYPE_NAME = new ListType((CypherType)LOCAL_DATETIME_CYPHER_TYPE_NAME, false, dummyPos);
    private static final ListType LIST_ZONED_DATETIME_CYPHER_TYPE_NAME = new ListType((CypherType)ZONED_DATETIME_CYPHER_TYPE_NAME, false, dummyPos);
    private static final ListType LIST_DURATION_CYPHER_TYPE_NAME = new ListType((CypherType)DURATION_CYPHER_TYPE_NAME, false, dummyPos);
    private static final ListType LIST_POINT_CYPHER_TYPE_NAME = new ListType((CypherType)POINT_CYPHER_TYPE_NAME, false, dummyPos);
    private static final CypherTypeValueMapper CYPHER_TYPE_NAME_VALUE_MAPPER = new CypherTypeValueMapper();

    public static String valueType(AnyValue in) {
        return in == null ? "NULL" : ((CypherType)in.map((ValueMapper)CYPHER_TYPE_NAME_VALUE_MAPPER)).description();
    }

    public CypherType mapNoValue() {
        return NULL_CYPHER_TYPE_NAME;
    }

    public CypherType mapBoolean(BooleanValue value) {
        return BOOLEAN_CYPHER_TYPE_NAME;
    }

    public CypherType mapText(TextValue value) {
        return STRING_CYPHER_TYPE_NAME;
    }

    public CypherType mapNumber(NumberValue value) {
        if (value instanceof IntegralValue) {
            return INTEGER_CYPHER_TYPE_NAME;
        }
        return FLOAT_CYPHER_TYPE_NAME;
    }

    public CypherType mapIntegral(IntegralValue value) {
        return INTEGER_CYPHER_TYPE_NAME;
    }

    public CypherType mapFloatingPoint(FloatingPointValue value) {
        return FLOAT_CYPHER_TYPE_NAME;
    }

    public CypherType mapDate(DateValue value) {
        return DATE_CYPHER_TYPE_NAME;
    }

    public CypherType mapLocalTime(LocalTimeValue value) {
        return LOCAL_TIME_CYPHER_TYPE_NAME;
    }

    public CypherType mapTime(TimeValue value) {
        return ZONED_TIME_CYPHER_TYPE_NAME;
    }

    public CypherType mapLocalDateTime(LocalDateTimeValue value) {
        return LOCAL_DATETIME_CYPHER_TYPE_NAME;
    }

    public CypherType mapDateTime(DateTimeValue value) {
        return ZONED_DATETIME_CYPHER_TYPE_NAME;
    }

    public CypherType mapDuration(DurationValue value) {
        return DURATION_CYPHER_TYPE_NAME;
    }

    public CypherType mapPoint(PointValue value) {
        return POINT_CYPHER_TYPE_NAME;
    }

    public CypherType mapNode(VirtualNodeValue value) {
        return NODE_CYPHER_TYPE_NAME;
    }

    public CypherType mapRelationship(VirtualRelationshipValue value) {
        return RELATIONSHIP_CYPHER_TYPE_NAME;
    }

    public CypherType mapMap(MapValue value) {
        return MAP_CYPHER_TYPE_NAME;
    }

    public CypherType mapSequence(SequenceValue value) {
        if (value.isEmpty()) {
            return new ListType((CypherType)new NothingType(dummyPos), false, dummyPos);
        }
        if (value instanceof ArrayValue) {
            ArrayValue array = (ArrayValue)value;
            return new ListType((CypherType)array.value(0).map((ValueMapper)this), false, dummyPos);
        }
        HashSet innerTypes = new HashSet();
        value.forEach(listItem -> innerTypes.add((CypherType)listItem.map((ValueMapper)this)));
        return new ListType((CypherType)new ClosedDynamicUnionType(CollectionConverters.asScala(innerTypes).toSet(), dummyPos), false, dummyPos);
    }

    public CypherType mapTextArray(TextArray value) {
        if (value.isEmpty()) {
            return new ListType((CypherType)new NothingType(dummyPos), false, dummyPos);
        }
        return LIST_STRING_CYPHER_TYPE_NAME;
    }

    public CypherType mapBooleanArray(BooleanArray value) {
        return LIST_BOOLEAN_CYPHER_TYPE_NAME;
    }

    public CypherType mapNumberArray(NumberArray value) {
        return this.mapSequence((SequenceValue)value);
    }

    public CypherType mapIntegralArray(IntegralArray value) {
        return LIST_INTEGER_CYPHER_TYPE_NAME;
    }

    public CypherType mapFloatingPointArray(FloatingPointArray value) {
        return LIST_FLOAT_CYPHER_TYPE_NAME;
    }

    public CypherType mapDateArray(DateArray value) {
        return LIST_DATE_CYPHER_TYPE_NAME;
    }

    public CypherType mapLocalTimeArray(LocalTimeArray value) {
        return LIST_LOCAL_TIME_CYPHER_TYPE_NAME;
    }

    public CypherType mapTimeArray(TimeArray value) {
        return LIST_ZONED_TIME_CYPHER_TYPE_NAME;
    }

    public CypherType mapLocalDateTimeArray(LocalDateTimeArray value) {
        return LIST_LOCAL_DATETIME_CYPHER_TYPE_NAME;
    }

    public CypherType mapDateTimeArray(DateTimeArray value) {
        return LIST_ZONED_DATETIME_CYPHER_TYPE_NAME;
    }

    public CypherType mapPointArray(PointArray value) {
        return LIST_POINT_CYPHER_TYPE_NAME;
    }

    public CypherType mapDurationArray(DurationArray value) {
        return LIST_DURATION_CYPHER_TYPE_NAME;
    }

    public CypherType mapPath(VirtualPathValue value) {
        return PATH_CYPHER_TYPE_NAME;
    }

    public CypherType mapVector(VectorValue value) {
        return ANY_VECTOR_CYPHER_TYPE_NAME;
    }

    public CypherType mapInt8Vector(Int8Vector value) {
        return INTEGER8_VECTOR_CYPHER_TYPE_NAME;
    }

    public CypherType mapInt16Vector(Int16Vector value) {
        return INTEGER16_VECTOR_CYPHER_TYPE_NAME;
    }

    public CypherType mapInt32Vector(Int32Vector value) {
        return INTEGER32_VECTOR_CYPHER_TYPE_NAME;
    }

    public CypherType mapInt64Vector(Int64Vector value) {
        return INTEGER64_VECTOR_CYPHER_TYPE_NAME;
    }

    public CypherType mapFloat32Vector(Float32Vector value) {
        return FLOAT32_VECTOR_CYPHER_TYPE_NAME;
    }

    public CypherType mapFloat64Vector(Float64Vector value) {
        return FLOAT64_VECTOR_CYPHER_TYPE_NAME;
    }
}

