/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.operations;

import java.math.BigDecimal;
import java.util.List;
import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.ListLiteral;
import org.neo4j.cypher.internal.expressions.Literal;
import org.neo4j.cypher.internal.expressions.NumberLiteral;
import org.neo4j.cypher.internal.parser.AstParserFactory;
import org.neo4j.cypher.internal.parser.AstParserFactory$;
import org.neo4j.cypher.internal.parser.ast.AstParser;
import org.neo4j.cypher.internal.util.CypherExceptionFactory;
import org.neo4j.cypher.internal.util.Neo4jCypherExceptionFactory;
import org.neo4j.cypher.operations.VectorUtils;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.exceptions.SyntaxException;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.storable.VectorValue;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;

abstract class CypherRuntimeParser {
    private static final BigDecimal MAX_LONG = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigDecimal MIN_LONG = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final AstParserFactory parserFactory = AstParserFactory$.MODULE$.apply(CypherVersion.Cypher25);

    private CypherRuntimeParser() {
        throw new UnsupportedOperationException();
    }

    static VectorValue parseInt8Vector(String expression) {
        Seq<Expression> expressions = CypherRuntimeParser.asList(expression);
        int length = expressions.size();
        byte[] bytes = new byte[length];
        Iterator iterator = expressions.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            bytes[i++] = CypherRuntimeParser.asByte((Expression)iterator.next());
        }
        return Values.int8Vector((byte[])bytes);
    }

    static VectorValue parseInt16Vector(String expression) {
        Seq<Expression> expressions = CypherRuntimeParser.asList(expression);
        int length = expressions.size();
        short[] shorts = new short[length];
        Iterator iterator = expressions.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            shorts[i++] = CypherRuntimeParser.asShort((Expression)iterator.next());
        }
        return Values.int16Vector((short[])shorts);
    }

    static VectorValue parseInt32Vector(String expression) {
        Seq<Expression> expressions = CypherRuntimeParser.asList(expression);
        int length = expressions.size();
        int[] ints = new int[length];
        Iterator iterator = expressions.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            ints[i++] = CypherRuntimeParser.asInt((Expression)iterator.next());
        }
        return Values.int32Vector((int[])ints);
    }

    static VectorValue parseInt64Vector(String expression) {
        Seq<Expression> expressions = CypherRuntimeParser.asList(expression);
        int length = expressions.size();
        long[] longs = new long[length];
        Iterator iterator = expressions.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            longs[i++] = CypherRuntimeParser.asLong((Expression)iterator.next());
        }
        return Values.int64Vector((long[])longs);
    }

    static VectorValue parseFloat32Vector(String expression) {
        Seq<Expression> expressions = CypherRuntimeParser.asList(expression);
        int length = expressions.size();
        float[] floats = new float[length];
        Iterator iterator = expressions.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            floats[i++] = VectorUtils.assertNoOverflow(CypherRuntimeParser.asNumber((Expression)iterator.next()).floatValue());
        }
        return Values.float32Vector((float[])floats);
    }

    static VectorValue parseFloat64Vector(String expression) {
        Seq<Expression> expressions = CypherRuntimeParser.asList(expression);
        int length = expressions.size();
        double[] doubles = new double[length];
        Iterator iterator = expressions.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            doubles[i++] = VectorUtils.assertNoOverflow(CypherRuntimeParser.asNumber((Expression)iterator.next()).doubleValue());
        }
        return Values.float64Vector((double[])doubles);
    }

    public static Value parseAsDoubleOrElseNoValue(String expression) {
        try {
            return Values.doubleValue((double)Double.parseDouble(expression));
        }
        catch (NumberFormatException ignore1) {
            try {
                return Values.doubleValue((double)CypherRuntimeParser.parser(expression).numberLiteral().value().doubleValue());
            }
            catch (NumberFormatException | SyntaxException ignore2) {
                return Values.NO_VALUE;
            }
        }
    }

    public static Value parseAsLongOrElseNoValue(String expression) {
        try {
            return Values.longValue((long)Long.parseLong(expression));
        }
        catch (NumberFormatException ignore1) {
            try {
                BigDecimal bigDecimal = new BigDecimal(expression);
                if (bigDecimal.compareTo(MAX_LONG) <= 0 && bigDecimal.compareTo(MIN_LONG) >= 0) {
                    return Values.longValue((long)bigDecimal.longValue());
                }
                throw new CypherTypeException(String.format("integer, %s, is too large", expression));
            }
            catch (NumberFormatException ignore2) {
                try {
                    return Values.longValue((long)CypherRuntimeParser.parser(expression).numberLiteral().value().longValue());
                }
                catch (NumberFormatException | SyntaxException ignore3) {
                    return Values.NO_VALUE;
                }
            }
        }
    }

    private static Seq<Expression> asList(String stringList) {
        Expression expression = CypherRuntimeParser.parser(stringList).expression();
        if (expression instanceof ListLiteral) {
            ListLiteral listLiteral = (ListLiteral)expression;
            return listLiteral.expressions();
        }
        if (expression instanceof Literal) {
            Literal literal = (Literal)expression;
            throw VectorUtils.invalidVectorType(ValueUtils.of((Object)literal.value()));
        }
        throw CypherRuntimeParser.invalidVectorType(expression);
    }

    private static byte asByte(Expression expression) {
        return CypherRuntimeParser.asNumber(expression).byteValue();
    }

    private static short asShort(Expression expression) {
        return CypherRuntimeParser.asNumber(expression).shortValue();
    }

    private static int asInt(Expression expression) {
        return CypherRuntimeParser.asNumber(expression).intValue();
    }

    private static long asLong(Expression expression) {
        return CypherRuntimeParser.asNumber(expression).longValue();
    }

    private static Number asNumber(Expression expression) {
        if (expression instanceof NumberLiteral) {
            NumberLiteral numberLiteral = (NumberLiteral)expression;
            return numberLiteral.value();
        }
        if (expression instanceof Literal) {
            Literal literal = (Literal)expression;
            throw VectorUtils.invalidVectorType(ValueUtils.of((Object)literal.value()));
        }
        throw CypherRuntimeParser.invalidVectorType(expression);
    }

    private static AstParser parser(String expression) {
        return parserFactory.apply(expression, (CypherExceptionFactory)new Neo4jCypherExceptionFactory(expression, Option.empty()), Option.empty());
    }

    private static CypherTypeException invalidVectorType(Expression badInput) {
        return CypherTypeException.functionArgumentWrongType((String)("Invalid input for function 'vector': Expected a NUMBER, got: " + badInput.asCanonicalStringVal()), (String)"vector", (String)badInput.asCanonicalStringVal(), List.of("INTEGER", "FLOAT"), (String)"ANY");
    }
}

