/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.profiling;

import java.util.Arrays;
import org.neo4j.cypher.result.OperatorProfile;

public class ProfilingTracerData
implements OperatorProfile {
    private long time;
    private long dbHits;
    private long rows;
    private long pageCacheHits;
    private long pageCacheMisses;
    private long maxAllocatedMemory;

    public void update(long time, long dbHits, long rows, long pageCacheHits, long pageCacheMisses, long maxAllocatedMemory) {
        this.time += time;
        this.dbHits += dbHits;
        this.rows += rows;
        this.pageCacheHits += pageCacheHits;
        this.pageCacheMisses += pageCacheMisses;
        this.maxAllocatedMemory += maxAllocatedMemory;
    }

    @Override
    public long time() {
        return this.time;
    }

    @Override
    public long dbHits() {
        return this.dbHits;
    }

    @Override
    public long rows() {
        return this.rows;
    }

    @Override
    public long pageCacheHits() {
        return this.pageCacheHits;
    }

    @Override
    public long pageCacheMisses() {
        return this.pageCacheMisses;
    }

    @Override
    public long maxAllocatedMemory() {
        return this.maxAllocatedMemory;
    }

    public void sanitize() {
        if (this.time < -1L) {
            this.time = -1L;
        }
        if (this.dbHits < -1L) {
            this.dbHits = -1L;
        }
        if (this.rows < -1L) {
            this.rows = -1L;
        }
        if (this.pageCacheHits < -1L) {
            this.pageCacheHits = -1L;
        }
        if (this.pageCacheMisses < -1L) {
            this.pageCacheMisses = -1L;
        }
        if (this.maxAllocatedMemory < -1L) {
            this.maxAllocatedMemory = -1L;
        }
    }

    public int hashCode() {
        return Arrays.hashCode(new long[]{this.time(), this.dbHits(), this.rows(), this.pageCacheHits(), this.pageCacheMisses(), this.maxAllocatedMemory()});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OperatorProfile)) {
            return false;
        }
        OperatorProfile that = (OperatorProfile)o;
        return this.time() == that.time() && this.dbHits() == that.dbHits() && this.rows() == that.rows() && this.pageCacheHits() == that.pageCacheHits() && this.pageCacheMisses() == that.pageCacheMisses() && this.maxAllocatedMemory() == that.maxAllocatedMemory();
    }

    public String toString() {
        return String.format("Operator Profile { time: %d, dbHits: %d, rows: %d, page cache hits: %d, page cache misses: %d, max allocated: %d }", this.time(), this.dbHits(), this.rows(), this.pageCacheHits(), this.pageCacheMisses(), this.maxAllocatedMemory());
    }
}

