/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.semantics.SemanticTable;
import org.neo4j.cypher.internal.compiler.helpers.MapSupport$;
import org.neo4j.cypher.internal.compiler.planner.ProcedureCallProjection;
import org.neo4j.cypher.internal.compiler.planner.logical.ExpressionEvaluator;
import org.neo4j.cypher.internal.compiler.planner.logical.Metrics;
import org.neo4j.cypher.internal.compiler.planner.logical.PlannerDefaults$;
import org.neo4j.cypher.internal.compiler.planner.logical.StatisticsBackedCardinalityModel$;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.index.IndexCompatiblePredicatesProviderContext;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.FunctionInvocation;
import org.neo4j.cypher.internal.expressions.IntegerLiteral;
import org.neo4j.cypher.internal.expressions.LabelName;
import org.neo4j.cypher.internal.expressions.ListLiteral;
import org.neo4j.cypher.internal.expressions.RelTypeName;
import org.neo4j.cypher.internal.ir.AggregatingQueryProjection;
import org.neo4j.cypher.internal.ir.CallSubqueryHorizon;
import org.neo4j.cypher.internal.ir.CommandProjection;
import org.neo4j.cypher.internal.ir.DistinctQueryProjection;
import org.neo4j.cypher.internal.ir.LoadCSVProjection;
import org.neo4j.cypher.internal.ir.PassthroughAllHorizon;
import org.neo4j.cypher.internal.ir.PlannerQuery;
import org.neo4j.cypher.internal.ir.QueryGraph;
import org.neo4j.cypher.internal.ir.QueryHorizon;
import org.neo4j.cypher.internal.ir.QueryPagination;
import org.neo4j.cypher.internal.ir.QueryProjection;
import org.neo4j.cypher.internal.ir.RegularQueryProjection;
import org.neo4j.cypher.internal.ir.Selections;
import org.neo4j.cypher.internal.ir.SinglePlannerQuery;
import org.neo4j.cypher.internal.ir.UnionQuery;
import org.neo4j.cypher.internal.ir.UnwindProjection;
import org.neo4j.cypher.internal.util.Cardinality;
import org.neo4j.cypher.internal.util.Cardinality$;
import org.neo4j.cypher.internal.util.Multiplier;
import org.neo4j.cypher.internal.util.Selectivity;
import org.neo4j.values.storable.NumberValue;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r\rc\u0001B\u00193\u0001\u0005C\u0001\u0002\u0019\u0001\u0003\u0002\u0003\u0006I!\u0019\u0005\tI\u0002\u0011\t\u0011)A\u0005K\"A\u0001\u000e\u0001B\u0001B\u0003%\u0011\u000eC\u0003n\u0001\u0011\u0005a\u000eC\u0003t\u0001\u0011\u0005C\u000fC\u0004\u0002H\u0001!\t!!\u0013\t\u000f\u0005u\u0003\u0001\"\u0001\u0002`!9\u00111\u000f\u0001\u0005\n\u0005U\u0004b\u0002Bl\u0001\u0011%!\u0011\u001c\u0005\b\u0005O\u0004A\u0011\u0002Bu\u0011\u001d\u0011I\u0010\u0001C\u0005\u0005wDqaa\u0001\u0001\t\u0013\u0019)\u0001C\u0004\u0004\u0014\u0001!Ia!\u0006\t\u000f\r-\u0002\u0001\"\u0003\u0004.\u001d9\u00111\u0010\u001a\t\u0002\u0005udAB\u00193\u0011\u0003\ty\b\u0003\u0004n!\u0011\u0005\u0011\u0011\u0011\u0004\u0007\u0003\u0007\u0003\u0002)!\"\t\u0015\u0005}%C!f\u0001\n\u0003\t\t\u000bC\u0005\u0002$J\u0011\t\u0012)A\u0005k\"Q\u0011\u0011\u0002\n\u0003\u0016\u0004%\t!!*\t\u0015\u0005\u001d&C!E!\u0002\u0013\tY\u0001\u0003\u0006\u0002\u0014I\u0011)\u001a!C\u0001\u0003SC!\"a+\u0013\u0005#\u0005\u000b\u0011BA\u000b\u0011\u0019i'\u0003\"\u0001\u0002.\"9\u0011\u0011\u0018\n\u0005\u0002\u0005m\u0006bBAa%\u0011\u0005\u00111\u0019\u0005\n\u0003\u0013\u0014\u0012\u0011!C\u0001\u0003\u0017D\u0011\"a5\u0013#\u0003%\t!!6\t\u0013\u0005-(#%A\u0005\u0002\u00055\b\"CAy%E\u0005I\u0011AAz\u0011%\t9PEA\u0001\n\u0003\nI\u0010C\u0005\u0003\fI\t\t\u0011\"\u0001\u0003\u000e!I!Q\u0003\n\u0002\u0002\u0013\u0005!q\u0003\u0005\n\u0005G\u0011\u0012\u0011!C!\u0005KA\u0011Ba\r\u0013\u0003\u0003%\tA!\u000e\t\u0013\t}\"#!A\u0005B\t\u0005\u0003\"\u0003B#%\u0005\u0005I\u0011\tB$\u0011%\u0011IEEA\u0001\n\u0003\u0012Y\u0005C\u0005\u0003NI\t\t\u0011\"\u0011\u0003P\u001dI!1\u000b\t\u0002\u0002#\u0005!Q\u000b\u0004\n\u0003\u0007\u0003\u0012\u0011!E\u0001\u0005/Ba!\u001c\u0016\u0005\u0002\t=\u0004\"\u0003B%U\u0005\u0005IQ\tB&\u0011!\u0019(&!A\u0005\u0002\nE\u0004\"\u0003B=U\u0005\u0005I\u0011\u0011B>\u0011%\u0011iIKA\u0001\n\u0013\u0011y\tC\u0004\u0003\u0018B!\tA!'\u0003AM#\u0018\r^5ti&\u001c7OQ1dW\u0016$7)\u0019:eS:\fG.\u001b;z\u001b>$W\r\u001c\u0006\u0003gQ\nq\u0001\\8hS\u000e\fGN\u0003\u00026m\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u001c9\u0003!\u0019w.\u001c9jY\u0016\u0014(BA\u001d;\u0003!Ig\u000e^3s]\u0006d'BA\u001e=\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011QHP\u0001\u0006]\u0016|GG\u001b\u0006\u0002\u007f\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0011%\u0011\u0005\r3U\"\u0001#\u000b\u0003\u0015\u000bQa]2bY\u0006L!a\u0012#\u0003\r\u0005s\u0017PU3g!\tIUL\u0004\u0002K7:\u00111J\u0017\b\u0003\u0019fs!!\u0014-\u000f\u00059;fBA(W\u001d\t\u0001VK\u0004\u0002R)6\t!K\u0003\u0002T\u0001\u00061AH]8pizJ\u0011aP\u0005\u0003{yJ!a\u000f\u001f\n\u0005eR\u0014BA\u001c9\u0013\t)d'\u0003\u00024i%\u0011ALM\u0001\b\u001b\u0016$(/[2t\u0013\tqvL\u0001\tDCJ$\u0017N\\1mSRLXj\u001c3fY*\u0011ALM\u0001\u001bcV,'/_$sCBD7)\u0019:eS:\fG.\u001b;z\u001b>$W\r\u001c\t\u0003\u0013\nL!aY0\u00035E+XM]=He\u0006\u0004\bnQ1sI&t\u0017\r\\5us6{G-\u001a7\u0002+M,G.Z2uSZLG/_\"bY\u000e,H.\u0019;peB\u0011\u0011JZ\u0005\u0003O~\u0013QcU3mK\u000e$\u0018N^5us\u000e\u000bGnY;mCR|'/A\rtS6\u0004H.Z#yaJ,7o]5p]\u00163\u0018\r\\;bi>\u0014\bC\u00016l\u001b\u0005\u0011\u0014B\u000173\u0005M)\u0005\u0010\u001d:fgNLwN\\#wC2,\u0018\r^8s\u0003\u0019a\u0014N\\5u}Q!q\u000e]9s!\tQ\u0007\u0001C\u0003a\t\u0001\u0007\u0011\rC\u0003e\t\u0001\u0007Q\rC\u0003i\t\u0001\u0007\u0011.A\u0003baBd\u0017\u0010\u0006\u0007vw\u0006\u001d\u0011\u0011CA\u000e\u0003_\t\u0019\u0005\u0005\u0002ws6\tqO\u0003\u0002yq\u0005!Q\u000f^5m\u0013\tQxOA\u0006DCJ$\u0017N\\1mSRL\b\"\u0002?\u0006\u0001\u0004i\u0018!B9vKJL\bc\u0001@\u0002\u00045\tqPC\u0002\u0002\u0002a\n!!\u001b:\n\u0007\u0005\u0015qP\u0001\u0007QY\u0006tg.\u001a:Rk\u0016\u0014\u0018\u0010C\u0004\u0002\n\u0015\u0001\r!a\u0003\u0002\u00131\f'-\u001a7J]\u001a|\u0007cA%\u0002\u000e%\u0019\u0011qB0\u0003\u00131\u000b'-\u001a7J]\u001a|\u0007bBA\n\u000b\u0001\u0007\u0011QC\u0001\fe\u0016dG+\u001f9f\u0013:4w\u000eE\u0002J\u0003/I1!!\u0007`\u0005-\u0011V\r\u001c+za\u0016LeNZ8\t\u000f\u0005uQ\u00011\u0001\u0002 \u0005i1/Z7b]RL7\rV1cY\u0016\u0004B!!\t\u0002,5\u0011\u00111\u0005\u0006\u0005\u0003K\t9#A\u0005tK6\fg\u000e^5dg*\u0019\u0011\u0011\u0006\u001d\u0002\u0007\u0005\u001cH/\u0003\u0003\u0002.\u0005\r\"!D*f[\u0006tG/[2UC\ndW\rC\u0004\u00022\u0015\u0001\r!a\r\u0002;%tG-\u001a=Qe\u0016$\u0017nY1uKB\u0013xN^5eKJ\u001cuN\u001c;fqR\u0004B!!\u000e\u0002@5\u0011\u0011q\u0007\u0006\u0005\u0003s\tY$A\u0003j]\u0012,\u0007PC\u0002\u0002>I\nQa\u001d;faNLA!!\u0011\u00028\tA\u0013J\u001c3fq\u000e{W\u000e]1uS\ndW\r\u0015:fI&\u001c\u0017\r^3t!J|g/\u001b3fe\u000e{g\u000e^3yi\"1\u0011QI\u0003A\u0002!\u000b\u0001cY1sI&t\u0017\r\\5us6{G-\u001a7\u0002;MLgn\u001a7f!2\fgN\\3s#V,'/_\"be\u0012Lg.\u00197jif$R\"^A&\u0003'\n)&a\u0016\u0002Z\u0005m\u0003B\u0002?\u0007\u0001\u0004\ti\u0005E\u0002\u007f\u0003\u001fJ1!!\u0015\u0000\u0005I\u0019\u0016N\\4mKBc\u0017M\u001c8feF+XM]=\t\u000f\u0005%a\u00011\u0001\u0002\f!9\u00111\u0003\u0004A\u0002\u0005U\u0001bBA\u000f\r\u0001\u0007\u0011q\u0004\u0005\b\u0003c1\u0001\u0019AA\u001a\u0011\u0019\t)E\u0002a\u0001\u0011\u0006a1m\\7cS:,WK\\5p]R9Q/!\u0019\u0002l\u0005=\u0004bBA2\u000f\u0001\u0007\u0011QM\u0001\u000bk:LwN\\)vKJL\bc\u0001@\u0002h%\u0019\u0011\u0011N@\u0003\u0015Us\u0017n\u001c8Rk\u0016\u0014\u0018\u0010\u0003\u0004\u0002n\u001d\u0001\r!^\u0001\u000fY\"\u001c8)\u0019:eS:\fG.\u001b;z\u0011\u0019\t\th\u0002a\u0001k\u0006q!\u000f[:DCJ$\u0017N\\1mSRL\u0018aI2bY\u000e,H.\u0019;f\u0007\u0006\u0014H-\u001b8bY&$\u0018PR8s#V,'/\u001f%pe&TxN\u001c\u000b\r\u0003o\u0012\u0019Ma2\u0003R\nM'Q\u001b\t\u0004\u0003s\u0012bB\u0001&\u0010\u0003\u0001\u001aF/\u0019;jgRL7m\u001d\"bG.,GmQ1sI&t\u0017\r\\5us6{G-\u001a7\u0011\u0005)\u00042C\u0001\tC)\t\tiHA\nDCJ$\u0017N\\1mSRL\u0018I\u001c3J]B,Ho\u0005\u0004\u0013\u0005\u0006\u001d\u0015Q\u0012\t\u0004\u0007\u0006%\u0015bAAF\t\n9\u0001K]8ek\u000e$\b\u0003BAH\u00033sA!!%\u0002\u0016:\u0019\u0011+a%\n\u0003\u0015K1!a&E\u0003\u001d\u0001\u0018mY6bO\u0016LA!a'\u0002\u001e\na1+\u001a:jC2L'0\u00192mK*\u0019\u0011q\u0013#\u0002\u0017\r\f'\u000fZ5oC2LG/_\u000b\u0002k\u0006a1-\u0019:eS:\fG.\u001b;zAU\u0011\u00111B\u0001\u000bY\u0006\u0014W\r\\%oM>\u0004SCAA\u000b\u00031\u0011X\r\u001c+za\u0016LeNZ8!)!\ty+a-\u00026\u0006]\u0006cAAY%5\t\u0001\u0003\u0003\u0004\u0002 f\u0001\r!\u001e\u0005\b\u0003\u0013I\u0002\u0019AA\u0006\u0011\u001d\t\u0019\"\u0007a\u0001\u0003+\t!c^5uQ\u001a+8/\u001a3MC\n,G.\u00138g_R!\u0011qVA_\u0011\u001d\tyL\u0007a\u0001\u0003\u0017\tAB\\3x\u0019\u0006\u0014W\r\\%oM>\fAc^5uQ\u001a+8/\u001a3SK2$\u0016\u0010]3J]\u001a|G\u0003BAX\u0003\u000bDq!a2\u001c\u0001\u0004\t)\"\u0001\boK^\u0014V\r\u001c+za\u0016LeNZ8\u0002\t\r|\u0007/\u001f\u000b\t\u0003_\u000bi-a4\u0002R\"A\u0011q\u0014\u000f\u0011\u0002\u0003\u0007Q\u000fC\u0005\u0002\nq\u0001\n\u00111\u0001\u0002\f!I\u00111\u0003\u000f\u0011\u0002\u0003\u0007\u0011QC\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t9NK\u0002v\u00033\\#!a7\u0011\t\u0005u\u0017q]\u0007\u0003\u0003?TA!!9\u0002d\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003K$\u0015AC1o]>$\u0018\r^5p]&!\u0011\u0011^Ap\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tyO\u000b\u0003\u0002\f\u0005e\u0017AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003kTC!!\u0006\u0002Z\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a?\u0011\t\u0005u(qA\u0007\u0003\u0003\u007fTAA!\u0001\u0003\u0004\u0005!A.\u00198h\u0015\t\u0011)!\u0001\u0003kCZ\f\u0017\u0002\u0002B\u0005\u0003\u007f\u0014aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001B\b!\r\u0019%\u0011C\u0005\u0004\u0005'!%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B\r\u0005?\u00012a\u0011B\u000e\u0013\r\u0011i\u0002\u0012\u0002\u0004\u0003:L\b\"\u0003B\u0011E\u0005\u0005\t\u0019\u0001B\b\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!q\u0005\t\u0007\u0005S\u0011yC!\u0007\u000e\u0005\t-\"b\u0001B\u0017\t\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\tE\"1\u0006\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u00038\tu\u0002cA\"\u0003:%\u0019!1\b#\u0003\u000f\t{w\u000e\\3b]\"I!\u0011\u0005\u0013\u0002\u0002\u0003\u0007!\u0011D\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002|\n\r\u0003\"\u0003B\u0011K\u0005\u0005\t\u0019\u0001B\b\u0003!A\u0017m\u001d5D_\u0012,GC\u0001B\b\u0003!!xn\u0015;sS:<GCAA~\u0003\u0019)\u0017/^1mgR!!q\u0007B)\u0011%\u0011\t\u0003KA\u0001\u0002\u0004\u0011I\"A\nDCJ$\u0017N\\1mSRL\u0018I\u001c3J]B,H\u000fE\u0002\u00022*\u001aRA\u000bB-\u0005K\u00022Ba\u0017\u0003bU\fY!!\u0006\u000206\u0011!Q\f\u0006\u0004\u0005?\"\u0015a\u0002:v]RLW.Z\u0005\u0005\u0005G\u0012iFA\tBEN$(/Y2u\rVt7\r^5p]N\u0002BAa\u001a\u0003n5\u0011!\u0011\u000e\u0006\u0005\u0005W\u0012\u0019!\u0001\u0002j_&!\u00111\u0014B5)\t\u0011)\u0006\u0006\u0005\u00020\nM$Q\u000fB<\u0011\u0019\ty*\fa\u0001k\"9\u0011\u0011B\u0017A\u0002\u0005-\u0001bBA\n[\u0001\u0007\u0011QC\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011iH!#\u0011\u000b\r\u0013yHa!\n\u0007\t\u0005EI\u0001\u0004PaRLwN\u001c\t\t\u0007\n\u0015U/a\u0003\u0002\u0016%\u0019!q\u0011#\u0003\rQ+\b\u000f\\34\u0011%\u0011YILA\u0001\u0002\u0004\ty+A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"A!%\u0011\t\u0005u(1S\u0005\u0005\u0005+\u000byP\u0001\u0004PE*,7\r^\u0001\u001fC\u001e<'/Z4bi\u0016\u001c\u0015M\u001d3j]\u0006d\u0017\u000e^=FgRLW.\u0019;j_:$R!\u001eBN\u0005?CaA!(1\u0001\u0004)\u0018AA5o\u0011\u001d\u0011\t\u000b\ra\u0001\u0005G\u000b1c\u001a:pkBLgnZ#yaJ,7o]5p]N\u0004\u0002B!*\u0003.\nM&q\u0017\b\u0005\u0005O\u0013I\u000b\u0005\u0002R\t&\u0019!1\u0016#\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011yK!-\u0003\u00075\u000b\u0007OC\u0002\u0003,\u0012\u0003BA!*\u00036&!!\u0011\u0002BY!\u0011\u0011ILa0\u000e\u0005\tm&b\u0001B_q\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\u0011\u0011\tMa/\u0003\u0015\u0015C\bO]3tg&|g\u000eC\u0004\u0003F\"\u0001\r!a\u001e\u0002'\r\f'\u000fZ5oC2LG/_!oI&s\u0007/\u001e;\t\u000f\t%\u0007\u00021\u0001\u0003L\u00069\u0001n\u001c:ju>t\u0007c\u0001@\u0003N&\u0019!qZ@\u0003\u0019E+XM]=I_JL'p\u001c8\t\u000f\u0005u\u0001\u00021\u0001\u0002 !9\u0011\u0011\u0007\u0005A\u0002\u0005M\u0002BBA#\u0011\u0001\u0007\u0001*A\u0013rk\u0016\u0014\u0018\u0010\u0015:pU\u0016\u001cG/[8o\u0007\u0006\u0014H-\u001b8bY&$\u0018PQ3g_J,G*[7jiR)QOa7\u0003^\"1!QT\u0005A\u0002UDqAa8\n\u0001\u0004\u0011\t/\u0001\u0006qe>TWm\u0019;j_:\u00042A Br\u0013\r\u0011)o \u0002\u0010#V,'/\u001f)s_*,7\r^5p]\u0006\u0019\u0013/^3ssB\u0013xN[3di&|gnQ1sI&t\u0017\r\\5us^KG\u000f\u001b'j[&$H#B;\u0003l\n=\bB\u0002Bw\u0015\u0001\u0007Q/\u0001\fdCJ$\u0017N\\1mSRL()\u001a4pe\u0016d\u0015.\\5u\u0011\u001d\u0011\tP\u0003a\u0001\u0005g\fq\"];fef\u0004\u0016mZ5oCRLwN\u001c\t\u0004}\nU\u0018b\u0001B|\u007f\ny\u0011+^3ssB\u000bw-\u001b8bi&|g.\u0001\u0012rk\u0016\u0014\u0018\u0010\u0015:pU\u0016\u001cG/[8o\u0007\u0006\u0014H-\u001b8bY&$\u0018pV5uQN[\u0017\u000e\u001d\u000b\u0006k\nu8\u0011\u0001\u0005\u0007\u0005\u007f\\\u0001\u0019A;\u0002+\r\f'\u000fZ5oC2LG/\u001f\"fM>\u0014XmU6ja\"9!\u0011_\u0006A\u0002\tM\u0018\u0001F3wC2,\u0018\r^3M_:<\u0017JZ*uC\ndW\r\u0006\u0003\u0004\b\r=\u0001#B\"\u0003\u0000\r%\u0001cA\"\u0004\f%\u00191Q\u0002#\u0003\t1{gn\u001a\u0005\b\u0007#a\u0001\u0019\u0001B\\\u0003))\u0007\u0010\u001d:fgNLwN\\\u0001)cV,'/\u001f)s_*,7\r^5p]\u000e\u000b'\u000fZ5oC2LG/_,ji\"\u001cV\r\\3di&|gn\u001d\u000b\r\u0003o\u001a9ba\u0007\u0004&\r\u001d2\u0011\u0006\u0005\b\u00073i\u0001\u0019AA<\u0003QIg\u000e];u\u0005\u00164wN]3TK2,7\r^5p]\"91QD\u0007A\u0002\r}\u0011!B<iKJ,\u0007c\u0001@\u0004\"%\u001911E@\u0003\u0015M+G.Z2uS>t7\u000fC\u0004\u0002\u001e5\u0001\r!a\b\t\u000f\u0005ER\u00021\u0001\u00024!1\u0011QI\u0007A\u0002!\u000b\u0011eY1mGVd\u0017\r^3DCJ$\u0017N\\1mSRLhi\u001c:Rk\u0016\u0014\u0018p\u0012:ba\"$b\"a\u001e\u00040\re21HB\u001f\u0007\u007f\u0019\t\u0005C\u0004\u000429\u0001\raa\r\u0002\u000b\u001d\u0014\u0018\r\u001d5\u0011\u0007y\u001c)$C\u0002\u00048}\u0014!\"U;fef<%/\u00199i\u0011\u001d\tIA\u0004a\u0001\u0003\u0017Aq!a\u0005\u000f\u0001\u0004\t)\u0002C\u0004\u0002\u001e9\u0001\r!a\b\t\u000f\u0005Eb\u00021\u0001\u00024!1\u0011Q\t\bA\u0002!\u0003")
public class StatisticsBackedCardinalityModel
implements Metrics.CardinalityModel {
    private final Metrics.QueryGraphCardinalityModel queryGraphCardinalityModel;
    private final Metrics.SelectivityCalculator selectivityCalculator;
    private final ExpressionEvaluator simpleExpressionEvaluator;

    public static Cardinality aggregateCardinalityEstimation(Cardinality in, Map<String, Expression> groupingExpressions) {
        return StatisticsBackedCardinalityModel$.MODULE$.aggregateCardinalityEstimation(in, groupingExpressions);
    }

    @Override
    public final Cardinality apply(PlannerQuery plannerQuery, Map<String, Set<LabelName>> labelInfo, Map<String, RelTypeName> relTypeInfo, SemanticTable semanticTable, IndexCompatiblePredicatesProviderContext indexCompatiblePredicatesProviderContext) {
        return Metrics.CardinalityModel.apply$(this, plannerQuery, labelInfo, relTypeInfo, semanticTable, indexCompatiblePredicatesProviderContext);
    }

    @Override
    public Cardinality apply(PlannerQuery query, Map<String, Set<LabelName>> labelInfo, Map<String, RelTypeName> relTypeInfo, SemanticTable semanticTable, IndexCompatiblePredicatesProviderContext indexPredicateProviderContext, Metrics.CardinalityModel cardinalityModel) {
        PlannerQuery plannerQuery = query;
        if (plannerQuery instanceof SinglePlannerQuery) {
            SinglePlannerQuery singlePlannerQuery = (SinglePlannerQuery)plannerQuery;
            return this.singlePlannerQueryCardinality(singlePlannerQuery, labelInfo, relTypeInfo, semanticTable, indexPredicateProviderContext, cardinalityModel);
        }
        if (plannerQuery instanceof UnionQuery) {
            UnionQuery unionQuery = (UnionQuery)plannerQuery;
            PlannerQuery lhs = unionQuery.lhs();
            SinglePlannerQuery rhs = unionQuery.rhs();
            return this.combineUnion(unionQuery, this.apply(lhs, labelInfo, relTypeInfo, semanticTable, indexPredicateProviderContext, cardinalityModel), this.apply((PlannerQuery)rhs, labelInfo, relTypeInfo, semanticTable, indexPredicateProviderContext, cardinalityModel));
        }
        throw new MatchError((Object)plannerQuery);
    }

    public Cardinality singlePlannerQueryCardinality(SinglePlannerQuery query, Map<String, Set<LabelName>> labelInfo, Map<String, RelTypeName> relTypeInfo, SemanticTable semanticTable, IndexCompatiblePredicatesProviderContext indexPredicateProviderContext, Metrics.CardinalityModel cardinalityModel) {
        CardinalityAndInput output = (CardinalityAndInput)query.fold((Object)new CardinalityAndInput(Cardinality$.MODULE$.SINGLE(), labelInfo, relTypeInfo), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                CardinalityAndInput cardinalityAndInput = (CardinalityAndInput)tuple2._1();
                SinglePlannerQuery plannerQuery = (SinglePlannerQuery)tuple2._2();
                if (cardinalityAndInput != null) {
                    Cardinality inboundCardinality = cardinalityAndInput.cardinality();
                    Map<String, Set<LabelName>> labelInfo = cardinalityAndInput.labelInfo();
                    Map<String, RelTypeName> relTypeInfo = cardinalityAndInput.relTypeInfo();
                    CardinalityAndInput cardinalityAndInput2 = this.calculateCardinalityForQueryGraph(plannerQuery.queryGraph(), labelInfo, relTypeInfo, semanticTable, indexPredicateProviderContext, cardinalityModel);
                    if (cardinalityAndInput2 == null) {
                        throw new MatchError((Object)cardinalityAndInput2);
                    }
                    Cardinality qgCardinality = cardinalityAndInput2.cardinality();
                    Map<String, Set<LabelName>> labelInfoAfterQG = cardinalityAndInput2.labelInfo();
                    Map<String, RelTypeName> relTypeInfoAfterQG = cardinalityAndInput2.relTypeInfo();
                    Tuple3 tuple3 = new Tuple3((Object)qgCardinality, labelInfoAfterQG, relTypeInfoAfterQG);
                    Cardinality qgCardinality2 = (Cardinality)tuple3._1();
                    Map labelInfoAfterQG2 = (Map)tuple3._2();
                    Map relTypeInfoAfterQG2 = (Map)tuple3._3();
                    Cardinality beforeHorizonCardinality = qgCardinality2.$times(inboundCardinality);
                    CardinalityAndInput afterHorizon = this.calculateCardinalityForQueryHorizon(new CardinalityAndInput(beforeHorizonCardinality, (Map<String, Set<LabelName>>)labelInfoAfterQG2, (Map<String, RelTypeName>)relTypeInfoAfterQG2), plannerQuery.horizon(), semanticTable, indexPredicateProviderContext, cardinalityModel);
                    return afterHorizon.withFusedLabelInfo((Map<String, Set<LabelName>>)plannerQuery.firstLabelInfo());
                }
            }
            throw new MatchError((Object)tuple2);
        });
        return output.cardinality();
    }

    public Cardinality combineUnion(UnionQuery unionQuery, Cardinality lhsCardinality, Cardinality rhsCardinality) {
        Cardinality unionCardinality = lhsCardinality.$plus(rhsCardinality);
        if (unionQuery.distinct()) {
            return unionCardinality.$times(PlannerDefaults$.MODULE$.DEFAULT_DISTINCT_SELECTIVITY());
        }
        return unionCardinality;
    }

    /*
     * Unable to fully structure code
     */
    private CardinalityAndInput calculateCardinalityForQueryHorizon(CardinalityAndInput cardinalityAndInput, QueryHorizon horizon, SemanticTable semanticTable, IndexCompatiblePredicatesProviderContext indexPredicateProviderContext, Metrics.CardinalityModel cardinalityModel) {
        block10: {
            block12: {
                block13: {
                    block11: {
                        var8_6 = false;
                        var9_7 = null;
                        var10_8 = horizon;
                        if (var10_8 instanceof QueryProjection) {
                            var11_9 = (QueryProjection)var10_8;
                            cardinalityBeforeSkip = this.queryProjectionCardinalityBeforeLimit(cardinalityAndInput.cardinality(), var11_9);
                            cardinalityBeforeLimit = this.queryProjectionCardinalityWithSkip(cardinalityBeforeSkip, var11_9.queryPagination());
                            cardinalityBeforeSelection = this.queryProjectionCardinalityWithLimit(cardinalityBeforeLimit, var11_9.queryPagination());
                            return this.queryProjectionCardinalityWithSelections(new CardinalityAndInput(cardinalityBeforeSelection, cardinalityAndInput.labelInfo(), cardinalityAndInput.relTypeInfo()), var11_9.selections(), semanticTable, indexPredicateProviderContext, cardinalityModel);
                        }
                        if (!(var10_8 instanceof UnwindProjection)) break block10;
                        var15_13 = (UnwindProjection)var10_8;
                        expression = var15_13.exp();
                        var18_15 = false;
                        var19_16 = null;
                        var20_17 = expression;
                        if (!(var20_17 instanceof ListLiteral)) break block11;
                        var21_18 = (ListLiteral)var20_17;
                        expressions = var21_18.expressions();
                        v0 = new Multiplier((double)expressions.size());
                        break block12;
                    }
                    if (!(var20_17 instanceof FunctionInvocation)) break block13;
                    var18_15 = true;
                    var19_16 = (FunctionInvocation)var20_17;
                    var23_20 = var19_16.namespace();
                    var24_21 = var19_16.functionName();
                    var25_22 = var19_16.args();
                    if (var23_20 == null || (var26_23 = var23_20.parts()) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(var27_24 = package$.MODULE$.Seq().unapplySeq((SeqOps)var26_23)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var27_24)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var27_24), 0) != 0 || var24_21 == null || !"range".equals(var28_25 = var24_21.name()) || var25_22 == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(var29_26 = package$.MODULE$.Seq().unapplySeq((SeqOps)var25_22)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var29_26)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var29_26), 2) != 0) break block13;
                    from = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var29_26), 0);
                    to = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var29_26), 1);
                    if (!(from instanceof IntegerLiteral)) break block13;
                    var32_29 = (IntegerLiteral)from;
                    if (!(to instanceof IntegerLiteral)) break block13;
                    var33_30 = (IntegerLiteral)to;
                    diff = Predef$.MODULE$.Long2long(var33_30.value()) - Predef$.MODULE$.Long2long(var32_29.value()) + 1L;
                    v0 = new Multiplier((double)Math.max(0L, diff));
                    break block12;
                }
                if (!var18_15) ** GOTO lbl-1000
                var36_32 = var19_16.namespace();
                var37_33 = var19_16.functionName();
                var38_34 = var19_16.args();
                if (var36_32 == null || (var39_35 = var36_32.parts()) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(var40_36 = package$.MODULE$.Seq().unapplySeq((SeqOps)var39_35)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var40_36)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var40_36), 0) != 0 || var37_33 == null || !"range".equals(var41_37 = var37_33.name()) || var38_34 == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(var42_38 = package$.MODULE$.Seq().unapplySeq((SeqOps)var38_34)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var42_38)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var42_38), 3) != 0) ** GOTO lbl-1000
                from = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var42_38), 0);
                to = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var42_38), 1);
                step = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var42_38), 2);
                if (!(from instanceof IntegerLiteral)) ** GOTO lbl-1000
                var46_42 = (IntegerLiteral)from;
                if (!(to instanceof IntegerLiteral)) ** GOTO lbl-1000
                var47_43 = (IntegerLiteral)to;
                if (step instanceof IntegerLiteral) {
                    var48_44 = (IntegerLiteral)step;
                    diff = Predef$.MODULE$.Long2long(var47_43.value()) - Predef$.MODULE$.Long2long(var46_42.value());
                    steps = diff / Predef$.MODULE$.Long2long(var48_44.value()) + 1L;
                    v0 = new Multiplier((double)Math.max(0L, steps));
                } else lbl-1000:
                // 5 sources

                {
                    v0 = PlannerDefaults$.MODULE$.DEFAULT_MULTIPLIER();
                }
            }
            multiplier = v0;
            return cardinalityAndInput.copy(cardinalityAndInput.cardinality().$times(multiplier), cardinalityAndInput.copy$default$2(), cardinalityAndInput.copy$default$3());
        }
        if (var10_8 instanceof ProcedureCallProjection) {
            return cardinalityAndInput.copy(Cardinality$.MODULE$.max(cardinalityAndInput.cardinality().$times(PlannerDefaults$.MODULE$.DEFAULT_MULTIPLIER()), Cardinality$.MODULE$.lift(1.0)), cardinalityAndInput.copy$default$2(), cardinalityAndInput.copy$default$3());
        }
        if (var10_8 instanceof CommandProjection) {
            return cardinalityAndInput.copy(Cardinality$.MODULE$.max(cardinalityAndInput.cardinality().$times(PlannerDefaults$.MODULE$.DEFAULT_MULTIPLIER()), Cardinality$.MODULE$.lift(1.0)), cardinalityAndInput.copy$default$2(), cardinalityAndInput.copy$default$3());
        }
        if (var10_8 instanceof LoadCSVProjection) {
            return cardinalityAndInput.copy(Cardinality$.MODULE$.max(cardinalityAndInput.cardinality().$times(PlannerDefaults$.MODULE$.DEFAULT_MULTIPLIER()), Cardinality$.MODULE$.lift(1.0)), cardinalityAndInput.copy$default$2(), cardinalityAndInput.copy$default$3());
        }
        if (var10_8 instanceof PassthroughAllHorizon) {
            return cardinalityAndInput;
        }
        if (var10_8 instanceof CallSubqueryHorizon) {
            var8_6 = true;
            var9_7 = (CallSubqueryHorizon)var10_8;
            subquery = var9_7.callSubquery();
            var54_49 = var9_7.yielding();
            if (var54_49) {
                subQueryCardinality = this.apply(subquery, cardinalityAndInput.labelInfo(), cardinalityAndInput.relTypeInfo(), semanticTable, indexPredicateProviderContext, cardinalityModel);
                return cardinalityAndInput.copy(cardinalityAndInput.cardinality().$times(subQueryCardinality), cardinalityAndInput.copy$default$2(), cardinalityAndInput.copy$default$3());
            }
        }
        if (var8_6 && !(var56_51 = var9_7.yielding())) {
            return cardinalityAndInput;
        }
        throw new MatchError((Object)var10_8);
    }

    private Cardinality queryProjectionCardinalityBeforeLimit(Cardinality in, QueryProjection projection2) {
        boolean bl = false;
        AggregatingQueryProjection aggregatingQueryProjection = null;
        QueryProjection queryProjection = projection2;
        if (queryProjection instanceof RegularQueryProjection) {
            return in;
        }
        if (queryProjection instanceof DistinctQueryProjection) {
            return in.$times(PlannerDefaults$.MODULE$.DEFAULT_DISTINCT_SELECTIVITY());
        }
        if (queryProjection instanceof AggregatingQueryProjection) {
            bl = true;
            aggregatingQueryProjection = (AggregatingQueryProjection)queryProjection;
            if (aggregatingQueryProjection.aggregationExpressions().isEmpty()) {
                return in.$times(PlannerDefaults$.MODULE$.DEFAULT_DISTINCT_SELECTIVITY());
            }
        }
        if (bl) {
            return StatisticsBackedCardinalityModel$.MODULE$.aggregateCardinalityEstimation(in, (Map<String, Expression>)aggregatingQueryProjection.groupingExpressions());
        }
        throw new MatchError((Object)queryProjection);
    }

    private Cardinality queryProjectionCardinalityWithLimit(Cardinality cardinalityBeforeLimit, QueryPagination queryPagination) {
        Option option = queryPagination.limit();
        if (None$.MODULE$.equals(option)) {
            return cardinalityBeforeLimit;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Expression limitExpression = (Expression)some.value();
            long limitRowCount = BoxesRunTime.unboxToLong((Object)this.evaluateLongIfStable(limitExpression).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> PlannerDefaults$.MODULE$.DEFAULT_LIMIT_ROW_COUNT()));
            if ((double)limitRowCount >= cardinalityBeforeLimit.amount()) {
                return cardinalityBeforeLimit;
            }
            return new Cardinality((double)limitRowCount);
        }
        throw new MatchError((Object)option);
    }

    private Cardinality queryProjectionCardinalityWithSkip(Cardinality cardinalityBeforeSkip, QueryPagination queryPagination) {
        Option option = queryPagination.skip();
        if (None$.MODULE$.equals(option)) {
            return cardinalityBeforeSkip;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Expression skipExpression = (Expression)some.value();
            long skipRowCount = BoxesRunTime.unboxToLong((Object)this.evaluateLongIfStable(skipExpression).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> PlannerDefaults$.MODULE$.DEFAULT_SKIP_ROW_COUNT()));
            if (skipRowCount == 0L) {
                return cardinalityBeforeSkip;
            }
            if ((double)skipRowCount >= cardinalityBeforeSkip.amount()) {
                return Cardinality$.MODULE$.EMPTY();
            }
            return cardinalityBeforeSkip.map((Function1)(JFunction1.mcDD.sp & Serializable)c -> c - (double)skipRowCount);
        }
        throw new MatchError((Object)option);
    }

    private Option<Object> evaluateLongIfStable(Expression expression) {
        Expression expression2 = expression;
        if (expression2 instanceof IntegerLiteral) {
            IntegerLiteral integerLiteral = (IntegerLiteral)expression2;
            return new Some((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(integerLiteral.value())));
        }
        if (this.isStable$1(expression2)) {
            return this.simpleExpressionEvaluator.evaluateExpression(expression2).collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof NumberValue) {
                        NumberValue numberValue = (NumberValue)A1;
                        return (B1)BoxesRunTime.boxToLong((long)numberValue.longValue());
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    return object instanceof NumberValue;
                }
            });
        }
        return None$.MODULE$;
    }

    private CardinalityAndInput queryProjectionCardinalityWithSelections(CardinalityAndInput inputBeforeSelection, Selections where, SemanticTable semanticTable, IndexCompatiblePredicatesProviderContext indexPredicateProviderContext, Metrics.CardinalityModel cardinalityModel) {
        Cardinality inboundCardinality = inputBeforeSelection.cardinality();
        CardinalityAndInput fusedInput = inputBeforeSelection.withFusedLabelInfo((Map<String, Set<LabelName>>)where.labelInfo());
        Selectivity whereSelectivity = this.selectivityCalculator.apply(where, fusedInput.labelInfo(), fusedInput.relTypeInfo(), semanticTable, indexPredicateProviderContext, cardinalityModel);
        Cardinality cardinality = inboundCardinality.$times(whereSelectivity);
        return new CardinalityAndInput(cardinality, fusedInput.labelInfo(), fusedInput.relTypeInfo());
    }

    private CardinalityAndInput calculateCardinalityForQueryGraph(QueryGraph graph, Map<String, Set<LabelName>> labelInfo, Map<String, RelTypeName> relTypeInfo, SemanticTable semanticTable, IndexCompatiblePredicatesProviderContext indexPredicateProviderContext, Metrics.CardinalityModel cardinalityModel) {
        Map<String, Set<LabelName>> fusedLabelInfo = MapSupport$.MODULE$.PowerMap(labelInfo).fuse((Map<String, Set<LabelName>>)graph.patternNodeLabels(), (Function2<Set<LabelName>, Set<LabelName>, Set<LabelName>>)(Function2 & Serializable)(x$2, x$3) -> (Set)x$2.$plus$plus((IterableOnce)x$3));
        Map fusedRelTypeInfo = (Map)relTypeInfo.$plus$plus((IterableOnce)graph.patternRelationshipTypes());
        Cardinality cardinality = this.queryGraphCardinalityModel.apply(graph, fusedLabelInfo, (Map<String, RelTypeName>)fusedRelTypeInfo, semanticTable, indexPredicateProviderContext, cardinalityModel);
        return new CardinalityAndInput(cardinality, fusedLabelInfo, (Map<String, RelTypeName>)fusedRelTypeInfo);
    }

    private final boolean isStable$1(Expression expression) {
        return !this.simpleExpressionEvaluator.hasParameters(expression) && this.simpleExpressionEvaluator.isDeterministic(expression);
    }

    public StatisticsBackedCardinalityModel(Metrics.QueryGraphCardinalityModel queryGraphCardinalityModel, Metrics.SelectivityCalculator selectivityCalculator, ExpressionEvaluator simpleExpressionEvaluator2) {
        this.queryGraphCardinalityModel = queryGraphCardinalityModel;
        this.selectivityCalculator = selectivityCalculator;
        this.simpleExpressionEvaluator = simpleExpressionEvaluator2;
        Metrics.CardinalityModel.$init$(this);
    }

    public static class CardinalityAndInput
    implements Product,
    Serializable {
        private final Cardinality cardinality;
        private final Map<String, Set<LabelName>> labelInfo;
        private final Map<String, RelTypeName> relTypeInfo;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Cardinality cardinality() {
            return this.cardinality;
        }

        public Map<String, Set<LabelName>> labelInfo() {
            return this.labelInfo;
        }

        public Map<String, RelTypeName> relTypeInfo() {
            return this.relTypeInfo;
        }

        public CardinalityAndInput withFusedLabelInfo(Map<String, Set<LabelName>> newLabelInfo) {
            Map<String, Set<LabelName>> x$1 = MapSupport$.MODULE$.PowerMap(this.labelInfo()).fuse(newLabelInfo, (Function2<Set<LabelName>, Set<LabelName>, Set<LabelName>>)(Function2 & Serializable)(x$4, x$5) -> (Set)x$4.$plus$plus((IterableOnce)x$5));
            Cardinality x$2 = this.copy$default$1();
            Map<String, RelTypeName> x$3 = this.copy$default$3();
            return this.copy(x$2, x$1, x$3);
        }

        public CardinalityAndInput withFusedRelTypeInfo(Map<String, RelTypeName> newRelTypeInfo) {
            Map x$1 = (Map)this.relTypeInfo().$plus$plus(newRelTypeInfo);
            Cardinality x$2 = this.copy$default$1();
            Map<String, Set<LabelName>> x$3 = this.copy$default$2();
            return this.copy(x$2, x$3, (Map<String, RelTypeName>)x$1);
        }

        public CardinalityAndInput copy(Cardinality cardinality, Map<String, Set<LabelName>> labelInfo, Map<String, RelTypeName> relTypeInfo) {
            return new CardinalityAndInput(cardinality, labelInfo, relTypeInfo);
        }

        public Cardinality copy$default$1() {
            return this.cardinality();
        }

        public Map<String, Set<LabelName>> copy$default$2() {
            return this.labelInfo();
        }

        public Map<String, RelTypeName> copy$default$3() {
            return this.relTypeInfo();
        }

        public String productPrefix() {
            return "CardinalityAndInput";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.cardinality();
                }
                case 1: {
                    return this.labelInfo();
                }
                case 2: {
                    return this.relTypeInfo();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CardinalityAndInput;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "cardinality";
                }
                case 1: {
                    return "labelInfo";
                }
                case 2: {
                    return "relTypeInfo";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CardinalityAndInput)) return false;
            boolean bl = true;
            if (!bl) return false;
            CardinalityAndInput cardinalityAndInput = (CardinalityAndInput)x$1;
            Cardinality cardinality = this.cardinality();
            Cardinality cardinality2 = cardinalityAndInput.cardinality();
            if (cardinality == null) {
                if (cardinality2 != null) {
                    return false;
                }
            } else if (!cardinality.equals(cardinality2)) return false;
            Map<String, Set<LabelName>> map2 = this.labelInfo();
            Map<String, Set<LabelName>> map3 = cardinalityAndInput.labelInfo();
            if (map2 == null) {
                if (map3 != null) {
                    return false;
                }
            } else if (!map2.equals(map3)) return false;
            Map<String, RelTypeName> map4 = this.relTypeInfo();
            Map<String, RelTypeName> map5 = cardinalityAndInput.relTypeInfo();
            if (map4 == null) {
                if (map5 != null) {
                    return false;
                }
            } else if (!map4.equals(map5)) return false;
            if (!cardinalityAndInput.canEqual(this)) return false;
            return true;
        }

        public CardinalityAndInput(Cardinality cardinality, Map<String, Set<LabelName>> labelInfo, Map<String, RelTypeName> relTypeInfo) {
            this.cardinality = cardinality;
            this.labelInfo = labelInfo;
            this.relTypeInfo = relTypeInfo;
            Product.$init$((Product)this);
        }
    }
}

