/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.neo4j.cypher.internal.ast.Clause;
import org.neo4j.cypher.internal.ast.Create;
import org.neo4j.cypher.internal.ast.ProjectingUnion;
import org.neo4j.cypher.internal.ast.ProjectingUnionAll;
import org.neo4j.cypher.internal.ast.ProjectingUnionDistinct;
import org.neo4j.cypher.internal.ast.Query;
import org.neo4j.cypher.internal.ast.SingleQuery;
import org.neo4j.cypher.internal.ast.UnaliasedReturnItem;
import org.neo4j.cypher.internal.ast.UnionAll;
import org.neo4j.cypher.internal.ast.UnionDistinct;
import org.neo4j.cypher.internal.ast.semantics.SemanticTable;
import org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery.ClauseConverters$;
import org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery.CreateIrExpressions;
import org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery.PlannerQueryBuilder;
import org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery.PlannerQueryBuilder$;
import org.neo4j.cypher.internal.expressions.And;
import org.neo4j.cypher.internal.expressions.Or;
import org.neo4j.cypher.internal.expressions.Pattern;
import org.neo4j.cypher.internal.ir.PlannerQuery;
import org.neo4j.cypher.internal.ir.SinglePlannerQuery;
import org.neo4j.cypher.internal.ir.UnionQuery;
import org.neo4j.cypher.internal.util.ASTNode;
import org.neo4j.cypher.internal.util.AnonymousVariableNameGenerator;
import org.neo4j.cypher.internal.util.Foldable;
import org.neo4j.cypher.internal.util.InputPosition;
import org.neo4j.cypher.internal.util.Rewritable;
import org.neo4j.cypher.internal.util.Rewritable$;
import org.neo4j.exceptions.InternalException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class StatementConverters$ {
    public static final StatementConverters$ MODULE$ = new StatementConverters$();
    private static final Set<Class<? extends ASTNode>> org$neo4j$cypher$internal$compiler$ast$convert$plannerQuery$StatementConverters$$NODE_BLACKLIST = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{And.class, Or.class, UnaliasedReturnItem.class, UnionAll.class, UnionDistinct.class}));

    private SinglePlannerQuery toSinglePlannerQuery(SingleQuery q, SemanticTable semanticTable, AnonymousVariableNameGenerator anonymousVariableNameGenerator, Set<String> importedVariables) {
        Set allImportedVars = (Set)importedVariables.$plus$plus((IterableOnce)q.importWith().map((Function1 & Serializable)wth -> ((IterableOnceOps)wth.returnItems().items().map((Function1 & Serializable)x$1 -> x$1.name())).toSet()).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Set().empty()));
        PlannerQueryBuilder builder = PlannerQueryBuilder$.MODULE$.apply(semanticTable, (Set<String>)allImportedVars);
        return this.addClausesToPlannerQueryBuilder((Seq<Clause>)q.clauses(), builder, anonymousVariableNameGenerator).build();
    }

    public PlannerQueryBuilder addClausesToPlannerQueryBuilder(Seq<Clause> clauses, PlannerQueryBuilder builder, AnonymousVariableNameGenerator anonymousVariableNameGenerator) {
        return this.addClausesToPlannerQueryBuilderRec$1(this.flattenCreates(clauses), builder, anonymousVariableNameGenerator);
    }

    public Set<Class<? extends ASTNode>> org$neo4j$cypher$internal$compiler$ast$convert$plannerQuery$StatementConverters$$NODE_BLACKLIST() {
        return org$neo4j$cypher$internal$compiler$ast$convert$plannerQuery$StatementConverters$$NODE_BLACKLIST;
    }

    private Seq<ASTNode> findBlacklistedNodes(Query query) {
        return (Seq)query.folder().treeFold((Object)package$.MODULE$.Seq().empty(), (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof ASTNode) {
                    ASTNode aSTNode = (ASTNode)A1;
                    if (StatementConverters$.MODULE$.org$neo4j$cypher$internal$compiler$ast$convert$plannerQuery$StatementConverters$$NODE_BLACKLIST().contains(aSTNode.getClass())) {
                        return (B1)(Function1 & Serializable)acc -> new Foldable.TraverseChildren(acc.$colon$plus((Object)aSTNode));
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                if (object instanceof ASTNode) {
                    ASTNode aSTNode = (ASTNode)object;
                    if (StatementConverters$.MODULE$.org$neo4j$cypher$internal$compiler$ast$convert$plannerQuery$StatementConverters$$NODE_BLACKLIST().contains(aSTNode.getClass())) {
                        return true;
                    }
                }
                return false;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.neo4j.cypher.internal.util.ASTNode scala.collection.immutable.Seq )}, serializedLambda);
            }
        });
    }

    public PlannerQuery toPlannerQuery(Query query, SemanticTable semanticTable, AnonymousVariableNameGenerator anonymousVariableNameGenerator, Set<String> importedVariables, boolean rewrite) {
        Query rewrittenQuery = rewrite ? (Query)Rewritable.RewritableAny$.MODULE$.endoRewrite$extension(Rewritable$.MODULE$.RewritableAny((Object)query), (Function1)new CreateIrExpressions(anonymousVariableNameGenerator, semanticTable)) : query;
        Seq<ASTNode> nodes = this.findBlacklistedNodes(rewrittenQuery);
        Predef$.MODULE$.require(nodes.isEmpty(), (Function0 & Serializable)() -> "Found a blacklisted AST node: " + nodes.head().toString());
        Query query2 = rewrittenQuery;
        if (query2 instanceof SingleQuery) {
            SingleQuery singleQuery = (SingleQuery)query2;
            return this.toSinglePlannerQuery(singleQuery, semanticTable, anonymousVariableNameGenerator, importedVariables);
        }
        if (query2 instanceof ProjectingUnion) {
            boolean bl;
            ProjectingUnion projectingUnion = (ProjectingUnion)query2;
            PlannerQuery lhs = this.toPlannerQuery(projectingUnion.lhs(), semanticTable, anonymousVariableNameGenerator, importedVariables, false);
            SinglePlannerQuery rhs = this.toSinglePlannerQuery(projectingUnion.rhs(), semanticTable, anonymousVariableNameGenerator, importedVariables);
            ProjectingUnion projectingUnion2 = projectingUnion;
            if (projectingUnion2 instanceof ProjectingUnionAll) {
                bl = false;
            } else if (projectingUnion2 instanceof ProjectingUnionDistinct) {
                bl = true;
            } else {
                throw new MatchError((Object)projectingUnion2);
            }
            boolean distinct2 = bl;
            return new UnionQuery(lhs, rhs, distinct2, projectingUnion.unionMappings());
        }
        throw new InternalException("Received an AST-clause that has no representation the QG: " + rewrittenQuery);
    }

    public Set<String> toPlannerQuery$default$4() {
        return Predef$.MODULE$.Set().empty();
    }

    public boolean toPlannerQuery$default$5() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Clause> flattenCreates(Seq<Clause> clauses) {
        void var2_2;
        ArrayBuffer builder = ArrayBuffer$.MODULE$.empty();
        ObjectRef prevCreate = ObjectRef.create((Object)None$.MODULE$);
        clauses.foreach((Function1 & Serializable)clause -> {
            Tuple2 tuple2 = new Tuple2(clause, (Object)((Option)prevCreate$1.elem));
            if (tuple2 != null) {
                Clause c = (Clause)tuple2._1();
                Option option = (Option)tuple2._2();
                if (c instanceof Create) {
                    Create create = (Create)c;
                    if (None$.MODULE$.equals(option)) {
                        prevCreate$1.elem = new Some((Object)new Tuple2((Object)create.pattern().patternParts(), (Object)create.position()));
                        return BoxedUnit.UNIT;
                    }
                }
            }
            if (tuple2 != null) {
                Clause c = (Clause)tuple2._1();
                Option option = (Option)tuple2._2();
                if (c instanceof Create) {
                    Some some;
                    Tuple2 tuple22;
                    Create create = (Create)c;
                    if (option instanceof Some && (tuple22 = (Tuple2)(some = (Some)option).value()) != null) {
                        Seq prevParts = (Seq)tuple22._1();
                        InputPosition pos = (InputPosition)tuple22._2();
                        prevCreate$1.elem = new Some((Object)new Tuple2(prevParts.$plus$plus((IterableOnce)create.pattern().patternParts()), (Object)pos));
                        return BoxedUnit.UNIT;
                    }
                }
            }
            if (tuple2 != null) {
                Some some;
                Tuple2 tuple23;
                Clause nonCreate = (Clause)tuple2._1();
                Option option = (Option)tuple2._2();
                if (option instanceof Some && (tuple23 = (Tuple2)(some = (Some)option).value()) != null) {
                    Seq prevParts = (Seq)tuple23._1();
                    InputPosition pos = (InputPosition)tuple23._2();
                    builder.$plus$eq((Object)new Create(new Pattern(prevParts, pos), pos));
                    builder.$plus$eq((Object)nonCreate);
                    prevCreate$1.elem = None$.MODULE$;
                    return BoxedUnit.UNIT;
                }
            }
            if (tuple2 != null) {
                Clause nonCreate = (Clause)tuple2._1();
                Option option = (Option)tuple2._2();
                if (None$.MODULE$.equals(option)) {
                    return builder.$plus$eq((Object)nonCreate);
                }
            }
            throw new MatchError((Object)tuple2);
        });
        ((Option)prevCreate.elem).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)StatementConverters$.$anonfun$flattenCreates$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$2 -> {
            Tuple2 tuple2 = x$2;
            if (tuple2 != null) {
                Seq prevParts = (Seq)tuple2._1();
                InputPosition pos = (InputPosition)tuple2._2();
                return (ArrayBuffer)builder.$plus$eq((Object)new Create(new Pattern(prevParts, pos), pos));
            }
            throw new MatchError((Object)tuple2);
        });
        return var2_2.toSeq();
    }

    private final PlannerQueryBuilder addClausesToPlannerQueryBuilderRec$1(Seq clauses, PlannerQueryBuilder builder, AnonymousVariableNameGenerator anonymousVariableNameGenerator$1) {
        while (!clauses.isEmpty()) {
            PlannerQueryBuilder newBuilder;
            Clause clause = (Clause)clauses.head();
            Seq nextClauses = (Seq)clauses.tail();
            Option nextClause = nextClauses.headOption();
            builder = newBuilder = ClauseConverters$.MODULE$.addToLogicalPlanInput(builder, clause, (Option<Clause>)nextClause, anonymousVariableNameGenerator$1);
            clauses = nextClauses;
        }
        return builder;
    }

    public static final /* synthetic */ boolean $anonfun$flattenCreates$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    private StatementConverters$() {
    }
}

