/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical.idp;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.cypher.internal.compiler.helpers.IteratorSupport$;
import org.neo4j.cypher.internal.compiler.planner.logical.ProjectingSelector;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.BestResults;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.DefaultIdRegistry;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.ExtraRequirement;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.Goal;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPCache;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPSolver$;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPSolverMonitor;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPSolverStep;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPTable;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IdRegistry;
import org.neo4j.cypher.internal.util.CancellationChecker;
import org.neo4j.exceptions.InternalException;
import org.neo4j.gqlstatus.ErrorClassification;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlClassification;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.time.Stopwatch;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.BitSet;
import scala.collection.immutable.BitSet$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\u0005%e\u0001\u0002\n\u0014\u0001\u0011B\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\"Aq\t\u0001B\u0001B\u0003%\u0001\n\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003P\u0011!a\u0006A!A!\u0002\u0013i\u0006\u0002\u00031\u0001\u0005\u0003\u0005\u000b\u0011B1\t\u0011\u0011\u0004!\u0011!Q\u0001\n\u0015D\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006I!\u001b\u0005\tY\u0002\u0011\t\u0011)A\u0005[\"AA\u000f\u0001B\u0001B\u0003%Q\u000fC\u0003|\u0001\u0011\u0005A\u0010C\u0004\u0002\u0012\u0001!\t!a\u0005\b\u0013\u0005u2#!A\t\u0002\u0005}b\u0001\u0003\n\u0014\u0003\u0003E\t!!\u0011\t\rmtA\u0011AA\"\u0011%\t)EDI\u0001\n\u0003\t9\u0005C\u0005\u0002p9\t\n\u0011\"\u0001\u0002r\tI\u0011\n\u0012)T_24XM\u001d\u0006\u0003)U\t1!\u001b3q\u0015\t1r#A\u0004m_\u001eL7-\u00197\u000b\u0005aI\u0012a\u00029mC:tWM\u001d\u0006\u00035m\t\u0001bY8na&dWM\u001d\u0006\u00039u\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003=}\taaY=qQ\u0016\u0014(B\u0001\u0011\"\u0003\u0015qWm\u001c\u001bk\u0015\u0005\u0011\u0013aA8sO\u000e\u0001Q\u0003B\u00134{\u0001\u001b\"\u0001\u0001\u0014\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\r\u0005s\u0017PU3g\u0003%9WM\\3sCR|'\u000fE\u0003/_Ebt(D\u0001\u0014\u0013\t\u00014CA\u0007J\tB\u001bv\u000e\u001c<feN#X\r\u001d\t\u0003eMb\u0001\u0001B\u00035\u0001\t\u0007QG\u0001\u0005T_24\u0018M\u00197f#\t1\u0014\b\u0005\u0002(o%\u0011\u0001\b\u000b\u0002\b\u001d>$\b.\u001b8h!\t9#(\u0003\u0002<Q\t\u0019\u0011I\\=\u0011\u0005IjD!\u0002 \u0001\u0005\u0004)$A\u0002*fgVdG\u000f\u0005\u00023\u0001\u0012)\u0011\t\u0001b\u0001k\t91i\u001c8uKb$\u0018A\u00059s_*,7\r^5oON+G.Z2u_J\u00042\u0001R#=\u001b\u0005)\u0012B\u0001$\u0016\u0005I\u0001&o\u001c6fGRLgnZ*fY\u0016\u001cGo\u001c:\u0002\u001fI,w-[:uef4\u0015m\u0019;pef\u00042aJ%L\u0013\tQ\u0005FA\u0005Gk:\u001cG/[8oaA\u0019a\u0006T\u0019\n\u00055\u001b\"AC%e%\u0016<\u0017n\u001d;ss\u0006aA/\u00192mK\u001a\u000b7\r^8ssB)q\u0005U&S3&\u0011\u0011\u000b\u000b\u0002\n\rVt7\r^5p]J\u0002Ba\u0015,2y9\u0011a\u0006V\u0005\u0003+N\tq\u0001]1dW\u0006<W-\u0003\u0002X1\n!1+Z3e\u0015\t)6\u0003E\u0002/5rJ!aW\n\u0003\u0011%#\u0005\u000bV1cY\u0016\fA\"\\1y)\u0006\u0014G.Z*ju\u0016\u0004\"a\n0\n\u0005}C#aA%oi\u00061\u0012\u000e^3sCRLwN\u001c#ve\u0006$\u0018n\u001c8MS6LG\u000f\u0005\u0002(E&\u00111\r\u000b\u0002\u0005\u0019>tw-\u0001\tfqR\u0014\u0018MU3rk&\u0014X-\\3oiB\u0019aF\u001a\u001f\n\u0005\u001d\u001c\"\u0001E#yiJ\f'+Z9vSJ,W.\u001a8u\u0003\u001diwN\\5u_J\u0004\"A\f6\n\u0005-\u001c\"\u0001E%E!N{GN^3s\u001b>t\u0017\u000e^8s\u0003A\u0019Ho\u001c9XCR\u001c\u0007NR1di>\u0014\u0018\u0010E\u0002(\u0013:\u0004\"a\u001c:\u000e\u0003AT!!]\u0010\u0002\tQLW.Z\u0005\u0003gB\u0014\u0011b\u0015;pa^\fGo\u00195\u0002'\r\fgnY3mY\u0006$\u0018n\u001c8DQ\u0016\u001c7.\u001a:\u0011\u0005YLX\"A<\u000b\u0005a\\\u0012\u0001B;uS2L!A_<\u0003'\r\u000bgnY3mY\u0006$\u0018n\u001c8DQ\u0016\u001c7.\u001a:\u0002\rqJg.\u001b;?)Mihp`A\u0001\u0003\u0007\t)!a\u0002\u0002\n\u0005-\u0011QBA\b!\u0015q\u0003!\r\u001f@\u0011\u0015a3\u00021\u0001.\u0011\u0015\u00115\u00021\u0001D\u0011\u001d95\u0002%AA\u0002!CqAT\u0006\u0011\u0002\u0003\u0007q\nC\u0003]\u0017\u0001\u0007Q\fC\u0003a\u0017\u0001\u0007\u0011\rC\u0003e\u0017\u0001\u0007Q\rC\u0003i\u0017\u0001\u0007\u0011\u000eC\u0003m\u0017\u0001\u0007Q\u000eC\u0003u\u0017\u0001\u0007Q/A\u0003baBd\u0017\u0010\u0006\u0005\u0002\u0016\u0005m\u0011qDA\u001d!\u0011q\u0013q\u0003\u001f\n\u0007\u0005e1CA\u0006CKN$(+Z:vYR\u001c\bBBA\u000f\u0019\u0001\u0007!+\u0001\u0003tK\u0016$\u0007bBA\u0011\u0019\u0001\u0007\u00111E\u0001\fS:LG/[1m)>$u\u000eE\u0003\u0002&\u0005M\u0012G\u0004\u0003\u0002(\u0005Eb\u0002BA\u0015\u0003_i!!a\u000b\u000b\u0007\u000552%\u0001\u0004=e>|GOP\u0005\u0002S%\u0011Q\u000bK\u0005\u0005\u0003k\t9DA\u0002TKFT!!\u0016\u0015\t\r\u0005mB\u00021\u0001@\u0003\u001d\u0019wN\u001c;fqR\f\u0011\"\u0013#Q'>dg/\u001a:\u0011\u00059r1C\u0001\b')\t\ty$A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\t\u0003\u0013\n9&a\u001b\u0002nU\u0011\u00111\n\u0016\u0005\u0003\u001b\nI\u0006\u0005\u0003(\u0013\u0006=\u0003#\u0002\u0018\u0002R\u0005U\u0013bAA*'\t\tB)\u001a4bk2$\u0018\n\u001a*fO&\u001cHO]=\u0011\u0007I\n9\u0006B\u00035!\t\u0007Qg\u000b\u0002\u0002\\A!\u0011QLA4\u001b\t\tyF\u0003\u0003\u0002b\u0005\r\u0014!C;oG\",7m[3e\u0015\r\t)\u0007K\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA5\u0003?\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\t\u0015q\u0004C1\u00016\t\u0015\t\u0005C1\u00016\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iUA\u00111OA?\u0003\u0007\u000b9)\u0006\u0002\u0002v)\"\u0011qOA-!!9\u0003+!\u001f\u0002\u0000\u0005\u0015\u0005\u0003\u0002\u0018M\u0003w\u00022AMA?\t\u0015!\u0014C1\u00016!\u0019\u0019f+a\u001f\u0002\u0002B\u0019!'a!\u0005\u000by\n\"\u0019A\u001b\u0011\t9R\u0016\u0011\u0011\u0003\u0006\u0003F\u0011\r!\u000e")
public class IDPSolver<Solvable, Result, Context> {
    private final IDPSolverStep<Solvable, Result, Context> generator;
    private final ProjectingSelector<Result> projectingSelector;
    private final Function0<IdRegistry<Solvable>> registryFactory;
    private final Function2<IdRegistry<Solvable>, Iterable<Tuple2<Tuple2<Set<Solvable>, Object>, Result>>, IDPTable<Result>> tableFactory;
    private final int maxTableSize;
    private final long iterationDurationLimit;
    private final ExtraRequirement<Result> extraRequirement;
    private final IDPSolverMonitor monitor;
    private final Function0<Stopwatch> stopWatchFactory;
    private final CancellationChecker cancellationChecker;

    public static <Solvable, Result, Context> Function2<IdRegistry<Solvable>, Iterable<Tuple2<Tuple2<Set<Solvable>, Object>, Result>>, IDPTable<Result>> $lessinit$greater$default$4() {
        return IDPSolver$.MODULE$.$lessinit$greater$default$4();
    }

    public static <Solvable, Result, Context> Function0<DefaultIdRegistry<Solvable>> $lessinit$greater$default$3() {
        return IDPSolver$.MODULE$.$lessinit$greater$default$3();
    }

    public BestResults<Result> apply(Iterable<Tuple2<Tuple2<Set<Solvable>, Object>, Result>> seed, Seq<Solvable> initialToDo, Context context) {
        IdRegistry registry = (IdRegistry)this.registryFactory.apply();
        ObjectRef toDo = ObjectRef.create((Object)new Goal(registry.registerAll(initialToDo)));
        IDPTable table = (IDPTable)this.tableFactory.apply((Object)registry, seed);
        int iterations = 0;
        while (((Goal)toDo.elem).size() > 1) {
            this.monitor.startIteration(++iterations);
            int largestFinished = this.generateBestCandidates$1(((Goal)toDo.elem).size(), toDo, table, registry, context);
            if (largestFinished <= 0) {
                ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N24).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).build();
                throw new InternalException(gql, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Unfortunately, the planner was unable to find a plan within the constraints provided.\n             |Try increasing the config values `" + GraphDatabaseInternalSettings.cypher_idp_solver_table_threshold.name() + "`\n             |and `" + GraphDatabaseInternalSettings.cypher_idp_solver_duration_threshold.name() + "` to allow\n             |for a larger sub-plan table and longer planning time.")));
            }
            Goal bestGoal = this.findBestCandidateInBlock$1(largestFinished, table);
            this.monitor.endIteration(iterations, largestFinished, table.size());
            IDPSolver.compactBlock$1(bestGoal, registry, table, toDo);
        }
        this.monitor.foundPlanAfter(iterations);
        Tuple2 tuple2 = table.plans().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Object result = tuple2._2();
                if (tuple22 != null) {
                    boolean fulfilsReq = tuple22._2$mcZ$sp();
                    return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)fulfilsReq), result);
                }
            }
            throw new MatchError((Object)tuple2);
        }).partition((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)IDPSolver.$anonfun$apply$15(x0$2)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterator plansFulfillingReq = (Iterator)tuple2._1();
        Iterator plans = (Iterator)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)plansFulfillingReq, (Object)plans);
        Iterator plansFulfillingReq2 = (Iterator)tuple22._1();
        Iterator plans2 = (Iterator)tuple22._2();
        Tuple2 tuple23 = (Tuple2)IteratorSupport$.MODULE$.RichIterator(plans2).toSingleOption().getOrElse((Function0 & Serializable)() -> {
            throw new InternalException("Expected a single plan to be left in the plan table");
        });
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        Object bestResult = tuple23._2();
        Object bestResult2 = bestResult;
        if (plansFulfillingReq2.hasNext()) {
            Tuple2 tuple24 = (Tuple2)IteratorSupport$.MODULE$.RichIterator(plansFulfillingReq2).toSingleOption().getOrElse((Function0 & Serializable)() -> {
                throw new InternalException("Expected a single plan that fulfils the requirements to be left in the plan table");
            });
            if (tuple24 == null) {
                throw new MatchError((Object)tuple24);
            }
            Object plan = tuple24._2();
            Object plan2 = plan;
            return new BestResults<Object>(bestResult2, (Option<Object>)new Some(plan2));
        }
        return new BestResults<Object>(bestResult2, (Option<Object>)None$.MODULE$);
    }

    private final Function1 candidateSelector$1(Function0 resolved) {
        return (Function1 & Serializable)x$2 -> $this.projectingSelector.apply((Function1 & Serializable)x -> Predef$.MODULE$.identity(x), x$2, (Function0<String>)resolved);
    }

    private final Function1 goalSelector$1(Function0 resolved) {
        return (Function1 & Serializable)x$3 -> $this.projectingSelector.apply((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Object result = tuple2._2();
                return result;
            }
            throw new MatchError((Object)tuple2);
        }, x$3, (Function0<String>)resolved);
    }

    public static final /* synthetic */ void $anonfun$apply$8(BooleanRef foundNoCandidate$1, IDPTable table$1, Goal goal$1, Object candidate) {
        foundNoCandidate$1.elem = false;
        table$1.put(goal$1, false, candidate);
    }

    public static final /* synthetic */ void $anonfun$apply$9(BooleanRef foundNoCandidate$1, IDPTable table$1, Goal goal$1, Object candidate) {
        foundNoCandidate$1.elem = false;
        table$1.put(goal$1, true, candidate);
    }

    private final int generateBestCandidates$1(int maxBlockSize, ObjectRef toDo$1, IDPTable table$1, IdRegistry registry$1, Object context$1) {
        int largestFinishedIteration = 0;
        int blockSize = 1;
        boolean keepGoing = true;
        Stopwatch start = (Stopwatch)this.stopWatchFactory.apply();
        while (keepGoing && blockSize <= maxBlockSize) {
            BooleanRef foundNoCandidate = BooleanRef.create((boolean)true);
            Iterator<Goal> goals = ((Goal)toDo$1.elem).subGoals(++blockSize);
            while (keepGoing && goals.hasNext()) {
                this.cancellationChecker.throwIfCancelled();
                Goal goal = (Goal)goals.next();
                if (table$1.contains(goal, false)) continue;
                Vector candidates = this.generator.apply(registry$1, goal, table$1, context$1).toVector();
                Tuple2 tuple2 = candidates.partition((Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)this.extraRequirement.fulfils(result)));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Iterable extraCandidates = (Iterable)tuple2._1();
                Iterable baseCandidates = (Iterable)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)extraCandidates, (Object)baseCandidates);
                Iterable extraCandidates2 = (Iterable)tuple22._1();
                Iterable baseCandidates2 = (Iterable)tuple22._2();
                Option bestExtraCandidate = (Option)this.candidateSelector$1((Function0 & Serializable)() -> "best sorted plan for " + goal.bitSet() + "@" + registry$1.explode(goal.bitSet())).apply((Object)extraCandidates2);
                ((Option)this.candidateSelector$1((Function0 & Serializable)() -> "best overall plan for " + goal.bitSet() + "@" + registry$1.explode(goal.bitSet())).apply(baseCandidates2.$plus$plus((IterableOnce)Option$.MODULE$.option2Iterable(bestExtraCandidate).toIterable()))).foreach((Function1 & Serializable)candidate -> {
                    IDPSolver.$anonfun$apply$8(foundNoCandidate, table$1, goal, candidate);
                    return BoxedUnit.UNIT;
                });
                bestExtraCandidate.foreach((Function1 & Serializable)candidate -> {
                    IDPSolver.$anonfun$apply$9(foundNoCandidate, table$1, goal, candidate);
                    return BoxedUnit.UNIT;
                });
                keepGoing = blockSize == 2 || table$1.size() <= this.maxTableSize && !start.hasTimedOut(this.iterationDurationLimit, TimeUnit.MILLISECONDS);
            }
            largestFinishedIteration = foundNoCandidate.elem || goals.hasNext() ? largestFinishedIteration : blockSize;
        }
        return largestFinishedIteration;
    }

    public static final /* synthetic */ Nothing$ $anonfun$apply$11(int blockSize$1, Iterable blockCandidates$1, IDPTable table$1) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N24).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).build();
        throw new InternalException(gql, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Found no solution for block with size " + blockSize$1 + ",\n             |" + blockCandidates$1 + " were the selected candidates from the table " + table$1)));
    }

    private final Goal findBestCandidateInBlock$1(int blockSize, IDPTable table$1) {
        Vector blockCandidates = table$1.unsortedPlansOfSize(blockSize).toVector();
        Option bestInBlock = (Option)this.goalSelector$1((Function0 & Serializable)() -> "Best candidate for block size " + blockSize).apply((Object)blockCandidates);
        Tuple2 tuple2 = (Tuple2)bestInBlock.getOrElse(() -> IDPSolver.$anonfun$apply$11(blockSize, (Iterable)blockCandidates, table$1));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Goal goal = (Goal)tuple2._1();
        Goal goal2 = goal;
        return goal2;
    }

    private static final void compactBlock$1(Goal original, IdRegistry registry$1, IDPTable table$1, ObjectRef toDo$1) {
        int newId = registry$1.compact(original.bitSet());
        IDPCache.Results results = table$1.apply(original);
        if (results == null) {
            throw new MatchError(results);
        }
        Option result = results.result();
        Option sortedResult = results.sortedResult();
        Tuple2 tuple2 = new Tuple2(result, sortedResult);
        Option result2 = (Option)tuple2._1();
        Option sortedResult2 = (Option)tuple2._2();
        result2.foreach((Function1 & Serializable)x$6 -> {
            table$1.put(new Goal((BitSet)BitSet$.MODULE$.empty().$plus((Object)BoxesRunTime.boxToInteger((int)newId))), false, x$6);
            return BoxedUnit.UNIT;
        });
        sortedResult2.foreach((Function1 & Serializable)x$7 -> {
            table$1.put(new Goal((BitSet)BitSet$.MODULE$.empty().$plus((Object)BoxesRunTime.boxToInteger((int)newId))), true, x$7);
            return BoxedUnit.UNIT;
        });
        toDo$1.elem = new Goal((BitSet)((Goal)toDo$1.elem).bitSet().$minus$minus((IterableOnce)original.bitSet()).$plus((Object)BoxesRunTime.boxToInteger((int)newId)));
        table$1.removeAllTracesOf(original);
    }

    public static final /* synthetic */ boolean $anonfun$apply$15(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            boolean fulfilsReq = tuple2._1$mcZ$sp();
            return fulfilsReq;
        }
        throw new MatchError((Object)tuple2);
    }

    public IDPSolver(IDPSolverStep<Solvable, Result, Context> generator, ProjectingSelector<Result> projectingSelector, Function0<IdRegistry<Solvable>> registryFactory, Function2<IdRegistry<Solvable>, Iterable<Tuple2<Tuple2<Set<Solvable>, Object>, Result>>, IDPTable<Result>> tableFactory, int maxTableSize, long iterationDurationLimit, ExtraRequirement<Result> extraRequirement, IDPSolverMonitor monitor, Function0<Stopwatch> stopWatchFactory, CancellationChecker cancellationChecker) {
        this.generator = generator;
        this.projectingSelector = projectingSelector;
        this.registryFactory = registryFactory;
        this.tableFactory = tableFactory;
        this.maxTableSize = maxTableSize;
        this.iterationDurationLimit = iterationDurationLimit;
        this.extraRequirement = extraRequirement;
        this.monitor = monitor;
        this.stopWatchFactory = stopWatchFactory;
        this.cancellationChecker = cancellationChecker;
    }
}

