/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.semantics.SemanticTable;
import org.neo4j.cypher.internal.compiler.helpers.MapSupport$;
import org.neo4j.cypher.internal.compiler.planner.ProcedureCallProjection;
import org.neo4j.cypher.internal.compiler.planner.logical.ExpressionEvaluator;
import org.neo4j.cypher.internal.compiler.planner.logical.Metrics;
import org.neo4j.cypher.internal.compiler.planner.logical.PlannerDefaults$;
import org.neo4j.cypher.internal.compiler.planner.logical.StatisticsBackedCardinalityModel$;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.index.IndexCompatiblePredicatesProviderContext;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.FunctionInvocation;
import org.neo4j.cypher.internal.expressions.IntegerLiteral;
import org.neo4j.cypher.internal.expressions.LabelName;
import org.neo4j.cypher.internal.expressions.ListLiteral;
import org.neo4j.cypher.internal.expressions.RelTypeName;
import org.neo4j.cypher.internal.ir.AggregatingQueryProjection;
import org.neo4j.cypher.internal.ir.CallSubqueryHorizon;
import org.neo4j.cypher.internal.ir.CommandProjection;
import org.neo4j.cypher.internal.ir.DistinctQueryProjection;
import org.neo4j.cypher.internal.ir.LoadCSVProjection;
import org.neo4j.cypher.internal.ir.PassthroughAllHorizon;
import org.neo4j.cypher.internal.ir.PlannerQueryPart;
import org.neo4j.cypher.internal.ir.QueryGraph;
import org.neo4j.cypher.internal.ir.QueryHorizon;
import org.neo4j.cypher.internal.ir.QueryPagination;
import org.neo4j.cypher.internal.ir.QueryProjection;
import org.neo4j.cypher.internal.ir.RegularQueryProjection;
import org.neo4j.cypher.internal.ir.Selections;
import org.neo4j.cypher.internal.ir.SinglePlannerQuery;
import org.neo4j.cypher.internal.ir.UnionQuery;
import org.neo4j.cypher.internal.ir.UnwindProjection;
import org.neo4j.cypher.internal.util.Cardinality;
import org.neo4j.cypher.internal.util.Cardinality$;
import org.neo4j.cypher.internal.util.Multiplier;
import org.neo4j.cypher.internal.util.Selectivity;
import org.neo4j.values.storable.NumberValue;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\reb\u0001B\u00193\u0001\u0005C\u0001\u0002\u0019\u0001\u0003\u0002\u0003\u0006I!\u0019\u0005\tI\u0002\u0011\t\u0011)A\u0005K\"A\u0001\u000e\u0001B\u0001B\u0003%\u0011\u000eC\u0003n\u0001\u0011\u0005a\u000eC\u0003t\u0001\u0011\u0005C\u000fC\u0004\u0002D\u0001!\t!!\u0012\t\u000f\u0005e\u0003\u0001\"\u0001\u0002\\!9\u0011q\u000e\u0001\u0005\n\u0005E\u0004b\u0002Bi\u0001\u0011%!1\u001b\u0005\b\u0005C\u0004A\u0011\u0002Br\u0011\u001d\u0011\u0019\u0010\u0001C\u0005\u0005kDqA!@\u0001\t\u0013\u0011y\u0010C\u0004\u0004\u000e\u0001!Iaa\u0004\t\u000f\r\r\u0002\u0001\"\u0003\u0004&\u001d9\u0011q\u000f\u001a\t\u0002\u0005edAB\u00193\u0011\u0003\tY\b\u0003\u0004n!\u0011\u0005\u0011Q\u0010\u0004\u0007\u0003\u007f\u0002\u0002)!!\t\u0015\u0005m%C!f\u0001\n\u0003\ti\nC\u0005\u0002 J\u0011\t\u0012)A\u0005k\"Q\u0011\u0011\u0002\n\u0003\u0016\u0004%\t!!)\t\u0015\u0005\r&C!E!\u0002\u0013\tY\u0001\u0003\u0006\u0002\u0014I\u0011)\u001a!C\u0001\u0003KC!\"a*\u0013\u0005#\u0005\u000b\u0011BA\u000b\u0011\u0019i'\u0003\"\u0001\u0002*\"9\u0011Q\u0017\n\u0005\u0002\u0005]\u0006bBA_%\u0011\u0005\u0011q\u0018\u0005\n\u0003\u000b\u0014\u0012\u0011!C\u0001\u0003\u000fD\u0011\"a4\u0013#\u0003%\t!!5\t\u0013\u0005\u001d(#%A\u0005\u0002\u0005%\b\"CAw%E\u0005I\u0011AAx\u0011%\t\u0019PEA\u0001\n\u0003\n)\u0010C\u0005\u0003\bI\t\t\u0011\"\u0001\u0003\n!I!\u0011\u0003\n\u0002\u0002\u0013\u0005!1\u0003\u0005\n\u0005?\u0011\u0012\u0011!C!\u0005CA\u0011Ba\f\u0013\u0003\u0003%\tA!\r\t\u0013\tm\"#!A\u0005B\tu\u0002\"\u0003B!%\u0005\u0005I\u0011\tB\"\u0011%\u0011)EEA\u0001\n\u0003\u00129\u0005C\u0005\u0003JI\t\t\u0011\"\u0011\u0003L\u001dI!q\n\t\u0002\u0002#\u0005!\u0011\u000b\u0004\n\u0003\u007f\u0002\u0012\u0011!E\u0001\u0005'Ba!\u001c\u0016\u0005\u0002\t-\u0004\"\u0003B#U\u0005\u0005IQ\tB$\u0011!\u0019(&!A\u0005\u0002\n5\u0004\"\u0003B;U\u0005\u0005I\u0011\u0011B<\u0011%\u0011IIKA\u0001\n\u0013\u0011Y\tC\u0004\u0003\u0014B!\tA!&\u0003AM#\u0018\r^5ti&\u001c7OQ1dW\u0016$7)\u0019:eS:\fG.\u001b;z\u001b>$W\r\u001c\u0006\u0003gQ\nq\u0001\\8hS\u000e\fGN\u0003\u00026m\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u001c9\u0003!\u0019w.\u001c9jY\u0016\u0014(BA\u001d;\u0003!Ig\u000e^3s]\u0006d'BA\u001e=\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011QHP\u0001\u0006]\u0016|GG\u001b\u0006\u0002\u007f\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0011%\u0011\u0005\r3U\"\u0001#\u000b\u0003\u0015\u000bQa]2bY\u0006L!a\u0012#\u0003\r\u0005s\u0017PU3g!\tIUL\u0004\u0002K7:\u00111J\u0017\b\u0003\u0019fs!!\u0014-\u000f\u00059;fBA(W\u001d\t\u0001VK\u0004\u0002R)6\t!K\u0003\u0002T\u0001\u00061AH]8pizJ\u0011aP\u0005\u0003{yJ!a\u000f\u001f\n\u0005eR\u0014BA\u001c9\u0013\t)d'\u0003\u00024i%\u0011ALM\u0001\b\u001b\u0016$(/[2t\u0013\tqvL\u0001\tDCJ$\u0017N\\1mSRLXj\u001c3fY*\u0011ALM\u0001\u001bcV,'/_$sCBD7)\u0019:eS:\fG.\u001b;z\u001b>$W\r\u001c\t\u0003\u0013\nL!aY0\u00035E+XM]=He\u0006\u0004\bnQ1sI&t\u0017\r\\5us6{G-\u001a7\u0002+M,G.Z2uSZLG/_\"bY\u000e,H.\u0019;peB\u0011\u0011JZ\u0005\u0003O~\u0013QcU3mK\u000e$\u0018N^5us\u000e\u000bGnY;mCR|'/A\rtS6\u0004H.Z#yaJ,7o]5p]\u00163\u0018\r\\;bi>\u0014\bC\u00016l\u001b\u0005\u0011\u0014B\u000173\u0005M)\u0005\u0010\u001d:fgNLwN\\#wC2,\u0018\r^8s\u0003\u0019a\u0014N\\5u}Q!q\u000e]9s!\tQ\u0007\u0001C\u0003a\t\u0001\u0007\u0011\rC\u0003e\t\u0001\u0007Q\rC\u0003i\t\u0001\u0007\u0011.A\u0003baBd\u0017\u0010\u0006\u0006vw\u0006\u001d\u0011\u0011CA\u000e\u0003_\u0001\"A^=\u000e\u0003]T!\u0001\u001f\u001d\u0002\tU$\u0018\u000e\\\u0005\u0003u^\u00141bQ1sI&t\u0017\r\\5us\")A0\u0002a\u0001{\u0006I\u0011/^3ssB\u000b'\u000f\u001e\t\u0004}\u0006\rQ\"A@\u000b\u0007\u0005\u0005\u0001(\u0001\u0002je&\u0019\u0011QA@\u0003!Ac\u0017M\u001c8feF+XM]=QCJ$\bbBA\u0005\u000b\u0001\u0007\u00111B\u0001\nY\u0006\u0014W\r\\%oM>\u00042!SA\u0007\u0013\r\tya\u0018\u0002\n\u0019\u0006\u0014W\r\\%oM>Dq!a\u0005\u0006\u0001\u0004\t)\"A\u0006sK2$\u0016\u0010]3J]\u001a|\u0007cA%\u0002\u0018%\u0019\u0011\u0011D0\u0003\u0017I+G\u000eV=qK&sgm\u001c\u0005\b\u0003;)\u0001\u0019AA\u0010\u00035\u0019X-\\1oi&\u001cG+\u00192mKB!\u0011\u0011EA\u0016\u001b\t\t\u0019C\u0003\u0003\u0002&\u0005\u001d\u0012!C:f[\u0006tG/[2t\u0015\r\tI\u0003O\u0001\u0004CN$\u0018\u0002BA\u0017\u0003G\u0011QbU3nC:$\u0018n\u0019+bE2,\u0007bBA\u0019\u000b\u0001\u0007\u00111G\u0001\u001eS:$W\r\u001f)sK\u0012L7-\u0019;f!J|g/\u001b3fe\u000e{g\u000e^3yiB!\u0011QGA \u001b\t\t9D\u0003\u0003\u0002:\u0005m\u0012!B5oI\u0016D(bAA\u001fe\u0005)1\u000f^3qg&!\u0011\u0011IA\u001c\u0005!Je\u000eZ3y\u0007>l\u0007/\u0019;jE2,\u0007K]3eS\u000e\fG/Z:Qe>4\u0018\u000eZ3s\u0007>tG/\u001a=u\u0003u\u0019\u0018N\\4mKBc\u0017M\u001c8feF+XM]=DCJ$\u0017N\\1mSRLHcC;\u0002H\u0005E\u00131KA+\u0003/Bq!!\u0013\u0007\u0001\u0004\tY%A\u0003rk\u0016\u0014\u0018\u0010E\u0002\u007f\u0003\u001bJ1!a\u0014\u0000\u0005I\u0019\u0016N\\4mKBc\u0017M\u001c8feF+XM]=\t\u000f\u0005%a\u00011\u0001\u0002\f!9\u00111\u0003\u0004A\u0002\u0005U\u0001bBA\u000f\r\u0001\u0007\u0011q\u0004\u0005\b\u0003c1\u0001\u0019AA\u001a\u00031\u0019w.\u001c2j]\u0016,f.[8o)\u001d)\u0018QLA4\u0003WBq!a\u0018\b\u0001\u0004\t\t'\u0001\u0006v]&|g.U;fef\u00042A`A2\u0013\r\t)g \u0002\u000b+:LwN\\)vKJL\bBBA5\u000f\u0001\u0007Q/A\bqCJ$8)\u0019:eS:\fG.\u001b;z\u0011\u0019\tig\u0002a\u0001k\u0006\u0001\u0012/^3ss\u000e\u000b'\u000fZ5oC2LG/_\u0001$G\u0006d7-\u001e7bi\u0016\u001c\u0015M\u001d3j]\u0006d\u0017\u000e^=G_J\fV/\u001a:z\u0011>\u0014\u0018N_8o))\t\u0019Ha0\u0003D\n5'q\u001a\t\u0004\u0003k\u0012bB\u0001&\u0010\u0003\u0001\u001aF/\u0019;jgRL7m\u001d\"bG.,GmQ1sI&t\u0017\r\\5us6{G-\u001a7\u0011\u0005)\u00042C\u0001\tC)\t\tIHA\nDCJ$\u0017N\\1mSRL\u0018I\u001c3J]B,Ho\u0005\u0004\u0013\u0005\u0006\r\u0015\u0011\u0012\t\u0004\u0007\u0006\u0015\u0015bAAD\t\n9\u0001K]8ek\u000e$\b\u0003BAF\u0003+sA!!$\u0002\u0012:\u0019\u0011+a$\n\u0003\u0015K1!a%E\u0003\u001d\u0001\u0018mY6bO\u0016LA!a&\u0002\u001a\na1+\u001a:jC2L'0\u00192mK*\u0019\u00111\u0013#\u0002\u0017\r\f'\u000fZ5oC2LG/_\u000b\u0002k\u0006a1-\u0019:eS:\fG.\u001b;zAU\u0011\u00111B\u0001\u000bY\u0006\u0014W\r\\%oM>\u0004SCAA\u000b\u00031\u0011X\r\u001c+za\u0016LeNZ8!)!\tY+a,\u00022\u0006M\u0006cAAW%5\t\u0001\u0003\u0003\u0004\u0002\u001cf\u0001\r!\u001e\u0005\b\u0003\u0013I\u0002\u0019AA\u0006\u0011\u001d\t\u0019\"\u0007a\u0001\u0003+\t!c^5uQ\u001a+8/\u001a3MC\n,G.\u00138g_R!\u00111VA]\u0011\u001d\tYL\u0007a\u0001\u0003\u0017\tAB\\3x\u0019\u0006\u0014W\r\\%oM>\fAc^5uQ\u001a+8/\u001a3SK2$\u0016\u0010]3J]\u001a|G\u0003BAV\u0003\u0003Dq!a1\u001c\u0001\u0004\t)\"\u0001\boK^\u0014V\r\u001c+za\u0016LeNZ8\u0002\t\r|\u0007/\u001f\u000b\t\u0003W\u000bI-a3\u0002N\"A\u00111\u0014\u000f\u0011\u0002\u0003\u0007Q\u000fC\u0005\u0002\nq\u0001\n\u00111\u0001\u0002\f!I\u00111\u0003\u000f\u0011\u0002\u0003\u0007\u0011QC\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\u0019NK\u0002v\u0003+\\#!a6\u0011\t\u0005e\u00171]\u0007\u0003\u00037TA!!8\u0002`\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003C$\u0015AC1o]>$\u0018\r^5p]&!\u0011Q]An\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tYO\u000b\u0003\u0002\f\u0005U\u0017AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003cTC!!\u0006\u0002V\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a>\u0011\t\u0005e(1A\u0007\u0003\u0003wTA!!@\u0002\u0000\u0006!A.\u00198h\u0015\t\u0011\t!\u0001\u0003kCZ\f\u0017\u0002\u0002B\u0003\u0003w\u0014aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001B\u0006!\r\u0019%QB\u0005\u0004\u0005\u001f!%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B\u000b\u00057\u00012a\u0011B\f\u0013\r\u0011I\u0002\u0012\u0002\u0004\u0003:L\b\"\u0003B\u000fE\u0005\u0005\t\u0019\u0001B\u0006\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!1\u0005\t\u0007\u0005K\u0011YC!\u0006\u000e\u0005\t\u001d\"b\u0001B\u0015\t\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t5\"q\u0005\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u00034\te\u0002cA\"\u00036%\u0019!q\u0007#\u0003\u000f\t{w\u000e\\3b]\"I!Q\u0004\u0013\u0002\u0002\u0003\u0007!QC\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002x\n}\u0002\"\u0003B\u000fK\u0005\u0005\t\u0019\u0001B\u0006\u0003!A\u0017m\u001d5D_\u0012,GC\u0001B\u0006\u0003!!xn\u0015;sS:<GCAA|\u0003\u0019)\u0017/^1mgR!!1\u0007B'\u0011%\u0011i\u0002KA\u0001\u0002\u0004\u0011)\"A\nDCJ$\u0017N\\1mSRL\u0018I\u001c3J]B,H\u000fE\u0002\u0002.*\u001aRA\u000bB+\u0005C\u00022Ba\u0016\u0003^U\fY!!\u0006\u0002,6\u0011!\u0011\f\u0006\u0004\u00057\"\u0015a\u0002:v]RLW.Z\u0005\u0005\u0005?\u0012IFA\tBEN$(/Y2u\rVt7\r^5p]N\u0002BAa\u0019\u0003j5\u0011!Q\r\u0006\u0005\u0005O\ny0\u0001\u0002j_&!\u0011q\u0013B3)\t\u0011\t\u0006\u0006\u0005\u0002,\n=$\u0011\u000fB:\u0011\u0019\tY*\fa\u0001k\"9\u0011\u0011B\u0017A\u0002\u0005-\u0001bBA\n[\u0001\u0007\u0011QC\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011IH!\"\u0011\u000b\r\u0013YHa \n\u0007\tuDI\u0001\u0004PaRLwN\u001c\t\t\u0007\n\u0005U/a\u0003\u0002\u0016%\u0019!1\u0011#\u0003\rQ+\b\u000f\\34\u0011%\u00119ILA\u0001\u0002\u0004\tY+A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"A!$\u0011\t\u0005e(qR\u0005\u0005\u0005#\u000bYP\u0001\u0004PE*,7\r^\u0001\u001fC\u001e<'/Z4bi\u0016\u001c\u0015M\u001d3j]\u0006d\u0017\u000e^=FgRLW.\u0019;j_:$R!\u001eBL\u00057CaA!'1\u0001\u0004)\u0018AA5o\u0011\u001d\u0011i\n\ra\u0001\u0005?\u000b1c\u001a:pkBLgnZ#yaJ,7o]5p]N\u0004\u0002B!)\u0003*\n=&1\u0017\b\u0005\u0005G\u0013)\u000b\u0005\u0002R\t&\u0019!q\u0015#\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011YK!,\u0003\u00075\u000b\u0007OC\u0002\u0003(\u0012\u0003BA!)\u00032&!!Q\u0001BW!\u0011\u0011)La/\u000e\u0005\t]&b\u0001B]q\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\u0011\u0011iLa.\u0003\u0015\u0015C\bO]3tg&|g\u000eC\u0004\u0003B\"\u0001\r!a\u001d\u0002'\r\f'\u000fZ5oC2LG/_!oI&s\u0007/\u001e;\t\u000f\t\u0015\u0007\u00021\u0001\u0003H\u00069\u0001n\u001c:ju>t\u0007c\u0001@\u0003J&\u0019!1Z@\u0003\u0019E+XM]=I_JL'p\u001c8\t\u000f\u0005u\u0001\u00021\u0001\u0002 !9\u0011\u0011\u0007\u0005A\u0002\u0005M\u0012!J9vKJL\bK]8kK\u000e$\u0018n\u001c8DCJ$\u0017N\\1mSRL()\u001a4pe\u0016d\u0015.\\5u)\u0015)(Q\u001bBl\u0011\u0019\u0011I*\u0003a\u0001k\"9!\u0011\\\u0005A\u0002\tm\u0017A\u00039s_*,7\r^5p]B\u0019aP!8\n\u0007\t}wPA\bRk\u0016\u0014\u0018\u0010\u0015:pU\u0016\u001cG/[8o\u0003\r\nX/\u001a:z!J|'.Z2uS>t7)\u0019:eS:\fG.\u001b;z/&$\b\u000eT5nSR$R!\u001eBs\u0005SDaAa:\u000b\u0001\u0004)\u0018AF2be\u0012Lg.\u00197jif\u0014UMZ8sK2KW.\u001b;\t\u000f\t-(\u00021\u0001\u0003n\u0006y\u0011/^3ssB\u000bw-\u001b8bi&|g\u000eE\u0002\u007f\u0005_L1A!=\u0000\u0005=\tV/\u001a:z!\u0006<\u0017N\\1uS>t\u0017AI9vKJL\bK]8kK\u000e$\u0018n\u001c8DCJ$\u0017N\\1mSRLx+\u001b;i'.L\u0007\u000fF\u0003v\u0005o\u0014Y\u0010\u0003\u0004\u0003z.\u0001\r!^\u0001\u0016G\u0006\u0014H-\u001b8bY&$\u0018PQ3g_J,7k[5q\u0011\u001d\u0011Yo\u0003a\u0001\u0005[\fA#\u001a<bYV\fG/\u001a'p]\u001eLem\u0015;bE2,G\u0003BB\u0001\u0007\u0013\u0001Ra\u0011B>\u0007\u0007\u00012aQB\u0003\u0013\r\u00199\u0001\u0012\u0002\u0005\u0019>tw\rC\u0004\u0004\f1\u0001\rAa-\u0002\u0015\u0015D\bO]3tg&|g.\u0001\u0015rk\u0016\u0014\u0018\u0010\u0015:pU\u0016\u001cG/[8o\u0007\u0006\u0014H-\u001b8bY&$\u0018pV5uQN+G.Z2uS>t7\u000f\u0006\u0006\u0002t\rE1QCB\u0010\u0007CAqaa\u0005\u000e\u0001\u0004\t\u0019(\u0001\u000bj]B,HOQ3g_J,7+\u001a7fGRLwN\u001c\u0005\b\u0007/i\u0001\u0019AB\r\u0003\u00159\b.\u001a:f!\rq81D\u0005\u0004\u0007;y(AC*fY\u0016\u001cG/[8og\"9\u0011QD\u0007A\u0002\u0005}\u0001bBA\u0019\u001b\u0001\u0007\u00111G\u0001\"G\u0006d7-\u001e7bi\u0016\u001c\u0015M\u001d3j]\u0006d\u0017\u000e^=G_J\fV/\u001a:z\u000fJ\f\u0007\u000f\u001b\u000b\r\u0003g\u001a9c!\r\u00044\rU2q\u0007\u0005\b\u0007Sq\u0001\u0019AB\u0016\u0003\u00159'/\u00199i!\rq8QF\u0005\u0004\u0007_y(AC)vKJLxI]1qQ\"9\u0011\u0011\u0002\bA\u0002\u0005-\u0001bBA\n\u001d\u0001\u0007\u0011Q\u0003\u0005\b\u0003;q\u0001\u0019AA\u0010\u0011\u001d\t\tD\u0004a\u0001\u0003g\u0001")
public class StatisticsBackedCardinalityModel
implements Metrics.CardinalityModel {
    private final Metrics.QueryGraphCardinalityModel queryGraphCardinalityModel;
    private final Metrics.SelectivityCalculator selectivityCalculator;
    private final ExpressionEvaluator simpleExpressionEvaluator;

    public static Cardinality aggregateCardinalityEstimation(Cardinality in, Map<String, Expression> groupingExpressions) {
        return StatisticsBackedCardinalityModel$.MODULE$.aggregateCardinalityEstimation(in, groupingExpressions);
    }

    @Override
    public Cardinality apply(PlannerQueryPart queryPart, Map<String, Set<LabelName>> labelInfo, Map<String, RelTypeName> relTypeInfo, SemanticTable semanticTable, IndexCompatiblePredicatesProviderContext indexPredicateProviderContext) {
        Cardinality cardinality;
        PlannerQueryPart plannerQueryPart = queryPart;
        if (plannerQueryPart instanceof SinglePlannerQuery) {
            SinglePlannerQuery singlePlannerQuery = (SinglePlannerQuery)plannerQueryPart;
            cardinality = this.singlePlannerQueryCardinality(singlePlannerQuery, labelInfo, relTypeInfo, semanticTable, indexPredicateProviderContext);
        } else if (plannerQueryPart instanceof UnionQuery) {
            UnionQuery unionQuery = (UnionQuery)plannerQueryPart;
            PlannerQueryPart part = unionQuery.part();
            SinglePlannerQuery query = unionQuery.query();
            cardinality = this.combineUnion(unionQuery, this.apply(part, labelInfo, relTypeInfo, semanticTable, indexPredicateProviderContext), this.apply((PlannerQueryPart)query, labelInfo, relTypeInfo, semanticTable, indexPredicateProviderContext));
        } else {
            throw new MatchError((Object)plannerQueryPart);
        }
        return cardinality;
    }

    public Cardinality singlePlannerQueryCardinality(SinglePlannerQuery query, Map<String, Set<LabelName>> labelInfo, Map<String, RelTypeName> relTypeInfo, SemanticTable semanticTable, IndexCompatiblePredicatesProviderContext indexPredicateProviderContext) {
        CardinalityAndInput output = (CardinalityAndInput)query.fold((Object)new CardinalityAndInput(Cardinality$.MODULE$.SINGLE(), labelInfo, relTypeInfo), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            CardinalityAndInput cardinalityAndInput = (CardinalityAndInput)tuple2._1();
            SinglePlannerQuery plannerQuery = (SinglePlannerQuery)tuple2._2();
            if (cardinalityAndInput == null) throw new MatchError((Object)tuple2);
            Cardinality inboundCardinality = cardinalityAndInput.cardinality();
            Map<String, Set<LabelName>> labelInfo = cardinalityAndInput.labelInfo();
            Map<String, RelTypeName> relTypeInfo = cardinalityAndInput.relTypeInfo();
            CardinalityAndInput cardinalityAndInput2 = this.calculateCardinalityForQueryGraph(plannerQuery.queryGraph(), labelInfo, relTypeInfo, semanticTable, indexPredicateProviderContext);
            if (cardinalityAndInput2 == null) throw new MatchError((Object)cardinalityAndInput2);
            Cardinality qgCardinality = cardinalityAndInput2.cardinality();
            Map<String, Set<LabelName>> labelInfoAfterQG = cardinalityAndInput2.labelInfo();
            Map<String, RelTypeName> relTypeInfoAfterQG = cardinalityAndInput2.relTypeInfo();
            Tuple3 tuple3 = new Tuple3((Object)qgCardinality, labelInfoAfterQG, relTypeInfoAfterQG);
            Tuple3 tuple32 = tuple3;
            Cardinality qgCardinality2 = (Cardinality)tuple32._1();
            Map labelInfoAfterQG2 = (Map)tuple32._2();
            Map relTypeInfoAfterQG2 = (Map)tuple32._3();
            Cardinality beforeHorizonCardinality = qgCardinality2.$times(inboundCardinality);
            CardinalityAndInput afterHorizon = this.calculateCardinalityForQueryHorizon(new CardinalityAndInput(beforeHorizonCardinality, (Map<String, Set<LabelName>>)labelInfoAfterQG2, (Map<String, RelTypeName>)relTypeInfoAfterQG2), plannerQuery.horizon(), semanticTable, indexPredicateProviderContext);
            return afterHorizon.withFusedLabelInfo((Map<String, Set<LabelName>>)plannerQuery.firstLabelInfo());
        });
        return output.cardinality();
    }

    public Cardinality combineUnion(UnionQuery unionQuery, Cardinality partCardinality, Cardinality queryCardinality) {
        Cardinality unionCardinality = partCardinality.$plus(queryCardinality);
        return unionQuery.distinct() ? unionCardinality.$times(PlannerDefaults$.MODULE$.DEFAULT_DISTINCT_SELECTIVITY()) : unionCardinality;
    }

    /*
     * Unable to fully structure code
     */
    private CardinalityAndInput calculateCardinalityForQueryHorizon(CardinalityAndInput cardinalityAndInput, QueryHorizon horizon, SemanticTable semanticTable, IndexCompatiblePredicatesProviderContext indexPredicateProviderContext) {
        block7: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block8: {
                                block10: {
                                    block11: {
                                        block9: {
                                            block6: {
                                                var7_5 = false;
                                                var8_6 = null;
                                                var9_7 = horizon;
                                                if (!(var9_7 instanceof QueryProjection)) break block6;
                                                var10_8 = (QueryProjection)var9_7;
                                                cardinalityBeforeSkip = this.queryProjectionCardinalityBeforeLimit(cardinalityAndInput.cardinality(), var10_8);
                                                cardinalityBeforeLimit = this.queryProjectionCardinalityWithSkip(cardinalityBeforeSkip, var10_8.queryPagination());
                                                cardinalityBeforeSelection = this.queryProjectionCardinalityWithLimit(cardinalityBeforeLimit, var10_8.queryPagination());
                                                var5_12 = this.queryProjectionCardinalityWithSelections(new CardinalityAndInput(cardinalityBeforeSelection, cardinalityAndInput.labelInfo(), cardinalityAndInput.relTypeInfo()), var10_8.selections(), semanticTable, indexPredicateProviderContext);
                                                break block7;
                                            }
                                            if (!(var9_7 instanceof UnwindProjection)) break block8;
                                            var14_13 = (UnwindProjection)var9_7;
                                            expression = var14_13.exp();
                                            var17_15 = false;
                                            var18_16 = null;
                                            var19_17 = expression;
                                            if (!(var19_17 instanceof ListLiteral)) break block9;
                                            var20_18 = (ListLiteral)var19_17;
                                            expressions = var20_18.expressions();
                                            var6_20 = new Multiplier((double)expressions.size());
                                            break block10;
                                        }
                                        if (!(var19_17 instanceof FunctionInvocation)) break block11;
                                        var17_15 = true;
                                        var18_16 = (FunctionInvocation)var19_17;
                                        var22_21 = var18_16.namespace();
                                        var23_22 = var18_16.functionName();
                                        var24_23 = var18_16.args();
                                        if (var22_21 == null || (var25_24 = var22_21.parts()) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(var26_25 = package$.MODULE$.Seq().unapplySeq((SeqOps)var25_24)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var26_25)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var26_25), 0) != 0 || var23_22 == null || !"range".equals(var27_26 = var23_22.name()) || var24_23 == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(var28_27 = package$.MODULE$.Seq().unapplySeq((SeqOps)var24_23)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var28_27)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var28_27), 2) != 0) break block11;
                                        from = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var28_27), 0);
                                        to = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var28_27), 1);
                                        if (!(from instanceof IntegerLiteral)) break block11;
                                        var31_30 = (IntegerLiteral)from;
                                        if (!(to instanceof IntegerLiteral)) break block11;
                                        var32_31 = (IntegerLiteral)to;
                                        diff = Predef$.MODULE$.Long2long(var32_31.value()) - Predef$.MODULE$.Long2long(var31_30.value()) + 1L;
                                        var6_20 = new Multiplier((double)Math.max(0L, diff));
                                        break block10;
                                    }
                                    if (!var17_15) ** GOTO lbl-1000
                                    var35_33 = var18_16.namespace();
                                    var36_34 = var18_16.functionName();
                                    var37_35 = var18_16.args();
                                    if (var35_33 == null || (var38_36 = var35_33.parts()) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(var39_37 = package$.MODULE$.Seq().unapplySeq((SeqOps)var38_36)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var39_37)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var39_37), 0) != 0 || var36_34 == null || !"range".equals(var40_38 = var36_34.name()) || var37_35 == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(var41_39 = package$.MODULE$.Seq().unapplySeq((SeqOps)var37_35)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var41_39)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var41_39), 3) != 0) ** GOTO lbl-1000
                                    from = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var41_39), 0);
                                    to = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var41_39), 1);
                                    step = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var41_39), 2);
                                    if (!(from instanceof IntegerLiteral)) ** GOTO lbl-1000
                                    var45_43 = (IntegerLiteral)from;
                                    if (!(to instanceof IntegerLiteral)) ** GOTO lbl-1000
                                    var46_44 = (IntegerLiteral)to;
                                    if (step instanceof IntegerLiteral) {
                                        var47_45 = (IntegerLiteral)step;
                                        diff = Predef$.MODULE$.Long2long(var46_44.value()) - Predef$.MODULE$.Long2long(var45_43.value());
                                        steps = diff / Predef$.MODULE$.Long2long(var47_45.value()) + 1L;
                                        var6_20 = new Multiplier((double)Math.max(0L, steps));
                                    } else lbl-1000:
                                    // 5 sources

                                    {
                                        var6_20 = PlannerDefaults$.MODULE$.DEFAULT_MULTIPLIER();
                                    }
                                }
                                multiplier = var6_20;
                                var5_12 = cardinalityAndInput.copy(cardinalityAndInput.cardinality().$times(multiplier), cardinalityAndInput.copy$default$2(), cardinalityAndInput.copy$default$3());
                                break block7;
                            }
                            if (!(var9_7 instanceof ProcedureCallProjection)) break block12;
                            var5_12 = cardinalityAndInput.copy(Cardinality$.MODULE$.max(cardinalityAndInput.cardinality().$times(PlannerDefaults$.MODULE$.DEFAULT_MULTIPLIER()), Cardinality$.MODULE$.lift(1.0)), cardinalityAndInput.copy$default$2(), cardinalityAndInput.copy$default$3());
                            break block7;
                        }
                        if (!(var9_7 instanceof CommandProjection)) break block13;
                        var5_12 = cardinalityAndInput.copy(Cardinality$.MODULE$.max(cardinalityAndInput.cardinality().$times(PlannerDefaults$.MODULE$.DEFAULT_MULTIPLIER()), Cardinality$.MODULE$.lift(1.0)), cardinalityAndInput.copy$default$2(), cardinalityAndInput.copy$default$3());
                        break block7;
                    }
                    if (!(var9_7 instanceof LoadCSVProjection)) break block14;
                    var5_12 = cardinalityAndInput.copy(Cardinality$.MODULE$.max(cardinalityAndInput.cardinality().$times(PlannerDefaults$.MODULE$.DEFAULT_MULTIPLIER()), Cardinality$.MODULE$.lift(1.0)), cardinalityAndInput.copy$default$2(), cardinalityAndInput.copy$default$3());
                    break block7;
                }
                if (!(var9_7 instanceof PassthroughAllHorizon)) break block15;
                var5_12 = cardinalityAndInput;
                break block7;
            }
            if (!(var9_7 instanceof CallSubqueryHorizon)) ** GOTO lbl-1000
            var7_5 = true;
            var8_6 = (CallSubqueryHorizon)var9_7;
            subquery = var8_6.callSubquery();
            var53_50 = var8_6.yielding();
            if (var53_50) {
                subQueryCardinality = this.apply(subquery, cardinalityAndInput.labelInfo(), cardinalityAndInput.relTypeInfo(), semanticTable, indexPredicateProviderContext);
                var5_12 = cardinalityAndInput.copy(cardinalityAndInput.cardinality().$times(subQueryCardinality), cardinalityAndInput.copy$default$2(), cardinalityAndInput.copy$default$3());
            } else if (var7_5 && !(var55_52 = var8_6.yielding())) {
                var5_12 = cardinalityAndInput;
            } else {
                throw new MatchError((Object)var9_7);
            }
        }
        return var5_12;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Cardinality queryProjectionCardinalityBeforeLimit(Cardinality in, QueryProjection projection2) {
        boolean bl = false;
        AggregatingQueryProjection aggregatingQueryProjection = null;
        QueryProjection queryProjection = projection2;
        if (queryProjection instanceof RegularQueryProjection) {
            return in;
        }
        if (queryProjection instanceof DistinctQueryProjection) {
            return in.$times(PlannerDefaults$.MODULE$.DEFAULT_DISTINCT_SELECTIVITY());
        }
        if (queryProjection instanceof AggregatingQueryProjection) {
            bl = true;
            aggregatingQueryProjection = (AggregatingQueryProjection)queryProjection;
            if (aggregatingQueryProjection.aggregationExpressions().isEmpty()) {
                return in.$times(PlannerDefaults$.MODULE$.DEFAULT_DISTINCT_SELECTIVITY());
            }
        }
        if (!bl) throw new MatchError((Object)queryProjection);
        return StatisticsBackedCardinalityModel$.MODULE$.aggregateCardinalityEstimation(in, (Map<String, Expression>)aggregatingQueryProjection.groupingExpressions());
    }

    private Cardinality queryProjectionCardinalityWithLimit(Cardinality cardinalityBeforeLimit, QueryPagination queryPagination) {
        Cardinality cardinality;
        Option option = queryPagination.limit();
        if (None$.MODULE$.equals(option)) {
            cardinality = cardinalityBeforeLimit;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Expression limitExpression = (Expression)some.value();
            long limitRowCount = BoxesRunTime.unboxToLong((Object)this.evaluateLongIfStable(limitExpression).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> PlannerDefaults$.MODULE$.DEFAULT_LIMIT_ROW_COUNT()));
            cardinality = (double)limitRowCount >= cardinalityBeforeLimit.amount() ? cardinalityBeforeLimit : new Cardinality((double)limitRowCount);
        } else {
            throw new MatchError((Object)option);
        }
        return cardinality;
    }

    private Cardinality queryProjectionCardinalityWithSkip(Cardinality cardinalityBeforeSkip, QueryPagination queryPagination) {
        Cardinality cardinality;
        Option option = queryPagination.skip();
        if (None$.MODULE$.equals(option)) {
            cardinality = cardinalityBeforeSkip;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Expression skipExpression = (Expression)some.value();
            long skipRowCount = BoxesRunTime.unboxToLong((Object)this.evaluateLongIfStable(skipExpression).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> PlannerDefaults$.MODULE$.DEFAULT_SKIP_ROW_COUNT()));
            cardinality = skipRowCount == 0L ? cardinalityBeforeSkip : ((double)skipRowCount >= cardinalityBeforeSkip.amount() ? Cardinality$.MODULE$.EMPTY() : cardinalityBeforeSkip.map((Function1)(JFunction1.mcDD.sp & Serializable)c -> c - (double)skipRowCount));
        } else {
            throw new MatchError((Object)option);
        }
        return cardinality;
    }

    private Option<Object> evaluateLongIfStable(Expression expression) {
        Object object;
        Expression expression2 = expression;
        if (expression2 instanceof IntegerLiteral) {
            IntegerLiteral integerLiteral = (IntegerLiteral)expression2;
            object = new Some((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(integerLiteral.value())));
        } else {
            object = this.isStable$1(expression2) ? this.simpleExpressionEvaluator.evaluateExpression(expression2).collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof NumberValue) {
                        NumberValue numberValue = (NumberValue)A1;
                        object = BoxesRunTime.boxToLong((long)numberValue.longValue());
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    boolean bl = object instanceof NumberValue;
                    return bl;
                }
            }) : None$.MODULE$;
        }
        return object;
    }

    private CardinalityAndInput queryProjectionCardinalityWithSelections(CardinalityAndInput inputBeforeSelection, Selections where, SemanticTable semanticTable, IndexCompatiblePredicatesProviderContext indexPredicateProviderContext) {
        Cardinality inboundCardinality = inputBeforeSelection.cardinality();
        CardinalityAndInput fusedInput = inputBeforeSelection.withFusedLabelInfo((Map<String, Set<LabelName>>)where.labelInfo());
        Selectivity whereSelectivity = this.selectivityCalculator.apply(where, fusedInput.labelInfo(), fusedInput.relTypeInfo(), semanticTable, indexPredicateProviderContext);
        Cardinality cardinality = inboundCardinality.$times(whereSelectivity);
        return new CardinalityAndInput(cardinality, fusedInput.labelInfo(), fusedInput.relTypeInfo());
    }

    private CardinalityAndInput calculateCardinalityForQueryGraph(QueryGraph graph, Map<String, Set<LabelName>> labelInfo, Map<String, RelTypeName> relTypeInfo, SemanticTable semanticTable, IndexCompatiblePredicatesProviderContext indexPredicateProviderContext) {
        Map<String, Set<LabelName>> fusedLabelInfo = MapSupport$.MODULE$.PowerMap(labelInfo).fuse((Map<String, Set<LabelName>>)graph.patternNodeLabels(), (Function2<Set<LabelName>, Set<LabelName>, Set<LabelName>>)(Function2 & Serializable)(x$2, x$3) -> (Set)x$2.$plus$plus((IterableOnce)x$3));
        Map fusedRelTypeInfo = (Map)relTypeInfo.$plus$plus((IterableOnce)graph.patternRelationshipTypes());
        Cardinality cardinality = this.queryGraphCardinalityModel.apply(graph, fusedLabelInfo, (Map<String, RelTypeName>)fusedRelTypeInfo, semanticTable, indexPredicateProviderContext);
        return new CardinalityAndInput(cardinality, fusedLabelInfo, (Map<String, RelTypeName>)fusedRelTypeInfo);
    }

    private final boolean isStable$1(Expression expression) {
        return !this.simpleExpressionEvaluator.hasParameters(expression) && this.simpleExpressionEvaluator.isDeterministic(expression);
    }

    public StatisticsBackedCardinalityModel(Metrics.QueryGraphCardinalityModel queryGraphCardinalityModel, Metrics.SelectivityCalculator selectivityCalculator, ExpressionEvaluator simpleExpressionEvaluator2) {
        this.queryGraphCardinalityModel = queryGraphCardinalityModel;
        this.selectivityCalculator = selectivityCalculator;
        this.simpleExpressionEvaluator = simpleExpressionEvaluator2;
    }

    public static class CardinalityAndInput
    implements Product,
    Serializable {
        private final Cardinality cardinality;
        private final Map<String, Set<LabelName>> labelInfo;
        private final Map<String, RelTypeName> relTypeInfo;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Cardinality cardinality() {
            return this.cardinality;
        }

        public Map<String, Set<LabelName>> labelInfo() {
            return this.labelInfo;
        }

        public Map<String, RelTypeName> relTypeInfo() {
            return this.relTypeInfo;
        }

        public CardinalityAndInput withFusedLabelInfo(Map<String, Set<LabelName>> newLabelInfo) {
            Map<String, Set<LabelName>> x$1 = MapSupport$.MODULE$.PowerMap(this.labelInfo()).fuse(newLabelInfo, (Function2<Set<LabelName>, Set<LabelName>, Set<LabelName>>)(Function2 & Serializable)(x$4, x$5) -> (Set)x$4.$plus$plus((IterableOnce)x$5));
            Cardinality x$2 = this.copy$default$1();
            Map<String, RelTypeName> x$3 = this.copy$default$3();
            return this.copy(x$2, x$1, x$3);
        }

        public CardinalityAndInput withFusedRelTypeInfo(Map<String, RelTypeName> newRelTypeInfo) {
            Map x$1 = (Map)this.relTypeInfo().$plus$plus(newRelTypeInfo);
            Cardinality x$2 = this.copy$default$1();
            Map<String, Set<LabelName>> x$3 = this.copy$default$2();
            return this.copy(x$2, x$3, (Map<String, RelTypeName>)x$1);
        }

        public CardinalityAndInput copy(Cardinality cardinality, Map<String, Set<LabelName>> labelInfo, Map<String, RelTypeName> relTypeInfo) {
            return new CardinalityAndInput(cardinality, labelInfo, relTypeInfo);
        }

        public Cardinality copy$default$1() {
            return this.cardinality();
        }

        public Map<String, Set<LabelName>> copy$default$2() {
            return this.labelInfo();
        }

        public Map<String, RelTypeName> copy$default$3() {
            return this.relTypeInfo();
        }

        public String productPrefix() {
            return "CardinalityAndInput";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            return switch (n) {
                case 0 -> this.cardinality();
                case 1 -> this.labelInfo();
                case 2 -> this.relTypeInfo();
                default -> Statics.ioobe((int)x$1);
            };
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CardinalityAndInput;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            return switch (n) {
                case 0 -> "cardinality";
                case 1 -> "labelInfo";
                case 2 -> "relTypeInfo";
                default -> (String)Statics.ioobe((int)x$1);
            };
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CardinalityAndInput)) return false;
            boolean bl = true;
            if (!bl) return false;
            CardinalityAndInput cardinalityAndInput = (CardinalityAndInput)x$1;
            Cardinality cardinality = this.cardinality();
            Cardinality cardinality2 = cardinalityAndInput.cardinality();
            if (cardinality == null) {
                if (cardinality2 != null) {
                    return false;
                }
            } else if (!cardinality.equals(cardinality2)) return false;
            Map<String, Set<LabelName>> map2 = this.labelInfo();
            Map<String, Set<LabelName>> map3 = cardinalityAndInput.labelInfo();
            if (map2 == null) {
                if (map3 != null) {
                    return false;
                }
            } else if (!map2.equals(map3)) return false;
            Map<String, RelTypeName> map4 = this.relTypeInfo();
            Map<String, RelTypeName> map5 = cardinalityAndInput.relTypeInfo();
            if (map4 == null) {
                if (map5 != null) {
                    return false;
                }
            } else if (!map4.equals(map5)) return false;
            if (!cardinalityAndInput.canEqual(this)) return false;
            return true;
        }

        public CardinalityAndInput(Cardinality cardinality, Map<String, Set<LabelName>> labelInfo, Map<String, RelTypeName> relTypeInfo) {
            this.cardinality = cardinality;
            this.labelInfo = labelInfo;
            this.relTypeInfo = relTypeInfo;
            Product.$init$((Product)this);
        }
    }
}

