/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical.steps.index;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.semantics.SemanticTable;
import org.neo4j.cypher.internal.compiler.planner.logical.LeafPlanRestrictions;
import org.neo4j.cypher.internal.compiler.planner.logical.ordering.InterestingOrderConfig;
import org.neo4j.cypher.internal.compiler.planner.logical.ordering.InterestingOrderConfig$;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.index.EntityIndexLeafPlanner;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.index.EntityIndexLeafPlanner$;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.index.IndexCompatiblePredicatesProvider;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.index.IndexCompatiblePredicatesProviderContext;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.index.RelationshipIndexLeafPlanner;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.index.RelationshipIndexPlanProvider;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.LogicalVariable;
import org.neo4j.cypher.internal.expressions.RelTypeName;
import org.neo4j.cypher.internal.ir.PatternLength;
import org.neo4j.cypher.internal.ir.PatternRelationship;
import org.neo4j.cypher.internal.ir.QueryGraph;
import org.neo4j.cypher.internal.ir.SimplePatternLength$;
import org.neo4j.cypher.internal.ir.ordering.NoProvidedOrderFactory$;
import org.neo4j.cypher.internal.ir.ordering.ProvidedOrderFactory;
import org.neo4j.cypher.internal.planner.spi.IndexDescriptor;
import org.neo4j.cypher.internal.planner.spi.PlanContext;
import org.neo4j.cypher.internal.util.NameId;
import org.neo4j.cypher.internal.util.NameId$;
import org.neo4j.cypher.internal.util.RelTypeId;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.package$;

public final class RelationshipIndexLeafPlanner$
implements IndexCompatiblePredicatesProvider,
scala.Serializable {
    public static RelationshipIndexLeafPlanner$ MODULE$;

    static {
        new RelationshipIndexLeafPlanner$();
    }

    @Override
    public Set<EntityIndexLeafPlanner.IndexCompatiblePredicate> findIndexCompatiblePredicates(Set<Expression> predicates, Set<String> argumentIds, SemanticTable semanticTable, PlanContext planContext, IndexCompatiblePredicatesProviderContext indexPredicateProviderContext) {
        return IndexCompatiblePredicatesProvider.findIndexCompatiblePredicates$(this, predicates, argumentIds, semanticTable, planContext, indexPredicateProviderContext);
    }

    public Set<RelationshipIndexLeafPlanner.RelationshipIndexMatch> findIndexMatchesForQueryGraph(QueryGraph qg, SemanticTable semanticTable, PlanContext planContext, IndexCompatiblePredicatesProviderContext indexPredicateProviderContext, InterestingOrderConfig interestingOrderConfig, ProvidedOrderFactory providedOrderFactory, boolean planningTextIndexesEnabled) {
        Iterable iterable;
        Set predicates = qg.selections().flatPredicatesSet();
        Map patternRelationshipsMap = ((TraversableOnce)qg.patternRelationships().collect((PartialFunction)new scala.Serializable(qg){
            public static final long serialVersionUID = 0L;
            private final QueryGraph qg$2;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends PatternRelationship, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    String name = A1.name();
                    Seq seq = A1.types();
                    PatternLength patternLength = A1.length();
                    Some some = Seq$.MODULE$.unapplySeq(seq);
                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && SimplePatternLength$.MODULE$.equals(patternLength) && !RelationshipIndexLeafPlanner$.org$neo4j$cypher$internal$compiler$planner$logical$steps$index$RelationshipIndexLeafPlanner$$shouldIgnore$1(A1, this.qg$2)) {
                        object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), A1);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(PatternRelationship x1) {
                PatternRelationship patternRelationship = x1;
                if (patternRelationship == null) return false;
                Seq seq = patternRelationship.types();
                PatternLength patternLength = patternRelationship.length();
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (some.isEmpty()) return false;
                if (some.get() == null) return false;
                if (((SeqLike)some.get()).lengthCompare(1) != 0) return false;
                if (!SimplePatternLength$.MODULE$.equals(patternLength)) return false;
                if (RelationshipIndexLeafPlanner$.org$neo4j$cypher$internal$compiler$planner$logical$steps$index$RelationshipIndexLeafPlanner$$shouldIgnore$1(patternRelationship, this.qg$2)) return false;
                return true;
            }
            {
                this.qg$2 = qg$2;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        if (patternRelationshipsMap.isEmpty()) {
            iterable = (Iterable)Nil$.MODULE$;
        } else {
            Set<EntityIndexLeafPlanner.IndexCompatiblePredicate> compatiblePropertyPredicates = this.findIndexCompatiblePredicates((Set<Expression>)predicates, (Set<String>)qg.argumentIds(), semanticTable, planContext, indexPredicateProviderContext, (Iterable<PatternRelationship>)patternRelationshipsMap.values());
            iterable = (Iterable)((TraversableLike)compatiblePropertyPredicates.groupBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name()).map((Function1 & Serializable & scala.Serializable)propertyPredicates -> {
                String variableName = (String)propertyPredicates._1();
                return new Tuple2(propertyPredicates, (Object)variableName);
            }, Map$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> {
                Tuple2 tuple2 = x$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Tuple2 propertyPredicates = (Tuple2)tuple2._1();
                String variableName = (String)tuple2._2();
                Set set = (Set)Option$.MODULE$.option2Iterable(patternRelationshipsMap.get((Object)variableName)).toSet().flatMap((Function1 & Serializable & scala.Serializable)patternRelationship -> (Set)MODULE$.findIndexMatches(variableName, (Set<EntityIndexLeafPlanner.IndexCompatiblePredicate>)((Set)propertyPredicates._2()), (PatternRelationship)patternRelationship, interestingOrderConfig, semanticTable, planContext, providedOrderFactory, planningTextIndexesEnabled).map((Function1 & Serializable & scala.Serializable)indexMatch -> indexMatch, Set$.MODULE$.canBuildFrom()), Set$.MODULE$.canBuildFrom());
                return set;
            }, Iterable$.MODULE$.canBuildFrom());
        }
        Iterable indexMatches = iterable;
        return indexMatches.toSet();
    }

    private Set<EntityIndexLeafPlanner.IndexCompatiblePredicate> findIndexCompatiblePredicates(Set<Expression> predicates, Set<String> argumentIds, SemanticTable semanticTable, PlanContext planContext, IndexCompatiblePredicatesProviderContext indexPredicateProviderContext, Iterable<PatternRelationship> patterns) {
        Set<EntityIndexLeafPlanner.IndexCompatiblePredicate> generalCompatiblePredicates = this.findIndexCompatiblePredicates(predicates, argumentIds, semanticTable, planContext, indexPredicateProviderContext);
        return (Set)generalCompatiblePredicates.$plus$plus((GenTraversableOnce)patterns.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            PatternRelationship patternRelationship = x0$1;
            if (patternRelationship == null) return Predef$.MODULE$.Set().empty();
            String name = patternRelationship.name();
            Seq seq = patternRelationship.types();
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty()) return Predef$.MODULE$.Set().empty();
            if (some.get() == null) return Predef$.MODULE$.Set().empty();
            if (((SeqLike)some.get()).lengthCompare(1) != 0) return Predef$.MODULE$.Set().empty();
            RelTypeName relTypeName = (RelTypeName)((SeqLike)some.get()).apply(0);
            if (relTypeName == null) return Predef$.MODULE$.Set().empty();
            String relTypeName2 = relTypeName.name();
            if (!RelationshipIndexLeafPlanner$.valid$1(relTypeName2, argumentIds)) return Predef$.MODULE$.Set().empty();
            Set constrainedPropNames = indexPredicateProviderContext.outerPlanHasUpdates() || planContext.txStateHasChanges() ? Predef$.MODULE$.Set().empty() : planContext.getRelationshipPropertiesWithExistenceConstraint(relTypeName2);
            return EntityIndexLeafPlanner$.MODULE$.implicitIsNotNullPredicates(EntityIndexLeafPlanner$.MODULE$.variable(name), indexPredicateProviderContext.aggregatingProperties(), (Set<String>)constrainedPropNames, generalCompatiblePredicates);
        }, scala.collection.Iterable$.MODULE$.canBuildFrom()));
    }

    private Set<RelationshipIndexLeafPlanner.RelationshipIndexMatch> findIndexMatches(String variableName, Set<EntityIndexLeafPlanner.IndexCompatiblePredicate> propertyPredicates, PatternRelationship patternRelationship, InterestingOrderConfig interestingOrderConfig, SemanticTable semanticTable, PlanContext planContext, ProvidedOrderFactory providedOrderFactory, boolean planningTextIndexesEnabled) {
        RelTypeName relTypeName = (RelTypeName)patternRelationship.types().head();
        Set indexMatches = (Set)Option$.MODULE$.option2Iterable(semanticTable.id(relTypeName)).toSet().flatMap((Function1 & Serializable & scala.Serializable)relTypeId -> MODULE$.indexDescriptorsForRelType((RelTypeId)relTypeId, planContext, planningTextIndexesEnabled).flatMap((Function1 & Serializable & scala.Serializable)indexDescriptor -> (Set)EntityIndexLeafPlanner$.MODULE$.predicatesForIndex((IndexDescriptor)indexDescriptor, propertyPredicates, interestingOrderConfig, semanticTable, providedOrderFactory).map((Function1 & Serializable & scala.Serializable)predicatesForIndex -> new RelationshipIndexLeafPlanner.RelationshipIndexMatch(variableName, patternRelationship, relTypeName, (RelTypeId)relTypeId, predicatesForIndex.predicatesInOrder(), predicatesForIndex.providedOrder(), predicatesForIndex.indexOrder(), (IndexDescriptor)indexDescriptor), Set$.MODULE$.canBuildFrom())), Set$.MODULE$.canBuildFrom());
        return indexMatches;
    }

    public InterestingOrderConfig findIndexMatchesForQueryGraph$default$5() {
        return InterestingOrderConfig$.MODULE$.empty();
    }

    public ProvidedOrderFactory findIndexMatchesForQueryGraph$default$6() {
        return NoProvidedOrderFactory$.MODULE$;
    }

    private Iterator<IndexDescriptor> indexDescriptorsForRelType(RelTypeId relTypeId, PlanContext planContext, boolean planningTextIndexesEnabled) {
        return planContext.btreeIndexesGetForRelType(NameId$.MODULE$.toKernelEncode((NameId)relTypeId)).$plus$plus((Function0 & Serializable & scala.Serializable)() -> planningTextIndexesEnabled ? planContext.textIndexesGetForRelType(NameId$.MODULE$.toKernelEncode((NameId)relTypeId)) : package$.MODULE$.Iterator().empty());
    }

    @Override
    public Set<EntityIndexLeafPlanner.IndexCompatiblePredicate> implicitIndexCompatiblePredicates(PlanContext planContext, IndexCompatiblePredicatesProviderContext indexPredicateProviderContext, Set<Expression> predicates, Set<EntityIndexLeafPlanner.IndexCompatiblePredicate> explicitCompatiblePredicates, Function2<LogicalVariable, Set<LogicalVariable>, Object> valid) {
        return Predef$.MODULE$.Set().empty();
    }

    public RelationshipIndexLeafPlanner apply(Seq<RelationshipIndexPlanProvider> planProviders, LeafPlanRestrictions restrictions) {
        return new RelationshipIndexLeafPlanner(planProviders, restrictions);
    }

    public Option<Tuple2<Seq<RelationshipIndexPlanProvider>, LeafPlanRestrictions>> unapply(RelationshipIndexLeafPlanner x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2(x$0.planProviders(), (Object)x$0.restrictions()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final boolean org$neo4j$cypher$internal$compiler$planner$logical$steps$index$RelationshipIndexLeafPlanner$$shouldIgnore$1(PatternRelationship pattern, QueryGraph qg$2) {
        String string = pattern.left();
        String string2 = pattern.right();
        return !(string == null ? string2 != null : !string.equals(string2)) || ((TraversableOnce)pattern.coveredIds().intersect((GenSet)qg$2.argumentIds())).nonEmpty();
    }

    private static final boolean valid$1(String variableName, Set argumentIds$1) {
        return !argumentIds$1.contains((Object)variableName);
    }

    private RelationshipIndexLeafPlanner$() {
        MODULE$ = this;
        IndexCompatiblePredicatesProvider.$init$(this);
    }
}

