/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.CommandClause;
import org.neo4j.cypher.internal.compiler.planner.ProcedureCallProjection;
import org.neo4j.cypher.internal.compiler.planner.logical.CandidateSelector;
import org.neo4j.cypher.internal.compiler.planner.logical.EagerAnalyzer;
import org.neo4j.cypher.internal.compiler.planner.logical.EventHorizonPlanner;
import org.neo4j.cypher.internal.compiler.planner.logical.LogicalPlanningContext;
import org.neo4j.cypher.internal.compiler.planner.logical.SortPlanner$;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.BestResults;
import org.neo4j.cypher.internal.compiler.planner.logical.ordering.InterestingOrderConfig;
import org.neo4j.cypher.internal.compiler.planner.logical.ordering.InterestingOrderConfig$;
import org.neo4j.cypher.internal.compiler.planner.logical.plannerQueryPartPlanner$;
import org.neo4j.cypher.internal.compiler.planner.logical.plans.rewriter.unnestApply;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.aggregation$;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.distinct$;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.projection$;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.skipAndLimit$;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.StringLiteral;
import org.neo4j.cypher.internal.ir.AggregatingQueryProjection;
import org.neo4j.cypher.internal.ir.CSVFormat;
import org.neo4j.cypher.internal.ir.CallSubqueryHorizon;
import org.neo4j.cypher.internal.ir.CommandProjection;
import org.neo4j.cypher.internal.ir.DistinctQueryProjection;
import org.neo4j.cypher.internal.ir.LoadCSVProjection;
import org.neo4j.cypher.internal.ir.PassthroughAllHorizon;
import org.neo4j.cypher.internal.ir.PlannerQueryPart;
import org.neo4j.cypher.internal.ir.QueryHorizon;
import org.neo4j.cypher.internal.ir.RegularQueryProjection;
import org.neo4j.cypher.internal.ir.SinglePlannerQuery;
import org.neo4j.cypher.internal.ir.UnwindProjection;
import org.neo4j.cypher.internal.ir.ordering.InterestingOrder;
import org.neo4j.cypher.internal.logical.plans.Argument;
import org.neo4j.cypher.internal.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.logical.plans.ResolvedCall;
import org.neo4j.cypher.internal.util.AssertionRunner;
import org.neo4j.cypher.internal.util.Rewritable;
import org.neo4j.cypher.internal.util.Rewritable$;
import org.neo4j.cypher.internal.util.attribution.Attribute;
import org.neo4j.cypher.internal.util.attribution.Attributes;
import org.neo4j.exceptions.InternalException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.runtime.ScalaRunTime$;

public final class PlanEventHorizon$
implements EventHorizonPlanner,
Product,
scala.Serializable {
    public static PlanEventHorizon$ MODULE$;

    static {
        new PlanEventHorizon$();
    }

    @Override
    public final BestResults<LogicalPlan> planHorizon(SinglePlannerQuery plannerQuery, BestResults<LogicalPlan> incomingPlans, Option<InterestingOrder> prevInterestingOrder, LogicalPlanningContext context) {
        return EventHorizonPlanner.planHorizon$(this, plannerQuery, incomingPlans, prevInterestingOrder, context);
    }

    @Override
    public BestResults<LogicalPlan> doPlanHorizon(SinglePlannerQuery plannerQuery, BestResults<LogicalPlan> incomingPlans, Option<InterestingOrder> prevInterestingOrder, LogicalPlanningContext context) {
        BestResults<LogicalPlan> bestResults;
        boolean tailHasRequiredOrder;
        CandidateSelector pickBest = context.config().pickBestCandidate().apply(context);
        InterestingOrderConfig sortIfSelfRequiredConfig = InterestingOrderConfig$.MODULE$.apply(plannerQuery.interestingOrder());
        InterestingOrderConfig sortIfTailOrSelfRequiredConfig = InterestingOrderConfig$.MODULE$.interestingOrderForPart(plannerQuery, false, true, context.debugOptions().disallowSplittingTopEnabled());
        unnestApply unnest = new unnestApply(context.planningAttributes().solveds(), context.planningAttributes().cardinalities(), context.planningAttributes().providedOrders(), (Attributes<LogicalPlan>)new Attributes(context.idGen(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[0])));
        Function1 & Serializable & scala.Serializable costProjection = (Function1 & Serializable & scala.Serializable)lp -> (LogicalPlan)Rewritable.RewritableAny$.MODULE$.endoRewrite$extension(Rewritable$.MODULE$.RewritableAny(lp), (Function1)unnest);
        boolean currentPartHasRequiredOrder = plannerQuery.interestingOrder().requiredOrderCandidate().nonEmpty();
        InterestingOrderConfig interestingOrderConfig = sortIfSelfRequiredConfig;
        InterestingOrderConfig interestingOrderConfig2 = sortIfTailOrSelfRequiredConfig;
        boolean bl = (interestingOrderConfig == null ? interestingOrderConfig2 != null : !((Object)interestingOrderConfig).equals(interestingOrderConfig2)) ? true : (tailHasRequiredOrder = false);
        if (currentPartHasRequiredOrder) {
            LogicalPlan bestOverall;
            Option option = pickBest.apply((Iterable)((TraversableLike)new .colon.colon((Object)this.planSortIfSelfRequired$1(plannerQuery, incomingPlans, prevInterestingOrder, context, sortIfSelfRequiredConfig), (List)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(PlanEventHorizon$.maintainSort$1(incomingPlans, plannerQuery, prevInterestingOrder, context, sortIfTailOrSelfRequiredConfig)), Seq$.MODULE$.canBuildFrom()), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "best overall plan with horizon");
            if (!(option instanceof Some)) {
                throw new MatchError(option);
            }
            Some some = (Some)option;
            LogicalPlan logicalPlan = bestOverall = (LogicalPlan)some.value();
            LogicalPlan bestOverall2 = logicalPlan;
            bestResults = new BestResults<LogicalPlan>(bestOverall2, (Option<LogicalPlan>)None$.MODULE$);
        } else if (tailHasRequiredOrder) {
            LogicalPlan bestOverall = this.planSortIfSelfRequired$1(plannerQuery, incomingPlans, prevInterestingOrder, context, sortIfSelfRequiredConfig);
            Option bestSorted = pickBest.apply(costProjection, (Iterable)((TraversableLike)new .colon.colon((Object)this.planSortIfTailOrSelfRequired$1(plannerQuery, incomingPlans, prevInterestingOrder, context, sortIfTailOrSelfRequiredConfig), (List)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(PlanEventHorizon$.maintainSort$1(incomingPlans, plannerQuery, prevInterestingOrder, context, sortIfTailOrSelfRequiredConfig)), Seq$.MODULE$.canBuildFrom()), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "best sorted plan with horizon");
            bestResults = new BestResults<LogicalPlan>(bestOverall, bestSorted);
        } else {
            LogicalPlan bestOverall = this.planSortIfSelfRequired$1(plannerQuery, incomingPlans, prevInterestingOrder, context, sortIfSelfRequiredConfig);
            bestResults = new BestResults<LogicalPlan>(bestOverall, (Option<LogicalPlan>)None$.MODULE$);
        }
        return bestResults;
    }

    public LogicalPlan planHorizonForPlan(SinglePlannerQuery query, LogicalPlan plan, Option<InterestingOrder> previousInterestingOrder, LogicalPlanningContext context, InterestingOrderConfig interestingOrderConfig) {
        LogicalPlan logicalPlan;
        LogicalPlan selectedPlan = context.config().applySelections().apply(plan, query.queryGraph(), interestingOrderConfig, context);
        boolean updateSolvedOrdering = query.interestingOrder().requiredOrderCandidate().nonEmpty();
        QueryHorizon queryHorizon = query.horizon();
        if (queryHorizon instanceof AggregatingQueryProjection) {
            LogicalPlan logicalPlan2;
            AggregatingQueryProjection aggregatingQueryProjection = (AggregatingQueryProjection)queryHorizon;
            LogicalPlan aggregationPlan = aggregation$.MODULE$.apply(selectedPlan, aggregatingQueryProjection, interestingOrderConfig.orderToReport(), previousInterestingOrder, context);
            LogicalPlan sorted = SortPlanner$.MODULE$.ensureSortedPlanWithSolved(aggregationPlan, interestingOrderConfig, context, updateSolvedOrdering);
            LogicalPlan limited = skipAndLimit$.MODULE$.apply(sorted, query, context);
            if (aggregatingQueryProjection.selections().isEmpty()) {
                logicalPlan2 = limited;
            } else {
                Seq predicates = aggregatingQueryProjection.selections().flatPredicates();
                logicalPlan2 = context.logicalPlanProducer().planHorizonSelection(limited, (Seq<Expression>)predicates, interestingOrderConfig, context);
            }
            logicalPlan = logicalPlan2;
        } else if (queryHorizon instanceof RegularQueryProjection) {
            LogicalPlan logicalPlan3;
            LogicalPlan projected;
            RegularQueryProjection regularQueryProjection = (RegularQueryProjection)queryHorizon;
            LogicalPlan sorted = SortPlanner$.MODULE$.ensureSortedPlanWithSolved(selectedPlan, interestingOrderConfig, context, updateSolvedOrdering);
            LogicalPlan limited = skipAndLimit$.MODULE$.apply(sorted, query, context);
            LogicalPlan logicalPlan4 = projected = regularQueryProjection.projections().isEmpty() && query.tail().isEmpty() ? context.logicalPlanProducer().planEmptyProjection(plan, context) : projection$.MODULE$.apply(limited, (Map<String, Expression>)regularQueryProjection.projections(), (Option<Map<String, Expression>>)new Some((Object)regularQueryProjection.projections()), context);
            if (regularQueryProjection.selections().isEmpty()) {
                logicalPlan3 = projected;
            } else {
                Seq predicates = regularQueryProjection.selections().flatPredicates();
                logicalPlan3 = context.logicalPlanProducer().planHorizonSelection(projected, (Seq<Expression>)predicates, interestingOrderConfig, context);
            }
            logicalPlan = logicalPlan3;
        } else if (queryHorizon instanceof DistinctQueryProjection) {
            LogicalPlan logicalPlan5;
            DistinctQueryProjection distinctQueryProjection = (DistinctQueryProjection)queryHorizon;
            LogicalPlan distinctPlan = distinct$.MODULE$.apply(selectedPlan, distinctQueryProjection, context);
            LogicalPlan sorted = SortPlanner$.MODULE$.ensureSortedPlanWithSolved(distinctPlan, interestingOrderConfig, context, updateSolvedOrdering);
            LogicalPlan limited = skipAndLimit$.MODULE$.apply(sorted, query, context);
            if (distinctQueryProjection.selections().isEmpty()) {
                logicalPlan5 = limited;
            } else {
                Seq predicates = distinctQueryProjection.selections().flatPredicates();
                logicalPlan5 = context.logicalPlanProducer().planHorizonSelection(limited, (Seq<Expression>)predicates, interestingOrderConfig, context);
            }
            logicalPlan = logicalPlan5;
        } else if (queryHorizon instanceof UnwindProjection) {
            UnwindProjection unwindProjection = (UnwindProjection)queryHorizon;
            String variable = unwindProjection.variable();
            Expression expression = unwindProjection.exp();
            LogicalPlan projected = context.logicalPlanProducer().planUnwind(selectedPlan, variable, expression, context);
            logicalPlan = SortPlanner$.MODULE$.ensureSortedPlanWithSolved(projected, interestingOrderConfig, context, updateSolvedOrdering);
        } else if (queryHorizon instanceof ProcedureCallProjection) {
            ProcedureCallProjection procedureCallProjection = (ProcedureCallProjection)queryHorizon;
            ResolvedCall call = procedureCallProjection.call();
            LogicalPlan projected = context.logicalPlanProducer().planProcedureCall(plan, call, context);
            logicalPlan = SortPlanner$.MODULE$.ensureSortedPlanWithSolved(projected, interestingOrderConfig, context, updateSolvedOrdering);
        } else if (queryHorizon instanceof LoadCSVProjection) {
            LoadCSVProjection loadCSVProjection = (LoadCSVProjection)queryHorizon;
            String variableName = loadCSVProjection.variable();
            Expression url = loadCSVProjection.url();
            CSVFormat format = loadCSVProjection.format();
            Option fieldTerminator = loadCSVProjection.fieldTerminator();
            LogicalPlan projected = context.logicalPlanProducer().planLoadCSV(plan, variableName, url, format, (Option<StringLiteral>)fieldTerminator, context);
            logicalPlan = SortPlanner$.MODULE$.ensureSortedPlanWithSolved(projected, interestingOrderConfig, context, updateSolvedOrdering);
        } else if (queryHorizon instanceof PassthroughAllHorizon) {
            LogicalPlan projected = context.logicalPlanProducer().planPassAll(plan, context);
            logicalPlan = SortPlanner$.MODULE$.ensureSortedPlanWithSolved(projected, interestingOrderConfig, context, updateSolvedOrdering);
        } else if (queryHorizon instanceof CallSubqueryHorizon) {
            CallSubqueryHorizon callSubqueryHorizon = (CallSubqueryHorizon)queryHorizon;
            PlannerQueryPart callSubquery = callSubqueryHorizon.callSubquery();
            boolean correlated = callSubqueryHorizon.correlated();
            LogicalPlanningContext subqueryContext = correlated ? context.forSubquery().withUpdatedLabelInfo(plan) : context.forSubquery();
            LogicalPlan subPlan = plannerQueryPartPlanner$.MODULE$.plan(callSubquery, subqueryContext, plannerQueryPartPlanner$.MODULE$.plan$default$3());
            LogicalPlan projected = context.logicalPlanProducer().planSubquery(plan, subPlan, context, correlated);
            logicalPlan = SortPlanner$.MODULE$.ensureSortedPlanWithSolved(projected, interestingOrderConfig, context, updateSolvedOrdering);
        } else if (queryHorizon instanceof CommandProjection) {
            CommandProjection commandProjection = (CommandProjection)queryHorizon;
            CommandClause clause = commandProjection.clause();
            if (AssertionRunner.ASSERTIONS_ENABLED) {
                boolean bl;
                LogicalPlan logicalPlan6 = plan;
                if (logicalPlan6 instanceof Argument) {
                    Argument argument = (Argument)logicalPlan6;
                    Set args = argument.argumentIds();
                    bl = args.isEmpty();
                } else {
                    bl = false;
                }
                if (!bl) {
                    throw new AssertionError((Object)"Command projections should only be planned as if they were leaf plans.");
                }
            }
            LogicalPlan commandPlan = context.logicalPlanProducer().planCommand(clause, context);
            logicalPlan = SortPlanner$.MODULE$.ensureSortedPlanWithSolved(commandPlan, interestingOrderConfig, context, updateSolvedOrdering);
        } else {
            throw new InternalException(new StringBuilder(39).append("Received QG with unknown horizon type: ").append(query.horizon()).toString());
        }
        LogicalPlan projectedPlan = logicalPlan;
        EagerAnalyzer eagerAnalyzer = new EagerAnalyzer(context);
        return eagerAnalyzer.horizonEagerize(projectedPlan, query);
    }

    public String productPrefix() {
        return "PlanEventHorizon";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof PlanEventHorizon$;
    }

    public int hashCode() {
        return -120284278;
    }

    public String toString() {
        return "PlanEventHorizon";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final LogicalPlan planSortIfSelfRequired$1(SinglePlannerQuery plannerQuery$1, BestResults incomingPlans$1, Option prevInterestingOrder$1, LogicalPlanningContext context$1, InterestingOrderConfig sortIfSelfRequiredConfig$1) {
        return this.planHorizonForPlan(plannerQuery$1, (LogicalPlan)incomingPlans$1.bestResult(), (Option<InterestingOrder>)prevInterestingOrder$1, context$1, sortIfSelfRequiredConfig$1);
    }

    private final LogicalPlan planSortIfTailOrSelfRequired$1(SinglePlannerQuery plannerQuery$1, BestResults incomingPlans$1, Option prevInterestingOrder$1, LogicalPlanningContext context$1, InterestingOrderConfig sortIfTailOrSelfRequiredConfig$1) {
        return this.planHorizonForPlan(plannerQuery$1, (LogicalPlan)incomingPlans$1.bestResult(), (Option<InterestingOrder>)prevInterestingOrder$1, context$1, sortIfTailOrSelfRequiredConfig$1);
    }

    private static final Option maintainSort$1(BestResults incomingPlans$1, SinglePlannerQuery plannerQuery$1, Option prevInterestingOrder$1, LogicalPlanningContext context$1, InterestingOrderConfig sortIfTailOrSelfRequiredConfig$1) {
        return incomingPlans$1.bestResultFulfillingReq().map((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.planHorizonForPlan(plannerQuery$1, (LogicalPlan)x$1, (Option<InterestingOrder>)prevInterestingOrder$1, context$1, sortIfTailOrSelfRequiredConfig$1));
    }

    private PlanEventHorizon$() {
        MODULE$ = this;
        EventHorizonPlanner.$init$(this);
        Product.$init$((Product)this);
    }
}

