/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical;

import java.io.Serializable;
import org.neo4j.cypher.internal.compiler.planner.logical.CardinalityCostModel$ApplyVariants$;
import org.neo4j.cypher.internal.compiler.planner.logical.CardinalityCostModel$HashJoin$;
import org.neo4j.cypher.internal.compiler.planner.logical.Metrics;
import org.neo4j.cypher.internal.expressions.Ands;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.HasLabels;
import org.neo4j.cypher.internal.expressions.Property;
import org.neo4j.cypher.internal.ir.LazyMode$;
import org.neo4j.cypher.internal.ir.Strictness;
import org.neo4j.cypher.internal.ir.StrictnessMode;
import org.neo4j.cypher.internal.logical.plans.AbstractLetSemiApply;
import org.neo4j.cypher.internal.logical.plans.AbstractSemiApply;
import org.neo4j.cypher.internal.logical.plans.AggregatingPlan;
import org.neo4j.cypher.internal.logical.plans.AllNodesScan;
import org.neo4j.cypher.internal.logical.plans.Argument;
import org.neo4j.cypher.internal.logical.plans.CartesianProduct;
import org.neo4j.cypher.internal.logical.plans.DirectedRelationshipByIdSeek;
import org.neo4j.cypher.internal.logical.plans.Expand;
import org.neo4j.cypher.internal.logical.plans.ExpandInto$;
import org.neo4j.cypher.internal.logical.plans.ExpansionMode;
import org.neo4j.cypher.internal.logical.plans.FindShortestPaths;
import org.neo4j.cypher.internal.logical.plans.LeftOuterHashJoin;
import org.neo4j.cypher.internal.logical.plans.Limit;
import org.neo4j.cypher.internal.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.logical.plans.NodeByIdSeek;
import org.neo4j.cypher.internal.logical.plans.NodeByLabelScan;
import org.neo4j.cypher.internal.logical.plans.NodeHashJoin;
import org.neo4j.cypher.internal.logical.plans.NodeIndexContainsScan;
import org.neo4j.cypher.internal.logical.plans.NodeIndexEndsWithScan;
import org.neo4j.cypher.internal.logical.plans.NodeIndexScan;
import org.neo4j.cypher.internal.logical.plans.NodeIndexSeek;
import org.neo4j.cypher.internal.logical.plans.NodeUniqueIndexSeek;
import org.neo4j.cypher.internal.logical.plans.Optional;
import org.neo4j.cypher.internal.logical.plans.ProcedureCall;
import org.neo4j.cypher.internal.logical.plans.ProjectEndpoints;
import org.neo4j.cypher.internal.logical.plans.RightOuterHashJoin;
import org.neo4j.cypher.internal.logical.plans.Selection;
import org.neo4j.cypher.internal.logical.plans.Skip;
import org.neo4j.cypher.internal.logical.plans.Sort;
import org.neo4j.cypher.internal.logical.plans.UndirectedRelationshipByIdSeek;
import org.neo4j.cypher.internal.logical.plans.Union;
import org.neo4j.cypher.internal.logical.plans.UnwindCollection;
import org.neo4j.cypher.internal.logical.plans.ValueHashJoin;
import org.neo4j.cypher.internal.logical.plans.VarExpand;
import org.neo4j.cypher.internal.planner.spi.PlanningAttributes;
import org.neo4j.cypher.internal.util.Cardinality;
import org.neo4j.cypher.internal.util.Cardinality$;
import org.neo4j.cypher.internal.util.Cost;
import org.neo4j.cypher.internal.util.CostPerRow;
import org.neo4j.cypher.internal.util.CostPerRow$;
import org.neo4j.cypher.internal.util.Foldable;
import org.neo4j.cypher.internal.util.Foldable$;
import org.neo4j.cypher.internal.util.Multiplier;
import org.neo4j.cypher.internal.util.Multiplier$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.runtime.BoxesRunTime;

public final class CardinalityCostModel$
implements Function3<LogicalPlan, Metrics.QueryGraphSolverInput, PlanningAttributes.Cardinalities, Cost> {
    public static CardinalityCostModel$ MODULE$;
    private final CostPerRow DEFAULT_COST_PER_ROW;
    private final CostPerRow PROBE_BUILD_COST;
    private final CostPerRow PROBE_SEARCH_COST;
    private final Multiplier EAGERNESS_MULTIPLIER;

    static {
        new CardinalityCostModel$();
    }

    public Function1<LogicalPlan, Function1<Metrics.QueryGraphSolverInput, Function1<PlanningAttributes.Cardinalities, Cost>>> curried() {
        return Function3.curried$((Function3)this);
    }

    public Function1<Tuple3<LogicalPlan, Metrics.QueryGraphSolverInput, PlanningAttributes.Cardinalities>, Cost> tupled() {
        return Function3.tupled$((Function3)this);
    }

    public String toString() {
        return Function3.toString$((Function3)this);
    }

    private CostPerRow DEFAULT_COST_PER_ROW() {
        return this.DEFAULT_COST_PER_ROW;
    }

    private CostPerRow PROBE_BUILD_COST() {
        return this.PROBE_BUILD_COST;
    }

    private CostPerRow PROBE_SEARCH_COST() {
        return this.PROBE_SEARCH_COST;
    }

    private Multiplier EAGERNESS_MULTIPLIER() {
        return this.EAGERNESS_MULTIPLIER;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CostPerRow costPerRow(LogicalPlan plan, Cardinality cardinality) {
        boolean bl;
        LogicalPlan logicalPlan = plan;
        boolean bl2 = logicalPlan instanceof NodeByLabelScan ? true : (logicalPlan instanceof NodeIndexScan ? true : logicalPlan instanceof ProjectEndpoints);
        if (bl2) {
            return CostPerRow$.MODULE$.lift(1.0);
        }
        if (logicalPlan instanceof Selection) {
            Selection selection = (Selection)logicalPlan;
            Ands predicate = selection.predicate();
            return this.apply((Expression)predicate);
        }
        if (logicalPlan instanceof AllNodesScan) {
            return CostPerRow$.MODULE$.lift(1.2);
        }
        if (logicalPlan instanceof Expand) {
            Expand expand2 = (Expand)logicalPlan;
            ExpansionMode expansionMode = expand2.mode();
            ExpandInto$ expandInto$ = ExpandInto$.MODULE$;
            if (expansionMode == null) {
                if (expandInto$ == null) return CostPerRow$.MODULE$.lift(4.5);
            } else if (expansionMode.equals(expandInto$)) {
                return CostPerRow$.MODULE$.lift(4.5);
            }
        }
        if (logicalPlan instanceof VarExpand) {
            VarExpand varExpand = (VarExpand)logicalPlan;
            ExpansionMode expansionMode = varExpand.mode();
            ExpandInto$ expandInto$ = ExpandInto$.MODULE$;
            if (expansionMode == null) {
                if (expandInto$ == null) return CostPerRow$.MODULE$.lift(4.5);
            } else if (expansionMode.equals(expandInto$)) {
                return CostPerRow$.MODULE$.lift(4.5);
            }
        }
        if (bl = logicalPlan instanceof Expand ? true : logicalPlan instanceof VarExpand) {
            return CostPerRow$.MODULE$.lift(1.5);
        }
        boolean bl3 = logicalPlan instanceof NodeUniqueIndexSeek ? true : (logicalPlan instanceof NodeIndexSeek ? true : (logicalPlan instanceof NodeIndexContainsScan ? true : logicalPlan instanceof NodeIndexEndsWithScan));
        if (bl3) {
            return CostPerRow$.MODULE$.lift(1.9);
        }
        boolean bl4 = logicalPlan instanceof NodeByIdSeek ? true : (logicalPlan instanceof DirectedRelationshipByIdSeek ? true : logicalPlan instanceof UndirectedRelationshipByIdSeek);
        if (bl4) {
            return CostPerRow$.MODULE$.lift(6.2);
        }
        boolean bl5 = logicalPlan instanceof NodeHashJoin ? true : (logicalPlan instanceof AggregatingPlan ? true : (logicalPlan instanceof AbstractLetSemiApply ? true : (logicalPlan instanceof Limit ? true : (logicalPlan instanceof Optional ? true : (logicalPlan instanceof Argument ? true : (logicalPlan instanceof LeftOuterHashJoin ? true : (logicalPlan instanceof RightOuterHashJoin ? true : (logicalPlan instanceof AbstractSemiApply ? true : (logicalPlan instanceof Skip ? true : (logicalPlan instanceof Union ? true : (logicalPlan instanceof ValueHashJoin ? true : (logicalPlan instanceof UnwindCollection ? true : logicalPlan instanceof ProcedureCall))))))))))));
        if (bl5) {
            return this.DEFAULT_COST_PER_ROW();
        }
        if (logicalPlan instanceof Sort) {
            return this.DEFAULT_COST_PER_ROW().$times(Multiplier$.MODULE$.lift(Math.log(cardinality.amount() + 1.0)));
        }
        if (!(logicalPlan instanceof FindShortestPaths)) return this.DEFAULT_COST_PER_ROW();
        return CostPerRow$.MODULE$.lift(12.0);
    }

    private Cardinality cardinalityForPlan(LogicalPlan plan, PlanningAttributes.Cardinalities cardinalities) {
        LogicalPlan logicalPlan = plan;
        Cardinality cardinality = (Cardinality)plan.lhs().map((Function1 & Serializable & scala.Serializable)p -> (Cardinality)cardinalities.get(p.id())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Cardinality)cardinalities.get(plan.id()));
        return cardinality;
    }

    public CostPerRow apply(Expression expression) {
        int noOfStoreAccesses = Foldable.FoldableAny$.MODULE$.treeCount$extension(Foldable$.MODULE$.FoldableAny((Object)expression), (PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                boolean bl = A1 instanceof Property ? true : A1 instanceof HasLabels;
                Boolean bl2 = bl ? BoxesRunTime.boxToBoolean((boolean)true) : BoxesRunTime.boxToBoolean((boolean)false);
                return (B1)bl2;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof Property ? true : object instanceof HasLabels;
                boolean bl2 = bl ? true : true;
                return bl2;
            }
        });
        return noOfStoreAccesses > 0 ? new CostPerRow((double)noOfStoreAccesses) : this.DEFAULT_COST_PER_ROW();
    }

    public Cost apply(LogicalPlan plan, Metrics.QueryGraphSolverInput input, PlanningAttributes.Cardinalities cardinalities) {
        Some some;
        StrictnessMode strictnessMode;
        Cost cost;
        LogicalPlan logicalPlan = plan;
        if (logicalPlan instanceof CartesianProduct) {
            CartesianProduct cartesianProduct = (CartesianProduct)logicalPlan;
            LogicalPlan lhs = cartesianProduct.left();
            LogicalPlan rhs = cartesianProduct.right();
            Cardinality lhsCardinality = Cardinality$.MODULE$.max(Cardinality$.MODULE$.SINGLE(), (Cardinality)cardinalities.get(lhs.id()));
            cost = this.apply(lhs, input, cardinalities).$plus(lhsCardinality.$times(this.apply(rhs, input, cardinalities)));
        } else {
            Option<Tuple2<LogicalPlan, LogicalPlan>> option = CardinalityCostModel$ApplyVariants$.MODULE$.unapply(logicalPlan);
            if (!option.isEmpty()) {
                LogicalPlan lhs = (LogicalPlan)((Tuple2)option.get())._1();
                LogicalPlan rhs = (LogicalPlan)((Tuple2)option.get())._2();
                Cost lCost = this.apply(lhs, input, cardinalities);
                Cost rCost = this.apply(rhs, input, cardinalities);
                cost = lCost.$plus(rCost);
            } else {
                Option<Tuple2<LogicalPlan, LogicalPlan>> option2 = CardinalityCostModel$HashJoin$.MODULE$.unapply(logicalPlan);
                if (!option2.isEmpty()) {
                    LogicalPlan lhs = (LogicalPlan)((Tuple2)option2.get())._1();
                    LogicalPlan rhs = (LogicalPlan)((Tuple2)option2.get())._2();
                    Cost lCost = this.apply(lhs, input, cardinalities);
                    Cost rCost = this.apply(rhs, input, cardinalities);
                    Cardinality lhsCardinality = (Cardinality)cardinalities.get(lhs.id());
                    Cardinality rhsCardinality = (Cardinality)cardinalities.get(rhs.id());
                    cost = lCost.$plus(rCost).$plus(lhsCardinality.$times(this.PROBE_BUILD_COST())).$plus(rhsCardinality.$times(this.PROBE_SEARCH_COST()));
                } else {
                    Cost totalCost;
                    Cost lhsCost = (Cost)plan.lhs().map((Function1 & Serializable & scala.Serializable)p -> MODULE$.apply((LogicalPlan)p, input, cardinalities)).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Cost(0.0));
                    Cost rhsCost = (Cost)plan.rhs().map((Function1 & Serializable & scala.Serializable)p -> MODULE$.apply((LogicalPlan)p, input, cardinalities)).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Cost(0.0));
                    Cardinality planCardinality = this.cardinalityForPlan(plan, cardinalities);
                    CostPerRow rowCost = this.costPerRow(plan, planCardinality);
                    Cost costForThisPlan = planCardinality.$times(rowCost);
                    cost = totalCost = costForThisPlan.$plus(lhsCost).$plus(rhsCost);
                }
            }
        }
        Cost cost2 = cost;
        Option<StrictnessMode> option = input.strictness();
        Cost cost3 = option instanceof Some && LazyMode$.MODULE$.equals(strictnessMode = (StrictnessMode)(some = (Some)option).value()) && !LazyMode$.MODULE$.apply((Strictness)plan) ? cost2.$times(this.EAGERNESS_MULTIPLIER()) : cost2;
        return cost3;
    }

    private CardinalityCostModel$() {
        MODULE$ = this;
        Function3.$init$((Function3)this);
        this.DEFAULT_COST_PER_ROW = CostPerRow$.MODULE$.lift(0.1);
        this.PROBE_BUILD_COST = CostPerRow$.MODULE$.lift(3.1);
        this.PROBE_SEARCH_COST = CostPerRow$.MODULE$.lift(2.4);
        this.EAGERNESS_MULTIPLIER = Multiplier$.MODULE$.lift(2.0);
    }
}

