/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical.idp;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.neo4j.cypher.internal.compiler.planner.logical.LogicalPlanningContext;
import org.neo4j.cypher.internal.compiler.planner.logical.QueryPlannerKit;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.JoinDisconnectedQueryGraphComponents;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.PlannedComponent;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.SingleComponentPlannerTrait;
import org.neo4j.cypher.internal.expressions.Equals;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.ir.PlannerQueryPart;
import org.neo4j.cypher.internal.ir.QueryGraph;
import org.neo4j.cypher.internal.ir.ordering.InterestingOrder;
import org.neo4j.cypher.internal.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.logical.plans.NodeIndexSeek;
import org.neo4j.cypher.internal.logical.plans.NodeUniqueIndexSeek;
import org.neo4j.cypher.internal.logical.plans.QueryExpression;
import org.neo4j.cypher.internal.util.Cost;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Builder;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

public final class cartesianProductsOrValueJoins$
implements JoinDisconnectedQueryGraphComponents,
Product,
scala.Serializable {
    public static cartesianProductsOrValueJoins$ MODULE$;

    static {
        new cartesianProductsOrValueJoins$();
    }

    @Override
    public Set<PlannedComponent> apply(Set<PlannedComponent> plans, QueryGraph qg, InterestingOrder interestingOrder, LogicalPlanningContext context, QueryPlannerKit kit, SingleComponentPlannerTrait singleComponentPlanner) {
        Set<PlannedComponent> set;
        Predef$.MODULE$.require(plans.size() > 1, (Function0 & Serializable & scala.Serializable)() -> "Can't build cartesian product with less than two input plans");
        Map joins = this.produceHashJoins(plans, qg, context, kit, singleComponentPlanner).$plus$plus(this.produceNIJVariations(plans, qg, interestingOrder, context, kit, singleComponentPlanner));
        if (joins.nonEmpty()) {
            set = this.pickTheBest(plans, kit, (Map<PlannedComponent, Tuple2<PlannedComponent, PlannedComponent>>)joins);
        } else if (plans.size() < 8) {
            Map<PlannedComponent, Tuple2<PlannedComponent, PlannedComponent>> cartesianProducts = this.produceCartesianProducts(plans, qg, context, kit);
            set = this.pickTheBest(plans, kit, cartesianProducts);
        } else {
            set = this.planLotsOfCartesianProducts(plans, qg, context, kit);
        }
        return set;
    }

    private Set<PlannedComponent> pickTheBest(Set<PlannedComponent> plans, QueryPlannerKit kit, Map<PlannedComponent, Tuple2<PlannedComponent, PlannedComponent>> joins) {
        LogicalPlan bestPlan = (LogicalPlan)kit.pickBest().apply((Iterable)joins.map((Function1 & Serializable & scala.Serializable)x$1 -> ((PlannedComponent)x$1._1()).plan(), Iterable$.MODULE$.canBuildFrom())).get();
        QueryGraph bestQG = (QueryGraph)joins.collectFirst((PartialFunction)new scala.Serializable(bestPlan){
            public static final long serialVersionUID = 0L;
            private final LogicalPlan bestPlan$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<PlannedComponent, Tuple2<PlannedComponent, PlannedComponent>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                PlannedComponent plannedComponent;
                A1 A1 = x1;
                if (A1 != null && (plannedComponent = (PlannedComponent)A1._1()) != null) {
                    QueryGraph fqg = plannedComponent.queryGraph();
                    LogicalPlan pl = plannedComponent.plan();
                    LogicalPlan logicalPlan = this.bestPlan$1;
                    LogicalPlan logicalPlan2 = pl;
                    if (!(logicalPlan != null ? !logicalPlan.equals(logicalPlan2) : logicalPlan2 != null)) {
                        object = fqg;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<PlannedComponent, Tuple2<PlannedComponent, PlannedComponent>> x1) {
                Tuple2<PlannedComponent, Tuple2<PlannedComponent, PlannedComponent>> tuple2 = x1;
                if (tuple2 == null) return false;
                PlannedComponent plannedComponent = (PlannedComponent)tuple2._1();
                if (plannedComponent == null) return false;
                LogicalPlan pl = plannedComponent.plan();
                LogicalPlan logicalPlan = this.bestPlan$1;
                LogicalPlan logicalPlan2 = pl;
                if (logicalPlan != null) {
                    if (!logicalPlan.equals(logicalPlan2)) return false;
                    return true;
                }
                if (logicalPlan2 == null) return true;
                return false;
            }
            {
                this.bestPlan$1 = bestPlan$1;
            }
        }).get();
        Tuple2 tuple2 = (Tuple2)joins.apply((Object)new PlannedComponent(bestQG, bestPlan));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        PlannedComponent p1 = (PlannedComponent)tuple2._1();
        PlannedComponent p2 = (PlannedComponent)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)p1, (Object)p2);
        Tuple2 tuple23 = tuple22;
        PlannedComponent p12 = (PlannedComponent)tuple23._1();
        PlannedComponent p22 = (PlannedComponent)tuple23._2();
        return (Set)plans.$minus((Object)p12).$minus((Object)p22).$plus((Object)new PlannedComponent(bestQG, bestPlan));
    }

    private Set<PlannedComponent> planLotsOfCartesianProducts(Set<PlannedComponent> plans, QueryGraph qg, LogicalPlanningContext context, QueryPlannerKit kit) {
        List allPlans = (List)plans.toList().sortBy((Function1 & Serializable & scala.Serializable)c -> (Cost)context.cost().apply((Object)c.plan(), (Object)context.input(), (Object)context.planningAttributes().cardinalities()), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        PlannedComponent onePlanToRuleThemAll = (PlannedComponent)((LinearSeqOptimized)allPlans.tail()).foldLeft(allPlans.head(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            PlannedComponent l = (PlannedComponent)tuple2._1();
            PlannedComponent r = (PlannedComponent)tuple2._2();
            LogicalPlan crossProduct = (LogicalPlan)kit.select().apply((Object)context.logicalPlanProducer().planCartesianProduct(l.plan(), r.plan(), context), (Object)qg);
            PlannedComponent plannedComponent = new PlannedComponent(l.queryGraph().$plus$plus(r.queryGraph()), crossProduct);
            return plannedComponent;
        });
        return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PlannedComponent[]{onePlanToRuleThemAll}));
    }

    private Map<PlannedComponent, Tuple2<PlannedComponent, PlannedComponent>> produceCartesianProducts(Set<PlannedComponent> plans, QueryGraph qg, LogicalPlanningContext context, QueryPlannerKit kit) {
        return ((TraversableOnce)plans.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)cartesianProductsOrValueJoins$.$anonfun$produceCartesianProducts$1(check$ifrefutable$1))).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> {
            PlannedComponent plannedComponent = x$5;
            if (plannedComponent == null) {
                throw new MatchError((Object)plannedComponent);
            }
            QueryGraph qg1 = plannedComponent.queryGraph();
            LogicalPlan p1 = plannedComponent.plan();
            Set set = (Set)plans.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)cartesianProductsOrValueJoins$.$anonfun$produceCartesianProducts$3(check$ifrefutable$2))).withFilter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)cartesianProductsOrValueJoins$.$anonfun$produceCartesianProducts$4(p1, x$3))).map((Function1 & Serializable & scala.Serializable)x$4 -> {
                PlannedComponent plannedComponent = x$4;
                if (plannedComponent == null) {
                    throw new MatchError((Object)plannedComponent);
                }
                QueryGraph qg2 = plannedComponent.queryGraph();
                LogicalPlan p2 = plannedComponent.plan();
                LogicalPlan crossProduct = (LogicalPlan)kit.select().apply((Object)context.logicalPlanProducer().planCartesianProduct(p1, p2, context), (Object)qg);
                Tuple2 tuple2 = new Tuple2((Object)new PlannedComponent(qg1.$plus$plus(qg2), crossProduct), (Object)new Tuple2((Object)plannedComponent, (Object)plannedComponent));
                return tuple2;
            }, Set$.MODULE$.canBuildFrom());
            return set;
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Map<PlannedComponent, Tuple2<PlannedComponent, PlannedComponent>> produceNIJVariations(Set<PlannedComponent> plans, QueryGraph qg, InterestingOrder interestingOrder, LogicalPlanningContext context, QueryPlannerKit kit, SingleComponentPlannerTrait singleComponentPlanner) {
        Tuple2[] predicatesWithDependencies = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])qg.selections().flatPredicates().toArray(ClassTag$.MODULE$.apply(Expression.class)))).map((Function1 & Serializable & scala.Serializable)pred -> new Tuple2(pred, ((TraversableOnce)pred.dependencies().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.name(), Set$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        PlannedComponent[] planArray = (PlannedComponent[])plans.toArray(ClassTag$.MODULE$.apply(PlannedComponent.class));
        Set[] allCoveredIds = (Set[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])planArray)).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.queryGraph().allCoveredIds(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Set.class)));
        Builder result = Predef$.MODULE$.Map().newBuilder();
        IntRef a = IntRef.create((int)0);
        while (a.elem < planArray.length) {
            IntRef b = IntRef.create((int)(a.elem + 1));
            while (b.elem < planArray.length) {
                LogicalPlan planA = planArray[a.elem].plan();
                LogicalPlan planB = planArray[b.elem].plan();
                QueryGraph qgA = planArray[a.elem].queryGraph();
                QueryGraph qgB = planArray[b.elem].queryGraph();
                this.predicatesDependendingOnBothSides(predicatesWithDependencies, (Set<String>)allCoveredIds[a.elem], (Set<String>)allCoveredIds[b.elem]).foreach((Function1 & Serializable & scala.Serializable)predicate -> {
                    cartesianProductsOrValueJoins$.$anonfun$produceNIJVariations$4(planA, planB, qgA, qgB, qg, interestingOrder, context, kit, singleComponentPlanner, result, planArray, a, b, predicate);
                    return BoxedUnit.UNIT;
                });
                ++b.elem;
            }
            ++a.elem;
        }
        return (Map)result.result();
    }

    private Map<PlannedComponent, Tuple2<PlannedComponent, PlannedComponent>> produceHashJoins(Set<PlannedComponent> plans, QueryGraph qg, LogicalPlanningContext context, QueryPlannerKit kit, SingleComponentPlannerTrait singleComponentPlanner) {
        return ((TraversableOnce)((GenericTraversableTemplate)this.valueJoins((Seq<Expression>)qg.selections().flatPredicates()).flatMap((Function1 & Serializable & scala.Serializable)join -> (Set)plans.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)cartesianProductsOrValueJoins$.$anonfun$produceHashJoins$2(check$ifrefutable$3))).withFilter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)cartesianProductsOrValueJoins$.$anonfun$produceHashJoins$3(join, x$8))).flatMap((Function1 & Serializable & scala.Serializable)x$11 -> {
            PlannedComponent plannedComponent = x$11;
            if (plannedComponent == null) {
                throw new MatchError((Object)plannedComponent);
            }
            LogicalPlan planA = plannedComponent.plan();
            Set set = (Set)plans.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)cartesianProductsOrValueJoins$.$anonfun$produceHashJoins$5(check$ifrefutable$4))).withFilter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)cartesianProductsOrValueJoins$.$anonfun$produceHashJoins$6(join, planA, x$9))).map((Function1 & Serializable & scala.Serializable)x$10 -> {
                PlannedComponent plannedComponent = x$10;
                if (plannedComponent == null) {
                    throw new MatchError((Object)plannedComponent);
                }
                LogicalPlan planB = plannedComponent.plan();
                LogicalPlan hashJoinAB = (LogicalPlan)kit.select().apply((Object)context.logicalPlanProducer().planValueHashJoin(planA, planB, (Equals)join, (Equals)join, context), (Object)qg);
                LogicalPlan hashJoinBA = (LogicalPlan)kit.select().apply((Object)context.logicalPlanProducer().planValueHashJoin(planB, planA, join.switchSides(), (Equals)join, context), (Object)qg);
                Set set = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new PlannedComponent(((PlannerQueryPart)context.planningAttributes().solveds().get(hashJoinAB.id())).asSinglePlannerQuery().lastQueryGraph(), hashJoinAB), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)plannedComponent), (Object)plannedComponent)), new Tuple2((Object)new PlannedComponent(((PlannerQueryPart)context.planningAttributes().solveds().get(hashJoinBA.id())).asSinglePlannerQuery().lastQueryGraph(), hashJoinBA), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)plannedComponent), (Object)plannedComponent))}));
                return set;
            }, Set$.MODULE$.canBuildFrom());
            return set;
        }, Set$.MODULE$.canBuildFrom()), Set$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms())).toMap(Predef$.MODULE$.$conforms());
    }

    private Option<PlannedComponent> planNIJ(LogicalPlan lhsPlan, LogicalPlan rhsInputPlan, QueryGraph lhsQG, QueryGraph rhsQG, QueryGraph fullQG, InterestingOrder interestingOrder, Expression predicate, LogicalPlanningContext context, QueryPlannerKit kit, SingleComponentPlannerTrait singleComponentPlanner) {
        Object object;
        boolean notSingleComponent = rhsQG.connectedComponents().size() > 1;
        boolean containsOptionals = ((PlannerQueryPart)context.planningAttributes().solveds().get(rhsInputPlan.id())).asSinglePlannerQuery().lastQueryGraph().optionalMatches().nonEmpty();
        if (notSingleComponent || containsOptionals) {
            object = None$.MODULE$;
        } else {
            QueryGraph rhsQGWithLHSArguments = ((PlannerQueryPart)context.planningAttributes().solveds().get(rhsInputPlan.id())).asSinglePlannerQuery().lastQueryGraph().addArgumentIds((Seq)lhsQG.idsWithoutOptionalMatchesOrUpdates().toIndexedSeq()).addPredicates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{predicate})).addHints((GenTraversableOnce)rhsQG.hints());
            LogicalPlan rhsPlan = singleComponentPlanner.planComponent(rhsQGWithLHSArguments, context, kit, interestingOrder);
            LogicalPlan result = (LogicalPlan)kit.select().apply((Object)context.logicalPlanProducer().planApply(lhsPlan, rhsPlan, context), (Object)fullQG);
            Seq indexWithDependency = (Seq)((GenericTraversableTemplate)result.leaves().collect((PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof NodeIndexSeek) {
                        NodeIndexSeek nodeIndexSeek = (NodeIndexSeek)A1;
                        QueryExpression valueExpr = nodeIndexSeek.valueExpr();
                        object = valueExpr.expressions().flatMap((Function1 & Serializable & scala.Serializable)x$12 -> x$12.dependencies(), Seq$.MODULE$.canBuildFrom());
                    } else if (A1 instanceof NodeUniqueIndexSeek) {
                        NodeUniqueIndexSeek nodeUniqueIndexSeek = (NodeUniqueIndexSeek)A1;
                        QueryExpression valueExpr = nodeUniqueIndexSeek.valueExpr();
                        object = valueExpr.expressions().flatMap((Function1 & Serializable & scala.Serializable)x$13 -> x$13.dependencies(), Seq$.MODULE$.canBuildFrom());
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x1) {
                    LogicalPlan logicalPlan = x1;
                    boolean bl = logicalPlan instanceof NodeIndexSeek ? true : logicalPlan instanceof NodeUniqueIndexSeek;
                    return bl;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.neo4j.cypher.internal.expressions.Expression ), $anonfun$applyOrElse$2(org.neo4j.cypher.internal.expressions.Expression )}, serializedLambda);
                }
            }, Seq$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms());
            object = indexWithDependency.nonEmpty() ? new Some((Object)new PlannedComponent(((PlannerQueryPart)context.planningAttributes().solveds().get(result.id())).asSinglePlannerQuery().lastQueryGraph(), result)) : None$.MODULE$;
        }
        return object;
    }

    public Set<Equals> valueJoins(Seq<Expression> flatPredicates) {
        return ((TraversableOnce)flatPredicates.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Equals) {
                    Equals equals = (Equals)A1;
                    Expression l = equals.lhs();
                    Expression r = equals.rhs();
                    if (l.dependencies().nonEmpty() && r.dependencies().nonEmpty()) {
                        Set set = r.dependencies();
                        Set set2 = l.dependencies();
                        if (set == null ? set2 != null : !set.equals(set2)) {
                            object = equals;
                            return (B1)object;
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                if (!(expression instanceof Equals)) return false;
                Equals equals = (Equals)expression;
                Expression l = equals.lhs();
                Expression r = equals.rhs();
                if (!l.dependencies().nonEmpty()) return false;
                if (!r.dependencies().nonEmpty()) return false;
                Set set = r.dependencies();
                Set set2 = l.dependencies();
                if (set == null) {
                    if (set2 == null) return false;
                    return true;
                } else if (set.equals(set2)) return false;
                return true;
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
    }

    public Seq<Expression> predicatesDependendingOnBothSides(Tuple2<Expression, String[]>[] predicateDependencies, Set<String> idsFromLeft, Set<String> idsFromRight) {
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predicateDependencies)).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)cartesianProductsOrValueJoins$.$anonfun$predicatesDependendingOnBothSides$1(idsFromLeft, idsFromRight, x0$1))))).map((Function1 & Serializable & scala.Serializable)x$14 -> (Expression)x$14._1(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public String productPrefix() {
        return "cartesianProductsOrValueJoins";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof cartesianProductsOrValueJoins$;
    }

    public int hashCode() {
        return 1781857095;
    }

    public String toString() {
        return "cartesianProductsOrValueJoins";
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$produceCartesianProducts$1(PlannedComponent check$ifrefutable$1) {
        PlannedComponent plannedComponent = check$ifrefutable$1;
        boolean bl = plannedComponent != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$produceCartesianProducts$3(PlannedComponent check$ifrefutable$2) {
        PlannedComponent plannedComponent = check$ifrefutable$2;
        boolean bl = plannedComponent != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$produceCartesianProducts$4(LogicalPlan p1$1, PlannedComponent x$3) {
        PlannedComponent plannedComponent = x$3;
        if (plannedComponent == null) {
            throw new MatchError((Object)plannedComponent);
        }
        LogicalPlan p2 = plannedComponent.plan();
        LogicalPlan logicalPlan = p1$1;
        LogicalPlan logicalPlan2 = p2;
        boolean bl = logicalPlan == null ? logicalPlan2 != null : !logicalPlan.equals(logicalPlan2);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$produceNIJVariations$4(LogicalPlan planA$1, LogicalPlan planB$1, QueryGraph qgA$1, QueryGraph qgB$1, QueryGraph qg$3, InterestingOrder interestingOrder$1, LogicalPlanningContext context$3, QueryPlannerKit kit$3, SingleComponentPlannerTrait singleComponentPlanner$1, Builder result$1, PlannedComponent[] planArray$1, IntRef a$1, IntRef b$1, Expression predicate) {
        Option<PlannedComponent> nestedIndexJoinAB = MODULE$.planNIJ(planA$1, planB$1, qgA$1, qgB$1, qg$3, interestingOrder$1, predicate, context$3, kit$3, singleComponentPlanner$1);
        Option<PlannedComponent> nestedIndexJoinBA = MODULE$.planNIJ(planB$1, planA$1, qgB$1, qgA$1, qg$3, interestingOrder$1, predicate, context$3, kit$3, singleComponentPlanner$1);
        nestedIndexJoinAB.foreach((Function1 & Serializable & scala.Serializable)x -> result$1.$plus$eq((Object)new Tuple2(x, (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)planArray$1[a$1.elem]), (Object)planArray$1[b$1.elem]))));
        nestedIndexJoinBA.foreach((Function1 & Serializable & scala.Serializable)x -> result$1.$plus$eq((Object)new Tuple2(x, (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)planArray$1[a$1.elem]), (Object)planArray$1[b$1.elem]))));
    }

    public static final /* synthetic */ boolean $anonfun$produceHashJoins$2(PlannedComponent check$ifrefutable$3) {
        PlannedComponent plannedComponent = check$ifrefutable$3;
        boolean bl = plannedComponent != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$produceHashJoins$3(Equals join$1, PlannedComponent x$8) {
        PlannedComponent plannedComponent = x$8;
        if (plannedComponent == null) {
            throw new MatchError((Object)plannedComponent);
        }
        LogicalPlan planA = plannedComponent.plan();
        boolean bl = planA.satisfiesExpressionDependencies(join$1.lhs()) && !planA.satisfiesExpressionDependencies(join$1.rhs());
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$produceHashJoins$5(PlannedComponent check$ifrefutable$4) {
        PlannedComponent plannedComponent = check$ifrefutable$4;
        boolean bl = plannedComponent != null;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$produceHashJoins$6(Equals join$1, LogicalPlan planA$2, PlannedComponent x$9) {
        PlannedComponent plannedComponent = x$9;
        if (plannedComponent == null) throw new MatchError((Object)plannedComponent);
        LogicalPlan planB = plannedComponent.plan();
        if (!planB.satisfiesExpressionDependencies(join$1.rhs())) return false;
        if (planB.satisfiesExpressionDependencies(join$1.lhs())) return false;
        LogicalPlan logicalPlan = planA$2;
        LogicalPlan logicalPlan2 = planB;
        if (logicalPlan == null) {
            if (logicalPlan2 == null) return false;
            return true;
        } else if (logicalPlan.equals(logicalPlan2)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$predicatesDependendingOnBothSides$1(Set idsFromLeft$1, Set idsFromRight$1, Tuple2 x0$1) {
        boolean forAllLhsOrRhs;
        boolean unfulfilledRhsDep;
        boolean unfulfilledLhsDep;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String[] deps = (String[])tuple2._2();
            unfulfilledLhsDep = false;
            unfulfilledRhsDep = false;
            forAllLhsOrRhs = true;
            for (int i = 0; i < deps.length; ++i) {
                boolean inLhs = idsFromLeft$1.apply((Object)deps[i]);
                boolean inRhs = idsFromRight$1.apply((Object)deps[i]);
                unfulfilledLhsDep = unfulfilledLhsDep || !inLhs;
                unfulfilledRhsDep = unfulfilledRhsDep || !inRhs;
                forAllLhsOrRhs = forAllLhsOrRhs && (inLhs || inRhs);
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        boolean bl = unfulfilledLhsDep && unfulfilledRhsDep && forAllLhsOrRhs;
        return bl;
    }

    private cartesianProductsOrValueJoins$() {
        MODULE$ = this;
        Product.$init$((Product)this);
    }
}

