/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical.idp;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.cypher.internal.compiler.planner.logical.ProjectingSelector;
import org.neo4j.cypher.internal.compiler.planner.logical.SelectorHeuristic$;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.BestResults;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.DefaultIdRegistry;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.ExtraRequirement;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.Goal;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPCache;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPLoggable;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPLoggable$;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPLogger;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPSolver$;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPSolverMonitor;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPSolverStep;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPTable;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IdRegistry;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.SolvableItemWithExtraRequirements;
import org.neo4j.cypher.internal.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.util.CancellationChecker;
import org.neo4j.cypher.internal.util.collection.immutable.ListSet;
import org.neo4j.exceptions.InternalException;
import org.neo4j.time.Stopwatch;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.BitSet;
import scala.collection.immutable.BitSet$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ReusableBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\rma\u0001\u0002\u0013&\u0001YB\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t)\u0002\u0011\t\u0011)A\u0005+\"A\u0011\f\u0001B\u0001B\u0003%!\f\u0003\u0005a\u0001\t\u0005\t\u0015!\u0003b\u0011!q\u0007A!A!\u0002\u0013y\u0007\u0002\u0003:\u0001\u0005\u0003\u0005\u000b\u0011B:\t\u0011Y\u0004!\u0011!Q\u0001\n]D\u0001B\u001f\u0001\u0003\u0002\u0003\u0006Ia\u001e\u0005\tw\u0002\u0011\t\u0011)A\u0005y\"Iq\u0010\u0001B\u0001B\u0003%\u0011\u0011\u0001\u0005\u000b\u0003\u001f\u0001!\u0011!Q\u0001\n\u0005E\u0001BCA\u000f\u0001\t\u0005\t\u0015!\u0003\u0002 !Q\u0011Q\u0005\u0001\u0003\u0004\u0003\u0006Y!a\n\t\u000f\u00055\u0002\u0001\"\u0001\u00020!9\u0011q\n\u0001\u0005\u0002\u0005E\u0003bBA;\u0001\u0011%\u0011q\u000f\u0005\b\u0003\u007f\u0002A\u0011BAA\u0011\u001d\tY\r\u0001C\u0005\u0003\u001bDq!a8\u0001\t\u0013\t\t\u000fC\u0004\u0003\b\u0001!IA!\u0003\t\u000f\tM\u0001\u0001\"\u0003\u0003\u0016!9!Q\t\u0001\u0005\n\t\u001d\u0003b\u0002B.\u0001\u0011%!Q\f\u0005\b\u0005K\u0002A\u0011\u0002B4\u0011\u001d\u0011y\u0007\u0001C\u0005\u0005cBqA!\"\u0001\t\u0013\u00119\tC\u0004\u0003\u0014\u0002!IA!&\t\u000f\t\u0005\u0006\u0001\"\u0003\u0003$\"9!1\u0017\u0001\u0005\n\tUv!\u0003BaK\u0005\u0005\t\u0012\u0001Bb\r!!S%!A\t\u0002\t\u0015\u0007bBA\u0017?\u0011\u0005!q\u0019\u0005\n\u0005\u0013|\u0012\u0013!C\u0001\u0005\u0017D\u0011Ba= #\u0003%\tA!>\t\u0013\r5q$%A\u0005\u0002\r=!!C%E!N{GN^3s\u0015\t1s%A\u0002jIBT!\u0001K\u0015\u0002\u000f1|w-[2bY*\u0011!fK\u0001\ba2\fgN\\3s\u0015\taS&\u0001\u0005d_6\u0004\u0018\u000e\\3s\u0015\tqs&\u0001\u0005j]R,'O\\1m\u0015\t\u0001\u0014'\u0001\u0004dsBDWM\u001d\u0006\u0003eM\nQA\\3pi)T\u0011\u0001N\u0001\u0004_J<7\u0001A\u000b\u0005o\u0015{%k\u0005\u0002\u0001qA\u0011\u0011\bP\u0007\u0002u)\t1(A\u0003tG\u0006d\u0017-\u0003\u0002>u\t1\u0011I\\=SK\u001a\f\u0011bZ3oKJ\fGo\u001c:\u0011\u000b\u0001\u000b5IT)\u000e\u0003\u0015J!AQ\u0013\u0003\u001b%#\u0005kU8mm\u0016\u00148\u000b^3q!\t!U\t\u0004\u0001\u0005\u000b\u0019\u0003!\u0019A$\u0003\u0011M{GN^1cY\u0016\f\"\u0001S&\u0011\u0005eJ\u0015B\u0001&;\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!\u000f'\n\u00055S$aA!osB\u0011Ai\u0014\u0003\u0006!\u0002\u0011\ra\u0012\u0002\u0007%\u0016\u001cX\u000f\u001c;\u0011\u0005\u0011\u0013F!B*\u0001\u0005\u00049%aB\"p]R,\u0007\u0010^\u0001\u0013aJ|'.Z2uS:<7+\u001a7fGR|'\u000fE\u0002W/:k\u0011aJ\u0005\u00031\u001e\u0012!\u0003\u0015:pU\u0016\u001cG/\u001b8h'\u0016dWm\u0019;pe\u0006y!/Z4jgR\u0014\u0018PR1di>\u0014\u0018\u0010E\u0002:7vK!\u0001\u0018\u001e\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004c\u0001!_\u0007&\u0011q,\n\u0002\u000b\u0013\u0012\u0014VmZ5tiJL\u0018\u0001\u0004;bE2,g)Y2u_JL\b#B\u001dc;\u0012\\\u0017BA2;\u0005%1UO\\2uS>t'\u0007\u0005\u0003fQ\u000eseB\u0001!g\u0013\t9W%A\u0004qC\u000e\\\u0017mZ3\n\u0005%T'\u0001B*fK\u0012T!aZ\u0013\u0011\u0007\u0001cg*\u0003\u0002nK\tA\u0011\n\u0012)UC\ndW-\u0001\u0007nCb$\u0016M\u00197f'&TX\r\u0005\u0002:a&\u0011\u0011O\u000f\u0002\u0004\u0013:$\u0018AF5uKJ\fG/[8o\tV\u0014\u0018\r^5p]2KW.\u001b;\u0011\u0005e\"\u0018BA;;\u0005\u0011auN\\4\u0002+\u0015DHO]1Pe\u0012,'OU3rk&\u0014X-\\3oiB\u0019\u0001\t\u001f(\n\u0005e,#\u0001E#yiJ\f'+Z9vSJ,W.\u001a8u\u0003a)\u0007\u0010\u001e:b!J|\u0007/\u001a:usJ+\u0017/^5sK6,g\u000e^\u0001\b[>t\u0017\u000e^8s!\t\u0001U0\u0003\u0002\u007fK\t\u0001\u0012\n\u0012)T_24XM]'p]&$xN]\u0001\u0011gR|\u0007oV1uG\"4\u0015m\u0019;pef\u0004B!O.\u0002\u0004A!\u0011QAA\u0006\u001b\t\t9AC\u0002\u0002\nE\nA\u0001^5nK&!\u0011QBA\u0004\u0005%\u0019Fo\u001c9xCR\u001c\u0007.A\ndC:\u001cW\r\u001c7bi&|gn\u00115fG.,'\u000f\u0005\u0003\u0002\u0014\u0005eQBAA\u000b\u0015\r\t9\"L\u0001\u0005kRLG.\u0003\u0003\u0002\u001c\u0005U!aE\"b]\u000e,G\u000e\\1uS>t7\t[3dW\u0016\u0014\u0018!C5ea2{wmZ3s!\r\u0001\u0015\u0011E\u0005\u0004\u0003G)#!C%E!2{wmZ3s\u0003))g/\u001b3f]\u000e,G%\r\t\u0005\u0001\u0006%2)C\u0002\u0002,\u0015\u00121\"\u0013#Q\u0019><w-\u00192mK\u00061A(\u001b8jiz\"\"$!\r\u00028\u0005e\u00121HA\u001f\u0003\u007f\t\t%a\u0011\u0002F\u0005\u001d\u0013\u0011JA&\u0003\u001b\"B!a\r\u00026A)\u0001\tA\"O#\"9\u0011Q\u0005\bA\u0004\u0005\u001d\u0002\"\u0002 \u000f\u0001\u0004y\u0004\"\u0002+\u000f\u0001\u0004)\u0006bB-\u000f!\u0003\u0005\rA\u0017\u0005\bA:\u0001\n\u00111\u0001b\u0011\u0015qg\u00021\u0001p\u0011\u0015\u0011h\u00021\u0001t\u0011\u00151h\u00021\u0001x\u0011\u0015Qh\u00021\u0001x\u0011\u0015Yh\u00021\u0001}\u0011\u0019yh\u00021\u0001\u0002\u0002!9\u0011q\u0002\bA\u0002\u0005E\u0001\"CA\u000f\u001dA\u0005\t\u0019AA\u0010\u0003\u0015\t\u0007\u000f\u001d7z)!\t\u0019&!\u0017\u0002^\u0005E\u0004\u0003\u0002!\u0002V9K1!a\u0016&\u0005-\u0011Um\u001d;SKN,H\u000e^:\t\r\u0005ms\u00021\u0001e\u0003\u0011\u0019X-\u001a3\t\u000f\u0005}s\u00021\u0001\u0002b\u0005Y\u0011N\\5uS\u0006dGk\u001c#p!\u0015\t\u0019'!\u001cD\u001b\t\t)G\u0003\u0003\u0002h\u0005%\u0014!C5n[V$\u0018M\u00197f\u0015\u0011\tY'!\u0006\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002p\u0005\u0015$a\u0002'jgR\u001cV\r\u001e\u0005\u0007\u0003gz\u0001\u0019A)\u0002\u000f\r|g\u000e^3yi\u0006\u0019!/\u001e8\u0015\u0011\u0005M\u0013\u0011PA>\u0003{Ba!a\u0017\u0011\u0001\u0004!\u0007bBA0!\u0001\u0007\u0011\u0011\r\u0005\u0007\u0003g\u0002\u0002\u0019A)\u0002#\r\fg\u000eZ5eCR,7+\u001a7fGR|'\u000f\u0006\u0003\u0002\u0004\u0006E\u0006#BAC\u0003Wse\u0002BAD\u0003SsA!!#\u0002(:!\u00111RAS\u001d\u0011\ti)a)\u000f\t\u0005=\u0015\u0011\u0015\b\u0005\u0003#\u000byJ\u0004\u0003\u0002\u0014\u0006ue\u0002BAK\u00037k!!a&\u000b\u0007\u0005eU'\u0001\u0004=e>|GOP\u0005\u0002i%\u0011!gM\u0005\u0003aEJ!AL\u0018\n\u00051j\u0013B\u0001\u0016,\u0013\tA\u0013&\u0003\u0002hO%!\u0011QVAX\u0005!\u0019V\r\\3di>\u0014(BA4(\u0011!\t\u0019,\u0005CA\u0002\u0005U\u0016\u0001\u0003:fg>dg/\u001a3\u0011\u000be\n9,a/\n\u0007\u0005e&H\u0001\u0005=Eft\u0017-\\3?!\u0011\ti,!2\u000f\t\u0005}\u0016\u0011\u0019\t\u0004\u0003+S\u0014bAAbu\u00051\u0001K]3eK\u001aLA!a2\u0002J\n11\u000b\u001e:j]\u001eT1!a1;\u000319w.\u00197TK2,7\r^8s)\u0011\ty-!8\u0011\r\u0005\u0015\u00151VAi!\u0019I\u00141[Al\u001d&\u0019\u0011Q\u001b\u001e\u0003\rQ+\b\u000f\\33!\r\u0001\u0015\u0011\\\u0005\u0004\u00037,#\u0001B$pC2D\u0001\"a-\u0013\t\u0003\u0007\u0011QW\u0001\rg&tw\r\\3SKN,H\u000e\u001e\u000b\u0004\u001d\u0006\r\bbBAs'\u0001\u0007\u0011q]\u0001\u0007m\u0016\u001cGo\u001c:\u0011\r\u0005%\u0018\u0011_A|\u001d\u0011\tY/a<\u000f\t\u0005U\u0015Q^\u0005\u0002w%\u0011qMO\u0005\u0005\u0003g\f)P\u0001\u0004WK\u000e$xN\u001d\u0006\u0003Oj\u0002b!OAj\u0003st\u0005\u0003BA~\u0005\u0003q1\u0001QA\u007f\u0013\r\ty0J\u0001\t\u0013\u0012\u00036)Y2iK&!!1\u0001B\u0003\u0005i\u0019\u0016\r^5tM&,G-\u0012=ue\u0006\u0014V-];je\u0016lWM\u001c;t\u0015\r\ty0J\u0001\u0014g&tw\r\\3Pe\u0016k\u0007\u000f^=SKN,H\u000e\u001e\u000b\u0005\u0005\u0017\u0011\t\u0002\u0005\u0003:\u0005\u001bq\u0015b\u0001B\bu\t1q\n\u001d;j_:Dq!!:\u0015\u0001\u0004\t9/\u0001\u0005dY\u0006\u001c8/\u001b4z+\u0011\u00119Ba\t\u0015\u0011\te!q\u0005B\u0019\u0005\u0003\u0002\u0012\"\u000fB\u000e\u0005?\u0011yBa\b\n\u0007\tu!H\u0001\u0004UkBdWm\r\t\u0007\u0003S\f\tP!\t\u0011\u0007\u0011\u0013\u0019\u0003\u0002\u0004\u0003&U\u0011\ra\u0012\u0002\u0002)\"9!\u0011F\u000bA\u0002\t-\u0012aD3mK6,g\u000e^%uKJ\fGo\u001c:\u0011\r\u0005%(Q\u0006B\u0011\u0013\u0011\u0011y#!>\u0003\u0011%#XM]1u_JDqAa\r\u0016\u0001\u0004\u0011)$\u0001\u0006qe\u0016$\u0017nY1uKF\u0002r!\u000fB\u001c\u0005C\u0011Y$C\u0002\u0003:i\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0007e\u0012i$C\u0002\u0003@i\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0003DU\u0001\rA!\u000e\u0002\u0015A\u0014X\rZ5dCR,''\u0001\u0005m_\u001e\u001cF/\u0019:u)!\u0011IEa\u0014\u0003T\t]\u0003cA\u001d\u0003L%\u0019!Q\n\u001e\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0005#2\u0002\u0019A/\u0002\u0011I,w-[:uefDaA!\u0016\u0017\u0001\u0004Y\u0017!\u0002;bE2,\u0007b\u0002B--\u0001\u0007\u0011q[\u0001\u0005i>$u.\u0001\nm_\u001e\u001cu.\u001c9bGRLwN\\*uCJ$HC\u0002B%\u0005?\u0012\t\u0007\u0003\u0004\u0003R]\u0001\r!\u0018\u0005\b\u0005G:\u0002\u0019AAl\u0003!y'/[4j]\u0006d\u0017\u0001\u00057pO\u000e{W\u000e]1di&|g.\u00128e)\u0019\u0011IE!\u001b\u0003l!1!Q\u000b\rA\u0002-DaA!\u001c\u0019\u0001\u0004y\u0017!\u00028fo&#\u0017A\u00077pO&#XM]1uS>tg)\u001e7ms\u000e{W\u000e\u001d7fi\u0016$G\u0003\u0004B%\u0005g\u00129H!\u001f\u0003~\t\u0005\u0005b\u0002B;3\u0001\u0007\u00111A\u0001\u0006gR\f'\u000f\u001e\u0005\u0007\u0005+J\u0002\u0019A6\t\r\tm\u0014\u00041\u0001p\u0003=!\u0018M\u00197f'&TXMQ3g_J,\u0007B\u0002B@3\u0001\u0007q.A\u0005cY>\u001c7nU5{K\"1!1Q\rA\u0002=\fA\"\\1y\u00052|7m[*ju\u0016\f\u0001\u0004\\8h)\u0006\u0014G.Z*ju\u0016d\u0015.\\5u%\u0016\f7\r[3e)1\u0011IE!#\u0003\f\n5%q\u0012BI\u0011\u001d\u0011)H\u0007a\u0001\u0003\u0007AaA!\u0016\u001b\u0001\u0004Y\u0007B\u0002B>5\u0001\u0007q\u000e\u0003\u0004\u0003\u0000i\u0001\ra\u001c\u0005\u0007\u0005\u0007S\u0002\u0019A8\u0002'1|w\rV5nK2KW.\u001b;SK\u0006\u001c\u0007.\u001a3\u0015\u0019\t%#q\u0013BM\u00057\u0013iJa(\t\u000f\tU4\u00041\u0001\u0002\u0004!1!QK\u000eA\u0002-DaAa\u001f\u001c\u0001\u0004y\u0007B\u0002B@7\u0001\u0007q\u000e\u0003\u0004\u0003\u0004n\u0001\ra\\\u0001\u0010Y><G*[7jiJ+\u0017m\u00195fIRq!\u0011\nBS\u0005S\u0013YK!,\u00030\nE\u0006b\u0002BT9\u0001\u0007\u00111X\u0001\nY&l\u0017\u000e\u001e+za\u0016DqA!\u001e\u001d\u0001\u0004\t\u0019\u0001\u0003\u0004\u0003Vq\u0001\ra\u001b\u0005\u0007\u0005wb\u0002\u0019A8\t\r\t}D\u00041\u0001p\u0011\u0019\u0011\u0019\t\ba\u0001_\u0006!bm\u001c:nCRLE/\u001a:bi&|gn\u0015;bi\u0016$B\"a/\u00038\ne&1\u0018B_\u0005\u007fCqA!\u001e\u001e\u0001\u0004\t\u0019\u0001\u0003\u0004\u0003Vu\u0001\ra\u001b\u0005\u0007\u0005wj\u0002\u0019A8\t\r\t}T\u00041\u0001p\u0011\u0019\u0011\u0019)\ba\u0001_\u0006I\u0011\n\u0012)T_24XM\u001d\t\u0003\u0001~\u0019\"a\b\u001d\u0015\u0005\t\r\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0005\u0003N\nm'q\u001eBy+\t\u0011yM\u000b\u0003\u0003R\nu\u0007\u0003B\u001d\\\u0005'\u0004R\u0001\u0011Bk\u00053L1Aa6&\u0005E!UMZ1vYRLEMU3hSN$(/\u001f\t\u0004\t\nmG!\u0002$\"\u0005\u000495F\u0001Bp!\u0011\u0011\tOa;\u000e\u0005\t\r(\u0002\u0002Bs\u0005O\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t%((\u0001\u0006b]:|G/\u0019;j_:LAA!<\u0003d\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000bA\u000b#\u0019A$\u0005\u000bM\u000b#\u0019A$\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+!\u00119p!\u0001\u0004\b\r-QC\u0001B}U\u0011\u0011YP!8\u0011\u0011e\u0012'Q`B\u0002\u0007\u0013\u0001B\u0001\u00110\u0003\u0000B\u0019Ai!\u0001\u0005\u000b\u0019\u0013#\u0019A$\u0011\r\u0015D'q`B\u0003!\r!5q\u0001\u0003\u0006!\n\u0012\ra\u0012\t\u0005\u00012\u001c)\u0001B\u0003TE\t\u0007q)\u0001\u000f%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u001a\u0016\u0011\rE1QCB\f\u00073)\"aa\u0005+\t\u0005}!Q\u001c\u0003\u0006\r\u000e\u0012\ra\u0012\u0003\u0006!\u000e\u0012\ra\u0012\u0003\u0006'\u000e\u0012\ra\u0012")
public class IDPSolver<Solvable, Result, Context> {
    private final IDPSolverStep<Solvable, Result, Context> generator;
    private final ProjectingSelector<Result> projectingSelector;
    private final Function0<IdRegistry<Solvable>> registryFactory;
    private final Function2<IdRegistry<Solvable>, Iterable<Tuple2<SolvableItemWithExtraRequirements<Solvable>, Result>>, IDPTable<Result>> tableFactory;
    private final int maxTableSize;
    private final long iterationDurationLimit;
    private final ExtraRequirement<Result> extraOrderRequirement;
    private final ExtraRequirement<Result> extraPropertyRequirement;
    private final IDPSolverMonitor monitor;
    private final Function0<Stopwatch> stopWatchFactory;
    private final CancellationChecker cancellationChecker;
    private final IDPLogger idpLogger;
    private final IDPLoggable<Solvable> evidence$1;

    public static <Solvable, Result, Context> IDPLogger $lessinit$greater$default$12() {
        return IDPSolver$.MODULE$.$lessinit$greater$default$12();
    }

    public static <Solvable, Result, Context> Function2<IdRegistry<Solvable>, Iterable<Tuple2<SolvableItemWithExtraRequirements<Solvable>, Result>>, IDPTable<Result>> $lessinit$greater$default$4() {
        return IDPSolver$.MODULE$.$lessinit$greater$default$4();
    }

    public static <Solvable, Result, Context> Function0<DefaultIdRegistry<Solvable>> $lessinit$greater$default$3() {
        return IDPSolver$.MODULE$.$lessinit$greater$default$3();
    }

    public BestResults<Result> apply(Iterable<Tuple2<SolvableItemWithExtraRequirements<Solvable>, Result>> seed, ListSet<Solvable> initialToDo, Context context) {
        return (BestResults)this.idpLogger.markScope("IDP", (Function0 & Serializable)() -> this.run(seed, initialToDo, context));
    }

    private BestResults<Result> run(Iterable<Tuple2<SolvableItemWithExtraRequirements<Solvable>, Result>> seed, ListSet<Solvable> initialToDo, Context context) {
        IdRegistry registry = (IdRegistry)this.registryFactory.apply();
        ObjectRef toDo = ObjectRef.create((Object)new Goal(registry.registerAll(initialToDo)));
        IDPTable table = (IDPTable)this.tableFactory.apply((Object)registry, seed);
        IntRef iterations = IntRef.create((int)0);
        this.logStart(registry, table, (Goal)toDo.elem);
        while (((Goal)toDo.elem).size() > 1) {
            ++iterations.elem;
            this.idpLogger.log((Function0<String>)(Function0 & Serializable)() -> "Iteration " + iterations$1.elem);
            this.monitor.startIteration(iterations.elem);
            int largestFinished = this.generateBestCandidates$1(((Goal)toDo.elem).size(), table, toDo, registry, context);
            if (largestFinished <= 0) {
                throw InternalException.foundNoPlanWithinConstraints((String)GraphDatabaseInternalSettings.cypher_idp_solver_table_threshold.name(), (String)GraphDatabaseInternalSettings.cypher_idp_solver_duration_threshold.name());
            }
            Goal bestGoal = this.findBestCandidateInBlock$1(largestFinished, iterations.elem, table);
            this.monitor.endIteration(iterations.elem, largestFinished, table.size());
            this.compactBlock$1(bestGoal, registry, table, toDo);
        }
        this.monitor.foundPlanAfter(iterations.elem);
        this.idpLogger.log((Function0<String>)(Function0 & Serializable)() -> "Done after " + iterations$1.elem + " iteration(s)");
        Iterator plansWithResult = table.plans().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Object result = tuple2._2();
                if (tuple22 != null) {
                    IDPCache.SatisfiedExtraRequirements fulfilsReq = (IDPCache.SatisfiedExtraRequirements)tuple22._2();
                    return new Tuple2((Object)fulfilsReq, result);
                }
            }
            throw new MatchError((Object)tuple2);
        });
        Tuple3 tuple3 = this.classify(plansWithResult, (Function1 & Serializable)planWithResult -> BoxesRunTime.boxToBoolean((boolean)IDPSolver.$anonfun$run$17(planWithResult)), (Function1 & Serializable)planWithResult -> BoxesRunTime.boxToBoolean((boolean)IDPSolver.$anonfun$run$18(planWithResult)));
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Vector plansFulfillingExtraProperties = (Vector)tuple3._1();
        Vector sortedPlans = (Vector)tuple3._2();
        Vector basePlans = (Vector)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)plansFulfillingExtraProperties, (Object)sortedPlans, (Object)basePlans);
        Vector plansFulfillingExtraProperties2 = (Vector)tuple32._1();
        Vector sortedPlans2 = (Vector)tuple32._2();
        Vector basePlans2 = (Vector)tuple32._3();
        return new BestResults<Result>(this.singleResult(basePlans2), this.singleOrEmptyResult(sortedPlans2), this.singleOrEmptyResult(plansFulfillingExtraProperties2));
    }

    private Function1<Iterable<Result>, Option<Result>> candidateSelector(Function0<String> resolved) {
        return (Function1 & Serializable)x$8 -> $this.projectingSelector.apply((Function1 & Serializable)x -> Predef$.MODULE$.identity(x), x$8, resolved);
    }

    private Function1<Iterable<Tuple2<Goal, Result>>, Option<Tuple2<Goal, Result>>> goalSelector(Function0<String> resolved) {
        return (Function1 & Serializable)x$10 -> $this.projectingSelector.applyWithResolvedPerPlan((Function1 & Serializable)x$9 -> x$9._2(), x$10, resolved, (Function1<LogicalPlan, String>)(Function1 & Serializable)x$11 -> "", SelectorHeuristic$.MODULE$.constant(), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Goal goal = (Goal)tuple2._1();
                return new Some((Object)("Goal: " + goal.bitSet()));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Result singleResult(Vector<Tuple2<IDPCache.SatisfiedExtraRequirements, Result>> vector) {
        SeqOps seqOps;
        Vector<Tuple2<IDPCache.SatisfiedExtraRequirements, Result>> vector2 = vector;
        if (vector2 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Vector().unapplySeq(vector2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
            Tuple2 t = (Tuple2)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            return (Result)t._2();
        }
        throw InternalException.internalError((String)this.getClass().getSimpleName(), (String)"Expected a single plan to be left in the plan table");
    }

    private Option<Result> singleOrEmptyResult(Vector<Tuple2<IDPCache.SatisfiedExtraRequirements, Result>> vector) {
        SeqOps seqOps;
        SeqOps seqOps2;
        Vector<Tuple2<IDPCache.SatisfiedExtraRequirements, Result>> vector2 = vector;
        if (vector2 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = package$.MODULE$.Vector().unapplySeq(vector2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0) == 0) {
            return None$.MODULE$;
        }
        if (vector2 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Vector().unapplySeq(vector2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
            Tuple2 t = (Tuple2)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            return new Some(t._2());
        }
        throw InternalException.internalError((String)this.getClass().getSimpleName(), (String)"Expected a single plan that fulfils the requirements to be left in the plan table");
    }

    private <T> Tuple3<Vector<T>, Vector<T>, Vector<T>> classify(Iterator<T> elementIterator, Function1<T, Object> predicate1, Function1<T, Object> predicate2) {
        ReusableBuilder predicate1Iterable = package$.MODULE$.Vector().newBuilder();
        ReusableBuilder predicate2Iterable = package$.MODULE$.Vector().newBuilder();
        ReusableBuilder noneMatchIterable = package$.MODULE$.Vector().newBuilder();
        elementIterator.foreach((Function1 & Serializable)element -> {
            boolean isPredicate1Accepted = BoxesRunTime.unboxToBoolean((Object)predicate1.apply(element));
            boolean isPredicate2Accepted = BoxesRunTime.unboxToBoolean((Object)predicate2.apply(element));
            Object object = !isPredicate1Accepted && !isPredicate2Accepted ? noneMatchIterable.addOne(element) : BoxedUnit.UNIT;
            Object object2 = isPredicate1Accepted ? predicate1Iterable.addOne(element) : BoxedUnit.UNIT;
            if (isPredicate2Accepted) {
                return predicate2Iterable.addOne(element);
            }
            return BoxedUnit.UNIT;
        });
        return new Tuple3(predicate1Iterable.result(), predicate2Iterable.result(), noneMatchIterable.result());
    }

    private void logStart(IdRegistry<Solvable> registry, IDPTable<Result> table, Goal toDo) {
        this.idpLogger.log((Function0<String>)(Function0 & Serializable)() -> {
            Vector goalsSummaries = (Vector)((StrictOptimizedIterableOps)((StrictOptimizedIterableOps)toDo.bitSet().toVector().sorted((Ordering)Ordering.Int$.MODULE$)).flatMap((Function1 & Serializable)i -> IDPSolver.$anonfun$logStart$2(registry, BoxesRunTime.unboxToInt((Object)i)))).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    int idx = tuple2._1$mcI$sp();
                    Object solvable = tuple2._2();
                    return "[" + idx + "] " + IDPLoggable$.MODULE$.summary(solvable, $this.evidence$1);
                }
                throw new MatchError((Object)tuple2);
            });
            return "Initial table size = " + table.size() + "\nGoals [" + goalsSummaries.size() + "]: " + goalsSummaries.mkString("[\n  ", ",\n  ", "\n]");
        });
    }

    private void logCompactionStart(IdRegistry<Solvable> registry, Goal original) {
        this.idpLogger.log((Function0<String>)(Function0 & Serializable)() -> {
            Set originalGoalsSummaries = (Set)registry.explode(original.bitSet()).map((Function1 & Serializable)x$13 -> IDPLoggable$.MODULE$.summary(x$13, $this.evidence$1));
            BitSet originalGoalsBits = registry.explodedBitSet(original.bitSet());
            return "Compacting goal " + original.bitSet() + " (exploded = " + originalGoalsBits + ") = " + originalGoalsSummaries.mkString("[\n  ", ",\n  ", "\n]");
        });
    }

    private void logCompactionEnd(IDPTable<Result> table, int newId) {
        this.idpLogger.log((Function0<String>)(Function0 & Serializable)() -> "New compacted goal id = " + newId + ", compacted table size: " + table.size());
    }

    private void logIterationFullyCompleted(Stopwatch start, IDPTable<Result> table, int tableSizeBefore, int blockSize, int maxBlockSize) {
        this.idpLogger.log((Function0<String>)(Function0 & Serializable)() -> "[\u2713] all done, " + this.formatIterationState(start, table, tableSizeBefore, blockSize, maxBlockSize));
    }

    private void logTableSizeLimitReached(Stopwatch start, IDPTable<Result> table, int tableSizeBefore, int blockSize, int maxBlockSize) {
        this.logLimitReached("table size", start, table, tableSizeBefore, blockSize, maxBlockSize);
    }

    private void logTimeLimitReached(Stopwatch start, IDPTable<Result> table, int tableSizeBefore, int blockSize, int maxBlockSize) {
        this.logLimitReached("time", start, table, tableSizeBefore, blockSize, maxBlockSize);
    }

    private void logLimitReached(String limitType, Stopwatch start, IDPTable<Result> table, int tableSizeBefore, int blockSize, int maxBlockSize) {
        this.idpLogger.log((Function0<String>)(Function0 & Serializable)() -> "[!] " + limitType + " limit reached, " + this.formatIterationState(start, table, tableSizeBefore, blockSize, maxBlockSize));
    }

    private String formatIterationState(Stopwatch start, IDPTable<Result> table, int tableSizeBefore, int blockSize, int maxBlockSize) {
        long elapsedTimeMs = start.elapsed(TimeUnit.MILLISECONDS);
        return "time(ms)=" + elapsedTimeMs + "/" + this.iterationDurationLimit + ", table=[" + table.size() + "/" + this.maxTableSize + " (+" + (table.size() - tableSizeBefore) + ")], blockSize=[" + blockSize + "/" + maxBlockSize + "]";
    }

    public static final /* synthetic */ void $anonfun$run$6(BooleanRef foundNoCandidate$1, IDPTable table$1, Goal goal$1, Object candidate) {
        foundNoCandidate$1.elem = false;
        table$1.put(goal$1, false, false, candidate);
    }

    public static final /* synthetic */ void $anonfun$run$7(BooleanRef foundNoCandidate$1, IDPTable table$1, Goal goal$1, Object candidate) {
        foundNoCandidate$1.elem = false;
        table$1.put(goal$1, true, false, candidate);
    }

    public static final /* synthetic */ void $anonfun$run$8(BooleanRef foundNoCandidate$1, IDPTable table$1, Goal goal$1, Object candidate) {
        foundNoCandidate$1.elem = false;
        table$1.put(goal$1, false, true, candidate);
    }

    private final int generateBestCandidates$1(int maxBlockSize, IDPTable table$1, ObjectRef toDo$1, IdRegistry registry$1, Object context$2) {
        int largestFinishedIteration;
        block9: {
            largestFinishedIteration = 0;
            int blockSize = 1;
            boolean keepGoing = true;
            Stopwatch start = (Stopwatch)this.stopWatchFactory.apply();
            int tableSizeBefore = table$1.size();
            while (keepGoing && blockSize <= maxBlockSize) {
                BooleanRef foundNoCandidate = BooleanRef.create((boolean)true);
                Iterator<Goal> goals = ((Goal)toDo$1.elem).subGoals(++blockSize);
                while (keepGoing && goals.hasNext()) {
                    boolean bl;
                    this.cancellationChecker.throwIfCancelled();
                    Goal goal = (Goal)goals.next();
                    if (table$1.contains(goal, false, false)) continue;
                    Vector candidates = this.generator.apply(registry$1, goal, table$1, context$2).toVector();
                    Tuple3 tuple3 = this.classify(candidates.iterator(), (Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)this.extraPropertyRequirement.fulfils(result)), (Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)this.extraOrderRequirement.fulfils(result)));
                    if (tuple3 == null) {
                        throw new MatchError(tuple3);
                    }
                    Vector extraPropertiesCandidates = (Vector)tuple3._1();
                    Vector extraOrderCandidates = (Vector)tuple3._2();
                    Vector baseCandidates = (Vector)tuple3._3();
                    Tuple3 tuple32 = new Tuple3((Object)extraPropertiesCandidates, (Object)extraOrderCandidates, (Object)baseCandidates);
                    Vector extraPropertiesCandidates2 = (Vector)tuple32._1();
                    Vector extraOrderCandidates2 = (Vector)tuple32._2();
                    Vector baseCandidates2 = (Vector)tuple32._3();
                    Option bestSortedCandidate = (Option)this.candidateSelector((Function0<String>)(Function0 & Serializable)() -> "best sorted plan for " + goal.bitSet() + "@" + registry$1.explode(goal.bitSet())).apply((Object)extraOrderCandidates2);
                    Option bestPrefetchedPropertiesCandidate = (Option)this.candidateSelector((Function0<String>)(Function0 & Serializable)() -> "best plan with pre-fetched properties for " + goal.bitSet() + "@" + registry$1.explode(goal.bitSet())).apply((Object)extraPropertiesCandidates2);
                    ((Option)this.candidateSelector((Function0<String>)(Function0 & Serializable)() -> "best overall plan for " + goal.bitSet() + "@" + registry$1.explode(goal.bitSet())).apply(((IterableOps)baseCandidates2.$plus$plus((IterableOnce)bestSortedCandidate)).$plus$plus((IterableOnce)bestPrefetchedPropertiesCandidate))).foreach((Function1 & Serializable)candidate -> {
                        IDPSolver.$anonfun$run$6(foundNoCandidate, table$1, goal, candidate);
                        return BoxedUnit.UNIT;
                    });
                    bestSortedCandidate.foreach((Function1 & Serializable)candidate -> {
                        IDPSolver.$anonfun$run$7(foundNoCandidate, table$1, goal, candidate);
                        return BoxedUnit.UNIT;
                    });
                    bestPrefetchedPropertiesCandidate.foreach((Function1 & Serializable)candidate -> {
                        IDPSolver.$anonfun$run$8(foundNoCandidate, table$1, goal, candidate);
                        return BoxedUnit.UNIT;
                    });
                    if (blockSize == 2) {
                        bl = true;
                    } else if (table$1.size() > this.maxTableSize) {
                        this.logTableSizeLimitReached(start, table$1, tableSizeBefore, blockSize, maxBlockSize);
                        bl = false;
                    } else if (start.hasTimedOut(this.iterationDurationLimit, TimeUnit.MILLISECONDS)) {
                        this.logTimeLimitReached(start, table$1, tableSizeBefore, blockSize, maxBlockSize);
                        bl = false;
                    } else {
                        bl = true;
                    }
                    keepGoing = bl;
                }
                largestFinishedIteration = foundNoCandidate.elem || goals.hasNext() ? largestFinishedIteration : blockSize;
            }
            if (!keepGoing) break block9;
            this.logIterationFullyCompleted(start, table$1, tableSizeBefore, blockSize, maxBlockSize);
        }
        return largestFinishedIteration;
    }

    public static final /* synthetic */ Nothing$ $anonfun$run$10(int blockSize$1, Iterable blockCandidates$1, IDPTable table$1) {
        throw InternalException.foundNoSolutionForBlock((int)blockSize$1, (String)blockCandidates$1.toString(), (String)table$1.toString());
    }

    private final Goal findBestCandidateInBlock$1(int blockSize, int iteration, IDPTable table$1) {
        Vector blockCandidates = table$1.unsortedPlansOfSize(blockSize).toVector();
        Option bestInBlock = (Option)this.goalSelector((Function0<String>)(Function0 & Serializable)() -> "Best candidate for block size " + blockSize + " (IDP iteration #" + iteration + ")").apply((Object)blockCandidates);
        Tuple2 tuple2 = (Tuple2)bestInBlock.getOrElse(() -> IDPSolver.$anonfun$run$10(blockSize, (Iterable)blockCandidates, table$1));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Goal goal = (Goal)tuple2._1();
        Goal goal2 = goal;
        return goal2;
    }

    private final void compactBlock$1(Goal original, IdRegistry registry$1, IDPTable table$1, ObjectRef toDo$1) {
        this.logCompactionStart(registry$1, original);
        int newId = registry$1.compact(original.bitSet());
        IDPCache.Results results = table$1.apply(original);
        if (results == null) {
            throw new MatchError(results);
        }
        Option result = results.result();
        Option sortedResult = results.sortedResult();
        Option extraPropertiesResult = results.extraPropertiesResult();
        Tuple3 tuple3 = new Tuple3(result, sortedResult, extraPropertiesResult);
        Option result2 = (Option)tuple3._1();
        Option sortedResult2 = (Option)tuple3._2();
        Option extraPropertiesResult2 = (Option)tuple3._3();
        result2.foreach((Function1 & Serializable)x$4 -> {
            table$1.put(new Goal((BitSet)BitSet$.MODULE$.empty().$plus((Object)BoxesRunTime.boxToInteger((int)newId))), false, false, x$4);
            return BoxedUnit.UNIT;
        });
        sortedResult2.foreach((Function1 & Serializable)x$5 -> {
            table$1.put(new Goal((BitSet)BitSet$.MODULE$.empty().$plus((Object)BoxesRunTime.boxToInteger((int)newId))), true, false, x$5);
            return BoxedUnit.UNIT;
        });
        extraPropertiesResult2.foreach((Function1 & Serializable)x$6 -> {
            table$1.put(new Goal((BitSet)BitSet$.MODULE$.empty().$plus((Object)BoxesRunTime.boxToInteger((int)newId))), false, true, x$6);
            return BoxedUnit.UNIT;
        });
        toDo$1.elem = new Goal((BitSet)((Goal)toDo$1.elem).bitSet().$minus$minus((IterableOnce)original.bitSet()).$plus((Object)BoxesRunTime.boxToInteger((int)newId)));
        table$1.removeAllTracesOf(original);
        this.logCompactionEnd(table$1, newId);
    }

    public static final /* synthetic */ boolean $anonfun$run$17(Tuple2 planWithResult) {
        return ((IDPCache.SatisfiedExtraRequirements)planWithResult._1()).hasExtraProperties();
    }

    public static final /* synthetic */ boolean $anonfun$run$18(Tuple2 planWithResult) {
        return ((IDPCache.SatisfiedExtraRequirements)planWithResult._1()).sorted();
    }

    public static final /* synthetic */ Option $anonfun$logStart$2(IdRegistry registry$2, int i) {
        return registry$2.lookup(i).map((Function1 & Serializable)x$12 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)i)), x$12));
    }

    public IDPSolver(IDPSolverStep<Solvable, Result, Context> generator, ProjectingSelector<Result> projectingSelector, Function0<IdRegistry<Solvable>> registryFactory, Function2<IdRegistry<Solvable>, Iterable<Tuple2<SolvableItemWithExtraRequirements<Solvable>, Result>>, IDPTable<Result>> tableFactory, int maxTableSize, long iterationDurationLimit, ExtraRequirement<Result> extraOrderRequirement, ExtraRequirement<Result> extraPropertyRequirement, IDPSolverMonitor monitor, Function0<Stopwatch> stopWatchFactory, CancellationChecker cancellationChecker, IDPLogger idpLogger, IDPLoggable<Solvable> evidence$1) {
        this.generator = generator;
        this.projectingSelector = projectingSelector;
        this.registryFactory = registryFactory;
        this.tableFactory = tableFactory;
        this.maxTableSize = maxTableSize;
        this.iterationDurationLimit = iterationDurationLimit;
        this.extraOrderRequirement = extraOrderRequirement;
        this.extraPropertyRequirement = extraPropertyRequirement;
        this.monitor = monitor;
        this.stopWatchFactory = stopWatchFactory;
        this.cancellationChecker = cancellationChecker;
        this.idpLogger = idpLogger;
        this.evidence$1 = evidence$1;
    }
}

