/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.neo4j.cypher.internal.ast.CatalogName;
import org.neo4j.cypher.internal.ast.CatalogName$;
import org.neo4j.cypher.internal.ast.Clause;
import org.neo4j.cypher.internal.ast.GraphDirectReference;
import org.neo4j.cypher.internal.ast.GraphFunctionReference;
import org.neo4j.cypher.internal.ast.GraphReference;
import org.neo4j.cypher.internal.ast.GraphSelection;
import org.neo4j.cypher.internal.ast.SingleQuery;
import org.neo4j.cypher.internal.ast.Statement;
import org.neo4j.cypher.internal.ast.Union;
import org.neo4j.cypher.internal.ast.UseGraph;
import org.neo4j.cypher.internal.ast.semantics.SemanticFeature;
import org.neo4j.cypher.internal.ast.semantics.SemanticState;
import org.neo4j.cypher.internal.compiler.phases.PlannerContext;
import org.neo4j.cypher.internal.compiler.planner.VerifyGraphTarget;
import org.neo4j.cypher.internal.evaluator.SimpleInternalExpressionEvaluator;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.FunctionInvocation;
import org.neo4j.cypher.internal.expressions.functions.GraphByElementId$;
import org.neo4j.cypher.internal.frontend.phases.BaseContains;
import org.neo4j.cypher.internal.frontend.phases.BaseContext;
import org.neo4j.cypher.internal.frontend.phases.BaseState;
import org.neo4j.cypher.internal.frontend.phases.CompilationPhaseTracer;
import org.neo4j.cypher.internal.frontend.phases.Phase;
import org.neo4j.cypher.internal.frontend.phases.Transformer;
import org.neo4j.cypher.internal.frontend.phases.VisitorPhase;
import org.neo4j.cypher.internal.frontend.phases.factories.PlanPipelineTransformerFactory;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.util.CancellationChecker;
import org.neo4j.cypher.internal.util.DeprecatedDatabaseNameNotification;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.cypher.internal.util.InternalNotificationLogger;
import org.neo4j.cypher.internal.util.StepSequencer;
import org.neo4j.cypher.messages.MessageUtilProvider$;
import org.neo4j.dbms.api.DatabaseNotFoundHelper;
import org.neo4j.exceptions.InvalidSemanticsException;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceImpl;
import org.neo4j.kernel.database.DatabaseReferenceRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedCatalogEntry;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.values.ElementIdDecoder;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.virtual.MapValue;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.jdk.javaapi.OptionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class VerifyGraphTarget$
implements VisitorPhase<PlannerContext, BaseState>,
StepSequencer.Step,
StepSequencer.DefaultPostCondition,
PlanPipelineTransformerFactory,
Product,
Serializable {
    public static final VerifyGraphTarget$ MODULE$ = new VerifyGraphTarget$();
    private static volatile StepSequencer.DefaultPostCondition.completed$ completed$module;

    static {
        Transformer.$init$((Transformer)MODULE$);
        Phase.$init$((Phase)MODULE$);
        VisitorPhase.$init$((VisitorPhase)MODULE$);
        StepSequencer.DefaultPostCondition.$init$((StepSequencer.DefaultPostCondition)MODULE$);
        Product.$init$((Product)MODULE$);
    }

    public String productElementName(int n) {
        return Product.productElementName$((Product)this, (int)n);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public Object process(Object from, BaseContext context) {
        return VisitorPhase.process$((VisitorPhase)this, (Object)from, (BaseContext)context);
    }

    public Object transform(Object from, BaseContext context) {
        return Phase.transform$((Phase)this, (Object)from, (BaseContext)context);
    }

    public String name() {
        return Phase.name$((Phase)this);
    }

    public <D extends PlannerContext, TO2> Transformer<D, BaseState, TO2> andThen(Transformer<D, BaseState, TO2> other) {
        return Transformer.andThen$((Transformer)this, other);
    }

    public final boolean checkConditions(Object state, Set<StepSequencer.Condition> conditions, CancellationChecker cancellationChecker) {
        return Transformer.checkConditions$((Transformer)this, (Object)state, conditions, (CancellationChecker)cancellationChecker);
    }

    public StepSequencer.DefaultPostCondition.completed$ completed() {
        if (completed$module == null) {
            this.completed$lzycompute$1();
        }
        return completed$module;
    }

    public CompilationPhaseTracer.CompilationPhase phase() {
        return CompilationPhaseTracer.CompilationPhase.LOGICAL_PLANNING;
    }

    public void visit(BaseState value, PlannerContext context) {
        if (!value.semantics().features().contains((Object)SemanticFeature.UseAsMultipleGraphsSelector$.MODULE$)) {
            this.verifyGraphTarget(context.databaseReferenceRepository(), value.statement(), context.databaseId(), context.config().queryRouterForCompositeQueriesEnabled(), context.params(), context.notificationLogger());
            return;
        }
    }

    public Set<StepSequencer.Condition> preConditions() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StepSequencer.Condition[]{new BaseContains(ClassTag$.MODULE$.apply(Statement.class)), new BaseContains(ClassTag$.MODULE$.apply(SemanticState.class))}));
    }

    public Set<StepSequencer.Condition> postConditions() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StepSequencer.Condition[]{this.completed()}));
    }

    public Set<StepSequencer.Condition> invalidatedConditions() {
        return Predef$.MODULE$.Set().empty();
    }

    public VisitorPhase<PlannerContext, BaseState> getTransformer(boolean pushdownPropertyReads, Seq<SemanticFeature> semanticFeatures) {
        return this;
    }

    private void resolveStrictly(DatabaseReferenceRepository databaseReferenceRepository, VerifyGraphTarget.GraphNameWithContext graphNameWithContext, NamedDatabaseId databaseId, boolean allowCompositeQueries) {
        DatabaseReferenceImpl.Internal internal;
        DatabaseReference databaseReference;
        CatalogName catalogName = graphNameWithContext.graphName();
        NormalizedDatabaseName normalizedDatabaseName = new NormalizedDatabaseName(catalogName.qualifiedNameString());
        boolean bl = false;
        Some some = null;
        Option option = OptionConverters$.MODULE$.toScala(databaseReferenceRepository.getByAlias(NormalizedCatalogEntry.fromList((List)catalogName.names())));
        if (None$.MODULE$.equals(option)) {
            throw DatabaseNotFoundHelper.databaseNameNotFoundWithoutDot((String)catalogName.qualifiedNameString());
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            DatabaseReference databaseReference2 = (DatabaseReference)some.value();
            if (!allowCompositeQueries && databaseReference2.namespace().isPresent()) {
                throw InvalidSemanticsException.accessingMultipleGraphsOnlySupportedOnCompositeDatabases((String)MessageUtilProvider$.MODULE$.createMultipleGraphReferencesError(normalizedDatabaseName.name(), MessageUtilProvider$.MODULE$.createMultipleGraphReferencesError$default$2()));
            }
        }
        if (bl) {
            DatabaseReference databaseReference3 = (DatabaseReference)some.value();
            if (allowCompositeQueries && databaseReference3.namespace().isPresent()) {
                return;
            }
        }
        if (bl && (databaseReference = (DatabaseReference)some.value()) instanceof DatabaseReferenceImpl.Internal && !(internal = (DatabaseReferenceImpl.Internal)databaseReference).databaseId().equals((Object)databaseId)) {
            this.unsupportedQueryRouting(graphNameWithContext);
            return;
        }
    }

    private void resolveNonStrictly(DatabaseReferenceRepository databaseReferenceRepository, VerifyGraphTarget.GraphNameWithContext graphNameWithContext, NamedDatabaseId databaseId, boolean allowCompositeQueries, InternalNotificationLogger notificationLogger) {
        DatabaseReferenceImpl.Internal internal;
        Some some;
        DatabaseReference databaseReference;
        Optional resolvedAlias;
        Option option;
        CatalogName catalogName = graphNameWithContext.graphName();
        NormalizedDatabaseName normalizedDatabaseName = new NormalizedDatabaseName(catalogName.qualifiedNameString());
        if (!allowCompositeQueries && catalogName.names().size() > 1) {
            notificationLogger.log((InternalNotification)new DeprecatedDatabaseNameNotification(catalogName.qualifiedNameString(), Option$.MODULE$.empty()));
        }
        if (!(!None$.MODULE$.equals(option = OptionConverters$.MODULE$.toScala(resolvedAlias = catalogName.resolveStrictly() ? databaseReferenceRepository.getByAlias(NormalizedCatalogEntry.fromList((List)catalogName.names())) : databaseReferenceRepository.getByAlias(normalizedDatabaseName))) || allowCompositeQueries && this.isConstituent(databaseReferenceRepository, normalizedDatabaseName))) {
            throw DatabaseNotFoundHelper.databaseNameNotFoundWithoutDot((String)graphNameWithContext.graphName().qualifiedNameString());
        }
        if (option instanceof Some && (databaseReference = (DatabaseReference)(some = (Some)option).value()) instanceof DatabaseReferenceImpl.Internal && !(internal = (DatabaseReferenceImpl.Internal)databaseReference).databaseId().equals((Object)databaseId)) {
            this.unsupportedQueryRouting(graphNameWithContext);
            return;
        }
    }

    private void unsupportedQueryRouting(VerifyGraphTarget.GraphNameWithContext graphNameWithContext) {
        if (graphNameWithContext.combinedWithAmbientGraph()) {
            throw InvalidSemanticsException.accessingMultipleGraphsOnlySupportedOnCompositeDatabases((String)MessageUtilProvider$.MODULE$.createMultipleGraphReferencesError(graphNameWithContext.graphName().qualifiedNameString(), MessageUtilProvider$.MODULE$.createMultipleGraphReferencesError$default$2()));
        }
        throw new InvalidSemanticsException("Query routing is not available in embedded sessions. Try running the query using a Neo4j driver or the HTTP API.");
    }

    private void verifyGraphTarget(DatabaseReferenceRepository databaseReferenceRepository, Statement statement, NamedDatabaseId databaseId, boolean allowCompositeQueries, MapValue params, InternalNotificationLogger notificationLogger) {
        Option<VerifyGraphTarget.GraphNameWithContext> option = this.evaluateGraphSelection(statement, databaseReferenceRepository, params);
        if (option instanceof Some) {
            Some some = (Some)option;
            VerifyGraphTarget.GraphNameWithContext graphNameWithContext = (VerifyGraphTarget.GraphNameWithContext)some.value();
            if (graphNameWithContext.graphName().resolveStrictly()) {
                this.resolveStrictly(databaseReferenceRepository, graphNameWithContext, databaseId, allowCompositeQueries);
                return;
            }
            this.resolveNonStrictly(databaseReferenceRepository, graphNameWithContext, databaseId, allowCompositeQueries, notificationLogger);
            return;
        }
    }

    private boolean isConstituent(DatabaseReferenceRepository databaseReferenceRepository, NormalizedDatabaseName normalizedDatabaseName) {
        return ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)databaseReferenceRepository.getCompositeDatabaseReferences()).asScala().flatMap((Function1 & Serializable)x$1 -> CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)x$1.constituents()).asScala())).map((Function1 & Serializable)x$2 -> x$2.fullName())).exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)VerifyGraphTarget$.$anonfun$isConstituent$3(normalizedDatabaseName, x$3)));
    }

    private Option<VerifyGraphTarget.GraphNameWithContext> evaluateGraphSelection(Statement statement, DatabaseReferenceRepository databaseReferenceRepository, MapValue params) {
        return this.findGraphSelection(statement).map((Function1 & Serializable)x$4 -> MODULE$.evaluateGraphSelection((VerifyGraphTarget.PositionalGraphSelection)x$4, databaseReferenceRepository, params));
    }

    private Option<VerifyGraphTarget.PositionalGraphSelection> findGraphSelection(Statement statement) {
        Option<GraphSelection> option = this.leadingGraphSelection(statement);
        if (option instanceof Some) {
            Some some = (Some)option;
            GraphSelection graphSelection = (GraphSelection)some.value();
            return new Some((Object)new VerifyGraphTarget.PositionalGraphSelection(graphSelection, true));
        }
        if (None$.MODULE$.equals(option)) {
            Option option2 = statement.folder().treeFindByClass(ClassTag$.MODULE$.apply(UseGraph.class));
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                UseGraph graphSelection = (UseGraph)some.value();
                return new Some((Object)new VerifyGraphTarget.PositionalGraphSelection((GraphSelection)graphSelection, false));
            }
            if (None$.MODULE$.equals(option2)) {
                return None$.MODULE$;
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError(option);
    }

    private VerifyGraphTarget.GraphNameWithContext evaluateGraphSelection(VerifyGraphTarget.PositionalGraphSelection graphSelection, DatabaseReferenceRepository databaseReferenceRepository, MapValue params) {
        GraphFunctionReference graphFunctionReference;
        GraphReference graphReference = graphSelection.graphSelection().graphReference();
        if (graphReference instanceof GraphDirectReference) {
            GraphDirectReference graphDirectReference = (GraphDirectReference)graphReference;
            return new VerifyGraphTarget.GraphNameWithContext(graphDirectReference.catalogName(), !graphSelection.leading());
        }
        if (graphReference instanceof GraphFunctionReference && (graphFunctionReference = (GraphFunctionReference)graphReference).functionInvocation().function().equals((Object)GraphByElementId$.MODULE$)) {
            Expression elementIdExpr = (Expression)((FunctionInvocation)graphFunctionReference.arguments().head()).args().head();
            SimpleInternalExpressionEvaluator qual$1 = new SimpleInternalExpressionEvaluator();
            Expression x$1 = elementIdExpr;
            MapValue x$2 = params;
            CypherRow x$3 = qual$1.evaluate$default$3();
            StringValue elementIdValue = (StringValue)qual$1.evaluate(x$1, x$2, x$3);
            UUID databaseId = ElementIdDecoder.database((String)elementIdValue.stringValue());
            return new VerifyGraphTarget.GraphNameWithContext(CatalogName$.MODULE$.of(((DatabaseReference)databaseReferenceRepository.getByUuid(databaseId).orElseThrow(() -> DatabaseNotFoundHelper.byElementIdFunction((String)elementIdValue.stringValue()))).name(), true), !graphSelection.leading());
        }
        throw new InvalidSemanticsException("Expected static graph selection");
    }

    private Option<SingleQuery> leftmostSingleQuery(Statement statement) {
        while (true) {
            Statement statement2;
            if ((statement2 = statement) instanceof SingleQuery) {
                SingleQuery singleQuery = (SingleQuery)statement2;
                return new Some((Object)singleQuery);
            }
            if (!(statement2 instanceof Union)) break;
            Union union = (Union)statement2;
            statement = union.lhs();
        }
        return None$.MODULE$;
    }

    private Option<GraphSelection> leadingGraphSelection(Statement statement) {
        Option<SingleQuery> singleQuery = this.leftmostSingleQuery(statement);
        Option clause = singleQuery.flatMap((Function1 & Serializable)x$5 -> x$5.clauses().headOption());
        return clause.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Clause, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof GraphSelection) {
                    GraphSelection graphSelection = (GraphSelection)A1;
                    return (B1)graphSelection;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Clause x1) {
                Clause clause = x1;
                return clause instanceof GraphSelection;
            }
        });
    }

    public String productPrefix() {
        return "VerifyGraphTarget";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof VerifyGraphTarget$;
    }

    public int hashCode() {
        return 829748774;
    }

    public String toString() {
        return "VerifyGraphTarget";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(VerifyGraphTarget$.class);
    }

    private final void completed$lzycompute$1() {
        VerifyGraphTarget$ verifyGraphTarget$ = this;
        synchronized (verifyGraphTarget$) {
            if (completed$module == null) {
                completed$module = new StepSequencer.DefaultPostCondition.completed$((StepSequencer.DefaultPostCondition)this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$isConstituent$3(NormalizedDatabaseName normalizedDatabaseName$1, NormalizedDatabaseName x$3) {
        NormalizedDatabaseName normalizedDatabaseName = x$3;
        NormalizedDatabaseName normalizedDatabaseName2 = normalizedDatabaseName$1;
        return !(normalizedDatabaseName != null ? !normalizedDatabaseName.equals(normalizedDatabaseName2) : normalizedDatabaseName2 != null);
    }

    private VerifyGraphTarget$() {
    }
}

