/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical.idp;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.cypher.internal.compiler.helpers.IteratorSupport$;
import org.neo4j.cypher.internal.compiler.planner.logical.ProjectingSelector;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.BestResults;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.DefaultIdRegistry;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.ExtraRequirement;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.Goal;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPCache;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPLoggable;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPLoggable$;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPLogger;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPSolver$;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPSolverMonitor;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPSolverStep;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPTable;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IdRegistry;
import org.neo4j.cypher.internal.util.CancellationChecker;
import org.neo4j.exceptions.InternalException;
import org.neo4j.time.Stopwatch;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.BitSet;
import scala.collection.immutable.BitSet$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\t]c\u0001B\u000f\u001f\u0001=B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u001d\"A!\u000b\u0001B\u0001B\u0003%1\u000b\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003[\u0011!9\u0007A!A!\u0002\u0013A\u0007\u0002C6\u0001\u0005\u0003\u0005\u000b\u0011\u00027\t\u0011=\u0004!\u0011!Q\u0001\nAD\u0001b\u001d\u0001\u0003\u0002\u0003\u0006I\u0001\u001e\u0005\to\u0002\u0011\t\u0011)A\u0005q\"Iq\u0010\u0001B\u0001B\u0003%\u0011\u0011\u0001\u0005\u000b\u0003\u001b\u0001!\u0011!Q\u0001\n\u0005=\u0001BCA\u000b\u0001\t\r\t\u0015a\u0003\u0002\u0018!9\u0011Q\u0004\u0001\u0005\u0002\u0005}\u0001bBA\u001f\u0001\u0011\u0005\u0011q\b\u0005\b\u0003S\u0002A\u0011BA6\u0011\u001d\t\u0019\b\u0001C\u0005\u0003kBq!a$\u0001\t\u0013\t\t\nC\u0004\u0002\u001c\u0002!I!!(\t\u000f\u0005E\u0006\u0001\"\u0003\u00024\"9\u0011q\u0018\u0001\u0005\n\u0005\u0005\u0007bBAg\u0001\u0011%\u0011q\u001a\u0005\b\u0003_\u0004A\u0011BAy\u000f%\tiPHA\u0001\u0012\u0003\tyP\u0002\u0005\u001e=\u0005\u0005\t\u0012\u0001B\u0001\u0011\u001d\ti\u0002\u0007C\u0001\u0005\u0007A\u0011B!\u0002\u0019#\u0003%\tAa\u0002\t\u0013\t=\u0002$%A\u0005\u0002\tE\u0002\"\u0003B%1E\u0005I\u0011\u0001B&\u0005%IE\tU*pYZ,'O\u0003\u0002 A\u0005\u0019\u0011\u000e\u001a9\u000b\u0005\u0005\u0012\u0013a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003G\u0011\nq\u0001\u001d7b]:,'O\u0003\u0002&M\u0005A1m\\7qS2,'O\u0003\u0002(Q\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002*U\u000511-\u001f9iKJT!a\u000b\u0017\u0002\u000b9,w\u000e\u000e6\u000b\u00035\n1a\u001c:h\u0007\u0001)B\u0001\r I\u0017N\u0011\u0001!\r\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\u0007\u0003:L(+\u001a4\u0002\u0013\u001d,g.\u001a:bi>\u0014\b#B\u001d;y\u001dSU\"\u0001\u0010\n\u0005mr\"!D%E!N{GN^3s'R,\u0007\u000f\u0005\u0002>}1\u0001A!B \u0001\u0005\u0004\u0001%\u0001C*pYZ\f'\r\\3\u0012\u0005\u0005#\u0005C\u0001\u001aC\u0013\t\u00195GA\u0004O_RD\u0017N\\4\u0011\u0005I*\u0015B\u0001$4\u0005\r\te.\u001f\t\u0003{!#Q!\u0013\u0001C\u0002\u0001\u0013aAU3tk2$\bCA\u001fL\t\u0015a\u0005A1\u0001A\u0005\u001d\u0019uN\u001c;fqR\f!\u0003\u001d:pU\u0016\u001cG/\u001b8h'\u0016dWm\u0019;peB\u0019q\nU$\u000e\u0003\u0001J!!\u0015\u0011\u0003%A\u0013xN[3di&twmU3mK\u000e$xN]\u0001\u0010e\u0016<\u0017n\u001d;ss\u001a\u000b7\r^8ssB\u0019!\u0007\u0016,\n\u0005U\u001b$!\u0003$v]\u000e$\u0018n\u001c81!\rIt\u000bP\u0005\u00031z\u0011!\"\u00133SK\u001eL7\u000f\u001e:z\u00031!\u0018M\u00197f\r\u0006\u001cGo\u001c:z!\u0015\u00114LV/e\u0013\ta6GA\u0005Gk:\u001cG/[8oeA!a,\u0019\u001fH\u001d\tIt,\u0003\u0002a=\u00059\u0001/Y2lC\u001e,\u0017B\u00012d\u0005\u0011\u0019V-\u001a3\u000b\u0005\u0001t\u0002cA\u001df\u000f&\u0011aM\b\u0002\t\u0013\u0012\u0003F+\u00192mK\u0006aQ.\u0019=UC\ndWmU5{KB\u0011!'[\u0005\u0003UN\u00121!\u00138u\u0003YIG/\u001a:bi&|g\u000eR;sCRLwN\u001c'j[&$\bC\u0001\u001an\u0013\tq7G\u0001\u0003M_:<\u0017\u0001E3yiJ\f'+Z9vSJ,W.\u001a8u!\rI\u0014oR\u0005\u0003ez\u0011\u0001#\u0012=ue\u0006\u0014V-];je\u0016lWM\u001c;\u0002\u000f5|g.\u001b;peB\u0011\u0011(^\u0005\u0003mz\u0011\u0001#\u0013#Q'>dg/\u001a:N_:LGo\u001c:\u0002!M$x\u000e],bi\u000eDg)Y2u_JL\bc\u0001\u001aUsB\u0011!0`\u0007\u0002w*\u0011APK\u0001\u0005i&lW-\u0003\u0002\u007fw\nI1\u000b^8qo\u0006$8\r[\u0001\u0014G\u0006t7-\u001a7mCRLwN\\\"iK\u000e\\WM\u001d\t\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0019\u0011q\u0001\u0014\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u0017\t)AA\nDC:\u001cW\r\u001c7bi&|gn\u00115fG.,'/A\u0005jIBdunZ4feB\u0019\u0011(!\u0005\n\u0007\u0005MaDA\u0005J\tBcunZ4fe\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\te\nI\u0002P\u0005\u0004\u00037q\"aC%E!2{wmZ1cY\u0016\fa\u0001P5oSRtD\u0003GA\u0011\u0003O\tI#a\u000b\u0002.\u0005=\u0012\u0011GA\u001a\u0003k\t9$!\u000f\u0002<Q!\u00111EA\u0013!\u0015I\u0004\u0001P$K\u0011\u001d\t)\"\u0004a\u0002\u0003/AQaN\u0007A\u0002aBQ!T\u0007A\u00029CqAU\u0007\u0011\u0002\u0003\u00071\u000bC\u0004Z\u001bA\u0005\t\u0019\u0001.\t\u000b\u001dl\u0001\u0019\u00015\t\u000b-l\u0001\u0019\u00017\t\u000b=l\u0001\u0019\u00019\t\u000bMl\u0001\u0019\u0001;\t\u000b]l\u0001\u0019\u0001=\t\r}l\u0001\u0019AA\u0001\u0011%\ti!\u0004I\u0001\u0002\u0004\ty!A\u0003baBd\u0017\u0010\u0006\u0005\u0002B\u0005\u001d\u00131JA3!\u0011I\u00141I$\n\u0007\u0005\u0015cDA\u0006CKN$(+Z:vYR\u001c\bBBA%\u001d\u0001\u0007Q,\u0001\u0003tK\u0016$\u0007bBA'\u001d\u0001\u0007\u0011qJ\u0001\fS:LG/[1m)>$u\u000eE\u0003\u0002R\u0005}CH\u0004\u0003\u0002T\u0005uc\u0002BA+\u00037j!!a\u0016\u000b\u0007\u0005ec&\u0001\u0004=e>|GOP\u0005\u0002i%\u0011\u0001mM\u0005\u0005\u0003C\n\u0019GA\u0002TKFT!\u0001Y\u001a\t\r\u0005\u001dd\u00021\u0001K\u0003\u001d\u0019wN\u001c;fqR\f1A];o)!\t\t%!\u001c\u0002p\u0005E\u0004BBA%\u001f\u0001\u0007Q\fC\u0004\u0002N=\u0001\r!a\u0014\t\r\u0005\u001dt\u00021\u0001K\u0003!awnZ*uCJ$H\u0003CA<\u0003{\n\t)!\"\u0011\u0007I\nI(C\u0002\u0002|M\u0012A!\u00168ji\"1\u0011q\u0010\tA\u0002Y\u000b\u0001B]3hSN$(/\u001f\u0005\u0007\u0003\u0007\u0003\u0002\u0019\u00013\u0002\u000bQ\f'\r\\3\t\u000f\u0005\u001d\u0005\u00031\u0001\u0002\n\u0006!Ao\u001c#p!\rI\u00141R\u0005\u0004\u0003\u001bs\"\u0001B$pC2\fQ\u0002\\8h\u0007>l\u0007/Y2uS>tG\u0003CA<\u0003'\u000b)*a&\t\r\u0005}\u0014\u00031\u0001W\u0011\u0019\t\u0019)\u0005a\u0001I\"9\u0011\u0011T\tA\u0002\u0005%\u0015\u0001C8sS\u001eLg.\u00197\u000251|w-\u0013;fe\u0006$\u0018n\u001c8Gk2d\u0017pQ8na2,G/\u001a3\u0015\u0019\u0005]\u0014qTAR\u0003K\u000bI+!,\t\r\u0005\u0005&\u00031\u0001z\u0003\u0015\u0019H/\u0019:u\u0011\u0019\t\u0019I\u0005a\u0001I\"1\u0011q\u0015\nA\u0002!\fq\u0002^1cY\u0016\u001c\u0016N_3CK\u001a|'/\u001a\u0005\u0007\u0003W\u0013\u0002\u0019\u00015\u0002\u0013\tdwnY6TSj,\u0007BBAX%\u0001\u0007\u0001.\u0001\u0007nCb\u0014En\\2l'&TX-\u0001\rm_\u001e$\u0016M\u00197f'&TX\rT5nSR\u0014V-Y2iK\u0012$B\"a\u001e\u00026\u0006]\u0016\u0011XA^\u0003{Ca!!)\u0014\u0001\u0004I\bBBAB'\u0001\u0007A\r\u0003\u0004\u0002(N\u0001\r\u0001\u001b\u0005\u0007\u0003W\u001b\u0002\u0019\u00015\t\r\u0005=6\u00031\u0001i\u0003Mawn\u001a+j[\u0016d\u0015.\\5u%\u0016\f7\r[3e)1\t9(a1\u0002F\u0006\u001d\u0017\u0011ZAf\u0011\u0019\t\t\u000b\u0006a\u0001s\"1\u00111\u0011\u000bA\u0002\u0011Da!a*\u0015\u0001\u0004A\u0007BBAV)\u0001\u0007\u0001\u000e\u0003\u0004\u00020R\u0001\r\u0001[\u0001\u0010Y><G*[7jiJ+\u0017m\u00195fIRq\u0011qOAi\u0003K\f9/!;\u0002l\u00065\bbBAj+\u0001\u0007\u0011Q[\u0001\nY&l\u0017\u000e\u001e+za\u0016\u0004B!a6\u0002`:!\u0011\u0011\\An!\r\t)fM\u0005\u0004\u0003;\u001c\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002b\u0006\r(AB*ue&twMC\u0002\u0002^NBa!!)\u0016\u0001\u0004I\bBBAB+\u0001\u0007A\r\u0003\u0004\u0002(V\u0001\r\u0001\u001b\u0005\u0007\u0003W+\u0002\u0019\u00015\t\r\u0005=V\u00031\u0001i\u0003Q1wN]7bi&#XM]1uS>t7\u000b^1uKRa\u0011Q[Az\u0003k\f90!?\u0002|\"1\u0011\u0011\u0015\fA\u0002eDa!a!\u0017\u0001\u0004!\u0007BBAT-\u0001\u0007\u0001\u000e\u0003\u0004\u0002,Z\u0001\r\u0001\u001b\u0005\u0007\u0003_3\u0002\u0019\u00015\u0002\u0013%#\u0005kU8mm\u0016\u0014\bCA\u001d\u0019'\tA\u0012\u0007\u0006\u0002\u0002\u0000\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\u0002B!\u0003\u0003\u0018\t-\"QF\u000b\u0003\u0005\u0017QCA!\u0004\u0003\u001aA!!\u0007\u0016B\b!\u0015I$\u0011\u0003B\u000b\u0013\r\u0011\u0019B\b\u0002\u0012\t\u00164\u0017-\u001e7u\u0013\u0012\u0014VmZ5tiJL\bcA\u001f\u0003\u0018\u0011)qH\u0007b\u0001\u0001.\u0012!1\u0004\t\u0005\u0005;\u00119#\u0004\u0002\u0003 )!!\u0011\u0005B\u0012\u0003%)hn\u00195fG.,GMC\u0002\u0003&M\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0011ICa\b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rB\u0003J5\t\u0007\u0001\tB\u0003M5\t\u0007\u0001)A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u000b\t\u0005g\u0011iDa\u0011\u0003HU\u0011!Q\u0007\u0016\u0005\u0005o\u0011I\u0002\u0005\u000537\ne\"q\bB#!\u0011ItKa\u000f\u0011\u0007u\u0012i\u0004B\u0003@7\t\u0007\u0001\t\u0005\u0004_C\nm\"\u0011\t\t\u0004{\t\rC!B%\u001c\u0005\u0004\u0001\u0005\u0003B\u001df\u0005\u0003\"Q\u0001T\u000eC\u0002\u0001\u000bA\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n\u0014'\u0006\u0005\u0003N\tE#1\u000bB++\t\u0011yE\u000b\u0003\u0002\u0010\teA!B \u001d\u0005\u0004\u0001E!B%\u001d\u0005\u0004\u0001E!\u0002'\u001d\u0005\u0004\u0001\u0005")
public class IDPSolver<Solvable, Result, Context> {
    private final IDPSolverStep<Solvable, Result, Context> generator;
    private final ProjectingSelector<Result> projectingSelector;
    private final Function0<IdRegistry<Solvable>> registryFactory;
    private final Function2<IdRegistry<Solvable>, Iterable<Tuple2<Tuple2<Set<Solvable>, Object>, Result>>, IDPTable<Result>> tableFactory;
    private final int maxTableSize;
    private final long iterationDurationLimit;
    private final ExtraRequirement<Result> extraRequirement;
    private final IDPSolverMonitor monitor;
    private final Function0<Stopwatch> stopWatchFactory;
    private final CancellationChecker cancellationChecker;
    private final IDPLogger idpLogger;
    private final IDPLoggable<Solvable> evidence$1;

    public static <Solvable, Result, Context> IDPLogger $lessinit$greater$default$11() {
        return IDPSolver$.MODULE$.$lessinit$greater$default$11();
    }

    public static <Solvable, Result, Context> Function2<IdRegistry<Solvable>, Iterable<Tuple2<Tuple2<Set<Solvable>, Object>, Result>>, IDPTable<Result>> $lessinit$greater$default$4() {
        return IDPSolver$.MODULE$.$lessinit$greater$default$4();
    }

    public static <Solvable, Result, Context> Function0<DefaultIdRegistry<Solvable>> $lessinit$greater$default$3() {
        return IDPSolver$.MODULE$.$lessinit$greater$default$3();
    }

    public BestResults<Result> apply(Iterable<Tuple2<Tuple2<Set<Solvable>, Object>, Result>> seed, Seq<Solvable> initialToDo, Context context) {
        return (BestResults)this.idpLogger.markScope("IDP", (Function0 & Serializable)() -> this.run(seed, initialToDo, context));
    }

    private BestResults<Result> run(Iterable<Tuple2<Tuple2<Set<Solvable>, Object>, Result>> seed, Seq<Solvable> initialToDo, Context context) {
        IdRegistry registry = (IdRegistry)this.registryFactory.apply();
        ObjectRef toDo = ObjectRef.create((Object)new Goal(registry.registerAll(initialToDo)));
        IDPTable table = (IDPTable)this.tableFactory.apply((Object)registry, seed);
        IntRef iterations = IntRef.create((int)0);
        this.logStart(registry, table, (Goal)toDo.elem);
        while (((Goal)toDo.elem).size() > 1) {
            ++iterations.elem;
            this.idpLogger.log((Function0<String>)(Function0 & Serializable)() -> "Iteration " + iterations$1.elem);
            this.monitor.startIteration(iterations.elem);
            int largestFinished = this.generateBestCandidates$1(((Goal)toDo.elem).size(), table, toDo, registry, context);
            if (largestFinished <= 0) {
                throw InternalException.foundNoPlanWithinConstraints((String)GraphDatabaseInternalSettings.cypher_idp_solver_table_threshold.name(), (String)GraphDatabaseInternalSettings.cypher_idp_solver_duration_threshold.name());
            }
            Goal bestGoal = this.findBestCandidateInBlock$1(largestFinished, table);
            this.monitor.endIteration(iterations.elem, largestFinished, table.size());
            this.compactBlock$1(bestGoal, registry, table, toDo);
        }
        this.monitor.foundPlanAfter(iterations.elem);
        this.idpLogger.log((Function0<String>)(Function0 & Serializable)() -> "Done after " + iterations$1.elem + " iteration(s)");
        Tuple2 tuple2 = table.plans().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Object result = tuple2._2();
                if (tuple22 != null) {
                    boolean fulfilsReq = tuple22._2$mcZ$sp();
                    return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)fulfilsReq), result);
                }
            }
            throw new MatchError((Object)tuple2);
        }).partition((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)IDPSolver.$anonfun$run$18(x0$2)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterator plansFulfillingReq = (Iterator)tuple2._1();
        Iterator plans = (Iterator)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)plansFulfillingReq, (Object)plans);
        Iterator plansFulfillingReq2 = (Iterator)tuple22._1();
        Iterator plans2 = (Iterator)tuple22._2();
        Tuple2 tuple23 = (Tuple2)IteratorSupport$.MODULE$.RichIterator(plans2).toSingleOption().getOrElse((Function0 & Serializable)() -> {
            throw new InternalException("Expected a single plan to be left in the plan table");
        });
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        Object bestResult = tuple23._2();
        Object bestResult2 = bestResult;
        if (plansFulfillingReq2.hasNext()) {
            Tuple2 tuple24 = (Tuple2)IteratorSupport$.MODULE$.RichIterator(plansFulfillingReq2).toSingleOption().getOrElse((Function0 & Serializable)() -> {
                throw new InternalException("Expected a single plan that fulfils the requirements to be left in the plan table");
            });
            if (tuple24 == null) {
                throw new MatchError((Object)tuple24);
            }
            Object plan = tuple24._2();
            Object plan2 = plan;
            return new BestResults<Object>(bestResult2, (Option<Object>)new Some(plan2));
        }
        return new BestResults<Object>(bestResult2, (Option<Object>)None$.MODULE$);
    }

    private void logStart(IdRegistry<Solvable> registry, IDPTable<Result> table, Goal toDo) {
        this.idpLogger.log((Function0<String>)(Function0 & Serializable)() -> {
            Vector goalsSummaries = (Vector)((StrictOptimizedIterableOps)((StrictOptimizedIterableOps)toDo.bitSet().toVector().sorted((Ordering)Ordering.Int$.MODULE$)).flatMap((Function1 & Serializable)i -> IDPSolver.$anonfun$logStart$2(registry, BoxesRunTime.unboxToInt((Object)i)))).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    int idx = tuple2._1$mcI$sp();
                    Object solvable = tuple2._2();
                    return "[" + idx + "] " + IDPLoggable$.MODULE$.summary(solvable, $this.evidence$1);
                }
                throw new MatchError((Object)tuple2);
            });
            return "Initial table size = " + table.size() + "\nGoals [" + goalsSummaries.size() + "]: " + goalsSummaries.mkString("[\n  ", ",\n  ", "\n]");
        });
    }

    private void logCompaction(IdRegistry<Solvable> registry, IDPTable<Result> table, Goal original) {
        this.idpLogger.log((Function0<String>)(Function0 & Serializable)() -> {
            Set originalGoalsSummaries = (Set)registry.explode(original.bitSet()).map((Function1 & Serializable)x$10 -> IDPLoggable$.MODULE$.summary(x$10, $this.evidence$1));
            BitSet originalGoalsBits = registry.explodedBitSet(original.bitSet());
            return "Compacting goal " + original.bitSet() + " (exploded = " + originalGoalsBits + ") = " + originalGoalsSummaries.mkString("[\n  ", ",\n  ", "\n]") + "\nCompacted table size: " + table.size();
        });
    }

    private void logIterationFullyCompleted(Stopwatch start, IDPTable<Result> table, int tableSizeBefore, int blockSize, int maxBlockSize) {
        this.idpLogger.log((Function0<String>)(Function0 & Serializable)() -> "[\u2713] all done, " + this.formatIterationState(start, table, tableSizeBefore, blockSize, maxBlockSize));
    }

    private void logTableSizeLimitReached(Stopwatch start, IDPTable<Result> table, int tableSizeBefore, int blockSize, int maxBlockSize) {
        this.logLimitReached("table size", start, table, tableSizeBefore, blockSize, maxBlockSize);
    }

    private void logTimeLimitReached(Stopwatch start, IDPTable<Result> table, int tableSizeBefore, int blockSize, int maxBlockSize) {
        this.logLimitReached("time", start, table, tableSizeBefore, blockSize, maxBlockSize);
    }

    private void logLimitReached(String limitType, Stopwatch start, IDPTable<Result> table, int tableSizeBefore, int blockSize, int maxBlockSize) {
        this.idpLogger.log((Function0<String>)(Function0 & Serializable)() -> "[!] " + limitType + " limit reached, " + this.formatIterationState(start, table, tableSizeBefore, blockSize, maxBlockSize));
    }

    private String formatIterationState(Stopwatch start, IDPTable<Result> table, int tableSizeBefore, int blockSize, int maxBlockSize) {
        long elapsedTimeMs = start.elapsed(TimeUnit.MILLISECONDS);
        return "time(ms)=" + elapsedTimeMs + "/" + this.iterationDurationLimit + ", table=[" + table.size() + "/" + this.maxTableSize + " (+" + (table.size() - tableSizeBefore) + ")], blockSize=[" + blockSize + "/" + maxBlockSize + "]";
    }

    private final Function1 candidateSelector$1(Function0 resolved) {
        return (Function1 & Serializable)x$2 -> $this.projectingSelector.apply((Function1 & Serializable)x -> Predef$.MODULE$.identity(x), x$2, (Function0<String>)resolved);
    }

    private final Function1 goalSelector$1(Function0 resolved) {
        return (Function1 & Serializable)x$3 -> $this.projectingSelector.apply((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Object result = tuple2._2();
                return result;
            }
            throw new MatchError((Object)tuple2);
        }, x$3, (Function0<String>)resolved);
    }

    public static final /* synthetic */ void $anonfun$run$8(BooleanRef foundNoCandidate$1, IDPTable table$1, Goal goal$1, Object candidate) {
        foundNoCandidate$1.elem = false;
        table$1.put(goal$1, false, candidate);
    }

    public static final /* synthetic */ void $anonfun$run$9(BooleanRef foundNoCandidate$1, IDPTable table$1, Goal goal$1, Object candidate) {
        foundNoCandidate$1.elem = false;
        table$1.put(goal$1, true, candidate);
    }

    private final int generateBestCandidates$1(int maxBlockSize, IDPTable table$1, ObjectRef toDo$1, IdRegistry registry$1, Object context$2) {
        int largestFinishedIteration;
        block9: {
            largestFinishedIteration = 0;
            int blockSize = 1;
            boolean keepGoing = true;
            Stopwatch start = (Stopwatch)this.stopWatchFactory.apply();
            int tableSizeBefore = table$1.size();
            while (keepGoing && blockSize <= maxBlockSize) {
                BooleanRef foundNoCandidate = BooleanRef.create((boolean)true);
                Iterator<Goal> goals = ((Goal)toDo$1.elem).subGoals(++blockSize);
                while (keepGoing && goals.hasNext()) {
                    boolean bl;
                    this.cancellationChecker.throwIfCancelled();
                    Goal goal = (Goal)goals.next();
                    if (table$1.contains(goal, false)) continue;
                    Vector candidates = this.generator.apply(registry$1, goal, table$1, context$2).toVector();
                    Tuple2 tuple2 = candidates.partition((Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)this.extraRequirement.fulfils(result)));
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Iterable extraCandidates = (Iterable)tuple2._1();
                    Iterable baseCandidates = (Iterable)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)extraCandidates, (Object)baseCandidates);
                    Iterable extraCandidates2 = (Iterable)tuple22._1();
                    Iterable baseCandidates2 = (Iterable)tuple22._2();
                    Option bestExtraCandidate = (Option)this.candidateSelector$1((Function0 & Serializable)() -> "best sorted plan for " + goal.bitSet() + "@" + registry$1.explode(goal.bitSet())).apply((Object)extraCandidates2);
                    ((Option)this.candidateSelector$1((Function0 & Serializable)() -> "best overall plan for " + goal.bitSet() + "@" + registry$1.explode(goal.bitSet())).apply(baseCandidates2.$plus$plus((IterableOnce)Option$.MODULE$.option2Iterable(bestExtraCandidate).toIterable()))).foreach((Function1 & Serializable)candidate -> {
                        IDPSolver.$anonfun$run$8(foundNoCandidate, table$1, goal, candidate);
                        return BoxedUnit.UNIT;
                    });
                    bestExtraCandidate.foreach((Function1 & Serializable)candidate -> {
                        IDPSolver.$anonfun$run$9(foundNoCandidate, table$1, goal, candidate);
                        return BoxedUnit.UNIT;
                    });
                    if (blockSize == 2) {
                        bl = true;
                    } else if (table$1.size() > this.maxTableSize) {
                        this.logTableSizeLimitReached(start, table$1, tableSizeBefore, blockSize, maxBlockSize);
                        bl = false;
                    } else if (start.hasTimedOut(this.iterationDurationLimit, TimeUnit.MILLISECONDS)) {
                        this.logTimeLimitReached(start, table$1, tableSizeBefore, blockSize, maxBlockSize);
                        bl = false;
                    } else {
                        bl = true;
                    }
                    keepGoing = bl;
                }
                largestFinishedIteration = foundNoCandidate.elem || goals.hasNext() ? largestFinishedIteration : blockSize;
            }
            if (!keepGoing) break block9;
            this.logIterationFullyCompleted(start, table$1, tableSizeBefore, blockSize, maxBlockSize);
        }
        return largestFinishedIteration;
    }

    public static final /* synthetic */ Nothing$ $anonfun$run$11(int blockSize$1, Iterable blockCandidates$1, IDPTable table$1) {
        throw InternalException.foundNoSolutionForBlock((int)blockSize$1, (String)blockCandidates$1.toString(), (String)table$1.toString());
    }

    private final Goal findBestCandidateInBlock$1(int blockSize, IDPTable table$1) {
        Vector blockCandidates = table$1.unsortedPlansOfSize(blockSize).toVector();
        Option bestInBlock = (Option)this.goalSelector$1((Function0 & Serializable)() -> "Best candidate for block size " + blockSize).apply((Object)blockCandidates);
        Tuple2 tuple2 = (Tuple2)bestInBlock.getOrElse(() -> IDPSolver.$anonfun$run$11(blockSize, (Iterable)blockCandidates, table$1));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Goal goal = (Goal)tuple2._1();
        Goal goal2 = goal;
        return goal2;
    }

    private final void compactBlock$1(Goal original, IdRegistry registry$1, IDPTable table$1, ObjectRef toDo$1) {
        this.logCompaction(registry$1, table$1, original);
        int newId = registry$1.compact(original.bitSet());
        IDPCache.Results results = table$1.apply(original);
        if (results == null) {
            throw new MatchError(results);
        }
        Option result = results.result();
        Option sortedResult = results.sortedResult();
        Tuple2 tuple2 = new Tuple2(result, sortedResult);
        Option result2 = (Option)tuple2._1();
        Option sortedResult2 = (Option)tuple2._2();
        result2.foreach((Function1 & Serializable)x$6 -> {
            table$1.put(new Goal((BitSet)BitSet$.MODULE$.empty().$plus((Object)BoxesRunTime.boxToInteger((int)newId))), false, x$6);
            return BoxedUnit.UNIT;
        });
        sortedResult2.foreach((Function1 & Serializable)x$7 -> {
            table$1.put(new Goal((BitSet)BitSet$.MODULE$.empty().$plus((Object)BoxesRunTime.boxToInteger((int)newId))), true, x$7);
            return BoxedUnit.UNIT;
        });
        toDo$1.elem = new Goal((BitSet)((Goal)toDo$1.elem).bitSet().$minus$minus((IterableOnce)original.bitSet()).$plus((Object)BoxesRunTime.boxToInteger((int)newId)));
        table$1.removeAllTracesOf(original);
        this.idpLogger.log((Function0<String>)(Function0 & Serializable)() -> "New compacted goal id = " + newId);
    }

    public static final /* synthetic */ boolean $anonfun$run$18(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            boolean fulfilsReq = tuple2._1$mcZ$sp();
            return fulfilsReq;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Option $anonfun$logStart$2(IdRegistry registry$2, int i) {
        return registry$2.lookup(i).map((Function1 & Serializable)x$9 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)i)), x$9));
    }

    public IDPSolver(IDPSolverStep<Solvable, Result, Context> generator, ProjectingSelector<Result> projectingSelector, Function0<IdRegistry<Solvable>> registryFactory, Function2<IdRegistry<Solvable>, Iterable<Tuple2<Tuple2<Set<Solvable>, Object>, Result>>, IDPTable<Result>> tableFactory, int maxTableSize, long iterationDurationLimit, ExtraRequirement<Result> extraRequirement, IDPSolverMonitor monitor, Function0<Stopwatch> stopWatchFactory, CancellationChecker cancellationChecker, IDPLogger idpLogger, IDPLoggable<Solvable> evidence$1) {
        this.generator = generator;
        this.projectingSelector = projectingSelector;
        this.registryFactory = registryFactory;
        this.tableFactory = tableFactory;
        this.maxTableSize = maxTableSize;
        this.iterationDurationLimit = iterationDurationLimit;
        this.extraRequirement = extraRequirement;
        this.monitor = monitor;
        this.stopWatchFactory = stopWatchFactory;
        this.cancellationChecker = cancellationChecker;
        this.idpLogger = idpLogger;
        this.evidence$1 = evidence$1;
    }
}

