/*
 * Copyright (c) "Neo4j"
 * Neo4j Sweden AB [http://neo4j.com]
 *
 * This file is part of Neo4j.
 *
 * Neo4j is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.neo4j.cypher.internal.physicalplanning

import org.neo4j.cypher.internal.logical.plans.Expand.VariablePredicate
import org.neo4j.cypher.internal.runtime.ast.ExpressionVariable
import org.neo4j.exceptions.InternalException

object VariablePredicates {

  def expressionSlotForPredicate(predicate: VariablePredicate): Int =
    predicate match {
      case VariablePredicate(ExpressionVariable(offset, _), _) => offset
      case VariablePredicate(v, _) =>
        throw new InternalException(
          s"Failure during physical planning: the expression slot of variable $v has not been allocated."
        )
    }
}
