/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.logical.plans;

import java.util.regex.Pattern;
import org.neo4j.exceptions.InvalidArgumentException;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;

public final class NameValidator$ {
    public static final NameValidator$ MODULE$ = new NameValidator$();
    private static final Pattern usernamePattern = Pattern.compile("^[\\x21-\\x2B\\x2D-\\x39\\x3B-\\x7E]+$");
    private static final Pattern roleNamePattern = Pattern.compile("^[a-zA-Z0-9_]+$");
    private static final String reservedRoleName = "PUBLIC";

    private Pattern usernamePattern() {
        return usernamePattern;
    }

    private Pattern roleNamePattern() {
        return roleNamePattern;
    }

    private String reservedRoleName() {
        return reservedRoleName;
    }

    public boolean assertValidUsername(String name) {
        if (name == null || name.isEmpty()) {
            throw new InvalidArgumentException("The provided username is empty.");
        }
        if (!this.usernamePattern().matcher(name).matches()) {
            throw new InvalidArgumentException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Username '" + name + "' contains illegal characters.\n           |Use ascii characters that are not ',', ':' or whitespaces.")));
        }
        return true;
    }

    public boolean assertValidRoleName(String name) {
        if (name == null || name.isEmpty()) {
            throw new InvalidArgumentException("The provided role name is empty.");
        }
        if (!this.roleNamePattern().matcher(name).matches()) {
            throw new InvalidArgumentException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Role name '" + name + "' contains illegal characters.\n           |Use simple ascii characters, numbers and underscores.")));
        }
        return true;
    }

    public boolean assertValidAliasName(String name) {
        if (name == null || name.isEmpty()) {
            throw new InvalidArgumentException("The provided alias is empty.");
        }
        if (name.length() > 65534) {
            throw new InvalidArgumentException("The provided alias is to long, maximum characters are 65534.");
        }
        if (name.startsWith("system")) {
            throw new InvalidArgumentException("Alias name '" + name + "' is invalid, due to the prefix 'system'.");
        }
        return true;
    }

    public boolean assertValidTargetName(String name) {
        if (name == null || name.isEmpty()) {
            throw new InvalidArgumentException("The provided target database name is empty.");
        }
        if (name.length() > 65534) {
            throw new InvalidArgumentException("The provided target database name is to long, maximum characters are 65534.");
        }
        if (name.startsWith("system")) {
            throw new InvalidArgumentException("Target database name '" + name + "' is invalid, due to the prefix 'system'.");
        }
        return true;
    }

    public boolean assertUnreservedRoleName(String verb, String name, Option<String> newName) {
        if (this.reservedRoleName().equals(name)) {
            throw new InvalidArgumentException("Failed to " + verb + " the specified role '" + name + "': '" + name + "' is a reserved role.");
        }
        if (newName.isDefined() && this.reservedRoleName().equals(newName.get())) {
            throw new InvalidArgumentException("Failed to " + verb + " the specified role '" + name + "' to '" + newName.get() + "': '" + newName.get() + "' is a reserved role.");
        }
        return true;
    }

    public Option<String> assertUnreservedRoleName$default$3() {
        return None$.MODULE$;
    }

    private NameValidator$() {
    }
}

