/*
 * Copyright (c) "Neo4j"
 * Neo4j Sweden AB [http://neo4j.com]
 *
 * This file is part of Neo4j.
 *
 * Neo4j is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.neo4j.cypher.internal.logical.plans

import org.neo4j.cypher.internal.expressions.Expression
import org.neo4j.cypher.internal.ir.ShortestPathPattern
import org.neo4j.cypher.internal.util.attribution.IdGen

/**
 * Find the shortest paths between two nodes, as specified by 'shortestPath'. For each shortest path found produce a
 * row containing the source row and the found path.
 */
case class LegacyFindShortestPaths(
  override val source: LogicalPlan,
  shortestPath: ShortestPathPattern,
  predicates: Seq[Expression] = Seq.empty,
  withFallBack: Boolean = false,
  disallowSameNode: Boolean = true
)(implicit idGen: IdGen)
    extends LogicalUnaryPlan(idGen) {

  override def withLhs(newLHS: LogicalPlan)(idGen: IdGen): LogicalUnaryPlan = copy(source = newLHS)(idGen)

  override val availableSymbols: Set[String] = source.availableSymbols ++ shortestPath.availableSymbols
}
