/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.logical.plans;

import java.io.Serializable;
import java.net.URI;
import java.util.List;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.messages.MessageUtil;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.package$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class RemoteUrlValidator$ {
    public static final RemoteUrlValidator$ MODULE$ = new RemoteUrlValidator$();

    public Option<Throwable> assertValidRemoteDatabaseUrl(String url, boolean secure) {
        None$ none$;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            if (url == null || url.isEmpty()) {
                throw new InvalidArgumentException("The provided url is empty.");
            }
            String uriScheme = URI.create(url).getScheme();
            scala.collection.immutable.Seq validSchemes = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"neo4j", "neo4j+s", "neo4j+ssc"}));
            if (uriScheme == null || !validSchemes.contains((Object)uriScheme)) {
                throw new InvalidArgumentException(MessageUtil.invalidScheme((String)url, (List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)validSchemes).asJava())));
            }
            if (secure && !uriScheme.endsWith("+s") && !uriScheme.endsWith("+ssc")) {
                scala.collection.immutable.Seq secureSchemes = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"neo4j+s", "neo4j+ssc"}));
                throw new InvalidArgumentException(MessageUtil.insecureScheme((String)url, (List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)secureSchemes).asJava())));
            }
        });
        if (try_ instanceof Success) {
            none$ = None$.MODULE$;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            none$ = new Some((Object)e);
        } else {
            throw new MatchError((Object)try_);
        }
        return none$;
    }

    private RemoteUrlValidator$() {
    }
}

