/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.logical.plans;

import java.util.regex.Pattern;
import org.neo4j.exceptions.InvalidArgumentException;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;

public final class NameValidator$ {
    public static NameValidator$ MODULE$;
    private final Pattern usernamePattern;
    private final Pattern roleNamePattern;
    private final String reservedRoleName;

    static {
        new NameValidator$();
    }

    private Pattern usernamePattern() {
        return this.usernamePattern;
    }

    private Pattern roleNamePattern() {
        return this.roleNamePattern;
    }

    private String reservedRoleName() {
        return this.reservedRoleName;
    }

    public boolean assertValidUsername(String name, Seq<String> restrictedUsernames) {
        if (name == null || name.isEmpty()) {
            throw new InvalidArgumentException("The provided username is empty.");
        }
        if (!this.usernamePattern().matcher(name).matches()) {
            throw new InvalidArgumentException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(111).append("Username '").append(name).append("' contains illegal characters.\n           |Use ascii characters that are not ',', ':' or whitespaces.").toString())).stripMargin());
        }
        if (restrictedUsernames.contains((Object)name)) {
            throw new InvalidArgumentException(new StringBuilder(38).append("Username '").append(name).append("' is reserved by the system.").toString());
        }
        return true;
    }

    public Seq<String> assertValidUsername$default$2() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public boolean assertValidRoleName(String name) {
        if (name == null || name.isEmpty()) {
            throw new InvalidArgumentException("The provided role name is empty.");
        }
        if (!this.roleNamePattern().matcher(name).matches()) {
            throw new InvalidArgumentException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(107).append("Role name '").append(name).append("' contains illegal characters.\n           |Use simple ascii characters, numbers and underscores.").toString())).stripMargin());
        }
        return true;
    }

    public boolean assertUnreservedRoleName(String verb, String name) {
        if (this.reservedRoleName().equals(name)) {
            throw new InvalidArgumentException(new StringBuilder(56).append("Failed to ").append(verb).append(" the specified role '").append(name).append("': '").append(name).append("' is a reserved role.").toString());
        }
        return true;
    }

    private NameValidator$() {
        MODULE$ = this;
        this.usernamePattern = Pattern.compile("^[\\x21-\\x2B\\x2D-\\x39\\x3B-\\x7E]+$");
        this.roleNamePattern = Pattern.compile("^[a-zA-Z0-9_]+$");
        this.reservedRoleName = "PUBLIC";
    }
}

