/* Cypher.java */
/* Generated by: ParserGeneratorCC: Do not edit this line. Cypher.java */
/*
 * Copyright (c) 2002-2019 "Neo4j,"
 * Neo4j Sweden AB [http://neo4j.com]
 *
 * This file is part of Neo4j.
 *
 * Neo4j is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.neo4j.cypher.internal.parser.javacc;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.neo4j.cypher.internal.ast.factory.AccessType;
import org.neo4j.cypher.internal.ast.factory.ASTExceptionFactory;
import org.neo4j.cypher.internal.ast.factory.ASTFactory;
import org.neo4j.cypher.internal.ast.factory.ASTFactory.StringPos;
import org.neo4j.cypher.internal.ast.factory.ActionType;
import org.neo4j.cypher.internal.ast.factory.ConstraintType;
import org.neo4j.cypher.internal.ast.factory.ConstraintVersion;
import org.neo4j.cypher.internal.ast.factory.CreateIndexTypes;
import org.neo4j.cypher.internal.ast.factory.HintIndexType;
import org.neo4j.cypher.internal.ast.factory.ParameterType;
import org.neo4j.cypher.internal.ast.factory.ScopeType;
import org.neo4j.cypher.internal.ast.factory.ShowCommandFilterTypes;
import org.neo4j.cypher.internal.ast.factory.SimpleEither;

/** Simple brace matcher. */
public class Cypher<STATEMENT,
                    QUERY extends STATEMENT,
                    CLAUSE,
                    RETURN_CLAUSE extends CLAUSE,
                    RETURN_ITEM,
                    RETURN_ITEMS,
                    ORDER_ITEM,
                    PATTERN,
                    NODE_PATTERN,
                    REL_PATTERN,
                    PATH_LENGTH,
                    SET_CLAUSE extends CLAUSE,
                    SET_ITEM,
                    REMOVE_ITEM,
                    CALL_RESULT_ITEM,
                    HINT,
                    EXPRESSION,
                    PARAMETER extends EXPRESSION,
                    VARIABLE extends EXPRESSION,
                    PROPERTY extends EXPRESSION,
                    MAP_PROJECTION_ITEM,
                    USE_CLAUSE extends CLAUSE,
                    STATEMENT_WITH_GRAPH extends STATEMENT,
                    ADMINISTRATION_COMMAND extends STATEMENT_WITH_GRAPH,
                    SCHEMA_COMMAND extends STATEMENT_WITH_GRAPH,
                    YIELD extends CLAUSE,
                    WHERE,
                    DATABASE_SCOPE,
                    WAIT_CLAUSE,
                    ADMINISTRATION_ACTION,
                    GRAPH_SCOPE,
                    PRIVILEGE_TYPE,
                    PRIVILEGE_RESOURCE,
                    PRIVILEGE_QUALIFIER,
                    SUBQUERY_IN_TRANSACTIONS_PARAMETERS,
                    POS> implements CypherConstants {

    ASTExceptionFactory exceptionFactory;
    ASTFactory<STATEMENT,
               QUERY,
               CLAUSE,
               RETURN_CLAUSE,
               RETURN_ITEM,
               RETURN_ITEMS,
               ORDER_ITEM,
               PATTERN,
               NODE_PATTERN,
               REL_PATTERN,
               PATH_LENGTH,
               SET_CLAUSE,
               SET_ITEM,
               REMOVE_ITEM,
               CALL_RESULT_ITEM,
               HINT,
               EXPRESSION,
               PARAMETER,
               VARIABLE,
               PROPERTY,
               MAP_PROJECTION_ITEM,
               USE_CLAUSE,
               STATEMENT_WITH_GRAPH,
               ADMINISTRATION_COMMAND,
               SCHEMA_COMMAND,
               YIELD,
               WHERE,
               DATABASE_SCOPE,
               WAIT_CLAUSE,
               ADMINISTRATION_ACTION,
               GRAPH_SCOPE,
               PRIVILEGE_TYPE,
               PRIVILEGE_RESOURCE,
               PRIVILEGE_QUALIFIER,
               SUBQUERY_IN_TRANSACTIONS_PARAMETERS,
               POS> astFactory;

    public Cypher(ASTFactory<STATEMENT,
                             QUERY,
                             CLAUSE,
                             RETURN_CLAUSE,
                             RETURN_ITEM,
                             RETURN_ITEMS,
                             ORDER_ITEM,
                             PATTERN,
                             NODE_PATTERN,
                             REL_PATTERN,
                             PATH_LENGTH,
                             SET_CLAUSE,
                             SET_ITEM,
                             REMOVE_ITEM,
                             CALL_RESULT_ITEM,
                             HINT,
                             EXPRESSION,
                             PARAMETER,
                             VARIABLE,
                             PROPERTY,
                             MAP_PROJECTION_ITEM,
                             USE_CLAUSE,
                             STATEMENT_WITH_GRAPH,
                             ADMINISTRATION_COMMAND,
                             SCHEMA_COMMAND,
                             YIELD,
                             WHERE,
                             DATABASE_SCOPE,
                             WAIT_CLAUSE,
                             ADMINISTRATION_ACTION,
                             GRAPH_SCOPE,
                             PRIVILEGE_TYPE,
                             PRIVILEGE_RESOURCE,
                             PRIVILEGE_QUALIFIER,
                             SUBQUERY_IN_TRANSACTIONS_PARAMETERS,
                             POS> astFactory,
                  ASTExceptionFactory exceptionFactory,
                  CharStream stream) {
        this(stream);
        this.astFactory = astFactory;
        this.exceptionFactory = exceptionFactory;
    }

    private POS pos( Token t )
    {
        return t != null ? astFactory.inputPosition( t.beginOffset, t.beginLine, t.beginColumn ) : null;
    }

    private void assertValidType( Token t, String expected, String actual ) throws Exception
    {
        if ( expected != null && !expected.equals(actual) )
        {
            throw exceptionFactory.syntaxException( new ParseException(
                String.format("Invalid input '%s': expected \"%s\"", t.image, expected ) ), t.beginOffset, t.beginLine, t.beginColumn );
        }
    }

    private void assertNotAlreadySet( Object object, Token token, String errorMessage ) throws Exception
    {
        if ( object != null )
        {
            throw exceptionFactory.syntaxException( new ParseException( errorMessage ), token.beginOffset, token.beginLine, token.beginColumn );
        }
    }

/** Root production. */
  final public List<STATEMENT> Statements() throws ParseException, Exception {STATEMENT x;
    List<STATEMENT> stmts = new ArrayList<>();
    try {
      x = Statement();
stmts.add( x );
      label_1:
      while (true) {
        if (jj_2_1(2)) {
        } else {
          break label_1;
        }
        jj_consume_token(249);
        x = Statement();
stmts.add( x );
      }
      if (jj_2_2(2)) {
        jj_consume_token(249);
      } else {
        ;
      }
      jj_consume_token(0);
{if ("" != null) return stmts;}
    } catch (ParseException e) {
Token t = e.currentToken.next;
        if ( e.getMessage().contains( "Encountered \"<EOF>\"" ) )
        {
            throw exceptionFactory.syntaxException( t.image, ParseExceptions.expected( e.expectedTokenSequences, e.tokenImage ), e,
                                                   t.endOffset + 1, t.endLine, t.endColumn + 1 );
        }
        else
        {
            throw exceptionFactory.syntaxException( t.image, ParseExceptions.expected( e.expectedTokenSequences, e.tokenImage ), e,
                                                   t.beginOffset, t.beginLine, t.beginColumn );
        }
    } catch (InvalidUnicodeLiteral e) {
throw exceptionFactory.syntaxException( e, e.offset, e.line, e.column );
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT Statement() throws ParseException, Exception {STATEMENT statement;
    USE_CLAUSE useClause = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case USING:{
      statement = PeriodicCommitQuery();
      break;
      }
    case USE:{
      useClause = UseClause();
      statement = SingleQueryOrCommandWithUseClause(useClause);
      break;
      }
    case ALTER:
    case CALL:
    case CATALOG:
    case CREATE:
    case DELETE:
    case DENY:
    case DETACH:
    case DROP:
    case FOREACH:
    case GRANT:
    case LOAD:
    case MATCH:
    case MERGE:
    case OPTIONAL:
    case RENAME:
    case REMOVE:
    case RETURN:
    case REVOKE:
    case SET:
    case SHOW:
    case START:
    case STOP:
    case TERMINATE:
    case UNWIND:
    case WITH:{
      statement = SingleQueryOrCommand();
      break;
      }
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return statement;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT SingleQueryOrCommand() throws ParseException, Exception {STATEMENT statement = null;
    QUERY query = null;
    boolean hasCatalog = false;
    if (jj_2_3(2)) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case CATALOG:{
        jj_consume_token(CATALOG);
hasCatalog = true;
        break;
        }
      default:
        jj_la1[1] = jj_gen;
        ;
      }
      statement = CreateCommand(null);
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ALTER:
      case CATALOG:
      case DENY:
      case DROP:
      case GRANT:
      case RENAME:
      case REVOKE:
      case SHOW:
      case START:
      case STOP:
      case TERMINATE:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case CATALOG:{
          jj_consume_token(CATALOG);
hasCatalog = true;
          break;
          }
        default:
          jj_la1[2] = jj_gen;
          ;
        }
        statement = Command(null);
        break;
        }
      case CALL:
      case CREATE:
      case DELETE:
      case DETACH:
      case FOREACH:
      case LOAD:
      case MATCH:
      case MERGE:
      case OPTIONAL:
      case REMOVE:
      case RETURN:
      case SET:
      case UNWIND:
      case USE:
      case WITH:{
        query = SingleQuery();
        label_2:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case UNION:{
            break;
            }
          default:
            jj_la1[3] = jj_gen;
            break label_2;
          }
          query = Union(query);
        }
        break;
        }
      default:
        jj_la1[4] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
if ( query != null )
        {
            {if ("" != null) return query;}
        }
        {if ("" != null) return hasCatalog ? astFactory.hasCatalog( statement ) : statement;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT SingleQueryOrCommandWithUseClause(USE_CLAUSE useClause) throws ParseException, Exception {STATEMENT statement = null;
    QUERY query = null;
    boolean hasCatalog = false;
    if (jj_2_4(2)) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case CATALOG:{
        jj_consume_token(CATALOG);
hasCatalog = true;
        break;
        }
      default:
        jj_la1[5] = jj_gen;
        ;
      }
      statement = CreateCommand(useClause);
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ALTER:
      case CATALOG:
      case DENY:
      case DROP:
      case GRANT:
      case RENAME:
      case REVOKE:
      case SHOW:
      case START:
      case STOP:
      case TERMINATE:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case CATALOG:{
          jj_consume_token(CATALOG);
hasCatalog = true;
          break;
          }
        default:
          jj_la1[6] = jj_gen;
          ;
        }
        statement = Command(useClause);
        break;
        }
      default:
        jj_la1[8] = jj_gen;
        query = SingleQueryWithUseClause(useClause);
        label_3:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case UNION:{
            break;
            }
          default:
            jj_la1[7] = jj_gen;
            break label_3;
          }
          query = Union(query);
        }
      }
    }
if ( query != null )
        {
            {if ("" != null) return query;}
        }
        {if ("" != null) return hasCatalog ? astFactory.hasCatalog( statement ) : statement;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public QUERY PeriodicCommitQuery() throws ParseException {Token t;
    Token tPeriodicCommit;
    Token batchSize = null;
    CLAUSE loadCsv;
    List<CLAUSE> queryBody;
    t = jj_consume_token(USING);
    tPeriodicCommit = jj_consume_token(PERIODIC);
    jj_consume_token(COMMIT);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case UNSIGNED_DECIMAL_INTEGER:{
      batchSize = jj_consume_token(UNSIGNED_DECIMAL_INTEGER);
      break;
      }
    default:
      jj_la1[9] = jj_gen;
      ;
    }
    loadCsv = LoadCSVClause();
    queryBody = PeriodicCommitQueryBody();
{if ("" != null) return astFactory.periodicCommitQuery( pos( t ), pos( tPeriodicCommit ), batchSize == null ? null : batchSize.image, loadCsv, queryBody );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<CLAUSE> PeriodicCommitQueryBody() throws ParseException {CLAUSE x;
    List<CLAUSE> clauses = new ArrayList<>();
    label_4:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case CALL:
      case CREATE:
      case DELETE:
      case DETACH:
      case FOREACH:
      case LOAD:
      case MATCH:
      case MERGE:
      case OPTIONAL:
      case REMOVE:
      case RETURN:
      case SET:
      case UNWIND:
      case USE:
      case WITH:{
        break;
        }
      default:
        jj_la1[10] = jj_gen;
        break label_4;
      }
      x = Clause();
clauses.add( x );
    }
{if ("" != null) return clauses;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public QUERY RegularQuery() throws ParseException {QUERY x;
    x = SingleQuery();
    label_5:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case UNION:{
        break;
        }
      default:
        jj_la1[11] = jj_gen;
        break label_5;
      }
      x = Union(x);
    }
{if ("" != null) return x;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public QUERY Union(QUERY lhs) throws ParseException {Token t;
    QUERY rhs;
    boolean all = false;
    t = jj_consume_token(UNION);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ALL:{
      jj_consume_token(ALL);
all = true;
      break;
      }
    default:
      jj_la1[12] = jj_gen;
      ;
    }
    rhs = SingleQuery();
{if ("" != null) return astFactory.newUnion( pos( t ), lhs, rhs, all );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public QUERY SingleQuery() throws ParseException {CLAUSE x;
    List<CLAUSE> clauses = new ArrayList<>();
    label_6:
    while (true) {
      x = Clause();
clauses.add( x );
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case CALL:
      case CREATE:
      case DELETE:
      case DETACH:
      case FOREACH:
      case LOAD:
      case MATCH:
      case MERGE:
      case OPTIONAL:
      case REMOVE:
      case RETURN:
      case SET:
      case UNWIND:
      case USE:
      case WITH:{
        break;
        }
      default:
        jj_la1[13] = jj_gen;
        break label_6;
      }
    }
{if ("" != null) return astFactory.newSingleQuery( clauses );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public QUERY SingleQueryWithUseClause(CLAUSE useClause) throws ParseException {CLAUSE x;
    List<CLAUSE> clauses = new ArrayList<>();
    if ( useClause != null )
    {
      clauses.add( useClause );
    }
    label_7:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case CALL:
      case CREATE:
      case DELETE:
      case DETACH:
      case FOREACH:
      case LOAD:
      case MATCH:
      case MERGE:
      case OPTIONAL:
      case REMOVE:
      case RETURN:
      case SET:
      case UNWIND:
      case USE:
      case WITH:{
        break;
        }
      default:
        jj_la1[14] = jj_gen;
        break label_7;
      }
      x = Clause();
clauses.add( x );
    }
{if ("" != null) return astFactory.newSingleQuery( clauses );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public CLAUSE Clause() throws ParseException {CLAUSE x = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case USE:{
      x = UseClause();
      break;
      }
    case RETURN:{
      x = ReturnClause();
      break;
      }
    case CREATE:{
      x = CreateClause();
      break;
      }
    case DELETE:
    case DETACH:{
      x = DeleteClause();
      break;
      }
    case SET:{
      x = SetClause();
      break;
      }
    case REMOVE:{
      x = RemoveClause();
      break;
      }
    case MATCH:
    case OPTIONAL:{
      x = MatchClause();
      break;
      }
    case MERGE:{
      x = MergeClause();
      break;
      }
    case WITH:{
      x = WithClause();
      break;
      }
    case UNWIND:{
      x = UnwindClause();
      break;
      }
    default:
      jj_la1[15] = jj_gen;
      if (jj_2_5(2)) {
        x = CallClause();
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case CALL:{
          x = SubqueryClause();
          break;
          }
        case LOAD:{
          x = LoadCSVClause();
          break;
          }
        case FOREACH:{
          x = ForeachClause();
          break;
          }
        default:
          jj_la1[16] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
{if ("" != null) return x;}
    throw new IllegalStateException ("Missing return statement in function");
}

// USE
  final public 
USE_CLAUSE UseClause() throws ParseException {Token t;
    EXPRESSION e;
    t = jj_consume_token(USE);
    if (jj_2_6(2)) {
      jj_consume_token(GRAPH);
    } else {
      ;
    }
    e = Expression();
{if ("" != null) return astFactory.useClause(  pos( t ), e );}
    throw new IllegalStateException ("Missing return statement in function");
}

// RETURN
  final public 
RETURN_CLAUSE ReturnClause() throws ParseException {Token t;
    RETURN_CLAUSE clause = null;
    t = jj_consume_token(RETURN);
    clause = ReturnBody(t);
{if ("" != null) return clause;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public RETURN_CLAUSE ReturnBody(Token t) throws ParseException {Token skipPosition = null;
    Token limitPosition = null;
    boolean distinct = false;
    List<ORDER_ITEM> order = new ArrayList<>();
    Token orderPos = null;
    EXPRESSION skip = null;
    EXPRESSION limit = null;
    ORDER_ITEM o = null;
    RETURN_ITEM x;
    RETURN_ITEMS returnItems;
    if (jj_2_7(2)) {
      jj_consume_token(DISTINCT);
distinct = true;
    } else {
      ;
    }
    returnItems = ReturnItems();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ORDER:{
      orderPos = jj_consume_token(ORDER);
      jj_consume_token(BY);
      o = OrderItem();
order.add( o );
      label_8:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case 250:{
          break;
          }
        default:
          jj_la1[17] = jj_gen;
          break label_8;
        }
        jj_consume_token(250);
        o = OrderItem();
order.add( o );
      }
      break;
      }
    default:
      jj_la1[18] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SKIPROWS:{
skipPosition=token.next;
      skip = Skip();
      break;
      }
    default:
      jj_la1[19] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LIMITROWS:{
limitPosition=token.next;
      limit = Limit();
      break;
      }
    default:
      jj_la1[20] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.newReturnClause(  pos( t ), distinct, returnItems, order, pos( orderPos ), skip, pos( skipPosition ), limit, pos( limitPosition ) );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public RETURN_ITEM ReturnItem() throws ParseException {EXPRESSION e;
    VARIABLE v = null;
    Token eStart;
    Token eEnd;
eStart = token;
    e = Expression();
eEnd = token;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case AS:{
      jj_consume_token(AS);
      v = Variable();
      break;
      }
    default:
      jj_la1[21] = jj_gen;
      ;
    }
if ( v != null )
        {
            {if ("" != null) return astFactory.newReturnItem( pos( eStart.next ), e, v );}
        }
        else
        {
            {if ("" != null) return astFactory.newReturnItem( pos( eStart.next ), e, eStart.next.beginOffset, eEnd.endOffset );}
        }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public RETURN_ITEMS ReturnItems() throws ParseException {Token returnItemsPosition;
    RETURN_ITEM x;
    List<RETURN_ITEM> returnItems = new ArrayList<>();
    boolean returnAll = false;
returnItemsPosition = token;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case TIMES:{
      jj_consume_token(TIMES);
returnAll = true;
      label_9:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case 250:{
          break;
          }
        default:
          jj_la1[22] = jj_gen;
          break label_9;
        }
        jj_consume_token(250);
        x = ReturnItem();
returnItems.add( x );
      }
      break;
      }
    case DECIMAL_DOUBLE:
    case UNSIGNED_DECIMAL_INTEGER:
    case UNSIGNED_HEX_INTEGER:
    case UNSIGNED_OCTAL_INTEGER:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case AS:
    case ASC:
    case ASSERT:
    case ASSIGN:
    case AT:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASE:
    case CATALOG:
    case CHANGE:
    case COMMIT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DBMS:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESTROY:
    case DETACH:
    case DOLLAR:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DUMP:
    case EACH:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case EXTRACT:
    case FALSE:
    case FIELDTERMINATOR:
    case FILTER:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case HEADERS:
    case HOME:
    case IF:
    case IN:
    case INDEX:
    case INDEXES:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LBRACKET:
    case LCURLY:
    case LIMITROWS:
    case LOAD:
    case LOOKUP:
    case LPAREN:
    case MANAGEMENT:
    case MATCH:
    case MERGE:
    case MINUS:
    case NAME:
    case NAMES:
    case NEW:
    case NODE:
    case NODES:
    case NONE:
    case NOT:
    case NOWAIT:
    case NULL:
    case OF:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PERIODIC:
    case PLAINTEXT:
    case PLUS:
    case POINT:
    case POPULATED:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTY:
    case RANGE:
    case READ:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REQUIRE:
    case REQUIRED:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDS:
    case SEEK:
    case SET:
    case SHORTEST_PATH:
    case SHOW:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TO:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRUE:
    case TYPE:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNWIND:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VERBOSE:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WRITE:
    case XOR:
    case YIELD:
    case IDENTIFIER:{
      x = ReturnItem();
returnItems.add( x );
      label_10:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case 250:{
          break;
          }
        default:
          jj_la1[23] = jj_gen;
          break label_10;
        }
        jj_consume_token(250);
        x = ReturnItem();
returnItems.add( x );
      }
      break;
      }
    default:
      jj_la1[24] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return astFactory.newReturnItems( pos( returnItemsPosition.next ), returnAll, returnItems );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ORDER_ITEM OrderItem() throws ParseException {Token t;
    EXPRESSION e;
t = token;
    e = Expression();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DESC:{
      jj_consume_token(DESC);
{if ("" != null) return astFactory.orderDesc( pos( t.next ), e );}
      break;
      }
    default:
      jj_la1[26] = jj_gen;
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ASC:{
        jj_consume_token(ASC);
        break;
        }
      default:
        jj_la1[25] = jj_gen;
        ;
      }
{if ("" != null) return astFactory.orderAsc( pos( t.next ), e );}
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Skip() throws ParseException {EXPRESSION e;
    jj_consume_token(SKIPROWS);
    e = Expression();
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Limit() throws ParseException {EXPRESSION e;
    jj_consume_token(LIMITROWS);
    e = Expression();
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

// WHERE
  final public 
WHERE WhereClause() throws ParseException {Token t;
    EXPRESSION e;
    t = jj_consume_token(WHERE);
    e = Expression();
{if ("" != null) return astFactory.whereClause( pos( t ), e );}
    throw new IllegalStateException ("Missing return statement in function");
}

// WITH
  final public 
CLAUSE WithClause() throws ParseException {Token t;
    RETURN_CLAUSE returnClause;
    WHERE where = null;
    t = jj_consume_token(WITH);
    returnClause = ReturnBody(t);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      where = WhereClause();
      break;
      }
    default:
      jj_la1[27] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.withClause( pos( t ), returnClause, where );}
    throw new IllegalStateException ("Missing return statement in function");
}

// CREATE
  final public 
CLAUSE CreateClause() throws ParseException {Token t;
    List<PATTERN> patterns;
    t = jj_consume_token(CREATE);
    patterns = PatternList();
{if ("" != null) return astFactory.createClause( pos( t ), patterns );}
    throw new IllegalStateException ("Missing return statement in function");
}

// SET
  final public 
SET_CLAUSE SetClause() throws ParseException {Token t;
    SET_ITEM item;
    List<SET_ITEM> items = new ArrayList<>();
    t = jj_consume_token(SET);
    item = SetItem();
items.add( item );
    label_11:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 250:{
        break;
        }
      default:
        jj_la1[28] = jj_gen;
        break label_11;
      }
      jj_consume_token(250);
      item = SetItem();
items.add( item );
    }
{if ("" != null) return astFactory.setClause( pos( t ), items );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SET_ITEM SetItem() throws ParseException {EXPRESSION e;
    PROPERTY p;
    VARIABLE v;
    List<StringPos<POS>> labels;
    if (jj_2_8(2)) {
      p = PropertyExpression();
      jj_consume_token(EQ);
      e = Expression();
{if ("" != null) return astFactory.setProperty( p, e );}
    } else if (jj_2_9(2)) {
      v = Variable();
      jj_consume_token(EQ);
      e = Expression();
{if ("" != null) return astFactory.setVariable( v, e );}
    } else if (jj_2_10(2)) {
      v = Variable();
      jj_consume_token(251);
      e = Expression();
{if ("" != null) return astFactory.addAndSetVariable( v, e );}
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case AS:
      case ASC:
      case ASSERT:
      case ASSIGN:
      case AT:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASE:
      case CATALOG:
      case CHANGE:
      case COMMIT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DBMS:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESTROY:
      case DETACH:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DUMP:
      case EACH:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case EXTRACT:
      case FALSE:
      case FIELDTERMINATOR:
      case FILTER:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case HEADERS:
      case HOME:
      case IF:
      case IN:
      case INDEX:
      case INDEXES:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LIMITROWS:
      case LOAD:
      case LOOKUP:
      case MANAGEMENT:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NEW:
      case NODE:
      case NODES:
      case NONE:
      case NOT:
      case NOWAIT:
      case NULL:
      case OF:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTY:
      case RANGE:
      case READ:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REQUIRE:
      case REQUIRED:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDS:
      case SEEK:
      case SET:
      case SHORTEST_PATH:
      case SHOW:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TO:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRUE:
      case TYPE:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNWIND:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VERBOSE:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WRITE:
      case XOR:
      case YIELD:
      case IDENTIFIER:{
        v = Variable();
        labels = NodeLabels();
{if ("" != null) return astFactory.setLabels( v, labels );}
        break;
        }
      default:
        jj_la1[29] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new IllegalStateException ("Missing return statement in function");
}

// REMOVE
  final public 
CLAUSE RemoveClause() throws ParseException {Token t;
    REMOVE_ITEM item;
    List<REMOVE_ITEM> items = new ArrayList<>();
    t = jj_consume_token(REMOVE);
    item = RemoveItem();
items.add( item );
    label_12:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 250:{
        break;
        }
      default:
        jj_la1[30] = jj_gen;
        break label_12;
      }
      jj_consume_token(250);
      item = RemoveItem();
items.add( item );
    }
{if ("" != null) return astFactory.removeClause( pos( t ), items );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public REMOVE_ITEM RemoveItem() throws ParseException {EXPRESSION e;
    PROPERTY p;
    VARIABLE v;
    List<StringPos<POS>> labels;
    if (jj_2_11(2)) {
      p = PropertyExpression();
{if ("" != null) return astFactory.removeProperty( p );}
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case AS:
      case ASC:
      case ASSERT:
      case ASSIGN:
      case AT:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASE:
      case CATALOG:
      case CHANGE:
      case COMMIT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DBMS:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESTROY:
      case DETACH:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DUMP:
      case EACH:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case EXTRACT:
      case FALSE:
      case FIELDTERMINATOR:
      case FILTER:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case HEADERS:
      case HOME:
      case IF:
      case IN:
      case INDEX:
      case INDEXES:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LIMITROWS:
      case LOAD:
      case LOOKUP:
      case MANAGEMENT:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NEW:
      case NODE:
      case NODES:
      case NONE:
      case NOT:
      case NOWAIT:
      case NULL:
      case OF:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTY:
      case RANGE:
      case READ:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REQUIRE:
      case REQUIRED:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDS:
      case SEEK:
      case SET:
      case SHORTEST_PATH:
      case SHOW:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TO:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRUE:
      case TYPE:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNWIND:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VERBOSE:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WRITE:
      case XOR:
      case YIELD:
      case IDENTIFIER:{
        v = Variable();
        labels = NodeLabels();
{if ("" != null) return astFactory.removeLabels( v, labels );}
        break;
        }
      default:
        jj_la1[31] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new IllegalStateException ("Missing return statement in function");
}

// DELETE
  final public 
CLAUSE DeleteClause() throws ParseException {Token detachT = null;
    Token t;
    boolean detach = false;
    EXPRESSION e;
    List<EXPRESSION> list = new ArrayList<>();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DETACH:{
      detachT = jj_consume_token(DETACH);
detach = true;
      break;
      }
    default:
      jj_la1[32] = jj_gen;
      ;
    }
    t = jj_consume_token(DELETE);
    e = Expression();
list.add( e );
    label_13:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 250:{
        break;
        }
      default:
        jj_la1[33] = jj_gen;
        break label_13;
      }
      jj_consume_token(250);
      e = Expression();
list.add( e );
    }
{if ("" != null) return astFactory.deleteClause( pos( detachT != null ? detachT : t ), detach, list );}
    throw new IllegalStateException ("Missing return statement in function");
}

// MATCH
  final public 
CLAUSE MatchClause() throws ParseException {Token optionalT = null;
    Token t;
    Token whereToken = null;
    boolean optional = false;
    List<PATTERN> patterns;
    List<HINT> hints;
    WHERE where = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case OPTIONAL:{
      optionalT = jj_consume_token(OPTIONAL);
optional = true;
      break;
      }
    default:
      jj_la1[34] = jj_gen;
      ;
    }
    t = jj_consume_token(MATCH);
    patterns = PatternList();
    hints = Hints();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      where = WhereClause();
      break;
      }
    default:
      jj_la1[35] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.matchClause( pos( optionalT != null ? optionalT : t ), optional, patterns, pos( t.next ), hints, where );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<HINT> Hints() throws ParseException {Token t;
    boolean seek;
    VARIABLE v;
    Token labelOrRelType;
    List<VARIABLE> joinVariables;
    HINT hint;
    List<HINT> hints = null;
    label_14:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case USING:{
        break;
        }
      default:
        jj_la1[36] = jj_gen;
        break label_14;
      }
      t = jj_consume_token(USING);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case INDEX:{
        jj_consume_token(INDEX);
        hint = IndexHintBody(HintIndexType.ANY, pos( t ));
        break;
        }
      case BTREE:{
        jj_consume_token(BTREE);
        jj_consume_token(INDEX);
        hint = IndexHintBody(HintIndexType.BTREE, pos( t ));
        break;
        }
      case TEXT:{
        jj_consume_token(TEXT);
        jj_consume_token(INDEX);
        hint = IndexHintBody(HintIndexType.TEXT, pos( t ));
        break;
        }
      case JOIN:{
        jj_consume_token(JOIN);
        jj_consume_token(ON);
        joinVariables = VariableList1();
hint = astFactory.usingJoin( pos( t ), joinVariables );
        break;
        }
      case SCAN:{
        jj_consume_token(SCAN);
        v = Variable();
        labelOrRelType = LabelOrRelType();
hint = astFactory.usingScan( pos( t ), v, labelOrRelType.image );
        break;
        }
      default:
        jj_la1[37] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
if ( hints == null )
            {
                hints = new ArrayList<>();
            }
            hints.add( hint );
    }
{if ("" != null) return hints;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public HINT IndexHintBody(HintIndexType indexType, POS p) throws ParseException {boolean seek = false;
    VARIABLE v;
    Token labelOrRelType;
    List<String> propNames;
    if (jj_2_12(2)) {
      jj_consume_token(SEEK);
seek = true;
    } else {
      ;
    }
    v = Variable();
    labelOrRelType = LabelOrRelType();
    jj_consume_token(LPAREN);
    propNames = SymbolicNameList1();
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.usingIndexHint( p, v, labelOrRelType.image, propNames, seek, indexType);}
    throw new IllegalStateException ("Missing return statement in function");
}

// MERGE
  final public 
CLAUSE MergeClause() throws ParseException {Token t;
    Token onToken;
    PATTERN p;
    SET_CLAUSE c;
    ArrayList<SET_CLAUSE> clauses = new ArrayList<>();
    ArrayList<POS> positions = new ArrayList<>();
    ArrayList<ASTFactory.MergeActionType> actionTypes = new ArrayList<>();
    t = jj_consume_token(MERGE);
    p = Pattern();
    label_15:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ON:{
        break;
        }
      default:
        jj_la1[38] = jj_gen;
        break label_15;
      }
      onToken = jj_consume_token(ON);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MATCH:{
        jj_consume_token(MATCH);
        c = SetClause();
clauses.add( c ); actionTypes.add( ASTFactory.MergeActionType.OnMatch ); positions.add( pos( onToken ) );
        break;
        }
      case CREATE:{
        jj_consume_token(CREATE);
        c = SetClause();
clauses.add( c ); actionTypes.add( ASTFactory.MergeActionType.OnCreate ); positions.add( pos( onToken ) );
        break;
        }
      default:
        jj_la1[39] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return astFactory.mergeClause( pos( t ), p, clauses, actionTypes, positions );}
    throw new IllegalStateException ("Missing return statement in function");
}

// UNWIND
  final public 
CLAUSE UnwindClause() throws ParseException {Token t;
    EXPRESSION e;
    VARIABLE v;
    t = jj_consume_token(UNWIND);
    e = Expression();
    jj_consume_token(AS);
    v = Variable();
{if ("" != null) return astFactory.unwindClause( pos( t ), e, v );}
    throw new IllegalStateException ("Missing return statement in function");
}

// CALL
  final public 
CLAUSE CallClause() throws ParseException {Token t;
    Token procedureNamePosition;
    Token procedureResultPosition = null;
    List<String> namespace;
    String name;
    EXPRESSION e;
    List<EXPRESSION> arguments = null;
    boolean yieldAll = false;
    CALL_RESULT_ITEM x;
    List<CALL_RESULT_ITEM> items = null;
    WHERE where = null;
    t = jj_consume_token(CALL);
    namespace = Namespace();
procedureNamePosition = token;
    name = ProcedureName();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LPAREN:{
      jj_consume_token(LPAREN);
arguments = new ArrayList<>();
      if (jj_2_13(2)) {
        e = Expression();
arguments.add( e );
      } else {
        ;
      }
      label_16:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case 250:{
          break;
          }
        default:
          jj_la1[40] = jj_gen;
          break label_16;
        }
        jj_consume_token(250);
        e = Expression();
arguments.add( e );
      }
      jj_consume_token(RPAREN);
      break;
      }
    default:
      jj_la1[41] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case YIELD:{
      procedureResultPosition = jj_consume_token(YIELD);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case TIMES:{
        jj_consume_token(TIMES);
yieldAll = true;
        break;
        }
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case AS:
      case ASC:
      case ASSERT:
      case ASSIGN:
      case AT:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASE:
      case CATALOG:
      case CHANGE:
      case COMMIT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DBMS:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESTROY:
      case DETACH:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DUMP:
      case EACH:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case EXTRACT:
      case FALSE:
      case FIELDTERMINATOR:
      case FILTER:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case HEADERS:
      case HOME:
      case IF:
      case IN:
      case INDEX:
      case INDEXES:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LIMITROWS:
      case LOAD:
      case LOOKUP:
      case MANAGEMENT:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NEW:
      case NODE:
      case NODES:
      case NONE:
      case NOT:
      case NOWAIT:
      case NULL:
      case OF:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTY:
      case RANGE:
      case READ:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REQUIRE:
      case REQUIRED:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDS:
      case SEEK:
      case SET:
      case SHORTEST_PATH:
      case SHOW:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TO:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRUE:
      case TYPE:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNWIND:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VERBOSE:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WRITE:
      case XOR:
      case YIELD:
      case IDENTIFIER:{
items = new ArrayList<>();
        x = ProcedureResultItem();
items.add( x );
        label_17:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case 250:{
            break;
            }
          default:
            jj_la1[42] = jj_gen;
            break label_17;
          }
          jj_consume_token(250);
          x = ProcedureResultItem();
items.add( x );
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case WHERE:{
          where = WhereClause();
          break;
          }
        default:
          jj_la1[43] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[44] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[45] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.callClause( pos( t ),
                                     pos( t.next ),
                                     pos( procedureNamePosition.next ),
                                     pos( procedureResultPosition ),
                                     namespace,
                                     name,
                                     arguments,
                                     yieldAll,
                                     items,
                                     where );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String ProcedureName() throws ParseException {Token t;
    t = SymbolicNameString();
{if ("" != null) return t.image;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public CALL_RESULT_ITEM ProcedureResultItem() throws ParseException {Token t;
    VARIABLE v = null;
    t = SymbolicNameString();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case AS:{
      jj_consume_token(AS);
      v = Variable();
      break;
      }
    default:
      jj_la1[46] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.callResultItem( pos( t ), t.image,  v );}
    throw new IllegalStateException ("Missing return statement in function");
}

// LOAD CSV
  final public 
CLAUSE LoadCSVClause() throws ParseException {Token t;
    boolean headers = false;
    EXPRESSION source;
    VARIABLE v;
    Token sep = null;
    t = jj_consume_token(LOAD);
    jj_consume_token(CSV);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WITH:{
      jj_consume_token(WITH);
      jj_consume_token(HEADERS);
headers = true;
      break;
      }
    default:
      jj_la1[47] = jj_gen;
      ;
    }
    jj_consume_token(FROM);
    source = Expression();
    jj_consume_token(AS);
    v = Variable();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case FIELDTERMINATOR:{
      jj_consume_token(FIELDTERMINATOR);
      sep = StringToken();
      break;
      }
    default:
      jj_la1[48] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.loadCsvClause( pos( t ), headers, source, v, sep == null ? null : sep.image );}
    throw new IllegalStateException ("Missing return statement in function");
}

// FOREACH
  final public 
CLAUSE ForeachClause() throws ParseException {Token t;
    VARIABLE v;
    EXPRESSION list;
    CLAUSE c;
    List<CLAUSE> clauses = new ArrayList<>();
    t = jj_consume_token(FOREACH);
    jj_consume_token(LPAREN);
    v = Variable();
    jj_consume_token(IN);
    list = Expression();
    jj_consume_token(BAR);
    label_18:
    while (true) {
      c = Clause();
clauses.add( c );
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case CALL:
      case CREATE:
      case DELETE:
      case DETACH:
      case FOREACH:
      case LOAD:
      case MATCH:
      case MERGE:
      case OPTIONAL:
      case REMOVE:
      case RETURN:
      case SET:
      case UNWIND:
      case USE:
      case WITH:{
        break;
        }
      default:
        jj_la1[49] = jj_gen;
        break label_18;
      }
    }
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.foreachClause( pos( t ), v, list, clauses );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public CLAUSE SubqueryClause() throws ParseException {Token t;
    QUERY q;
    SUBQUERY_IN_TRANSACTIONS_PARAMETERS inTransactionsParams = null;
    t = jj_consume_token(CALL);
    jj_consume_token(LCURLY);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case USING:{
      q = PeriodicCommitQuery();
      break;
      }
    case CALL:
    case CREATE:
    case DELETE:
    case DETACH:
    case FOREACH:
    case LOAD:
    case MATCH:
    case MERGE:
    case OPTIONAL:
    case REMOVE:
    case RETURN:
    case SET:
    case UNWIND:
    case USE:
    case WITH:{
      q = RegularQuery();
      break;
      }
    default:
      jj_la1[50] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RCURLY);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IN:{
      inTransactionsParams = SubqueryInTransactionsParameters();
      break;
      }
    default:
      jj_la1[51] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.subqueryClause( pos( t ), q, inTransactionsParams );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SUBQUERY_IN_TRANSACTIONS_PARAMETERS SubqueryInTransactionsParameters() throws ParseException {Token t;
    EXPRESSION batchSize = null;
    t = jj_consume_token(IN);
    jj_consume_token(TRANSACTIONS);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case OF:{
      jj_consume_token(OF);
      batchSize = Expression();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ROW:{
        jj_consume_token(ROW);
        break;
        }
      case ROWS:{
        jj_consume_token(ROWS);
        break;
        }
      default:
        jj_la1[52] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[53] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.subqueryInTransactionsParams( pos( t ), batchSize );}
    throw new IllegalStateException ("Missing return statement in function");
}

// PATTERN
  final public 
List<PATTERN> PatternList() throws ParseException {PATTERN p;
    List<PATTERN> patterns = new ArrayList<>();
    p = Pattern();
patterns.add( p );
    label_19:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 250:{
        break;
        }
      default:
        jj_la1[54] = jj_gen;
        break label_19;
      }
      jj_consume_token(250);
      p = Pattern();
patterns.add( p );
    }
{if ("" != null) return patterns;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PATTERN Pattern() throws ParseException {VARIABLE v;
    PATTERN p;
    if (jj_2_14(2)) {
      v = Variable();
      jj_consume_token(EQ);
      p = AnonymousPattern();
{if ("" != null) return astFactory.namedPattern( v, p );}
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ALL_SHORTEST_PATH:
      case LPAREN:
      case SHORTEST_PATH:{
        p = AnonymousPattern();
{if ("" != null) return p;}
        break;
        }
      default:
        jj_la1[55] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PATTERN AnonymousPattern() throws ParseException {PATTERN p;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ALL_SHORTEST_PATH:
    case SHORTEST_PATH:{
      p = ShortestPathPattern();
      break;
      }
    default:
      jj_la1[56] = jj_gen;
      if (jj_2_15(3)) {
        p = EveryPathPattern();
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case LPAREN:{
          jj_consume_token(LPAREN);
          p = AnonymousPattern();
          jj_consume_token(RPAREN);
          break;
          }
        default:
          jj_la1[57] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
{if ("" != null) return p;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PATTERN ShortestPathPattern() throws ParseException {Token t;
    PATTERN p;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SHORTEST_PATH:{
      t = jj_consume_token(SHORTEST_PATH);
      jj_consume_token(LPAREN);
      p = EveryPathPattern();
      jj_consume_token(RPAREN);
{if ("" != null) return astFactory.shortestPathPattern( pos( t ), p );}
      break;
      }
    case ALL_SHORTEST_PATH:{
      t = jj_consume_token(ALL_SHORTEST_PATH);
      jj_consume_token(LPAREN);
      p = EveryPathPattern();
      jj_consume_token(RPAREN);
{if ("" != null) return astFactory.allShortestPathsPattern( pos( t ), p );}
      break;
      }
    default:
      jj_la1[58] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PATTERN EveryPathPattern() throws ParseException {NODE_PATTERN n;
    REL_PATTERN r;
    List<REL_PATTERN> relationships = new ArrayList<>();
    List<NODE_PATTERN> nodes = new ArrayList<>();
    n = NodePattern();
nodes.add( n );
    label_20:
    while (true) {
      if (jj_2_16(2)) {
      } else {
        break label_20;
      }
      r = RelationshipPattern();
relationships.add( r );
      n = NodePattern();
nodes.add( n );
    }
{if ("" != null) return astFactory.everyPathPattern( nodes, relationships );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PATTERN EveryPathPatternNonEmpty() throws ParseException {NODE_PATTERN n;
    REL_PATTERN r;
    List<REL_PATTERN> relationships = new ArrayList<>();
    List<NODE_PATTERN> nodes = new ArrayList<>();
    n = NodePattern();
nodes.add( n );
    label_21:
    while (true) {
      r = RelationshipPattern();
relationships.add( r );
      n = NodePattern();
nodes.add( n );
      if (jj_2_17(2)) {
      } else {
        break label_21;
      }
    }
{if ("" != null) return astFactory.everyPathPattern( nodes, relationships );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public NODE_PATTERN NodePattern() throws ParseException {Token t;
    VARIABLE v = null;
    List<StringPos<POS>> labels = new ArrayList<>();
    EXPRESSION properties = null;
    EXPRESSION predicate = null;
    t = jj_consume_token(LPAREN);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case AS:
    case ASC:
    case ASSERT:
    case ASSIGN:
    case AT:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASE:
    case CATALOG:
    case CHANGE:
    case COMMIT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DBMS:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESTROY:
    case DETACH:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DUMP:
    case EACH:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case EXTRACT:
    case FALSE:
    case FIELDTERMINATOR:
    case FILTER:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case HEADERS:
    case HOME:
    case IF:
    case IN:
    case INDEX:
    case INDEXES:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LIMITROWS:
    case LOAD:
    case LOOKUP:
    case MANAGEMENT:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NEW:
    case NODE:
    case NODES:
    case NONE:
    case NOT:
    case NOWAIT:
    case NULL:
    case OF:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTY:
    case RANGE:
    case READ:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REQUIRE:
    case REQUIRED:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDS:
    case SEEK:
    case SET:
    case SHORTEST_PATH:
    case SHOW:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TO:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRUE:
    case TYPE:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNWIND:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VERBOSE:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WRITE:
    case XOR:
    case YIELD:
    case IDENTIFIER:{
      v = Variable();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 252:{
        labels = NodeLabels();
        break;
        }
      default:
        jj_la1[59] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DOLLAR:
      case LCURLY:{
        properties = Properties();
        break;
        }
      default:
        jj_la1[60] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case WHERE:{
        jj_consume_token(WHERE);
        predicate = Expression();
        break;
        }
      default:
        jj_la1[61] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[64] = jj_gen;
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 252:{
        labels = NodeLabels();
        break;
        }
      default:
        jj_la1[62] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DOLLAR:
      case LCURLY:{
        properties = Properties();
        break;
        }
      default:
        jj_la1[63] = jj_gen;
        ;
      }
    }
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.nodePattern( pos( t ), v, labels, properties, predicate );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<StringPos<POS>> NodeLabels() throws ParseException {Token label;
    List<StringPos<POS>> labels = new ArrayList<>();
    label_22:
    while (true) {
      label = LabelOrRelType();
labels.add( new StringPos<>( label.image, pos( label ) ) );
      if (jj_2_18(2)) {
      } else {
        break label_22;
      }
    }
{if ("" != null) return labels;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION HasLabels(EXPRESSION subject) throws ParseException {List<StringPos<POS>> labels;
    labels = NodeLabels();
{if ("" != null) return astFactory.hasLabelsOrTypes( subject, labels );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Token LabelOrRelType() throws ParseException {Token t;
    jj_consume_token(252);
    t = SymbolicNameString();
{if ("" != null) return t;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<StringPos<POS>> LabelOrRelTypes() throws ParseException {List<StringPos<POS>> labels = new ArrayList<>();
    StringPos<POS> label;
    jj_consume_token(252);
    SymbolicNameString();
labels.add( new StringPos( token.image, pos(token) ) );
    label_23:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case BAR:{
        break;
        }
      default:
        jj_la1[65] = jj_gen;
        break label_23;
      }
      jj_consume_token(BAR);
      SymbolicNameString();
labels.add( new StringPos( token.image, pos(token) ) );
    }
{if ("" != null) return labels;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Properties() throws ParseException {EXPRESSION e;
    if (jj_2_19(3)) {
      e = MapLiteral();
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DOLLAR:{
        e = Parameter(ParameterType.ANY);
        break;
        }
      case LCURLY:{
        e = OldParameter();
        break;
        }
      default:
        jj_la1[66] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public REL_PATTERN RelationshipPattern() throws ParseException {Token firstToken = token.next;
    Token t;
    boolean left = false;
    boolean right = false;
    VARIABLE v = null;
    List<StringPos<POS>> relTypes = new ArrayList<>();
    boolean legacyTypeSeparator = false;
    PATH_LENGTH pathLength = null;
    EXPRESSION properties = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LT:
    case ARROW_LEFT_HEAD:{
      LeftArrow();
left = true;
      break;
      }
    default:
      jj_la1[67] = jj_gen;
      ;
    }
    ArrowLine();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LBRACKET:{
      jj_consume_token(LBRACKET);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case AS:
      case ASC:
      case ASSERT:
      case ASSIGN:
      case AT:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASE:
      case CATALOG:
      case CHANGE:
      case COMMIT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DBMS:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESTROY:
      case DETACH:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DUMP:
      case EACH:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case EXTRACT:
      case FALSE:
      case FIELDTERMINATOR:
      case FILTER:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case HEADERS:
      case HOME:
      case IF:
      case IN:
      case INDEX:
      case INDEXES:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LIMITROWS:
      case LOAD:
      case LOOKUP:
      case MANAGEMENT:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NEW:
      case NODE:
      case NODES:
      case NONE:
      case NOT:
      case NOWAIT:
      case NULL:
      case OF:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTY:
      case RANGE:
      case READ:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REQUIRE:
      case REQUIRED:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDS:
      case SEEK:
      case SET:
      case SHORTEST_PATH:
      case SHOW:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TO:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRUE:
      case TYPE:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNWIND:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VERBOSE:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WRITE:
      case XOR:
      case YIELD:
      case IDENTIFIER:{
        v = Variable();
        break;
        }
      default:
        jj_la1[68] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 252:{
        jj_consume_token(252);
        t = SymbolicNameString();
relTypes = new ArrayList<>();
                relTypes.add(new StringPos<>( t.image,  pos( t ) ) );
        label_24:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case BAR:{
            break;
            }
          default:
            jj_la1[69] = jj_gen;
            break label_24;
          }
          jj_consume_token(BAR);
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case 252:{
            jj_consume_token(252);
legacyTypeSeparator = true;
            break;
            }
          default:
            jj_la1[70] = jj_gen;
            ;
          }
          t = SymbolicNameString();
relTypes.add( new StringPos<>( t.image,  pos( t ) ) );
        }
        break;
        }
      default:
        jj_la1[71] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case TIMES:{
        pathLength = PathLength();
        break;
        }
      default:
        jj_la1[72] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DOLLAR:
      case LCURLY:{
        properties = Properties();
        break;
        }
      default:
        jj_la1[73] = jj_gen;
        ;
      }
      jj_consume_token(RBRACKET);
      break;
      }
    default:
      jj_la1[74] = jj_gen;
      ;
    }
    ArrowLine();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case GT:
    case ARROW_RIGHT_HEAD:{
      RightArrow();
right = true;
      break;
      }
    default:
      jj_la1[75] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.relationshipPattern( pos( firstToken ), left, right, v, relTypes, pathLength, properties, legacyTypeSeparator );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public void LeftArrow() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LT:{
      jj_consume_token(LT);
      break;
      }
    case ARROW_LEFT_HEAD:{
      jj_consume_token(ARROW_LEFT_HEAD);
      break;
      }
    default:
      jj_la1[76] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void ArrowLine() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ARROW_LINE:{
      jj_consume_token(ARROW_LINE);
      break;
      }
    case MINUS:{
      jj_consume_token(MINUS);
      break;
      }
    default:
      jj_la1[77] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void RightArrow() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case GT:{
      jj_consume_token(GT);
      break;
      }
    case ARROW_RIGHT_HEAD:{
      jj_consume_token(ARROW_RIGHT_HEAD);
      break;
      }
    default:
      jj_la1[78] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public PATH_LENGTH PathLength() throws ParseException {Token t;
    PATH_LENGTH p = null;
    t = jj_consume_token(TIMES);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case UNSIGNED_DECIMAL_INTEGER:
    case DOTDOT:{
      p = PathLengthLiteral(t);
      break;
      }
    default:
      jj_la1[79] = jj_gen;
      ;
    }
{if ("" != null) return p == null ? astFactory.pathLength( pos( t ), null, null, null, null ) : p;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PATH_LENGTH PathLengthLiteral(Token t) throws ParseException {Token v1 = null;
    Token v2 = null;
    if (jj_2_20(2)) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case UNSIGNED_DECIMAL_INTEGER:{
        v1 = jj_consume_token(UNSIGNED_DECIMAL_INTEGER);
        break;
        }
      default:
        jj_la1[80] = jj_gen;
        ;
      }
      t = jj_consume_token(DOTDOT);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case UNSIGNED_DECIMAL_INTEGER:{
        v2 = jj_consume_token(UNSIGNED_DECIMAL_INTEGER);
        break;
        }
      default:
        jj_la1[81] = jj_gen;
        ;
      }
{if ("" != null) return astFactory.pathLength( pos( t ), v1 == null ? null : pos ( v1 ), v2 == null ? null : pos ( v2 ),  v1 == null ? "" : v1.image, v2 == null ? "" : v2.image );}
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case UNSIGNED_DECIMAL_INTEGER:{
        v1 = jj_consume_token(UNSIGNED_DECIMAL_INTEGER);
String v = v1 == null ? "" : v1.image;
            {if ("" != null) return astFactory.pathLength( pos( t ), v1 == null ? null : pos ( v1 ), v1 == null ? null : pos ( v1 ), v, v);}
        break;
        }
      default:
        jj_la1[82] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new IllegalStateException ("Missing return statement in function");
}

// EXPRESSIONS
  final public 
EXPRESSION Expression() throws ParseException {EXPRESSION e;
    e = Expression12();
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Expression12() throws ParseException {Token t;
    EXPRESSION e;
    EXPRESSION temp;
    e = Expression11();
    label_25:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case OR:{
        break;
        }
      default:
        jj_la1[83] = jj_gen;
        break label_25;
      }
      t = jj_consume_token(OR);
      temp = Expression11();
e = astFactory.or( pos( t ), e, temp );
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Expression11() throws ParseException {Token t;
    EXPRESSION e;
    EXPRESSION temp;
    e = Expression10();
    label_26:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case XOR:{
        break;
        }
      default:
        jj_la1[84] = jj_gen;
        break label_26;
      }
      t = jj_consume_token(XOR);
      temp = Expression10();
e = astFactory.xor( pos( t ), e, temp );
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Expression10() throws ParseException {Token t;
    EXPRESSION e;
    EXPRESSION temp;
    e = Expression9();
    label_27:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case AND:{
        break;
        }
      default:
        jj_la1[85] = jj_gen;
        break label_27;
      }
      t = jj_consume_token(AND);
      temp = Expression9();
e = astFactory.and( pos( t ), e, temp );
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Expression9() throws ParseException {Token t;
    EXPRESSION e;
    if (jj_2_21(3)) {
      t = jj_consume_token(NOT);
      e = Expression9();
e = astFactory.not( pos( t ), e );
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DECIMAL_DOUBLE:
      case UNSIGNED_DECIMAL_INTEGER:
      case UNSIGNED_HEX_INTEGER:
      case UNSIGNED_OCTAL_INTEGER:
      case STRING_LITERAL1:
      case STRING_LITERAL2:
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case AS:
      case ASC:
      case ASSERT:
      case ASSIGN:
      case AT:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASE:
      case CATALOG:
      case CHANGE:
      case COMMIT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DBMS:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESTROY:
      case DETACH:
      case DOLLAR:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DUMP:
      case EACH:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case EXTRACT:
      case FALSE:
      case FIELDTERMINATOR:
      case FILTER:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case HEADERS:
      case HOME:
      case IF:
      case IN:
      case INDEX:
      case INDEXES:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LBRACKET:
      case LCURLY:
      case LIMITROWS:
      case LOAD:
      case LOOKUP:
      case LPAREN:
      case MANAGEMENT:
      case MATCH:
      case MERGE:
      case MINUS:
      case NAME:
      case NAMES:
      case NEW:
      case NODE:
      case NODES:
      case NONE:
      case NOT:
      case NOWAIT:
      case NULL:
      case OF:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PERIODIC:
      case PLAINTEXT:
      case PLUS:
      case POINT:
      case POPULATED:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTY:
      case RANGE:
      case READ:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REQUIRE:
      case REQUIRED:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDS:
      case SEEK:
      case SET:
      case SHORTEST_PATH:
      case SHOW:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TO:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRUE:
      case TYPE:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNWIND:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VERBOSE:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WRITE:
      case XOR:
      case YIELD:
      case IDENTIFIER:{
        e = Expression8();
        break;
        }
      default:
        jj_la1[86] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Expression8() throws ParseException {Token t;
    EXPRESSION e;
    EXPRESSION lhs;
    EXPRESSION rhs;
    List<EXPRESSION> expressions = new ArrayList();
    e = Expression7();
lhs = e;
    label_28:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case EQ:
      case GE:
      case GT:
      case LE:
      case LT:
      case NEQ:
      case NEQ2:{
        break;
        }
      default:
        jj_la1[87] = jj_gen;
        break label_28;
      }
      if (jj_2_22(2)) {
        t = jj_consume_token(EQ);
        rhs = Expression7();
expressions.add( astFactory.eq( pos( t ), lhs, rhs)); lhs = rhs;
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NEQ:{
          t = jj_consume_token(NEQ);
          rhs = Expression7();
expressions.add( astFactory.neq( pos( t ), lhs, rhs ) ); lhs = rhs;
          break;
          }
        case NEQ2:{
          t = jj_consume_token(NEQ2);
          rhs = Expression7();
expressions.add( astFactory.neq2( pos( t ), lhs, rhs ) ); lhs = rhs;
          break;
          }
        case LE:{
          t = jj_consume_token(LE);
          rhs = Expression7();
expressions.add( astFactory.lte( pos( t ), lhs, rhs ) ); lhs = rhs;
          break;
          }
        case GE:{
          t = jj_consume_token(GE);
          rhs = Expression7();
expressions.add( astFactory.gte( pos( t ), lhs, rhs ) ); lhs = rhs;
          break;
          }
        case LT:{
          t = jj_consume_token(LT);
          rhs = Expression7();
expressions.add( astFactory.lt( pos( t ), lhs, rhs ) ); lhs = rhs;
          break;
          }
        case GT:{
          t = jj_consume_token(GT);
          rhs = Expression7();
expressions.add( astFactory.gt( pos( t ), lhs, rhs ) ); lhs = rhs;
          break;
          }
        default:
          jj_la1[88] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
if ( expressions.isEmpty() )
        {
            {if ("" != null) return e;}
        }
        else if ( expressions.size() == 1 )
        {
            {if ("" != null) return expressions.get( 0 );}
        }
        else
        {
            {if ("" != null) return astFactory.ands( expressions );}
        }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Expression7() throws ParseException {EXPRESSION e;
    e = Expression6();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case CONTAINS:
    case ENDS:
    case IN:
    case IS:
    case REGEQ:
    case STARTS:{
      e = ComparisonExpression6(e);
      break;
      }
    default:
      jj_la1[89] = jj_gen;
      ;
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION ComparisonExpression6(EXPRESSION lhs) throws ParseException {Token t;
    EXPRESSION rhs;
    if (jj_2_23(2)) {
      t = jj_consume_token(REGEQ);
      rhs = Expression6();
{if ("" != null) return astFactory.regeq( pos( t ), lhs, rhs );}
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case STARTS:{
        t = jj_consume_token(STARTS);
        jj_consume_token(WITH);
        rhs = Expression6();
{if ("" != null) return astFactory.startsWith( pos( t ), lhs, rhs );}
        break;
        }
      case ENDS:{
        t = jj_consume_token(ENDS);
        jj_consume_token(WITH);
        rhs = Expression6();
{if ("" != null) return astFactory.endsWith( pos( t ), lhs, rhs );}
        break;
        }
      case CONTAINS:{
        t = jj_consume_token(CONTAINS);
        rhs = Expression6();
{if ("" != null) return astFactory.contains( pos( t ), lhs, rhs );}
        break;
        }
      case IN:{
        t = jj_consume_token(IN);
        rhs = Expression6();
{if ("" != null) return astFactory.in( pos( t ), lhs, rhs );}
        break;
        }
      case IS:{
        t = jj_consume_token(IS);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NULL:{
          jj_consume_token(NULL);
{if ("" != null) return astFactory.isNull( pos( t ), lhs );}
          break;
          }
        case NOT:{
          jj_consume_token(NOT);
          jj_consume_token(NULL);
{if ("" != null) return astFactory.isNotNull( pos( t ), lhs );}
          break;
          }
        default:
          jj_la1[90] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[91] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Expression6() throws ParseException {Token t;
    EXPRESSION lhs;
    EXPRESSION rhs;
    lhs = Expression5();
    label_29:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MINUS:
      case PLUS:{
        break;
        }
      default:
        jj_la1[92] = jj_gen;
        break label_29;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PLUS:{
        t = jj_consume_token(PLUS);
        rhs = Expression5();
lhs = astFactory.plus( pos( t ), lhs, rhs);
        break;
        }
      case MINUS:{
        t = jj_consume_token(MINUS);
        rhs = Expression5();
lhs = astFactory.minus( pos( t ), lhs, rhs);
        break;
        }
      default:
        jj_la1[93] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return lhs;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Expression5() throws ParseException {Token t;
    EXPRESSION lhs;
    EXPRESSION rhs;
    lhs = Expression4();
    label_30:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DIVIDE:
      case MODULO:
      case TIMES:{
        break;
        }
      default:
        jj_la1[94] = jj_gen;
        break label_30;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case TIMES:{
        t = jj_consume_token(TIMES);
        rhs = Expression4();
lhs = astFactory.multiply( pos( t ), lhs, rhs );
        break;
        }
      case DIVIDE:{
        t = jj_consume_token(DIVIDE);
        rhs = Expression4();
lhs = astFactory.divide( pos( t ), lhs, rhs );
        break;
        }
      case MODULO:{
        t = jj_consume_token(MODULO);
        rhs = Expression4();
lhs = astFactory.modulo( pos( t ), lhs, rhs );
        break;
        }
      default:
        jj_la1[95] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return lhs;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Expression4() throws ParseException {Token t;
    EXPRESSION lhs;
    EXPRESSION rhs;
    lhs = Expression3();
    label_31:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case POW:{
        break;
        }
      default:
        jj_la1[96] = jj_gen;
        break label_31;
      }
      t = jj_consume_token(POW);
      rhs = Expression3();
lhs = astFactory.pow( pos( t ), lhs, rhs );
    }
{if ("" != null) return lhs;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Expression3() throws ParseException {Token t;
    EXPRESSION e;
    if (jj_2_24(3)) {
      e = Expression2();
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PLUS:{
        t = jj_consume_token(PLUS);
        e = Expression2();
e = astFactory.unaryPlus( pos( t ), e );
        break;
        }
      case MINUS:{
        t = jj_consume_token(MINUS);
        e = Expression2();
e = astFactory.unaryMinus( pos( t ), e );
        break;
        }
      default:
        jj_la1[97] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Expression2() throws ParseException {EXPRESSION e;
    e = Expression1();
    label_32:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DOT:
      case LBRACKET:
      case 252:{
        break;
        }
      default:
        jj_la1[98] = jj_gen;
        break label_32;
      }
      e = PostFix1(e);
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION PostFix1(EXPRESSION subject) throws ParseException {Token t;
    EXPRESSION e1 = null;
    EXPRESSION e2 = null;
    EXPRESSION ret;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DOT:{
      ret = Property(subject);
      break;
      }
    case 252:{
      ret = HasLabels(subject);
      break;
      }
    default:
      jj_la1[101] = jj_gen;
      if (jj_2_25(2147483647)) {
        jj_consume_token(LBRACKET);
        e1 = Expression();
        jj_consume_token(RBRACKET);
ret=astFactory.listLookup( subject, e1 );
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case LBRACKET:{
          t = jj_consume_token(LBRACKET);
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case DECIMAL_DOUBLE:
          case UNSIGNED_DECIMAL_INTEGER:
          case UNSIGNED_HEX_INTEGER:
          case UNSIGNED_OCTAL_INTEGER:
          case STRING_LITERAL1:
          case STRING_LITERAL2:
          case ESCAPED_SYMBOLIC_NAME:
          case ACCESS:
          case ACTIVE:
          case ALIAS:
          case ALIASES:
          case ALL_SHORTEST_PATH:
          case ALL:
          case ALTER:
          case AND:
          case ANY:
          case AS:
          case ASC:
          case ASSERT:
          case ASSIGN:
          case AT:
          case BRIEF:
          case BTREE:
          case BUILT:
          case BY:
          case CALL:
          case CASE:
          case CATALOG:
          case CHANGE:
          case COMMIT:
          case CONSTRAINT:
          case CONSTRAINTS:
          case CONTAINS:
          case COPY:
          case COUNT:
          case CREATE:
          case CSV:
          case CURRENT:
          case DATA:
          case DATABASE:
          case DATABASES:
          case DBMS:
          case DEFAULT_TOKEN:
          case DEFINED:
          case DELETE:
          case DENY:
          case DESC:
          case DESTROY:
          case DETACH:
          case DOLLAR:
          case DISTINCT:
          case DRIVER:
          case DROP:
          case DUMP:
          case EACH:
          case ELEMENT:
          case ELEMENTS:
          case ELSE:
          case ENCRYPTED:
          case END:
          case ENDS:
          case EXECUTABLE:
          case EXIST:
          case EXISTENCE:
          case EXISTS:
          case EXTRACT:
          case FALSE:
          case FIELDTERMINATOR:
          case FILTER:
          case FOR:
          case FOREACH:
          case FROM:
          case FULLTEXT:
          case FUNCTION:
          case FUNCTIONS:
          case GRANT:
          case GRAPH:
          case GRAPHS:
          case HEADERS:
          case HOME:
          case IF:
          case IN:
          case INDEX:
          case INDEXES:
          case IS:
          case JOIN:
          case KEY:
          case LABEL:
          case LABELS:
          case LBRACKET:
          case LCURLY:
          case LIMITROWS:
          case LOAD:
          case LOOKUP:
          case LPAREN:
          case MANAGEMENT:
          case MATCH:
          case MERGE:
          case MINUS:
          case NAME:
          case NAMES:
          case NEW:
          case NODE:
          case NODES:
          case NONE:
          case NOT:
          case NOWAIT:
          case NULL:
          case OF:
          case ON:
          case ONLY:
          case OPTIONAL:
          case OPTIONS:
          case OR:
          case ORDER:
          case OUTPUT:
          case PASSWORD:
          case PASSWORDS:
          case PERIODIC:
          case PLAINTEXT:
          case PLUS:
          case POINT:
          case POPULATED:
          case PRIVILEGE:
          case PRIVILEGES:
          case PROCEDURE:
          case PROCEDURES:
          case PROPERTY:
          case RANGE:
          case READ:
          case REDUCE:
          case RENAME:
          case REL:
          case RELATIONSHIP:
          case RELATIONSHIPS:
          case REMOVE:
          case REPLACE:
          case REQUIRE:
          case REQUIRED:
          case RETURN:
          case REVOKE:
          case ROLE:
          case ROLES:
          case ROW:
          case ROWS:
          case SCAN:
          case SEC:
          case SECOND:
          case SECONDS:
          case SEEK:
          case SET:
          case SHORTEST_PATH:
          case SHOW:
          case SINGLE:
          case SKIPROWS:
          case START:
          case STARTS:
          case STATUS:
          case STOP:
          case SUSPENDED:
          case TARGET:
          case TERMINATE:
          case TEXT:
          case THEN:
          case TO:
          case TRANSACTION:
          case TRANSACTIONS:
          case TRAVERSE:
          case TRUE:
          case TYPE:
          case TYPES:
          case UNION:
          case UNIQUE:
          case UNWIND:
          case USE:
          case USER:
          case USERS:
          case USING:
          case VERBOSE:
          case WAIT:
          case WHEN:
          case WHERE:
          case WITH:
          case WRITE:
          case XOR:
          case YIELD:
          case IDENTIFIER:{
            e1 = Expression();
            break;
            }
          default:
            jj_la1[99] = jj_gen;
            ;
          }
          jj_consume_token(DOTDOT);
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case DECIMAL_DOUBLE:
          case UNSIGNED_DECIMAL_INTEGER:
          case UNSIGNED_HEX_INTEGER:
          case UNSIGNED_OCTAL_INTEGER:
          case STRING_LITERAL1:
          case STRING_LITERAL2:
          case ESCAPED_SYMBOLIC_NAME:
          case ACCESS:
          case ACTIVE:
          case ALIAS:
          case ALIASES:
          case ALL_SHORTEST_PATH:
          case ALL:
          case ALTER:
          case AND:
          case ANY:
          case AS:
          case ASC:
          case ASSERT:
          case ASSIGN:
          case AT:
          case BRIEF:
          case BTREE:
          case BUILT:
          case BY:
          case CALL:
          case CASE:
          case CATALOG:
          case CHANGE:
          case COMMIT:
          case CONSTRAINT:
          case CONSTRAINTS:
          case CONTAINS:
          case COPY:
          case COUNT:
          case CREATE:
          case CSV:
          case CURRENT:
          case DATA:
          case DATABASE:
          case DATABASES:
          case DBMS:
          case DEFAULT_TOKEN:
          case DEFINED:
          case DELETE:
          case DENY:
          case DESC:
          case DESTROY:
          case DETACH:
          case DOLLAR:
          case DISTINCT:
          case DRIVER:
          case DROP:
          case DUMP:
          case EACH:
          case ELEMENT:
          case ELEMENTS:
          case ELSE:
          case ENCRYPTED:
          case END:
          case ENDS:
          case EXECUTABLE:
          case EXIST:
          case EXISTENCE:
          case EXISTS:
          case EXTRACT:
          case FALSE:
          case FIELDTERMINATOR:
          case FILTER:
          case FOR:
          case FOREACH:
          case FROM:
          case FULLTEXT:
          case FUNCTION:
          case FUNCTIONS:
          case GRANT:
          case GRAPH:
          case GRAPHS:
          case HEADERS:
          case HOME:
          case IF:
          case IN:
          case INDEX:
          case INDEXES:
          case IS:
          case JOIN:
          case KEY:
          case LABEL:
          case LABELS:
          case LBRACKET:
          case LCURLY:
          case LIMITROWS:
          case LOAD:
          case LOOKUP:
          case LPAREN:
          case MANAGEMENT:
          case MATCH:
          case MERGE:
          case MINUS:
          case NAME:
          case NAMES:
          case NEW:
          case NODE:
          case NODES:
          case NONE:
          case NOT:
          case NOWAIT:
          case NULL:
          case OF:
          case ON:
          case ONLY:
          case OPTIONAL:
          case OPTIONS:
          case OR:
          case ORDER:
          case OUTPUT:
          case PASSWORD:
          case PASSWORDS:
          case PERIODIC:
          case PLAINTEXT:
          case PLUS:
          case POINT:
          case POPULATED:
          case PRIVILEGE:
          case PRIVILEGES:
          case PROCEDURE:
          case PROCEDURES:
          case PROPERTY:
          case RANGE:
          case READ:
          case REDUCE:
          case RENAME:
          case REL:
          case RELATIONSHIP:
          case RELATIONSHIPS:
          case REMOVE:
          case REPLACE:
          case REQUIRE:
          case REQUIRED:
          case RETURN:
          case REVOKE:
          case ROLE:
          case ROLES:
          case ROW:
          case ROWS:
          case SCAN:
          case SEC:
          case SECOND:
          case SECONDS:
          case SEEK:
          case SET:
          case SHORTEST_PATH:
          case SHOW:
          case SINGLE:
          case SKIPROWS:
          case START:
          case STARTS:
          case STATUS:
          case STOP:
          case SUSPENDED:
          case TARGET:
          case TERMINATE:
          case TEXT:
          case THEN:
          case TO:
          case TRANSACTION:
          case TRANSACTIONS:
          case TRAVERSE:
          case TRUE:
          case TYPE:
          case TYPES:
          case UNION:
          case UNIQUE:
          case UNWIND:
          case USE:
          case USER:
          case USERS:
          case USING:
          case VERBOSE:
          case WAIT:
          case WHEN:
          case WHERE:
          case WITH:
          case WRITE:
          case XOR:
          case YIELD:
          case IDENTIFIER:{
            e2 = Expression();
            break;
            }
          default:
            jj_la1[100] = jj_gen;
            ;
          }
          jj_consume_token(RBRACKET);
ret=astFactory.listSlice( pos( t ), subject, e1, e2 );
          break;
          }
        default:
          jj_la1[102] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PROPERTY Property(EXPRESSION subject) throws ParseException {EXPRESSION e;
    StringPos<POS> propKeyName;
    jj_consume_token(DOT);
    propKeyName = PropertyKeyName();
{if ("" != null) return astFactory.property( subject, propKeyName );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PROPERTY PropertyExpression() throws ParseException {EXPRESSION subject;
    PROPERTY p;
    subject = Expression1();
    label_33:
    while (true) {
      p = Property(subject);
subject = p;
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DOT:{
        break;
        }
      default:
        jj_la1[103] = jj_gen;
        break label_33;
      }
    }
{if ("" != null) return p;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Expression1() throws ParseException {EXPRESSION e = null;
    Token t;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DECIMAL_DOUBLE:
    case UNSIGNED_DECIMAL_INTEGER:
    case UNSIGNED_HEX_INTEGER:
    case UNSIGNED_OCTAL_INTEGER:
    case MINUS:{
      e = NumberLiteral();
      break;
      }
    case STRING_LITERAL1:
    case STRING_LITERAL2:{
      e = StringLiteral();
      break;
      }
    case DOLLAR:{
      e = Parameter(ParameterType.ANY);
      break;
      }
    case TRUE:{
      t = jj_consume_token(TRUE);
e = astFactory.newTrueLiteral( pos( t ) );
      break;
      }
    case FALSE:{
      t = jj_consume_token(FALSE);
e = astFactory.newFalseLiteral( pos( t ) );
      break;
      }
    default:
      jj_la1[104] = jj_gen;
      if (jj_2_26(2)) {
        t = jj_consume_token(NULL);
e = astFactory.newNullLiteral( pos( t ) );
      } else if (jj_2_27(3)) {
        e = CaseExpression();
      } else if (jj_2_28(3)) {
        t = jj_consume_token(COUNT);
        jj_consume_token(LPAREN);
        jj_consume_token(TIMES);
        jj_consume_token(RPAREN);
e = astFactory.newCountStar( pos( t ) );
      } else if (jj_2_29(3)) {
        e = MapLiteral();
      } else if (jj_2_30(3)) {
        e = ExistsSubQuery();
      } else if (jj_2_31(2)) {
        e = MapProjection();
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case LCURLY:{
          e = OldParameter();
          break;
          }
        default:
          jj_la1[105] = jj_gen;
          if (jj_2_32(3)) {
            e = ListComprehension();
          } else if (jj_2_33(2147483647)) {
            e = PatternComprehension();
          } else if (jj_2_34(3)) {
            e = ListLiteral();
          } else if (jj_2_35(3)) {
            e = FilterExpression();
          } else if (jj_2_36(3)) {
            e = ExtractExpression();
          } else if (jj_2_37(3)) {
            e = ReduceExpression();
          } else if (jj_2_38(3)) {
            e = AllExpression();
          } else if (jj_2_39(3)) {
            e = AnyExpression();
          } else if (jj_2_40(3)) {
            e = NoneExpression();
          } else if (jj_2_41(3)) {
            e = SingleExpression();
          } else if (jj_2_42(2147483647)) {
            e = PatternExpression();
          } else if (jj_2_43(2)) {
            e = ShortestPathExpression();
          } else {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case LPAREN:{
              jj_consume_token(LPAREN);
              e = Expression();
              jj_consume_token(RPAREN);
              break;
              }
            default:
              jj_la1[106] = jj_gen;
              if (jj_2_44(2147483647)) {
                e = FunctionInvocation();
              } else {
                switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
                case ESCAPED_SYMBOLIC_NAME:
                case ACCESS:
                case ACTIVE:
                case ALIAS:
                case ALIASES:
                case ALL_SHORTEST_PATH:
                case ALL:
                case ALTER:
                case AND:
                case ANY:
                case AS:
                case ASC:
                case ASSERT:
                case ASSIGN:
                case AT:
                case BRIEF:
                case BTREE:
                case BUILT:
                case BY:
                case CALL:
                case CASE:
                case CATALOG:
                case CHANGE:
                case COMMIT:
                case CONSTRAINT:
                case CONSTRAINTS:
                case CONTAINS:
                case COPY:
                case COUNT:
                case CREATE:
                case CSV:
                case CURRENT:
                case DATA:
                case DATABASE:
                case DATABASES:
                case DBMS:
                case DEFAULT_TOKEN:
                case DEFINED:
                case DELETE:
                case DENY:
                case DESC:
                case DESTROY:
                case DETACH:
                case DISTINCT:
                case DRIVER:
                case DROP:
                case DUMP:
                case EACH:
                case ELEMENT:
                case ELEMENTS:
                case ELSE:
                case ENCRYPTED:
                case END:
                case ENDS:
                case EXECUTABLE:
                case EXIST:
                case EXISTENCE:
                case EXISTS:
                case EXTRACT:
                case FALSE:
                case FIELDTERMINATOR:
                case FILTER:
                case FOR:
                case FOREACH:
                case FROM:
                case FULLTEXT:
                case FUNCTION:
                case FUNCTIONS:
                case GRANT:
                case GRAPH:
                case GRAPHS:
                case HEADERS:
                case HOME:
                case IF:
                case IN:
                case INDEX:
                case INDEXES:
                case IS:
                case JOIN:
                case KEY:
                case LABEL:
                case LABELS:
                case LIMITROWS:
                case LOAD:
                case LOOKUP:
                case MANAGEMENT:
                case MATCH:
                case MERGE:
                case NAME:
                case NAMES:
                case NEW:
                case NODE:
                case NODES:
                case NONE:
                case NOT:
                case NOWAIT:
                case NULL:
                case OF:
                case ON:
                case ONLY:
                case OPTIONAL:
                case OPTIONS:
                case OR:
                case ORDER:
                case OUTPUT:
                case PASSWORD:
                case PASSWORDS:
                case PERIODIC:
                case PLAINTEXT:
                case POINT:
                case POPULATED:
                case PRIVILEGE:
                case PRIVILEGES:
                case PROCEDURE:
                case PROCEDURES:
                case PROPERTY:
                case RANGE:
                case READ:
                case REDUCE:
                case RENAME:
                case REL:
                case RELATIONSHIP:
                case RELATIONSHIPS:
                case REMOVE:
                case REPLACE:
                case REQUIRE:
                case REQUIRED:
                case RETURN:
                case REVOKE:
                case ROLE:
                case ROLES:
                case ROW:
                case ROWS:
                case SCAN:
                case SEC:
                case SECOND:
                case SECONDS:
                case SEEK:
                case SET:
                case SHORTEST_PATH:
                case SHOW:
                case SINGLE:
                case SKIPROWS:
                case START:
                case STARTS:
                case STATUS:
                case STOP:
                case SUSPENDED:
                case TARGET:
                case TERMINATE:
                case TEXT:
                case THEN:
                case TO:
                case TRANSACTION:
                case TRANSACTIONS:
                case TRAVERSE:
                case TRUE:
                case TYPE:
                case TYPES:
                case UNION:
                case UNIQUE:
                case UNWIND:
                case USE:
                case USER:
                case USERS:
                case USING:
                case VERBOSE:
                case WAIT:
                case WHEN:
                case WHERE:
                case WITH:
                case WRITE:
                case XOR:
                case YIELD:
                case IDENTIFIER:{
                  e = Variable();
                  break;
                  }
                default:
                  jj_la1[107] = jj_gen;
                  jj_consume_token(-1);
                  throw new ParseException();
                }
              }
            }
          }
        }
      }
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION CaseExpression() throws ParseException {Token t;
    EXPRESSION caseExpr = null;
    EXPRESSION e;
    List<EXPRESSION> when = new ArrayList<>();
    List<EXPRESSION> then = new ArrayList<>();
    EXPRESSION elseCase = null;
    t = jj_consume_token(CASE);
    if (jj_2_45(2147483647)) {
      caseExpr = Expression();
      jj_consume_token(WHEN);
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case WHEN:{
        jj_consume_token(WHEN);
        break;
        }
      default:
        jj_la1[108] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    e = Expression();
when.add( e );
    jj_consume_token(THEN);
    e = Expression();
then.add( e );
    label_34:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case WHEN:{
        break;
        }
      default:
        jj_la1[109] = jj_gen;
        break label_34;
      }
      jj_consume_token(WHEN);
      e = Expression();
when.add( e );
      jj_consume_token(THEN);
      e = Expression();
then.add( e );
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ELSE:{
      jj_consume_token(ELSE);
      elseCase = Expression();
      break;
      }
    default:
      jj_la1[110] = jj_gen;
      ;
    }
    jj_consume_token(END);
{if ("" != null) return astFactory.caseExpression( pos( t ), caseExpr, when, then, elseCase);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION ListComprehension() throws ParseException {Token t;
    VARIABLE v;
    EXPRESSION e;
    EXPRESSION where = null;
    EXPRESSION projection = null;
    t = jj_consume_token(LBRACKET);
    v = Variable();
    jj_consume_token(IN);
    e = Expression();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      jj_consume_token(WHERE);
      where = Expression();
      break;
      }
    default:
      jj_la1[111] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case BAR:{
      jj_consume_token(BAR);
      projection = Expression();
      break;
      }
    default:
      jj_la1[112] = jj_gen;
      ;
    }
    jj_consume_token(RBRACKET);
{if ("" != null) return astFactory.listComprehension( pos( t ), v, e, where, projection );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION PatternComprehension() throws ParseException {Token t;
    Token relationshipPatternPosition;
    VARIABLE v = null;
    PATTERN p;
    EXPRESSION where = null;
    EXPRESSION projection = null;
    t = jj_consume_token(LBRACKET);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case AS:
    case ASC:
    case ASSERT:
    case ASSIGN:
    case AT:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASE:
    case CATALOG:
    case CHANGE:
    case COMMIT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DBMS:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESTROY:
    case DETACH:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DUMP:
    case EACH:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case EXTRACT:
    case FALSE:
    case FIELDTERMINATOR:
    case FILTER:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case HEADERS:
    case HOME:
    case IF:
    case IN:
    case INDEX:
    case INDEXES:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LIMITROWS:
    case LOAD:
    case LOOKUP:
    case MANAGEMENT:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NEW:
    case NODE:
    case NODES:
    case NONE:
    case NOT:
    case NOWAIT:
    case NULL:
    case OF:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTY:
    case RANGE:
    case READ:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REQUIRE:
    case REQUIRED:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDS:
    case SEEK:
    case SET:
    case SHORTEST_PATH:
    case SHOW:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TO:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRUE:
    case TYPE:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNWIND:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VERBOSE:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WRITE:
    case XOR:
    case YIELD:
    case IDENTIFIER:{
      v = Variable();
      jj_consume_token(EQ);
      break;
      }
    default:
      jj_la1[113] = jj_gen;
      ;
    }
relationshipPatternPosition = token;
    p = EveryPathPatternNonEmpty();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      jj_consume_token(WHERE);
      where = Expression();
      break;
      }
    default:
      jj_la1[114] = jj_gen;
      ;
    }
    jj_consume_token(BAR);
    projection = Expression();
    jj_consume_token(RBRACKET);
{if ("" != null) return astFactory.patternComprehension( pos( t ), pos( relationshipPatternPosition.next ), v, p, where, projection );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public void PatternComprehensionPrefix() throws ParseException {
    jj_consume_token(LBRACKET);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case AS:
    case ASC:
    case ASSERT:
    case ASSIGN:
    case AT:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASE:
    case CATALOG:
    case CHANGE:
    case COMMIT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DBMS:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESTROY:
    case DETACH:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DUMP:
    case EACH:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case EXTRACT:
    case FALSE:
    case FIELDTERMINATOR:
    case FILTER:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case HEADERS:
    case HOME:
    case IF:
    case IN:
    case INDEX:
    case INDEXES:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LIMITROWS:
    case LOAD:
    case LOOKUP:
    case MANAGEMENT:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NEW:
    case NODE:
    case NODES:
    case NONE:
    case NOT:
    case NOWAIT:
    case NULL:
    case OF:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTY:
    case RANGE:
    case READ:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REQUIRE:
    case REQUIRED:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDS:
    case SEEK:
    case SET:
    case SHORTEST_PATH:
    case SHOW:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TO:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRUE:
    case TYPE:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNWIND:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VERBOSE:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WRITE:
    case XOR:
    case YIELD:
    case IDENTIFIER:{
      Variable();
      jj_consume_token(EQ);
      break;
      }
    default:
      jj_la1[115] = jj_gen;
      ;
    }
    EveryPathPattern();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      jj_consume_token(WHERE);
      break;
      }
    case BAR:{
      jj_consume_token(BAR);
      break;
      }
    default:
      jj_la1[116] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public EXPRESSION FilterExpression() throws ParseException {Token t;
    VARIABLE v;
    EXPRESSION e;
    EXPRESSION where = null;
    t = jj_consume_token(FILTER);
    jj_consume_token(LPAREN);
    v = Variable();
    jj_consume_token(IN);
    e = Expression();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      jj_consume_token(WHERE);
      where = Expression();
      break;
      }
    default:
      jj_la1[117] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.filterExpression( pos( t ), v, e, where );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION ExtractExpression() throws ParseException {Token t;
    VARIABLE v;
    EXPRESSION e;
    EXPRESSION where = null;
    EXPRESSION projection = null;
    t = jj_consume_token(EXTRACT);
    jj_consume_token(LPAREN);
    v = Variable();
    jj_consume_token(IN);
    e = Expression();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      jj_consume_token(WHERE);
      where = Expression();
      break;
      }
    default:
      jj_la1[118] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case BAR:{
      jj_consume_token(BAR);
      projection = Expression();
      break;
      }
    default:
      jj_la1[119] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.extractExpression( pos( t ), v, e, where, projection );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION ReduceExpression() throws ParseException {Token t;
    VARIABLE acc;
    EXPRESSION accExpr;
    VARIABLE v;
    EXPRESSION vExpr;
    EXPRESSION innerExpr;
    t = jj_consume_token(REDUCE);
    jj_consume_token(LPAREN);
    acc = Variable();
    jj_consume_token(EQ);
    accExpr = Expression();
    jj_consume_token(250);
    v = Variable();
    jj_consume_token(IN);
    vExpr = Expression();
    jj_consume_token(BAR);
    innerExpr = Expression();
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.reduceExpression( pos( t ), acc, accExpr, v, vExpr, innerExpr );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION AllExpression() throws ParseException {Token t;
    VARIABLE v;
    EXPRESSION e;
    EXPRESSION where = null;
    t = jj_consume_token(ALL);
    jj_consume_token(LPAREN);
    v = Variable();
    jj_consume_token(IN);
    e = Expression();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      jj_consume_token(WHERE);
      where = Expression();
      break;
      }
    default:
      jj_la1[120] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.allExpression( pos( t ), v, e, where );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION AnyExpression() throws ParseException {Token t;
    VARIABLE v;
    EXPRESSION e;
    EXPRESSION where = null;
    t = jj_consume_token(ANY);
    jj_consume_token(LPAREN);
    v = Variable();
    jj_consume_token(IN);
    e = Expression();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      jj_consume_token(WHERE);
      where = Expression();
      break;
      }
    default:
      jj_la1[121] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.anyExpression( pos( t ), v, e, where );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION NoneExpression() throws ParseException {Token t;
    VARIABLE v;
    EXPRESSION e;
    EXPRESSION where = null;
    t = jj_consume_token(NONE);
    jj_consume_token(LPAREN);
    v = Variable();
    jj_consume_token(IN);
    e = Expression();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      jj_consume_token(WHERE);
      where = Expression();
      break;
      }
    default:
      jj_la1[122] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.noneExpression( pos( t ), v, e, where );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION SingleExpression() throws ParseException {Token t;
    VARIABLE v;
    EXPRESSION e;
    EXPRESSION where = null;
    t = jj_consume_token(SINGLE);
    jj_consume_token(LPAREN);
    v = Variable();
    jj_consume_token(IN);
    e = Expression();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      jj_consume_token(WHERE);
      where = Expression();
      break;
      }
    default:
      jj_la1[123] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.singleExpression( pos( t ), v, e, where );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION PatternExpression() throws ParseException {PATTERN p;
    Token t;
t = token;
    p = EveryPathPatternNonEmpty();
{if ("" != null) return astFactory.patternExpression( pos( t.next ), p );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION ShortestPathExpression() throws ParseException {PATTERN p;
    Token t;
t = token;
    p = ShortestPathPattern();
{if ("" != null) return astFactory.patternExpression( pos( t.next ), p );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION MapProjection() throws ParseException {Token t;
    VARIABLE v;
    MAP_PROJECTION_ITEM x;
    List<MAP_PROJECTION_ITEM> items = new ArrayList<>();
    v = Variable();
    t = jj_consume_token(LCURLY);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case AS:
    case ASC:
    case ASSERT:
    case ASSIGN:
    case AT:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASE:
    case CATALOG:
    case CHANGE:
    case COMMIT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DBMS:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESTROY:
    case DETACH:
    case DISTINCT:
    case DOT:
    case DRIVER:
    case DROP:
    case DUMP:
    case EACH:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case EXTRACT:
    case FALSE:
    case FIELDTERMINATOR:
    case FILTER:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case HEADERS:
    case HOME:
    case IF:
    case IN:
    case INDEX:
    case INDEXES:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LIMITROWS:
    case LOAD:
    case LOOKUP:
    case MANAGEMENT:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NEW:
    case NODE:
    case NODES:
    case NONE:
    case NOT:
    case NOWAIT:
    case NULL:
    case OF:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTY:
    case RANGE:
    case READ:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REQUIRE:
    case REQUIRED:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDS:
    case SEEK:
    case SET:
    case SHORTEST_PATH:
    case SHOW:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TO:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRUE:
    case TYPE:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNWIND:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VERBOSE:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WRITE:
    case XOR:
    case YIELD:
    case IDENTIFIER:{
      x = MapProjectionItem();
items.add( x );
      break;
      }
    default:
      jj_la1[124] = jj_gen;
      ;
    }
    label_35:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 250:{
        break;
        }
      default:
        jj_la1[125] = jj_gen;
        break label_35;
      }
      jj_consume_token(250);
      x = MapProjectionItem();
items.add( x );
    }
    jj_consume_token(RCURLY);
{if ("" != null) return astFactory.mapProjection( pos( t ), v, items );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public MAP_PROJECTION_ITEM MapProjectionItem() throws ParseException {Token t;
    StringPos<POS> p;
    EXPRESSION e;
    VARIABLE v;
    if (jj_2_46(2)) {
      p = PropertyKeyName();
      jj_consume_token(252);
      e = Expression();
{if ("" != null) return astFactory.mapProjectionLiteralEntry( p, e );}
    } else if (jj_2_47(2)) {
      jj_consume_token(DOT);
      p = PropertyKeyName();
{if ("" != null) return astFactory.mapProjectionProperty( p );}
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case AS:
      case ASC:
      case ASSERT:
      case ASSIGN:
      case AT:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASE:
      case CATALOG:
      case CHANGE:
      case COMMIT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DBMS:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESTROY:
      case DETACH:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DUMP:
      case EACH:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case EXTRACT:
      case FALSE:
      case FIELDTERMINATOR:
      case FILTER:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case HEADERS:
      case HOME:
      case IF:
      case IN:
      case INDEX:
      case INDEXES:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LIMITROWS:
      case LOAD:
      case LOOKUP:
      case MANAGEMENT:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NEW:
      case NODE:
      case NODES:
      case NONE:
      case NOT:
      case NOWAIT:
      case NULL:
      case OF:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTY:
      case RANGE:
      case READ:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REQUIRE:
      case REQUIRED:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDS:
      case SEEK:
      case SET:
      case SHORTEST_PATH:
      case SHOW:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TO:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRUE:
      case TYPE:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNWIND:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VERBOSE:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WRITE:
      case XOR:
      case YIELD:
      case IDENTIFIER:{
        v = Variable();
{if ("" != null) return astFactory.mapProjectionVariable( v );}
        break;
        }
      case DOT:{
        jj_consume_token(DOT);
        t = jj_consume_token(TIMES);
{if ("" != null) return astFactory.mapProjectionAll( pos( t ) );}
        break;
        }
      default:
        jj_la1[126] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION ExistsSubQuery() throws ParseException {Token t;
    List<PATTERN> patterns;
    EXPRESSION where = null;
    t = jj_consume_token(EXISTS);
    jj_consume_token(LCURLY);
    if (jj_2_48(2)) {
      jj_consume_token(MATCH);
    } else {
      ;
    }
    patterns = PatternList();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      jj_consume_token(WHERE);
      where = Expression();
      break;
      }
    default:
      jj_la1[127] = jj_gen;
      ;
    }
    jj_consume_token(RCURLY);
{if ("" != null) return astFactory.existsSubQuery( pos( t ), patterns, where );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Literal() throws ParseException {Token t;
    EXPRESSION e;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DECIMAL_DOUBLE:
    case UNSIGNED_DECIMAL_INTEGER:
    case UNSIGNED_HEX_INTEGER:
    case UNSIGNED_OCTAL_INTEGER:
    case MINUS:{
      e = NumberLiteral();
      break;
      }
    case STRING_LITERAL1:
    case STRING_LITERAL2:{
      e = StringLiteral();
      break;
      }
    case DOLLAR:{
      e = Parameter(ParameterType.ANY);
      break;
      }
    case TRUE:{
      t = jj_consume_token(TRUE);
e = astFactory.newTrueLiteral( pos( t ) );
      break;
      }
    case FALSE:{
      t = jj_consume_token(FALSE);
e = astFactory.newFalseLiteral( pos( t ) );
      break;
      }
    default:
      jj_la1[128] = jj_gen;
      if (jj_2_49(2)) {
        t = jj_consume_token(NULL);
e = astFactory.newNullLiteral( pos( t ) );
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case LBRACKET:{
          e = ListLiteralOfLiterals();
          break;
          }
        case LCURLY:{
          e = MapLiteralOfLiterals();
          break;
          }
        case ESCAPED_SYMBOLIC_NAME:
        case ACCESS:
        case ACTIVE:
        case ALIAS:
        case ALIASES:
        case ALL_SHORTEST_PATH:
        case ALL:
        case ALTER:
        case AND:
        case ANY:
        case AS:
        case ASC:
        case ASSERT:
        case ASSIGN:
        case AT:
        case BRIEF:
        case BTREE:
        case BUILT:
        case BY:
        case CALL:
        case CASE:
        case CATALOG:
        case CHANGE:
        case COMMIT:
        case CONSTRAINT:
        case CONSTRAINTS:
        case CONTAINS:
        case COPY:
        case COUNT:
        case CREATE:
        case CSV:
        case CURRENT:
        case DATA:
        case DATABASE:
        case DATABASES:
        case DBMS:
        case DEFAULT_TOKEN:
        case DEFINED:
        case DELETE:
        case DENY:
        case DESC:
        case DESTROY:
        case DETACH:
        case DISTINCT:
        case DRIVER:
        case DROP:
        case DUMP:
        case EACH:
        case ELEMENT:
        case ELEMENTS:
        case ELSE:
        case ENCRYPTED:
        case END:
        case ENDS:
        case EXECUTABLE:
        case EXIST:
        case EXISTENCE:
        case EXISTS:
        case EXTRACT:
        case FALSE:
        case FIELDTERMINATOR:
        case FILTER:
        case FOR:
        case FOREACH:
        case FROM:
        case FULLTEXT:
        case FUNCTION:
        case FUNCTIONS:
        case GRANT:
        case GRAPH:
        case GRAPHS:
        case HEADERS:
        case HOME:
        case IF:
        case IN:
        case INDEX:
        case INDEXES:
        case IS:
        case JOIN:
        case KEY:
        case LABEL:
        case LABELS:
        case LIMITROWS:
        case LOAD:
        case LOOKUP:
        case MANAGEMENT:
        case MATCH:
        case MERGE:
        case NAME:
        case NAMES:
        case NEW:
        case NODE:
        case NODES:
        case NONE:
        case NOT:
        case NOWAIT:
        case NULL:
        case OF:
        case ON:
        case ONLY:
        case OPTIONAL:
        case OPTIONS:
        case OR:
        case ORDER:
        case OUTPUT:
        case PASSWORD:
        case PASSWORDS:
        case PERIODIC:
        case PLAINTEXT:
        case POINT:
        case POPULATED:
        case PRIVILEGE:
        case PRIVILEGES:
        case PROCEDURE:
        case PROCEDURES:
        case PROPERTY:
        case RANGE:
        case READ:
        case REDUCE:
        case RENAME:
        case REL:
        case RELATIONSHIP:
        case RELATIONSHIPS:
        case REMOVE:
        case REPLACE:
        case REQUIRE:
        case REQUIRED:
        case RETURN:
        case REVOKE:
        case ROLE:
        case ROLES:
        case ROW:
        case ROWS:
        case SCAN:
        case SEC:
        case SECOND:
        case SECONDS:
        case SEEK:
        case SET:
        case SHORTEST_PATH:
        case SHOW:
        case SINGLE:
        case SKIPROWS:
        case START:
        case STARTS:
        case STATUS:
        case STOP:
        case SUSPENDED:
        case TARGET:
        case TERMINATE:
        case TEXT:
        case THEN:
        case TO:
        case TRANSACTION:
        case TRANSACTIONS:
        case TRAVERSE:
        case TRUE:
        case TYPE:
        case TYPES:
        case UNION:
        case UNIQUE:
        case UNWIND:
        case USE:
        case USER:
        case USERS:
        case USING:
        case VERBOSE:
        case WAIT:
        case WHEN:
        case WHERE:
        case WITH:
        case WRITE:
        case XOR:
        case YIELD:
        case IDENTIFIER:{
          e = FunctionInvocation();
          break;
          }
        default:
          jj_la1[129] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION ListLiteralOfLiterals() throws ParseException {Token t;
    EXPRESSION e;
    List<EXPRESSION> list = new ArrayList<>();
    t = jj_consume_token(LBRACKET);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DECIMAL_DOUBLE:
    case UNSIGNED_DECIMAL_INTEGER:
    case UNSIGNED_HEX_INTEGER:
    case UNSIGNED_OCTAL_INTEGER:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case AS:
    case ASC:
    case ASSERT:
    case ASSIGN:
    case AT:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASE:
    case CATALOG:
    case CHANGE:
    case COMMIT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DBMS:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESTROY:
    case DETACH:
    case DOLLAR:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DUMP:
    case EACH:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case EXTRACT:
    case FALSE:
    case FIELDTERMINATOR:
    case FILTER:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case HEADERS:
    case HOME:
    case IF:
    case IN:
    case INDEX:
    case INDEXES:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LBRACKET:
    case LCURLY:
    case LIMITROWS:
    case LOAD:
    case LOOKUP:
    case MANAGEMENT:
    case MATCH:
    case MERGE:
    case MINUS:
    case NAME:
    case NAMES:
    case NEW:
    case NODE:
    case NODES:
    case NONE:
    case NOT:
    case NOWAIT:
    case NULL:
    case OF:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTY:
    case RANGE:
    case READ:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REQUIRE:
    case REQUIRED:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDS:
    case SEEK:
    case SET:
    case SHORTEST_PATH:
    case SHOW:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TO:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRUE:
    case TYPE:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNWIND:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VERBOSE:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WRITE:
    case XOR:
    case YIELD:
    case IDENTIFIER:{
      e = Literal();
list.add(e);
      break;
      }
    default:
      jj_la1[130] = jj_gen;
      ;
    }
    label_36:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 250:{
        break;
        }
      default:
        jj_la1[131] = jj_gen;
        break label_36;
      }
      jj_consume_token(250);
      e = Literal();
list.add( e );
    }
    jj_consume_token(RBRACKET);
{if ("" != null) return astFactory.listLiteral( pos( t ), list );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION MapLiteralOfLiterals() throws ParseException {Token t;
    StringPos<POS> key;
    EXPRESSION value;
    List<StringPos<POS>> keys = new ArrayList<>();
    List<EXPRESSION> values = new ArrayList<>();
    t = jj_consume_token(LCURLY);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case AS:
    case ASC:
    case ASSERT:
    case ASSIGN:
    case AT:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASE:
    case CATALOG:
    case CHANGE:
    case COMMIT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DBMS:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESTROY:
    case DETACH:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DUMP:
    case EACH:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case EXTRACT:
    case FALSE:
    case FIELDTERMINATOR:
    case FILTER:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case HEADERS:
    case HOME:
    case IF:
    case IN:
    case INDEX:
    case INDEXES:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LIMITROWS:
    case LOAD:
    case LOOKUP:
    case MANAGEMENT:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NEW:
    case NODE:
    case NODES:
    case NONE:
    case NOT:
    case NOWAIT:
    case NULL:
    case OF:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTY:
    case RANGE:
    case READ:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REQUIRE:
    case REQUIRED:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDS:
    case SEEK:
    case SET:
    case SHORTEST_PATH:
    case SHOW:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TO:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRUE:
    case TYPE:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNWIND:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VERBOSE:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WRITE:
    case XOR:
    case YIELD:
    case IDENTIFIER:{
      key = PropertyKeyName();
      jj_consume_token(252);
      value = Literal();
keys.add( key ); values.add( value );
      break;
      }
    default:
      jj_la1[132] = jj_gen;
      ;
    }
    label_37:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 250:{
        break;
        }
      default:
        jj_la1[133] = jj_gen;
        break label_37;
      }
      jj_consume_token(250);
      key = PropertyKeyName();
      jj_consume_token(252);
      value = Literal();
keys.add( key ); values.add( value );
    }
    jj_consume_token(RCURLY);
{if ("" != null) return astFactory.mapLiteral( pos( t ), keys, values );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION StringLiteral() throws ParseException {Token t;
    t = StringToken();
{if ("" != null) return astFactory.newString( pos( t ), token.image );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION NumberLiteral() throws ParseException {Token sign = null;
    Token t;
    boolean negated = false;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case MINUS:{
      sign = jj_consume_token(MINUS);
negated = true;
      break;
      }
    default:
      jj_la1[134] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DECIMAL_DOUBLE:{
      t = jj_consume_token(DECIMAL_DOUBLE);
{if ("" != null) return astFactory.newDouble(  pos( sign != null ? sign : t ) , sign != null ? sign.image + token.image : token.image );}
      break;
      }
    case UNSIGNED_DECIMAL_INTEGER:{
      t = jj_consume_token(UNSIGNED_DECIMAL_INTEGER);
{if ("" != null) return astFactory.newDecimalInteger( pos( sign != null ? sign : t ), token.image, negated );}
      break;
      }
    case UNSIGNED_HEX_INTEGER:{
      t = jj_consume_token(UNSIGNED_HEX_INTEGER);
{if ("" != null) return astFactory.newHexInteger( pos( sign != null ? sign : t ), token.image, negated );}
      break;
      }
    case UNSIGNED_OCTAL_INTEGER:{
      t = jj_consume_token(UNSIGNED_OCTAL_INTEGER);
{if ("" != null) return astFactory.newOctalInteger( pos( sign != null ? sign : t ), token.image, negated );}
      break;
      }
    default:
      jj_la1[135] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION SignedIntegerLiteral() throws ParseException {Token sign = null;
    Token number;
    boolean negated = false;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case MINUS:{
      sign = jj_consume_token(MINUS);
negated = true;
      break;
      }
    default:
      jj_la1[136] = jj_gen;
      ;
    }
    number = jj_consume_token(UNSIGNED_DECIMAL_INTEGER);
{if ("" != null) return astFactory.newDecimalInteger( pos( sign != null ? sign : number ), token.image, negated );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION ListLiteral() throws ParseException {Token t;
    EXPRESSION e;
    List<EXPRESSION> list = new ArrayList<>();
    t = jj_consume_token(LBRACKET);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DECIMAL_DOUBLE:
    case UNSIGNED_DECIMAL_INTEGER:
    case UNSIGNED_HEX_INTEGER:
    case UNSIGNED_OCTAL_INTEGER:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case AS:
    case ASC:
    case ASSERT:
    case ASSIGN:
    case AT:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASE:
    case CATALOG:
    case CHANGE:
    case COMMIT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DBMS:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESTROY:
    case DETACH:
    case DOLLAR:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DUMP:
    case EACH:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case EXTRACT:
    case FALSE:
    case FIELDTERMINATOR:
    case FILTER:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case HEADERS:
    case HOME:
    case IF:
    case IN:
    case INDEX:
    case INDEXES:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LBRACKET:
    case LCURLY:
    case LIMITROWS:
    case LOAD:
    case LOOKUP:
    case LPAREN:
    case MANAGEMENT:
    case MATCH:
    case MERGE:
    case MINUS:
    case NAME:
    case NAMES:
    case NEW:
    case NODE:
    case NODES:
    case NONE:
    case NOT:
    case NOWAIT:
    case NULL:
    case OF:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PERIODIC:
    case PLAINTEXT:
    case PLUS:
    case POINT:
    case POPULATED:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTY:
    case RANGE:
    case READ:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REQUIRE:
    case REQUIRED:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDS:
    case SEEK:
    case SET:
    case SHORTEST_PATH:
    case SHOW:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TO:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRUE:
    case TYPE:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNWIND:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VERBOSE:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WRITE:
    case XOR:
    case YIELD:
    case IDENTIFIER:{
      e = Expression();
list.add( e );
      break;
      }
    default:
      jj_la1[137] = jj_gen;
      ;
    }
    label_38:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 250:{
        break;
        }
      default:
        jj_la1[138] = jj_gen;
        break label_38;
      }
      jj_consume_token(250);
      e = Expression();
list.add( e );
    }
    jj_consume_token(RBRACKET);
{if ("" != null) return astFactory.listLiteral( pos( t ), list );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION MapLiteral() throws ParseException {Token t;
    StringPos<POS> key;
    EXPRESSION value;
    List<StringPos<POS>> keys = new ArrayList<>();
    List<EXPRESSION> values = new ArrayList<>();
    t = jj_consume_token(LCURLY);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case AS:
    case ASC:
    case ASSERT:
    case ASSIGN:
    case AT:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASE:
    case CATALOG:
    case CHANGE:
    case COMMIT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DBMS:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESTROY:
    case DETACH:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DUMP:
    case EACH:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case EXTRACT:
    case FALSE:
    case FIELDTERMINATOR:
    case FILTER:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case HEADERS:
    case HOME:
    case IF:
    case IN:
    case INDEX:
    case INDEXES:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LIMITROWS:
    case LOAD:
    case LOOKUP:
    case MANAGEMENT:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NEW:
    case NODE:
    case NODES:
    case NONE:
    case NOT:
    case NOWAIT:
    case NULL:
    case OF:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTY:
    case RANGE:
    case READ:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REQUIRE:
    case REQUIRED:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDS:
    case SEEK:
    case SET:
    case SHORTEST_PATH:
    case SHOW:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TO:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRUE:
    case TYPE:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNWIND:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VERBOSE:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WRITE:
    case XOR:
    case YIELD:
    case IDENTIFIER:{
      key = PropertyKeyName();
      jj_consume_token(252);
      value = Expression();
keys.add( key ); values.add( value );
      break;
      }
    default:
      jj_la1[139] = jj_gen;
      ;
    }
    label_39:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 250:{
        break;
        }
      default:
        jj_la1[140] = jj_gen;
        break label_39;
      }
      jj_consume_token(250);
      key = PropertyKeyName();
      jj_consume_token(252);
      value = Expression();
keys.add( key ); values.add( value );
    }
    jj_consume_token(RCURLY);
{if ("" != null) return astFactory.mapLiteral( pos( t ), keys, values);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public StringPos<POS> PropertyKeyName() throws ParseException {Token t;
    t = SymbolicNameString();
{if ("" != null) return new StringPos<POS>( t.image,  pos( t ) );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PARAMETER Parameter(ParameterType type) throws ParseException {Token t;
    VARIABLE v;
    t = jj_consume_token(DOLLAR);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case AS:
    case ASC:
    case ASSERT:
    case ASSIGN:
    case AT:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASE:
    case CATALOG:
    case CHANGE:
    case COMMIT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DBMS:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESTROY:
    case DETACH:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DUMP:
    case EACH:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case EXTRACT:
    case FALSE:
    case FIELDTERMINATOR:
    case FILTER:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case HEADERS:
    case HOME:
    case IF:
    case IN:
    case INDEX:
    case INDEXES:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LIMITROWS:
    case LOAD:
    case LOOKUP:
    case MANAGEMENT:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NEW:
    case NODE:
    case NODES:
    case NONE:
    case NOT:
    case NOWAIT:
    case NULL:
    case OF:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTY:
    case RANGE:
    case READ:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REQUIRE:
    case REQUIRED:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDS:
    case SEEK:
    case SET:
    case SHORTEST_PATH:
    case SHOW:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TO:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRUE:
    case TYPE:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNWIND:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VERBOSE:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WRITE:
    case XOR:
    case YIELD:
    case IDENTIFIER:{
      v = Variable();
{if ("" != null) return astFactory.newParameter( pos( t ), v, type );}
      break;
      }
    case UNSIGNED_DECIMAL_INTEGER:{
      jj_consume_token(UNSIGNED_DECIMAL_INTEGER);
{if ("" != null) return astFactory.newParameter( pos( t ), token.image, type );}
      break;
      }
    default:
      jj_la1[141] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION OldParameter() throws ParseException {Token t;
    VARIABLE v;
    t = jj_consume_token(LCURLY);
    v = Variable();
    jj_consume_token(RCURLY);
{if ("" != null) return astFactory.oldParameter( pos( t ), v );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION FunctionInvocation() throws ParseException {Token before = token;
    Token nameSpaceToken;
    Token nameToken;
    List<String> namespace;
    boolean distinct = false;
    EXPRESSION e;
    List<EXPRESSION> arguments = new ArrayList<>();
    namespace = Namespace();
    nameToken = SymbolicNameString();
    jj_consume_token(LPAREN);
    if (jj_2_50(2)) {
      jj_consume_token(DISTINCT);
distinct=true;
    } else {
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DECIMAL_DOUBLE:
    case UNSIGNED_DECIMAL_INTEGER:
    case UNSIGNED_HEX_INTEGER:
    case UNSIGNED_OCTAL_INTEGER:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case AS:
    case ASC:
    case ASSERT:
    case ASSIGN:
    case AT:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASE:
    case CATALOG:
    case CHANGE:
    case COMMIT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DBMS:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESTROY:
    case DETACH:
    case DOLLAR:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DUMP:
    case EACH:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case EXTRACT:
    case FALSE:
    case FIELDTERMINATOR:
    case FILTER:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case HEADERS:
    case HOME:
    case IF:
    case IN:
    case INDEX:
    case INDEXES:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LBRACKET:
    case LCURLY:
    case LIMITROWS:
    case LOAD:
    case LOOKUP:
    case LPAREN:
    case MANAGEMENT:
    case MATCH:
    case MERGE:
    case MINUS:
    case NAME:
    case NAMES:
    case NEW:
    case NODE:
    case NODES:
    case NONE:
    case NOT:
    case NOWAIT:
    case NULL:
    case OF:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PERIODIC:
    case PLAINTEXT:
    case PLUS:
    case POINT:
    case POPULATED:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTY:
    case RANGE:
    case READ:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REQUIRE:
    case REQUIRED:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDS:
    case SEEK:
    case SET:
    case SHORTEST_PATH:
    case SHOW:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TO:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRUE:
    case TYPE:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNWIND:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VERBOSE:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WRITE:
    case XOR:
    case YIELD:
    case IDENTIFIER:{
      e = Expression();
arguments.add( e );
      break;
      }
    default:
      jj_la1[142] = jj_gen;
      ;
    }
    label_40:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 250:{
        break;
        }
      default:
        jj_la1[143] = jj_gen;
        break label_40;
      }
      jj_consume_token(250);
      e = Expression();
arguments.add( e );
    }
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.functionInvocation( pos( before.next ), pos( nameToken ), namespace, nameToken.image, distinct, arguments );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<String> Namespace() throws ParseException {Token t;
    List<String> parts = new ArrayList<>();
    label_41:
    while (true) {
      if (jj_2_51(2)) {
      } else {
        break label_41;
      }
      t = SymbolicNameString();
parts.add( t.image );
      jj_consume_token(DOT);
    }
{if ("" != null) return parts;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String FunctionName() throws ParseException {Token t;
    t = SymbolicNameString();
{if ("" != null) return t.image;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<VARIABLE> VariableList1() throws ParseException {Token t;
    List<VARIABLE> list = new ArrayList<>();
    t = SymbolicNameString();
list.add( astFactory.newVariable( pos( t ), t.image ) );
    label_42:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 250:{
        break;
        }
      default:
        jj_la1[144] = jj_gen;
        break label_42;
      }
      jj_consume_token(250);
      t = SymbolicNameString();
list.add( astFactory.newVariable( pos( t ), t.image) );
    }
{if ("" != null) return list;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public VARIABLE Variable() throws ParseException {Token t;
    t = SymbolicNameString();
{if ("" != null) return astFactory.newVariable( pos( t ), t.image );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<String> SymbolicNameList1() throws ParseException {Token n;
    List<String> list = new ArrayList<>();
    n = SymbolicNameString();
list.add(n.image);
    label_43:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 250:{
        break;
        }
      default:
        jj_la1[145] = jj_gen;
        break label_43;
      }
      jj_consume_token(250);
      n = SymbolicNameString();
list.add( n.image );
    }
{if ("" != null) return list;}
    throw new IllegalStateException ("Missing return statement in function");
}

// Command Section
  final public 
STATEMENT_WITH_GRAPH CreateCommand(USE_CLAUSE useClause) throws ParseException, Exception {Token start;
    boolean replace = false;
    STATEMENT_WITH_GRAPH statement;
    start = jj_consume_token(CREATE);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case OR:{
      jj_consume_token(OR);
      jj_consume_token(REPLACE);
replace = true;
      break;
      }
    default:
      jj_la1[146] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ROLE:{
      statement = CreateRole(start, replace);
      break;
      }
    case USER:{
      statement = CreateUser(start, replace);
      break;
      }
    case DATABASE:{
      statement = CreateDatabase(start, replace);
      break;
      }
    case CONSTRAINT:{
      statement = CreateConstraint(start, replace);
      break;
      }
    case BTREE:
    case FULLTEXT:
    case INDEX:
    case LOOKUP:
    case POINT:
    case RANGE:
    case TEXT:{
      statement = CreateIndex(start, replace);
      break;
      }
    case ALIAS:{
      statement = CreateAlias(start, replace);
      break;
      }
    default:
      jj_la1[147] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return astFactory.useGraph( statement, useClause );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT Command(USE_CLAUSE useClause) throws ParseException, Exception {STATEMENT statement = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ALTER:
    case DENY:
    case DROP:
    case GRANT:
    case RENAME:
    case REVOKE:
    case START:
    case STOP:{
      statement = CommandWithUseGraph(useClause);
      break;
      }
    case SHOW:{
      statement = ShowCommand(useClause);
      break;
      }
    case TERMINATE:{
      statement = TerminateCommand(useClause);
      break;
      }
    default:
      jj_la1[148] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return statement;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT_WITH_GRAPH CommandWithUseGraph(USE_CLAUSE useClause) throws ParseException, Exception {STATEMENT_WITH_GRAPH s;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DROP:{
      s = DropCommand();
      break;
      }
    case ALTER:{
      s = AlterCommand();
      break;
      }
    case RENAME:{
      s = RenameCommand();
      break;
      }
    case DENY:{
      s = DenyPrivilege();
      break;
      }
    case REVOKE:{
      s = RevokeCommand();
      break;
      }
    case GRANT:{
      s = GrantCommand();
      break;
      }
    case START:{
      s = StartDatabase();
      break;
      }
    case STOP:{
      s = StopDatabase();
      break;
      }
    default:
      jj_la1[149] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return astFactory.useGraph( s, useClause );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT_WITH_GRAPH DropCommand() throws ParseException, Exception {Token start;
    STATEMENT_WITH_GRAPH s;
    start = jj_consume_token(DROP);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ROLE:{
      s = DropRole(start);
      break;
      }
    case USER:{
      s = DropUser(start);
      break;
      }
    case DATABASE:{
      s = DropDatabase(start);
      break;
      }
    case CONSTRAINT:{
      s = DropConstraint(start);
      break;
      }
    case INDEX:{
      s = DropIndex(start);
      break;
      }
    case ALIAS:{
      s = DropAlias(start);
      break;
      }
    default:
      jj_la1[150] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return s;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT_WITH_GRAPH AlterCommand() throws ParseException, Exception {Token start = null;
    STATEMENT_WITH_GRAPH s;
    start = jj_consume_token(ALTER);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DATABASE:{
      s = AlterDatabase(start);
      break;
      }
    case ALIAS:{
      s = AlterAlias(start);
      break;
      }
    case CURRENT:{
      s = AlterCurrentUser(start);
      break;
      }
    case USER:{
      s = AlterUser(start);
      break;
      }
    default:
      jj_la1[151] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return s;}
    throw new IllegalStateException ("Missing return statement in function");
}

// SHOW commands
  final public 
STATEMENT ShowCommand(USE_CLAUSE useClause) throws ParseException {Token start = null;
    Token showCommandType = null;
    STATEMENT statement = null;
    start = jj_consume_token(SHOW);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ALL:{
      showCommandType = jj_consume_token(ALL);
      statement = ShowAllCommand(start, useClause);
      break;
      }
    case POPULATED:{
      jj_consume_token(POPULATED);
      statement = ShowRoles(start, useClause, false);
      break;
      }
    case BTREE:{
      showCommandType = jj_consume_token(BTREE);
      statement = ShowIndexesAllowBrief(start, useClause, ShowCommandFilterTypes.BTREE);
      break;
      }
    case RANGE:{
      showCommandType = jj_consume_token(RANGE);
      statement = ShowIndexesNoBrief(start, useClause, ShowCommandFilterTypes.RANGE);
      break;
      }
    case FULLTEXT:{
      showCommandType = jj_consume_token(FULLTEXT);
      statement = ShowIndexesNoBrief(start, useClause, ShowCommandFilterTypes.FULLTEXT);
      break;
      }
    case TEXT:{
      showCommandType = jj_consume_token(TEXT);
      statement = ShowIndexesNoBrief(start, useClause, ShowCommandFilterTypes.TEXT);
      break;
      }
    case POINT:{
      showCommandType = jj_consume_token(POINT);
      statement = ShowIndexesNoBrief(start, useClause, ShowCommandFilterTypes.POINT);
      break;
      }
    case LOOKUP:{
      showCommandType = jj_consume_token(LOOKUP);
      statement = ShowIndexesNoBrief(start, useClause, ShowCommandFilterTypes.LOOKUP);
      break;
      }
    case UNIQUE:{
      showCommandType = jj_consume_token(UNIQUE);
      statement = ShowConstraintsAllowBriefAndYield(start, useClause, ShowCommandFilterTypes.UNIQUE);
      break;
      }
    case NODE:{
      showCommandType = jj_consume_token(NODE);
      statement = ShowNodeCommand(start, useClause);
      break;
      }
    case PROPERTY:{
      showCommandType = jj_consume_token(PROPERTY);
      statement = ShowPropertyCommand(start, useClause, ShowCommandFilterTypes.EXIST);
      break;
      }
    case EXISTENCE:{
      showCommandType = jj_consume_token(EXISTENCE);
      statement = ShowConstraintsAllowYield(start, useClause, ShowCommandFilterTypes.EXIST);
      break;
      }
    case EXISTS:{
      showCommandType = jj_consume_token(EXISTS);
      statement = ShowConstraintsAllowBrief(start, useClause, ShowCommandFilterTypes.OLD_EXISTS);
      break;
      }
    case EXIST:{
      showCommandType = jj_consume_token(EXIST);
      statement = ShowConstraintsAllowBriefAndYield(start, useClause, ShowCommandFilterTypes.OLD_EXIST);
      break;
      }
    case RELATIONSHIP:{
      showCommandType = jj_consume_token(RELATIONSHIP);
      statement = ShowRelationshipCommand(start, useClause);
      break;
      }
    case REL:{
      showCommandType = jj_consume_token(REL);
      statement = ShowRelCommand(start, useClause);
      break;
      }
    case BUILT:{
      showCommandType = jj_consume_token(BUILT);
      jj_consume_token(IN);
      statement = ShowFunctions(start, useClause, ShowCommandFilterTypes.BUILT_IN);
      break;
      }
    case USER:{
      showCommandType = jj_consume_token(USER);
      jj_consume_token(DEFINED);
      statement = ShowFunctions(start, useClause, ShowCommandFilterTypes.USER_DEFINED);
      break;
      }
    case ROLES:{
      statement = ShowRoles(start, useClause, true);
      break;
      }
    case INDEX:
    case INDEXES:{
      statement = ShowIndexesAllowBrief(start, useClause, ShowCommandFilterTypes.ALL);
      break;
      }
    case DATABASE:
    case DATABASES:
    case DEFAULT_TOKEN:
    case HOME:{
      statement = ShowDatabase(start, useClause);
      break;
      }
    case USERS:{
      statement = ShowUsers(start, useClause);
      break;
      }
    case CURRENT:{
      statement = ShowCurrentUser(start, useClause);
      break;
      }
    case CONSTRAINT:
    case CONSTRAINTS:{
      statement = ShowConstraintsAllowBriefAndYield(start, useClause, ShowCommandFilterTypes.ALL);
      break;
      }
    case PROCEDURE:
    case PROCEDURES:{
      statement = ShowProcedures(start, useClause);
      break;
      }
    case FUNCTION:
    case FUNCTIONS:{
      statement = ShowFunctions(start, useClause, ShowCommandFilterTypes.ALL);
      break;
      }
    case TRANSACTION:
    case TRANSACTIONS:{
      statement = ShowTransactions(start, useClause);
      break;
      }
    case ALIAS:
    case ALIASES:{
      statement = ShowAliases(start, useClause);
      break;
      }
    default:
      jj_la1[152] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return statement;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT TerminateCommand(USE_CLAUSE useClause) throws ParseException {Token start = null;
    STATEMENT statement = null;
    start = jj_consume_token(TERMINATE);
    statement = TerminateTransactions(start, useClause);
{if ("" != null) return statement;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT ShowAllCommand(Token start, USE_CLAUSE useClause) throws ParseException {STATEMENT statement = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ROLES:{
      statement = ShowRoles(start, useClause, true);
      break;
      }
    case INDEX:
    case INDEXES:{
      statement = ShowIndexesAllowBrief(start, useClause, ShowCommandFilterTypes.ALL);
      break;
      }
    case CONSTRAINT:
    case CONSTRAINTS:{
      statement = ShowConstraintsAllowBriefAndYield(start, useClause, ShowCommandFilterTypes.ALL);
      break;
      }
    case FUNCTION:
    case FUNCTIONS:{
      statement = ShowFunctions(start, useClause, ShowCommandFilterTypes.ALL);
      break;
      }
    default:
      jj_la1[153] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return statement;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT ShowNodeCommand(Token start, USE_CLAUSE useClause) throws ParseException {Token constraintType = null;
    STATEMENT statement = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case KEY:{
      constraintType = jj_consume_token(KEY);
      statement = ShowConstraintsAllowBriefAndYield(start, useClause, ShowCommandFilterTypes.NODE_KEY);
      break;
      }
    case PROPERTY:{
      constraintType = jj_consume_token(PROPERTY);
      statement = ShowPropertyCommand(start, useClause, ShowCommandFilterTypes.NODE_EXIST);
      break;
      }
    case EXISTENCE:{
      constraintType = jj_consume_token(EXISTENCE);
      statement = ShowConstraintsAllowYield(start, useClause, ShowCommandFilterTypes.NODE_EXIST);
      break;
      }
    case EXISTS:{
      constraintType = jj_consume_token(EXISTS);
      statement = ShowConstraintsAllowBrief(start, useClause, ShowCommandFilterTypes.NODE_OLD_EXISTS);
      break;
      }
    case EXIST:{
      constraintType = jj_consume_token(EXIST);
      statement = ShowConstraintsAllowBriefAndYield(start, useClause, ShowCommandFilterTypes.NODE_OLD_EXIST);
      break;
      }
    default:
      jj_la1[154] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return statement;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT ShowRelationshipCommand(Token start, USE_CLAUSE useClause) throws ParseException {Token constraintType = null;
    STATEMENT statement = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case PROPERTY:{
      constraintType = jj_consume_token(PROPERTY);
      statement = ShowPropertyCommand(start, useClause, ShowCommandFilterTypes.RELATIONSHIP_EXIST);
      break;
      }
    case EXISTENCE:{
      constraintType = jj_consume_token(EXISTENCE);
      statement = ShowConstraintsAllowYield(start, useClause, ShowCommandFilterTypes.RELATIONSHIP_EXIST);
      break;
      }
    case EXISTS:{
      constraintType = jj_consume_token(EXISTS);
      statement = ShowConstraintsAllowBrief(start, useClause, ShowCommandFilterTypes.RELATIONSHIP_OLD_EXISTS);
      break;
      }
    case EXIST:{
      constraintType = jj_consume_token(EXIST);
      statement = ShowConstraintsAllowBriefAndYield(start, useClause, ShowCommandFilterTypes.RELATIONSHIP_OLD_EXIST);
      break;
      }
    default:
      jj_la1[155] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return statement;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT ShowRelCommand(Token start, USE_CLAUSE useClause) throws ParseException {STATEMENT statement = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case PROPERTY:{
      jj_consume_token(PROPERTY);
      statement = ShowPropertyCommand(start, useClause, ShowCommandFilterTypes.RELATIONSHIP_EXIST);
      break;
      }
    case EXISTENCE:{
      jj_consume_token(EXISTENCE);
      statement = ShowConstraintsAllowYield(start, useClause, ShowCommandFilterTypes.RELATIONSHIP_EXIST);
      break;
      }
    case EXIST:{
      jj_consume_token(EXIST);
      statement = ShowConstraintsAllowYield(start, useClause, ShowCommandFilterTypes.RELATIONSHIP_EXIST);
      break;
      }
    default:
      jj_la1[156] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return statement;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT ShowPropertyCommand(Token start, USE_CLAUSE useClause, ShowCommandFilterTypes constraintType) throws ParseException {STATEMENT statement = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case EXISTENCE:{
      jj_consume_token(EXISTENCE);
      statement = ShowConstraintsAllowYield(start, useClause, constraintType);
      break;
      }
    case EXIST:{
      jj_consume_token(EXIST);
      statement = ShowConstraintsAllowYield(start, useClause, constraintType);
      break;
      }
    default:
      jj_la1[157] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return statement;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public RETURN_ITEM YieldItem() throws ParseException {VARIABLE e;
    VARIABLE v = null;
    Token eStart;
    Token eEnd;
eStart = token;
    e = Variable();
eEnd = token;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case AS:{
      jj_consume_token(AS);
      v = Variable();
      break;
      }
    default:
      jj_la1[158] = jj_gen;
      ;
    }
if ( v != null )
        {
            {if ("" != null) return astFactory.newReturnItem( pos( eStart.next ), e, v );}
        }
        else
        {
            {if ("" != null) return astFactory.newReturnItem( pos( eStart.next ), e, eStart.next.beginOffset, eEnd.endOffset );}
        }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public YIELD YieldClause() throws ParseException {Token start;
    Token skipPosition = null;
    Token limitPosition = null;
    Token orderToken = null;
    boolean returnAll = false;
    RETURN_ITEM item;
    ORDER_ITEM o;
    List<RETURN_ITEM> returnItems = new ArrayList<>();
    List<ORDER_ITEM> orders = new ArrayList<>();
    EXPRESSION skip = null;
    EXPRESSION limit = null;
    WHERE where = null;
    start = jj_consume_token(YIELD);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case TIMES:{
      jj_consume_token(TIMES);
returnAll = true;
      break;
      }
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case AS:
    case ASC:
    case ASSERT:
    case ASSIGN:
    case AT:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASE:
    case CATALOG:
    case CHANGE:
    case COMMIT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DBMS:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESTROY:
    case DETACH:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DUMP:
    case EACH:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case EXTRACT:
    case FALSE:
    case FIELDTERMINATOR:
    case FILTER:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case HEADERS:
    case HOME:
    case IF:
    case IN:
    case INDEX:
    case INDEXES:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LIMITROWS:
    case LOAD:
    case LOOKUP:
    case MANAGEMENT:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NEW:
    case NODE:
    case NODES:
    case NONE:
    case NOT:
    case NOWAIT:
    case NULL:
    case OF:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTY:
    case RANGE:
    case READ:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REQUIRE:
    case REQUIRED:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDS:
    case SEEK:
    case SET:
    case SHORTEST_PATH:
    case SHOW:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TO:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRUE:
    case TYPE:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNWIND:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VERBOSE:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WRITE:
    case XOR:
    case YIELD:
    case IDENTIFIER:{
      item = YieldItem();
returnItems.add( item );
      label_44:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case 250:{
          break;
          }
        default:
          jj_la1[159] = jj_gen;
          break label_44;
        }
        jj_consume_token(250);
        item = YieldItem();
returnItems.add( item );
      }
      break;
      }
    default:
      jj_la1[160] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ORDER:{
      orderToken = jj_consume_token(ORDER);
      jj_consume_token(BY);
      o = OrderItem();
orders.add( o );
      label_45:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case 250:{
          break;
          }
        default:
          jj_la1[161] = jj_gen;
          break label_45;
        }
        jj_consume_token(250);
        o = OrderItem();
orders.add( o );
      }
      break;
      }
    default:
      jj_la1[162] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SKIPROWS:{
      skipPosition = jj_consume_token(SKIPROWS);
      skip = SignedIntegerLiteral();
      break;
      }
    default:
      jj_la1[163] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LIMITROWS:{
      limitPosition = jj_consume_token(LIMITROWS);
      limit = SignedIntegerLiteral();
      break;
      }
    default:
      jj_la1[164] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      where = WhereClause();
      break;
      }
    default:
      jj_la1[165] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.yieldClause( pos( start ), returnAll, returnItems, pos( start.next ), orders, pos( orderToken ), skip, pos( skipPosition ), limit, pos( limitPosition ), where );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT ShowIndexesAllowBrief(Token start, USE_CLAUSE useClause, ShowCommandFilterTypes indexType) throws ParseException {// all and btree indexes
    List<CLAUSE> clauses = new ArrayList<>();
    if ( useClause != null )
    {
      clauses.add( useClause );
    }
    boolean brief = false;
    boolean verbose = false;
    WHERE where = null;
    YIELD yieldClause = null;
    RETURN_CLAUSE returnClause = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case INDEX:{
      jj_consume_token(INDEX);
      break;
      }
    case INDEXES:{
      jj_consume_token(INDEXES);
      break;
      }
    default:
      jj_la1[166] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case BRIEF:
    case VERBOSE:
    case WHERE:
    case YIELD:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case BRIEF:
      case VERBOSE:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case BRIEF:{
          jj_consume_token(BRIEF);
brief = true;
          break;
          }
        case VERBOSE:{
          jj_consume_token(VERBOSE);
verbose = true;
          break;
          }
        default:
          jj_la1[167] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case OUTPUT:{
          jj_consume_token(OUTPUT);
          break;
          }
        default:
          jj_la1[168] = jj_gen;
          ;
        }
        break;
        }
      case YIELD:{
        yieldClause = YieldClause();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case RETURN:{
          returnClause = ReturnClause();
          break;
          }
        default:
          jj_la1[169] = jj_gen;
          ;
        }
        break;
        }
      case WHERE:{
        where = WhereClause();
        break;
        }
      default:
        jj_la1[170] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[171] = jj_gen;
      ;
    }
if ( yieldClause != null )
        {
            clauses.add( astFactory.showIndexClause( pos( start ), indexType, brief, verbose, where, true ) );
            clauses.add( yieldClause );
            if ( returnClause != null )
            {
                clauses.add( returnClause );
            }
        }
        else
        {
            clauses.add( astFactory.showIndexClause( pos( start ), indexType, brief, verbose, where, false ) );
        }
        {if ("" != null) return astFactory.newSingleQuery( pos( start ), clauses );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT ShowIndexesNoBrief(Token start, USE_CLAUSE useClause, ShowCommandFilterTypes indexType) throws ParseException {// fulltext, text and lookup indexes
  List<CLAUSE> clauses = new ArrayList<>();
  if (useClause != null) {
      clauses.add( useClause );
  }
  WHERE where = null;
  YIELD yieldClause = null;
  RETURN_CLAUSE returnClause = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case INDEX:{
      jj_consume_token(INDEX);
      break;
      }
    case INDEXES:{
      jj_consume_token(INDEXES);
      break;
      }
    default:
      jj_la1[172] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:
    case YIELD:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case YIELD:{
        yieldClause = YieldClause();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case RETURN:{
          returnClause = ReturnClause();
          break;
          }
        default:
          jj_la1[173] = jj_gen;
          ;
        }
        break;
        }
      case WHERE:{
        where = WhereClause();
        break;
        }
      default:
        jj_la1[174] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[175] = jj_gen;
      ;
    }
if ( yieldClause != null )
        {
            clauses.add( astFactory.showIndexClause( pos( start ), indexType, false, false, where, true ) );
            clauses.add( yieldClause );
            if ( returnClause != null )
            {
                clauses.add( returnClause );
            }
        }
        else
        {
            clauses.add( astFactory.showIndexClause( pos( start ), indexType, false, false, where, false ) );
        }
        {if ("" != null) return astFactory.newSingleQuery( pos( start ), clauses );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT ShowConstraintsAllowBriefAndYield(Token start, USE_CLAUSE useClause, ShowCommandFilterTypes constraintType) throws ParseException {// all, node key, uniqueness and old valid existence constraints
    List<CLAUSE> clauses = new ArrayList<>();
    if ( useClause != null )
    {
        clauses.add( useClause );
    }
    boolean brief = false;
    boolean verbose = false;
    WHERE where = null;
    YIELD yieldClause = null;
    RETURN_CLAUSE returnClause = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case CONSTRAINT:{
      jj_consume_token(CONSTRAINT);
      break;
      }
    case CONSTRAINTS:{
      jj_consume_token(CONSTRAINTS);
      break;
      }
    default:
      jj_la1[176] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case BRIEF:
    case VERBOSE:
    case WHERE:
    case YIELD:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case BRIEF:
      case VERBOSE:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case BRIEF:{
          jj_consume_token(BRIEF);
brief = true;
          break;
          }
        case VERBOSE:{
          jj_consume_token(VERBOSE);
verbose = true;
          break;
          }
        default:
          jj_la1[177] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case OUTPUT:{
          jj_consume_token(OUTPUT);
          break;
          }
        default:
          jj_la1[178] = jj_gen;
          ;
        }
        break;
        }
      case YIELD:{
        yieldClause = YieldClause();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case RETURN:{
          returnClause = ReturnClause();
          break;
          }
        default:
          jj_la1[179] = jj_gen;
          ;
        }
        break;
        }
      case WHERE:{
        where = WhereClause();
        break;
        }
      default:
        jj_la1[180] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[181] = jj_gen;
      ;
    }
if ( yieldClause != null )
        {
            clauses.add( astFactory.showConstraintClause( pos( start ), constraintType, brief, verbose, where, true ) );
            clauses.add( yieldClause );
            if ( returnClause != null )
            {
                clauses.add( returnClause );
            }
        }
        else
        {
            clauses.add( astFactory.showConstraintClause( pos( start ), constraintType, brief, verbose, where, false ) );
        }
        {if ("" != null) return astFactory.newSingleQuery( pos( start ), clauses );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT ShowConstraintsAllowBrief(Token start, USE_CLAUSE useClause, ShowCommandFilterTypes constraintType) throws ParseException {// old deprecated existence constraints
    List<CLAUSE> clauses = new ArrayList<>();
    if ( useClause != null )
    {
        clauses.add( useClause );
    }
    boolean brief = false;
    boolean verbose = false;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case CONSTRAINT:{
      jj_consume_token(CONSTRAINT);
      break;
      }
    case CONSTRAINTS:{
      jj_consume_token(CONSTRAINTS);
      break;
      }
    default:
      jj_la1[182] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case BRIEF:
    case VERBOSE:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case BRIEF:{
        jj_consume_token(BRIEF);
brief = true;
        break;
        }
      case VERBOSE:{
        jj_consume_token(VERBOSE);
verbose = true;
        break;
        }
      default:
        jj_la1[183] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case OUTPUT:{
        jj_consume_token(OUTPUT);
        break;
        }
      default:
        jj_la1[184] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[185] = jj_gen;
      ;
    }
clauses.add( astFactory.showConstraintClause( pos( start ), constraintType, brief, verbose, null, false ) );
        {if ("" != null) return astFactory.newSingleQuery( pos( start ), clauses );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT ShowConstraintsAllowYield(Token start, USE_CLAUSE useClause, ShowCommandFilterTypes constraintType) throws ParseException {// new existence constraints
    List<CLAUSE> clauses = new ArrayList<>();
    if (useClause != null)
    {
        clauses.add( useClause );
    }
    WHERE where = null;
    YIELD yieldClause = null;
    RETURN_CLAUSE returnClause = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case CONSTRAINT:{
      jj_consume_token(CONSTRAINT);
      break;
      }
    case CONSTRAINTS:{
      jj_consume_token(CONSTRAINTS);
      break;
      }
    default:
      jj_la1[186] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:
    case YIELD:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case YIELD:{
        yieldClause = YieldClause();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case RETURN:{
          returnClause = ReturnClause();
          break;
          }
        default:
          jj_la1[187] = jj_gen;
          ;
        }
        break;
        }
      case WHERE:{
        where = WhereClause();
        break;
        }
      default:
        jj_la1[188] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[189] = jj_gen;
      ;
    }
if ( yieldClause != null )
        {
            clauses.add( astFactory.showConstraintClause( pos( start ), constraintType, false, false, where, true ) );
            clauses.add( yieldClause );
            if ( returnClause != null )
            {
                clauses.add( returnClause );
            }
        }
        else
        {
            clauses.add( astFactory.showConstraintClause( pos( start ), constraintType, false, false, where, false ) );
        }
        {if ("" != null) return astFactory.newSingleQuery( pos( start ), clauses );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT ShowProcedures(Token start, USE_CLAUSE useClause) throws ParseException {List<CLAUSE> clauses = new ArrayList<>();
    if (useClause != null)
    {
        clauses.add( useClause );
    }

    boolean currentUser = false;
    Token userToken = null;
    String user = null;

    WHERE where = null;
    YIELD yieldClause = null;
    RETURN_CLAUSE returnClause = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case PROCEDURE:{
      jj_consume_token(PROCEDURE);
      break;
      }
    case PROCEDURES:{
      jj_consume_token(PROCEDURES);
      break;
      }
    default:
      jj_la1[190] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case EXECUTABLE:{
      jj_consume_token(EXECUTABLE);
currentUser = true;
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case BY:{
        jj_consume_token(BY);
        if (jj_2_52(2147483647)) {
          jj_consume_token(CURRENT);
          jj_consume_token(USER);
currentUser = true;
        } else {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case ESCAPED_SYMBOLIC_NAME:
          case ACCESS:
          case ACTIVE:
          case ALIAS:
          case ALIASES:
          case ALL_SHORTEST_PATH:
          case ALL:
          case ALTER:
          case AND:
          case ANY:
          case AS:
          case ASC:
          case ASSERT:
          case ASSIGN:
          case AT:
          case BRIEF:
          case BTREE:
          case BUILT:
          case BY:
          case CALL:
          case CASE:
          case CATALOG:
          case CHANGE:
          case COMMIT:
          case CONSTRAINT:
          case CONSTRAINTS:
          case CONTAINS:
          case COPY:
          case COUNT:
          case CREATE:
          case CSV:
          case CURRENT:
          case DATA:
          case DATABASE:
          case DATABASES:
          case DBMS:
          case DEFAULT_TOKEN:
          case DEFINED:
          case DELETE:
          case DENY:
          case DESC:
          case DESTROY:
          case DETACH:
          case DISTINCT:
          case DRIVER:
          case DROP:
          case DUMP:
          case EACH:
          case ELEMENT:
          case ELEMENTS:
          case ELSE:
          case ENCRYPTED:
          case END:
          case ENDS:
          case EXECUTABLE:
          case EXIST:
          case EXISTENCE:
          case EXISTS:
          case EXTRACT:
          case FALSE:
          case FIELDTERMINATOR:
          case FILTER:
          case FOR:
          case FOREACH:
          case FROM:
          case FULLTEXT:
          case FUNCTION:
          case FUNCTIONS:
          case GRANT:
          case GRAPH:
          case GRAPHS:
          case HEADERS:
          case HOME:
          case IF:
          case IN:
          case INDEX:
          case INDEXES:
          case IS:
          case JOIN:
          case KEY:
          case LABEL:
          case LABELS:
          case LIMITROWS:
          case LOAD:
          case LOOKUP:
          case MANAGEMENT:
          case MATCH:
          case MERGE:
          case NAME:
          case NAMES:
          case NEW:
          case NODE:
          case NODES:
          case NONE:
          case NOT:
          case NOWAIT:
          case NULL:
          case OF:
          case ON:
          case ONLY:
          case OPTIONAL:
          case OPTIONS:
          case OR:
          case ORDER:
          case OUTPUT:
          case PASSWORD:
          case PASSWORDS:
          case PERIODIC:
          case PLAINTEXT:
          case POINT:
          case POPULATED:
          case PRIVILEGE:
          case PRIVILEGES:
          case PROCEDURE:
          case PROCEDURES:
          case PROPERTY:
          case RANGE:
          case READ:
          case REDUCE:
          case RENAME:
          case REL:
          case RELATIONSHIP:
          case RELATIONSHIPS:
          case REMOVE:
          case REPLACE:
          case REQUIRE:
          case REQUIRED:
          case RETURN:
          case REVOKE:
          case ROLE:
          case ROLES:
          case ROW:
          case ROWS:
          case SCAN:
          case SEC:
          case SECOND:
          case SECONDS:
          case SEEK:
          case SET:
          case SHORTEST_PATH:
          case SHOW:
          case SINGLE:
          case SKIPROWS:
          case START:
          case STARTS:
          case STATUS:
          case STOP:
          case SUSPENDED:
          case TARGET:
          case TERMINATE:
          case TEXT:
          case THEN:
          case TO:
          case TRANSACTION:
          case TRANSACTIONS:
          case TRAVERSE:
          case TRUE:
          case TYPE:
          case TYPES:
          case UNION:
          case UNIQUE:
          case UNWIND:
          case USE:
          case USER:
          case USERS:
          case USING:
          case VERBOSE:
          case WAIT:
          case WHEN:
          case WHERE:
          case WITH:
          case WRITE:
          case XOR:
          case YIELD:
          case IDENTIFIER:{
            userToken = SymbolicNameString();
user = userToken.image; currentUser = false;
            break;
            }
          default:
            jj_la1[191] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      default:
        jj_la1[192] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[193] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:
    case YIELD:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case YIELD:{
        yieldClause = YieldClause();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case RETURN:{
          returnClause = ReturnClause();
          break;
          }
        default:
          jj_la1[194] = jj_gen;
          ;
        }
        break;
        }
      case WHERE:{
        where = WhereClause();
        break;
        }
      default:
        jj_la1[195] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[196] = jj_gen;
      ;
    }
if ( yieldClause != null )
        {
            clauses.add( astFactory.showProcedureClause( pos( start ), currentUser, user, where, true ) );
            clauses.add( yieldClause );
            if ( returnClause != null )
            {
                clauses.add( returnClause );
            }
        }
        else
        {
            clauses.add( astFactory.showProcedureClause( pos( start ), currentUser, user, where, false ) );
        }
        {if ("" != null) return astFactory.newSingleQuery( pos( start ), clauses );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT ShowFunctions(Token start, USE_CLAUSE useClause, ShowCommandFilterTypes functionType) throws ParseException {List<CLAUSE> clauses = new ArrayList<>();
    if (useClause != null)
    {
        clauses.add( useClause );
    }

    boolean currentUser = false;
    Token userToken = null;
    String user = null;

    WHERE where = null;
    YIELD yieldClause = null;
    RETURN_CLAUSE returnClause = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case FUNCTION:{
      jj_consume_token(FUNCTION);
      break;
      }
    case FUNCTIONS:{
      jj_consume_token(FUNCTIONS);
      break;
      }
    default:
      jj_la1[197] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case EXECUTABLE:{
      jj_consume_token(EXECUTABLE);
currentUser = true;
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case BY:{
        jj_consume_token(BY);
        if (jj_2_53(2147483647)) {
          jj_consume_token(CURRENT);
          jj_consume_token(USER);
currentUser = true;
        } else {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case ESCAPED_SYMBOLIC_NAME:
          case ACCESS:
          case ACTIVE:
          case ALIAS:
          case ALIASES:
          case ALL_SHORTEST_PATH:
          case ALL:
          case ALTER:
          case AND:
          case ANY:
          case AS:
          case ASC:
          case ASSERT:
          case ASSIGN:
          case AT:
          case BRIEF:
          case BTREE:
          case BUILT:
          case BY:
          case CALL:
          case CASE:
          case CATALOG:
          case CHANGE:
          case COMMIT:
          case CONSTRAINT:
          case CONSTRAINTS:
          case CONTAINS:
          case COPY:
          case COUNT:
          case CREATE:
          case CSV:
          case CURRENT:
          case DATA:
          case DATABASE:
          case DATABASES:
          case DBMS:
          case DEFAULT_TOKEN:
          case DEFINED:
          case DELETE:
          case DENY:
          case DESC:
          case DESTROY:
          case DETACH:
          case DISTINCT:
          case DRIVER:
          case DROP:
          case DUMP:
          case EACH:
          case ELEMENT:
          case ELEMENTS:
          case ELSE:
          case ENCRYPTED:
          case END:
          case ENDS:
          case EXECUTABLE:
          case EXIST:
          case EXISTENCE:
          case EXISTS:
          case EXTRACT:
          case FALSE:
          case FIELDTERMINATOR:
          case FILTER:
          case FOR:
          case FOREACH:
          case FROM:
          case FULLTEXT:
          case FUNCTION:
          case FUNCTIONS:
          case GRANT:
          case GRAPH:
          case GRAPHS:
          case HEADERS:
          case HOME:
          case IF:
          case IN:
          case INDEX:
          case INDEXES:
          case IS:
          case JOIN:
          case KEY:
          case LABEL:
          case LABELS:
          case LIMITROWS:
          case LOAD:
          case LOOKUP:
          case MANAGEMENT:
          case MATCH:
          case MERGE:
          case NAME:
          case NAMES:
          case NEW:
          case NODE:
          case NODES:
          case NONE:
          case NOT:
          case NOWAIT:
          case NULL:
          case OF:
          case ON:
          case ONLY:
          case OPTIONAL:
          case OPTIONS:
          case OR:
          case ORDER:
          case OUTPUT:
          case PASSWORD:
          case PASSWORDS:
          case PERIODIC:
          case PLAINTEXT:
          case POINT:
          case POPULATED:
          case PRIVILEGE:
          case PRIVILEGES:
          case PROCEDURE:
          case PROCEDURES:
          case PROPERTY:
          case RANGE:
          case READ:
          case REDUCE:
          case RENAME:
          case REL:
          case RELATIONSHIP:
          case RELATIONSHIPS:
          case REMOVE:
          case REPLACE:
          case REQUIRE:
          case REQUIRED:
          case RETURN:
          case REVOKE:
          case ROLE:
          case ROLES:
          case ROW:
          case ROWS:
          case SCAN:
          case SEC:
          case SECOND:
          case SECONDS:
          case SEEK:
          case SET:
          case SHORTEST_PATH:
          case SHOW:
          case SINGLE:
          case SKIPROWS:
          case START:
          case STARTS:
          case STATUS:
          case STOP:
          case SUSPENDED:
          case TARGET:
          case TERMINATE:
          case TEXT:
          case THEN:
          case TO:
          case TRANSACTION:
          case TRANSACTIONS:
          case TRAVERSE:
          case TRUE:
          case TYPE:
          case TYPES:
          case UNION:
          case UNIQUE:
          case UNWIND:
          case USE:
          case USER:
          case USERS:
          case USING:
          case VERBOSE:
          case WAIT:
          case WHEN:
          case WHERE:
          case WITH:
          case WRITE:
          case XOR:
          case YIELD:
          case IDENTIFIER:{
            userToken = SymbolicNameString();
user = userToken.image; currentUser = false;
            break;
            }
          default:
            jj_la1[198] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      default:
        jj_la1[199] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[200] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:
    case YIELD:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case YIELD:{
        yieldClause = YieldClause();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case RETURN:{
          returnClause = ReturnClause();
          break;
          }
        default:
          jj_la1[201] = jj_gen;
          ;
        }
        break;
        }
      case WHERE:{
        where = WhereClause();
        break;
        }
      default:
        jj_la1[202] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[203] = jj_gen;
      ;
    }
if ( yieldClause != null )
        {
            clauses.add( astFactory.showFunctionClause( pos( start ), functionType, currentUser, user, where, true ) );
            clauses.add( yieldClause );
            if ( returnClause != null )
            {
                clauses.add( returnClause );
            }
        }
        else
        {
            clauses.add( astFactory.showFunctionClause( pos( start ), functionType, currentUser, user, where, false ) );
        }
        {if ("" != null) return astFactory.newSingleQuery( pos( start ), clauses );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT ShowTransactions(Token start, USE_CLAUSE useClause) throws ParseException {List<CLAUSE> clauses = new ArrayList<>();
    if (useClause != null)
    {
        clauses.add( useClause );
    }

    List<String> ids = new ArrayList<>();
    PARAMETER param = null;
    SimpleEither<List<String>, PARAMETER> idEither = SimpleEither.left(ids);

    WHERE where = null;
    YIELD yieldClause = null;
    RETURN_CLAUSE returnClause = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case TRANSACTION:{
      jj_consume_token(TRANSACTION);
      break;
      }
    case TRANSACTIONS:{
      jj_consume_token(TRANSACTIONS);
      break;
      }
    default:
      jj_la1[204] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case DOLLAR:
    case WHERE:
    case YIELD:{
      if (jj_2_54(2147483647)) {
        yieldClause = YieldClause();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case RETURN:{
          returnClause = ReturnClause();
          break;
          }
        default:
          jj_la1[205] = jj_gen;
          ;
        }
      } else if (jj_2_55(2147483647)) {
        where = WhereClause();
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case STRING_LITERAL1:
        case STRING_LITERAL2:
        case DOLLAR:{
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case STRING_LITERAL1:
          case STRING_LITERAL2:{
            ids = TransactionIdStringList();
idEither=SimpleEither.left(ids);
            break;
            }
          case DOLLAR:{
            param = Parameter(ParameterType.ANY);
idEither=SimpleEither.right(param);
            break;
            }
          default:
            jj_la1[206] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case WHERE:
          case YIELD:{
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case YIELD:{
              yieldClause = YieldClause();
              switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
              case RETURN:{
                returnClause = ReturnClause();
                break;
                }
              default:
                jj_la1[207] = jj_gen;
                ;
              }
              break;
              }
            case WHERE:{
              where = WhereClause();
              break;
              }
            default:
              jj_la1[208] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
            }
          default:
            jj_la1[209] = jj_gen;
            ;
          }
          break;
          }
        default:
          jj_la1[210] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[211] = jj_gen;
      ;
    }
if ( yieldClause != null )
        {
            clauses.add( astFactory.showTransactionsClause( pos( start ), idEither,  where, true ) );
            clauses.add( yieldClause );
            if ( returnClause != null )
            {
                clauses.add( returnClause );
            }
        }
        else
        {
            clauses.add( astFactory.showTransactionsClause( pos( start ), idEither, where, false ) );
        }
        {if ("" != null) return astFactory.newSingleQuery( pos( start ), clauses );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT TerminateTransactions(Token start, USE_CLAUSE useClause) throws ParseException {List<CLAUSE> clauses = new ArrayList<>();
    if (useClause != null)
    {
        clauses.add( useClause );
    }

    List<String> ids = new ArrayList<>();
    PARAMETER param = null;
    SimpleEither<List<String>, PARAMETER> idEither = SimpleEither.left(ids);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case TRANSACTION:{
      jj_consume_token(TRANSACTION);
      break;
      }
    case TRANSACTIONS:{
      jj_consume_token(TRANSACTIONS);
      break;
      }
    default:
      jj_la1[212] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case DOLLAR:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case STRING_LITERAL1:
      case STRING_LITERAL2:{
        ids = TransactionIdStringList();
idEither=SimpleEither.left(ids);
        break;
        }
      case DOLLAR:{
        param = Parameter(ParameterType.ANY);
idEither=SimpleEither.right(param);
        break;
        }
      default:
        jj_la1[213] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[214] = jj_gen;
      ;
    }
clauses.add( astFactory.terminateTransactionsClause( pos( start ), idEither ) );
        {if ("" != null) return astFactory.newSingleQuery( pos( start ), clauses );}
    throw new IllegalStateException ("Missing return statement in function");
}

// Schema commands
// Constraint commands
  final public 
SCHEMA_COMMAND CreateConstraint(Token start, boolean replace) throws ParseException, Exception {String name = null;
    boolean ifNotExists = false;
    Token label;
    VARIABLE variable = null;
    List<PROPERTY> properties= new ArrayList<>();
    SimpleEither<Map<String, EXPRESSION>, PARAMETER> options = null;
    ConstraintType constraintType = ConstraintType.NODE_EXISTS;
    boolean isNode = false;
    Token errorStart;
    boolean containsOn = true;
    ConstraintVersion constraintVersion = ConstraintVersion.CONSTRAINT_VERSION_0;
    jj_consume_token(CONSTRAINT);
    if (jj_2_57(2147483647)) {
      jj_consume_token(ON);
      jj_consume_token(LPAREN);
    } else if (jj_2_58(2147483647)) {
      jj_consume_token(FOR);
      jj_consume_token(LPAREN);
containsOn = false;
    } else if (jj_2_59(2147483647)) {
      jj_consume_token(IF);
      jj_consume_token(NOT);
      jj_consume_token(EXISTS);
ifNotExists = true;
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ON:{
        jj_consume_token(ON);
        break;
        }
      case FOR:{
        jj_consume_token(FOR);
containsOn = false;
        break;
        }
      default:
        jj_la1[215] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(LPAREN);
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case AS:
      case ASC:
      case ASSERT:
      case ASSIGN:
      case AT:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASE:
      case CATALOG:
      case CHANGE:
      case COMMIT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DBMS:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESTROY:
      case DETACH:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DUMP:
      case EACH:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case EXTRACT:
      case FALSE:
      case FIELDTERMINATOR:
      case FILTER:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case HEADERS:
      case HOME:
      case IF:
      case IN:
      case INDEX:
      case INDEXES:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LIMITROWS:
      case LOAD:
      case LOOKUP:
      case MANAGEMENT:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NEW:
      case NODE:
      case NODES:
      case NONE:
      case NOT:
      case NOWAIT:
      case NULL:
      case OF:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTY:
      case RANGE:
      case READ:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REQUIRE:
      case REQUIRED:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDS:
      case SEEK:
      case SET:
      case SHORTEST_PATH:
      case SHOW:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TO:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRUE:
      case TYPE:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNWIND:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VERBOSE:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WRITE:
      case XOR:
      case YIELD:
      case IDENTIFIER:{
        if (jj_2_56(2)) {
          SymbolicNameString();
name = token.image;
        } else {
          ;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IF:{
          jj_consume_token(IF);
          jj_consume_token(NOT);
          jj_consume_token(EXISTS);
ifNotExists = true;
          break;
          }
        default:
          jj_la1[216] = jj_gen;
          ;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ON:{
          jj_consume_token(ON);
          break;
          }
        case FOR:{
          jj_consume_token(FOR);
containsOn = false;
          break;
          }
        default:
          jj_la1[217] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(LPAREN);
        break;
        }
      default:
        jj_la1[218] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case AS:
    case ASC:
    case ASSERT:
    case ASSIGN:
    case AT:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASE:
    case CATALOG:
    case CHANGE:
    case COMMIT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DBMS:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESTROY:
    case DETACH:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DUMP:
    case EACH:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case EXTRACT:
    case FALSE:
    case FIELDTERMINATOR:
    case FILTER:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case HEADERS:
    case HOME:
    case IF:
    case IN:
    case INDEX:
    case INDEXES:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LIMITROWS:
    case LOAD:
    case LOOKUP:
    case MANAGEMENT:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NEW:
    case NODE:
    case NODES:
    case NONE:
    case NOT:
    case NOWAIT:
    case NULL:
    case OF:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTY:
    case RANGE:
    case READ:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REQUIRE:
    case REQUIRED:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDS:
    case SEEK:
    case SET:
    case SHORTEST_PATH:
    case SHOW:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TO:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRUE:
    case TYPE:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNWIND:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VERBOSE:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WRITE:
    case XOR:
    case YIELD:
    case IDENTIFIER:{
      //(variable:LABEL)
              variable = Variable();
      label = LabelOrRelType();
      jj_consume_token(RPAREN);
isNode = true;
      break;
      }
    case RPAREN:{
      jj_consume_token(RPAREN);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LT:
      case ARROW_LEFT_HEAD:{
        LeftArrow();
        break;
        }
      default:
        jj_la1[219] = jj_gen;
        ;
      }
      ArrowLine();
      jj_consume_token(LBRACKET);
      variable = Variable();
      label = LabelOrRelType();
      jj_consume_token(RBRACKET);
      ArrowLine();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case GT:
      case ARROW_RIGHT_HEAD:{
        RightArrow();
        break;
        }
      default:
        jj_la1[220] = jj_gen;
        ;
      }
      jj_consume_token(LPAREN);
      jj_consume_token(RPAREN);
      break;
      }
    default:
      jj_la1[221] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (jj_2_60(2147483647)) {
      jj_consume_token(ASSERT);
constraintVersion = ConstraintVersion.CONSTRAINT_VERSION_0;
      errorStart = jj_consume_token(EXISTS);
constraintType = isNode ? ConstraintType.NODE_EXISTS : ConstraintType.REL_EXISTS;
      properties = PropertyList();
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ASSERT:
      case REQUIRE:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case REQUIRE:{
          jj_consume_token(REQUIRE);
constraintVersion = ConstraintVersion.CONSTRAINT_VERSION_2;
          break;
          }
        case ASSERT:{
          jj_consume_token(ASSERT);
constraintVersion = ConstraintVersion.CONSTRAINT_VERSION_0;
          break;
          }
        default:
          jj_la1[222] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        properties = PropertyList();
        errorStart = jj_consume_token(IS);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case UNIQUE:{
          jj_consume_token(UNIQUE);
// CREATE CONSTRAINT ON (variable:LABEL) ASSERT variable.prop IS UNIQUE
                        // CREATE CONSTRAINT FOR (variable:LABEL) REQUIRE variable.prop IS UNIQUE
                        constraintType = ConstraintType.UNIQUE ;
                        if ( !isNode )
                        {
                            throw exceptionFactory.syntaxException(
                                new ParseException( ASTExceptionFactory.relationshipPattternNotAllowed( constraintType ) ),
                                errorStart.beginOffset, errorStart.beginLine, errorStart.beginColumn );
                        }
          break;
          }
        case NODE:{
          jj_consume_token(NODE);
          jj_consume_token(KEY);
// CREATE CONSTRAINT ON (variable:LABEL) ASSERT variable.prop IS NODE KEY
                        // CREATE CONSTRAINT FOR (variable:LABEL) REQUIRE variable.prop IS NODE KEY
                        constraintType = ConstraintType.NODE_KEY;
                        if ( !isNode )
                        {
                            throw exceptionFactory.syntaxException(
                                new ParseException( ASTExceptionFactory.relationshipPattternNotAllowed( constraintType ) ),
                                errorStart.beginOffset, errorStart.beginLine, errorStart.beginColumn );
                        }
          break;
          }
        case NOT:{
          jj_consume_token(NOT);
          jj_consume_token(NULL);
// CREATE CONSTRAINT ON (variable:LABEL) ASSERT variable.prop IS NOT NULL
                    // CREATE CONSTRAINT FOR (variable:LABEL) REQUIRE variable.prop IS NOT NULL
                    constraintType = isNode ? ConstraintType.NODE_IS_NOT_NULL : ConstraintType.REL_IS_NOT_NULL;
                    if (constraintVersion == ConstraintVersion.CONSTRAINT_VERSION_0)
                    {
                        constraintVersion = ConstraintVersion.CONSTRAINT_VERSION_1;
                    }
          break;
          }
        default:
          jj_la1[223] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[224] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case OPTIONS:{
      jj_consume_token(OPTIONS);
      options = MapOrParameter();
      break;
      }
    default:
      jj_la1[225] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.createConstraint( pos( start ), constraintType, replace, ifNotExists, name, variable,
        new StringPos<POS>( label.image, pos( label ) ), properties, options, containsOn, constraintVersion );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SCHEMA_COMMAND DropConstraint(Token start) throws ParseException, Exception {Token name = null;
        boolean ifExists = false;
        VARIABLE variable = null;
        Token label = null;
        List<PROPERTY> properties= new ArrayList<>();
        ConstraintType constraintType = ConstraintType.NODE_EXISTS;
        boolean isNode = false;
        Token errorStart;
    jj_consume_token(CONSTRAINT);
    if (jj_2_62(2147483647)) {
      jj_consume_token(ON);
      jj_consume_token(LPAREN);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case AS:
      case ASC:
      case ASSERT:
      case ASSIGN:
      case AT:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASE:
      case CATALOG:
      case CHANGE:
      case COMMIT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DBMS:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESTROY:
      case DETACH:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DUMP:
      case EACH:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case EXTRACT:
      case FALSE:
      case FIELDTERMINATOR:
      case FILTER:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case HEADERS:
      case HOME:
      case IF:
      case IN:
      case INDEX:
      case INDEXES:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LIMITROWS:
      case LOAD:
      case LOOKUP:
      case MANAGEMENT:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NEW:
      case NODE:
      case NODES:
      case NONE:
      case NOT:
      case NOWAIT:
      case NULL:
      case OF:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTY:
      case RANGE:
      case READ:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REQUIRE:
      case REQUIRED:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDS:
      case SEEK:
      case SET:
      case SHORTEST_PATH:
      case SHOW:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TO:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRUE:
      case TYPE:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNWIND:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VERBOSE:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WRITE:
      case XOR:
      case YIELD:
      case IDENTIFIER:{
        //(n:LABEL)
                    variable = Variable();
        label = LabelOrRelType();
        jj_consume_token(RPAREN);
isNode = true;
        break;
        }
      case RPAREN:{
        jj_consume_token(RPAREN);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case LT:
        case ARROW_LEFT_HEAD:{
          LeftArrow();
          break;
          }
        default:
          jj_la1[226] = jj_gen;
          ;
        }
        ArrowLine();
        jj_consume_token(LBRACKET);
        variable = Variable();
        label = LabelOrRelType();
        jj_consume_token(RBRACKET);
        ArrowLine();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case GT:
        case ARROW_RIGHT_HEAD:{
          RightArrow();
          break;
          }
        default:
          jj_la1[227] = jj_gen;
          ;
        }
        jj_consume_token(LPAREN);
        jj_consume_token(RPAREN);
        break;
        }
      default:
        jj_la1[228] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(ASSERT);
      if (jj_2_61(2147483647)) {
        errorStart = jj_consume_token(EXISTS);
constraintType = isNode ? ConstraintType.NODE_EXISTS : ConstraintType.REL_EXISTS;
        properties = PropertyList();
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ESCAPED_SYMBOLIC_NAME:
        case ACCESS:
        case ACTIVE:
        case ALIAS:
        case ALIASES:
        case ALL_SHORTEST_PATH:
        case ALL:
        case ALTER:
        case AND:
        case ANY:
        case AS:
        case ASC:
        case ASSERT:
        case ASSIGN:
        case AT:
        case BRIEF:
        case BTREE:
        case BUILT:
        case BY:
        case CALL:
        case CASE:
        case CATALOG:
        case CHANGE:
        case COMMIT:
        case CONSTRAINT:
        case CONSTRAINTS:
        case CONTAINS:
        case COPY:
        case COUNT:
        case CREATE:
        case CSV:
        case CURRENT:
        case DATA:
        case DATABASE:
        case DATABASES:
        case DBMS:
        case DEFAULT_TOKEN:
        case DEFINED:
        case DELETE:
        case DENY:
        case DESC:
        case DESTROY:
        case DETACH:
        case DISTINCT:
        case DRIVER:
        case DROP:
        case DUMP:
        case EACH:
        case ELEMENT:
        case ELEMENTS:
        case ELSE:
        case ENCRYPTED:
        case END:
        case ENDS:
        case EXECUTABLE:
        case EXIST:
        case EXISTENCE:
        case EXISTS:
        case EXTRACT:
        case FALSE:
        case FIELDTERMINATOR:
        case FILTER:
        case FOR:
        case FOREACH:
        case FROM:
        case FULLTEXT:
        case FUNCTION:
        case FUNCTIONS:
        case GRANT:
        case GRAPH:
        case GRAPHS:
        case HEADERS:
        case HOME:
        case IF:
        case IN:
        case INDEX:
        case INDEXES:
        case IS:
        case JOIN:
        case KEY:
        case LABEL:
        case LABELS:
        case LIMITROWS:
        case LOAD:
        case LOOKUP:
        case LPAREN:
        case MANAGEMENT:
        case MATCH:
        case MERGE:
        case NAME:
        case NAMES:
        case NEW:
        case NODE:
        case NODES:
        case NONE:
        case NOT:
        case NOWAIT:
        case NULL:
        case OF:
        case ON:
        case ONLY:
        case OPTIONAL:
        case OPTIONS:
        case OR:
        case ORDER:
        case OUTPUT:
        case PASSWORD:
        case PASSWORDS:
        case PERIODIC:
        case PLAINTEXT:
        case POINT:
        case POPULATED:
        case PRIVILEGE:
        case PRIVILEGES:
        case PROCEDURE:
        case PROCEDURES:
        case PROPERTY:
        case RANGE:
        case READ:
        case REDUCE:
        case RENAME:
        case REL:
        case RELATIONSHIP:
        case RELATIONSHIPS:
        case REMOVE:
        case REPLACE:
        case REQUIRE:
        case REQUIRED:
        case RETURN:
        case REVOKE:
        case ROLE:
        case ROLES:
        case ROW:
        case ROWS:
        case SCAN:
        case SEC:
        case SECOND:
        case SECONDS:
        case SEEK:
        case SET:
        case SHORTEST_PATH:
        case SHOW:
        case SINGLE:
        case SKIPROWS:
        case START:
        case STARTS:
        case STATUS:
        case STOP:
        case SUSPENDED:
        case TARGET:
        case TERMINATE:
        case TEXT:
        case THEN:
        case TO:
        case TRANSACTION:
        case TRANSACTIONS:
        case TRAVERSE:
        case TRUE:
        case TYPE:
        case TYPES:
        case UNION:
        case UNIQUE:
        case UNWIND:
        case USE:
        case USER:
        case USERS:
        case USING:
        case VERBOSE:
        case WAIT:
        case WHEN:
        case WHERE:
        case WITH:
        case WRITE:
        case XOR:
        case YIELD:
        case IDENTIFIER:{
          properties = PropertyList();
          errorStart = jj_consume_token(IS);
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case UNIQUE:{
            jj_consume_token(UNIQUE);
constraintType = ConstraintType.UNIQUE;
                          if ( !isNode )
                          {
                              throw exceptionFactory.syntaxException(
                                  new ParseException( ASTExceptionFactory.relationshipPattternNotAllowed( constraintType ) ),
                                  errorStart.beginOffset, errorStart.beginLine, errorStart.beginColumn );
                          }
            break;
            }
          case NODE:{
            jj_consume_token(NODE);
            jj_consume_token(KEY);
constraintType = ConstraintType.NODE_KEY ;
                          if ( !isNode )
                          {
                              throw exceptionFactory.syntaxException(
                                  new ParseException( ASTExceptionFactory.relationshipPattternNotAllowed( constraintType ) ),
                                  errorStart.beginOffset, errorStart.beginLine, errorStart.beginColumn );
                          }
            break;
            }
          case NOT:{
            jj_consume_token(NOT);
            jj_consume_token(NULL);
constraintType = isNode ? ConstraintType.NODE_IS_NOT_NULL : ConstraintType.REL_IS_NOT_NULL;
            break;
            }
          default:
            jj_la1[229] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[230] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
{if ("" != null) return astFactory.dropConstraint( pos( start ), constraintType, variable, new StringPos<POS>( label.image, pos( label ) ),
                properties );}
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case AS:
      case ASC:
      case ASSERT:
      case ASSIGN:
      case AT:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASE:
      case CATALOG:
      case CHANGE:
      case COMMIT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DBMS:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESTROY:
      case DETACH:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DUMP:
      case EACH:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case EXTRACT:
      case FALSE:
      case FIELDTERMINATOR:
      case FILTER:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case HEADERS:
      case HOME:
      case IF:
      case IN:
      case INDEX:
      case INDEXES:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LIMITROWS:
      case LOAD:
      case LOOKUP:
      case MANAGEMENT:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NEW:
      case NODE:
      case NODES:
      case NONE:
      case NOT:
      case NOWAIT:
      case NULL:
      case OF:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTY:
      case RANGE:
      case READ:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REQUIRE:
      case REQUIRED:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDS:
      case SEEK:
      case SET:
      case SHORTEST_PATH:
      case SHOW:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TO:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRUE:
      case TYPE:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNWIND:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VERBOSE:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WRITE:
      case XOR:
      case YIELD:
      case IDENTIFIER:{
        //DROP CONSTRAINT name IF EXISTS
                name = SymbolicNameString();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IF:{
          jj_consume_token(IF);
          jj_consume_token(EXISTS);
ifExists = true;
          break;
          }
        default:
          jj_la1[231] = jj_gen;
          ;
        }
{if ("" != null) return astFactory.dropConstraint( pos( start ), name.image, ifExists );}
        break;
        }
      default:
        jj_la1[232] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new IllegalStateException ("Missing return statement in function");
}

// Index commands
  final public 
SCHEMA_COMMAND CreateIndex(Token start, boolean replace) throws ParseException, Exception {SCHEMA_COMMAND command = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case BTREE:{
      jj_consume_token(BTREE);
      jj_consume_token(INDEX);
      command = createIndex(start, replace, CreateIndexTypes.BTREE);
      break;
      }
    case RANGE:{
      jj_consume_token(RANGE);
      jj_consume_token(INDEX);
      command = createIndex(start, replace, CreateIndexTypes.RANGE);
      break;
      }
    case FULLTEXT:{
      jj_consume_token(FULLTEXT);
      jj_consume_token(INDEX);
      command = createFulltextIndex(start, replace);
      break;
      }
    case TEXT:{
      jj_consume_token(TEXT);
      jj_consume_token(INDEX);
      command = createIndex(start, replace, CreateIndexTypes.TEXT);
      break;
      }
    case POINT:{
      jj_consume_token(POINT);
      jj_consume_token(INDEX);
      command = createIndex(start, replace, CreateIndexTypes.POINT);
      break;
      }
    case LOOKUP:{
      jj_consume_token(LOOKUP);
      jj_consume_token(INDEX);
      command = createLookupIndex(start, replace);
      break;
      }
    case INDEX:{
      jj_consume_token(INDEX);
      if (jj_2_63(2147483647)) {
        jj_consume_token(ON);
        command = oldCreateIndex(start, replace);
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ESCAPED_SYMBOLIC_NAME:
        case ACCESS:
        case ACTIVE:
        case ALIAS:
        case ALIASES:
        case ALL_SHORTEST_PATH:
        case ALL:
        case ALTER:
        case AND:
        case ANY:
        case AS:
        case ASC:
        case ASSERT:
        case ASSIGN:
        case AT:
        case BRIEF:
        case BTREE:
        case BUILT:
        case BY:
        case CALL:
        case CASE:
        case CATALOG:
        case CHANGE:
        case COMMIT:
        case CONSTRAINT:
        case CONSTRAINTS:
        case CONTAINS:
        case COPY:
        case COUNT:
        case CREATE:
        case CSV:
        case CURRENT:
        case DATA:
        case DATABASE:
        case DATABASES:
        case DBMS:
        case DEFAULT_TOKEN:
        case DEFINED:
        case DELETE:
        case DENY:
        case DESC:
        case DESTROY:
        case DETACH:
        case DISTINCT:
        case DRIVER:
        case DROP:
        case DUMP:
        case EACH:
        case ELEMENT:
        case ELEMENTS:
        case ELSE:
        case ENCRYPTED:
        case END:
        case ENDS:
        case EXECUTABLE:
        case EXIST:
        case EXISTENCE:
        case EXISTS:
        case EXTRACT:
        case FALSE:
        case FIELDTERMINATOR:
        case FILTER:
        case FOR:
        case FOREACH:
        case FROM:
        case FULLTEXT:
        case FUNCTION:
        case FUNCTIONS:
        case GRANT:
        case GRAPH:
        case GRAPHS:
        case HEADERS:
        case HOME:
        case IF:
        case IN:
        case INDEX:
        case INDEXES:
        case IS:
        case JOIN:
        case KEY:
        case LABEL:
        case LABELS:
        case LIMITROWS:
        case LOAD:
        case LOOKUP:
        case MANAGEMENT:
        case MATCH:
        case MERGE:
        case NAME:
        case NAMES:
        case NEW:
        case NODE:
        case NODES:
        case NONE:
        case NOT:
        case NOWAIT:
        case NULL:
        case OF:
        case ON:
        case ONLY:
        case OPTIONAL:
        case OPTIONS:
        case OR:
        case ORDER:
        case OUTPUT:
        case PASSWORD:
        case PASSWORDS:
        case PERIODIC:
        case PLAINTEXT:
        case POINT:
        case POPULATED:
        case PRIVILEGE:
        case PRIVILEGES:
        case PROCEDURE:
        case PROCEDURES:
        case PROPERTY:
        case RANGE:
        case READ:
        case REDUCE:
        case RENAME:
        case REL:
        case RELATIONSHIP:
        case RELATIONSHIPS:
        case REMOVE:
        case REPLACE:
        case REQUIRE:
        case REQUIRED:
        case RETURN:
        case REVOKE:
        case ROLE:
        case ROLES:
        case ROW:
        case ROWS:
        case SCAN:
        case SEC:
        case SECOND:
        case SECONDS:
        case SEEK:
        case SET:
        case SHORTEST_PATH:
        case SHOW:
        case SINGLE:
        case SKIPROWS:
        case START:
        case STARTS:
        case STATUS:
        case STOP:
        case SUSPENDED:
        case TARGET:
        case TERMINATE:
        case TEXT:
        case THEN:
        case TO:
        case TRANSACTION:
        case TRANSACTIONS:
        case TRAVERSE:
        case TRUE:
        case TYPE:
        case TYPES:
        case UNION:
        case UNIQUE:
        case UNWIND:
        case USE:
        case USER:
        case USERS:
        case USING:
        case VERBOSE:
        case WAIT:
        case WHEN:
        case WHERE:
        case WITH:
        case WRITE:
        case XOR:
        case YIELD:
        case IDENTIFIER:{
          command = createIndex(start, replace, CreateIndexTypes.DEFAULT);
          break;
          }
        default:
          jj_la1[233] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[234] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return command;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SCHEMA_COMMAND oldCreateIndex(Token start, boolean replace) throws ParseException, Exception {Token nodeLabel;
    List<StringPos<POS>> properties;
    //CREATE INDEX ON :nodeLabel(prop1, prop2)
        nodeLabel = LabelOrRelType();
    jj_consume_token(LPAREN);
    properties = SymbolicNamePositions();
    jj_consume_token(RPAREN);
if (replace) {
            throw exceptionFactory.syntaxException( new ParseException("'REPLACE' is not allowed for this index syntax"), start.beginOffset, start.beginLine, start.beginColumn );
        }
        {if ("" != null) return astFactory.createIndexWithOldSyntax( pos(start), new StringPos<>(nodeLabel.image, pos(nodeLabel) ), properties );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SCHEMA_COMMAND createIndex(Token start, boolean replace, CreateIndexTypes indexType) throws ParseException, Exception {boolean ifNotExists = false;
    boolean isNode = false;
    String indexName = null;
    VARIABLE variable = null;
    Token label = null;
    List<PROPERTY> properties= new ArrayList<>();
    SimpleEither<Map<String, EXPRESSION>, PARAMETER> options = null;
    if (jj_2_64(2147483647)) {
      jj_consume_token(FOR);
      jj_consume_token(LPAREN);
    } else if (jj_2_65(2147483647)) {
      jj_consume_token(IF);
      jj_consume_token(NOT);
      jj_consume_token(EXISTS);
ifNotExists = true;
      jj_consume_token(FOR);
      jj_consume_token(LPAREN);
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case AS:
      case ASC:
      case ASSERT:
      case ASSIGN:
      case AT:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASE:
      case CATALOG:
      case CHANGE:
      case COMMIT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DBMS:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESTROY:
      case DETACH:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DUMP:
      case EACH:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case EXTRACT:
      case FALSE:
      case FIELDTERMINATOR:
      case FILTER:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case HEADERS:
      case HOME:
      case IF:
      case IN:
      case INDEX:
      case INDEXES:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LIMITROWS:
      case LOAD:
      case LOOKUP:
      case MANAGEMENT:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NEW:
      case NODE:
      case NODES:
      case NONE:
      case NOT:
      case NOWAIT:
      case NULL:
      case OF:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTY:
      case RANGE:
      case READ:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REQUIRE:
      case REQUIRED:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDS:
      case SEEK:
      case SET:
      case SHORTEST_PATH:
      case SHOW:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TO:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRUE:
      case TYPE:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNWIND:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VERBOSE:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WRITE:
      case XOR:
      case YIELD:
      case IDENTIFIER:{
        SymbolicNameString();
indexName = token.image;
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IF:{
          jj_consume_token(IF);
          jj_consume_token(NOT);
          jj_consume_token(EXISTS);
ifNotExists = true;
          break;
          }
        default:
          jj_la1[235] = jj_gen;
          ;
        }
        jj_consume_token(FOR);
        jj_consume_token(LPAREN);
        break;
        }
      default:
        jj_la1[236] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case AS:
    case ASC:
    case ASSERT:
    case ASSIGN:
    case AT:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASE:
    case CATALOG:
    case CHANGE:
    case COMMIT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DBMS:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESTROY:
    case DETACH:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DUMP:
    case EACH:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case EXTRACT:
    case FALSE:
    case FIELDTERMINATOR:
    case FILTER:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case HEADERS:
    case HOME:
    case IF:
    case IN:
    case INDEX:
    case INDEXES:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LIMITROWS:
    case LOAD:
    case LOOKUP:
    case MANAGEMENT:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NEW:
    case NODE:
    case NODES:
    case NONE:
    case NOT:
    case NOWAIT:
    case NULL:
    case OF:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTY:
    case RANGE:
    case READ:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REQUIRE:
    case REQUIRED:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDS:
    case SEEK:
    case SET:
    case SHORTEST_PATH:
    case SHOW:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TO:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRUE:
    case TYPE:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNWIND:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VERBOSE:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WRITE:
    case XOR:
    case YIELD:
    case IDENTIFIER:{
      //(n:LABEL)
              variable = Variable();
      label = LabelOrRelType();
      jj_consume_token(RPAREN);
isNode = true;
      break;
      }
    case RPAREN:{
      jj_consume_token(RPAREN);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LT:
      case ARROW_LEFT_HEAD:{
        LeftArrow();
        break;
        }
      default:
        jj_la1[237] = jj_gen;
        ;
      }
      ArrowLine();
      jj_consume_token(LBRACKET);
      variable = Variable();
      label = LabelOrRelType();
      jj_consume_token(RBRACKET);
      ArrowLine();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case GT:
      case ARROW_RIGHT_HEAD:{
        RightArrow();
        break;
        }
      default:
        jj_la1[238] = jj_gen;
        ;
      }
      jj_consume_token(LPAREN);
      jj_consume_token(RPAREN);
      break;
      }
    default:
      jj_la1[239] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(ON);
    properties = PropertyList();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case OPTIONS:{
      jj_consume_token(OPTIONS);
      options = MapOrParameter();
      break;
      }
    default:
      jj_la1[240] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.createIndex( pos(start), replace, ifNotExists, isNode, indexName, variable, new StringPos<>(label.image, pos(label)), properties, options, indexType );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SCHEMA_COMMAND createFulltextIndex(Token start, boolean replace) throws ParseException {boolean ifNotExists = false;
    boolean isNode = false;
    String indexName = null;
    VARIABLE variable = null;
    VARIABLE propName = null;
    PROPERTY p = null;
    List<StringPos<POS>> labels = new ArrayList<>();
    List<PROPERTY> properties= new ArrayList<>();
    SimpleEither<Map<String, EXPRESSION>, PARAMETER> options = null;
    if (jj_2_66(2147483647)) {
      jj_consume_token(FOR);
      jj_consume_token(LPAREN);
    } else if (jj_2_67(2147483647)) {
      jj_consume_token(IF);
      jj_consume_token(NOT);
      jj_consume_token(EXISTS);
ifNotExists = true;
      jj_consume_token(FOR);
      jj_consume_token(LPAREN);
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case AS:
      case ASC:
      case ASSERT:
      case ASSIGN:
      case AT:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASE:
      case CATALOG:
      case CHANGE:
      case COMMIT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DBMS:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESTROY:
      case DETACH:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DUMP:
      case EACH:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case EXTRACT:
      case FALSE:
      case FIELDTERMINATOR:
      case FILTER:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case HEADERS:
      case HOME:
      case IF:
      case IN:
      case INDEX:
      case INDEXES:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LIMITROWS:
      case LOAD:
      case LOOKUP:
      case MANAGEMENT:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NEW:
      case NODE:
      case NODES:
      case NONE:
      case NOT:
      case NOWAIT:
      case NULL:
      case OF:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTY:
      case RANGE:
      case READ:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REQUIRE:
      case REQUIRED:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDS:
      case SEEK:
      case SET:
      case SHORTEST_PATH:
      case SHOW:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TO:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRUE:
      case TYPE:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNWIND:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VERBOSE:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WRITE:
      case XOR:
      case YIELD:
      case IDENTIFIER:{
        SymbolicNameString();
indexName = token.image;
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IF:{
          jj_consume_token(IF);
          jj_consume_token(NOT);
          jj_consume_token(EXISTS);
ifNotExists = true;
          break;
          }
        default:
          jj_la1[241] = jj_gen;
          ;
        }
        jj_consume_token(FOR);
        jj_consume_token(LPAREN);
        break;
        }
      default:
        jj_la1[242] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case AS:
    case ASC:
    case ASSERT:
    case ASSIGN:
    case AT:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASE:
    case CATALOG:
    case CHANGE:
    case COMMIT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DBMS:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESTROY:
    case DETACH:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DUMP:
    case EACH:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case EXTRACT:
    case FALSE:
    case FIELDTERMINATOR:
    case FILTER:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case HEADERS:
    case HOME:
    case IF:
    case IN:
    case INDEX:
    case INDEXES:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LIMITROWS:
    case LOAD:
    case LOOKUP:
    case MANAGEMENT:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NEW:
    case NODE:
    case NODES:
    case NONE:
    case NOT:
    case NOWAIT:
    case NULL:
    case OF:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTY:
    case RANGE:
    case READ:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REQUIRE:
    case REQUIRED:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDS:
    case SEEK:
    case SET:
    case SHORTEST_PATH:
    case SHOW:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TO:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRUE:
    case TYPE:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNWIND:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VERBOSE:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WRITE:
    case XOR:
    case YIELD:
    case IDENTIFIER:{
      //(v:L1 | ... | Ln)
                  variable = Variable();
      labels = LabelOrRelTypes();
      jj_consume_token(RPAREN);
isNode = true;
      break;
      }
    case RPAREN:{
      jj_consume_token(RPAREN);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LT:
      case ARROW_LEFT_HEAD:{
        LeftArrow();
        break;
        }
      default:
        jj_la1[243] = jj_gen;
        ;
      }
      ArrowLine();
      jj_consume_token(LBRACKET);
      variable = Variable();
      labels = LabelOrRelTypes();
      jj_consume_token(RBRACKET);
      ArrowLine();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case GT:
      case ARROW_RIGHT_HEAD:{
        RightArrow();
        break;
        }
      default:
        jj_la1[244] = jj_gen;
        ;
      }
      jj_consume_token(LPAREN);
      jj_consume_token(RPAREN);
      break;
      }
    default:
      jj_la1[245] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(ON);
    jj_consume_token(EACH);
    jj_consume_token(LBRACKET);
    propName = Variable();
    p = Property(propName);
properties.add( p );
    label_46:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 250:{
        break;
        }
      default:
        jj_la1[246] = jj_gen;
        break label_46;
      }
      jj_consume_token(250);
      propName = Variable();
      p = Property(propName);
properties.add( p );
    }
    jj_consume_token(RBRACKET);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case OPTIONS:{
      jj_consume_token(OPTIONS);
      options = MapOrParameter();
      break;
      }
    default:
      jj_la1[247] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.createFulltextIndex( pos(start), replace, ifNotExists, isNode, indexName, variable, labels, properties, options );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SCHEMA_COMMAND createLookupIndex(Token start, boolean replace) throws ParseException {boolean ifNotExists = false;
    boolean isNode = false;
    String indexName = null;
    VARIABLE variable = null;
    StringPos<POS> funcName = null;
    VARIABLE funcParam = variable;
    SimpleEither<Map<String, EXPRESSION>, PARAMETER> options = null;
    if (jj_2_68(2147483647)) {
      jj_consume_token(FOR);
      jj_consume_token(LPAREN);
    } else if (jj_2_69(2147483647)) {
      jj_consume_token(IF);
      jj_consume_token(NOT);
      jj_consume_token(EXISTS);
ifNotExists = true;
      jj_consume_token(FOR);
      jj_consume_token(LPAREN);
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case AS:
      case ASC:
      case ASSERT:
      case ASSIGN:
      case AT:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASE:
      case CATALOG:
      case CHANGE:
      case COMMIT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DBMS:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESTROY:
      case DETACH:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DUMP:
      case EACH:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case EXTRACT:
      case FALSE:
      case FIELDTERMINATOR:
      case FILTER:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case HEADERS:
      case HOME:
      case IF:
      case IN:
      case INDEX:
      case INDEXES:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LIMITROWS:
      case LOAD:
      case LOOKUP:
      case MANAGEMENT:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NEW:
      case NODE:
      case NODES:
      case NONE:
      case NOT:
      case NOWAIT:
      case NULL:
      case OF:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTY:
      case RANGE:
      case READ:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REQUIRE:
      case REQUIRED:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDS:
      case SEEK:
      case SET:
      case SHORTEST_PATH:
      case SHOW:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TO:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRUE:
      case TYPE:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNWIND:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VERBOSE:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WRITE:
      case XOR:
      case YIELD:
      case IDENTIFIER:{
        SymbolicNameString();
indexName = token.image;
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IF:{
          jj_consume_token(IF);
          jj_consume_token(NOT);
          jj_consume_token(EXISTS);
ifNotExists = true;
          break;
          }
        default:
          jj_la1[248] = jj_gen;
          ;
        }
        jj_consume_token(FOR);
        jj_consume_token(LPAREN);
        break;
        }
      default:
        jj_la1[249] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case AS:
    case ASC:
    case ASSERT:
    case ASSIGN:
    case AT:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASE:
    case CATALOG:
    case CHANGE:
    case COMMIT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DBMS:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESTROY:
    case DETACH:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DUMP:
    case EACH:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case EXTRACT:
    case FALSE:
    case FIELDTERMINATOR:
    case FILTER:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case HEADERS:
    case HOME:
    case IF:
    case IN:
    case INDEX:
    case INDEXES:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LIMITROWS:
    case LOAD:
    case LOOKUP:
    case MANAGEMENT:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NEW:
    case NODE:
    case NODES:
    case NONE:
    case NOT:
    case NOWAIT:
    case NULL:
    case OF:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTY:
    case RANGE:
    case READ:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REQUIRE:
    case REQUIRED:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDS:
    case SEEK:
    case SET:
    case SHORTEST_PATH:
    case SHOW:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TO:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRUE:
    case TYPE:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNWIND:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VERBOSE:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WRITE:
    case XOR:
    case YIELD:
    case IDENTIFIER:{
      //(v)
              variable = Variable();
      jj_consume_token(RPAREN);
      jj_consume_token(ON);
      jj_consume_token(EACH);
isNode = true;
      break;
      }
    case RPAREN:{
      jj_consume_token(RPAREN);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LT:
      case ARROW_LEFT_HEAD:{
        LeftArrow();
        break;
        }
      default:
        jj_la1[250] = jj_gen;
        ;
      }
      ArrowLine();
      jj_consume_token(LBRACKET);
      variable = Variable();
      jj_consume_token(RBRACKET);
      ArrowLine();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case GT:
      case ARROW_RIGHT_HEAD:{
        RightArrow();
        break;
        }
      default:
        jj_la1[251] = jj_gen;
        ;
      }
      jj_consume_token(LPAREN);
      jj_consume_token(RPAREN);
      jj_consume_token(ON);
      if (jj_2_70(2147483647)) {
        jj_consume_token(EACH);
      } else {
        ;
      }
      break;
      }
    default:
      jj_la1[252] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    SymbolicNameString();
funcName = new StringPos<POS>( token.image, pos(token) );
    jj_consume_token(LPAREN);
    funcParam = Variable();
    jj_consume_token(RPAREN);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case OPTIONS:{
      jj_consume_token(OPTIONS);
      options = MapOrParameter();
      break;
      }
    default:
      jj_la1[253] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.createLookupIndex( pos(start), replace, ifNotExists, isNode, indexName, variable, funcName, funcParam, options );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SCHEMA_COMMAND DropIndex(Token start) throws ParseException {Token nodeLabel;
    List<StringPos<POS>> properties;
    Token name;
    boolean ifExists = false;
    jj_consume_token(INDEX);
    if (jj_2_71(2)) {
      jj_consume_token(ON);
      nodeLabel = LabelOrRelType();
      jj_consume_token(LPAREN);
      properties = SymbolicNamePositions();
      jj_consume_token(RPAREN);
{if ("" != null) return astFactory.dropIndex( pos(start), new StringPos<>(nodeLabel.image, pos(nodeLabel) ), properties );}
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case AS:
      case ASC:
      case ASSERT:
      case ASSIGN:
      case AT:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASE:
      case CATALOG:
      case CHANGE:
      case COMMIT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DBMS:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESTROY:
      case DETACH:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DUMP:
      case EACH:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case EXTRACT:
      case FALSE:
      case FIELDTERMINATOR:
      case FILTER:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case HEADERS:
      case HOME:
      case IF:
      case IN:
      case INDEX:
      case INDEXES:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LIMITROWS:
      case LOAD:
      case LOOKUP:
      case MANAGEMENT:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NEW:
      case NODE:
      case NODES:
      case NONE:
      case NOT:
      case NOWAIT:
      case NULL:
      case OF:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTY:
      case RANGE:
      case READ:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REQUIRE:
      case REQUIRED:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDS:
      case SEEK:
      case SET:
      case SHORTEST_PATH:
      case SHOW:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TO:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRUE:
      case TYPE:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNWIND:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VERBOSE:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WRITE:
      case XOR:
      case YIELD:
      case IDENTIFIER:{
        name = SymbolicNameString();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IF:{
          jj_consume_token(IF);
          jj_consume_token(EXISTS);
ifExists = true;
          break;
          }
        default:
          jj_la1[254] = jj_gen;
          ;
        }
{if ("" != null) return astFactory.dropIndex( pos(start), name.image, ifExists );}
        break;
        }
      default:
        jj_la1[255] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<PROPERTY> PropertyList() throws ParseException {VARIABLE variable;
    PROPERTY p;
    List<PROPERTY> properties= new ArrayList<>();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case AS:
    case ASC:
    case ASSERT:
    case ASSIGN:
    case AT:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASE:
    case CATALOG:
    case CHANGE:
    case COMMIT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DBMS:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESTROY:
    case DETACH:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DUMP:
    case EACH:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case EXTRACT:
    case FALSE:
    case FIELDTERMINATOR:
    case FILTER:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case HEADERS:
    case HOME:
    case IF:
    case IN:
    case INDEX:
    case INDEXES:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LIMITROWS:
    case LOAD:
    case LOOKUP:
    case MANAGEMENT:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NEW:
    case NODE:
    case NODES:
    case NONE:
    case NOT:
    case NOWAIT:
    case NULL:
    case OF:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTY:
    case RANGE:
    case READ:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REQUIRE:
    case REQUIRED:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDS:
    case SEEK:
    case SET:
    case SHORTEST_PATH:
    case SHOW:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TO:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRUE:
    case TYPE:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNWIND:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VERBOSE:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WRITE:
    case XOR:
    case YIELD:
    case IDENTIFIER:{
      variable = Variable();
      p = Property(variable);
properties.add( p );
      break;
      }
    case LPAREN:{
      jj_consume_token(LPAREN);
      variable = Variable();
      p = Property(variable);
properties.add( p );
      label_47:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case 250:{
          break;
          }
        default:
          jj_la1[256] = jj_gen;
          break label_47;
        }
        jj_consume_token(250);
        variable = Variable();
        p = Property(variable);
properties.add( p );
      }
      jj_consume_token(RPAREN);
      break;
      }
    default:
      jj_la1[257] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return properties;}
    throw new IllegalStateException ("Missing return statement in function");
}

// Administration Commands
  final public 
ADMINISTRATION_COMMAND RenameCommand() throws ParseException {Token start;
    ADMINISTRATION_COMMAND command;
    start = jj_consume_token(RENAME);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ROLE:{
      command = RenameRole(start);
      break;
      }
    case USER:{
      command = RenameUser(start);
      break;
      }
    default:
      jj_la1[258] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return command;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND GrantCommand() throws ParseException, Exception {Token start;
    ADMINISTRATION_COMMAND c;
    start = jj_consume_token(GRANT);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ACCESS:
    case ALIAS:
    case ALL:
    case ALTER:
    case ASSIGN:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CREATE:
    case DATABASE:
    case DELETE:
    case DROP:
    case IMPERSONATE:
    case INDEX:
    case INDEXES:
    case MATCH:
    case MERGE:
    case NAME:
    case PRIVILEGE:
    case READ:
    case RENAME:
    case REMOVE:
    case SET:
    case SHOW:
    case START:
    case STOP:
    case TERMINATE:
    case TRANSACTION:
    case TRAVERSE:
    case USER:
    case WRITE:{
      c = grantPrivilege(start);
      break;
      }
    case ROLE:{
      jj_consume_token(ROLE);
      if (jj_2_72(2147483647)) {
        c = grantRoleManagement(start);
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ESCAPED_SYMBOLIC_NAME:
        case ACCESS:
        case ACTIVE:
        case ALIAS:
        case ALIASES:
        case ALL_SHORTEST_PATH:
        case ALL:
        case ALTER:
        case AND:
        case ANY:
        case AS:
        case ASC:
        case ASSERT:
        case ASSIGN:
        case AT:
        case BRIEF:
        case BTREE:
        case BUILT:
        case BY:
        case CALL:
        case CASE:
        case CATALOG:
        case CHANGE:
        case COMMIT:
        case CONSTRAINT:
        case CONSTRAINTS:
        case CONTAINS:
        case COPY:
        case COUNT:
        case CREATE:
        case CSV:
        case CURRENT:
        case DATA:
        case DATABASE:
        case DATABASES:
        case DBMS:
        case DEFAULT_TOKEN:
        case DEFINED:
        case DELETE:
        case DENY:
        case DESC:
        case DESTROY:
        case DETACH:
        case DOLLAR:
        case DISTINCT:
        case DRIVER:
        case DROP:
        case DUMP:
        case EACH:
        case ELEMENT:
        case ELEMENTS:
        case ELSE:
        case ENCRYPTED:
        case END:
        case ENDS:
        case EXECUTABLE:
        case EXIST:
        case EXISTENCE:
        case EXISTS:
        case EXTRACT:
        case FALSE:
        case FIELDTERMINATOR:
        case FILTER:
        case FOR:
        case FOREACH:
        case FROM:
        case FULLTEXT:
        case FUNCTION:
        case FUNCTIONS:
        case GRANT:
        case GRAPH:
        case GRAPHS:
        case HEADERS:
        case HOME:
        case IF:
        case IN:
        case INDEX:
        case INDEXES:
        case IS:
        case JOIN:
        case KEY:
        case LABEL:
        case LABELS:
        case LIMITROWS:
        case LOAD:
        case LOOKUP:
        case MANAGEMENT:
        case MATCH:
        case MERGE:
        case NAME:
        case NAMES:
        case NEW:
        case NODE:
        case NODES:
        case NONE:
        case NOT:
        case NOWAIT:
        case NULL:
        case OF:
        case ON:
        case ONLY:
        case OPTIONAL:
        case OPTIONS:
        case OR:
        case ORDER:
        case OUTPUT:
        case PASSWORD:
        case PASSWORDS:
        case PERIODIC:
        case PLAINTEXT:
        case POINT:
        case POPULATED:
        case PRIVILEGE:
        case PRIVILEGES:
        case PROCEDURE:
        case PROCEDURES:
        case PROPERTY:
        case RANGE:
        case READ:
        case REDUCE:
        case RENAME:
        case REL:
        case RELATIONSHIP:
        case RELATIONSHIPS:
        case REMOVE:
        case REPLACE:
        case REQUIRE:
        case REQUIRED:
        case RETURN:
        case REVOKE:
        case ROLE:
        case ROLES:
        case ROW:
        case ROWS:
        case SCAN:
        case SEC:
        case SECOND:
        case SECONDS:
        case SEEK:
        case SET:
        case SHORTEST_PATH:
        case SHOW:
        case SINGLE:
        case SKIPROWS:
        case START:
        case STARTS:
        case STATUS:
        case STOP:
        case SUSPENDED:
        case TARGET:
        case TERMINATE:
        case TEXT:
        case THEN:
        case TO:
        case TRANSACTION:
        case TRANSACTIONS:
        case TRAVERSE:
        case TRUE:
        case TYPE:
        case TYPES:
        case UNION:
        case UNIQUE:
        case UNWIND:
        case USE:
        case USER:
        case USERS:
        case USING:
        case VERBOSE:
        case WAIT:
        case WHEN:
        case WHERE:
        case WITH:
        case WRITE:
        case XOR:
        case YIELD:
        case IDENTIFIER:{
          c = GrantRole(start);
          break;
          }
        default:
          jj_la1[259] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    case ROLES:{
      jj_consume_token(ROLES);
      c = GrantRole(start);
      break;
      }
    default:
      jj_la1[260] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return c;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND RevokeCommand() throws ParseException, Exception {Token start;
    ADMINISTRATION_COMMAND c;
    start = jj_consume_token(REVOKE);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DENY:{
      jj_consume_token(DENY);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ACCESS:
      case ALIAS:
      case ALL:
      case ALTER:
      case ASSIGN:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CREATE:
      case DATABASE:
      case DELETE:
      case DROP:
      case IMPERSONATE:
      case INDEX:
      case INDEXES:
      case MATCH:
      case MERGE:
      case NAME:
      case PRIVILEGE:
      case READ:
      case RENAME:
      case REMOVE:
      case SET:
      case SHOW:
      case START:
      case STOP:
      case TERMINATE:
      case TRANSACTION:
      case TRAVERSE:
      case USER:
      case WRITE:{
        c = RevokePrivilege(start, false, true);
        break;
        }
      case ROLE:{
        jj_consume_token(ROLE);
        c = revokeRoleManagement(start, false, true);
        break;
        }
      default:
        jj_la1[261] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case GRANT:{
      jj_consume_token(GRANT);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ACCESS:
      case ALIAS:
      case ALL:
      case ALTER:
      case ASSIGN:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CREATE:
      case DATABASE:
      case DELETE:
      case DROP:
      case IMPERSONATE:
      case INDEX:
      case INDEXES:
      case MATCH:
      case MERGE:
      case NAME:
      case PRIVILEGE:
      case READ:
      case RENAME:
      case REMOVE:
      case SET:
      case SHOW:
      case START:
      case STOP:
      case TERMINATE:
      case TRANSACTION:
      case TRAVERSE:
      case USER:
      case WRITE:{
        c = RevokePrivilege(start, true, false);
        break;
        }
      case ROLE:{
        jj_consume_token(ROLE);
        c = revokeRoleManagement(start, true, false);
        break;
        }
      default:
        jj_la1[262] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case ACCESS:
    case ALIAS:
    case ALL:
    case ALTER:
    case ASSIGN:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CREATE:
    case DATABASE:
    case DELETE:
    case DROP:
    case IMPERSONATE:
    case INDEX:
    case INDEXES:
    case MATCH:
    case MERGE:
    case NAME:
    case PRIVILEGE:
    case READ:
    case RENAME:
    case REMOVE:
    case SET:
    case SHOW:
    case START:
    case STOP:
    case TERMINATE:
    case TRANSACTION:
    case TRAVERSE:
    case USER:
    case WRITE:{
      c = RevokePrivilege(start, true, true);
      break;
      }
    case ROLE:{
      jj_consume_token(ROLE);
      if (jj_2_73(2147483647)) {
        c = revokeRoleManagement(start, true, true);
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ESCAPED_SYMBOLIC_NAME:
        case ACCESS:
        case ACTIVE:
        case ALIAS:
        case ALIASES:
        case ALL_SHORTEST_PATH:
        case ALL:
        case ALTER:
        case AND:
        case ANY:
        case AS:
        case ASC:
        case ASSERT:
        case ASSIGN:
        case AT:
        case BRIEF:
        case BTREE:
        case BUILT:
        case BY:
        case CALL:
        case CASE:
        case CATALOG:
        case CHANGE:
        case COMMIT:
        case CONSTRAINT:
        case CONSTRAINTS:
        case CONTAINS:
        case COPY:
        case COUNT:
        case CREATE:
        case CSV:
        case CURRENT:
        case DATA:
        case DATABASE:
        case DATABASES:
        case DBMS:
        case DEFAULT_TOKEN:
        case DEFINED:
        case DELETE:
        case DENY:
        case DESC:
        case DESTROY:
        case DETACH:
        case DOLLAR:
        case DISTINCT:
        case DRIVER:
        case DROP:
        case DUMP:
        case EACH:
        case ELEMENT:
        case ELEMENTS:
        case ELSE:
        case ENCRYPTED:
        case END:
        case ENDS:
        case EXECUTABLE:
        case EXIST:
        case EXISTENCE:
        case EXISTS:
        case EXTRACT:
        case FALSE:
        case FIELDTERMINATOR:
        case FILTER:
        case FOR:
        case FOREACH:
        case FROM:
        case FULLTEXT:
        case FUNCTION:
        case FUNCTIONS:
        case GRANT:
        case GRAPH:
        case GRAPHS:
        case HEADERS:
        case HOME:
        case IF:
        case IN:
        case INDEX:
        case INDEXES:
        case IS:
        case JOIN:
        case KEY:
        case LABEL:
        case LABELS:
        case LIMITROWS:
        case LOAD:
        case LOOKUP:
        case MANAGEMENT:
        case MATCH:
        case MERGE:
        case NAME:
        case NAMES:
        case NEW:
        case NODE:
        case NODES:
        case NONE:
        case NOT:
        case NOWAIT:
        case NULL:
        case OF:
        case ON:
        case ONLY:
        case OPTIONAL:
        case OPTIONS:
        case OR:
        case ORDER:
        case OUTPUT:
        case PASSWORD:
        case PASSWORDS:
        case PERIODIC:
        case PLAINTEXT:
        case POINT:
        case POPULATED:
        case PRIVILEGE:
        case PRIVILEGES:
        case PROCEDURE:
        case PROCEDURES:
        case PROPERTY:
        case RANGE:
        case READ:
        case REDUCE:
        case RENAME:
        case REL:
        case RELATIONSHIP:
        case RELATIONSHIPS:
        case REMOVE:
        case REPLACE:
        case REQUIRE:
        case REQUIRED:
        case RETURN:
        case REVOKE:
        case ROLE:
        case ROLES:
        case ROW:
        case ROWS:
        case SCAN:
        case SEC:
        case SECOND:
        case SECONDS:
        case SEEK:
        case SET:
        case SHORTEST_PATH:
        case SHOW:
        case SINGLE:
        case SKIPROWS:
        case START:
        case STARTS:
        case STATUS:
        case STOP:
        case SUSPENDED:
        case TARGET:
        case TERMINATE:
        case TEXT:
        case THEN:
        case TO:
        case TRANSACTION:
        case TRANSACTIONS:
        case TRAVERSE:
        case TRUE:
        case TYPE:
        case TYPES:
        case UNION:
        case UNIQUE:
        case UNWIND:
        case USE:
        case USER:
        case USERS:
        case USING:
        case VERBOSE:
        case WAIT:
        case WHEN:
        case WHERE:
        case WITH:
        case WRITE:
        case XOR:
        case YIELD:
        case IDENTIFIER:{
          c = RevokeRole(start);
          break;
          }
        default:
          jj_la1[263] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    case ROLES:{
      jj_consume_token(ROLES);
      c = RevokeRole(start);
      break;
      }
    default:
      jj_la1[264] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return c;}
    throw new IllegalStateException ("Missing return statement in function");
}

// Role commands
  final public 
ADMINISTRATION_COMMAND CreateRole(Token start, boolean replace) throws ParseException {SimpleEither<String, PARAMETER> roleName = null;
    SimpleEither<String, PARAMETER> sourceRoleName = null;
    boolean ifNotExists = false;
    jj_consume_token(ROLE);
    roleName = SymbolicNameOrStringParameter();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(NOT);
      jj_consume_token(EXISTS);
ifNotExists = true;
      break;
      }
    default:
      jj_la1[265] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case AS:{
      jj_consume_token(AS);
      jj_consume_token(COPY);
      jj_consume_token(OF);
      sourceRoleName = SymbolicNameOrStringParameter();
      break;
      }
    default:
      jj_la1[266] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.createRole( pos( start ), replace, roleName, sourceRoleName, ifNotExists );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND DropRole(Token start) throws ParseException {SimpleEither<String, PARAMETER> roleName = null;
    boolean ifExists = false;
    jj_consume_token(ROLE);
    roleName = SymbolicNameOrStringParameter();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
ifExists = true;
      break;
      }
    default:
      jj_la1[267] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.dropRole( pos( start ), roleName, ifExists );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND RenameRole(Token start) throws ParseException {SimpleEither<String, PARAMETER> fromRoleName = null;
    SimpleEither<String, PARAMETER> toRoleName = null;
    boolean ifExists = false;
    jj_consume_token(ROLE);
    fromRoleName = SymbolicNameOrStringParameter();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
ifExists = true;
      break;
      }
    default:
      jj_la1[268] = jj_gen;
      ;
    }
    jj_consume_token(TO);
    toRoleName = SymbolicNameOrStringParameter();
{if ("" != null) return astFactory.renameRole( pos( start ), fromRoleName, toRoleName, ifExists );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT_WITH_GRAPH ShowRoles(Token start, USE_CLAUSE useClause, boolean showAll) throws ParseException {boolean withUsers = false;
    YIELD yield = null;
    RETURN_CLAUSE returnClause = null;
    WHERE where = null;
    jj_consume_token(ROLES);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WITH:{
      jj_consume_token(WITH);
      jj_consume_token(USERS);
withUsers = true;
      break;
      }
    default:
      jj_la1[269] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:
    case YIELD:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case YIELD:{
        yield = YieldClause();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case RETURN:{
          returnClause = ReturnClause();
          break;
          }
        default:
          jj_la1[270] = jj_gen;
          ;
        }
        break;
        }
      case WHERE:{
        where = WhereClause();
        break;
        }
      default:
        jj_la1[271] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[272] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.useGraph( astFactory.showRoles( pos( start ), withUsers, showAll, yield, returnClause, where ), useClause );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND GrantRole(Token start) throws ParseException {List<SimpleEither<String, PARAMETER>> roles;
    List<SimpleEither<String, PARAMETER>> users;
    roles = SymbolicNameOrStringParameterList();
    jj_consume_token(TO);
    users = SymbolicNameOrStringParameterList();
{if ("" != null) return astFactory.grantRoles( pos( start ), roles, users );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND RevokeRole(Token start) throws ParseException {List<SimpleEither<String, PARAMETER>> roles;
    List<SimpleEither<String, PARAMETER>> users;
    roles = SymbolicNameOrStringParameterList();
    jj_consume_token(FROM);
    users = SymbolicNameOrStringParameterList();
{if ("" != null) return astFactory.revokeRoles( pos( start ), roles, users );}
    throw new IllegalStateException ("Missing return statement in function");
}

// User commands
  final public 
ADMINISTRATION_COMMAND CreateUser(Token start, boolean replace) throws ParseException, Exception {Token set = null;
    SimpleEither<String, PARAMETER> username = null;
    EXPRESSION password = null;
    boolean ifNotExists = false;
    boolean encrypted = false;
    Optional<Boolean> changeRequired = Optional.empty();
    Optional<Boolean> suspended = Optional.empty();
    Optional<SimpleEither<String, PARAMETER>> homeDatabase = Optional.empty();
    jj_consume_token(USER);
    username = SymbolicNameOrStringParameter();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(NOT);
      jj_consume_token(EXISTS);
ifNotExists = true;
      break;
      }
    default:
      jj_la1[273] = jj_gen;
      ;
    }
    jj_consume_token(SET);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ENCRYPTED:
    case PLAINTEXT:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PLAINTEXT:{
        jj_consume_token(PLAINTEXT);
encrypted = false;
        break;
        }
      case ENCRYPTED:{
        jj_consume_token(ENCRYPTED);
encrypted = true;
        break;
        }
      default:
        jj_la1[274] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[275] = jj_gen;
      ;
    }
    jj_consume_token(PASSWORD);
    password = passwordExpression();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case CHANGE:{
      changeRequired = PasswordChangeRequired(start, changeRequired);
      break;
      }
    default:
      jj_la1[276] = jj_gen;
      ;
    }
    label_48:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case SET:{
        break;
        }
      default:
        jj_la1[277] = jj_gen;
        break label_48;
      }
      set = jj_consume_token(SET);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PASSWORD:{
        jj_consume_token(PASSWORD);
        changeRequired = PasswordChangeRequired(set, changeRequired);
        break;
        }
      case STATUS:{
        suspended = UserStatus(set, suspended);
        break;
        }
      case HOME:{
        homeDatabase = HomeDatabase(set, homeDatabase);
        break;
        }
      default:
        jj_la1[278] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return astFactory.createUser( pos( start ), replace, ifNotExists, username, password, encrypted,
                                      changeRequired.orElse( true ), suspended.orElse( null ), homeDatabase.orElse( null ) );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND DropUser(Token start) throws ParseException {SimpleEither<String, PARAMETER> username = null;
    boolean ifExists = false;
    jj_consume_token(USER);
    username = SymbolicNameOrStringParameter();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
ifExists = true;
      break;
      }
    default:
      jj_la1[279] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.dropUser( pos( start ), ifExists, username );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND RenameUser(Token start) throws ParseException {SimpleEither<String, PARAMETER> fromUserName = null;
    SimpleEither<String, PARAMETER> toUserName = null;
    boolean ifExists = false;
    jj_consume_token(USER);
    fromUserName = SymbolicNameOrStringParameter();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
ifExists = true;
      break;
      }
    default:
      jj_la1[280] = jj_gen;
      ;
    }
    jj_consume_token(TO);
    toUserName = SymbolicNameOrStringParameter();
{if ("" != null) return astFactory.renameUser( pos( start ), fromUserName, toUserName, ifExists );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND AlterCurrentUser(Token start) throws ParseException, Exception {EXPRESSION currentPassword = null;
    EXPRESSION newPassword = null;
    jj_consume_token(CURRENT);
    jj_consume_token(USER);
    jj_consume_token(SET);
    jj_consume_token(PASSWORD);
    jj_consume_token(FROM);
    currentPassword = passwordExpression();
    jj_consume_token(TO);
    newPassword = passwordExpression();
{if ("" != null) return astFactory.setOwnPassword( pos( start ), currentPassword, newPassword);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND AlterUser(Token start) throws ParseException, Exception {Token set = null;
    SimpleEither<String, PARAMETER> username = null;
    EXPRESSION password = null;
    boolean ifExists = false;
    boolean encrypted = false;
    Optional<Boolean> changeRequired = Optional.empty();
    Optional<Boolean> suspended = Optional.empty();
    Optional<SimpleEither<String, PARAMETER>> homeDatabase = Optional.empty();
    boolean removeHome = false;
    String passwordSetError = "Duplicate SET PASSWORD clause";
    jj_consume_token(USER);
    username = SymbolicNameOrStringParameter();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
ifExists = true;
      break;
      }
    default:
      jj_la1[281] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SET:{
      label_49:
      while (true) {
        set = jj_consume_token(SET);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case PLAINTEXT:{
          jj_consume_token(PLAINTEXT);
assertNotAlreadySet( password, set, passwordSetError );
          jj_consume_token(PASSWORD);
          password = SetPassword(set, password);
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case CHANGE:{
            changeRequired = PasswordChangeRequired(set, changeRequired);
            break;
            }
          default:
            jj_la1[282] = jj_gen;
            ;
          }
          break;
          }
        case ENCRYPTED:{
          jj_consume_token(ENCRYPTED);
assertNotAlreadySet( password, set, passwordSetError ); encrypted = true;
          jj_consume_token(PASSWORD);
          password = SetPassword(set, password);
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case CHANGE:{
            changeRequired = PasswordChangeRequired(set, changeRequired);
            break;
            }
          default:
            jj_la1[283] = jj_gen;
            ;
          }
          break;
          }
        case PASSWORD:{
          jj_consume_token(PASSWORD);
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case CHANGE:{
            changeRequired = PasswordChangeRequired(set, changeRequired);
            break;
            }
          case STRING_LITERAL1:
          case STRING_LITERAL2:
          case DOLLAR:{
            password = SetPassword(set, password);
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case CHANGE:{
              changeRequired = PasswordChangeRequired(set, changeRequired);
              break;
              }
            default:
              jj_la1[284] = jj_gen;
              ;
            }
            break;
            }
          default:
            jj_la1[285] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        case STATUS:{
          suspended = UserStatus(set, suspended);
          break;
          }
        case HOME:{
          homeDatabase = HomeDatabase(set, homeDatabase);
          break;
          }
        default:
          jj_la1[286] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case SET:{
          break;
          }
        default:
          jj_la1[287] = jj_gen;
          break label_49;
        }
      }
      break;
      }
    case REMOVE:{
      jj_consume_token(REMOVE);
      jj_consume_token(HOME);
      jj_consume_token(DATABASE);
removeHome = true;
      break;
      }
    default:
      jj_la1[288] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return astFactory.alterUser( pos( start ), ifExists, username, password, encrypted,
            changeRequired.orElse( null ), suspended.orElse( null ), homeDatabase.orElse( null ), removeHome );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION SetPassword(Token start, EXPRESSION password) throws ParseException, Exception {String errorMessage = "Duplicate SET PASSWORD clause";
    EXPRESSION newPassword = null;
    newPassword = passwordExpression();
if ( password != null ) {
            throw exceptionFactory.syntaxException( new ParseException( errorMessage ), start.beginOffset, start.beginLine, start.beginColumn );
        }
        {if ("" != null) return newPassword;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION passwordExpression() throws ParseException {Token name = null;
   PARAMETER parameter = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case STRING_LITERAL1:
    case STRING_LITERAL2:{
      name = StringToken();
      break;
      }
    case DOLLAR:{
      parameter = Parameter(ParameterType.STRING);
      break;
      }
    default:
      jj_la1[289] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if ( name != null )
        {
            {if ("" != null) return astFactory.passwordExpression( pos(name), name.image );}
        }
        else
        {
            {if ("" != null) return astFactory.passwordExpression( parameter );}
        }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Token StringToken() throws ParseException {Token stringLiteral = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case STRING_LITERAL1:{
      stringLiteral = jj_consume_token(STRING_LITERAL1);
      break;
      }
    case STRING_LITERAL2:{
      stringLiteral = jj_consume_token(STRING_LITERAL2);
      break;
      }
    default:
      jj_la1[290] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return stringLiteral;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SimpleEither<String, PARAMETER> StringOrParameter() throws ParseException {Token token = null;
    PARAMETER parameter = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case STRING_LITERAL1:
    case STRING_LITERAL2:{
      token = StringToken();
{if ("" != null) return SimpleEither.<String, PARAMETER>left( token.image );}
      break;
      }
    case DOLLAR:{
      parameter = Parameter(ParameterType.STRING);
{if ("" != null) return SimpleEither.<String, PARAMETER>right( parameter );}
      break;
      }
    default:
      jj_la1[291] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Optional<Boolean> PasswordChangeRequired(Token start, Optional<Boolean> changeRequired) throws ParseException, Exception {String errorMessage = "Duplicate SET PASSWORD CHANGE [NOT] REQUIRED clause";
    boolean required = true;
    jj_consume_token(CHANGE);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case NOT:{
      jj_consume_token(NOT);
required = false;
      break;
      }
    default:
      jj_la1[292] = jj_gen;
      ;
    }
    jj_consume_token(REQUIRED);
assertNotAlreadySet( changeRequired.orElse(null), start, errorMessage );
        {if ("" != null) return Optional.of( required );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Optional<Boolean> UserStatus(Token start, Optional<Boolean> suspended) throws ParseException, Exception {String errorMessage = "Duplicate SET STATUS {SUSPENDED|ACTIVE} clause";
    boolean suspend = false;
    jj_consume_token(STATUS);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SUSPENDED:{
      jj_consume_token(SUSPENDED);
suspend = true;
      break;
      }
    case ACTIVE:{
      jj_consume_token(ACTIVE);
suspend = false;
      break;
      }
    default:
      jj_la1[293] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
assertNotAlreadySet( suspended.orElse(null), start, errorMessage );
        {if ("" != null) return Optional.of( suspend );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Optional<SimpleEither<String, PARAMETER>> HomeDatabase(Token start, Optional<SimpleEither<String, PARAMETER>> homeDatabase) throws ParseException, Exception {String errorMessage = "Duplicate SET HOME DATABASE clause";
    SimpleEither<String, PARAMETER> home = null;
    jj_consume_token(HOME);
    jj_consume_token(DATABASE);
    home = SymbolicDatabaseNameStringOrParameter();
assertNotAlreadySet( homeDatabase.orElse(null), start, errorMessage );
        {if ("" != null) return Optional.of( home );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT_WITH_GRAPH ShowUsers(Token start, USE_CLAUSE useClause) throws ParseException {YIELD yield = null;
    RETURN_CLAUSE returnClause = null;
    WHERE where = null;
    jj_consume_token(USERS);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:
    case YIELD:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case YIELD:{
        yield = YieldClause();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case RETURN:{
          returnClause = ReturnClause();
          break;
          }
        default:
          jj_la1[294] = jj_gen;
          ;
        }
        break;
        }
      case WHERE:{
        where = WhereClause();
        break;
        }
      default:
        jj_la1[295] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[296] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.useGraph( astFactory.showUsers( pos( start ), yield, returnClause, where ), useClause );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT_WITH_GRAPH ShowCurrentUser(Token start, USE_CLAUSE useClause) throws ParseException {YIELD yield = null;
    RETURN_CLAUSE returnClause = null;
    WHERE where = null;
    jj_consume_token(CURRENT);
    jj_consume_token(USER);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:
    case YIELD:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case YIELD:{
        yield = YieldClause();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case RETURN:{
          returnClause = ReturnClause();
          break;
          }
        default:
          jj_la1[297] = jj_gen;
          ;
        }
        break;
        }
      case WHERE:{
        where = WhereClause();
        break;
        }
      default:
        jj_la1[298] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[299] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.useGraph( astFactory.showCurrentUser( pos( start ), yield, returnClause, where ), useClause );}
    throw new IllegalStateException ("Missing return statement in function");
}

// Privilege commands
  final public 
ADMINISTRATION_COMMAND grantRoleManagement(Token start) throws ParseException {PRIVILEGE_TYPE privilege = null;
    List<SimpleEither<String, PARAMETER>> roles = null;
    privilege = roleManagementPrivilege(start);
    jj_consume_token(TO);
    roles = SymbolicNameOrStringParameterList();
{if ("" != null) return astFactory.grantPrivilege( pos(start), roles, privilege );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND revokeRoleManagement(Token start, boolean revokeGrant, boolean revokeDeny) throws ParseException {PRIVILEGE_TYPE privilege = null;
    List<SimpleEither<String, PARAMETER>> roles = null;
    privilege = roleManagementPrivilege(start);
    jj_consume_token(FROM);
    roles = SymbolicNameOrStringParameterList();
{if ("" != null) return astFactory.revokePrivilege( pos(start), roles, privilege, revokeGrant, revokeDeny );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PRIVILEGE_TYPE roleManagementPrivilege(Token start) throws ParseException {List<SimpleEither<String, PARAMETER>> roles = null;
    jj_consume_token(MANAGEMENT);
    jj_consume_token(ON);
    jj_consume_token(DBMS);
{if ("" != null) return astFactory.dbmsPrivilege( pos(start), astFactory.privilegeAction( ActionType.ROLE_ALL ), astFactory.allQualifier() );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND grantPrivilege(Token start) throws ParseException, Exception {List<SimpleEither<String, PARAMETER>> roles = null;
    PRIVILEGE_TYPE privilege = null;
    privilege = privilege(start);
    jj_consume_token(TO);
    roles = SymbolicNameOrStringParameterList();
{if ("" != null) return astFactory.grantPrivilege( pos(start), roles, privilege );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND DenyPrivilege() throws ParseException, Exception {Token start;
    List<SimpleEither<String, PARAMETER>> roles = null;
    PRIVILEGE_TYPE privilege = null;
    start = jj_consume_token(DENY);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ACCESS:
    case ALIAS:
    case ALL:
    case ALTER:
    case ASSIGN:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CREATE:
    case DATABASE:
    case DELETE:
    case DROP:
    case IMPERSONATE:
    case INDEX:
    case INDEXES:
    case MATCH:
    case MERGE:
    case NAME:
    case PRIVILEGE:
    case READ:
    case RENAME:
    case REMOVE:
    case SET:
    case SHOW:
    case START:
    case STOP:
    case TERMINATE:
    case TRANSACTION:
    case TRAVERSE:
    case USER:
    case WRITE:{
      privilege = privilege(start);
      break;
      }
    case ROLE:{
      jj_consume_token(ROLE);
      privilege = roleManagementPrivilege(start);
      break;
      }
    default:
      jj_la1[300] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(TO);
    roles = SymbolicNameOrStringParameterList();
{if ("" != null) return astFactory.denyPrivilege( pos(start), roles, privilege );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND RevokePrivilege(Token start, boolean revokeGrant, boolean revokeDeny) throws ParseException, Exception {List<SimpleEither<String, PARAMETER>> roles = null;
    PRIVILEGE_TYPE privilege = null;
    privilege = privilege(start);
    jj_consume_token(FROM);
    roles = SymbolicNameOrStringParameterList();
{if ("" != null) return astFactory.revokePrivilege( pos(start), roles, privilege, revokeGrant, revokeDeny );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PRIVILEGE_TYPE privilege(Token start) throws ParseException, Exception {PRIVILEGE_TYPE privilege = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ALL:{
      privilege = allPrivilege(start);
      break;
      }
    case CREATE:{
      privilege = createPrivilege(start);
      break;
      }
    case DROP:{
      privilege = dropPrivilege(start);
      break;
      }
    case SHOW:{
      privilege = showPrivilege(start);
      break;
      }
    case SET:{
      privilege = setPrivilege(start);
      break;
      }
    case REMOVE:{
      privilege = removePrivilege(start);
      break;
      }
    case ACCESS:
    case CONSTRAINT:
    case CONSTRAINTS:
    case INDEX:
    case INDEXES:
    case NAME:
    case START:
    case STOP:
    case TERMINATE:
    case TRANSACTION:{
      privilege = databasePrivilege(start);
      break;
      }
    case ALIAS:
    case ALTER:
    case ASSIGN:
    case DATABASE:
    case IMPERSONATE:
    case PRIVILEGE:
    case RENAME:
    case USER:{
      privilege = dbmsPrivilege(start);
      break;
      }
    case WRITE:{
      privilege = writePrivilege(start);
      break;
      }
    case DELETE:
    case MERGE:{
      privilege = qualifiedGraphPrivileges(start);
      break;
      }
    case MATCH:
    case READ:
    case TRAVERSE:{
      privilege = qualifiedGraphPrivilegesWithProperty(start);
      break;
      }
    default:
      jj_la1[301] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return privilege;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PRIVILEGE_TYPE allPrivilege(Token start) throws ParseException, Exception {ADMINISTRATION_ACTION action = null;
    List<SimpleEither<String, PARAMETER>> names = null;
    boolean isAll = false;
    String type = null;
    Token t = null;
    ScopeType scopeType = ScopeType.NAMED;
    jj_consume_token(ALL);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DATABASE:
    case DBMS:
    case GRAPH:
    case PRIVILEGES:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DATABASE:
      case DBMS:
      case GRAPH:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case DBMS:{
          jj_consume_token(DBMS);
type = "DBMS";
          break;
          }
        case GRAPH:{
          jj_consume_token(GRAPH);
type = "GRAPH";
          break;
          }
        case DATABASE:{
          jj_consume_token(DATABASE);
type = "DATABASE";
          break;
          }
        default:
          jj_la1[302] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[303] = jj_gen;
        ;
      }
      jj_consume_token(PRIVILEGES);
      break;
      }
    default:
      jj_la1[304] = jj_gen;
      ;
    }
    jj_consume_token(ON);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DEFAULT_TOKEN:{
      t = jj_consume_token(DEFAULT_TOKEN);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case GRAPH:{
        jj_consume_token(GRAPH);
assertValidType( t, type, "GRAPH" );
                 {if ("" != null) return astFactory.graphPrivilege( pos(start), astFactory.privilegeAction( ActionType.GRAPH_ALL ), astFactory.graphScopes( pos( t ), null, ScopeType.DEFAULT ), null, astFactory.allQualifier() );}
        break;
        }
      case DATABASE:{
        jj_consume_token(DATABASE);
assertValidType( t, type, "DATABASE" );
                {if ("" != null) return astFactory.databasePrivilege( pos(start), astFactory.privilegeAction( ActionType.DATABASE_ALL ), astFactory.databaseScopes( pos( t ), null, ScopeType.DEFAULT ), astFactory.allDatabasesQualifier() );}
        break;
        }
      default:
        jj_la1[305] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case HOME:{
      t = jj_consume_token(HOME);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case GRAPH:{
        jj_consume_token(GRAPH);
assertValidType( t, type, "GRAPH" );
                {if ("" != null) return astFactory.graphPrivilege( pos(start), astFactory.privilegeAction( ActionType.GRAPH_ALL ), astFactory.graphScopes( pos( t ), null, ScopeType.HOME ), null, astFactory.allQualifier() );}
        break;
        }
      case DATABASE:{
        jj_consume_token(DATABASE);
assertValidType( t, type, "DATABASE" );
                {if ("" != null) return astFactory.databasePrivilege( pos(start), astFactory.privilegeAction( ActionType.DATABASE_ALL ), astFactory.databaseScopes( pos( t ), null, ScopeType.HOME ), astFactory.allDatabasesQualifier() );}
        break;
        }
      default:
        jj_la1[306] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case DBMS:{
      t = jj_consume_token(DBMS);
assertValidType( t, type, "DBMS" );
            {if ("" != null) return astFactory.dbmsPrivilege( pos(start), astFactory.privilegeAction( ActionType.DBMS_ALL ), astFactory.allQualifier() );}
      break;
      }
    case GRAPH:
    case GRAPHS:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case GRAPH:{
        t = jj_consume_token(GRAPH);
        break;
        }
      case GRAPHS:{
        t = jj_consume_token(GRAPHS);
        break;
        }
      default:
        jj_la1[307] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case TIMES:{
        jj_consume_token(TIMES);
scopeType = ScopeType.ALL;
        break;
        }
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case AS:
      case ASC:
      case ASSERT:
      case ASSIGN:
      case AT:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASE:
      case CATALOG:
      case CHANGE:
      case COMMIT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DBMS:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESTROY:
      case DETACH:
      case DOLLAR:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DUMP:
      case EACH:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case EXTRACT:
      case FALSE:
      case FIELDTERMINATOR:
      case FILTER:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case HEADERS:
      case HOME:
      case IF:
      case IN:
      case INDEX:
      case INDEXES:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LIMITROWS:
      case LOAD:
      case LOOKUP:
      case MANAGEMENT:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NEW:
      case NODE:
      case NODES:
      case NONE:
      case NOT:
      case NOWAIT:
      case NULL:
      case OF:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTY:
      case RANGE:
      case READ:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REQUIRE:
      case REQUIRED:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDS:
      case SEEK:
      case SET:
      case SHORTEST_PATH:
      case SHOW:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TO:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRUE:
      case TYPE:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNWIND:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VERBOSE:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WRITE:
      case XOR:
      case YIELD:
      case IDENTIFIER:{
        names = SymbolicDatabaseNameStringOrParameterList();
        break;
        }
      default:
        jj_la1[308] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
assertValidType( t, type, "GRAPH" );
            {if ("" != null) return astFactory.graphPrivilege( pos(start), astFactory.privilegeAction( ActionType.GRAPH_ALL ), astFactory.graphScopes( pos( t ), names, scopeType ), null, astFactory.allQualifier() );}
      break;
      }
    case DATABASE:
    case DATABASES:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DATABASE:{
        t = jj_consume_token(DATABASE);
        break;
        }
      case DATABASES:{
        t = jj_consume_token(DATABASES);
        break;
        }
      default:
        jj_la1[309] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case TIMES:{
        jj_consume_token(TIMES);
scopeType = ScopeType.ALL;
        break;
        }
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case AS:
      case ASC:
      case ASSERT:
      case ASSIGN:
      case AT:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASE:
      case CATALOG:
      case CHANGE:
      case COMMIT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DBMS:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESTROY:
      case DETACH:
      case DOLLAR:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DUMP:
      case EACH:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case EXTRACT:
      case FALSE:
      case FIELDTERMINATOR:
      case FILTER:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case HEADERS:
      case HOME:
      case IF:
      case IN:
      case INDEX:
      case INDEXES:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LIMITROWS:
      case LOAD:
      case LOOKUP:
      case MANAGEMENT:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NEW:
      case NODE:
      case NODES:
      case NONE:
      case NOT:
      case NOWAIT:
      case NULL:
      case OF:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTY:
      case RANGE:
      case READ:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REQUIRE:
      case REQUIRED:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDS:
      case SEEK:
      case SET:
      case SHORTEST_PATH:
      case SHOW:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TO:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRUE:
      case TYPE:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNWIND:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VERBOSE:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WRITE:
      case XOR:
      case YIELD:
      case IDENTIFIER:{
        names = SymbolicDatabaseNameStringOrParameterList();
        break;
        }
      default:
        jj_la1[310] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
assertValidType( t, type, "DATABASE" );
            {if ("" != null) return astFactory.databasePrivilege( pos(start), astFactory.privilegeAction( ActionType.DATABASE_ALL ), astFactory.databaseScopes( pos( t ), names, scopeType ), astFactory.allDatabasesQualifier() );}
      break;
      }
    default:
      jj_la1[311] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PRIVILEGE_TYPE createPrivilege(Token start) throws ParseException {PRIVILEGE_TYPE privilege = null;
    ADMINISTRATION_ACTION action = null;
    List<DATABASE_SCOPE> databases = null;
    List<GRAPH_SCOPE> graphs = null;
    List<PRIVILEGE_QUALIFIER> qualifier = new ArrayList<>();
    jj_consume_token(CREATE);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case CONSTRAINT:
    case CONSTRAINTS:
    case INDEX:
    case INDEXES:
    case NEW:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case INDEX:
      case INDEXES:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case INDEX:{
          jj_consume_token(INDEX);
          break;
          }
        case INDEXES:{
          jj_consume_token(INDEXES);
          break;
          }
        default:
          jj_la1[312] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
action = astFactory.privilegeAction( ActionType.INDEX_CREATE );
        break;
        }
      case CONSTRAINT:
      case CONSTRAINTS:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case CONSTRAINT:{
          jj_consume_token(CONSTRAINT);
          break;
          }
        case CONSTRAINTS:{
          jj_consume_token(CONSTRAINTS);
          break;
          }
        default:
          jj_la1[313] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
action = astFactory.privilegeAction( ActionType.CONSTRAINT_CREATE );
        break;
        }
      case NEW:{
        jj_consume_token(NEW);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case LABEL:
        case LABELS:
        case NODE:{
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case NODE:{
            jj_consume_token(NODE);
            break;
            }
          default:
            jj_la1[314] = jj_gen;
            ;
          }
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case LABEL:{
            jj_consume_token(LABEL);
            break;
            }
          case LABELS:{
            jj_consume_token(LABELS);
            break;
            }
          default:
            jj_la1[315] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
action = astFactory.privilegeAction( ActionType.CREATE_LABEL );
          break;
          }
        case RELATIONSHIP:
        case TYPE:
        case TYPES:{
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case RELATIONSHIP:{
            jj_consume_token(RELATIONSHIP);
            break;
            }
          default:
            jj_la1[316] = jj_gen;
            ;
          }
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case TYPE:{
            jj_consume_token(TYPE);
            break;
            }
          case TYPES:{
            jj_consume_token(TYPES);
            break;
            }
          default:
            jj_la1[317] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
action = astFactory.privilegeAction( ActionType.CREATE_RELTYPE );
          break;
          }
        case NAME:
        case NAMES:
        case PROPERTY:{
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case PROPERTY:{
            jj_consume_token(PROPERTY);
            break;
            }
          default:
            jj_la1[318] = jj_gen;
            ;
          }
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case NAME:{
            jj_consume_token(NAME);
            break;
            }
          case NAMES:{
            jj_consume_token(NAMES);
            break;
            }
          default:
            jj_la1[319] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
action = astFactory.privilegeAction( ActionType.CREATE_PROPERTYKEY );
          break;
          }
        default:
          jj_la1[320] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[321] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(ON);
      databases = DatabaseScopeList();
privilege = astFactory.databasePrivilege( pos(start), action, databases, astFactory.allDatabasesQualifier() );
      break;
      }
    case ALIAS:
    case DATABASE:
    case ROLE:
    case USER:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DATABASE:{
        jj_consume_token(DATABASE);
action = astFactory.privilegeAction( ActionType.DATABASE_CREATE );
        break;
        }
      case ALIAS:{
        jj_consume_token(ALIAS);
action = astFactory.privilegeAction( ActionType.ALIAS_CREATE );
        break;
        }
      case ROLE:{
        jj_consume_token(ROLE);
action = astFactory.privilegeAction( ActionType.ROLE_CREATE );
        break;
        }
      case USER:{
        jj_consume_token(USER);
action = astFactory.privilegeAction( ActionType.USER_CREATE );
        break;
        }
      default:
        jj_la1[322] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(ON);
      jj_consume_token(DBMS);
privilege = astFactory.dbmsPrivilege( pos(start), action,  astFactory.allQualifier() );
      break;
      }
    case ON:{
      jj_consume_token(ON);
      graphs = graphScopeList();
      qualifier = graphQualifier();
privilege = astFactory.graphPrivilege( pos(start), astFactory.privilegeAction( ActionType.GRAPH_CREATE ), graphs, null, qualifier );
      break;
      }
    default:
      jj_la1[323] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return privilege;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PRIVILEGE_TYPE dropPrivilege(Token start) throws ParseException {PRIVILEGE_TYPE privilege = null;
    ADMINISTRATION_ACTION action = null;
    List<DATABASE_SCOPE> databases = null;
    jj_consume_token(DROP);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case CONSTRAINT:
    case CONSTRAINTS:
    case INDEX:
    case INDEXES:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case INDEX:
      case INDEXES:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case INDEX:{
          jj_consume_token(INDEX);
          break;
          }
        case INDEXES:{
          jj_consume_token(INDEXES);
          break;
          }
        default:
          jj_la1[324] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
action = astFactory.privilegeAction( ActionType.INDEX_DROP );
        break;
        }
      case CONSTRAINT:
      case CONSTRAINTS:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case CONSTRAINT:{
          jj_consume_token(CONSTRAINT);
          break;
          }
        case CONSTRAINTS:{
          jj_consume_token(CONSTRAINTS);
          break;
          }
        default:
          jj_la1[325] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
action = astFactory.privilegeAction( ActionType.CONSTRAINT_DROP );
        break;
        }
      default:
        jj_la1[326] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(ON);
      databases = DatabaseScopeList();
privilege = astFactory.databasePrivilege( pos(start), action, databases, astFactory.allDatabasesQualifier() );
      break;
      }
    case ALIAS:
    case DATABASE:
    case ROLE:
    case USER:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DATABASE:{
        jj_consume_token(DATABASE);
action = astFactory.privilegeAction( ActionType.DATABASE_DROP );
        break;
        }
      case ALIAS:{
        jj_consume_token(ALIAS);
action = astFactory.privilegeAction( ActionType.ALIAS_DROP );
        break;
        }
      case ROLE:{
        jj_consume_token(ROLE);
action = astFactory.privilegeAction( ActionType.ROLE_DROP );
        break;
        }
      case USER:{
        jj_consume_token(USER);
action = astFactory.privilegeAction( ActionType.USER_DROP );
        break;
        }
      default:
        jj_la1[327] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(ON);
      jj_consume_token(DBMS);
privilege = astFactory.dbmsPrivilege( pos(start), action, astFactory.allQualifier() );
      break;
      }
    default:
      jj_la1[328] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return privilege;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PRIVILEGE_TYPE showPrivilege(Token start) throws ParseException {PRIVILEGE_TYPE privilege = null;
    ADMINISTRATION_ACTION action = null;
    List<DATABASE_SCOPE> databases = null;
    List<PRIVILEGE_QUALIFIER> qualifier = astFactory.allDatabasesQualifier();
    List<SimpleEither<String, PARAMETER>>qualifiers = null;
    jj_consume_token(SHOW);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case CONSTRAINT:
    case CONSTRAINTS:
    case INDEX:
    case INDEXES:
    case TRANSACTION:
    case TRANSACTIONS:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case INDEX:
      case INDEXES:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case INDEX:{
          jj_consume_token(INDEX);
          break;
          }
        case INDEXES:{
          jj_consume_token(INDEXES);
          break;
          }
        default:
          jj_la1[329] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
action = astFactory.privilegeAction( ActionType.INDEX_SHOW );
        break;
        }
      case CONSTRAINT:
      case CONSTRAINTS:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case CONSTRAINT:{
          jj_consume_token(CONSTRAINT);
          break;
          }
        case CONSTRAINTS:{
          jj_consume_token(CONSTRAINTS);
          break;
          }
        default:
          jj_la1[330] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
action = astFactory.privilegeAction( ActionType.CONSTRAINT_SHOW );
        break;
        }
      case TRANSACTION:
      case TRANSACTIONS:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case TRANSACTION:{
          jj_consume_token(TRANSACTION);
          break;
          }
        case TRANSACTIONS:{
          jj_consume_token(TRANSACTIONS);
          break;
          }
        default:
          jj_la1[331] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
action = astFactory.privilegeAction( ActionType.TRANSACTION_SHOW ); qualifier = astFactory.allUsersQualifier();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case LPAREN:{
          jj_consume_token(LPAREN);
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case TIMES:{
            jj_consume_token(TIMES);
            break;
            }
          case ESCAPED_SYMBOLIC_NAME:
          case ACCESS:
          case ACTIVE:
          case ALIAS:
          case ALIASES:
          case ALL_SHORTEST_PATH:
          case ALL:
          case ALTER:
          case AND:
          case ANY:
          case AS:
          case ASC:
          case ASSERT:
          case ASSIGN:
          case AT:
          case BRIEF:
          case BTREE:
          case BUILT:
          case BY:
          case CALL:
          case CASE:
          case CATALOG:
          case CHANGE:
          case COMMIT:
          case CONSTRAINT:
          case CONSTRAINTS:
          case CONTAINS:
          case COPY:
          case COUNT:
          case CREATE:
          case CSV:
          case CURRENT:
          case DATA:
          case DATABASE:
          case DATABASES:
          case DBMS:
          case DEFAULT_TOKEN:
          case DEFINED:
          case DELETE:
          case DENY:
          case DESC:
          case DESTROY:
          case DETACH:
          case DOLLAR:
          case DISTINCT:
          case DRIVER:
          case DROP:
          case DUMP:
          case EACH:
          case ELEMENT:
          case ELEMENTS:
          case ELSE:
          case ENCRYPTED:
          case END:
          case ENDS:
          case EXECUTABLE:
          case EXIST:
          case EXISTENCE:
          case EXISTS:
          case EXTRACT:
          case FALSE:
          case FIELDTERMINATOR:
          case FILTER:
          case FOR:
          case FOREACH:
          case FROM:
          case FULLTEXT:
          case FUNCTION:
          case FUNCTIONS:
          case GRANT:
          case GRAPH:
          case GRAPHS:
          case HEADERS:
          case HOME:
          case IF:
          case IN:
          case INDEX:
          case INDEXES:
          case IS:
          case JOIN:
          case KEY:
          case LABEL:
          case LABELS:
          case LIMITROWS:
          case LOAD:
          case LOOKUP:
          case MANAGEMENT:
          case MATCH:
          case MERGE:
          case NAME:
          case NAMES:
          case NEW:
          case NODE:
          case NODES:
          case NONE:
          case NOT:
          case NOWAIT:
          case NULL:
          case OF:
          case ON:
          case ONLY:
          case OPTIONAL:
          case OPTIONS:
          case OR:
          case ORDER:
          case OUTPUT:
          case PASSWORD:
          case PASSWORDS:
          case PERIODIC:
          case PLAINTEXT:
          case POINT:
          case POPULATED:
          case PRIVILEGE:
          case PRIVILEGES:
          case PROCEDURE:
          case PROCEDURES:
          case PROPERTY:
          case RANGE:
          case READ:
          case REDUCE:
          case RENAME:
          case REL:
          case RELATIONSHIP:
          case RELATIONSHIPS:
          case REMOVE:
          case REPLACE:
          case REQUIRE:
          case REQUIRED:
          case RETURN:
          case REVOKE:
          case ROLE:
          case ROLES:
          case ROW:
          case ROWS:
          case SCAN:
          case SEC:
          case SECOND:
          case SECONDS:
          case SEEK:
          case SET:
          case SHORTEST_PATH:
          case SHOW:
          case SINGLE:
          case SKIPROWS:
          case START:
          case STARTS:
          case STATUS:
          case STOP:
          case SUSPENDED:
          case TARGET:
          case TERMINATE:
          case TEXT:
          case THEN:
          case TO:
          case TRANSACTION:
          case TRANSACTIONS:
          case TRAVERSE:
          case TRUE:
          case TYPE:
          case TYPES:
          case UNION:
          case UNIQUE:
          case UNWIND:
          case USE:
          case USER:
          case USERS:
          case USING:
          case VERBOSE:
          case WAIT:
          case WHEN:
          case WHERE:
          case WITH:
          case WRITE:
          case XOR:
          case YIELD:
          case IDENTIFIER:{
            qualifiers = SymbolicNameOrStringParameterList();
qualifier = astFactory.userQualifier(qualifiers);
            break;
            }
          default:
            jj_la1[332] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          jj_consume_token(RPAREN);
          break;
          }
        default:
          jj_la1[333] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[334] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(ON);
      databases = DatabaseScopeList();
privilege = astFactory.databasePrivilege( pos(start), action, databases, qualifier );
      break;
      }
    case ALIAS:
    case PRIVILEGE:
    case ROLE:
    case USER:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ALIAS:{
        jj_consume_token(ALIAS);
action = astFactory.privilegeAction( ActionType.ALIAS_SHOW );
        break;
        }
      case PRIVILEGE:{
        jj_consume_token(PRIVILEGE);
action = astFactory.privilegeAction( ActionType.PRIVILEGE_SHOW );
        break;
        }
      case ROLE:{
        jj_consume_token(ROLE);
action = astFactory.privilegeAction( ActionType.ROLE_SHOW );
        break;
        }
      case USER:{
        jj_consume_token(USER);
action = astFactory.privilegeAction( ActionType.USER_SHOW );
        break;
        }
      default:
        jj_la1[335] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(ON);
      jj_consume_token(DBMS);
privilege = astFactory.dbmsPrivilege( pos(start), action, astFactory.allQualifier() );
      break;
      }
    default:
      jj_la1[336] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return privilege;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PRIVILEGE_TYPE setPrivilege(Token start) throws ParseException {PRIVILEGE_TYPE privilege = null;
    ADMINISTRATION_ACTION action = null;
    List<GRAPH_SCOPE> graphs = null;
    PRIVILEGE_RESOURCE resource = null;
    List<PRIVILEGE_QUALIFIER> qualifier = null;
    jj_consume_token(SET);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DATABASE:
    case PASSWORD:
    case PASSWORDS:
    case USER:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PASSWORD:
      case PASSWORDS:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case PASSWORD:{
          jj_consume_token(PASSWORD);
          break;
          }
        case PASSWORDS:{
          jj_consume_token(PASSWORDS);
          break;
          }
        default:
          jj_la1[337] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
action = astFactory.privilegeAction( ActionType.USER_PASSWORD );
        break;
        }
      case USER:{
        jj_consume_token(USER);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case STATUS:{
          jj_consume_token(STATUS);
action = astFactory.privilegeAction( ActionType.USER_STATUS );
          break;
          }
        case HOME:{
          jj_consume_token(HOME);
          jj_consume_token(DATABASE);
action = astFactory.privilegeAction( ActionType.USER_HOME );
          break;
          }
        default:
          jj_la1[338] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case DATABASE:{
        jj_consume_token(DATABASE);
        jj_consume_token(ACCESS);
action = astFactory.privilegeAction( ActionType.SET_DATABASE_ACCESS);
        break;
        }
      default:
        jj_la1[339] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(ON);
      jj_consume_token(DBMS);
privilege = astFactory.dbmsPrivilege( pos(start), action, astFactory.allQualifier() );
      break;
      }
    case LABEL:
    case PROPERTY:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LABEL:{
        jj_consume_token(LABEL);
        resource = labelResource();
        jj_consume_token(ON);
        graphs = graphScopeList();
privilege = astFactory.graphPrivilege( pos(start), astFactory.privilegeAction( ActionType.GRAPH_LABEL_SET ), graphs, resource, List.of( astFactory.allLabelsQualifier( pos(start) ) ) );
        break;
        }
      case PROPERTY:{
        jj_consume_token(PROPERTY);
        resource = propertyResource();
        jj_consume_token(ON);
        graphs = graphScopeList();
        qualifier = graphQualifier();
privilege = astFactory.graphPrivilege( pos(start), astFactory.privilegeAction( ActionType.GRAPH_PROPERTY_SET ), graphs, resource, qualifier );
        break;
        }
      default:
        jj_la1[340] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[341] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return privilege;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PRIVILEGE_TYPE removePrivilege(Token start) throws ParseException {PRIVILEGE_TYPE privilege = null;
    List<GRAPH_SCOPE> graphs = null;
    PRIVILEGE_RESOURCE resource = null;
    ADMINISTRATION_ACTION action = null;
    jj_consume_token(REMOVE);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case PRIVILEGE:
    case ROLE:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PRIVILEGE:{
        jj_consume_token(PRIVILEGE);
action = astFactory.privilegeAction( ActionType.PRIVILEGE_REMOVE );
        break;
        }
      case ROLE:{
        jj_consume_token(ROLE);
action = astFactory.privilegeAction( ActionType.ROLE_REMOVE );
        break;
        }
      default:
        jj_la1[342] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(ON);
      jj_consume_token(DBMS);
privilege = astFactory.dbmsPrivilege( pos(start), action, astFactory.allQualifier() );
      break;
      }
    case LABEL:{
      jj_consume_token(LABEL);
      resource = labelResource();
      jj_consume_token(ON);
      graphs = graphScopeList();
privilege = astFactory.graphPrivilege( pos(start), astFactory.privilegeAction( ActionType.GRAPH_LABEL_REMOVE ), graphs, resource, List.of( astFactory.allLabelsQualifier( pos(start) ) ) );
      break;
      }
    default:
      jj_la1[343] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return privilege;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PRIVILEGE_TYPE writePrivilege(Token start) throws ParseException {List<GRAPH_SCOPE> graphs = null;
    List<SimpleEither<String, PARAMETER>> qualifiers = null;
    jj_consume_token(WRITE);
    jj_consume_token(ON);
    graphs = graphScopeList();
{if ("" != null) return astFactory.graphPrivilege( pos(start), astFactory.privilegeAction( ActionType.GRAPH_WRITE ), graphs, null, List.of( astFactory.allElementsQualifier( pos(start) ) ) );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PRIVILEGE_TYPE databasePrivilege(Token start) throws ParseException {ADMINISTRATION_ACTION action = null;
    List<DATABASE_SCOPE> databases = null;
    List<PRIVILEGE_QUALIFIER> qualifier = astFactory.allDatabasesQualifier();
    List<SimpleEither<String, PARAMETER>>qualifiers = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ACCESS:{
      jj_consume_token(ACCESS);
action = astFactory.privilegeAction( ActionType.ACCESS );
      break;
      }
    case START:{
      jj_consume_token(START);
action = astFactory.privilegeAction( ActionType.DATABASE_START );
      break;
      }
    case STOP:{
      jj_consume_token(STOP);
action = astFactory.privilegeAction( ActionType.DATABASE_STOP );
      break;
      }
    case INDEX:
    case INDEXES:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case INDEX:{
        jj_consume_token(INDEX);
        break;
        }
      case INDEXES:{
        jj_consume_token(INDEXES);
        break;
        }
      default:
        jj_la1[344] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MANAGEMENT:{
        jj_consume_token(MANAGEMENT);
        break;
        }
      default:
        jj_la1[345] = jj_gen;
        ;
      }
action = astFactory.privilegeAction( ActionType.INDEX_ALL );
      break;
      }
    case CONSTRAINT:
    case CONSTRAINTS:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case CONSTRAINT:{
        jj_consume_token(CONSTRAINT);
        break;
        }
      case CONSTRAINTS:{
        jj_consume_token(CONSTRAINTS);
        break;
        }
      default:
        jj_la1[346] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MANAGEMENT:{
        jj_consume_token(MANAGEMENT);
        break;
        }
      default:
        jj_la1[347] = jj_gen;
        ;
      }
action = astFactory.privilegeAction( ActionType.CONSTRAINT_ALL );
      break;
      }
    case TRANSACTION:{
      jj_consume_token(TRANSACTION);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MANAGEMENT:{
        jj_consume_token(MANAGEMENT);
        break;
        }
      default:
        jj_la1[348] = jj_gen;
        ;
      }
qualifier = astFactory.allUsersQualifier();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LPAREN:{
        jj_consume_token(LPAREN);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case TIMES:{
          jj_consume_token(TIMES);
          break;
          }
        case ESCAPED_SYMBOLIC_NAME:
        case ACCESS:
        case ACTIVE:
        case ALIAS:
        case ALIASES:
        case ALL_SHORTEST_PATH:
        case ALL:
        case ALTER:
        case AND:
        case ANY:
        case AS:
        case ASC:
        case ASSERT:
        case ASSIGN:
        case AT:
        case BRIEF:
        case BTREE:
        case BUILT:
        case BY:
        case CALL:
        case CASE:
        case CATALOG:
        case CHANGE:
        case COMMIT:
        case CONSTRAINT:
        case CONSTRAINTS:
        case CONTAINS:
        case COPY:
        case COUNT:
        case CREATE:
        case CSV:
        case CURRENT:
        case DATA:
        case DATABASE:
        case DATABASES:
        case DBMS:
        case DEFAULT_TOKEN:
        case DEFINED:
        case DELETE:
        case DENY:
        case DESC:
        case DESTROY:
        case DETACH:
        case DOLLAR:
        case DISTINCT:
        case DRIVER:
        case DROP:
        case DUMP:
        case EACH:
        case ELEMENT:
        case ELEMENTS:
        case ELSE:
        case ENCRYPTED:
        case END:
        case ENDS:
        case EXECUTABLE:
        case EXIST:
        case EXISTENCE:
        case EXISTS:
        case EXTRACT:
        case FALSE:
        case FIELDTERMINATOR:
        case FILTER:
        case FOR:
        case FOREACH:
        case FROM:
        case FULLTEXT:
        case FUNCTION:
        case FUNCTIONS:
        case GRANT:
        case GRAPH:
        case GRAPHS:
        case HEADERS:
        case HOME:
        case IF:
        case IN:
        case INDEX:
        case INDEXES:
        case IS:
        case JOIN:
        case KEY:
        case LABEL:
        case LABELS:
        case LIMITROWS:
        case LOAD:
        case LOOKUP:
        case MANAGEMENT:
        case MATCH:
        case MERGE:
        case NAME:
        case NAMES:
        case NEW:
        case NODE:
        case NODES:
        case NONE:
        case NOT:
        case NOWAIT:
        case NULL:
        case OF:
        case ON:
        case ONLY:
        case OPTIONAL:
        case OPTIONS:
        case OR:
        case ORDER:
        case OUTPUT:
        case PASSWORD:
        case PASSWORDS:
        case PERIODIC:
        case PLAINTEXT:
        case POINT:
        case POPULATED:
        case PRIVILEGE:
        case PRIVILEGES:
        case PROCEDURE:
        case PROCEDURES:
        case PROPERTY:
        case RANGE:
        case READ:
        case REDUCE:
        case RENAME:
        case REL:
        case RELATIONSHIP:
        case RELATIONSHIPS:
        case REMOVE:
        case REPLACE:
        case REQUIRE:
        case REQUIRED:
        case RETURN:
        case REVOKE:
        case ROLE:
        case ROLES:
        case ROW:
        case ROWS:
        case SCAN:
        case SEC:
        case SECOND:
        case SECONDS:
        case SEEK:
        case SET:
        case SHORTEST_PATH:
        case SHOW:
        case SINGLE:
        case SKIPROWS:
        case START:
        case STARTS:
        case STATUS:
        case STOP:
        case SUSPENDED:
        case TARGET:
        case TERMINATE:
        case TEXT:
        case THEN:
        case TO:
        case TRANSACTION:
        case TRANSACTIONS:
        case TRAVERSE:
        case TRUE:
        case TYPE:
        case TYPES:
        case UNION:
        case UNIQUE:
        case UNWIND:
        case USE:
        case USER:
        case USERS:
        case USING:
        case VERBOSE:
        case WAIT:
        case WHEN:
        case WHERE:
        case WITH:
        case WRITE:
        case XOR:
        case YIELD:
        case IDENTIFIER:{
          qualifiers = SymbolicNameOrStringParameterList();
qualifier = astFactory.userQualifier(qualifiers);
          break;
          }
        default:
          jj_la1[349] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(RPAREN);
        break;
        }
      default:
        jj_la1[350] = jj_gen;
        ;
      }
action = astFactory.privilegeAction( ActionType.TRANSACTION_ALL );
      break;
      }
    case TERMINATE:{
      jj_consume_token(TERMINATE);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case TRANSACTION:{
        jj_consume_token(TRANSACTION);
        break;
        }
      case TRANSACTIONS:{
        jj_consume_token(TRANSACTIONS);
        break;
        }
      default:
        jj_la1[351] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
qualifier = astFactory.allUsersQualifier();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LPAREN:{
        jj_consume_token(LPAREN);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case TIMES:{
          jj_consume_token(TIMES);
          break;
          }
        case ESCAPED_SYMBOLIC_NAME:
        case ACCESS:
        case ACTIVE:
        case ALIAS:
        case ALIASES:
        case ALL_SHORTEST_PATH:
        case ALL:
        case ALTER:
        case AND:
        case ANY:
        case AS:
        case ASC:
        case ASSERT:
        case ASSIGN:
        case AT:
        case BRIEF:
        case BTREE:
        case BUILT:
        case BY:
        case CALL:
        case CASE:
        case CATALOG:
        case CHANGE:
        case COMMIT:
        case CONSTRAINT:
        case CONSTRAINTS:
        case CONTAINS:
        case COPY:
        case COUNT:
        case CREATE:
        case CSV:
        case CURRENT:
        case DATA:
        case DATABASE:
        case DATABASES:
        case DBMS:
        case DEFAULT_TOKEN:
        case DEFINED:
        case DELETE:
        case DENY:
        case DESC:
        case DESTROY:
        case DETACH:
        case DOLLAR:
        case DISTINCT:
        case DRIVER:
        case DROP:
        case DUMP:
        case EACH:
        case ELEMENT:
        case ELEMENTS:
        case ELSE:
        case ENCRYPTED:
        case END:
        case ENDS:
        case EXECUTABLE:
        case EXIST:
        case EXISTENCE:
        case EXISTS:
        case EXTRACT:
        case FALSE:
        case FIELDTERMINATOR:
        case FILTER:
        case FOR:
        case FOREACH:
        case FROM:
        case FULLTEXT:
        case FUNCTION:
        case FUNCTIONS:
        case GRANT:
        case GRAPH:
        case GRAPHS:
        case HEADERS:
        case HOME:
        case IF:
        case IN:
        case INDEX:
        case INDEXES:
        case IS:
        case JOIN:
        case KEY:
        case LABEL:
        case LABELS:
        case LIMITROWS:
        case LOAD:
        case LOOKUP:
        case MANAGEMENT:
        case MATCH:
        case MERGE:
        case NAME:
        case NAMES:
        case NEW:
        case NODE:
        case NODES:
        case NONE:
        case NOT:
        case NOWAIT:
        case NULL:
        case OF:
        case ON:
        case ONLY:
        case OPTIONAL:
        case OPTIONS:
        case OR:
        case ORDER:
        case OUTPUT:
        case PASSWORD:
        case PASSWORDS:
        case PERIODIC:
        case PLAINTEXT:
        case POINT:
        case POPULATED:
        case PRIVILEGE:
        case PRIVILEGES:
        case PROCEDURE:
        case PROCEDURES:
        case PROPERTY:
        case RANGE:
        case READ:
        case REDUCE:
        case RENAME:
        case REL:
        case RELATIONSHIP:
        case RELATIONSHIPS:
        case REMOVE:
        case REPLACE:
        case REQUIRE:
        case REQUIRED:
        case RETURN:
        case REVOKE:
        case ROLE:
        case ROLES:
        case ROW:
        case ROWS:
        case SCAN:
        case SEC:
        case SECOND:
        case SECONDS:
        case SEEK:
        case SET:
        case SHORTEST_PATH:
        case SHOW:
        case SINGLE:
        case SKIPROWS:
        case START:
        case STARTS:
        case STATUS:
        case STOP:
        case SUSPENDED:
        case TARGET:
        case TERMINATE:
        case TEXT:
        case THEN:
        case TO:
        case TRANSACTION:
        case TRANSACTIONS:
        case TRAVERSE:
        case TRUE:
        case TYPE:
        case TYPES:
        case UNION:
        case UNIQUE:
        case UNWIND:
        case USE:
        case USER:
        case USERS:
        case USING:
        case VERBOSE:
        case WAIT:
        case WHEN:
        case WHERE:
        case WITH:
        case WRITE:
        case XOR:
        case YIELD:
        case IDENTIFIER:{
          qualifiers = SymbolicNameOrStringParameterList();
qualifier = astFactory.userQualifier(qualifiers);
          break;
          }
        default:
          jj_la1[352] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(RPAREN);
        break;
        }
      default:
        jj_la1[353] = jj_gen;
        ;
      }
action = astFactory.privilegeAction( ActionType.TRANSACTION_TERMINATE );
      break;
      }
    case NAME:{
      jj_consume_token(NAME);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MANAGEMENT:{
        jj_consume_token(MANAGEMENT);
        break;
        }
      default:
        jj_la1[354] = jj_gen;
        ;
      }
action = astFactory.privilegeAction( ActionType.CREATE_TOKEN );
      break;
      }
    default:
      jj_la1[355] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(ON);
    databases = DatabaseScopeList();
{if ("" != null) return astFactory.databasePrivilege( pos(start), action, databases, qualifier );}
    throw new IllegalStateException ("Missing return statement in function");
}

// all dbms privileges apart from EXECUTE PROCEDURE/FUNCTION since we have to solve globbing for that first
  final public PRIVILEGE_TYPE dbmsPrivilege(Token start) throws ParseException {ADMINISTRATION_ACTION action = null;
    List<PRIVILEGE_QUALIFIER> qualifier = astFactory.allQualifier();
    List<SimpleEither<String, PARAMETER>> qualifiers = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ALTER:{
      jj_consume_token(ALTER);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case USER:{
        jj_consume_token(USER);
action = astFactory.privilegeAction( ActionType.USER_ALTER );
        break;
        }
      case DATABASE:{
        jj_consume_token(DATABASE);
action = astFactory.privilegeAction( ActionType.DATABASE_ALTER );
        break;
        }
      case ALIAS:{
        jj_consume_token(ALIAS);
action = astFactory.privilegeAction( ActionType.ALIAS_ALTER );
        break;
        }
      default:
        jj_la1[356] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case ASSIGN:{
      jj_consume_token(ASSIGN);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PRIVILEGE:{
        jj_consume_token(PRIVILEGE);
action = astFactory.privilegeAction( ActionType.PRIVILEGE_ASSIGN );
        break;
        }
      case ROLE:{
        jj_consume_token(ROLE);
action = astFactory.privilegeAction( ActionType.ROLE_ASSIGN );
        break;
        }
      default:
        jj_la1[357] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case DATABASE:{
      jj_consume_token(DATABASE);
      jj_consume_token(MANAGEMENT);
action = astFactory.privilegeAction( ActionType.DATABASE_MANAGEMENT );
      break;
      }
    case ALIAS:{
      jj_consume_token(ALIAS);
      jj_consume_token(MANAGEMENT);
action = astFactory.privilegeAction( ActionType.ALIAS_MANAGEMENT );
      break;
      }
    case PRIVILEGE:{
      jj_consume_token(PRIVILEGE);
      jj_consume_token(MANAGEMENT);
action = astFactory.privilegeAction( ActionType.PRIVILEGE_ALL );
      break;
      }
    case RENAME:{
      jj_consume_token(RENAME);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ROLE:{
        jj_consume_token(ROLE);
action = astFactory.privilegeAction( ActionType.ROLE_RENAME );
        break;
        }
      case USER:{
        jj_consume_token(USER);
action = astFactory.privilegeAction( ActionType.USER_RENAME );
        break;
        }
      default:
        jj_la1[358] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case USER:{
      jj_consume_token(USER);
      jj_consume_token(MANAGEMENT);
action = astFactory.privilegeAction( ActionType.USER_ALL );
      break;
      }
    case IMPERSONATE:{
      jj_consume_token(IMPERSONATE);
qualifier = astFactory.allUsersQualifier();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LPAREN:{
        jj_consume_token(LPAREN);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case TIMES:{
          jj_consume_token(TIMES);
          break;
          }
        case ESCAPED_SYMBOLIC_NAME:
        case ACCESS:
        case ACTIVE:
        case ALIAS:
        case ALIASES:
        case ALL_SHORTEST_PATH:
        case ALL:
        case ALTER:
        case AND:
        case ANY:
        case AS:
        case ASC:
        case ASSERT:
        case ASSIGN:
        case AT:
        case BRIEF:
        case BTREE:
        case BUILT:
        case BY:
        case CALL:
        case CASE:
        case CATALOG:
        case CHANGE:
        case COMMIT:
        case CONSTRAINT:
        case CONSTRAINTS:
        case CONTAINS:
        case COPY:
        case COUNT:
        case CREATE:
        case CSV:
        case CURRENT:
        case DATA:
        case DATABASE:
        case DATABASES:
        case DBMS:
        case DEFAULT_TOKEN:
        case DEFINED:
        case DELETE:
        case DENY:
        case DESC:
        case DESTROY:
        case DETACH:
        case DOLLAR:
        case DISTINCT:
        case DRIVER:
        case DROP:
        case DUMP:
        case EACH:
        case ELEMENT:
        case ELEMENTS:
        case ELSE:
        case ENCRYPTED:
        case END:
        case ENDS:
        case EXECUTABLE:
        case EXIST:
        case EXISTENCE:
        case EXISTS:
        case EXTRACT:
        case FALSE:
        case FIELDTERMINATOR:
        case FILTER:
        case FOR:
        case FOREACH:
        case FROM:
        case FULLTEXT:
        case FUNCTION:
        case FUNCTIONS:
        case GRANT:
        case GRAPH:
        case GRAPHS:
        case HEADERS:
        case HOME:
        case IF:
        case IN:
        case INDEX:
        case INDEXES:
        case IS:
        case JOIN:
        case KEY:
        case LABEL:
        case LABELS:
        case LIMITROWS:
        case LOAD:
        case LOOKUP:
        case MANAGEMENT:
        case MATCH:
        case MERGE:
        case NAME:
        case NAMES:
        case NEW:
        case NODE:
        case NODES:
        case NONE:
        case NOT:
        case NOWAIT:
        case NULL:
        case OF:
        case ON:
        case ONLY:
        case OPTIONAL:
        case OPTIONS:
        case OR:
        case ORDER:
        case OUTPUT:
        case PASSWORD:
        case PASSWORDS:
        case PERIODIC:
        case PLAINTEXT:
        case POINT:
        case POPULATED:
        case PRIVILEGE:
        case PRIVILEGES:
        case PROCEDURE:
        case PROCEDURES:
        case PROPERTY:
        case RANGE:
        case READ:
        case REDUCE:
        case RENAME:
        case REL:
        case RELATIONSHIP:
        case RELATIONSHIPS:
        case REMOVE:
        case REPLACE:
        case REQUIRE:
        case REQUIRED:
        case RETURN:
        case REVOKE:
        case ROLE:
        case ROLES:
        case ROW:
        case ROWS:
        case SCAN:
        case SEC:
        case SECOND:
        case SECONDS:
        case SEEK:
        case SET:
        case SHORTEST_PATH:
        case SHOW:
        case SINGLE:
        case SKIPROWS:
        case START:
        case STARTS:
        case STATUS:
        case STOP:
        case SUSPENDED:
        case TARGET:
        case TERMINATE:
        case TEXT:
        case THEN:
        case TO:
        case TRANSACTION:
        case TRANSACTIONS:
        case TRAVERSE:
        case TRUE:
        case TYPE:
        case TYPES:
        case UNION:
        case UNIQUE:
        case UNWIND:
        case USE:
        case USER:
        case USERS:
        case USING:
        case VERBOSE:
        case WAIT:
        case WHEN:
        case WHERE:
        case WITH:
        case WRITE:
        case XOR:
        case YIELD:
        case IDENTIFIER:{
          qualifiers = SymbolicNameOrStringParameterList();
qualifier = astFactory.userQualifier(qualifiers);
          break;
          }
        default:
          jj_la1[359] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(RPAREN);
        break;
        }
      default:
        jj_la1[360] = jj_gen;
        ;
      }
action = astFactory.privilegeAction( ActionType.USER_IMPERSONATE );
      break;
      }
    default:
      jj_la1[361] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(ON);
    jj_consume_token(DBMS);
{if ("" != null) return astFactory.dbmsPrivilege( pos(start), action, qualifier );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PRIVILEGE_TYPE qualifiedGraphPrivilegesWithProperty(Token start) throws ParseException {ADMINISTRATION_ACTION action = null;
    List<GRAPH_SCOPE> graphs = null;
    List<PRIVILEGE_QUALIFIER> qualifier = null;
    PRIVILEGE_RESOURCE resource = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case TRAVERSE:{
      jj_consume_token(TRAVERSE);
action = astFactory.privilegeAction( ActionType.GRAPH_TRAVERSE );
      break;
      }
    case READ:{
      jj_consume_token(READ);
action = astFactory.privilegeAction( ActionType.GRAPH_READ );
      resource = propertyResource();
      break;
      }
    case MATCH:{
      jj_consume_token(MATCH);
action = astFactory.privilegeAction( ActionType.GRAPH_MATCH );
      resource = propertyResource();
      break;
      }
    default:
      jj_la1[362] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(ON);
    graphs = graphScopeList();
    qualifier = graphQualifier();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LPAREN:{
      jj_consume_token(LPAREN);
      jj_consume_token(TIMES);
      jj_consume_token(RPAREN);
      break;
      }
    default:
      jj_la1[363] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.graphPrivilege( pos(start), action, graphs, resource, qualifier );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PRIVILEGE_TYPE qualifiedGraphPrivileges(Token start) throws ParseException {ADMINISTRATION_ACTION action = null;
    List<GRAPH_SCOPE> graphs = null;
    List<PRIVILEGE_QUALIFIER> qualifier = null;
    PRIVILEGE_RESOURCE resource = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DELETE:{
      jj_consume_token(DELETE);
action = astFactory.privilegeAction( ActionType.GRAPH_DELETE );
      break;
      }
    case MERGE:{
      jj_consume_token(MERGE);
      resource = propertyResource();
action = astFactory.privilegeAction( ActionType.GRAPH_MERGE );
      break;
      }
    default:
      jj_la1[364] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(ON);
    graphs = graphScopeList();
    qualifier = graphQualifier();
{if ("" != null) return astFactory.graphPrivilege( pos(start), action, graphs, resource, qualifier );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PRIVILEGE_RESOURCE labelResource() throws ParseException {List<String> names = null;
    Token t;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case TIMES:{
      jj_consume_token(TIMES);
{if ("" != null) return astFactory.allLabelsResource( pos(token) );}
      break;
      }
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case AS:
    case ASC:
    case ASSERT:
    case ASSIGN:
    case AT:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASE:
    case CATALOG:
    case CHANGE:
    case COMMIT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DBMS:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESTROY:
    case DETACH:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DUMP:
    case EACH:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case EXTRACT:
    case FALSE:
    case FIELDTERMINATOR:
    case FILTER:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case HEADERS:
    case HOME:
    case IF:
    case IN:
    case INDEX:
    case INDEXES:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LIMITROWS:
    case LOAD:
    case LOOKUP:
    case MANAGEMENT:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NEW:
    case NODE:
    case NODES:
    case NONE:
    case NOT:
    case NOWAIT:
    case NULL:
    case OF:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTY:
    case RANGE:
    case READ:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REQUIRE:
    case REQUIRED:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDS:
    case SEEK:
    case SET:
    case SHORTEST_PATH:
    case SHOW:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TO:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRUE:
    case TYPE:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNWIND:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VERBOSE:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WRITE:
    case XOR:
    case YIELD:
    case IDENTIFIER:{
      names = SymbolicNameList1();
{if ("" != null) return astFactory.labelsResource( pos(token), names );}
      break;
      }
    default:
      jj_la1[365] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PRIVILEGE_RESOURCE propertyResource() throws ParseException {List<String> names = null;
    PRIVILEGE_RESOURCE resource = null;
    Token t;
    jj_consume_token(LCURLY);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case TIMES:{
      jj_consume_token(TIMES);
resource = astFactory.allPropertiesResource( pos(token) );
      break;
      }
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case AS:
    case ASC:
    case ASSERT:
    case ASSIGN:
    case AT:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASE:
    case CATALOG:
    case CHANGE:
    case COMMIT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DBMS:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESTROY:
    case DETACH:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DUMP:
    case EACH:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case EXTRACT:
    case FALSE:
    case FIELDTERMINATOR:
    case FILTER:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case HEADERS:
    case HOME:
    case IF:
    case IN:
    case INDEX:
    case INDEXES:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LIMITROWS:
    case LOAD:
    case LOOKUP:
    case MANAGEMENT:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NEW:
    case NODE:
    case NODES:
    case NONE:
    case NOT:
    case NOWAIT:
    case NULL:
    case OF:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTY:
    case RANGE:
    case READ:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REQUIRE:
    case REQUIRED:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDS:
    case SEEK:
    case SET:
    case SHORTEST_PATH:
    case SHOW:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TO:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRUE:
    case TYPE:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNWIND:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VERBOSE:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WRITE:
    case XOR:
    case YIELD:
    case IDENTIFIER:{
      names = SymbolicNameList1();
resource = astFactory.propertiesResource( pos(token), names );
      break;
      }
    default:
      jj_la1[366] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RCURLY);
{if ("" != null) return resource;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<PRIVILEGE_QUALIFIER> graphQualifier() throws ParseException {List<PRIVILEGE_QUALIFIER> qualifier = new ArrayList<>();
    List<String> names = null;
    Token n = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ELEMENT:
    case ELEMENTS:
    case NODE:
    case NODES:
    case RELATIONSHIP:
    case RELATIONSHIPS:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case RELATIONSHIP:
      case RELATIONSHIPS:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case RELATIONSHIP:{
          jj_consume_token(RELATIONSHIP);
          break;
          }
        case RELATIONSHIPS:{
          jj_consume_token(RELATIONSHIPS);
          break;
          }
        default:
          jj_la1[367] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case TIMES:{
          jj_consume_token(TIMES);
qualifier.add( astFactory.allRelationshipsQualifier( pos(token) ) );
          break;
          }
        case ESCAPED_SYMBOLIC_NAME:
        case ACCESS:
        case ACTIVE:
        case ALIAS:
        case ALIASES:
        case ALL_SHORTEST_PATH:
        case ALL:
        case ALTER:
        case AND:
        case ANY:
        case AS:
        case ASC:
        case ASSERT:
        case ASSIGN:
        case AT:
        case BRIEF:
        case BTREE:
        case BUILT:
        case BY:
        case CALL:
        case CASE:
        case CATALOG:
        case CHANGE:
        case COMMIT:
        case CONSTRAINT:
        case CONSTRAINTS:
        case CONTAINS:
        case COPY:
        case COUNT:
        case CREATE:
        case CSV:
        case CURRENT:
        case DATA:
        case DATABASE:
        case DATABASES:
        case DBMS:
        case DEFAULT_TOKEN:
        case DEFINED:
        case DELETE:
        case DENY:
        case DESC:
        case DESTROY:
        case DETACH:
        case DISTINCT:
        case DRIVER:
        case DROP:
        case DUMP:
        case EACH:
        case ELEMENT:
        case ELEMENTS:
        case ELSE:
        case ENCRYPTED:
        case END:
        case ENDS:
        case EXECUTABLE:
        case EXIST:
        case EXISTENCE:
        case EXISTS:
        case EXTRACT:
        case FALSE:
        case FIELDTERMINATOR:
        case FILTER:
        case FOR:
        case FOREACH:
        case FROM:
        case FULLTEXT:
        case FUNCTION:
        case FUNCTIONS:
        case GRANT:
        case GRAPH:
        case GRAPHS:
        case HEADERS:
        case HOME:
        case IF:
        case IN:
        case INDEX:
        case INDEXES:
        case IS:
        case JOIN:
        case KEY:
        case LABEL:
        case LABELS:
        case LIMITROWS:
        case LOAD:
        case LOOKUP:
        case MANAGEMENT:
        case MATCH:
        case MERGE:
        case NAME:
        case NAMES:
        case NEW:
        case NODE:
        case NODES:
        case NONE:
        case NOT:
        case NOWAIT:
        case NULL:
        case OF:
        case ON:
        case ONLY:
        case OPTIONAL:
        case OPTIONS:
        case OR:
        case ORDER:
        case OUTPUT:
        case PASSWORD:
        case PASSWORDS:
        case PERIODIC:
        case PLAINTEXT:
        case POINT:
        case POPULATED:
        case PRIVILEGE:
        case PRIVILEGES:
        case PROCEDURE:
        case PROCEDURES:
        case PROPERTY:
        case RANGE:
        case READ:
        case REDUCE:
        case RENAME:
        case REL:
        case RELATIONSHIP:
        case RELATIONSHIPS:
        case REMOVE:
        case REPLACE:
        case REQUIRE:
        case REQUIRED:
        case RETURN:
        case REVOKE:
        case ROLE:
        case ROLES:
        case ROW:
        case ROWS:
        case SCAN:
        case SEC:
        case SECOND:
        case SECONDS:
        case SEEK:
        case SET:
        case SHORTEST_PATH:
        case SHOW:
        case SINGLE:
        case SKIPROWS:
        case START:
        case STARTS:
        case STATUS:
        case STOP:
        case SUSPENDED:
        case TARGET:
        case TERMINATE:
        case TEXT:
        case THEN:
        case TO:
        case TRANSACTION:
        case TRANSACTIONS:
        case TRAVERSE:
        case TRUE:
        case TYPE:
        case TYPES:
        case UNION:
        case UNIQUE:
        case UNWIND:
        case USE:
        case USER:
        case USERS:
        case USING:
        case VERBOSE:
        case WAIT:
        case WHEN:
        case WHERE:
        case WITH:
        case WRITE:
        case XOR:
        case YIELD:
        case IDENTIFIER:{
          n = SymbolicNameString();
qualifier.add( astFactory.relationshipQualifier( pos(n), n.image ) );
          label_50:
          while (true) {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case 250:{
              break;
              }
            default:
              jj_la1[368] = jj_gen;
              break label_50;
            }
            jj_consume_token(250);
            n = SymbolicNameString();
qualifier.add( astFactory.relationshipQualifier( pos(n), n.image ) );
          }
          break;
          }
        default:
          jj_la1[369] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case NODE:
      case NODES:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NODE:{
          jj_consume_token(NODE);
          break;
          }
        case NODES:{
          jj_consume_token(NODES);
          break;
          }
        default:
          jj_la1[370] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case TIMES:{
          jj_consume_token(TIMES);
qualifier.add( astFactory.allLabelsQualifier( pos(token) ) );
          break;
          }
        case ESCAPED_SYMBOLIC_NAME:
        case ACCESS:
        case ACTIVE:
        case ALIAS:
        case ALIASES:
        case ALL_SHORTEST_PATH:
        case ALL:
        case ALTER:
        case AND:
        case ANY:
        case AS:
        case ASC:
        case ASSERT:
        case ASSIGN:
        case AT:
        case BRIEF:
        case BTREE:
        case BUILT:
        case BY:
        case CALL:
        case CASE:
        case CATALOG:
        case CHANGE:
        case COMMIT:
        case CONSTRAINT:
        case CONSTRAINTS:
        case CONTAINS:
        case COPY:
        case COUNT:
        case CREATE:
        case CSV:
        case CURRENT:
        case DATA:
        case DATABASE:
        case DATABASES:
        case DBMS:
        case DEFAULT_TOKEN:
        case DEFINED:
        case DELETE:
        case DENY:
        case DESC:
        case DESTROY:
        case DETACH:
        case DISTINCT:
        case DRIVER:
        case DROP:
        case DUMP:
        case EACH:
        case ELEMENT:
        case ELEMENTS:
        case ELSE:
        case ENCRYPTED:
        case END:
        case ENDS:
        case EXECUTABLE:
        case EXIST:
        case EXISTENCE:
        case EXISTS:
        case EXTRACT:
        case FALSE:
        case FIELDTERMINATOR:
        case FILTER:
        case FOR:
        case FOREACH:
        case FROM:
        case FULLTEXT:
        case FUNCTION:
        case FUNCTIONS:
        case GRANT:
        case GRAPH:
        case GRAPHS:
        case HEADERS:
        case HOME:
        case IF:
        case IN:
        case INDEX:
        case INDEXES:
        case IS:
        case JOIN:
        case KEY:
        case LABEL:
        case LABELS:
        case LIMITROWS:
        case LOAD:
        case LOOKUP:
        case MANAGEMENT:
        case MATCH:
        case MERGE:
        case NAME:
        case NAMES:
        case NEW:
        case NODE:
        case NODES:
        case NONE:
        case NOT:
        case NOWAIT:
        case NULL:
        case OF:
        case ON:
        case ONLY:
        case OPTIONAL:
        case OPTIONS:
        case OR:
        case ORDER:
        case OUTPUT:
        case PASSWORD:
        case PASSWORDS:
        case PERIODIC:
        case PLAINTEXT:
        case POINT:
        case POPULATED:
        case PRIVILEGE:
        case PRIVILEGES:
        case PROCEDURE:
        case PROCEDURES:
        case PROPERTY:
        case RANGE:
        case READ:
        case REDUCE:
        case RENAME:
        case REL:
        case RELATIONSHIP:
        case RELATIONSHIPS:
        case REMOVE:
        case REPLACE:
        case REQUIRE:
        case REQUIRED:
        case RETURN:
        case REVOKE:
        case ROLE:
        case ROLES:
        case ROW:
        case ROWS:
        case SCAN:
        case SEC:
        case SECOND:
        case SECONDS:
        case SEEK:
        case SET:
        case SHORTEST_PATH:
        case SHOW:
        case SINGLE:
        case SKIPROWS:
        case START:
        case STARTS:
        case STATUS:
        case STOP:
        case SUSPENDED:
        case TARGET:
        case TERMINATE:
        case TEXT:
        case THEN:
        case TO:
        case TRANSACTION:
        case TRANSACTIONS:
        case TRAVERSE:
        case TRUE:
        case TYPE:
        case TYPES:
        case UNION:
        case UNIQUE:
        case UNWIND:
        case USE:
        case USER:
        case USERS:
        case USING:
        case VERBOSE:
        case WAIT:
        case WHEN:
        case WHERE:
        case WITH:
        case WRITE:
        case XOR:
        case YIELD:
        case IDENTIFIER:{
          n = SymbolicNameString();
qualifier.add( astFactory.labelQualifier( pos(n), n.image ) );
          label_51:
          while (true) {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case 250:{
              break;
              }
            default:
              jj_la1[371] = jj_gen;
              break label_51;
            }
            jj_consume_token(250);
            n = SymbolicNameString();
qualifier.add( astFactory.labelQualifier( pos(n), n.image ) );
          }
          break;
          }
        default:
          jj_la1[372] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case ELEMENT:
      case ELEMENTS:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ELEMENT:{
          jj_consume_token(ELEMENT);
          break;
          }
        case ELEMENTS:{
          jj_consume_token(ELEMENTS);
          break;
          }
        default:
          jj_la1[373] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case TIMES:{
          jj_consume_token(TIMES);
qualifier.add( astFactory.allElementsQualifier( pos(token) ) );
          break;
          }
        case ESCAPED_SYMBOLIC_NAME:
        case ACCESS:
        case ACTIVE:
        case ALIAS:
        case ALIASES:
        case ALL_SHORTEST_PATH:
        case ALL:
        case ALTER:
        case AND:
        case ANY:
        case AS:
        case ASC:
        case ASSERT:
        case ASSIGN:
        case AT:
        case BRIEF:
        case BTREE:
        case BUILT:
        case BY:
        case CALL:
        case CASE:
        case CATALOG:
        case CHANGE:
        case COMMIT:
        case CONSTRAINT:
        case CONSTRAINTS:
        case CONTAINS:
        case COPY:
        case COUNT:
        case CREATE:
        case CSV:
        case CURRENT:
        case DATA:
        case DATABASE:
        case DATABASES:
        case DBMS:
        case DEFAULT_TOKEN:
        case DEFINED:
        case DELETE:
        case DENY:
        case DESC:
        case DESTROY:
        case DETACH:
        case DISTINCT:
        case DRIVER:
        case DROP:
        case DUMP:
        case EACH:
        case ELEMENT:
        case ELEMENTS:
        case ELSE:
        case ENCRYPTED:
        case END:
        case ENDS:
        case EXECUTABLE:
        case EXIST:
        case EXISTENCE:
        case EXISTS:
        case EXTRACT:
        case FALSE:
        case FIELDTERMINATOR:
        case FILTER:
        case FOR:
        case FOREACH:
        case FROM:
        case FULLTEXT:
        case FUNCTION:
        case FUNCTIONS:
        case GRANT:
        case GRAPH:
        case GRAPHS:
        case HEADERS:
        case HOME:
        case IF:
        case IN:
        case INDEX:
        case INDEXES:
        case IS:
        case JOIN:
        case KEY:
        case LABEL:
        case LABELS:
        case LIMITROWS:
        case LOAD:
        case LOOKUP:
        case MANAGEMENT:
        case MATCH:
        case MERGE:
        case NAME:
        case NAMES:
        case NEW:
        case NODE:
        case NODES:
        case NONE:
        case NOT:
        case NOWAIT:
        case NULL:
        case OF:
        case ON:
        case ONLY:
        case OPTIONAL:
        case OPTIONS:
        case OR:
        case ORDER:
        case OUTPUT:
        case PASSWORD:
        case PASSWORDS:
        case PERIODIC:
        case PLAINTEXT:
        case POINT:
        case POPULATED:
        case PRIVILEGE:
        case PRIVILEGES:
        case PROCEDURE:
        case PROCEDURES:
        case PROPERTY:
        case RANGE:
        case READ:
        case REDUCE:
        case RENAME:
        case REL:
        case RELATIONSHIP:
        case RELATIONSHIPS:
        case REMOVE:
        case REPLACE:
        case REQUIRE:
        case REQUIRED:
        case RETURN:
        case REVOKE:
        case ROLE:
        case ROLES:
        case ROW:
        case ROWS:
        case SCAN:
        case SEC:
        case SECOND:
        case SECONDS:
        case SEEK:
        case SET:
        case SHORTEST_PATH:
        case SHOW:
        case SINGLE:
        case SKIPROWS:
        case START:
        case STARTS:
        case STATUS:
        case STOP:
        case SUSPENDED:
        case TARGET:
        case TERMINATE:
        case TEXT:
        case THEN:
        case TO:
        case TRANSACTION:
        case TRANSACTIONS:
        case TRAVERSE:
        case TRUE:
        case TYPE:
        case TYPES:
        case UNION:
        case UNIQUE:
        case UNWIND:
        case USE:
        case USER:
        case USERS:
        case USING:
        case VERBOSE:
        case WAIT:
        case WHEN:
        case WHERE:
        case WITH:
        case WRITE:
        case XOR:
        case YIELD:
        case IDENTIFIER:{
          n = SymbolicNameString();
qualifier.add( astFactory.elementQualifier( pos(n), n.image ) );
          label_52:
          while (true) {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case 250:{
              break;
              }
            default:
              jj_la1[374] = jj_gen;
              break label_52;
            }
            jj_consume_token(250);
            n = SymbolicNameString();
qualifier.add( astFactory.elementQualifier( pos(n), n.image ) );
          }
          break;
          }
        default:
          jj_la1[375] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[376] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[377] = jj_gen;
      ;
    }
if ( qualifier.isEmpty() ) {
            qualifier.add( astFactory.allElementsQualifier( pos(token) ) );
        }
        {if ("" != null) return qualifier;}
    throw new IllegalStateException ("Missing return statement in function");
}

// Database commands
  final public 
ADMINISTRATION_COMMAND CreateDatabase(Token start, boolean replace) throws ParseException {SimpleEither<String, PARAMETER> databaseName = null;
    boolean ifNotExists = false;
    WAIT_CLAUSE wait = astFactory.wait( false, -1 );
    SimpleEither<Map<String, EXPRESSION>, PARAMETER> options = null;
    jj_consume_token(DATABASE);
    databaseName = SymbolicDatabaseNameStringOrParameter();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(NOT);
      jj_consume_token(EXISTS);
ifNotExists = true;
      break;
      }
    default:
      jj_la1[378] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case OPTIONS:{
      options = Options();
      break;
      }
    default:
      jj_la1[379] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case NOWAIT:
    case WAIT:{
      wait = WaitClause();
      break;
      }
    default:
      jj_la1[380] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.createDatabase( pos( start ), replace, databaseName, ifNotExists, wait, options );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SimpleEither<Map<String, EXPRESSION>, PARAMETER> Options() throws ParseException {SimpleEither<Map<String, EXPRESSION>, PARAMETER> options = null;
    jj_consume_token(OPTIONS);
    options = MapOrParameter();
{if ("" != null) return options;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND DropDatabase(Token start) throws ParseException {SimpleEither<String, PARAMETER> databaseName = null;
    boolean ifExists = false;
    WAIT_CLAUSE wait = astFactory.wait( false, -1 );
    boolean dumpData = false;
    jj_consume_token(DATABASE);
    databaseName = SymbolicDatabaseNameStringOrParameter();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
ifExists = true;
      break;
      }
    default:
      jj_la1[381] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DESTROY:
    case DUMP:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DUMP:{
        jj_consume_token(DUMP);
dumpData = true;
        break;
        }
      case DESTROY:{
        jj_consume_token(DESTROY);
        break;
        }
      default:
        jj_la1[382] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(DATA);
      break;
      }
    default:
      jj_la1[383] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case NOWAIT:
    case WAIT:{
      wait = WaitClause();
      break;
      }
    default:
      jj_la1[384] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.dropDatabase( pos( start ), databaseName, ifExists, dumpData, wait );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND AlterDatabase(Token start) throws ParseException {SimpleEither<String, PARAMETER> databaseName = null;
    boolean ifExists = false;
    AccessType accessType = AccessType.READ_WRITE;
    jj_consume_token(DATABASE);
    databaseName = SymbolicDatabaseNameStringOrParameter();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
ifExists = true;
      break;
      }
    default:
      jj_la1[385] = jj_gen;
      ;
    }
    jj_consume_token(SET);
    jj_consume_token(ACCESS);
    jj_consume_token(READ);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ONLY:{
      jj_consume_token(ONLY);
accessType = AccessType.READ_ONLY;
      break;
      }
    case WRITE:{
      jj_consume_token(WRITE);
      break;
      }
    default:
      jj_la1[386] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return astFactory.alterDatabase( pos( start ), databaseName, ifExists, accessType );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND StartDatabase() throws ParseException {Token start;
    SimpleEither<String, PARAMETER> databaseName;
    WAIT_CLAUSE wait = astFactory.wait( false, -1 );
    start = jj_consume_token(START);
    jj_consume_token(DATABASE);
    databaseName = SymbolicDatabaseNameStringOrParameter();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case NOWAIT:
    case WAIT:{
      wait = WaitClause();
      break;
      }
    default:
      jj_la1[387] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.startDatabase( pos( start ), databaseName, wait );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND StopDatabase() throws ParseException {Token start;
    SimpleEither<String, PARAMETER> databaseName;
    WAIT_CLAUSE wait = astFactory.wait( false, -1 );
    start = jj_consume_token(STOP);
    jj_consume_token(DATABASE);
    databaseName = SymbolicDatabaseNameStringOrParameter();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case NOWAIT:
    case WAIT:{
      wait = WaitClause();
      break;
      }
    default:
      jj_la1[388] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.stopDatabase( pos( start ), databaseName, wait );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public WAIT_CLAUSE WaitClause() throws ParseException {Token number = null;
    boolean wait = false;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WAIT:{
      jj_consume_token(WAIT);
wait = true;
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case UNSIGNED_DECIMAL_INTEGER:{
        number = jj_consume_token(UNSIGNED_DECIMAL_INTEGER);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case SEC:
        case SECOND:
        case SECONDS:{
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case SEC:{
            jj_consume_token(SEC);
            break;
            }
          case SECOND:{
            jj_consume_token(SECOND);
            break;
            }
          case SECONDS:{
            jj_consume_token(SECONDS);
            break;
            }
          default:
            jj_la1[389] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[390] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[391] = jj_gen;
        ;
      }
      break;
      }
    case NOWAIT:{
      jj_consume_token(NOWAIT);
      break;
      }
    default:
      jj_la1[392] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if ( number != null )
        {
            {if ("" != null) return astFactory.wait( wait, Long.parseLong( number.image) );}
        }
        {if ("" != null) return astFactory.wait( wait, -1 ) ;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT_WITH_GRAPH ShowDatabase(Token start, USE_CLAUSE useClause) throws ParseException {DATABASE_SCOPE scope;
    YIELD yield = null;
    RETURN_CLAUSE returnClause = null;
    WHERE where = null;
    scope = DatabaseScope();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:
    case YIELD:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case YIELD:{
        yield = YieldClause();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case RETURN:{
          returnClause = ReturnClause();
          break;
          }
        default:
          jj_la1[393] = jj_gen;
          ;
        }
        break;
        }
      case WHERE:{
        where = WhereClause();
        break;
        }
      default:
        jj_la1[394] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[395] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.useGraph( astFactory.showDatabase( pos( start ), scope, yield, returnClause, where), useClause );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public DATABASE_SCOPE DatabaseScope() throws ParseException {Token start = null;
    SimpleEither<String, PARAMETER> name = null;
    boolean isDefault = false;
    boolean isHome = false;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DATABASE:{
      start = jj_consume_token(DATABASE);
      name = SymbolicDatabaseNameStringOrParameter();
      break;
      }
    case DATABASES:{
      start = jj_consume_token(DATABASES);
      break;
      }
    case DEFAULT_TOKEN:{
      start = jj_consume_token(DEFAULT_TOKEN);
      jj_consume_token(DATABASE);
isDefault = true;
      break;
      }
    case HOME:{
      start = jj_consume_token(HOME);
      jj_consume_token(DATABASE);
isHome = true;
      break;
      }
    default:
      jj_la1[396] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return astFactory.databaseScope( pos( start ), name, isDefault, isHome );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<DATABASE_SCOPE> DatabaseScopeList() throws ParseException {Token start = null;
    List<SimpleEither<String, PARAMETER>> names = null;
    ScopeType type = ScopeType.NAMED;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DATABASE:
    case DATABASES:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DATABASE:{
        start = jj_consume_token(DATABASE);
        break;
        }
      case DATABASES:{
        start = jj_consume_token(DATABASES);
        break;
        }
      default:
        jj_la1[397] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case TIMES:{
        jj_consume_token(TIMES);
type = ScopeType.ALL;
        break;
        }
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case AS:
      case ASC:
      case ASSERT:
      case ASSIGN:
      case AT:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASE:
      case CATALOG:
      case CHANGE:
      case COMMIT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DBMS:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESTROY:
      case DETACH:
      case DOLLAR:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DUMP:
      case EACH:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case EXTRACT:
      case FALSE:
      case FIELDTERMINATOR:
      case FILTER:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case HEADERS:
      case HOME:
      case IF:
      case IN:
      case INDEX:
      case INDEXES:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LIMITROWS:
      case LOAD:
      case LOOKUP:
      case MANAGEMENT:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NEW:
      case NODE:
      case NODES:
      case NONE:
      case NOT:
      case NOWAIT:
      case NULL:
      case OF:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTY:
      case RANGE:
      case READ:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REQUIRE:
      case REQUIRED:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDS:
      case SEEK:
      case SET:
      case SHORTEST_PATH:
      case SHOW:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TO:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRUE:
      case TYPE:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNWIND:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VERBOSE:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WRITE:
      case XOR:
      case YIELD:
      case IDENTIFIER:{
        names = SymbolicDatabaseNameStringOrParameterList();
        break;
        }
      default:
        jj_la1[398] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case DEFAULT_TOKEN:{
      start = jj_consume_token(DEFAULT_TOKEN);
      jj_consume_token(DATABASE);
type = ScopeType.DEFAULT;
      break;
      }
    case HOME:{
      start = jj_consume_token(HOME);
      jj_consume_token(DATABASE);
type = ScopeType.HOME;
      break;
      }
    default:
      jj_la1[399] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return astFactory.databaseScopes( pos( start ), names, type );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<GRAPH_SCOPE> graphScopeList() throws ParseException {Token start = null;
    List<SimpleEither<String, PARAMETER>> names = null;
    ScopeType type = ScopeType.NAMED;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case GRAPH:
    case GRAPHS:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case GRAPH:{
        start = jj_consume_token(GRAPH);
        break;
        }
      case GRAPHS:{
        start = jj_consume_token(GRAPHS);
        break;
        }
      default:
        jj_la1[400] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case TIMES:{
        jj_consume_token(TIMES);
type = ScopeType.ALL;
        break;
        }
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case AS:
      case ASC:
      case ASSERT:
      case ASSIGN:
      case AT:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASE:
      case CATALOG:
      case CHANGE:
      case COMMIT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DBMS:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESTROY:
      case DETACH:
      case DOLLAR:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DUMP:
      case EACH:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case EXTRACT:
      case FALSE:
      case FIELDTERMINATOR:
      case FILTER:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case HEADERS:
      case HOME:
      case IF:
      case IN:
      case INDEX:
      case INDEXES:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LIMITROWS:
      case LOAD:
      case LOOKUP:
      case MANAGEMENT:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NEW:
      case NODE:
      case NODES:
      case NONE:
      case NOT:
      case NOWAIT:
      case NULL:
      case OF:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTY:
      case RANGE:
      case READ:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REQUIRE:
      case REQUIRED:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDS:
      case SEEK:
      case SET:
      case SHORTEST_PATH:
      case SHOW:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TO:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRUE:
      case TYPE:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNWIND:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VERBOSE:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WRITE:
      case XOR:
      case YIELD:
      case IDENTIFIER:{
        names = SymbolicDatabaseNameStringOrParameterList();
        break;
        }
      default:
        jj_la1[401] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case DEFAULT_TOKEN:{
      start = jj_consume_token(DEFAULT_TOKEN);
      jj_consume_token(GRAPH);
type = ScopeType.DEFAULT;
      break;
      }
    case HOME:{
      start = jj_consume_token(HOME);
      jj_consume_token(GRAPH);
type = ScopeType.HOME;
      break;
      }
    default:
      jj_la1[402] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return astFactory.graphScopes( pos( start ), names, type );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND CreateAlias(Token start, boolean replace) throws ParseException, Exception {AliasName<PARAMETER> aliasName = null;
    SimpleEither<String, PARAMETER> targetName = null;
    boolean ifNotExists = false;
    SimpleEither<String, PARAMETER> url = null;
    SimpleEither<String, PARAMETER> username = null;
    EXPRESSION password = null;
    SimpleEither<Map<String, EXPRESSION>, PARAMETER> driverSettings = null;
    jj_consume_token(ALIAS);
    aliasName = SymbolicAliasName();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(NOT);
      jj_consume_token(EXISTS);
ifNotExists = true;
      break;
      }
    default:
      jj_la1[403] = jj_gen;
      ;
    }
    jj_consume_token(FOR);
    jj_consume_token(DATABASE);
    targetName = SymbolicDatabaseNameStringOrParameter();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case AT:{
      jj_consume_token(AT);
      url = StringOrParameter();
      jj_consume_token(USER);
      username = SymbolicNameOrStringParameter();
      jj_consume_token(PASSWORD);
      password = passwordExpression();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DRIVER:{
        jj_consume_token(DRIVER);
        driverSettings = MapOrParameter();
        break;
        }
      default:
        jj_la1[404] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[405] = jj_gen;
      ;
    }
if ( url == null )
       {
           {if ("" != null) return astFactory.createLocalDatabaseAlias( pos( start ), replace, aliasName.getLocalAliasName(), targetName, ifNotExists );}
       }
       else
       {
           {if ("" != null) return astFactory.createRemoteDatabaseAlias( pos( start ), replace, aliasName.getRemoteAliasName(), targetName, ifNotExists, url, username, password, driverSettings );}
       }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND DropAlias(Token start) throws ParseException {SimpleEither<String, PARAMETER> aliasName = null;
    boolean ifExists = false;
    jj_consume_token(ALIAS);
    aliasName = SymbolicDatabaseNameStringOrParameter();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
ifExists = true;
      break;
      }
    default:
      jj_la1[406] = jj_gen;
      ;
    }
    jj_consume_token(FOR);
    jj_consume_token(DATABASE);
{if ("" != null) return astFactory.dropAlias( pos( start ), aliasName, ifExists );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND AlterAlias(Token start) throws ParseException, Exception {AliasName<PARAMETER> aliasName = null;
    SimpleEither<String, PARAMETER> targetName = null;
    boolean ifExists = false;
    SimpleEither<String, PARAMETER> url = null;
    SimpleEither<String, PARAMETER> username = null;
    EXPRESSION password = null;
    SimpleEither<Map<String, EXPRESSION>, PARAMETER> driverSettings = null;
    Token errorStart = null;
    String alreadySet = "Duplicate SET DATABASE %s clause";
    jj_consume_token(ALIAS);
    aliasName = SymbolicAliasName();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
ifExists = true;
      break;
      }
    default:
      jj_la1[407] = jj_gen;
      ;
    }
    jj_consume_token(SET);
    jj_consume_token(DATABASE);
    label_53:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case TARGET:{
        errorStart = jj_consume_token(TARGET);
assertNotAlreadySet( targetName, errorStart, String.format(alreadySet, errorStart.image) );
        targetName = SymbolicDatabaseNameStringOrParameter();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case AT:{
          jj_consume_token(AT);
          url = StringOrParameter();
          break;
          }
        default:
          jj_la1[408] = jj_gen;
          ;
        }
        break;
        }
      case USER:{
        errorStart = jj_consume_token(USER);
assertNotAlreadySet( username, errorStart, String.format(alreadySet, errorStart.image) );
        username = SymbolicNameOrStringParameter();
        break;
        }
      case PASSWORD:{
        errorStart = jj_consume_token(PASSWORD);
assertNotAlreadySet( password, errorStart, String.format(alreadySet, errorStart.image) );
        password = passwordExpression();
        break;
        }
      case DRIVER:{
        errorStart = jj_consume_token(DRIVER);
assertNotAlreadySet( driverSettings, errorStart, String.format(alreadySet, errorStart.image) );
        driverSettings = MapOrParameter();
        break;
        }
      default:
        jj_la1[409] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DRIVER:
      case PASSWORD:
      case TARGET:
      case USER:{
        break;
        }
      default:
        jj_la1[410] = jj_gen;
        break label_53;
      }
    }
if ( url == null && username == null && password == null && driverSettings == null )
        {
            {if ("" != null) return astFactory.alterLocalDatabaseAlias( pos( start ), aliasName.getLocalAliasName(), targetName, ifExists );}
        }
        else
        {
            {if ("" != null) return astFactory.alterRemoteDatabaseAlias( pos( start ), aliasName.getRemoteAliasName(), targetName, ifExists, url, username, password, driverSettings );}
        }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT ShowAliases(Token start, USE_CLAUSE useClause) throws ParseException {WHERE where = null;
    YIELD yieldClause = null;
    RETURN_CLAUSE returnClause = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ALIAS:{
      jj_consume_token(ALIAS);
      break;
      }
    case ALIASES:{
      jj_consume_token(ALIASES);
      break;
      }
    default:
      jj_la1[411] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(FOR);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DATABASE:{
      jj_consume_token(DATABASE);
      break;
      }
    case DATABASES:{
      jj_consume_token(DATABASES);
      break;
      }
    default:
      jj_la1[412] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:
    case YIELD:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case YIELD:{
        yieldClause = YieldClause();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case RETURN:{
          returnClause = ReturnClause();
          break;
          }
        default:
          jj_la1[413] = jj_gen;
          ;
        }
        break;
        }
      case WHERE:{
        where = WhereClause();
        break;
        }
      default:
        jj_la1[414] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[415] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.useGraph( astFactory.showAliases( pos( start ), yieldClause, returnClause, where), useClause );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<SimpleEither<String, PARAMETER>> SymbolicDatabaseNameStringOrParameterList() throws ParseException {SimpleEither<String, PARAMETER> dbSymbol = null;
    List<SimpleEither<String, PARAMETER>> databases = new ArrayList<>();
    dbSymbol = SymbolicDatabaseNameStringOrParameter();
databases.add(dbSymbol);
    label_54:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 250:{
        break;
        }
      default:
        jj_la1[416] = jj_gen;
        break label_54;
      }
      jj_consume_token(250);
      dbSymbol = SymbolicDatabaseNameStringOrParameter();
databases.add(dbSymbol);
    }
{if ("" != null) return databases;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SimpleEither<String, PARAMETER> SymbolicDatabaseNameStringOrParameter() throws ParseException {Token nameToken;
    StringBuilder nameBuilder;
    PARAMETER parameter;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case AS:
    case ASC:
    case ASSERT:
    case ASSIGN:
    case AT:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASE:
    case CATALOG:
    case CHANGE:
    case COMMIT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DBMS:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESTROY:
    case DETACH:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DUMP:
    case EACH:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case EXTRACT:
    case FALSE:
    case FIELDTERMINATOR:
    case FILTER:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case HEADERS:
    case HOME:
    case IF:
    case IN:
    case INDEX:
    case INDEXES:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LIMITROWS:
    case LOAD:
    case LOOKUP:
    case MANAGEMENT:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NEW:
    case NODE:
    case NODES:
    case NONE:
    case NOT:
    case NOWAIT:
    case NULL:
    case OF:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTY:
    case RANGE:
    case READ:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REQUIRE:
    case REQUIRED:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDS:
    case SEEK:
    case SET:
    case SHORTEST_PATH:
    case SHOW:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TO:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRUE:
    case TYPE:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNWIND:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VERBOSE:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WRITE:
    case XOR:
    case YIELD:
    case IDENTIFIER:{
      nameToken = SymbolicNameString();
nameBuilder =new StringBuilder( nameToken.image );
      label_55:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case DOT:{
          break;
          }
        default:
          jj_la1[417] = jj_gen;
          break label_55;
        }
        jj_consume_token(DOT);
        nameToken = SymbolicNameString();
nameBuilder.append( "." ); nameBuilder.append( nameToken.image );
      }
{if ("" != null) return SimpleEither.<String, PARAMETER>left( nameBuilder.toString() );}
      break;
      }
    case DOLLAR:{
      parameter = Parameter(ParameterType.STRING);
{if ("" != null) return SimpleEither.<String, PARAMETER>right( parameter );}
      break;
      }
    default:
      jj_la1[418] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public AliasName<PARAMETER> SymbolicAliasName() throws ParseException, Exception {Token token;
    AliasName<PARAMETER> name = null;
    PARAMETER parameter;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case AS:
    case ASC:
    case ASSERT:
    case ASSIGN:
    case AT:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASE:
    case CATALOG:
    case CHANGE:
    case COMMIT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DBMS:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESTROY:
    case DETACH:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DUMP:
    case EACH:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case EXTRACT:
    case FALSE:
    case FIELDTERMINATOR:
    case FILTER:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case HEADERS:
    case HOME:
    case IF:
    case IN:
    case INDEX:
    case INDEXES:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LIMITROWS:
    case LOAD:
    case LOOKUP:
    case MANAGEMENT:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NEW:
    case NODE:
    case NODES:
    case NONE:
    case NOT:
    case NOWAIT:
    case NULL:
    case OF:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTY:
    case RANGE:
    case READ:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REQUIRE:
    case REQUIRED:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDS:
    case SEEK:
    case SET:
    case SHORTEST_PATH:
    case SHOW:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TO:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRUE:
    case TYPE:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNWIND:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VERBOSE:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WRITE:
    case XOR:
    case YIELD:
    case IDENTIFIER:{
      token = SymbolicNameString();
name = new AliasName<PARAMETER>( exceptionFactory, token );
      label_56:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case DOT:{
          break;
          }
        default:
          jj_la1[419] = jj_gen;
          break label_56;
        }
        jj_consume_token(DOT);
        token = SymbolicNameString();
name.add( token );
      }
{if ("" != null) return name;}
      break;
      }
    case DOLLAR:{
      parameter = Parameter(ParameterType.STRING);
{if ("" != null) return new AliasName<PARAMETER>( exceptionFactory, parameter );}
      break;
      }
    default:
      jj_la1[420] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<SimpleEither<String, PARAMETER>> SymbolicNameOrStringParameterList() throws ParseException {SimpleEither<String, PARAMETER> entry;
    List<SimpleEither<String, PARAMETER>> list = new ArrayList<>();
    entry = SymbolicNameOrStringParameter();
list.add( entry );
    label_57:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 250:{
        break;
        }
      default:
        jj_la1[421] = jj_gen;
        break label_57;
      }
      jj_consume_token(250);
      entry = SymbolicNameOrStringParameter();
list.add( entry );
    }
{if ("" != null) return list;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SimpleEither<String, PARAMETER> SymbolicNameOrStringParameter() throws ParseException {Token name;
    PARAMETER parameter;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case AS:
    case ASC:
    case ASSERT:
    case ASSIGN:
    case AT:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASE:
    case CATALOG:
    case CHANGE:
    case COMMIT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DBMS:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESTROY:
    case DETACH:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DUMP:
    case EACH:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case EXTRACT:
    case FALSE:
    case FIELDTERMINATOR:
    case FILTER:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case HEADERS:
    case HOME:
    case IF:
    case IN:
    case INDEX:
    case INDEXES:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LIMITROWS:
    case LOAD:
    case LOOKUP:
    case MANAGEMENT:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NEW:
    case NODE:
    case NODES:
    case NONE:
    case NOT:
    case NOWAIT:
    case NULL:
    case OF:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTY:
    case RANGE:
    case READ:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REQUIRE:
    case REQUIRED:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDS:
    case SEEK:
    case SET:
    case SHORTEST_PATH:
    case SHOW:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TO:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRUE:
    case TYPE:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNWIND:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VERBOSE:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WRITE:
    case XOR:
    case YIELD:
    case IDENTIFIER:{
      name = SymbolicNameString();
{if ("" != null) return SimpleEither.<String, PARAMETER>left( name.image );}
      break;
      }
    case DOLLAR:{
      parameter = Parameter(ParameterType.STRING);
{if ("" != null) return SimpleEither.<String, PARAMETER>right( parameter );}
      break;
      }
    default:
      jj_la1[422] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String TransactionIdString() throws ParseException {Token t;
    t = StringToken();
{if ("" != null) return token.image;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<String> TransactionIdStringList() throws ParseException {String entry;
    List<String> list = new ArrayList<>();
    entry = TransactionIdString();
list.add( entry );
    label_58:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 250:{
        break;
        }
      default:
        jj_la1[423] = jj_gen;
        break label_58;
      }
      jj_consume_token(250);
      entry = TransactionIdString();
list.add( entry );
    }
{if ("" != null) return list;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SimpleEither<Map<String, EXPRESSION>, PARAMETER> MapOrParameter() throws ParseException {Map<String, EXPRESSION> map = null;
    PARAMETER parameter;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LCURLY:{
      map = Map();
{if ("" != null) return SimpleEither.<Map<String,EXPRESSION>,PARAMETER>left ( map );}
      break;
      }
    case DOLLAR:{
      parameter = Parameter(ParameterType.MAP);
{if ("" != null) return SimpleEither.<Map<String,EXPRESSION>,PARAMETER>right( parameter );}
      break;
      }
    default:
      jj_la1[424] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Map<String, EXPRESSION> Map() throws ParseException {Token key;
    EXPRESSION expr;
    LinkedHashMap<String, EXPRESSION> map = new LinkedHashMap<>();
    jj_consume_token(LCURLY);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case AS:
    case ASC:
    case ASSERT:
    case ASSIGN:
    case AT:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASE:
    case CATALOG:
    case CHANGE:
    case COMMIT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DBMS:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESTROY:
    case DETACH:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DUMP:
    case EACH:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case EXTRACT:
    case FALSE:
    case FIELDTERMINATOR:
    case FILTER:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case HEADERS:
    case HOME:
    case IF:
    case IN:
    case INDEX:
    case INDEXES:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LIMITROWS:
    case LOAD:
    case LOOKUP:
    case MANAGEMENT:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NEW:
    case NODE:
    case NODES:
    case NONE:
    case NOT:
    case NOWAIT:
    case NULL:
    case OF:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTY:
    case RANGE:
    case READ:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REQUIRE:
    case REQUIRED:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDS:
    case SEEK:
    case SET:
    case SHORTEST_PATH:
    case SHOW:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TO:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRUE:
    case TYPE:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNWIND:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VERBOSE:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WRITE:
    case XOR:
    case YIELD:
    case IDENTIFIER:{
      key = SymbolicNameString();
      jj_consume_token(252);
      expr = Expression();
map.put( key.image, expr );
      label_59:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case 250:{
          break;
          }
        default:
          jj_la1[425] = jj_gen;
          break label_59;
        }
        jj_consume_token(250);
        key = SymbolicNameString();
        jj_consume_token(252);
        expr = Expression();
map.put( key.image, expr );
      }
      break;
      }
    default:
      jj_la1[426] = jj_gen;
      ;
    }
    jj_consume_token(RCURLY);
{if ("" != null) return map;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<StringPos<POS>> SymbolicNamePositions() throws ParseException {List<StringPos<POS>> names = new ArrayList<>();
    SymbolicNameString();
names.add( new StringPos<>( token.image, pos( token ) ) );
    label_60:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 250:{
        break;
        }
      default:
        jj_la1[427] = jj_gen;
        break label_60;
      }
      jj_consume_token(250);
      SymbolicNameString();
names.add( new StringPos<>( token.image, pos( token ) ) );
    }
{if ("" != null) return names;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Token SymbolicNameString() throws ParseException {Token t;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IDENTIFIER:{
      t = jj_consume_token(IDENTIFIER);
      break;
      }
    case ESCAPED_SYMBOLIC_NAME:{
      t = jj_consume_token(ESCAPED_SYMBOLIC_NAME);
      break;
      }
    case ACCESS:{
      t = jj_consume_token(ACCESS);
      break;
      }
    case ACTIVE:{
      t = jj_consume_token(ACTIVE);
      break;
      }
    case ALIAS:{
      t = jj_consume_token(ALIAS);
      break;
      }
    case ALIASES:{
      t = jj_consume_token(ALIASES);
      break;
      }
    case ALL_SHORTEST_PATH:{
      t = jj_consume_token(ALL_SHORTEST_PATH);
      break;
      }
    case ALL:{
      t = jj_consume_token(ALL);
      break;
      }
    case ALTER:{
      t = jj_consume_token(ALTER);
      break;
      }
    case AND:{
      t = jj_consume_token(AND);
      break;
      }
    case ANY:{
      t = jj_consume_token(ANY);
      break;
      }
    case AS:{
      t = jj_consume_token(AS);
      break;
      }
    case ASC:{
      t = jj_consume_token(ASC);
      break;
      }
    case ASSERT:{
      t = jj_consume_token(ASSERT);
      break;
      }
    case ASSIGN:{
      t = jj_consume_token(ASSIGN);
      break;
      }
    case AT:{
      t = jj_consume_token(AT);
      break;
      }
    case BRIEF:{
      t = jj_consume_token(BRIEF);
      break;
      }
    case BTREE:{
      t = jj_consume_token(BTREE);
      break;
      }
    case BUILT:{
      t = jj_consume_token(BUILT);
      break;
      }
    case BY:{
      t = jj_consume_token(BY);
      break;
      }
    case CALL:{
      t = jj_consume_token(CALL);
      break;
      }
    case CASE:{
      t = jj_consume_token(CASE);
      break;
      }
    case CATALOG:{
      t = jj_consume_token(CATALOG);
      break;
      }
    case CHANGE:{
      t = jj_consume_token(CHANGE);
      break;
      }
    case COMMIT:{
      t = jj_consume_token(COMMIT);
      break;
      }
    case CONSTRAINT:{
      t = jj_consume_token(CONSTRAINT);
      break;
      }
    case CONSTRAINTS:{
      t = jj_consume_token(CONSTRAINTS);
      break;
      }
    case CONTAINS:{
      t = jj_consume_token(CONTAINS);
      break;
      }
    case COPY:{
      t = jj_consume_token(COPY);
      break;
      }
    case COUNT:{
      t = jj_consume_token(COUNT);
      break;
      }
    case CREATE:{
      t = jj_consume_token(CREATE);
      break;
      }
    case CSV:{
      t = jj_consume_token(CSV);
      break;
      }
    case CURRENT:{
      t = jj_consume_token(CURRENT);
      break;
      }
    case DATA:{
      t = jj_consume_token(DATA);
      break;
      }
    case DATABASE:{
      t = jj_consume_token(DATABASE);
      break;
      }
    case DATABASES:{
      t = jj_consume_token(DATABASES);
      break;
      }
    case DBMS:{
      t = jj_consume_token(DBMS);
      break;
      }
    case DEFAULT_TOKEN:{
      t = jj_consume_token(DEFAULT_TOKEN);
      break;
      }
    case DEFINED:{
      t = jj_consume_token(DEFINED);
      break;
      }
    case DELETE:{
      t = jj_consume_token(DELETE);
      break;
      }
    case DENY:{
      t = jj_consume_token(DENY);
      break;
      }
    case DESC:{
      t = jj_consume_token(DESC);
      break;
      }
    case DESTROY:{
      t = jj_consume_token(DESTROY);
      break;
      }
    case DETACH:{
      t = jj_consume_token(DETACH);
      break;
      }
    case DISTINCT:{
      t = jj_consume_token(DISTINCT);
      break;
      }
    case DRIVER:{
      t = jj_consume_token(DRIVER);
      break;
      }
    case DROP:{
      t = jj_consume_token(DROP);
      break;
      }
    case DUMP:{
      t = jj_consume_token(DUMP);
      break;
      }
    case EACH:{
      t = jj_consume_token(EACH);
      break;
      }
    case ELEMENT:{
      t = jj_consume_token(ELEMENT);
      break;
      }
    case ELEMENTS:{
      t = jj_consume_token(ELEMENTS);
      break;
      }
    case ELSE:{
      t = jj_consume_token(ELSE);
      break;
      }
    case ENCRYPTED:{
      t = jj_consume_token(ENCRYPTED);
      break;
      }
    case END:{
      t = jj_consume_token(END);
      break;
      }
    case ENDS:{
      t = jj_consume_token(ENDS);
      break;
      }
    case EXECUTABLE:{
      t = jj_consume_token(EXECUTABLE);
      break;
      }
    case EXIST:{
      t = jj_consume_token(EXIST);
      break;
      }
    case EXISTENCE:{
      t = jj_consume_token(EXISTENCE);
      break;
      }
    case EXISTS:{
      t = jj_consume_token(EXISTS);
      break;
      }
    case EXTRACT:{
      t = jj_consume_token(EXTRACT);
      break;
      }
    case FALSE:{
      t = jj_consume_token(FALSE);
      break;
      }
    case FIELDTERMINATOR:{
      t = jj_consume_token(FIELDTERMINATOR);
      break;
      }
    case FILTER:{
      t = jj_consume_token(FILTER);
      break;
      }
    case FOREACH:{
      t = jj_consume_token(FOREACH);
      break;
      }
    case FOR:{
      t = jj_consume_token(FOR);
      break;
      }
    case FROM:{
      t = jj_consume_token(FROM);
      break;
      }
    case FULLTEXT:{
      t = jj_consume_token(FULLTEXT);
      break;
      }
    case FUNCTION:{
      t = jj_consume_token(FUNCTION);
      break;
      }
    case FUNCTIONS:{
      t = jj_consume_token(FUNCTIONS);
      break;
      }
    case GRANT:{
      t = jj_consume_token(GRANT);
      break;
      }
    case GRAPH:{
      t = jj_consume_token(GRAPH);
      break;
      }
    case GRAPHS:{
      t = jj_consume_token(GRAPHS);
      break;
      }
    case HEADERS:{
      t = jj_consume_token(HEADERS);
      break;
      }
    case HOME:{
      t = jj_consume_token(HOME);
      break;
      }
    case IF:{
      t = jj_consume_token(IF);
      break;
      }
    case IN:{
      t = jj_consume_token(IN);
      break;
      }
    case INDEX:{
      t = jj_consume_token(INDEX);
      break;
      }
    case INDEXES:{
      t = jj_consume_token(INDEXES);
      break;
      }
    case IS:{
      t = jj_consume_token(IS);
      break;
      }
    case JOIN:{
      t = jj_consume_token(JOIN);
      break;
      }
    case KEY:{
      t = jj_consume_token(KEY);
      break;
      }
    case LABEL:{
      t = jj_consume_token(LABEL);
      break;
      }
    case LABELS:{
      t = jj_consume_token(LABELS);
      break;
      }
    case LIMITROWS:{
      t = jj_consume_token(LIMITROWS);
      break;
      }
    case LOAD:{
      t = jj_consume_token(LOAD);
      break;
      }
    case LOOKUP:{
      t = jj_consume_token(LOOKUP);
      break;
      }
    case MATCH:{
      t = jj_consume_token(MATCH);
      break;
      }
    case MANAGEMENT:{
      t = jj_consume_token(MANAGEMENT);
      break;
      }
    case MERGE:{
      t = jj_consume_token(MERGE);
      break;
      }
    case NAME:{
      t = jj_consume_token(NAME);
      break;
      }
    case NAMES:{
      t = jj_consume_token(NAMES);
      break;
      }
    case NEW:{
      t = jj_consume_token(NEW);
      break;
      }
    case NODE:{
      t = jj_consume_token(NODE);
      break;
      }
    case NODES:{
      t = jj_consume_token(NODES);
      break;
      }
    case NONE:{
      t = jj_consume_token(NONE);
      break;
      }
    case NOT:{
      t = jj_consume_token(NOT);
      break;
      }
    case NOWAIT:{
      t = jj_consume_token(NOWAIT);
      break;
      }
    case NULL:{
      t = jj_consume_token(NULL);
      break;
      }
    case OF:{
      t = jj_consume_token(OF);
      break;
      }
    case ON:{
      t = jj_consume_token(ON);
      break;
      }
    case ONLY:{
      t = jj_consume_token(ONLY);
      break;
      }
    case OPTIONAL:{
      t = jj_consume_token(OPTIONAL);
      break;
      }
    case OPTIONS:{
      t = jj_consume_token(OPTIONS);
      break;
      }
    case OR:{
      t = jj_consume_token(OR);
      break;
      }
    case ORDER:{
      t = jj_consume_token(ORDER);
      break;
      }
    case OUTPUT:{
      t = jj_consume_token(OUTPUT);
      break;
      }
    case PASSWORD:{
      t = jj_consume_token(PASSWORD);
      break;
      }
    case PASSWORDS:{
      t = jj_consume_token(PASSWORDS);
      break;
      }
    case PERIODIC:{
      t = jj_consume_token(PERIODIC);
      break;
      }
    case PLAINTEXT:{
      t = jj_consume_token(PLAINTEXT);
      break;
      }
    case POINT:{
      t = jj_consume_token(POINT);
      break;
      }
    case POPULATED:{
      t = jj_consume_token(POPULATED);
      break;
      }
    case PRIVILEGE:{
      t = jj_consume_token(PRIVILEGE);
      break;
      }
    case PRIVILEGES:{
      t = jj_consume_token(PRIVILEGES);
      break;
      }
    case PROCEDURE:{
      t = jj_consume_token(PROCEDURE);
      break;
      }
    case PROCEDURES:{
      t = jj_consume_token(PROCEDURES);
      break;
      }
    case PROPERTY:{
      t = jj_consume_token(PROPERTY);
      break;
      }
    case RANGE:{
      t = jj_consume_token(RANGE);
      break;
      }
    case READ:{
      t = jj_consume_token(READ);
      break;
      }
    case REDUCE:{
      t = jj_consume_token(REDUCE);
      break;
      }
    case REL:{
      t = jj_consume_token(REL);
      break;
      }
    case RELATIONSHIP:{
      t = jj_consume_token(RELATIONSHIP);
      break;
      }
    case RELATIONSHIPS:{
      t = jj_consume_token(RELATIONSHIPS);
      break;
      }
    case REMOVE:{
      t = jj_consume_token(REMOVE);
      break;
      }
    case RENAME:{
      t = jj_consume_token(RENAME);
      break;
      }
    case REPLACE:{
      t = jj_consume_token(REPLACE);
      break;
      }
    case REQUIRE:{
      t = jj_consume_token(REQUIRE);
      break;
      }
    case REQUIRED:{
      t = jj_consume_token(REQUIRED);
      break;
      }
    case RETURN:{
      t = jj_consume_token(RETURN);
      break;
      }
    case REVOKE:{
      t = jj_consume_token(REVOKE);
      break;
      }
    case ROLE:{
      t = jj_consume_token(ROLE);
      break;
      }
    case ROLES:{
      t = jj_consume_token(ROLES);
      break;
      }
    case ROW:{
      t = jj_consume_token(ROW);
      break;
      }
    case ROWS:{
      t = jj_consume_token(ROWS);
      break;
      }
    case SCAN:{
      t = jj_consume_token(SCAN);
      break;
      }
    case SEC:{
      t = jj_consume_token(SEC);
      break;
      }
    case SECOND:{
      t = jj_consume_token(SECOND);
      break;
      }
    case SECONDS:{
      t = jj_consume_token(SECONDS);
      break;
      }
    case SEEK:{
      t = jj_consume_token(SEEK);
      break;
      }
    case SET:{
      t = jj_consume_token(SET);
      break;
      }
    case SHORTEST_PATH:{
      t = jj_consume_token(SHORTEST_PATH);
      break;
      }
    case SHOW:{
      t = jj_consume_token(SHOW);
      break;
      }
    case SINGLE:{
      t = jj_consume_token(SINGLE);
      break;
      }
    case SKIPROWS:{
      t = jj_consume_token(SKIPROWS);
      break;
      }
    case START:{
      t = jj_consume_token(START);
      break;
      }
    case STARTS:{
      t = jj_consume_token(STARTS);
      break;
      }
    case STATUS:{
      t = jj_consume_token(STATUS);
      break;
      }
    case STOP:{
      t = jj_consume_token(STOP);
      break;
      }
    case SUSPENDED:{
      t = jj_consume_token(SUSPENDED);
      break;
      }
    case TARGET:{
      t = jj_consume_token(TARGET);
      break;
      }
    case TERMINATE:{
      t = jj_consume_token(TERMINATE);
      break;
      }
    case TEXT:{
      t = jj_consume_token(TEXT);
      break;
      }
    case THEN:{
      t = jj_consume_token(THEN);
      break;
      }
    case TO:{
      t = jj_consume_token(TO);
      break;
      }
    case TRANSACTION:{
      t = jj_consume_token(TRANSACTION);
      break;
      }
    case TRANSACTIONS:{
      t = jj_consume_token(TRANSACTIONS);
      break;
      }
    case TRAVERSE:{
      t = jj_consume_token(TRAVERSE);
      break;
      }
    case TRUE:{
      t = jj_consume_token(TRUE);
      break;
      }
    case TYPE:{
      t = jj_consume_token(TYPE);
      break;
      }
    case TYPES:{
      t = jj_consume_token(TYPES);
      break;
      }
    case UNION:{
      t = jj_consume_token(UNION);
      break;
      }
    case UNIQUE:{
      t = jj_consume_token(UNIQUE);
      break;
      }
    case UNWIND:{
      t = jj_consume_token(UNWIND);
      break;
      }
    case USE:{
      t = jj_consume_token(USE);
      break;
      }
    case USER:{
      t = jj_consume_token(USER);
      break;
      }
    case USERS:{
      t = jj_consume_token(USERS);
      break;
      }
    case USING:{
      t = jj_consume_token(USING);
      break;
      }
    case VERBOSE:{
      t = jj_consume_token(VERBOSE);
      break;
      }
    case WAIT:{
      t = jj_consume_token(WAIT);
      break;
      }
    case WHEN:{
      t = jj_consume_token(WHEN);
      break;
      }
    case WHERE:{
      t = jj_consume_token(WHERE);
      break;
      }
    case WITH:{
      t = jj_consume_token(WITH);
      break;
      }
    case WRITE:{
      t = jj_consume_token(WRITE);
      break;
      }
    case XOR:{
      t = jj_consume_token(XOR);
      break;
      }
    case YIELD:{
      t = jj_consume_token(YIELD);
      break;
      }
    default:
      jj_la1[428] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t;}
    throw new IllegalStateException ("Missing return statement in function");
}

  private boolean jj_2_1(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_4()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_5()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_6()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_7()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_8()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_9()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_10()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_11()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_12()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_13()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_14()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_15()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_16()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_17()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_18()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_19()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_20()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_21()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_22()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_23()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_24()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_2_25(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_25()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  private boolean jj_2_26(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_26()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  private boolean jj_2_27(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_27()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  private boolean jj_2_28(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_28()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  private boolean jj_2_29(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_29()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  private boolean jj_2_30(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_30()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  private boolean jj_2_31(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_31()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  private boolean jj_2_32(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_32()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  private boolean jj_2_33(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_33()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  private boolean jj_2_34(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_34()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  private boolean jj_2_35(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_35()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  private boolean jj_2_36(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_36()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  private boolean jj_2_37(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_37()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  private boolean jj_2_38(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_38()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  private boolean jj_2_39(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_39()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  private boolean jj_2_40(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_40()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  private boolean jj_2_41(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_41()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  private boolean jj_2_42(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_42()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  private boolean jj_2_43(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_43()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  private boolean jj_2_44(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_44()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  private boolean jj_2_45(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_45()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  private boolean jj_2_46(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_46()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  private boolean jj_2_47(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_47()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  private boolean jj_2_48(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_48()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(47, xla); }
  }

  private boolean jj_2_49(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_49()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(48, xla); }
  }

  private boolean jj_2_50(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_50()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(49, xla); }
  }

  private boolean jj_2_51(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_51()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(50, xla); }
  }

  private boolean jj_2_52(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_52()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(51, xla); }
  }

  private boolean jj_2_53(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_53()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(52, xla); }
  }

  private boolean jj_2_54(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_54()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(53, xla); }
  }

  private boolean jj_2_55(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_55()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(54, xla); }
  }

  private boolean jj_2_56(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_56()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(55, xla); }
  }

  private boolean jj_2_57(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_57()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(56, xla); }
  }

  private boolean jj_2_58(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_58()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(57, xla); }
  }

  private boolean jj_2_59(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_59()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(58, xla); }
  }

  private boolean jj_2_60(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_60()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(59, xla); }
  }

  private boolean jj_2_61(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_61()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(60, xla); }
  }

  private boolean jj_2_62(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_62()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(61, xla); }
  }

  private boolean jj_2_63(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_63()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(62, xla); }
  }

  private boolean jj_2_64(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_64()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(63, xla); }
  }

  private boolean jj_2_65(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_65()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(64, xla); }
  }

  private boolean jj_2_66(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_66()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(65, xla); }
  }

  private boolean jj_2_67(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_67()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(66, xla); }
  }

  private boolean jj_2_68(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_68()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(67, xla); }
  }

  private boolean jj_2_69(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_69()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(68, xla); }
  }

  private boolean jj_2_70(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_70()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(69, xla); }
  }

  private boolean jj_2_71(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_71()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(70, xla); }
  }

  private boolean jj_2_72(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_72()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(71, xla); }
  }

  private boolean jj_2_73(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_73()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(72, xla); }
  }

  private boolean jj_3R_198()
 {
    Token xsp;
    if (jj_3R_233()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_233()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_107()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_136()) {
    jj_scanpos = xsp;
    if (jj_3R_137()) {
    jj_scanpos = xsp;
    if (jj_3R_138()) {
    jj_scanpos = xsp;
    if (jj_3R_139()) {
    jj_scanpos = xsp;
    if (jj_3R_140()) {
    jj_scanpos = xsp;
    if (jj_3_26()) {
    jj_scanpos = xsp;
    if (jj_3_27()) {
    jj_scanpos = xsp;
    if (jj_3_28()) {
    jj_scanpos = xsp;
    if (jj_3_29()) {
    jj_scanpos = xsp;
    if (jj_3_30()) {
    jj_scanpos = xsp;
    if (jj_3_31()) {
    jj_scanpos = xsp;
    if (jj_3R_141()) {
    jj_scanpos = xsp;
    if (jj_3_32()) {
    jj_scanpos = xsp;
    if (jj_3R_142()) {
    jj_scanpos = xsp;
    if (jj_3_34()) {
    jj_scanpos = xsp;
    if (jj_3_35()) {
    jj_scanpos = xsp;
    if (jj_3_36()) {
    jj_scanpos = xsp;
    if (jj_3_37()) {
    jj_scanpos = xsp;
    if (jj_3_38()) {
    jj_scanpos = xsp;
    if (jj_3_39()) {
    jj_scanpos = xsp;
    if (jj_3_40()) {
    jj_scanpos = xsp;
    if (jj_3_41()) {
    jj_scanpos = xsp;
    if (jj_3R_143()) {
    jj_scanpos = xsp;
    if (jj_3_43()) {
    jj_scanpos = xsp;
    if (jj_3R_144()) {
    jj_scanpos = xsp;
    if (jj_3R_145()) {
    jj_scanpos = xsp;
    if (jj_3R_146()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_233()
 {
    if (jj_3R_243()) return true;
    return false;
  }

  private boolean jj_3R_63()
 {
    if (jj_scan_token(CREATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_98()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_99()) {
    jj_scanpos = xsp;
    if (jj_3R_100()) {
    jj_scanpos = xsp;
    if (jj_3R_101()) {
    jj_scanpos = xsp;
    if (jj_3R_102()) {
    jj_scanpos = xsp;
    if (jj_3R_103()) {
    jj_scanpos = xsp;
    if (jj_3R_104()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_136()
 {
    if (jj_3R_176()) return true;
    return false;
  }

  private boolean jj_3R_99()
 {
    if (jj_3R_130()) return true;
    return false;
  }

  private boolean jj_3R_137()
 {
    if (jj_3R_177()) return true;
    return false;
  }

  private boolean jj_3R_100()
 {
    if (jj_3R_131()) return true;
    return false;
  }

  private boolean jj_3R_138()
 {
    if (jj_3R_178()) return true;
    return false;
  }

  private boolean jj_3_53()
 {
    if (jj_scan_token(CURRENT)) return true;
    if (jj_scan_token(USER)) return true;
    return false;
  }

  private boolean jj_3R_101()
 {
    if (jj_3R_132()) return true;
    return false;
  }

  private boolean jj_3R_139()
 {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  private boolean jj_3R_102()
 {
    if (jj_3R_133()) return true;
    return false;
  }

  private boolean jj_3R_140()
 {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  private boolean jj_3_26()
 {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_103()
 {
    if (jj_3R_134()) return true;
    return false;
  }

  private boolean jj_3R_108()
 {
    if (jj_3R_147()) return true;
    return false;
  }

  private boolean jj_3_27()
 {
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3R_104()
 {
    if (jj_3R_135()) return true;
    return false;
  }

  private boolean jj_3_28()
 {
    if (jj_scan_token(COUNT)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(TIMES)) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_317()
 {
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3_29()
 {
    if (jj_3R_72()) return true;
    return false;
  }

  private boolean jj_3_30()
 {
    if (jj_3R_78()) return true;
    return false;
  }

  private boolean jj_3_31()
 {
    if (jj_3R_79()) return true;
    return false;
  }

  private boolean jj_3R_98()
 {
    if (jj_scan_token(OR)) return true;
    return false;
  }

  private boolean jj_3R_141()
 {
    if (jj_3R_179()) return true;
    return false;
  }

  private boolean jj_3_32()
 {
    if (jj_3R_80()) return true;
    return false;
  }

  private boolean jj_3R_197()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_230()) {
    jj_scanpos = xsp;
    if (jj_3R_231()) {
    jj_scanpos = xsp;
    if (jj_3R_232()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_142()
 {
    if (jj_3R_180()) return true;
    return false;
  }

  private boolean jj_3_34()
 {
    if (jj_3R_82()) return true;
    return false;
  }

  private boolean jj_3_35()
 {
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3_36()
 {
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_119()
 {
    if (jj_3R_154()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_318()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_37()
 {
    if (jj_3R_85()) return true;
    return false;
  }

  private boolean jj_3_38()
 {
    if (jj_3R_86()) return true;
    return false;
  }

  private boolean jj_3R_230()
 {
    if (jj_3R_240()) return true;
    return false;
  }

  private boolean jj_3R_243()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_263()) {
    jj_scanpos = xsp;
    if (jj_3R_264()) {
    jj_scanpos = xsp;
    if (jj_3R_265()) {
    jj_scanpos = xsp;
    if (jj_3R_266()) {
    jj_scanpos = xsp;
    if (jj_3R_267()) {
    jj_scanpos = xsp;
    if (jj_3R_268()) {
    jj_scanpos = xsp;
    if (jj_3R_269()) {
    jj_scanpos = xsp;
    if (jj_3R_270()) {
    jj_scanpos = xsp;
    if (jj_3R_271()) {
    jj_scanpos = xsp;
    if (jj_3R_272()) {
    jj_scanpos = xsp;
    if (jj_3_5()) {
    jj_scanpos = xsp;
    if (jj_3R_273()) {
    jj_scanpos = xsp;
    if (jj_3R_274()) {
    jj_scanpos = xsp;
    if (jj_3R_275()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_39()
 {
    if (jj_3R_87()) return true;
    return false;
  }

  private boolean jj_3_40()
 {
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3_41()
 {
    if (jj_3R_89()) return true;
    return false;
  }

  private boolean jj_3R_231()
 {
    if (jj_3R_241()) return true;
    return false;
  }

  private boolean jj_3R_143()
 {
    if (jj_3R_181()) return true;
    return false;
  }

  private boolean jj_3R_232()
 {
    if (jj_3R_242()) return true;
    return false;
  }

  private boolean jj_3_43()
 {
    if (jj_3R_91()) return true;
    return false;
  }

  private boolean jj_3R_263()
 {
    if (jj_3R_128()) return true;
    return false;
  }

  private boolean jj_3_33()
 {
    if (jj_3R_81()) return true;
    return false;
  }

  private boolean jj_3R_144()
 {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_68()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_145()
 {
    if (jj_3R_182()) return true;
    return false;
  }

  private boolean jj_3R_146()
 {
    if (jj_3R_67()) return true;
    return false;
  }

  private boolean jj_3R_264()
 {
    if (jj_3R_288()) return true;
    return false;
  }

  private boolean jj_3R_265()
 {
    if (jj_3R_289()) return true;
    return false;
  }

  private boolean jj_3_14()
 {
    if (jj_3R_67()) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_3R_225()) return true;
    return false;
  }

  private boolean jj_3R_154()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_14()) {
    jj_scanpos = xsp;
    if (jj_3R_191()) return true;
    }
    return false;
  }

  private boolean jj_3R_240()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_255()) {
    jj_scanpos = xsp;
    if (jj_3R_256()) {
    jj_scanpos = xsp;
    if (jj_3R_257()) {
    jj_scanpos = xsp;
    if (jj_3R_258()) {
    jj_scanpos = xsp;
    if (jj_3R_259()) {
    jj_scanpos = xsp;
    if (jj_3R_260()) {
    jj_scanpos = xsp;
    if (jj_3R_261()) {
    jj_scanpos = xsp;
    if (jj_3R_262()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_266()
 {
    if (jj_3R_290()) return true;
    return false;
  }

  private boolean jj_3R_267()
 {
    if (jj_3R_291()) return true;
    return false;
  }

  private boolean jj_3R_268()
 {
    if (jj_3R_292()) return true;
    return false;
  }

  private boolean jj_3R_191()
 {
    if (jj_3R_225()) return true;
    return false;
  }

  private boolean jj_3R_269()
 {
    if (jj_3R_293()) return true;
    return false;
  }

  private boolean jj_3R_270()
 {
    if (jj_3R_294()) return true;
    return false;
  }

  private boolean jj_3_42()
 {
    if (jj_3R_90()) return true;
    if (jj_3R_70()) return true;
    return false;
  }

  private boolean jj_3R_255()
 {
    if (jj_3R_280()) return true;
    return false;
  }

  private boolean jj_3R_271()
 {
    if (jj_3R_295()) return true;
    return false;
  }

  private boolean jj_3R_272()
 {
    if (jj_3R_296()) return true;
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_3R_65()) return true;
    return false;
  }

  private boolean jj_3_44()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_92()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_93()) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_256()
 {
    if (jj_3R_281()) return true;
    return false;
  }

  private boolean jj_3R_273()
 {
    if (jj_3R_297()) return true;
    return false;
  }

  private boolean jj_3R_77()
 {
    if (jj_scan_token(CASE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_118()) {
    jj_scanpos = xsp;
    if (jj_scan_token(236)) return true;
    }
    if (jj_3R_68()) return true;
    if (jj_scan_token(THEN)) return true;
    if (jj_3R_68()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_304()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_305()) jj_scanpos = xsp;
    if (jj_scan_token(END)) return true;
    return false;
  }

  private boolean jj_3R_92()
 {
    if (jj_3R_93()) return true;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_225()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_237()) {
    jj_scanpos = xsp;
    if (jj_3_15()) {
    jj_scanpos = xsp;
    if (jj_3R_238()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_257()
 {
    if (jj_3R_282()) return true;
    return false;
  }

  private boolean jj_3R_274()
 {
    if (jj_3R_298()) return true;
    return false;
  }

  private boolean jj_3R_258()
 {
    if (jj_3R_283()) return true;
    return false;
  }

  private boolean jj_3R_275()
 {
    if (jj_3R_299()) return true;
    return false;
  }

  private boolean jj_3R_259()
 {
    if (jj_3R_284()) return true;
    return false;
  }

  private boolean jj_3R_260()
 {
    if (jj_3R_285()) return true;
    return false;
  }

  private boolean jj_3R_261()
 {
    if (jj_3R_286()) return true;
    return false;
  }

  private boolean jj_3R_237()
 {
    if (jj_3R_126()) return true;
    return false;
  }

  private boolean jj_3R_262()
 {
    if (jj_3R_287()) return true;
    return false;
  }

  private boolean jj_3R_118()
 {
    if (jj_3R_68()) return true;
    if (jj_scan_token(WHEN)) return true;
    return false;
  }

  private boolean jj_3_15()
 {
    if (jj_3R_69()) return true;
    return false;
  }

  private boolean jj_3_54()
 {
    if (jj_scan_token(YIELD)) return true;
    return false;
  }

  private boolean jj_3R_238()
 {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_225()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_128()
 {
    if (jj_scan_token(USE)) return true;
    return false;
  }

  private boolean jj_3R_304()
 {
    if (jj_scan_token(WHEN)) return true;
    if (jj_3R_68()) return true;
    if (jj_scan_token(THEN)) return true;
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3_55()
 {
    if (jj_scan_token(WHERE)) return true;
    return false;
  }

  private boolean jj_3R_280()
 {
    if (jj_scan_token(DROP)) return true;
    return false;
  }

  private boolean jj_3R_305()
 {
    if (jj_scan_token(ELSE)) return true;
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_126()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_165()) {
    jj_scanpos = xsp;
    if (jj_3R_166()) return true;
    }
    return false;
  }

  private boolean jj_3R_165()
 {
    if (jj_scan_token(SHORTEST_PATH)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_69()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_318()
 {
    if (jj_scan_token(250)) return true;
    if (jj_3R_154()) return true;
    return false;
  }

  private boolean jj_3_45()
 {
    if (jj_3R_68()) return true;
    if (jj_scan_token(WHEN)) return true;
    return false;
  }

  private boolean jj_3R_166()
 {
    if (jj_scan_token(ALL_SHORTEST_PATH)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_69()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_scan_token(GRAPH)) return true;
    return false;
  }

  private boolean jj_3R_288()
 {
    if (jj_scan_token(RETURN)) return true;
    return false;
  }

  private boolean jj_3R_80()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_67()) return true;
    if (jj_scan_token(IN)) return true;
    if (jj_3R_68()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_307()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_308()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_69()
 {
    if (jj_3R_90()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_16()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_281()
 {
    if (jj_scan_token(ALTER)) return true;
    return false;
  }

  private boolean jj_3_16()
 {
    if (jj_3R_70()) return true;
    if (jj_3R_90()) return true;
    return false;
  }

  private boolean jj_3R_131()
 {
    if (jj_scan_token(USER)) return true;
    return false;
  }

  private boolean jj_3R_180()
 {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_207()) jj_scanpos = xsp;
    if (jj_3R_208()) return true;
    xsp = jj_scanpos;
    if (jj_3R_309()) jj_scanpos = xsp;
    if (jj_scan_token(BAR)) return true;
    if (jj_3R_68()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_208()
 {
    if (jj_3R_90()) return true;
    Token xsp;
    if (jj_3_17()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_17()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_7()
 {
    if (jj_scan_token(DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_81()
 {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_120()) jj_scanpos = xsp;
    if (jj_3R_69()) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(237)) {
    jj_scanpos = xsp;
    if (jj_scan_token(58)) return true;
    }
    return false;
  }

  private boolean jj_3_17()
 {
    if (jj_3R_70()) return true;
    if (jj_3R_90()) return true;
    return false;
  }

  private boolean jj_3R_241()
 {
    if (jj_scan_token(SHOW)) return true;
    return false;
  }

  private boolean jj_3R_207()
 {
    if (jj_3R_67()) return true;
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  private boolean jj_3R_83()
 {
    if (jj_scan_token(FILTER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_67()) return true;
    if (jj_scan_token(IN)) return true;
    if (jj_3R_68()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_310()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_133()
 {
    if (jj_scan_token(CONSTRAINT)) return true;
    return false;
  }

  private boolean jj_3R_120()
 {
    if (jj_3R_67()) return true;
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  private boolean jj_3R_90()
 {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_123()) {
    jj_scanpos = xsp;
    if (jj_3R_124()) return true;
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_123()
 {
    if (jj_3R_67()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_155()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_156()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_157()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_124()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_158()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_159()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_307()
 {
    if (jj_scan_token(WHERE)) return true;
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_158()
 {
    if (jj_3R_192()) return true;
    return false;
  }

  private boolean jj_3_56()
 {
    if (jj_3R_93()) return true;
    return false;
  }

  private boolean jj_3R_84()
 {
    if (jj_scan_token(EXTRACT)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_67()) return true;
    if (jj_scan_token(IN)) return true;
    if (jj_3R_68()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_311()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_312()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_57()
 {
    if (jj_scan_token(ON)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_192()
 {
    Token xsp;
    if (jj_3_18()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_18()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_58()
 {
    if (jj_scan_token(FOR)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3_18()
 {
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3_59()
 {
    if (jj_scan_token(IF)) return true;
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_155()
 {
    if (jj_3R_192()) return true;
    return false;
  }

  private boolean jj_3R_85()
 {
    if (jj_scan_token(REDUCE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_67()) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_3R_68()) return true;
    if (jj_scan_token(250)) return true;
    if (jj_3R_67()) return true;
    if (jj_scan_token(IN)) return true;
    if (jj_3R_68()) return true;
    if (jj_scan_token(BAR)) return true;
    if (jj_3R_68()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_223()
 {
    if (jj_3R_192()) return true;
    return false;
  }

  private boolean jj_3_60()
 {
    if (jj_scan_token(ASSERT)) return true;
    if (jj_scan_token(EXISTS)) return true;
    return false;
  }

  private boolean jj_3R_242()
 {
    if (jj_scan_token(TERMINATE)) return true;
    return false;
  }

  private boolean jj_3R_159()
 {
    if (jj_3R_193()) return true;
    return false;
  }

  private boolean jj_3R_71()
 {
    if (jj_scan_token(252)) return true;
    if (jj_3R_93()) return true;
    return false;
  }

  private boolean jj_3R_308()
 {
    if (jj_scan_token(BAR)) return true;
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_156()
 {
    if (jj_3R_193()) return true;
    return false;
  }

  private boolean jj_3R_93()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(242)) {
    jj_scanpos = xsp;
    if (jj_scan_token(43)) {
    jj_scanpos = xsp;
    if (jj_scan_token(44)) {
    jj_scanpos = xsp;
    if (jj_scan_token(45)) {
    jj_scanpos = xsp;
    if (jj_scan_token(46)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) {
    jj_scanpos = xsp;
    if (jj_scan_token(50)) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(52)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) {
    jj_scanpos = xsp;
    if (jj_scan_token(54)) {
    jj_scanpos = xsp;
    if (jj_scan_token(55)) {
    jj_scanpos = xsp;
    if (jj_scan_token(56)) {
    jj_scanpos = xsp;
    if (jj_scan_token(57)) {
    jj_scanpos = xsp;
    if (jj_scan_token(59)) {
    jj_scanpos = xsp;
    if (jj_scan_token(60)) {
    jj_scanpos = xsp;
    if (jj_scan_token(61)) {
    jj_scanpos = xsp;
    if (jj_scan_token(62)) {
    jj_scanpos = xsp;
    if (jj_scan_token(63)) {
    jj_scanpos = xsp;
    if (jj_scan_token(64)) {
    jj_scanpos = xsp;
    if (jj_scan_token(65)) {
    jj_scanpos = xsp;
    if (jj_scan_token(66)) {
    jj_scanpos = xsp;
    if (jj_scan_token(67)) {
    jj_scanpos = xsp;
    if (jj_scan_token(68)) {
    jj_scanpos = xsp;
    if (jj_scan_token(69)) {
    jj_scanpos = xsp;
    if (jj_scan_token(70)) {
    jj_scanpos = xsp;
    if (jj_scan_token(71)) {
    jj_scanpos = xsp;
    if (jj_scan_token(72)) {
    jj_scanpos = xsp;
    if (jj_scan_token(73)) {
    jj_scanpos = xsp;
    if (jj_scan_token(74)) {
    jj_scanpos = xsp;
    if (jj_scan_token(75)) {
    jj_scanpos = xsp;
    if (jj_scan_token(76)) {
    jj_scanpos = xsp;
    if (jj_scan_token(77)) {
    jj_scanpos = xsp;
    if (jj_scan_token(78)) {
    jj_scanpos = xsp;
    if (jj_scan_token(79)) {
    jj_scanpos = xsp;
    if (jj_scan_token(80)) {
    jj_scanpos = xsp;
    if (jj_scan_token(81)) {
    jj_scanpos = xsp;
    if (jj_scan_token(82)) {
    jj_scanpos = xsp;
    if (jj_scan_token(83)) {
    jj_scanpos = xsp;
    if (jj_scan_token(84)) {
    jj_scanpos = xsp;
    if (jj_scan_token(85)) {
    jj_scanpos = xsp;
    if (jj_scan_token(86)) {
    jj_scanpos = xsp;
    if (jj_scan_token(88)) {
    jj_scanpos = xsp;
    if (jj_scan_token(92)) {
    jj_scanpos = xsp;
    if (jj_scan_token(93)) {
    jj_scanpos = xsp;
    if (jj_scan_token(94)) {
    jj_scanpos = xsp;
    if (jj_scan_token(95)) {
    jj_scanpos = xsp;
    if (jj_scan_token(96)) {
    jj_scanpos = xsp;
    if (jj_scan_token(97)) {
    jj_scanpos = xsp;
    if (jj_scan_token(98)) {
    jj_scanpos = xsp;
    if (jj_scan_token(99)) {
    jj_scanpos = xsp;
    if (jj_scan_token(100)) {
    jj_scanpos = xsp;
    if (jj_scan_token(101)) {
    jj_scanpos = xsp;
    if (jj_scan_token(103)) {
    jj_scanpos = xsp;
    if (jj_scan_token(104)) {
    jj_scanpos = xsp;
    if (jj_scan_token(105)) {
    jj_scanpos = xsp;
    if (jj_scan_token(106)) {
    jj_scanpos = xsp;
    if (jj_scan_token(107)) {
    jj_scanpos = xsp;
    if (jj_scan_token(108)) {
    jj_scanpos = xsp;
    if (jj_scan_token(109)) {
    jj_scanpos = xsp;
    if (jj_scan_token(110)) {
    jj_scanpos = xsp;
    if (jj_scan_token(112)) {
    jj_scanpos = xsp;
    if (jj_scan_token(111)) {
    jj_scanpos = xsp;
    if (jj_scan_token(113)) {
    jj_scanpos = xsp;
    if (jj_scan_token(114)) {
    jj_scanpos = xsp;
    if (jj_scan_token(115)) {
    jj_scanpos = xsp;
    if (jj_scan_token(116)) {
    jj_scanpos = xsp;
    if (jj_scan_token(118)) {
    jj_scanpos = xsp;
    if (jj_scan_token(119)) {
    jj_scanpos = xsp;
    if (jj_scan_token(120)) {
    jj_scanpos = xsp;
    if (jj_scan_token(122)) {
    jj_scanpos = xsp;
    if (jj_scan_token(123)) {
    jj_scanpos = xsp;
    if (jj_scan_token(124)) {
    jj_scanpos = xsp;
    if (jj_scan_token(126)) {
    jj_scanpos = xsp;
    if (jj_scan_token(127)) {
    jj_scanpos = xsp;
    if (jj_scan_token(128)) {
    jj_scanpos = xsp;
    if (jj_scan_token(129)) {
    jj_scanpos = xsp;
    if (jj_scan_token(130)) {
    jj_scanpos = xsp;
    if (jj_scan_token(131)) {
    jj_scanpos = xsp;
    if (jj_scan_token(132)) {
    jj_scanpos = xsp;
    if (jj_scan_token(133)) {
    jj_scanpos = xsp;
    if (jj_scan_token(137)) {
    jj_scanpos = xsp;
    if (jj_scan_token(138)) {
    jj_scanpos = xsp;
    if (jj_scan_token(139)) {
    jj_scanpos = xsp;
    if (jj_scan_token(143)) {
    jj_scanpos = xsp;
    if (jj_scan_token(142)) {
    jj_scanpos = xsp;
    if (jj_scan_token(144)) {
    jj_scanpos = xsp;
    if (jj_scan_token(149)) {
    jj_scanpos = xsp;
    if (jj_scan_token(150)) {
    jj_scanpos = xsp;
    if (jj_scan_token(151)) {
    jj_scanpos = xsp;
    if (jj_scan_token(152)) {
    jj_scanpos = xsp;
    if (jj_scan_token(153)) {
    jj_scanpos = xsp;
    if (jj_scan_token(154)) {
    jj_scanpos = xsp;
    if (jj_scan_token(155)) {
    jj_scanpos = xsp;
    if (jj_scan_token(156)) {
    jj_scanpos = xsp;
    if (jj_scan_token(157)) {
    jj_scanpos = xsp;
    if (jj_scan_token(158)) {
    jj_scanpos = xsp;
    if (jj_scan_token(159)) {
    jj_scanpos = xsp;
    if (jj_scan_token(160)) {
    jj_scanpos = xsp;
    if (jj_scan_token(161)) {
    jj_scanpos = xsp;
    if (jj_scan_token(162)) {
    jj_scanpos = xsp;
    if (jj_scan_token(163)) {
    jj_scanpos = xsp;
    if (jj_scan_token(164)) {
    jj_scanpos = xsp;
    if (jj_scan_token(165)) {
    jj_scanpos = xsp;
    if (jj_scan_token(166)) {
    jj_scanpos = xsp;
    if (jj_scan_token(167)) {
    jj_scanpos = xsp;
    if (jj_scan_token(168)) {
    jj_scanpos = xsp;
    if (jj_scan_token(169)) {
    jj_scanpos = xsp;
    if (jj_scan_token(171)) {
    jj_scanpos = xsp;
    if (jj_scan_token(172)) {
    jj_scanpos = xsp;
    if (jj_scan_token(174)) {
    jj_scanpos = xsp;
    if (jj_scan_token(175)) {
    jj_scanpos = xsp;
    if (jj_scan_token(176)) {
    jj_scanpos = xsp;
    if (jj_scan_token(177)) {
    jj_scanpos = xsp;
    if (jj_scan_token(178)) {
    jj_scanpos = xsp;
    if (jj_scan_token(179)) {
    jj_scanpos = xsp;
    if (jj_scan_token(182)) {
    jj_scanpos = xsp;
    if (jj_scan_token(183)) {
    jj_scanpos = xsp;
    if (jj_scan_token(186)) {
    jj_scanpos = xsp;
    if (jj_scan_token(187)) {
    jj_scanpos = xsp;
    if (jj_scan_token(188)) {
    jj_scanpos = xsp;
    if (jj_scan_token(189)) {
    jj_scanpos = xsp;
    if (jj_scan_token(184)) {
    jj_scanpos = xsp;
    if (jj_scan_token(190)) {
    jj_scanpos = xsp;
    if (jj_scan_token(191)) {
    jj_scanpos = xsp;
    if (jj_scan_token(192)) {
    jj_scanpos = xsp;
    if (jj_scan_token(193)) {
    jj_scanpos = xsp;
    if (jj_scan_token(194)) {
    jj_scanpos = xsp;
    if (jj_scan_token(195)) {
    jj_scanpos = xsp;
    if (jj_scan_token(196)) {
    jj_scanpos = xsp;
    if (jj_scan_token(197)) {
    jj_scanpos = xsp;
    if (jj_scan_token(198)) {
    jj_scanpos = xsp;
    if (jj_scan_token(200)) {
    jj_scanpos = xsp;
    if (jj_scan_token(201)) {
    jj_scanpos = xsp;
    if (jj_scan_token(202)) {
    jj_scanpos = xsp;
    if (jj_scan_token(203)) {
    jj_scanpos = xsp;
    if (jj_scan_token(204)) {
    jj_scanpos = xsp;
    if (jj_scan_token(205)) {
    jj_scanpos = xsp;
    if (jj_scan_token(206)) {
    jj_scanpos = xsp;
    if (jj_scan_token(207)) {
    jj_scanpos = xsp;
    if (jj_scan_token(208)) {
    jj_scanpos = xsp;
    if (jj_scan_token(209)) {
    jj_scanpos = xsp;
    if (jj_scan_token(210)) {
    jj_scanpos = xsp;
    if (jj_scan_token(211)) {
    jj_scanpos = xsp;
    if (jj_scan_token(212)) {
    jj_scanpos = xsp;
    if (jj_scan_token(213)) {
    jj_scanpos = xsp;
    if (jj_scan_token(214)) {
    jj_scanpos = xsp;
    if (jj_scan_token(215)) {
    jj_scanpos = xsp;
    if (jj_scan_token(216)) {
    jj_scanpos = xsp;
    if (jj_scan_token(217)) {
    jj_scanpos = xsp;
    if (jj_scan_token(218)) {
    jj_scanpos = xsp;
    if (jj_scan_token(220)) {
    jj_scanpos = xsp;
    if (jj_scan_token(221)) {
    jj_scanpos = xsp;
    if (jj_scan_token(222)) {
    jj_scanpos = xsp;
    if (jj_scan_token(223)) {
    jj_scanpos = xsp;
    if (jj_scan_token(224)) {
    jj_scanpos = xsp;
    if (jj_scan_token(225)) {
    jj_scanpos = xsp;
    if (jj_scan_token(226)) {
    jj_scanpos = xsp;
    if (jj_scan_token(227)) {
    jj_scanpos = xsp;
    if (jj_scan_token(228)) {
    jj_scanpos = xsp;
    if (jj_scan_token(229)) {
    jj_scanpos = xsp;
    if (jj_scan_token(230)) {
    jj_scanpos = xsp;
    if (jj_scan_token(231)) {
    jj_scanpos = xsp;
    if (jj_scan_token(232)) {
    jj_scanpos = xsp;
    if (jj_scan_token(233)) {
    jj_scanpos = xsp;
    if (jj_scan_token(234)) {
    jj_scanpos = xsp;
    if (jj_scan_token(235)) {
    jj_scanpos = xsp;
    if (jj_scan_token(236)) {
    jj_scanpos = xsp;
    if (jj_scan_token(237)) {
    jj_scanpos = xsp;
    if (jj_scan_token(238)) {
    jj_scanpos = xsp;
    if (jj_scan_token(239)) {
    jj_scanpos = xsp;
    if (jj_scan_token(240)) {
    jj_scanpos = xsp;
    if (jj_scan_token(241)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_86()
 {
    if (jj_scan_token(ALL)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_67()) return true;
    if (jj_scan_token(IN)) return true;
    if (jj_3R_68()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_313()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_310()
 {
    if (jj_scan_token(WHERE)) return true;
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_87()
 {
    if (jj_scan_token(ANY)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_67()) return true;
    if (jj_scan_token(IN)) return true;
    if (jj_3R_68()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_314()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_193()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_19()) {
    jj_scanpos = xsp;
    if (jj_3R_226()) {
    jj_scanpos = xsp;
    if (jj_3R_227()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_19()
 {
    if (jj_3R_72()) return true;
    return false;
  }

  private boolean jj_3R_157()
 {
    if (jj_scan_token(WHERE)) return true;
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_311()
 {
    if (jj_scan_token(WHERE)) return true;
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_226()
 {
    if (jj_3R_178()) return true;
    return false;
  }

  private boolean jj_3R_227()
 {
    if (jj_3R_179()) return true;
    return false;
  }

  private boolean jj_3R_88()
 {
    if (jj_scan_token(NONE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_67()) return true;
    if (jj_scan_token(IN)) return true;
    if (jj_3R_68()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_315()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_309()
 {
    if (jj_scan_token(WHERE)) return true;
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_295()
 {
    if (jj_scan_token(WITH)) return true;
    return false;
  }

  private boolean jj_3R_70()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_110()) jj_scanpos = xsp;
    if (jj_3R_111()) return true;
    xsp = jj_scanpos;
    if (jj_3R_112()) jj_scanpos = xsp;
    if (jj_3R_111()) return true;
    xsp = jj_scanpos;
    if (jj_3R_125()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_110()
 {
    if (jj_3R_150()) return true;
    return false;
  }

  private boolean jj_3R_89()
 {
    if (jj_scan_token(SINGLE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_67()) return true;
    if (jj_scan_token(IN)) return true;
    if (jj_3R_68()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_316()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_112()
 {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_160()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_161()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_162()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_163()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_161()
 {
    if (jj_scan_token(252)) return true;
    if (jj_3R_93()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_194()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_62()
 {
    if (jj_scan_token(ON)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_289()
 {
    if (jj_scan_token(CREATE)) return true;
    return false;
  }

  private boolean jj_3R_313()
 {
    if (jj_scan_token(WHERE)) return true;
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_312()
 {
    if (jj_scan_token(BAR)) return true;
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_162()
 {
    if (jj_3R_195()) return true;
    return false;
  }

  private boolean jj_3R_181()
 {
    if (jj_3R_208()) return true;
    return false;
  }

  private boolean jj_3R_160()
 {
    if (jj_3R_67()) return true;
    return false;
  }

  private boolean jj_3R_163()
 {
    if (jj_3R_193()) return true;
    return false;
  }

  private boolean jj_3R_194()
 {
    if (jj_scan_token(BAR)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_228()) jj_scanpos = xsp;
    if (jj_3R_93()) return true;
    return false;
  }

  private boolean jj_3R_150()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(141)) {
    jj_scanpos = xsp;
    if (jj_scan_token(246)) return true;
    }
    return false;
  }

  private boolean jj_3R_228()
 {
    if (jj_scan_token(252)) return true;
    return false;
  }

  private boolean jj_3_61()
 {
    if (jj_scan_token(EXISTS)) return true;
    return false;
  }

  private boolean jj_3R_111()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(245)) {
    jj_scanpos = xsp;
    if (jj_scan_token(145)) return true;
    }
    return false;
  }

  private boolean jj_3R_125()
 {
    if (jj_3R_164()) return true;
    return false;
  }

  private boolean jj_3R_314()
 {
    if (jj_scan_token(WHERE)) return true;
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_91()
 {
    if (jj_3R_126()) return true;
    return false;
  }

  private boolean jj_3R_291()
 {
    if (jj_scan_token(SET)) return true;
    return false;
  }

  private boolean jj_3R_164()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(121)) {
    jj_scanpos = xsp;
    if (jj_scan_token(247)) return true;
    }
    return false;
  }

  private boolean jj_3R_204()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(27)) {
    jj_scanpos = xsp;
    if (jj_scan_token(39)) return true;
    }
    return false;
  }

  private boolean jj_3_8()
 {
    if (jj_3R_66()) return true;
    return false;
  }

  private boolean jj_3R_315()
 {
    if (jj_scan_token(WHERE)) return true;
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_79()
 {
    if (jj_3R_67()) return true;
    if (jj_scan_token(LCURLY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_219()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_220()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RCURLY)) return true;
    return false;
  }

  private boolean jj_3R_195()
 {
    if (jj_scan_token(TIMES)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_229()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_9()
 {
    if (jj_3R_67()) return true;
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  private boolean jj_3_10()
 {
    if (jj_3R_67()) return true;
    if (jj_scan_token(251)) return true;
    return false;
  }

  private boolean jj_3_20()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(12)) jj_scanpos = xsp;
    if (jj_scan_token(DOTDOT)) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(12)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_229()
 {
    if (jj_3R_239()) return true;
    return false;
  }

  private boolean jj_3R_239()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_20()) {
    jj_scanpos = xsp;
    if (jj_3R_254()) return true;
    }
    return false;
  }

  private boolean jj_3_46()
 {
    if (jj_3R_94()) return true;
    if (jj_scan_token(252)) return true;
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_236()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_46()) {
    jj_scanpos = xsp;
    if (jj_3_47()) {
    jj_scanpos = xsp;
    if (jj_3R_252()) {
    jj_scanpos = xsp;
    if (jj_3R_253()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_292()
 {
    if (jj_scan_token(REMOVE)) return true;
    return false;
  }

  private boolean jj_3R_316()
 {
    if (jj_scan_token(WHERE)) return true;
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_134()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_169()) {
    jj_scanpos = xsp;
    if (jj_3R_170()) {
    jj_scanpos = xsp;
    if (jj_3R_171()) {
    jj_scanpos = xsp;
    if (jj_3R_172()) {
    jj_scanpos = xsp;
    if (jj_3R_173()) {
    jj_scanpos = xsp;
    if (jj_3R_174()) {
    jj_scanpos = xsp;
    if (jj_3R_175()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_47()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_94()) return true;
    return false;
  }

  private boolean jj_3R_252()
 {
    if (jj_3R_67()) return true;
    return false;
  }

  private boolean jj_3R_254()
 {
    if (jj_scan_token(UNSIGNED_DECIMAL_INTEGER)) return true;
    return false;
  }

  private boolean jj_3R_253()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(TIMES)) return true;
    return false;
  }

  private boolean jj_3R_169()
 {
    if (jj_scan_token(BTREE)) return true;
    return false;
  }

  private boolean jj_3R_170()
 {
    if (jj_scan_token(RANGE)) return true;
    return false;
  }

  private boolean jj_3R_171()
 {
    if (jj_scan_token(FULLTEXT)) return true;
    return false;
  }

  private boolean jj_3R_132()
 {
    if (jj_scan_token(DATABASE)) return true;
    return false;
  }

  private boolean jj_3R_172()
 {
    if (jj_scan_token(TEXT)) return true;
    return false;
  }

  private boolean jj_3R_219()
 {
    if (jj_3R_236()) return true;
    return false;
  }

  private boolean jj_3R_78()
 {
    if (jj_scan_token(EXISTS)) return true;
    if (jj_scan_token(LCURLY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_48()) jj_scanpos = xsp;
    if (jj_3R_119()) return true;
    xsp = jj_scanpos;
    if (jj_3R_306()) jj_scanpos = xsp;
    if (jj_scan_token(RCURLY)) return true;
    return false;
  }

  private boolean jj_3R_173()
 {
    if (jj_scan_token(POINT)) return true;
    return false;
  }

  private boolean jj_3_11()
 {
    if (jj_3R_66()) return true;
    return false;
  }

  private boolean jj_3R_174()
 {
    if (jj_scan_token(LOOKUP)) return true;
    return false;
  }

  private boolean jj_3R_175()
 {
    if (jj_scan_token(INDEX)) return true;
    return false;
  }

  private boolean jj_3R_68()
 {
    if (jj_3R_109()) return true;
    return false;
  }

  private boolean jj_3_63()
 {
    if (jj_scan_token(ON)) return true;
    if (jj_scan_token(252)) return true;
    return false;
  }

  private boolean jj_3R_109()
 {
    if (jj_3R_148()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_149()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_290()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_300()) jj_scanpos = xsp;
    if (jj_scan_token(DELETE)) return true;
    return false;
  }

  private boolean jj_3R_300()
 {
    if (jj_scan_token(DETACH)) return true;
    return false;
  }

  private boolean jj_3_48()
 {
    if (jj_scan_token(MATCH)) return true;
    return false;
  }

  private boolean jj_3_49()
 {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_148()
 {
    if (jj_3R_183()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_184()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_149()
 {
    if (jj_scan_token(OR)) return true;
    if (jj_3R_148()) return true;
    return false;
  }

  private boolean jj_3R_293()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_301()) jj_scanpos = xsp;
    if (jj_scan_token(MATCH)) return true;
    return false;
  }

  private boolean jj_3R_301()
 {
    if (jj_scan_token(OPTIONAL)) return true;
    return false;
  }

  private boolean jj_3R_183()
 {
    if (jj_3R_73()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_209()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_220()
 {
    if (jj_scan_token(250)) return true;
    if (jj_3R_236()) return true;
    return false;
  }

  private boolean jj_3R_184()
 {
    if (jj_scan_token(XOR)) return true;
    if (jj_3R_183()) return true;
    return false;
  }

  private boolean jj_3_64()
 {
    if (jj_scan_token(FOR)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3_65()
 {
    if (jj_scan_token(IF)) return true;
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_73()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_21()) {
    jj_scanpos = xsp;
    if (jj_3R_115()) return true;
    }
    return false;
  }

  private boolean jj_3_21()
 {
    if (jj_scan_token(NOT)) return true;
    if (jj_3R_73()) return true;
    return false;
  }

  private boolean jj_3R_209()
 {
    if (jj_scan_token(AND)) return true;
    if (jj_3R_73()) return true;
    return false;
  }

  private boolean jj_3R_286()
 {
    if (jj_scan_token(START)) return true;
    return false;
  }

  private boolean jj_3R_115()
 {
    if (jj_3R_151()) return true;
    return false;
  }

  private boolean jj_3R_177()
 {
    if (jj_3R_204()) return true;
    return false;
  }

  private boolean jj_3R_151()
 {
    if (jj_3R_74()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_185()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_176()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_199()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_200()) {
    jj_scanpos = xsp;
    if (jj_3R_201()) {
    jj_scanpos = xsp;
    if (jj_3R_202()) {
    jj_scanpos = xsp;
    if (jj_3R_203()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_287()
 {
    if (jj_scan_token(STOP)) return true;
    return false;
  }

  private boolean jj_3R_306()
 {
    if (jj_scan_token(WHERE)) return true;
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_199()
 {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  private boolean jj_3_22()
 {
    if (jj_scan_token(EQ)) return true;
    if (jj_3R_74()) return true;
    return false;
  }

  private boolean jj_3R_185()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_22()) {
    jj_scanpos = xsp;
    if (jj_3R_211()) {
    jj_scanpos = xsp;
    if (jj_3R_212()) {
    jj_scanpos = xsp;
    if (jj_3R_213()) {
    jj_scanpos = xsp;
    if (jj_3R_214()) {
    jj_scanpos = xsp;
    if (jj_3R_215()) {
    jj_scanpos = xsp;
    if (jj_3R_216()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_200()
 {
    if (jj_scan_token(DECIMAL_DOUBLE)) return true;
    return false;
  }

  private boolean jj_3R_211()
 {
    if (jj_scan_token(NEQ)) return true;
    if (jj_3R_74()) return true;
    return false;
  }

  private boolean jj_3R_201()
 {
    if (jj_scan_token(UNSIGNED_DECIMAL_INTEGER)) return true;
    return false;
  }

  private boolean jj_3R_212()
 {
    if (jj_scan_token(NEQ2)) return true;
    if (jj_3R_74()) return true;
    return false;
  }

  private boolean jj_3R_202()
 {
    if (jj_scan_token(UNSIGNED_HEX_INTEGER)) return true;
    return false;
  }

  private boolean jj_3R_213()
 {
    if (jj_scan_token(LE)) return true;
    if (jj_3R_74()) return true;
    return false;
  }

  private boolean jj_3_12()
 {
    if (jj_scan_token(SEEK)) return true;
    return false;
  }

  private boolean jj_3R_203()
 {
    if (jj_scan_token(UNSIGNED_OCTAL_INTEGER)) return true;
    return false;
  }

  private boolean jj_3R_214()
 {
    if (jj_scan_token(GE)) return true;
    if (jj_3R_74()) return true;
    return false;
  }

  private boolean jj_3R_215()
 {
    if (jj_scan_token(LT)) return true;
    if (jj_3R_74()) return true;
    return false;
  }

  private boolean jj_3R_216()
 {
    if (jj_scan_token(GT)) return true;
    if (jj_3R_74()) return true;
    return false;
  }

  private boolean jj_3_66()
 {
    if (jj_scan_token(FOR)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3_67()
 {
    if (jj_scan_token(IF)) return true;
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_294()
 {
    if (jj_scan_token(MERGE)) return true;
    return false;
  }

  private boolean jj_3R_74()
 {
    if (jj_3R_75()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_210()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_82()
 {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_121()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_122()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_283()
 {
    if (jj_scan_token(DENY)) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_scan_token(249)) return true;
    if (jj_3R_61()) return true;
    return false;
  }

  private boolean jj_3_23()
 {
    if (jj_scan_token(REGEQ)) return true;
    if (jj_3R_75()) return true;
    return false;
  }

  private boolean jj_3R_235()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_23()) {
    jj_scanpos = xsp;
    if (jj_3R_247()) {
    jj_scanpos = xsp;
    if (jj_3R_248()) {
    jj_scanpos = xsp;
    if (jj_3R_249()) {
    jj_scanpos = xsp;
    if (jj_3R_250()) {
    jj_scanpos = xsp;
    if (jj_3R_251()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_72()
 {
    if (jj_scan_token(LCURLY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_113()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_114()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RCURLY)) return true;
    return false;
  }

  private boolean jj_3R_121()
 {
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_247()
 {
    if (jj_scan_token(STARTS)) return true;
    if (jj_scan_token(WITH)) return true;
    if (jj_3R_75()) return true;
    return false;
  }

  private boolean jj_3R_248()
 {
    if (jj_scan_token(ENDS)) return true;
    if (jj_scan_token(WITH)) return true;
    if (jj_3R_75()) return true;
    return false;
  }

  private boolean jj_3R_249()
 {
    if (jj_scan_token(CONTAINS)) return true;
    if (jj_3R_75()) return true;
    return false;
  }

  private boolean jj_3R_210()
 {
    if (jj_3R_235()) return true;
    return false;
  }

  private boolean jj_3R_250()
 {
    if (jj_scan_token(IN)) return true;
    if (jj_3R_75()) return true;
    return false;
  }

  private boolean jj_3R_296()
 {
    if (jj_scan_token(UNWIND)) return true;
    return false;
  }

  private boolean jj_3R_251()
 {
    if (jj_scan_token(IS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_302()) {
    jj_scanpos = xsp;
    if (jj_3R_303()) return true;
    }
    return false;
  }

  private boolean jj_3R_302()
 {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_114()
 {
    if (jj_scan_token(250)) return true;
    if (jj_3R_94()) return true;
    if (jj_scan_token(252)) return true;
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_303()
 {
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3_68()
 {
    if (jj_scan_token(FOR)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_94()
 {
    if (jj_3R_93()) return true;
    return false;
  }

  private boolean jj_3R_113()
 {
    if (jj_3R_94()) return true;
    if (jj_scan_token(252)) return true;
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3_69()
 {
    if (jj_scan_token(IF)) return true;
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_75()
 {
    if (jj_3R_116()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_234()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_61()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_95()) {
    jj_scanpos = xsp;
    if (jj_3R_96()) {
    jj_scanpos = xsp;
    if (jj_3R_97()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_234()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_245()) {
    jj_scanpos = xsp;
    if (jj_3R_246()) return true;
    }
    return false;
  }

  private boolean jj_3R_245()
 {
    if (jj_scan_token(PLUS)) return true;
    if (jj_3R_116()) return true;
    return false;
  }

  private boolean jj_3R_95()
 {
    if (jj_3R_127()) return true;
    return false;
  }

  private boolean jj_3_71()
 {
    if (jj_scan_token(ON)) return true;
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3R_246()
 {
    if (jj_scan_token(MINUS)) return true;
    if (jj_3R_116()) return true;
    return false;
  }

  private boolean jj_3R_178()
 {
    if (jj_scan_token(DOLLAR)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_205()) {
    jj_scanpos = xsp;
    if (jj_3R_206()) return true;
    }
    return false;
  }

  private boolean jj_3R_96()
 {
    if (jj_3R_128()) return true;
    return false;
  }

  private boolean jj_3R_65()
 {
    if (jj_scan_token(CALL)) return true;
    if (jj_3R_105()) return true;
    if (jj_3R_106()) return true;
    return false;
  }

  private boolean jj_3R_97()
 {
    if (jj_3R_129()) return true;
    return false;
  }

  private boolean jj_3R_205()
 {
    if (jj_3R_67()) return true;
    return false;
  }

  private boolean jj_3R_116()
 {
    if (jj_3R_152()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_244()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_206()
 {
    if (jj_scan_token(UNSIGNED_DECIMAL_INTEGER)) return true;
    return false;
  }

  private boolean jj_3_13()
 {
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_129()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_3()) {
    jj_scanpos = xsp;
    if (jj_3R_167()) {
    jj_scanpos = xsp;
    if (jj_3R_168()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_179()
 {
    if (jj_scan_token(LCURLY)) return true;
    if (jj_3R_67()) return true;
    if (jj_scan_token(RCURLY)) return true;
    return false;
  }

  private boolean jj_3R_244()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_277()) {
    jj_scanpos = xsp;
    if (jj_3R_278()) {
    jj_scanpos = xsp;
    if (jj_3R_279()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_277()
 {
    if (jj_scan_token(TIMES)) return true;
    if (jj_3R_152()) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_62()) jj_scanpos = xsp;
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_122()
 {
    if (jj_scan_token(250)) return true;
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_278()
 {
    if (jj_scan_token(DIVIDE)) return true;
    if (jj_3R_152()) return true;
    return false;
  }

  private boolean jj_3R_279()
 {
    if (jj_scan_token(MODULO)) return true;
    if (jj_3R_152()) return true;
    return false;
  }

  private boolean jj_3R_167()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_196()) jj_scanpos = xsp;
    if (jj_3R_197()) return true;
    return false;
  }

  private boolean jj_3R_168()
 {
    if (jj_3R_198()) return true;
    return false;
  }

  private boolean jj_3R_196()
 {
    if (jj_scan_token(CATALOG)) return true;
    return false;
  }

  private boolean jj_3R_152()
 {
    if (jj_3R_186()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_276()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_scan_token(249)) return true;
    return false;
  }

  private boolean jj_3R_62()
 {
    if (jj_scan_token(CATALOG)) return true;
    return false;
  }

  private boolean jj_3R_182()
 {
    if (jj_3R_105()) return true;
    if (jj_3R_93()) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_50()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_221()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_222()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_282()
 {
    if (jj_scan_token(RENAME)) return true;
    return false;
  }

  private boolean jj_3R_106()
 {
    if (jj_3R_93()) return true;
    return false;
  }

  private boolean jj_3_4()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_64()) jj_scanpos = xsp;
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_186()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_24()) {
    jj_scanpos = xsp;
    if (jj_3R_217()) {
    jj_scanpos = xsp;
    if (jj_3R_218()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_50()
 {
    if (jj_scan_token(DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_135()
 {
    if (jj_scan_token(ALIAS)) return true;
    return false;
  }

  private boolean jj_3R_221()
 {
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3_24()
 {
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3R_217()
 {
    if (jj_scan_token(PLUS)) return true;
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3R_276()
 {
    if (jj_scan_token(POW)) return true;
    if (jj_3R_186()) return true;
    return false;
  }

  private boolean jj_3R_105()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_51()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_218()
 {
    if (jj_scan_token(MINUS)) return true;
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3_51()
 {
    if (jj_3R_93()) return true;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3_70()
 {
    if (jj_scan_token(EACH)) return true;
    return false;
  }

  private boolean jj_3R_285()
 {
    if (jj_scan_token(GRANT)) return true;
    return false;
  }

  private boolean jj_3R_64()
 {
    if (jj_scan_token(CATALOG)) return true;
    return false;
  }

  private boolean jj_3R_76()
 {
    if (jj_3R_107()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_117()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_127()
 {
    if (jj_scan_token(USING)) return true;
    return false;
  }

  private boolean jj_3R_298()
 {
    if (jj_scan_token(LOAD)) return true;
    return false;
  }

  private boolean jj_3R_153()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_187()) {
    jj_scanpos = xsp;
    if (jj_3R_188()) {
    jj_scanpos = xsp;
    if (jj_3R_189()) {
    jj_scanpos = xsp;
    if (jj_3R_190()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_284()
 {
    if (jj_scan_token(REVOKE)) return true;
    return false;
  }

  private boolean jj_3_72()
 {
    if (jj_scan_token(MANAGEMENT)) return true;
    if (jj_scan_token(ON)) return true;
    return false;
  }

  private boolean jj_3R_117()
 {
    if (jj_3R_153()) return true;
    return false;
  }

  private boolean jj_3R_187()
 {
    if (jj_3R_147()) return true;
    return false;
  }

  private boolean jj_3_52()
 {
    if (jj_scan_token(CURRENT)) return true;
    if (jj_scan_token(USER)) return true;
    return false;
  }

  private boolean jj_3R_188()
 {
    if (jj_3R_223()) return true;
    return false;
  }

  private boolean jj_3R_189()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_68()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_190()
 {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_224()) jj_scanpos = xsp;
    if (jj_scan_token(DOTDOT)) return true;
    xsp = jj_scanpos;
    if (jj_3R_317()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_67()
 {
    if (jj_3R_93()) return true;
    return false;
  }

  private boolean jj_3R_147()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_94()) return true;
    return false;
  }

  private boolean jj_3R_222()
 {
    if (jj_scan_token(250)) return true;
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_299()
 {
    if (jj_scan_token(FOREACH)) return true;
    return false;
  }

  private boolean jj_3_25()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_68()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_224()
 {
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3_73()
 {
    if (jj_scan_token(MANAGEMENT)) return true;
    if (jj_scan_token(ON)) return true;
    return false;
  }

  private boolean jj_3R_130()
 {
    if (jj_scan_token(ROLE)) return true;
    return false;
  }

  private boolean jj_3R_66()
 {
    if (jj_3R_107()) return true;
    Token xsp;
    if (jj_3R_108()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_108()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_297()
 {
    if (jj_scan_token(CALL)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public CypherTokenManager token_source;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[429];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static private int[] jj_la1_5;
  static private int[] jj_la1_6;
  static private int[] jj_la1_7;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	   jj_la1_init_2();
	   jj_la1_init_3();
	   jj_la1_init_4();
	   jj_la1_init_5();
	   jj_la1_init_6();
	   jj_la1_init_7();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800d800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x1000,0x1000,0x1000,0x0,0x0,0x0,0x800d800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800d800,0x800d800,0x0,0x0,0x0,0x800d800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800d800,0x0,0x800d800,0x0,0x0,0x0,0x0,0xd800,0x0,0x800d800,0x0,0x0,0x0,0x1000,0x800d800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x8000000,0x8000000,0x0,0x8000000,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x8000000,0x8000000,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x80040000,0x0,0x0,0x0,0x80040000,0x0,0x0,0x0,0x40000,0x0,0x80000000,0x0,0x20000,0x80000000,0x80000000,0x0,0x80000000,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0xfbfff880,0x400000,0x0,0x0,0x0,0xfbfff800,0x0,0xfbfff800,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0xfbfff800,0x0,0x200000,0x0,0x0,0x80000000,0x80000000,0x0,0x0,0x0,0x0,0x10000,0x10000,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0xfbfff800,0x4000000,0x0,0x0,0xfbfff800,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0xfbfff880,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfbfff880,0xfbfff880,0x0,0x0,0x0,0x80,0x0,0x0,0xfbfff800,0x0,0x0,0x0,0x0,0x4000000,0xfbfff800,0x0,0xfbfff800,0x4000000,0x0,0x0,0x4000000,0x0,0x0,0x0,0x0,0xfbfff800,0x0,0xfbfff800,0x0,0x80,0xfbfff800,0xfbfff880,0x0,0xfbfff800,0x0,0x0,0x0,0x0,0xfbfff880,0x0,0xfbfff800,0x0,0xfbfff800,0xfbfff880,0x0,0x0,0x0,0x0,0x10004000,0x40000,0x40000,0x4000,0x4000,0x3002c000,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0xfbfff800,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x8000000,0x8000000,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x8000000,0x8000000,0x0,0x8000000,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0xfbfff800,0x40000000,0x0,0x0,0x0,0x0,0x0,0xfbfff800,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x80,0x80,0x0,0x80,0x80,0x0,0x0,0x0,0xfbfff800,0x0,0x0,0xfbfff800,0x800000,0x0,0x800000,0x0,0x0,0x0,0xfbfff800,0x0,0xfbfff800,0x0,0xfbfff800,0xfbfff800,0x10000000,0x0,0xfbfff800,0x0,0x0,0xfbfff800,0x0,0x0,0xfbfff800,0x0,0x0,0xfbfff800,0x0,0x0,0x0,0xfbfff800,0x0,0x0,0xfbfff800,0x0,0x0,0xfbfff800,0x0,0xfbfff800,0x0,0xfbfff800,0x1065000,0x1065000,0x1065000,0xfbfff800,0x1065000,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x80,0x80,0x80,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x1065000,0x1065000,0x0,0x0,0x0,0x0,0x0,0x0,0xfbfff800,0x0,0xfbfff800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x4000,0x0,0x0,0x0,0x4000,0x4000,0x0,0x0,0x0,0xfbfff800,0x0,0x0,0x4000,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfbfff800,0x0,0x0,0xfbfff800,0x0,0x0,0x1000,0x4000,0x0,0x0,0xfbfff800,0x0,0x1044000,0x0,0x0,0x0,0xfbfff800,0xfbfff800,0x0,0x0,0xfbfff800,0x0,0x0,0xfbfff800,0x0,0x0,0xfbfff800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfbfff800,0x0,0x0,0xfbfff800,0x0,0x0,0x0,0x2000000,0x0,0x0,0x2000000,0x0,0x0,0xc000,0x0,0x0,0x0,0x0,0x0,0x0,0xfbfff800,0x0,0xfbfff800,0x0,0xfbfff800,0x0,0x0,0x0,0xfbfff800,0x0,0xfbfff800,};
	}
	private static void jj_la1_init_2() {
	   jj_la1_2 = new int[] {0x204c0202,0x2,0x2,0x0,0x204c0202,0x2,0x2,0x0,0x20080002,0x0,0x440200,0x0,0x0,0x440200,0x440200,0x440200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf1ffffff,0x0,0x100000,0x0,0x0,0xf17fffff,0x0,0xf17fffff,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0xf17fffff,0x0,0x0,0x0,0x0,0x440200,0x440200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x800000,0xf17fffff,0x0,0x800000,0x0,0xf17fffff,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0xf1ffffff,0x0,0x0,0x40,0x0,0x40,0x0,0x0,0x2000000,0x2000000,0x0,0x0,0x4000000,0xf1ffffff,0xf1ffffff,0x4000000,0x0,0x4000000,0x800000,0x0,0x0,0xf17fffff,0x0,0x0,0x0,0x0,0x0,0xf17fffff,0x0,0xf17fffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf57fffff,0x0,0xf57fffff,0x0,0x800000,0xf17fffff,0xf1ffffff,0x0,0xf17fffff,0x0,0x0,0x0,0x0,0xf1ffffff,0x0,0xf17fffff,0x0,0xf17fffff,0xf1ffffff,0x0,0x0,0x0,0x0,0x2010,0x20080000,0x20080000,0x2010,0x2800,0x16830,0x30,0x0,0x0,0x0,0x0,0x0,0x0,0xf17fffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x30,0x0,0x0,0x0,0x0,0x0,0x30,0x0,0x0,0x0,0x30,0x0,0x0,0x0,0x0,0xf17fffff,0x0,0x0,0x0,0x0,0x0,0x0,0xf17fffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x800000,0x800000,0x0,0x800000,0x800000,0x0,0x0,0x0,0xf17fffff,0x0,0x0,0xf17fffff,0x0,0x0,0x0,0x0,0x0,0x0,0xf17fffff,0x0,0xf17fffff,0x0,0xf17fffff,0xf17fffff,0x0,0x0,0xf17fffff,0x0,0x0,0xf17fffff,0x0,0x0,0xf17fffff,0x0,0x0,0xf17fffff,0x0,0x0,0x0,0xf17fffff,0x0,0x0,0xf17fffff,0x0,0x0,0xf17fffff,0x0,0xf17fffff,0x0,0xf1ffffff,0x20042230,0x20042230,0x20042230,0xf1ffffff,0x200c2230,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x4,0x4,0x4,0x800004,0x0,0x0,0x0,0x800000,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20042230,0x20042230,0xa000,0xa000,0xa000,0x2000,0x2000,0x0,0xf1ffffff,0x6000,0xf1ffffff,0x1e000,0x0,0x30,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x30,0x2000,0x2030,0x0,0x30,0x30,0x2000,0x2030,0x0,0x30,0x0,0xf1ffffff,0x0,0x30,0x0,0x30,0x0,0x0,0x2000,0x0,0x2000,0x0,0x0,0x0,0x0,0x30,0x0,0x0,0xf1ffffff,0x0,0x0,0xf1ffffff,0x0,0x0,0x30,0x2000,0x0,0x0,0xf1ffffff,0x0,0x2000,0x0,0x0,0x40000,0xf17fffff,0xf17fffff,0x0,0x0,0xf17fffff,0x0,0x0,0xf17fffff,0x0,0x0,0xf17fffff,0x0,0x0,0x0,0x0,0x0,0x0,0x40200000,0x40200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x16000,0x6000,0xf1ffffff,0x16000,0x0,0xf1ffffff,0x10000,0x0,0x10000000,0x0,0x0,0x0,0x0,0x10000000,0x10000000,0x0,0x6000,0x0,0x0,0x0,0x0,0x4000000,0xf1ffffff,0x4000000,0xf1ffffff,0x0,0xf1ffffff,0x0,0x800000,0x0,0xf17fffff,0x0,0xf17fffff,};
	}
	private static void jj_la1_init_3() {
	   jj_la1_3 = new int[] {0x410000,0x0,0x0,0x0,0x410000,0x0,0x0,0x0,0x400000,0x0,0x10000,0x0,0x0,0x10000,0x10000,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xdddfffbf,0x0,0x0,0x0,0x0,0xdddfffbf,0x0,0xdddfffbf,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0xdddfffbf,0x0,0x0,0x0,0x2000,0x10000,0x10000,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xdddfffbf,0x0,0x0,0x0,0xdddfffbf,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xdddfffbf,0x2200040,0x2200000,0x40000020,0x0,0x40000020,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xdddfffbf,0xdddfffbf,0x0,0x0,0x0,0x1000,0x0,0x0,0xdddfffbf,0x0,0x0,0x4,0x0,0x0,0xdddfffbf,0x0,0xdddfffbf,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xdddfffbf,0x0,0xdddfffbf,0x0,0x1000,0xdddfffbf,0xdddfffbf,0x0,0xdddfffbf,0x0,0x0,0x0,0x0,0xdddfffbf,0x0,0xdddfffbf,0x0,0xdddfffbf,0xdddfffbf,0x0,0x0,0x0,0x0,0x80040000,0x400000,0x400000,0x80000000,0x0,0x881c0700,0x80180000,0x700,0x700,0x300,0x300,0x0,0x0,0xdddfffbf,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xdddfffbf,0x0,0x80,0x0,0x0,0x0,0x180000,0xdddfffbf,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x10000000,0x8000,0xdddfffbf,0x0,0x2000000,0xdddfffbf,0x0,0x0,0x0,0x0,0x0,0x2000000,0xdddfffbf,0x0,0xdddfffbf,0x10000000,0xdddfffbf,0xdddfffbf,0x80040000,0x10000000,0xdddfffbf,0x0,0x2000000,0xdddfffbf,0x0,0x10000000,0xdddfffbf,0x0,0x2000000,0xdddfffbf,0x0,0x0,0x10000000,0xdddfffbf,0x0,0x2000000,0xdddfffbf,0x0,0x10000000,0xdddfffbf,0x0,0xdddfffbf,0x0,0xdddfffbf,0xa0000000,0xa0000000,0xa0000000,0xdddfffbf,0xa0400000,0x10000000,0x0,0x10000000,0x10000000,0x0,0x0,0x0,0x0,0x10000000,0x8,0x8,0x0,0x0,0x8000000,0x10000000,0x10000000,0x10000000,0x0,0x0,0x0,0x0,0x8000008,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa0000000,0xa0000000,0x800000,0x800000,0x800000,0x800000,0x800000,0x1800000,0xdddfffbf,0x0,0xdddfffbf,0x9800000,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x80000000,0x80000000,0x0,0x80000000,0x0,0x80000000,0x80000000,0x0,0x0,0xdddfffbf,0x0,0x80000000,0x0,0x80000000,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0xdddfffbf,0x0,0x0,0xdddfffbf,0x0,0x0,0x80000000,0x0,0x0,0x0,0xdddfffbf,0x0,0x20000000,0x0,0x0,0x0,0xdddfffbf,0xdddfffbf,0x0,0x0,0xdddfffbf,0x0,0x0,0xdddfffbf,0x3,0x0,0xdddfffbf,0x3,0x3,0x10000000,0x0,0x0,0x10000000,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0xdddfffbf,0x8000000,0x1800000,0xdddfffbf,0x9800000,0x10000000,0x0,0x0,0x10000000,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xdddfffbf,0x0,0xdddfffbf,0x0,0xdddfffbf,0x0,0x0,0x0,0xdddfffbf,0x0,0xdddfffbf,};
	}
	private static void jj_la1_init_4() {
	   jj_la1_4 = new int[] {0x18400,0x0,0x0,0x0,0x18400,0x0,0x0,0x0,0x0,0x0,0x18400,0x0,0x0,0x18400,0x18400,0x18000,0x400,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0xffe3deff,0x0,0x0,0x0,0x0,0xffe1ce3f,0x0,0xffe1ce3f,0x0,0x0,0x0,0x0,0x0,0x4,0x80000000,0x8000,0x0,0x1000,0x0,0x0,0xffe1ce3f,0x0,0x0,0x0,0x0,0x18400,0x18400,0x0,0x0,0x40000000,0x0,0x1000,0x0,0x1000,0x0,0x0,0x80,0x0,0x0,0x80,0xffe1ce3f,0x0,0x80,0x2000,0xffe1ce3f,0x0,0x0,0x0,0x0,0x80,0x40,0x0,0x2000,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffe3deff,0x182100,0x182100,0x2,0x28000000,0x2,0x20000,0x20000,0x40000,0x40000,0x0,0x20000,0x40,0xffe3deff,0xffe3deff,0x0,0x40,0x0,0x20000,0x80,0x1000,0xffe1ce3f,0x0,0x0,0x0,0x0,0x0,0xffe1ce3f,0x0,0xffe1ce3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffe1ce3f,0x0,0xffe1ce3f,0x0,0x20000,0xffe1ceff,0xffe3ceff,0x0,0xffe1ce3f,0x0,0x20000,0x0,0x20000,0xffe3deff,0x0,0xffe1ce3f,0x0,0xffe1ce3f,0xffe3deff,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x1000801,0x1,0x8,0x0,0x0,0x0,0x0,0x0,0xffe1ce3f,0x0,0x0,0x0,0x200,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffe1ce3f,0x0,0x0,0x0,0x0,0x0,0x0,0xffe1ce3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x80000000,0xffe1ce3f,0x2000,0x0,0xffe1ce3f,0x0,0x9000000,0x0,0x0,0x2000,0x0,0xffe1ce3f,0x9000000,0xffe1de3f,0x0,0xffe1ce3f,0xffe1ce3f,0x800,0x0,0xffe1ce3f,0x2000,0x0,0xffe1ce3f,0x0,0x0,0xffe1ce3f,0x2000,0x0,0xffe1ce3f,0x0,0x0,0x0,0xffe1ce3f,0x2000,0x0,0xffe1ce3f,0x0,0x0,0xffe1ce3f,0x0,0xffe1de3f,0x0,0xffe1ce3f,0x218001,0x218001,0x218001,0xffe1ce3f,0x218001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x218001,0x218001,0x0,0x0,0x0,0x0,0x0,0x0,0xffe1ce3f,0x0,0xffe1ce3f,0x0,0x1,0x0,0x1000000,0x30,0x0,0x0,0x0,0x600000,0x1600030,0x800001,0x0,0x80800001,0x1,0x0,0x1,0x0,0x1,0x1,0x0,0x0,0xffe1ce3f,0x1000,0x1,0x0,0x1,0x0,0x0,0x0,0x10,0x10,0x0,0x10,0x1,0x4000,0x0,0x4000,0x4000,0xffe1ce3f,0x1000,0x0,0xffe1ce3f,0x1000,0x4000,0x200001,0x0,0x0,0x0,0xffe1ce3f,0x1000,0x0,0x8000,0x1000,0x10000,0xffe1ce3f,0xffe1ce3f,0x0,0x0,0xffe1ce3f,0x3000000,0x0,0xffe1ce3f,0x0,0x0,0xffe1ce3f,0x3000000,0x3000000,0x0,0x0,0x10000000,0x0,0x0,0x0,0x10000000,0x0,0x0,0x10000000,0x10000000,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0xffe1ce3f,0x0,0x0,0xffe1ce3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffe1ce3f,0x0,0xffe1ce3f,0x0,0xffe1ce3f,0x0,0x80,0x0,0xffe1ce3f,0x0,0xffe1ce3f,};
	}
	private static void jj_la1_init_5() {
	   jj_la1_5 = new int[] {0x21000002,0x0,0x0,0x0,0x21000002,0x0,0x0,0x0,0x1000000,0x0,0x20000002,0x0,0x0,0x20000002,0x20000002,0x20000002,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0xfdcfdfff,0x0,0x0,0x0,0x0,0xfdcfdbff,0x0,0xfdcfdbff,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfdcfdbff,0x0,0x0,0x0,0x0,0x20000002,0x20000002,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfdcfdbff,0x0,0x0,0x0,0xfdcfdbff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0xfdcfdfff,0x0,0x0,0x2000000,0x0,0x0,0x400,0x400,0x0,0x0,0x2000,0x400,0x0,0xfdcfdfff,0xfdcfdfff,0x0,0x0,0x0,0x0,0x0,0x0,0xfdcfdbff,0x0,0x0,0x0,0x0,0x0,0xfdcfdbff,0x0,0xfdcfdbff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfdcfdbff,0x0,0xfdcfdbff,0x0,0x0,0xfdcfdbff,0xfdcfdbff,0x0,0xfdcfdbff,0x0,0x0,0x0,0x0,0xfdcfdfff,0x0,0xfdcfdbff,0x0,0xfdcfdbff,0xfdcfdfff,0x0,0x0,0x0,0x8,0x80800,0x1000000,0x1000000,0x0,0x0,0xc0f1800,0x0,0x40000,0x40000,0x40000,0x0,0x0,0x0,0xfdcfdbff,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x30000,0xfdcfdbff,0x0,0x0,0x0,0x0,0x0,0x0,0xfdcfdbff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfdcfdbff,0x0,0x0,0xfdcfdbff,0x80000000,0x0,0x80000000,0x4,0x0,0x0,0xfdcfdbff,0x0,0xfdcfdbff,0x0,0xfdcfdbff,0xfdcfdbff,0x80800,0x0,0xfdcfdbff,0x0,0x0,0xfdcfdbff,0x4,0x0,0xfdcfdbff,0x0,0x0,0xfdcfdbff,0x0,0x4,0x0,0xfdcfdbff,0x0,0x0,0xfdcfdbff,0x4,0x0,0xfdcfdbff,0x0,0xfdcfdbff,0x0,0xfdcfdbff,0x21404000,0x21404000,0x21404000,0xfdcfdbff,0x21404000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x200,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x240,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x21404000,0x21404000,0x0,0x0,0x8000,0x0,0x0,0x0,0xfdcfdbff,0x0,0xfdcfdbff,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x40000,0x0,0x8040000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfdcfdbff,0x0,0x0,0x4000,0x4000,0xc0,0x0,0xc0,0x40000,0x400c0,0x4000,0x4000,0x0,0x0,0x0,0x0,0x0,0xfdcfdbff,0x0,0x0,0xfdcfdbff,0x0,0x0,0x0,0x0,0x4000,0x0,0xfdcfdbff,0x0,0x1004000,0x400000,0x0,0x0,0xfdcfdbff,0xfdcfdbff,0x18000000,0x0,0xfdcfdbff,0x0,0x0,0xfdcfdbff,0x0,0x0,0xfdcfdbff,0x18000000,0x18000000,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfdcfdbff,0x0,0x0,0xfdcfdbff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfdcfdbff,0x0,0xfdcfdbff,0x0,0xfdcfdbff,0x0,0x0,0x0,0xfdcfdbff,0x0,0xfdcfdbff,};
	}
	private static void jj_la1_init_6() {
	   jj_la1_6 = new int[] {0x124a006,0x0,0x0,0x0,0x124a006,0x0,0x0,0x0,0x1248004,0x0,0x2002,0x0,0x0,0x2002,0x2002,0x2002,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0xffffff7f,0x0,0x0,0x0,0x0,0xf7ffff7f,0x0,0xf7ffff7f,0x0,0x0,0x0,0x0,0x0,0x2000100,0x0,0x0,0x0,0x0,0x0,0x0,0xffffff7f,0x0,0x0,0x0,0x0,0x2002,0x2002,0x0,0x60,0x0,0x0,0x4000,0x4000,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0xf7ffff7f,0x0,0x0,0x0,0xf7ffff7f,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf7ffff7f,0x0,0x0,0x80000,0x0,0x80000,0x0,0x0,0x8000000,0x8000000,0x0,0x0,0x0,0xf7ffff7f,0xf7ffff7f,0x0,0x0,0x0,0x0,0x0,0x0,0xf7ffff7f,0x0,0x0,0x0,0x0,0x0,0xf7ffff7f,0x0,0xf7ffff7f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf7ffff7f,0x0,0xf7ffff7f,0x0,0x0,0xf7ffff7f,0xf7ffff7f,0x0,0xf7ffff7f,0x0,0x0,0x0,0x0,0xf7ffff7f,0x0,0xf7ffff7f,0x0,0xf7ffff7f,0xf7ffff7f,0x0,0x0,0x0,0x0,0x2000008,0x1248004,0x240004,0x8,0x0,0x62000010,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0xffffff7f,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0xf7ffff7f,0x0,0x0,0x2,0x0,0x0,0x0,0xf7ffff7f,0x0,0x0,0x2,0x0,0x0,0x60000000,0x2,0x0,0x2,0x0,0x0,0x0,0x0,0x60000000,0x0,0x0,0x0,0x0,0x0,0xf7ffff7f,0x0,0x0,0xf7ffffff,0x0,0x0,0x0,0x0,0x0,0x0,0xf7ffffff,0x0,0xf7ffff7f,0x0,0xf7ffff7f,0xf7ffff7f,0x2000000,0x0,0xf7ffff7f,0x0,0x0,0xf7ffffff,0x0,0x0,0xf7ffff7f,0x0,0x0,0xf7ffffff,0x0,0x0,0x0,0xf7ffff7f,0x0,0x0,0xf7ffffff,0x0,0x0,0xf7ffff7f,0x0,0xf7ffff7f,0x8,0xf7ffff7f,0xa124a018,0xa124a008,0xa124a008,0xf7ffff7f,0xa124a018,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x2000,0x2000,0x0,0x0,0x0,0x0,0x400000,0x2,0x0,0x0,0x2,0x0,0x0,0xa124a008,0xa124a000,0x0,0x0,0x0,0x0,0x0,0x0,0xffffff7f,0x0,0xffffff7f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x8,0x0,0x0,0x0,0x8,0x8,0x0,0x0,0x60000000,0xffffff7f,0x0,0x60000000,0x8,0x60000008,0x0,0x100000,0x0,0x0,0x0,0x8,0x8,0x0,0x0,0x0,0x0,0x0,0xffffff7f,0x0,0x60000000,0xffffff7f,0x0,0x0,0x21240000,0x0,0x8,0x8,0xffffff7f,0x0,0x0,0x80000000,0x0,0x0,0xffffff7f,0xffffff7f,0x0,0x0,0xffffff7f,0x0,0x0,0xffffff7f,0x0,0x0,0xffffff7f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe00,0xe00,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0xffffff7f,0x0,0x0,0xffffff7f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x800000,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0xf7ffff7f,0x0,0xf7ffff7f,0x0,0xf7ffff7f,0x0,0x0,0x0,0xf7ffff7f,0x0,0xf7ffff7f,};
	}
	private static void jj_la1_init_7() {
	   jj_la1_7 = new int[] {0x4260,0x0,0x0,0x8,0x4060,0x0,0x0,0x8,0x0,0x0,0x4060,0x8,0x0,0x4060,0x4060,0x4060,0x0,0x4000000,0x0,0x0,0x0,0x0,0x4000000,0x4000000,0x7ffff,0x0,0x0,0x2000,0x4000000,0x7ffff,0x4000000,0x7ffff,0x0,0x4000000,0x0,0x2000,0x200,0x0,0x0,0x0,0x4000000,0x0,0x4000000,0x2000,0x7ffff,0x20000,0x0,0x4000,0x0,0x4060,0x4260,0x0,0x0,0x0,0x4000000,0x0,0x0,0x0,0x0,0x10000000,0x0,0x2000,0x10000000,0x0,0x7ffff,0x0,0x0,0x400000,0x7ffff,0x0,0x10000000,0x10000000,0x0,0x0,0x0,0x800000,0x400000,0x200000,0x800000,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x7ffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x7ffff,0x7ffff,0x10000000,0x0,0x0,0x1,0x0,0x0,0x7ffff,0x1000,0x1000,0x0,0x2000,0x0,0x7ffff,0x2000,0x7ffff,0x2000,0x2000,0x2000,0x0,0x2000,0x2000,0x2000,0x2000,0x7ffff,0x4000000,0x7ffff,0x2000,0x1,0x7ffff,0x7ffff,0x4000000,0x7ffff,0x4000000,0x0,0x0,0x0,0x7ffff,0x4000000,0x7ffff,0x4000000,0x7ffff,0x7ffff,0x4000000,0x4000000,0x4000000,0x0,0x80,0x0,0x0,0x80,0x80,0x190,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x7ffff,0x4000000,0x0,0x0,0x0,0x2000,0x0,0x400,0x0,0x0,0x22400,0x22400,0x0,0x0,0x22000,0x22000,0x0,0x400,0x0,0x0,0x22400,0x22400,0x0,0x400,0x0,0x400,0x0,0x0,0x22000,0x22000,0x0,0x7ffff,0x0,0x0,0x0,0x22000,0x22000,0x0,0x7ffff,0x0,0x0,0x0,0x22000,0x22000,0x0,0x0,0x0,0x0,0x22000,0x22000,0x0,0x22000,0x0,0x0,0x0,0x0,0x0,0x0,0x7ffff,0x400000,0x800000,0x7ffff,0x0,0x10,0x0,0x0,0x400000,0x800000,0x7ffff,0x10,0x7ffff,0x0,0x7ffff,0x7ffff,0x0,0x0,0x7ffff,0x400000,0x800000,0x7ffff,0x0,0x0,0x7ffff,0x400000,0x800000,0x7ffff,0x4000000,0x0,0x0,0x7ffff,0x400000,0x800000,0x7ffff,0x0,0x0,0x7ffff,0x4000000,0x7ffff,0x80,0x7ffff,0x8080,0x8080,0x8080,0x7ffff,0x8080,0x0,0x0,0x0,0x0,0x4000,0x0,0x22000,0x22000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x22000,0x22000,0x0,0x22000,0x22000,0x8080,0x8080,0x0,0x0,0x0,0x0,0x0,0x0,0x7ffff,0x0,0x7ffff,0x0,0x0,0x0,0x0,0x0,0x0,0x6,0x0,0x0,0x6,0x0,0x80,0x80,0x0,0x0,0x0,0x80,0x80,0x0,0x0,0x0,0x7ffff,0x0,0x0,0x80,0x80,0x0,0x0,0x80,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7ffff,0x0,0x0,0x7ffff,0x0,0x0,0x0,0x80,0x0,0x80,0x7ffff,0x0,0x80,0x0,0x0,0x0,0x7ffff,0x7ffff,0x0,0x4000000,0x7ffff,0x0,0x4000000,0x7ffff,0x0,0x4000000,0x7ffff,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x800,0x0,0x8000,0x800,0x800,0x0,0x0,0x0,0x800,0x0,0x22000,0x22000,0x0,0x0,0x7ffff,0x0,0x0,0x7ffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x80,0x0,0x0,0x0,0x22000,0x22000,0x4000000,0x0,0x7ffff,0x0,0x7ffff,0x4000000,0x7ffff,0x4000000,0x0,0x4000000,0x7ffff,0x4000000,0x7ffff,};
	}
  private final JJCalls[] jj_2_rtns = new JJCalls[73];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /**
   * Constructor with user supplied CharStream.
   * @param stream stream to init with
   */
  public Cypher(final CharStream stream) {
	 token_source = new CypherTokenManager(stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 429; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Reinitialise.
   * @param stream stream to init with
   */
  public void ReInit(final CharStream stream) {
	 token_source.ReInit(stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
   for (int i = 0; i < 429; i++)
     jj_la1[i] = -1;
   for (int i = 0; i < jj_2_rtns.length; i++)
     jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Constructor with generated Token Manager.
   * @param tm Token manager to use
   */
  public Cypher(final CypherTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 429; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Reinitialise
   * @param tm Token manager to use
   */
  public void ReInit(final CypherTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 429; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(final int kind) throws ParseException {
    final Token oldToken = token;
    if (token.next != null)
      token = token.next;
    else {
      token.next = token_source.getNextToken();
      token = token.next;
    }
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen)
              c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  @SuppressWarnings("serial")
  private static final class LookaheadSuccess extends IllegalStateException { }
  private final LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		   jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		   jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


  /**
   * @return the next Token.
   */
  public final Token getNextToken() {
   if (token.next != null)
     token = token.next;
   else
     token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

  /**
   * @param index index to be retrieved
   * @return the specific Token.
   */
  public final Token getToken(final int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next == null)
        t.next = token_source.getNextToken();
      t = t.next;
    }
    return t;
  }

  private int jj_ntk_f() {
    jj_nt = token.next;
    if (jj_nt == null) {
      token.next = token_source.getNextToken();
      jj_ntk = token.next.kind;
      return jj_ntk;
    }
    jj_ntk = jj_nt.kind;
    return jj_ntk;
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
  if (pos >= 100) {
    return;
  }

  if (pos == jj_endpos + 1) {
    jj_lasttokens[jj_endpos++] = kind;
  } else if (jj_endpos != 0) {
    jj_expentry = new int[jj_endpos];

    for (int i = 0; i < jj_endpos; i++) {
      jj_expentry[i] = jj_lasttokens[i];
    }

    for (final int[] oldentry : jj_expentries) {
      if (oldentry.length == jj_expentry.length) {
        boolean isMatched = true;
        for (int i = 0; i < jj_expentry.length; i++) {
          if (oldentry[i] != jj_expentry[i]) {
            isMatched = false;
            break;
          }
        }
        if (isMatched) {
          jj_expentries.add(jj_expentry);
          break;
        }
      }
    }

    if (pos != 0) {
      jj_endpos = pos;
      jj_lasttokens[jj_endpos - 1] = kind;
    }
  }
}

  /**
   * Generate ParseException.
   * @return new Exception object. Never <code>null</code>
   */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[253];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 429; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
          if ((jj_la1_5[i] & (1<<j)) != 0) {
            la1tokens[160+j] = true;
          }
          if ((jj_la1_6[i] & (1<<j)) != 0) {
            la1tokens[192+j] = true;
          }
          if ((jj_la1_7[i] & (1<<j)) != 0) {
            la1tokens[224+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 253; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /**
   * @return Always <code>false</code>.
   */
  public final boolean trace_enabled() {
    return false;
  }

  /** Enable tracing. */
  public final void enable_tracing() {}

  /** Disable tracing. */
  public final void disable_tracing() {}

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 73; i++) {
      try {
        JJCalls p = jj_2_rtns[i];
        do {
          if (p.gen > jj_gen) {
            jj_la = p.arg;
            jj_scanpos = p.first;
            jj_lastpos = p.first;
            switch (i) {
              case 0: jj_3_1(); break;
              case 1: jj_3_2(); break;
              case 2: jj_3_3(); break;
              case 3: jj_3_4(); break;
              case 4: jj_3_5(); break;
              case 5: jj_3_6(); break;
              case 6: jj_3_7(); break;
              case 7: jj_3_8(); break;
              case 8: jj_3_9(); break;
              case 9: jj_3_10(); break;
              case 10: jj_3_11(); break;
              case 11: jj_3_12(); break;
              case 12: jj_3_13(); break;
              case 13: jj_3_14(); break;
              case 14: jj_3_15(); break;
              case 15: jj_3_16(); break;
              case 16: jj_3_17(); break;
              case 17: jj_3_18(); break;
              case 18: jj_3_19(); break;
              case 19: jj_3_20(); break;
              case 20: jj_3_21(); break;
              case 21: jj_3_22(); break;
              case 22: jj_3_23(); break;
              case 23: jj_3_24(); break;
              case 24: jj_3_25(); break;
              case 25: jj_3_26(); break;
              case 26: jj_3_27(); break;
              case 27: jj_3_28(); break;
              case 28: jj_3_29(); break;
              case 29: jj_3_30(); break;
              case 30: jj_3_31(); break;
              case 31: jj_3_32(); break;
              case 32: jj_3_33(); break;
              case 33: jj_3_34(); break;
              case 34: jj_3_35(); break;
              case 35: jj_3_36(); break;
              case 36: jj_3_37(); break;
              case 37: jj_3_38(); break;
              case 38: jj_3_39(); break;
              case 39: jj_3_40(); break;
              case 40: jj_3_41(); break;
              case 41: jj_3_42(); break;
              case 42: jj_3_43(); break;
              case 43: jj_3_44(); break;
              case 44: jj_3_45(); break;
              case 45: jj_3_46(); break;
              case 46: jj_3_47(); break;
              case 47: jj_3_48(); break;
              case 48: jj_3_49(); break;
              case 49: jj_3_50(); break;
              case 50: jj_3_51(); break;
              case 51: jj_3_52(); break;
              case 52: jj_3_53(); break;
              case 53: jj_3_54(); break;
              case 54: jj_3_55(); break;
              case 55: jj_3_56(); break;
              case 56: jj_3_57(); break;
              case 57: jj_3_58(); break;
              case 58: jj_3_59(); break;
              case 59: jj_3_60(); break;
              case 60: jj_3_61(); break;
              case 61: jj_3_62(); break;
              case 62: jj_3_63(); break;
              case 63: jj_3_64(); break;
              case 64: jj_3_65(); break;
              case 65: jj_3_66(); break;
              case 66: jj_3_67(); break;
              case 67: jj_3_68(); break;
              case 68: jj_3_69(); break;
              case 69: jj_3_70(); break;
              case 70: jj_3_71(); break;
              case 71: jj_3_72(); break;
              case 72: jj_3_73(); break;
            }
          }
          p = p.next;
        } while (p != null);
      } catch(LookaheadSuccess ls) { /* ignore */ }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) {
        p.next = new JJCalls();
        p = p.next;
        break;
      }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; 
    p.first = token;
    p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
