/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.pipes;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.SubqueryCall;
import org.neo4j.cypher.internal.runtime.QueryStatistics;
import org.neo4j.cypher.internal.runtime.QueryStatistics$;
import org.neo4j.cypher.internal.runtime.QueryTransactionalContext;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.OnErrorBreakTxPipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.OnErrorContinueTxPipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.OnErrorFailTxPipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.Pipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.PipeHelper$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.TransactionPipeWrapper;
import org.neo4j.exceptions.InternalException;
import org.neo4j.logging.InternalLog;
import scala.Function1;
import scala.runtime.java8.JFunction1;

public final class TransactionPipeWrapper$ {
    public static final TransactionPipeWrapper$ MODULE$ = new TransactionPipeWrapper$();

    public TransactionPipeWrapper apply(SubqueryCall.InTransactionsOnErrorBehaviour error, Pipe inner) {
        SubqueryCall.InTransactionsOnErrorBehaviour inTransactionsOnErrorBehaviour = error;
        if (SubqueryCall.InTransactionsOnErrorBehaviour$.OnErrorContinue$.MODULE$.equals(inTransactionsOnErrorBehaviour)) {
            return new OnErrorContinueTxPipe(inner);
        }
        if (SubqueryCall.InTransactionsOnErrorBehaviour$.OnErrorBreak$.MODULE$.equals(inTransactionsOnErrorBehaviour)) {
            return new OnErrorBreakTxPipe(inner);
        }
        if (SubqueryCall.InTransactionsOnErrorBehaviour$.OnErrorFail$.MODULE$.equals(inTransactionsOnErrorBehaviour)) {
            return new OnErrorFailTxPipe(inner);
        }
        throw new UnsupportedOperationException("Unsupported error behaviour " + inTransactionsOnErrorBehaviour);
    }

    public long evaluateBatchSize(Expression batchSize, QueryState state) {
        return PipeHelper$.MODULE$.evaluateStaticLongOrThrow(batchSize, (Function1<Object, Object>)(JFunction1.mcZJ.sp & Serializable)x$3 -> x$3 > 0L, state, "OF ... ROWS", " Must be a positive integer.");
    }

    public void assertTransactionStateIsEmpty(QueryState state) {
        if (state.query().transactionalContext().dataRead().transactionStateHasChanges()) {
            throw new InternalException("Expected transaction state to be empty when calling transactional subquery.");
        }
    }

    public void org$neo4j$cypher$internal$runtime$interpreted$pipes$TransactionPipeWrapper$$commitTransactionWithStatistics(QueryTransactionalContext innerTxContext, QueryState outerQueryState) {
        innerTxContext.commitTransaction();
        boolean x$1 = true;
        int x$2 = QueryStatistics$.MODULE$.apply$default$1();
        int x$3 = QueryStatistics$.MODULE$.apply$default$2();
        int x$4 = QueryStatistics$.MODULE$.apply$default$3();
        int x$5 = QueryStatistics$.MODULE$.apply$default$4();
        int x$6 = QueryStatistics$.MODULE$.apply$default$5();
        int x$7 = QueryStatistics$.MODULE$.apply$default$6();
        int x$8 = QueryStatistics$.MODULE$.apply$default$7();
        int x$9 = QueryStatistics$.MODULE$.apply$default$8();
        int x$10 = QueryStatistics$.MODULE$.apply$default$9();
        int x$11 = QueryStatistics$.MODULE$.apply$default$10();
        int x$12 = QueryStatistics$.MODULE$.apply$default$11();
        int x$13 = QueryStatistics$.MODULE$.apply$default$12();
        int x$14 = QueryStatistics$.MODULE$.apply$default$13();
        int x$15 = QueryStatistics$.MODULE$.apply$default$14();
        int x$16 = QueryStatistics$.MODULE$.apply$default$15();
        int x$17 = QueryStatistics$.MODULE$.apply$default$16();
        int x$18 = QueryStatistics$.MODULE$.apply$default$18();
        int x$19 = QueryStatistics$.MODULE$.apply$default$19();
        QueryStatistics executionStatistics = new QueryStatistics(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, 1, x$18, x$19);
        outerQueryState.query().addStatistics(executionStatistics);
    }

    public void org$neo4j$cypher$internal$runtime$interpreted$pipes$TransactionPipeWrapper$$logError(QueryState state, String innerTxId, Throwable t) {
        String outerTxId = state.query().transactionalContext().userTransactionId();
        InternalLog log = state.query().logProvider().getLog(this.getClass());
        log.info("Recover error in inner transaction " + innerTxId + " (outer transaction " + outerTxId + ")", t);
    }

    private TransactionPipeWrapper$() {
    }
}

