/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.expressions;

import java.io.Serializable;
import java.util.function.Consumer;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.RelationshipVisitor;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValues;
import scala.Function0;
import scala.collection.Iterator;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015e\u0001\u0002\u000e\u001c\u00051B\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\u0006\u0019\u0002!\t!\u0014\u0005\b#\u0002\u0011\r\u0011\"\u0003S\u0011\u0019\t\u0007\u0001)A\u0005'\"9!\r\u0001b\u0001\n\u0013\u0011\u0006BB2\u0001A\u0003%1\u000bC\u0004e\u0001\u0001\u0007I\u0011B3\t\u000f1\u0004\u0001\u0019!C\u0005[\"11\u000f\u0001Q!\n\u0019DQ\u0001\u001e\u0001\u0005\u0002UDQA\u001f\u0001\u0005\u0002mDQ\u0001 \u0001\u0005\u0002uDa!a\u0001\u0001\t\u0003Y\bbBA\u0003\u0001\u0011\u0005\u0011q\u0001\u0005\b\u0003\u001b\u0001A\u0011AA\b\u0011\u001d\ti\u0001\u0001C\u0001\u0003+Aq!!\t\u0001\t\u0003\t\u0019\u0003C\u0004\u0002(\u0001!\t!!\u000b\t\u000f\u00055\u0002\u0001\"\u0001\u00020!9\u00111\u0007\u0001\u0005\u0002\u0005U\u0002bBA\u001e\u0001\u0011\u0005\u0011Q\b\u0005\b\u0003\u0003\u0002A\u0011AA\"\u0011\u001d\t9\u0005\u0001C\u0001\u0003\u0013Bq!!\u0015\u0001\t\u0003\n\u0019\u0006C\u0004\u0002Z\u0001!I!a\u0017\u0003!A\u000bG\u000f\u001b,bYV,')^5mI\u0016\u0014(B\u0001\u000f\u001e\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005yy\u0012\u0001C2p[6\fg\u000eZ:\u000b\u0005\u0001\n\u0013aC5oi\u0016\u0014\bO]3uK\u0012T!AI\u0012\u0002\u000fI,h\u000e^5nK*\u0011A%J\u0001\tS:$XM\u001d8bY*\u0011aeJ\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005!J\u0013!\u00028f_RR'\"\u0001\u0016\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001iS\u0007\u0005\u0002/g5\tqF\u0003\u00021c\u0005!A.\u00198h\u0015\u0005\u0011\u0014\u0001\u00026bm\u0006L!\u0001N\u0018\u0003\r=\u0013'.Z2u!\r14(P\u0007\u0002o)\u0011\u0001(O\u0001\tMVt7\r^5p]*\u0011!(M\u0001\u0005kRLG.\u0003\u0002=o\tA1i\u001c8tk6,'\u000f\u0005\u0002?\u00076\tqH\u0003\u0002A\u0003\u00069a/\u001b:uk\u0006d'B\u0001\"(\u0003\u00191\u0018\r\\;fg&\u0011Ai\u0010\u0002\u0014%\u0016d\u0017\r^5p]ND\u0017\u000e\u001d,jg&$xN]\u0001\u0006gR\fG/\u001a\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013~\tQ\u0001]5qKNL!a\u0013%\u0003\u0015E+XM]=Ti\u0006$X-\u0001\u0004=S:LGO\u0010\u000b\u0003\u001dB\u0003\"a\u0014\u0001\u000e\u0003mAQ!\u0012\u0002A\u0002\u0019\u000bQA\\8eKN,\u0012a\u0015\t\u0003)~k\u0011!\u0016\u0006\u0003-^\u000b\u0011\u0002\u001d:j[&$\u0018N^3\u000b\u0005aK\u0016\u0001\u00027jgRT!AW.\u0002\u0007\u0005\u0004\u0018N\u0003\u0002];\u0006Y1m\u001c7mK\u000e$\u0018n\u001c8t\u0015\tq\u0016&A\u0004fG2L\u0007o]3\n\u0005\u0001,&aD'vi\u0006\u0014G.\u001a'p]\u001ed\u0015n\u001d;\u0002\r9|G-Z:!\u0003\u0011\u0011X\r\\:\u0002\u000bI,Gn\u001d\u0011\u0002\r9,H\u000e\\3e+\u00051\u0007CA4k\u001b\u0005A'\"A5\u0002\u000bM\u001c\u0017\r\\1\n\u0005-D'a\u0002\"p_2,\u0017M\\\u0001\u000b]VdG.\u001a3`I\u0015\fHC\u00018r!\t9w.\u0003\u0002qQ\n!QK\\5u\u0011\u001d\u0011\b\"!AA\u0002\u0019\f1\u0001\u001f\u00132\u0003\u001dqW\u000f\u001c7fI\u0002\naA]3tk2$H#\u0001<\u0011\u0005]DX\"A!\n\u0005e\f%\u0001C!osZ\u000bG.^3\u0002\u000b\rdW-\u0019:\u0015\u00039\u000bA\u0002\u001d:fm&|Wo\u001d(pI\u0016,\u0012A \t\u0003O~L1!!\u0001i\u0005\u0011auN\\4\u0002\u0015\u0005$GMT8WC2,X-A\u0004bI\u0012tu\u000eZ3\u0015\u00079\u000bI\u0001\u0003\u0004\u0002\f9\u0001\rA^\u0001\u000b]>$Wm\u0014:Ok2d\u0017aD1eIJ+G.\u0019;j_:\u001c\b.\u001b9\u0015\u00079\u000b\t\u0002\u0003\u0004\u0002\u0014=\u0001\rA^\u0001\ne\u0016dwJ\u001d(vY2$2ATA\f\u0011\u001d\tI\u0002\u0005a\u0001\u00037\t1A]3m!\rq\u0014QD\u0005\u0004\u0003?y$\u0001\u0007,jeR,\u0018\r\u001c*fY\u0006$\u0018n\u001c8tQ&\u0004h+\u00197vK\u00069\u0012\r\u001a3J]\u000e|W.\u001b8h%\u0016d\u0017\r^5p]ND\u0017\u000e\u001d\u000b\u0004\u001d\u0006\u0015\u0002BBA\n#\u0001\u0007a/A\fbI\u0012|U\u000f^4pS:<'+\u001a7bi&|gn\u001d5jaR\u0019a*a\u000b\t\r\u0005M!\u00031\u0001w\u0003e\tG\rZ+oI&\u0014Xm\u0019;fIJ+G.\u0019;j_:\u001c\b.\u001b9\u0015\u00079\u000b\t\u0004\u0003\u0004\u0002\u0014M\u0001\rA^\u0001\u0019C\u0012$\u0017J\\2p[&twMU3mCRLwN\\:iSB\u001cHc\u0001(\u00028!1\u0011\u0011\b\u000bA\u0002Y\f!B]3mg>\u0013h*\u001e7m\u0003a\tG\rZ(vi\u001e|\u0017N\\4SK2\fG/[8og\"L\u0007o\u001d\u000b\u0004\u001d\u0006}\u0002BBA\u001d+\u0001\u0007a/\u0001\u000ebI\u0012,f\u000eZ5sK\u000e$X\r\u001a*fY\u0006$\u0018n\u001c8tQ&\u00048\u000fF\u0002O\u0003\u000bBa!!\u000f\u0017\u0001\u00041\u0018\u0001E2peJ,7\r\u001e#je\u0016\u001cG/[8o)\u00151\u00171JA'\u0011\u001d\tIb\u0006a\u0001\u00037Aa!a\u0014\u0018\u0001\u0004q\u0018A\u00029sKZLE-\u0001\u0004bG\u000e,\u0007\u000f\u001e\u000b\u0004]\u0006U\u0003BBA,1\u0001\u0007Q(A\u0001u\u0003%qW\u000f\u001c7DQ\u0016\u001c7.\u0006\u0003\u0002^\u0005MD\u0003BA0\u0003W\"2ATA1\u0011!\t\u0019'\u0007CA\u0002\u0005\u0015\u0014!\u00014\u0011\t\u001d\f9GT\u0005\u0004\u0003SB'\u0001\u0003\u001fcs:\fW.\u001a \t\u000f\u00055\u0014\u00041\u0001\u0002p\u0005)a/\u00197vKB!\u0011\u0011OA:\u0019\u0001!q!!\u001e\u001a\u0005\u0004\t9HA\u0001B#\u0011\tI(a \u0011\u0007\u001d\fY(C\u0002\u0002~!\u0014qAT8uQ&tw\rE\u0002h\u0003\u0003K1!a!i\u0005\u0019\te.\u001f*fM\u0002")
public final class PathValueBuilder
implements Consumer<RelationshipVisitor> {
    private final QueryState state;
    private final MutableLongList nodes;
    private final MutableLongList rels;
    private boolean nulled;

    @Override
    public Consumer<RelationshipVisitor> andThen(Consumer<? super RelationshipVisitor> x$1) {
        return Consumer.super.andThen(x$1);
    }

    private MutableLongList nodes() {
        return this.nodes;
    }

    private MutableLongList rels() {
        return this.rels;
    }

    private boolean nulled() {
        return this.nulled;
    }

    private void nulled_$eq(boolean x$1) {
        this.nulled = x$1;
    }

    public AnyValue result() {
        if (this.nulled()) {
            return Values.NO_VALUE;
        }
        return VirtualValues.pathReference((long[])this.nodes().toArray(), (long[])this.rels().toArray());
    }

    public PathValueBuilder clear() {
        this.nodes().clear();
        this.rels().clear();
        this.nulled_$eq(false);
        return this;
    }

    public long previousNode() {
        return this.nodes().getLast();
    }

    public PathValueBuilder addNoValue() {
        this.nulled_$eq(true);
        return this;
    }

    public PathValueBuilder addNode(AnyValue nodeOrNull) {
        return this.nullCheck(nodeOrNull, (Function0<PathValueBuilder>)(Function0 & Serializable)() -> {
            VirtualNodeValue node = (VirtualNodeValue)nodeOrNull;
            this.nodes().add(node.id());
            return this;
        });
    }

    public PathValueBuilder addRelationship(AnyValue relOrNull) {
        return this.nullCheck(relOrNull, (Function0<PathValueBuilder>)(Function0 & Serializable)() -> this.addRelationship((VirtualRelationshipValue)relOrNull));
    }

    public PathValueBuilder addRelationship(VirtualRelationshipValue rel) {
        this.rels().add(rel.id());
        return this;
    }

    public PathValueBuilder addIncomingRelationship(AnyValue relOrNull) {
        return this.nullCheck(relOrNull, (Function0<PathValueBuilder>)(Function0 & Serializable)() -> {
            VirtualRelationshipValue rel = (VirtualRelationshipValue)relOrNull;
            this.rels().add(rel.id());
            this.nodes().add(rel.startNodeId((Consumer)this));
            return this;
        });
    }

    public PathValueBuilder addOutgoingRelationship(AnyValue relOrNull) {
        return this.nullCheck(relOrNull, (Function0<PathValueBuilder>)(Function0 & Serializable)() -> {
            VirtualRelationshipValue rel = (VirtualRelationshipValue)relOrNull;
            this.rels().add(rel.id());
            this.nodes().add(rel.endNodeId((Consumer)this));
            return this;
        });
    }

    public PathValueBuilder addUndirectedRelationship(AnyValue relOrNull) {
        return this.nullCheck(relOrNull, (Function0<PathValueBuilder>)(Function0 & Serializable)() -> {
            VirtualRelationshipValue rel = (VirtualRelationshipValue)relOrNull;
            long previousNode = this.nodes().getLast();
            long start = rel.startNodeId((Consumer)this);
            long end = rel.endNodeId((Consumer)this);
            if (start == previousNode) {
                return this.addOutgoingRelationship((AnyValue)rel);
            }
            if (end == previousNode) {
                return this.addIncomingRelationship((AnyValue)rel);
            }
            throw new IllegalArgumentException("Invalid usage of PathValueBuilder, " + previousNode + " must be a node in " + rel);
        });
    }

    public PathValueBuilder addIncomingRelationships(AnyValue relsOrNull) {
        return this.nullCheck(relsOrNull, (Function0<PathValueBuilder>)(Function0 & Serializable)() -> {
            ListValue relsToAdd = (ListValue)relsOrNull;
            java.util.Iterator iterator = relsToAdd.iterator();
            while (iterator.hasNext()) {
                this.addIncomingRelationship((AnyValue)((VirtualRelationshipValue)iterator.next()));
            }
            return this;
        });
    }

    public PathValueBuilder addOutgoingRelationships(AnyValue relsOrNull) {
        return this.nullCheck(relsOrNull, (Function0<PathValueBuilder>)(Function0 & Serializable)() -> {
            ListValue relsToAdd = (ListValue)relsOrNull;
            java.util.Iterator iterator = relsToAdd.iterator();
            while (iterator.hasNext()) {
                this.addOutgoingRelationship((AnyValue)((VirtualRelationshipValue)iterator.next()));
            }
            return this;
        });
    }

    public PathValueBuilder addUndirectedRelationships(AnyValue relsOrNull) {
        return this.nullCheck(relsOrNull, (Function0<PathValueBuilder>)(Function0 & Serializable)() -> {
            ListValue relsToAdd = (ListValue)relsOrNull;
            java.util.Iterator relIterator = relsToAdd.iterator();
            if (relIterator.hasNext()) {
                long previousNode;
                VirtualRelationshipValue first = (VirtualRelationshipValue)relIterator.next();
                if (this.correctDirection(first, previousNode = this.nodes().getLast())) {
                    this.addUndirectedRelationship((AnyValue)first);
                    this.consumeIterator$1(CollectionConverters$.MODULE$.IteratorHasAsScala(relIterator).asScala());
                    v0 = BoxedUnit.UNIT;
                } else {
                    this.consumeIterator$1(CollectionConverters$.MODULE$.IteratorHasAsScala(relIterator).asScala().toIndexedSeq().reverseIterator());
                    v0 = this.addUndirectedRelationship((AnyValue)first);
                }
            } else {
                v0 = BoxedUnit.UNIT;
            }
            return this;
        });
    }

    public boolean correctDirection(VirtualRelationshipValue rel, long prevId) {
        long start = rel.startNodeId((Consumer)this);
        long end = rel.endNodeId((Consumer)this);
        return start == prevId || end == prevId;
    }

    @Override
    public void accept(RelationshipVisitor t) {
        RelationshipScanCursor cursor = this.state.cursors().relationshipScanCursor();
        this.state.query().singleRelationship(t.id(), cursor);
        cursor.next();
        t.visit(cursor.sourceNodeReference(), cursor.targetNodeReference(), cursor.type());
    }

    private <A> PathValueBuilder nullCheck(A value, Function0<PathValueBuilder> f) {
        A a = value;
        if (a == null || Values.NO_VALUE == a) {
            this.nulled_$eq(true);
            return this;
        }
        return (PathValueBuilder)f.apply();
    }

    private final void consumeIterator$1(Iterator i) {
        while (i.hasNext()) {
            this.addUndirectedRelationship((AnyValue)((VirtualRelationshipValue)i.next()));
        }
    }

    public PathValueBuilder(QueryState state) {
        this.state = state;
        this.nodes = LongLists.mutable.empty();
        this.rels = LongLists.mutable.empty();
        this.nulled = false;
    }
}

