/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.pipes;

import java.io.Serializable;
import org.neo4j.cypher.internal.runtime.IsNoValue$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.DeletePipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.Pipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.util.attribution.Id$;
import org.neo4j.cypher.operations.CypherTypeValueMapper;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualPathValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple3;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class DeletePipe$
implements Serializable {
    public static final DeletePipe$ MODULE$ = new DeletePipe$();

    public int $lessinit$greater$default$4(Pipe src, Expression expression, boolean forced) {
        return Id$.MODULE$.INVALID_ID();
    }

    public void delete(AnyValue toDelete, QueryState state, boolean forced) {
        AnyValue anyValue = toDelete;
        if (anyValue != null && IsNoValue$.MODULE$.unapply(anyValue)) {
            return;
        }
        if (anyValue instanceof VirtualRelationshipValue) {
            VirtualRelationshipValue virtualRelationshipValue = (VirtualRelationshipValue)anyValue;
            this.deleteRelationship(virtualRelationshipValue, state);
            return;
        }
        if (anyValue instanceof VirtualNodeValue) {
            VirtualNodeValue virtualNodeValue = (VirtualNodeValue)anyValue;
            this.deleteNode(virtualNodeValue, state, forced);
            return;
        }
        if (anyValue instanceof VirtualPathValue) {
            VirtualPathValue virtualPathValue = (VirtualPathValue)anyValue;
            this.deletePath(virtualPathValue, state, forced);
            return;
        }
        if (anyValue instanceof Value) {
            Value value = (Value)anyValue;
            throw CypherTypeException.expectedNodeRelPath((String)value.prettyPrint(), (String)value.getClass().getSimpleName(), (String)CypherTypeValueMapper.valueType((AnyValue)value));
        }
        throw CypherTypeException.expectedNodeRelPath((String)String.valueOf(anyValue), (String)anyValue.getClass().getSimpleName(), (String)CypherTypeValueMapper.valueType((AnyValue)anyValue));
    }

    private Object deleteNode(VirtualNodeValue n, QueryState state, boolean forced) {
        if (!state.query().nodeReadOps().isDeletedInThisTx(n.id())) {
            if (forced) {
                return BoxesRunTime.boxToInteger((int)state.query().detachDeleteNode(n.id()));
            }
            return BoxesRunTime.boxToBoolean((boolean)state.query().nodeWriteOps().delete(n.id()));
        }
        return BoxedUnit.UNIT;
    }

    private void deleteRelationship(VirtualRelationshipValue r, QueryState state) {
        if (!state.query().relationshipReadOps().isDeletedInThisTx(r.id())) {
            state.query().relationshipWriteOps().delete(r.id());
            return;
        }
    }

    private void deletePath(VirtualPathValue p, QueryState state, boolean forced) {
        for (AnyValue anyValue : p.asList()) {
            if (anyValue instanceof VirtualNodeValue) {
                VirtualNodeValue virtualNodeValue = (VirtualNodeValue)anyValue;
                this.deleteNode(virtualNodeValue, state, forced);
                continue;
            }
            if (anyValue instanceof VirtualRelationshipValue) {
                VirtualRelationshipValue virtualRelationshipValue = (VirtualRelationshipValue)anyValue;
                this.deleteRelationship(virtualRelationshipValue, state);
                continue;
            }
            if (anyValue instanceof Value) {
                Value value = (Value)anyValue;
                throw CypherTypeException.expectedNodeRel((String)value.getClass().getSimpleName(), (String)value.prettyPrint(), (String)CypherTypeValueMapper.valueType((AnyValue)value));
            }
            throw CypherTypeException.expectedNodeRel((String)anyValue.getClass().getSimpleName(), (String)String.valueOf(anyValue), (String)CypherTypeValueMapper.valueType((AnyValue)anyValue));
        }
    }

    public DeletePipe apply(Pipe src, Expression expression, boolean forced, int id) {
        return new DeletePipe(src, expression, forced, id);
    }

    public int apply$default$4(Pipe src, Expression expression, boolean forced) {
        return Id$.MODULE$.INVALID_ID();
    }

    public Option<Tuple3<Pipe, Expression, Object>> unapply(DeletePipe x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3((Object)x$0.src(), (Object)x$0.expression(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.forced())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DeletePipe$.class);
    }

    private DeletePipe$() {
    }
}

