/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.pipes;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import org.neo4j.cypher.internal.ir.CSVFormat;
import org.neo4j.cypher.internal.ir.HasHeaders$;
import org.neo4j.cypher.internal.ir.NoHeaders$;
import org.neo4j.cypher.internal.runtime.ArrayBackedMap;
import org.neo4j.cypher.internal.runtime.ArrayBackedMap$;
import org.neo4j.cypher.internal.runtime.ClosingIterator;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.LoadCsvIterator;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.Pipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.PipeWithSource;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.exceptions.LoadExternalResourceException;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Uh!\u0002\u0016,\u0003\u0003Q\u0004\u0002C \u0001\u0005\u0003\u0005\u000b\u0011\u0002!\t\u0011\r\u0003!\u0011!Q\u0001\n\u0011C\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\t'\u0002\u0011\t\u0011)A\u0005)\"AQ\r\u0001B\u0001B\u0003%a\r\u0003\u0005j\u0001\t\u0005\t\u0015!\u0003k\u0011\u0015i\u0007\u0001\"\u0001o\u0011\u00151\bA\"\u0005x\r\u0019\ty\u0002\u0001\u0003\u0002\"!Q\u0011\u0011F\u0005\u0003\u0002\u0003\u0006I!a\u000b\t\u0013\u00055\u0011B!A!\u0002\u0013A\b\u0002C?\n\u0005\u0003\u0005\u000b\u0011\u0002.\t\u0015\u0005%\u0013B!A!\u0002\u0013\tY\u0005\u0003\u0004n\u0013\u0011\u0005\u0011\u0011\u000b\u0005\n\u0003?J!\u0019!C\u0005\u0003CB\u0001\"!\u001b\nA\u0003%\u00111\r\u0005\n\u0003WJ!\u0019!C\u0005\u0003[B\u0001\"a\u001c\nA\u0003%\u0011\u0011\u0001\u0005\f\u0003cJ\u0001\u0019!a\u0001\n\u0013\t\u0019\bC\u0006\u0002v%\u0001\r\u00111A\u0005\n\u0005]\u0004BCAB\u0013\u0001\u0007\t\u0011)Q\u0005q\"I\u0011QQ\u0005A\u0002\u0013%\u0011q\u0011\u0005\n\u0003\u0013K\u0001\u0019!C\u0005\u0003\u0017Cq!a$\nA\u0003&a\r\u0003\u0005\u0002\u0012&\u0001K\u0011KAJ\u0011\u001d\t)*\u0003C!\u0003\u000fCq!a&\n\t\u0003\nI\nC\u0004\u0002\u001c&!I!!'\u0007\r\u0005u\u0005\u0001BAP\u0011%\ti!\bB\u0001B\u0003%\u0001\u0010\u0003\u0005~;\t\u0005\t\u0015!\u0003[\u0011)\tI%\bB\u0001B\u0003%\u00111\n\u0005\u0007[v!\t!!)\t\u0011\u0005EU\u0004)C)\u0003'Cq!!&\u001e\t\u0003\n9\tC\u0004\u0002\u0018v!\t%!'\t\u000f\u0005-\u0006\u0001\"\u0003\u0002.\"9\u0011\u0011\u0019\u0001\u0005R\u0005\r\u0007bBAf\u0001\u0011%\u0011Q\u001a\u0005\b\u0003C\u0004A\u0011BAr\u0011\u001d\tI\u000f\u0001C\u0005\u0003W\u00141#\u00112tiJ\f7\r\u001e'pC\u0012\u001c5K\u0016)ja\u0016T!\u0001L\u0017\u0002\u000bAL\u0007/Z:\u000b\u00059z\u0013aC5oi\u0016\u0014\bO]3uK\u0012T!\u0001M\u0019\u0002\u000fI,h\u000e^5nK*\u0011!gM\u0001\tS:$XM\u001d8bY*\u0011A'N\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005Y:\u0014!\u00028f_RR'\"\u0001\u001d\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001Y\u0004C\u0001\u001f>\u001b\u0005Y\u0013B\u0001 ,\u00059\u0001\u0016\u000e]3XSRD7k\\;sG\u0016\faa]8ve\u000e,\u0007C\u0001\u001fB\u0013\t\u00115F\u0001\u0003QSB,\u0017A\u00024pe6\fG\u000f\u0005\u0002F\u00116\taI\u0003\u0002Hc\u0005\u0011\u0011N]\u0005\u0003\u0013\u001a\u0013\u0011bQ*W\r>\u0014X.\u0019;\u0002\u001bU\u0014H.\u0012=qe\u0016\u001c8/[8o!\ta\u0015+D\u0001N\u0015\tqu*A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001).\u0003!\u0019w.\\7b]\u0012\u001c\u0018B\u0001*N\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0010M&,G\u000e\u001a+fe6Lg.\u0019;peB\u0019Q\u000b\u0017.\u000e\u0003YS\u0011aV\u0001\u0006g\u000e\fG.Y\u0005\u00033Z\u0013aa\u00149uS>t\u0007CA.c\u001d\ta\u0006\r\u0005\u0002^-6\taL\u0003\u0002`s\u00051AH]8pizJ!!\u0019,\u0002\rA\u0013X\rZ3g\u0013\t\u0019GM\u0001\u0004TiJLgn\u001a\u0006\u0003CZ\u000ba\u0003\\3hC\u000eL8i\u001d<Rk>$X-R:dCBLgn\u001a\t\u0003+\u001eL!\u0001\u001b,\u0003\u000f\t{w\u000e\\3b]\u0006Q!-\u001e4gKJ\u001c\u0016N_3\u0011\u0005U[\u0017B\u00017W\u0005\rIe\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f=\u0004\u0018O]:ukB\u0011A\b\u0001\u0005\u0006\u007f\u001d\u0001\r\u0001\u0011\u0005\u0006\u0007\u001e\u0001\r\u0001\u0012\u0005\u0006\u0015\u001e\u0001\ra\u0013\u0005\u0006'\u001e\u0001\r\u0001\u0016\u0005\u0006K\u001e\u0001\rA\u001a\u0005\u0006S\u001e\u0001\rA[\u0001\toJLG/\u001a*poRI\u0001\u0010 @\u0002\b\u0005-\u0011q\u0002\t\u0003sjl\u0011aL\u0005\u0003w>\u0012\u0011bQ=qQ\u0016\u0014(k\\<\t\u000buD\u0001\u0019\u0001.\u0002\u0011\u0019LG.\u001a8b[\u0016Daa \u0005A\u0002\u0005\u0005\u0011A\u00037j]\u0016tW/\u001c2feB\u0019Q+a\u0001\n\u0007\u0005\u0015aK\u0001\u0003M_:<\u0007BBA\u0005\u0011\u0001\u0007a-\u0001\u0003mCN$\bBBA\u0007\u0011\u0001\u0007\u00010A\u0006be\u001e,X.\u001a8u%><\bbBA\t\u0011\u0001\u0007\u00111C\u0001\u0006m\u0006dW/\u001a\t\u0005\u0003+\tY\"\u0004\u0002\u0002\u0018)\u0019\u0011\u0011D\u001b\u0002\rY\fG.^3t\u0013\u0011\ti\"a\u0006\u0003\u0011\u0005s\u0017PV1mk\u0016\u00141#\u0013;fe\u0006$xN],ji\"DU-\u00193feN\u001c2!CA\u0012!\u0011I\u0018Q\u0005=\n\u0007\u0005\u001drFA\bDY>\u001c\u0018N\\4Ji\u0016\u0014\u0018\r^8s\u0003\u001dAW-\u00193feN\u0004b!!\f\u00028\u0005ub\u0002BA\u0018\u0003gq1!XA\u0019\u0013\u00059\u0016bAA\u001b-\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u001d\u0003w\u00111aU3r\u0015\r\t)D\u0016\t\u0005\u0003\u007f\t)%\u0004\u0002\u0002B)!\u00111IA\f\u0003!\u0019Ho\u001c:bE2,\u0017\u0002BA$\u0003\u0003\u0012QAV1mk\u0016\fQ!\u001b8oKJ\u00042\u0001PA'\u0013\r\tye\u000b\u0002\u0010\u0019>\fGmQ:w\u0013R,'/\u0019;peRQ\u00111KA,\u00033\nY&!\u0018\u0011\u0007\u0005U\u0013\"D\u0001\u0001\u0011\u001d\tIC\u0004a\u0001\u0003WAa!!\u0004\u000f\u0001\u0004A\b\"B?\u000f\u0001\u0004Q\u0006bBA%\u001d\u0001\u0007\u00111J\u0001\fS:$XM\u001d8bY6\u000b\u0007/\u0006\u0002\u0002dA1\u00110!\u001a[\u0003'I1!a\u001a0\u00059\t%O]1z\u0005\u0006\u001c7.\u001a3NCB\fA\"\u001b8uKJt\u0017\r\\'ba\u0002\nq\"\u001b8uKJt\u0017\r\\'baNK'0Z\u000b\u0003\u0003\u0003\t\u0001#\u001b8uKJt\u0017\r\\'baNK'0\u001a\u0011\u0002\r9,wOU8x+\u0005A\u0018A\u00038foJ{wo\u0018\u0013fcR!\u0011\u0011PA@!\r)\u00161P\u0005\u0004\u0003{2&\u0001B+oSRD\u0001\"!!\u0015\u0003\u0003\u0005\r\u0001_\u0001\u0004q\u0012\n\u0014a\u00028foJ{w\u000fI\u0001\f]\u0016,Gm]+qI\u0006$X-F\u0001g\u0003=qW-\u001a3t+B$\u0017\r^3`I\u0015\fH\u0003BA=\u0003\u001bC\u0001\"!!\u0018\u0003\u0003\u0005\rAZ\u0001\r]\u0016,Gm]+qI\u0006$X\rI\u0001\nG2|7/Z'pe\u0016$\"!!\u001f\u0002\u0019%tg.\u001a:ICNtU\r\u001f;\u0002\t9,\u0007\u0010\u001e\u000b\u0002q\u0006q1m\\7qkR,g*\u001a=u%><(AF%uKJ\fGo\u001c:XSRDw.\u001e;IK\u0006$WM]:\u0014\u0007u\t\u0019\u0003\u0006\u0005\u0002$\u0006\u0015\u0016qUAU!\r\t)&\b\u0005\u0007\u0003\u001b\t\u0003\u0019\u0001=\t\u000bu\f\u0003\u0019\u0001.\t\u000f\u0005%\u0013\u00051\u0001\u0002L\u0005\u0011r-\u001a;M_\u0006$7i\u0015,Ji\u0016\u0014\u0018\r^8s)!\tY%a,\u0002:\u0006u\u0006bBAYK\u0001\u0007\u00111W\u0001\u0006gR\fG/\u001a\t\u0004y\u0005U\u0016bAA\\W\tQ\u0011+^3ssN#\u0018\r^3\t\r\u0005mV\u00051\u0001[\u0003%)(\u000f\\*ue&tw\r\u0003\u0004\u0002@\u0016\u0002\rAZ\u0001\u000bkN,\u0007*Z1eKJ\u001c\u0018!F5oi\u0016\u0014h.\u00197De\u0016\fG/\u001a*fgVdGo\u001d\u000b\u0007\u0003G\t)-!3\t\u000f\u0005\u001dg\u00051\u0001\u0002$\u0005)\u0011N\u001c9vi\"9\u0011\u0011\u0017\u0014A\u0002\u0005M\u0016\u0001D4fi&k\u0007o\u001c:u+JKE\u0003BAh\u0003?\u0004B!!5\u0002\\6\u0011\u00111\u001b\u0006\u0005\u0003+\f9.A\u0002oKRT!!!7\u0002\t)\fg/Y\u0005\u0005\u0003;\f\u0019NA\u0002V%&Ca!a/(\u0001\u0004Q\u0016a\u00044jY\u0016t\u0015-\\3Ge>lWK]5\u0015\u0007i\u000b)\u000fC\u0004\u0002h\"\u0002\r!a4\u0002\u0007U\u0014\u0018.A\bsKBd\u0017mY3O_Z\u000bG.^3t)\u0011\ti/a=\u0011\r\u00055\u0012q^A\u001f\u0013\u0011\t\t0a\u000f\u0003\u0015%sG-\u001a=fIN+\u0017\u000fC\u0004\u0002*%\u0002\r!!<")
public abstract class AbstractLoadCSVPipe
extends PipeWithSource {
    private final CSVFormat format;
    private final Expression urlExpression;
    private final Option<String> fieldTerminator;
    private final boolean legacyCsvQuoteEscaping;
    private final int bufferSize;

    public abstract CypherRow writeRow(String var1, long var2, boolean var4, CypherRow var5, AnyValue var6);

    private LoadCsvIterator getLoadCSVIterator(QueryState state, String urlString, boolean useHeaders) {
        return state.resources().getCsvIterator(urlString, state.query(), this.fieldTerminator, this.legacyCsvQuoteEscaping, this.bufferSize, useHeaders);
    }

    @Override
    public ClosingIterator<CypherRow> internalCreateResults(ClosingIterator<CypherRow> input, QueryState state) {
        return input.flatMap((Function1 & Serializable)row -> {
            String urlString = ((TextValue)$this.urlExpression.apply((ReadableRow)row, state)).stringValue();
            URI uri = this.getImportURI(urlString);
            String fileName = this.fileNameFromUri(uri);
            CSVFormat cSVFormat = $this.format;
            if (HasHeaders$.MODULE$.equals(cSVFormat)) {
                LoadCsvIterator iterator = this.getLoadCSVIterator(state, urlString, true);
                IndexedSeq headers = ((ClosingIterator)iterator).nonEmpty() ? ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.refArrayOps((Object[])((ClosingIterator)iterator).next())) : (IndexedSeq)package$.MODULE$.IndexedSeq().empty();
                return new IteratorWithHeaders(this, (Seq<Value>)this.replaceNoValues((IndexedSeq<Value>)headers), (CypherRow)row, fileName, iterator);
            }
            if (NoHeaders$.MODULE$.equals(cSVFormat)) {
                return new IteratorWithoutHeaders(this, (CypherRow)row, fileName, this.getLoadCSVIterator(state, urlString, false));
            }
            throw new MatchError((Object)cSVFormat);
        });
    }

    private URI getImportURI(String urlString) {
        URI uRI;
        try {
            uRI = new URI(urlString);
        }
        catch (URISyntaxException e) {
            if (e.getMessage().startsWith("Expected scheme name")) {
                throw LoadExternalResourceException.invalidUrlNoProtocol((String)urlString, (Throwable)e);
            }
            throw LoadExternalResourceException.invalidUrl((String)urlString, (Throwable)e);
        }
        URI uri = uRI;
        if (!uri.isAbsolute() || uri.getScheme() == null) {
            throw LoadExternalResourceException.invalidUrlNoProtocol((String)urlString);
        }
        return uri;
    }

    private String fileNameFromUri(URI uri) {
        int ix;
        String string = uri.getScheme();
        String string2 = "file";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return uri.getSchemeSpecificPart();
        }
        String path = uri.getPath();
        int n = ix = path == null ? -1 : path.lastIndexOf("/");
        if (ix == -1) {
            return "N/A";
        }
        return path.substring(ix + 1);
    }

    private IndexedSeq<Value> replaceNoValues(IndexedSeq<Value> headers) {
        return (IndexedSeq)headers.map((Function1 & Serializable)x0$1 -> {
            Value value = x0$1;
            if (value == Values.NO_VALUE) {
                return Values.stringValue((String)"");
            }
            return value;
        });
    }

    public AbstractLoadCSVPipe(Pipe source, CSVFormat format, Expression urlExpression, Option<String> fieldTerminator, boolean legacyCsvQuoteEscaping, int bufferSize) {
        this.format = format;
        this.urlExpression = urlExpression;
        this.fieldTerminator = fieldTerminator;
        this.legacyCsvQuoteEscaping = legacyCsvQuoteEscaping;
        this.bufferSize = bufferSize;
        super(source);
    }

    private class IteratorWithHeaders
    extends ClosingIterator<CypherRow> {
        private final CypherRow argumentRow;
        private final String filename;
        private final LoadCsvIterator inner;
        private final ArrayBackedMap<String, AnyValue> internalMap;
        private final long internalMapSize;
        private CypherRow newRow;
        private boolean needsUpdate;
        public final /* synthetic */ AbstractLoadCSVPipe $outer;

        private ArrayBackedMap<String, AnyValue> internalMap() {
            return this.internalMap;
        }

        private long internalMapSize() {
            return this.internalMapSize;
        }

        private CypherRow newRow() {
            return this.newRow;
        }

        private void newRow_$eq(CypherRow x$1) {
            this.newRow = x$1;
        }

        private boolean needsUpdate() {
            return this.needsUpdate;
        }

        private void needsUpdate_$eq(boolean x$1) {
            this.needsUpdate = x$1;
        }

        public void closeMore() {
            ((ClosingIterator)this.inner).close();
        }

        public boolean innerHasNext() {
            if (this.needsUpdate()) {
                this.newRow_$eq(this.computeNextRow());
                this.needsUpdate_$eq(false);
            }
            return this.newRow() != null;
        }

        public CypherRow next() {
            Object object = !this.hasNext() ? package$.MODULE$.Iterator().empty().next() : BoxedUnit.UNIT;
            this.needsUpdate_$eq(true);
            return this.newRow();
        }

        private CypherRow computeNextRow() {
            if (((ClosingIterator)this.inner).hasNext()) {
                Value[] row = (Value[])((ClosingIterator)this.inner).next();
                this.internalMap().putValues((Object)((AnyValue[])row));
                java.util.Map internalMapCopy = CollectionConverters$.MODULE$.MapHasAsJava((Map)this.internalMap().copy()).asJava();
                long payloadSize = 0L;
                for (int i = 0; i < row.length; ++i) {
                    payloadSize += row[i].estimatedHeapUsage();
                }
                MapValue mapValue = VirtualValues.fromMap((java.util.Map)internalMapCopy, (long)this.internalMapSize(), (long)payloadSize);
                return this.org$neo4j$cypher$internal$runtime$interpreted$pipes$AbstractLoadCSVPipe$IteratorWithHeaders$$$outer().writeRow(this.filename, this.inner.lastProcessed(), this.inner.readAll(), this.argumentRow, (AnyValue)mapValue);
            }
            return null;
        }

        public /* synthetic */ AbstractLoadCSVPipe org$neo4j$cypher$internal$runtime$interpreted$pipes$AbstractLoadCSVPipe$IteratorWithHeaders$$$outer() {
            return this.$outer;
        }

        public IteratorWithHeaders(AbstractLoadCSVPipe $outer, Seq<Value> headers, CypherRow argumentRow, String filename, LoadCsvIterator inner) {
            this.argumentRow = argumentRow;
            this.filename = filename;
            this.inner = inner;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.internalMap = new ArrayBackedMap(((IterableOnceOps)((IterableOps)headers.map((Function1 & Serializable)a -> {
                if (a == Values.NO_VALUE) {
                    return null;
                }
                return ((TextValue)a).stringValue();
            })).zipWithIndex()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)Values.NO_VALUE, ClassTag$.MODULE$.apply(AnyValue.class));
            this.internalMapSize = ArrayBackedMap$.MODULE$.SHALLOW_SIZE() + HeapEstimator.shallowSizeOfObjectArray((int)headers.size());
            this.needsUpdate = true;
        }
    }

    private class IteratorWithoutHeaders
    extends ClosingIterator<CypherRow> {
        private final CypherRow argumentRow;
        private final String filename;
        private final LoadCsvIterator inner;
        public final /* synthetic */ AbstractLoadCSVPipe $outer;

        public void closeMore() {
            ((ClosingIterator)this.inner).close();
        }

        public boolean innerHasNext() {
            return ((ClosingIterator)this.inner).hasNext();
        }

        public CypherRow next() {
            ListValue value = VirtualValues.list((AnyValue[])((AnyValue[])((ClosingIterator)this.inner).next()));
            return this.org$neo4j$cypher$internal$runtime$interpreted$pipes$AbstractLoadCSVPipe$IteratorWithoutHeaders$$$outer().writeRow(this.filename, this.inner.lastProcessed(), this.inner.readAll(), this.argumentRow, (AnyValue)value);
        }

        public /* synthetic */ AbstractLoadCSVPipe org$neo4j$cypher$internal$runtime$interpreted$pipes$AbstractLoadCSVPipe$IteratorWithoutHeaders$$$outer() {
            return this.$outer;
        }

        public IteratorWithoutHeaders(AbstractLoadCSVPipe $outer, CypherRow argumentRow, String filename, LoadCsvIterator inner) {
            this.argumentRow = argumentRow;
            this.filename = filename;
            this.inner = inner;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

