/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands;

import java.io.Serializable;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.cypher.internal.ast.CommandResultItem;
import org.neo4j.cypher.internal.ast.ShowColumn;
import org.neo4j.cypher.internal.expressions.LogicalVariable;
import org.neo4j.cypher.internal.runtime.ClosingIterator;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.values.AnyValue;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dd!\u0002\u000b\u0016\u0003\u00031\u0003\u0002C\u0017\u0001\u0005\u000b\u0007I\u0011\u0002\u0018\t\u0011\u0005\u0003!\u0011!Q\u0001\n=B\u0001B\u0011\u0001\u0003\u0006\u0004%Ia\u0011\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\t\")\u0011\n\u0001C\u0001\u0015\"9q\n\u0001b\u0001\n\u0013q\u0003B\u0002)\u0001A\u0003%q\u0006C\u0004R\u0001\t\u0007I\u0011\u0003*\t\rq\u0003\u0001\u0015!\u0003T\u0011\u0015i\u0006A\"\u0005_\u0011\u0015I\b\u0001\"\u0002{\u0011\u0015i\b\u0001\"\u0005\u007f\u0011\u001d\tI\u0002\u0001C\t\u00037Aq!!\r\u0001\t#\t\u0019\u0004C\u0004\u0002:\u0001!I!a\u000f\b\u000f\u0005\u0005S\u0003#\u0001\u0002D\u00191A#\u0006E\u0001\u0003\u000bBa!S\t\u0005\u0002\u0005\u001d\u0003\u0002CA%#\u0011EQ#a\u0013\u0003\u000f\r{W.\\1oI*\u0011acF\u0001\rg\"|woY8n[\u0006tGm\u001d\u0006\u00031e\t\u0001bY8n[\u0006tGm\u001d\u0006\u00035m\t1\"\u001b8uKJ\u0004(/\u001a;fI*\u0011A$H\u0001\beVtG/[7f\u0015\tqr$\u0001\u0005j]R,'O\\1m\u0015\t\u0001\u0013%\u0001\u0004dsBDWM\u001d\u0006\u0003E\r\nQA\\3pi)T\u0011\u0001J\u0001\u0004_J<7\u0001A\n\u0003\u0001\u001d\u0002\"\u0001K\u0016\u000e\u0003%R\u0011AK\u0001\u0006g\u000e\fG.Y\u0005\u0003Y%\u0012a!\u00118z%\u00164\u0017A\u00043fM\u0006,H\u000e^\"pYVlgn]\u000b\u0002_A\u0019\u0001\u0007O\u001e\u000f\u0005E2dB\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b&\u0003\u0019a$o\\8u}%\t!&\u0003\u00028S\u00059\u0001/Y2lC\u001e,\u0017BA\u001d;\u0005\u0011a\u0015n\u001d;\u000b\u0005]J\u0003C\u0001\u001f@\u001b\u0005i$B\u0001 \u001e\u0003\r\t7\u000f^\u0005\u0003\u0001v\u0012!b\u00155po\u000e{G.^7o\u0003=!WMZ1vYR\u001cu\u000e\\;n]N\u0004\u0013\u0001D=jK2$7i\u001c7v[:\u001cX#\u0001#\u0011\u0007ABT\t\u0005\u0002=\r&\u0011q)\u0010\u0002\u0012\u0007>lW.\u00198e%\u0016\u001cX\u000f\u001c;Ji\u0016l\u0017!D=jK2$7i\u001c7v[:\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0004\u00176s\u0005C\u0001'\u0001\u001b\u0005)\u0002\"B\u0017\u0006\u0001\u0004y\u0003\"\u0002\"\u0006\u0001\u0004!\u0015aB2pYVlgn]\u0001\tG>dW/\u001c8tA\u0005)\"/Z9vKN$X\rZ\"pYVlgn\u001d(b[\u0016\u001cX#A*\u0011\u0007ABD\u000b\u0005\u0002V3:\u0011ak\u0016\t\u0003e%J!\u0001W\u0015\u0002\rA\u0013X\rZ3g\u0013\tQ6L\u0001\u0004TiJLgn\u001a\u0006\u00031&\naC]3rk\u0016\u001cH/\u001a3D_2,XN\\:OC6,7\u000fI\u0001\u0011_JLw-\u001b8bY:\u000bW.\u001a*poN$2a\u00187u!\r\u0001\u0017mY\u0007\u00027%\u0011!m\u0007\u0002\u0010\u00072|7/\u001b8h\u0013R,'/\u0019;peB!Q\u000b\u001a+g\u0013\t)7LA\u0002NCB\u0004\"a\u001a6\u000e\u0003!T!![\u0011\u0002\rY\fG.^3t\u0013\tY\u0007N\u0001\u0005B]f4\u0016\r\\;f\u0011\u0015i'\u00021\u0001o\u0003\u0015\u0019H/\u0019;f!\ty'/D\u0001q\u0015\t\t\u0018$A\u0003qSB,7/\u0003\u0002ta\nQ\u0011+^3ssN#\u0018\r^3\t\u000bUT\u0001\u0019\u0001<\u0002\u000f\t\f7/\u001a*poB\u0011\u0001m^\u0005\u0003qn\u0011\u0011bQ=qQ\u0016\u0014(k\\<\u0002\tI|wo\u001d\u000b\u0004?nd\b\"B7\f\u0001\u0004q\u0007\"B;\f\u0001\u00041\u0018!F4fi\u000e{gNZ5hkJ,G\rV5nKj{g.\u001a\u000b\u0004\u007f\u0006=\u0001\u0003BA\u0001\u0003\u0017i!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\u0005i&lWM\u0003\u0002\u0002\n\u0005!!.\u0019<b\u0013\u0011\ti!a\u0001\u0003\ri{g.Z%e\u0011\u001d\t\t\u0002\u0004a\u0001\u0003'\t1a\u0019;y!\r\u0001\u0017QC\u0005\u0004\u0003/Y\"\u0001D)vKJL8i\u001c8uKb$\u0018A\u00034pe6\fG\u000fV5nKR1\u0011QDA\u0012\u0003[\u0001B!!\u0001\u0002 %!\u0011\u0011EA\u0002\u00059yeMZ:fi\u0012\u000bG/\u001a+j[\u0016Dq!!\n\u000e\u0001\u0004\t9#A\u0005ti\u0006\u0014H\u000fV5nKB\u0019\u0001&!\u000b\n\u0007\u0005-\u0012F\u0001\u0003M_:<\u0007BBA\u0018\u001b\u0001\u0007q0\u0001\u0004{_:,\u0017\nZ\u0001(kB$\u0017\r^3S_^\u001cx+\u001b;i!>$XM\u001c;jC2d\u0017PU3oC6,GmQ8mk6t7\u000f\u0006\u0003\u00026\u0005]\u0002c\u0001\u00199G\"1\u0011P\u0004a\u0001\u0003k\t!bZ3u\u0007>dW/\u001c8t)\u0015y\u0013QHA \u0011\u0015is\u00021\u00010\u0011\u0015\u0011u\u00021\u0001E\u0003\u001d\u0019u.\\7b]\u0012\u0004\"\u0001T\t\u0014\u0005E9CCAA\"\u00031)\u0007\u0010\u001e:bGRt\u0015-\\3t)\u001d\u0019\u0016QJA2\u0003KBq!a\u0014\u0014\u0001\u0004\t\t&A\u0003oC6,7\u000f\u0005\u00041\u0003'\u001a\u0016qK\u0005\u0004\u0003+R$AB#ji\",'\u000f\u0005\u0003\u0002Z\u0005}SBAA.\u0015\r\tifF\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0003\u0002b\u0005m#AC#yaJ,7o]5p]\")Qn\u0005a\u0001]\")Qo\u0005a\u0001m\u0002")
public abstract class Command {
    private final List<ShowColumn> defaultColumns;
    private final List<CommandResultItem> yieldColumns;
    private final List<ShowColumn> columns;
    private final List<String> requestedColumnsNames;

    private List<ShowColumn> defaultColumns() {
        return this.defaultColumns;
    }

    private List<CommandResultItem> yieldColumns() {
        return this.yieldColumns;
    }

    private List<ShowColumn> columns() {
        return this.columns;
    }

    public List<String> requestedColumnsNames() {
        return this.requestedColumnsNames;
    }

    public abstract ClosingIterator<Map<String, AnyValue>> originalNameRows(QueryState var1, CypherRow var2);

    public final ClosingIterator<Map<String, AnyValue>> rows(QueryState state, CypherRow baseRow) {
        return this.originalNameRows(state, baseRow).map((Function1 & Serializable)map -> this.columns().map((Function1 & Serializable)x0$1 -> {
            ShowColumn showColumn = x0$1;
            if (showColumn != null) {
                LogicalVariable lv = showColumn.variable();
                String originalName = showColumn.name();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)lv.name()), map.apply((Object)originalName));
            }
            throw new MatchError((Object)showColumn);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public ZoneId getConfiguredTimeZone(QueryContext ctx) {
        return ((LogTimeZone)ctx.getConfig().get(GraphDatabaseSettings.db_timezone)).getZoneId();
    }

    public OffsetDateTime formatTime(long startTime, ZoneId zoneId) {
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(startTime), zoneId);
    }

    public List<Map<String, AnyValue>> updateRowsWithPotentiallyRenamedColumns(List<Map<String, AnyValue>> rows) {
        return rows.map((Function1 & Serializable)row -> (Map)row.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                AnyValue value = (AnyValue)tuple2._2();
                String newKey = (String)this.yieldColumns().find((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)Command.$anonfun$updateRowsWithPotentiallyRenamedColumns$3(key, c))).map((Function1 & Serializable)x$3 -> x$3.aliasedVariable().name()).getOrElse((Function0 & Serializable)() -> key);
                return new Tuple2((Object)newKey, (Object)value);
            }
            throw new MatchError((Object)tuple2);
        }));
    }

    private List<ShowColumn> getColumns(List<ShowColumn> defaultColumns, List<CommandResultItem> yieldColumns) {
        if (yieldColumns.nonEmpty()) {
            return yieldColumns.map((Function1 & Serializable)c -> {
                ShowColumn column = (ShowColumn)defaultColumns.find((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)Command.$anonfun$getColumns$2(c, s))).get();
                return new ShowColumn(c.aliasedVariable(), column.cypherType(), c.aliasedVariable().name());
            });
        }
        return defaultColumns;
    }

    public static final /* synthetic */ boolean $anonfun$updateRowsWithPotentiallyRenamedColumns$3(String key$1, CommandResultItem c) {
        return c.originalName().equals(key$1);
    }

    public static final /* synthetic */ boolean $anonfun$getColumns$2(CommandResultItem c$1, ShowColumn s) {
        return s.variable().name().equals(c$1.originalName());
    }

    /*
     * WARNING - void declaration
     */
    public Command(List<ShowColumn> defaultColumns, List<CommandResultItem> yieldColumns) {
        void var3_3;
        this.defaultColumns = defaultColumns;
        this.yieldColumns = yieldColumns;
        this.columns = this.getColumns(defaultColumns, yieldColumns);
        List yieldedColumns = yieldColumns.map((Function1 & Serializable)x$1 -> x$1.originalName());
        this.requestedColumnsNames = yieldedColumns.isEmpty() ? defaultColumns.map((Function1 & Serializable)x$2 -> x$2.name()) : var3_3;
    }
}

