/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands;

import java.io.Serializable;
import java.util.Optional;
import org.neo4j.cypher.internal.ast.CommandResultItem;
import org.neo4j.cypher.internal.ast.ShowColumn;
import org.neo4j.cypher.internal.runtime.ClosingIterator;
import org.neo4j.cypher.internal.runtime.ClosingIterator$;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.Command;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.Command$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.TerminateTransactionsCommand$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.TransactionCommandHelper$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.TransactionId;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.TransactionId$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.exceptions.InvalidSemanticsException;
import org.neo4j.internal.kernel.api.security.AdminActionOnResource;
import org.neo4j.internal.kernel.api.security.PrivilegeAction;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.kernel.api.security.Segment;
import org.neo4j.internal.kernel.api.security.UserSegment;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.logging.InternalLog;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\u00055h\u0001B\u000f\u001f\u0001>B\u0001B\u0012\u0001\u0003\u0016\u0004%\ta\u0012\u0005\t9\u0002\u0011\t\u0012)A\u0005\u0011\"AQ\f\u0001BK\u0002\u0013\u0005a\f\u0003\u0005g\u0001\tE\t\u0015!\u0003`\u0011!9\u0007A!f\u0001\n\u0003A\u0007\u0002C7\u0001\u0005#\u0005\u000b\u0011B5\t\u000b9\u0004A\u0011A8\t\u000bQ\u0004A\u0011I;\t\u0013\u0005\u0005\u0002!!A\u0005\u0002\u0005\r\u0002\"CA\u0016\u0001E\u0005I\u0011AA\u0017\u0011%\t\u0019\u0005AI\u0001\n\u0003\t)\u0005C\u0005\u0002J\u0001\t\n\u0011\"\u0001\u0002L!I\u0011q\n\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u000b\u0005\n\u0003C\u0002\u0011\u0011!C\u0001\u0003GB\u0011\"a\u001b\u0001\u0003\u0003%\t!!\u001c\t\u0013\u0005e\u0004!!A\u0005B\u0005m\u0004\"CAE\u0001\u0005\u0005I\u0011AAF\u0011%\t)\nAA\u0001\n\u0003\n9\nC\u0005\u0002\u001c\u0002\t\t\u0011\"\u0011\u0002\u001e\"I\u0011q\u0014\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u0015\u0005\n\u0003G\u0003\u0011\u0011!C!\u0003K;\u0011\"!+\u001f\u0003\u0003E\t!a+\u0007\u0011uq\u0012\u0011!E\u0001\u0003[CaA\\\f\u0005\u0002\u0005\r\u0007\"CAP/\u0005\u0005IQIAQ\u0011%\t)mFA\u0001\n\u0003\u000b9\rC\u0005\u0002P^\t\t\u0011\"!\u0002R\"I\u00111]\f\u0002\u0002\u0013%\u0011Q\u001d\u0002\u001d)\u0016\u0014X.\u001b8bi\u0016$&/\u00198tC\u000e$\u0018n\u001c8t\u0007>lW.\u00198e\u0015\ty\u0002%\u0001\u0007tQ><8m\\7nC:$7O\u0003\u0002\"E\u0005A1m\\7nC:$7O\u0003\u0002$I\u0005Y\u0011N\u001c;feB\u0014X\r^3e\u0015\t)c%A\u0004sk:$\u0018.\\3\u000b\u0005\u001dB\u0013\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005%R\u0013AB2za\",'O\u0003\u0002,Y\u0005)a.Z85U*\tQ&A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001aQR\u0004CA\u00193\u001b\u0005q\u0012BA\u001a\u001f\u0005\u001d\u0019u.\\7b]\u0012\u0004\"!\u000e\u001d\u000e\u0003YR\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sY\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002<\u0007:\u0011A(\u0011\b\u0003{\u0001k\u0011A\u0010\u0006\u0003\u007f9\na\u0001\u0010:p_Rt\u0014\"A\u001c\n\u0005\t3\u0014a\u00029bG.\fw-Z\u0005\u0003\t\u0016\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!A\u0011\u001c\u0002\u0011\u001dLg/\u001a8JIN,\u0012\u0001\u0013\t\u0005w%[e+\u0003\u0002K\u000b\n1Q)\u001b;iKJ\u00042a\u000f'O\u0013\tiUI\u0001\u0003MSN$\bCA(T\u001d\t\u0001\u0016\u000b\u0005\u0002>m%\u0011!KN\u0001\u0007!J,G-\u001a4\n\u0005Q+&AB*ue&twM\u0003\u0002SmA\u0011qKW\u0007\u00021*\u0011\u0011\fI\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0002\\1\nQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u0013\u001dLg/\u001a8JIN\u0004\u0013aB2pYVlgn]\u000b\u0002?B\u00191\b\u00141\u0011\u0005\u0005$W\"\u00012\u000b\u0005\r4\u0013aA1ti&\u0011QM\u0019\u0002\u000b'\"|woQ8mk6t\u0017\u0001C2pYVlgn\u001d\u0011\u0002\u0019eLW\r\u001c3D_2,XN\\:\u0016\u0003%\u00042a\u000f'k!\t\t7.\u0003\u0002mE\n\t2i\\7nC:$'+Z:vYRLE/Z7\u0002\u001beLW\r\u001c3D_2,XN\\:!\u0003\u0019a\u0014N\\5u}Q!\u0001/\u001d:t!\t\t\u0004\u0001C\u0003G\u000f\u0001\u0007\u0001\nC\u0003^\u000f\u0001\u0007q\fC\u0003h\u000f\u0001\u0007\u0011.\u0001\tpe&<\u0017N\\1m\u001d\u0006lWMU8xgR)a/a\u0002\u0002\u0018A\u0019q\u000f\u001f>\u000e\u0003\u0011J!!\u001f\u0013\u0003\u001f\rcwn]5oO&#XM]1u_J\u0004BaT>O{&\u0011A0\u0016\u0002\u0004\u001b\u0006\u0004\bc\u0001@\u0002\u00045\tqPC\u0002\u0002\u0002)\naA^1mk\u0016\u001c\u0018bAA\u0003\u007f\nA\u0011I\\=WC2,X\rC\u0004\u0002\n!\u0001\r!a\u0003\u0002\u000bM$\u0018\r^3\u0011\t\u00055\u00111C\u0007\u0003\u0003\u001fQ1!!\u0005#\u0003\u0015\u0001\u0018\u000e]3t\u0013\u0011\t)\"a\u0004\u0003\u0015E+XM]=Ti\u0006$X\rC\u0004\u0002\u001a!\u0001\r!a\u0007\u0002\u000f\t\f7/\u001a*poB\u0019q/!\b\n\u0007\u0005}AEA\u0005DsBDWM\u001d*po\u0006!1m\u001c9z)\u001d\u0001\u0018QEA\u0014\u0003SAqAR\u0005\u0011\u0002\u0003\u0007\u0001\nC\u0004^\u0013A\u0005\t\u0019A0\t\u000f\u001dL\u0001\u0013!a\u0001S\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0018U\rA\u0015\u0011G\u0016\u0003\u0003g\u0001B!!\u000e\u0002@5\u0011\u0011q\u0007\u0006\u0005\u0003s\tY$A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\b\u001c\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002B\u0005]\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA$U\ry\u0016\u0011G\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tiEK\u0002j\u0003c\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA*!\u0011\t)&a\u0018\u000e\u0005\u0005]#\u0002BA-\u00037\nA\u0001\\1oO*\u0011\u0011QL\u0001\u0005U\u00064\u0018-C\u0002U\u0003/\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u001a\u0011\u0007U\n9'C\u0002\u0002jY\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u001c\u0002vA\u0019Q'!\u001d\n\u0007\u0005MdGA\u0002B]fD\u0011\"a\u001e\u0010\u0003\u0003\u0005\r!!\u001a\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\b\u0005\u0004\u0002\u0000\u0005\u0015\u0015qN\u0007\u0003\u0003\u0003S1!a!7\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u000f\u000b\tI\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAG\u0003'\u00032!NAH\u0013\r\t\tJ\u000e\u0002\b\u0005>|G.Z1o\u0011%\t9(EA\u0001\u0002\u0004\ty'\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA*\u00033C\u0011\"a\u001e\u0013\u0003\u0003\u0005\r!!\u001a\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!\u001a\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0015\u0002\r\u0015\fX/\u00197t)\u0011\ti)a*\t\u0013\u0005]T#!AA\u0002\u0005=\u0014\u0001\b+fe6Lg.\u0019;f)J\fgn]1di&|gn]\"p[6\fg\u000e\u001a\t\u0003c]\u0019RaFAX\u0003s\u0003\u0002\"!-\u00026\"{\u0016\u000e]\u0007\u0003\u0003gS!!\n\u001c\n\t\u0005]\u00161\u0017\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001c\u0004\u0003BA^\u0003\u0003l!!!0\u000b\t\u0005}\u00161L\u0001\u0003S>L1\u0001RA_)\t\tY+A\u0003baBd\u0017\u0010F\u0004q\u0003\u0013\fY-!4\t\u000b\u0019S\u0002\u0019\u0001%\t\u000buS\u0002\u0019A0\t\u000b\u001dT\u0002\u0019A5\u0002\u000fUt\u0017\r\u001d9msR!\u00111[Ap!\u0015)\u0014Q[Am\u0013\r\t9N\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0011\rU\nY\u000eS0j\u0013\r\tiN\u000e\u0002\u0007)V\u0004H.Z\u001a\t\u0011\u0005\u00058$!AA\u0002A\f1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\t9\u000f\u0005\u0003\u0002V\u0005%\u0018\u0002BAv\u0003/\u0012aa\u00142kK\u000e$\b")
public class TerminateTransactionsCommand
extends Command
implements Product,
Serializable {
    private final Either<List<String>, Expression> givenIds;
    private final List<ShowColumn> columns;
    private final List<CommandResultItem> yieldColumns;

    public static Option<Tuple3<Either<List<String>, Expression>, List<ShowColumn>, List<CommandResultItem>>> unapply(TerminateTransactionsCommand x$0) {
        return TerminateTransactionsCommand$.MODULE$.unapply(x$0);
    }

    public static TerminateTransactionsCommand apply(Either<List<String>, Expression> givenIds, List<ShowColumn> columns, List<CommandResultItem> yieldColumns) {
        return TerminateTransactionsCommand$.MODULE$.apply(givenIds, columns, yieldColumns);
    }

    public static Function1<Tuple3<Either<List<String>, Expression>, List<ShowColumn>, List<CommandResultItem>>, TerminateTransactionsCommand> tupled() {
        return TerminateTransactionsCommand$.MODULE$.tupled();
    }

    public static Function1<Either<List<String>, Expression>, Function1<List<ShowColumn>, Function1<List<CommandResultItem>, TerminateTransactionsCommand>>> curried() {
        return TerminateTransactionsCommand$.MODULE$.curried();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public Either<List<String>, Expression> givenIds() {
        return this.givenIds;
    }

    public List<ShowColumn> columns() {
        return this.columns;
    }

    public List<CommandResultItem> yieldColumns() {
        return this.yieldColumns;
    }

    @Override
    public ClosingIterator<Map<String, AnyValue>> originalNameRows(QueryState state, CypherRow baseRow) {
        List<String> ids = Command$.MODULE$.extractNames(this.givenIds(), state, baseRow);
        if (ids.isEmpty()) {
            throw new InvalidSemanticsException("Missing transaction id to terminate, the transaction id can be found using `SHOW TRANSACTIONS`.");
        }
        QueryContext ctx = state.query();
        SecurityContext securityContext = ctx.transactionalContext().securityContext();
        String executingUser = securityContext.subject().executingUser();
        String authenticatedUser = securityContext.subject().authenticatedUser();
        String loggingUser = securityContext.impersonating() ? authenticatedUser + ":" + executingUser : executingUser;
        InternalLog log = state.query().logProvider().getLog(this.getClass());
        log.info("User %s trying to terminate transactions: %s.", new Object[]{loggingUser, ids.mkString("[", ", ", "]")});
        DatabaseContextProvider databaseManager = ctx.getDatabaseContextProvider();
        DatabaseIdRepository databaseIdRepository = databaseManager.databaseIdRepository();
        Tuple2 tuple2 = (Tuple2)ids.foldLeft((Object)new Tuple2((Object)Predef$.MODULE$.Map().empty(), (Object)Predef$.MODULE$.Set().empty()), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                String idText = (String)tuple2._2();
                if (tuple22 != null) {
                    Map accMap = (Map)tuple22._1();
                    Set accSet = (Set)tuple22._2();
                    TransactionId id = TransactionId$.MODULE$.parse(idText);
                    Optional namedDatabaseId = databaseIdRepository.getByName(id.database());
                    if (namedDatabaseId.isPresent()) {
                        NamedDatabaseId databaseId = (NamedDatabaseId)namedDatabaseId.get();
                        Set transactions = (Set)accMap.getOrElse((Object)databaseId, (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
                        return new Tuple2((Object)accMap.$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)databaseId), (Object)transactions.$plus((Object)id))}))), (Object)accSet);
                    }
                    return new Tuple2((Object)accMap, (Object)accSet.$plus((Object)id));
                }
            }
            throw new MatchError((Object)tuple2);
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Map transactionsByDatabase = (Map)tuple2._1();
        Set otherTxIds = (Set)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)transactionsByDatabase, (Object)otherTxIds);
        Map transactionsByDatabase2 = (Map)tuple22._1();
        Set otherTxIds2 = (Set)tuple22._2();
        Iterable rows = (Iterable)transactionsByDatabase2.flatMap((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                NamedDatabaseId databaseId = (NamedDatabaseId)tuple2._1();
                Set txIds = (Set)tuple2._2();
                if (databaseId != null) {
                    NamedDatabaseId namedDatabaseId = databaseId;
                    if (txIds != null) {
                        Map map;
                        Set set = txIds;
                        Optional maybeDatabaseContext = databaseManager.getDatabaseContext(namedDatabaseId);
                        String dbName = namedDatabaseId.name();
                        if (maybeDatabaseContext.isPresent()) {
                            DatabaseContext databaseContext = (DatabaseContext)maybeDatabaseContext.get();
                            AdminActionOnResource.DatabaseScope dbScope = new AdminActionOnResource.DatabaseScope(dbName);
                            map = ((IterableOnceOps)((IterableOps)TransactionCommandHelper$.MODULE$.getExecutingTransactions(databaseContext).map((Function1 & Serializable)tx -> {
                                TransactionId txIdRepresentation = TransactionId$.MODULE$.apply(dbName, tx.getTransactionSequenceNumber());
                                return new Tuple2((Object)txIdRepresentation, tx);
                            })).filter((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)TerminateTransactionsCommand.$anonfun$originalNameRows$5(dbScope, securityContext, set, x0$3)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                        } else {
                            map = Predef$.MODULE$.Map().empty();
                        }
                        Map allowedTransactions = map;
                        return (Set)set.map((Function1 & Serializable)txId -> {
                            Option txHandle = allowedTransactions.get(txId);
                            Tuple2 tuple2 = (Tuple2)txHandle.map((Function1 & Serializable)x0$4 -> {
                                KernelTransactionHandle kernelTransactionHandle = x0$4;
                                if (kernelTransactionHandle.isClosing()) {
                                    return new Tuple2((Object)kernelTransactionHandle.subject().executingUser(), (Object)"Unable to terminate closing transactions.");
                                }
                                kernelTransactionHandle.markForTermination((Status)Status.Transaction.Terminated);
                                log.info("User %s terminated transaction %s.", new Object[]{loggingUser, txId.toString()});
                                return new Tuple2((Object)kernelTransactionHandle.subject().executingUser(), (Object)"Transaction terminated.");
                            }).getOrElse((Function0 & Serializable)() -> new Tuple2(null, (Object)"Transaction not found."));
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            String username = (String)tuple2._1();
                            String message = (String)tuple2._2();
                            Tuple2 tuple22 = new Tuple2((Object)username, (Object)message);
                            String username2 = (String)tuple22._1();
                            String message2 = (String)tuple22._2();
                            return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"transactionId"), (Object)Values.stringValue((String)txId.toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"username"), (Object)Values.stringOrNoValue((String)username2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)Values.stringValue((String)message2))}));
                        });
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
        Iterable updatedWithExtraRows = (Iterable)rows.$plus$plus((IterableOnce)otherTxIds2.map((Function1 & Serializable)txId -> (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"transactionId"), (Object)Values.stringValue((String)txId.toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"username"), (Object)Values.NO_VALUE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)Values.stringValue((String)"Transaction not found."))}))));
        List<Map<String, AnyValue>> updatedColumnNameRows = this.updateRowsWithPotentiallyRenamedColumns((List<Map<String, AnyValue>>)updatedWithExtraRows.toList());
        return ClosingIterator$.MODULE$.apply(updatedColumnNameRows.iterator());
    }

    public TerminateTransactionsCommand copy(Either<List<String>, Expression> givenIds, List<ShowColumn> columns, List<CommandResultItem> yieldColumns) {
        return new TerminateTransactionsCommand(givenIds, columns, yieldColumns);
    }

    public Either<List<String>, Expression> copy$default$1() {
        return this.givenIds();
    }

    public List<ShowColumn> copy$default$2() {
        return this.columns();
    }

    public List<CommandResultItem> copy$default$3() {
        return this.yieldColumns();
    }

    public String productPrefix() {
        return "TerminateTransactionsCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.givenIds();
            }
            case 1: {
                return this.columns();
            }
            case 2: {
                return this.yieldColumns();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TerminateTransactionsCommand;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "givenIds";
            }
            case 1: {
                return "columns";
            }
            case 2: {
                return "yieldColumns";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TerminateTransactionsCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        TerminateTransactionsCommand terminateTransactionsCommand = (TerminateTransactionsCommand)x$1;
        Either<List<String>, Expression> either = this.givenIds();
        Either<List<String>, Expression> either2 = terminateTransactionsCommand.givenIds();
        if (either == null) {
            if (either2 != null) {
                return false;
            }
        } else if (!either.equals(either2)) return false;
        List<ShowColumn> list = this.columns();
        List<ShowColumn> list2 = terminateTransactionsCommand.columns();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        List<CommandResultItem> list3 = this.yieldColumns();
        List<CommandResultItem> list4 = terminateTransactionsCommand.yieldColumns();
        if (list3 == null) {
            if (list4 != null) {
                return false;
            }
        } else if (!list3.equals(list4)) return false;
        if (!terminateTransactionsCommand.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$originalNameRows$5(AdminActionOnResource.DatabaseScope dbScope$1, SecurityContext securityContext$1, Set x3$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            AdminActionOnResource action;
            TransactionId txIdRepresentation = (TransactionId)tuple2._1();
            KernelTransactionHandle tx = (KernelTransactionHandle)tuple2._2();
            String username = tx.subject().executingUser();
            return TransactionCommandHelper$.MODULE$.isSelfOrAllows(username, action = new AdminActionOnResource(PrivilegeAction.TERMINATE_TRANSACTION, dbScope$1, (Segment)new UserSegment(username)), securityContext$1) && x3$1.contains((Object)txIdRepresentation);
        }
        throw new MatchError((Object)tuple2);
    }

    public TerminateTransactionsCommand(Either<List<String>, Expression> givenIds, List<ShowColumn> columns, List<CommandResultItem> yieldColumns) {
        this.givenIds = givenIds;
        this.columns = columns;
        this.yieldColumns = yieldColumns;
        super(columns, yieldColumns);
        Product.$init$((Product)this);
    }
}

