/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands;

import java.io.Serializable;
import java.time.Duration;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAmount;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.cypher.internal.ast.CommandResultItem;
import org.neo4j.cypher.internal.ast.ShowColumn;
import org.neo4j.cypher.internal.runtime.ClosingIterator;
import org.neo4j.cypher.internal.runtime.ClosingIterator$;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.Command;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.Command$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.QueryId;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.ShowTransactionsCommand$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.TransactionCommandHelper$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.TransactionId$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.internal.kernel.api.helpers.TransactionDependenciesResolver;
import org.neo4j.internal.kernel.api.security.AdminActionOnResource;
import org.neo4j.internal.kernel.api.security.PrivilegeAction;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.kernel.api.security.Segment;
import org.neo4j.internal.kernel.api.security.UserSegment;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.query.QuerySnapshot;
import org.neo4j.kernel.impl.api.TransactionExecutionStatistic;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple15;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\tEd\u0001\u0002\u0013&\u0001ZB\u0001\"\u0014\u0001\u0003\u0016\u0004%\tA\u0014\u0005\tG\u0002\u0011\t\u0012)A\u0005\u001f\"AA\r\u0001BK\u0002\u0013\u0005Q\r\u0003\u0005j\u0001\tE\t\u0015!\u0003g\u0011!Q\u0007A!f\u0001\n\u0003Y\u0007\u0002C:\u0001\u0005#\u0005\u000b\u0011\u00027\t\u0011Q\u0004!Q3A\u0005\u0002UD\u0001B\u001f\u0001\u0003\u0012\u0003\u0006IA\u001e\u0005\u0006w\u0002!\t\u0001 \u0005\b\u0003\u000b\u0001A\u0011IA\u0004\u0011\u001d\ti\u0004\u0001C\u0005\u0003\u007fAq!!\u001b\u0001\t\u0013\tY\u0007C\u0004\u0002\u001e\u0002!I!a(\t\u000f\u0005\u001d\u0006\u0001\"\u0003\u0002*\"I\u0011q\u0016\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0017\u0005\n\u0003w\u0003\u0011\u0013!C\u0001\u0003{C\u0011\"a5\u0001#\u0003%\t!!6\t\u0013\u0005e\u0007!%A\u0005\u0002\u0005m\u0007\"CAp\u0001E\u0005I\u0011AAq\u0011%\t)\u000fAA\u0001\n\u0003\n9\u000fC\u0005\u0002j\u0002\t\t\u0011\"\u0001\u0002l\"I\u00111\u001f\u0001\u0002\u0002\u0013\u0005\u0011Q\u001f\u0005\n\u0005\u0003\u0001\u0011\u0011!C!\u0005\u0007A\u0011B!\u0005\u0001\u0003\u0003%\tAa\u0005\t\u0013\t]\u0001!!A\u0005B\te\u0001\"\u0003B\u000f\u0001\u0005\u0005I\u0011\tB\u0010\u0011%\u0011\t\u0003AA\u0001\n\u0003\u0012\u0019\u0003C\u0005\u0003&\u0001\t\t\u0011\"\u0011\u0003(\u001dI!1F\u0013\u0002\u0002#\u0005!Q\u0006\u0004\tI\u0015\n\t\u0011#\u0001\u00030!11P\bC\u0001\u0005\u000bB\u0011B!\t\u001f\u0003\u0003%)Ea\t\t\u0013\t\u001dc$!A\u0005\u0002\n%\u0003\"\u0003B*=\u0005\u0005I\u0011\u0011B+\u0011%\u00119GHA\u0001\n\u0013\u0011IGA\fTQ><HK]1og\u0006\u001cG/[8og\u000e{W.\\1oI*\u0011aeJ\u0001\rg\"|woY8n[\u0006tGm\u001d\u0006\u0003Q%\n\u0001bY8n[\u0006tGm\u001d\u0006\u0003U-\n1\"\u001b8uKJ\u0004(/\u001a;fI*\u0011A&L\u0001\beVtG/[7f\u0015\tqs&\u0001\u0005j]R,'O\\1m\u0015\t\u0001\u0014'\u0001\u0004dsBDWM\u001d\u0006\u0003eM\nQA\\3pi)T\u0011\u0001N\u0001\u0004_J<7\u0001A\n\u0005\u0001]Z\u0014\t\u0005\u00029s5\tQ%\u0003\u0002;K\t91i\\7nC:$\u0007C\u0001\u001f@\u001b\u0005i$\"\u0001 \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001k$a\u0002)s_\u0012,8\r\u001e\t\u0003\u0005*s!a\u0011%\u000f\u0005\u0011;U\"A#\u000b\u0005\u0019+\u0014A\u0002\u001fs_>$h(C\u0001?\u0013\tIU(A\u0004qC\u000e\\\u0017mZ3\n\u0005-c%\u0001D*fe&\fG.\u001b>bE2,'BA%>\u0003!9\u0017N^3o\u0013\u0012\u001cX#A(\u0011\t\t\u0003&+X\u0005\u0003#2\u0013a!R5uQ\u0016\u0014\bc\u0001\"T+&\u0011A\u000b\u0014\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002W5:\u0011q\u000b\u0017\t\u0003\tvJ!!W\u001f\u0002\rA\u0013X\rZ3g\u0013\tYFL\u0001\u0004TiJLgn\u001a\u0006\u00033v\u0002\"AX1\u000e\u0003}S!\u0001Y\u0014\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0003E~\u0013!\"\u0012=qe\u0016\u001c8/[8o\u0003%9\u0017N^3o\u0013\u0012\u001c\b%A\u0004wKJ\u0014wn]3\u0016\u0003\u0019\u0004\"\u0001P4\n\u0005!l$a\u0002\"p_2,\u0017M\\\u0001\tm\u0016\u0014(m\\:fA\u0005qA-\u001a4bk2$8i\u001c7v[:\u001cX#\u00017\u0011\u0007\t\u001bV\u000e\u0005\u0002oc6\tqN\u0003\u0002q[\u0005\u0019\u0011m\u001d;\n\u0005I|'AC*i_^\u001cu\u000e\\;n]\u0006yA-\u001a4bk2$8i\u001c7v[:\u001c\b%\u0001\u0007zS\u0016dGmQ8mk6t7/F\u0001w!\r\u00115k\u001e\t\u0003]bL!!_8\u0003#\r{W.\\1oIJ+7/\u001e7u\u0013R,W.A\u0007zS\u0016dGmQ8mk6t7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000futx0!\u0001\u0002\u0004A\u0011\u0001\b\u0001\u0005\u0006\u001b&\u0001\ra\u0014\u0005\u0006I&\u0001\rA\u001a\u0005\u0006U&\u0001\r\u0001\u001c\u0005\u0006i&\u0001\rA^\u0001\u0011_JLw-\u001b8bY:\u000bW.\u001a*poN$b!!\u0003\u0002$\u0005M\u0002CBA\u0006\u0003\u001b\t\t\"D\u0001,\u0013\r\tya\u000b\u0002\u0010\u00072|7/\u001b8h\u0013R,'/\u0019;peB1a+a\u0005V\u0003/I1!!\u0006]\u0005\ri\u0015\r\u001d\t\u0005\u00033\ty\"\u0004\u0002\u0002\u001c)\u0019\u0011QD\u0019\u0002\rY\fG.^3t\u0013\u0011\t\t#a\u0007\u0003\u0011\u0005s\u0017PV1mk\u0016Dq!!\n\u000b\u0001\u0004\t9#A\u0003ti\u0006$X\r\u0005\u0003\u0002*\u0005=RBAA\u0016\u0015\r\ti#K\u0001\u0006a&\u0004Xm]\u0005\u0005\u0003c\tYC\u0001\u0006Rk\u0016\u0014\u0018p\u0015;bi\u0016Dq!!\u000e\u000b\u0001\u0004\t9$A\u0004cCN,'k\\<\u0011\t\u0005-\u0011\u0011H\u0005\u0004\u0003wY#!C\"za\",'OU8x\u0003A1wN]7biRKW.Z*ue&tw\r\u0006\u0004\u0002B\u0005=\u0013\u0011\f\t\u0005\u0003\u0007\ni%\u0004\u0002\u0002F)!\u0011qIA%\u0003\u0011a\u0017M\\4\u000b\u0005\u0005-\u0013\u0001\u00026bm\u0006L1aWA#\u0011\u001d\t\tf\u0003a\u0001\u0003'\n\u0011b\u001d;beR$\u0016.\\3\u0011\u0007q\n)&C\u0002\u0002Xu\u0012A\u0001T8oO\"9\u00111L\u0006A\u0002\u0005u\u0013A\u0002>p]\u0016LE\r\u0005\u0003\u0002`\u0005\u0015TBAA1\u0015\u0011\t\u0019'!\u0013\u0002\tQLW.Z\u0005\u0005\u0003O\n\tG\u0001\u0004[_:,\u0017\nZ\u0001\nO\u0016$8\u000b^1ukN$b!!\u001c\u0002t\u0005\u001d\u0005#\u0002\u001f\u0002pU+\u0016bAA9{\t1A+\u001e9mKJBq!!\u001e\r\u0001\u0004\t9(\u0001\u0004iC:$G.\u001a\t\u0005\u0003s\n\u0019)\u0004\u0002\u0002|)!\u0011QPA@\u0003\r\t\u0007/\u001b\u0006\u0004\u0003\u0003\u000b\u0014AB6fe:,G.\u0003\u0003\u0002\u0006\u0006m$aF&fe:,G\u000e\u0016:b]N\f7\r^5p]\"\u000bg\u000e\u001a7f\u0011\u001d\tI\t\u0004a\u0001\u0003\u0017\u000bq\u0004\u001e:b]N\f7\r^5p]\u0012+\u0007/\u001a8eK:\u001c\u0017.Z:SKN|GN^3s!\u0011\ti)!'\u000e\u0005\u0005=%\u0002BAI\u0003'\u000bq\u0001[3ma\u0016\u00148O\u0003\u0003\u0002~\u0005U%\u0002BAA\u0003/S!AL\u0019\n\t\u0005m\u0015q\u0012\u0002 )J\fgn]1di&|g\u000eR3qK:$WM\\2jKN\u0014Vm]8mm\u0016\u0014\u0018\u0001\u0006:fg>dg/Z*uCR,8\u000fR3uC&d7\u000fF\u0003V\u0003C\u000b\u0019\u000bC\u0004\u0002v5\u0001\r!a\u001e\t\r\u0005\u0015V\u00021\u0001V\u00039!WMZ1vYR$U\r^1jYN\f!cZ3u\u000bb,7-\u001e;j]\u001e\u001cF/\u0019;vgR1\u0011QNAV\u0003[Cq!!\u001e\u000f\u0001\u0004\t9\bC\u0004\u0002\n:\u0001\r!a#\u0002\t\r|\u0007/\u001f\u000b\n{\u0006M\u0016QWA\\\u0003sCq!T\b\u0011\u0002\u0003\u0007q\nC\u0004e\u001fA\u0005\t\u0019\u00014\t\u000f)|\u0001\u0013!a\u0001Y\"9Ao\u0004I\u0001\u0002\u00041\u0018AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u007fS3aTAaW\t\t\u0019\r\u0005\u0003\u0002F\u0006=WBAAd\u0015\u0011\tI-a3\u0002\u0013Ut7\r[3dW\u0016$'bAAg{\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005E\u0017q\u0019\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003/T3AZAa\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!!8+\u00071\f\t-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005\r(f\u0001<\u0002B\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u0011\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u00055\bc\u0001\u001f\u0002p&\u0019\u0011\u0011_\u001f\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005]\u0018Q \t\u0004y\u0005e\u0018bAA~{\t\u0019\u0011I\\=\t\u0013\u0005}h#!AA\u0002\u00055\u0018a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\u0006A1!q\u0001B\u0007\u0003ol!A!\u0003\u000b\u0007\t-Q(\u0001\u0006d_2dWm\u0019;j_:LAAa\u0004\u0003\n\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r1'Q\u0003\u0005\n\u0003\u007fD\u0012\u0011!a\u0001\u0003o\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011\u0011\tB\u000e\u0011%\ty0GA\u0001\u0002\u0004\ti/\u0001\u0005iCND7i\u001c3f)\t\ti/\u0001\u0005u_N#(/\u001b8h)\t\t\t%\u0001\u0004fcV\fGn\u001d\u000b\u0004M\n%\u0002\"CA\u00009\u0005\u0005\t\u0019AA|\u0003]\u0019\u0006n\\<Ue\u0006t7/Y2uS>t7oQ8n[\u0006tG\r\u0005\u00029=M)aD!\r\u0003<AI!1\u0007B\u001c\u001f\u001adg/`\u0007\u0003\u0005kQ!\u0001L\u001f\n\t\te\"Q\u0007\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$\u0004\u0003\u0002B\u001f\u0005\u0007j!Aa\u0010\u000b\t\t\u0005\u0013\u0011J\u0001\u0003S>L1a\u0013B )\t\u0011i#A\u0003baBd\u0017\u0010F\u0005~\u0005\u0017\u0012iEa\u0014\u0003R!)Q*\ta\u0001\u001f\")A-\ta\u0001M\")!.\ta\u0001Y\")A/\ta\u0001m\u00069QO\\1qa2LH\u0003\u0002B,\u0005G\u0002R\u0001\u0010B-\u0005;J1Aa\u0017>\u0005\u0019y\u0005\u000f^5p]B9AHa\u0018PM24\u0018b\u0001B1{\t1A+\u001e9mKRB\u0001B!\u001a#\u0003\u0003\u0005\r!`\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B6!\u0011\t\u0019E!\u001c\n\t\t=\u0014Q\t\u0002\u0007\u001f\nTWm\u0019;")
public class ShowTransactionsCommand
extends Command
implements Product,
Serializable {
    private final Either<List<String>, Expression> givenIds;
    private final boolean verbose;
    private final List<ShowColumn> defaultColumns;
    private final List<CommandResultItem> yieldColumns;

    public static Option<Tuple4<Either<List<String>, Expression>, Object, List<ShowColumn>, List<CommandResultItem>>> unapply(ShowTransactionsCommand x$0) {
        return ShowTransactionsCommand$.MODULE$.unapply(x$0);
    }

    public static ShowTransactionsCommand apply(Either<List<String>, Expression> givenIds, boolean verbose, List<ShowColumn> defaultColumns, List<CommandResultItem> yieldColumns) {
        return ShowTransactionsCommand$.MODULE$.apply(givenIds, verbose, defaultColumns, yieldColumns);
    }

    public static Function1<Tuple4<Either<List<String>, Expression>, Object, List<ShowColumn>, List<CommandResultItem>>, ShowTransactionsCommand> tupled() {
        return ShowTransactionsCommand$.MODULE$.tupled();
    }

    public static Function1<Either<List<String>, Expression>, Function1<Object, Function1<List<ShowColumn>, Function1<List<CommandResultItem>, ShowTransactionsCommand>>>> curried() {
        return ShowTransactionsCommand$.MODULE$.curried();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public Either<List<String>, Expression> givenIds() {
        return this.givenIds;
    }

    public boolean verbose() {
        return this.verbose;
    }

    public List<ShowColumn> defaultColumns() {
        return this.defaultColumns;
    }

    public List<CommandResultItem> yieldColumns() {
        return this.yieldColumns;
    }

    @Override
    public ClosingIterator<scala.collection.immutable.Map<String, AnyValue>> originalNameRows(QueryState state, CypherRow baseRow) {
        List<String> ids = Command$.MODULE$.extractNames(this.givenIds(), state, baseRow);
        QueryContext ctx = state.query();
        SecurityContext securityContext = ctx.transactionalContext().securityContext();
        List allowedTransactions = CollectionConverters$.MODULE$.CollectionHasAsScala(ctx.getDatabaseContextProvider().registeredDatabases().values()).asScala().toList().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ShowTransactionsCommand.$anonfun$originalNameRows$1(x$1))).flatMap((Function1 & Serializable)databaseContext -> {
            String dbName = databaseContext.databaseFacade().databaseName();
            AdminActionOnResource.DatabaseScope dbScope = new AdminActionOnResource.DatabaseScope(databaseContext.database().getNamedDatabaseId().name());
            Set<KernelTransactionHandle> allTransactions = TransactionCommandHelper$.MODULE$.getExecutingTransactions((DatabaseContext)databaseContext);
            return (Set)((IterableOps)allTransactions.filter((Function1 & Serializable)tx -> BoxesRunTime.boxToBoolean((boolean)ShowTransactionsCommand.$anonfun$originalNameRows$3(dbScope, securityContext, tx)))).map((Function1 & Serializable)tx -> {
                Optional<QuerySnapshot> querySnapshot = tx.executingQuery().map(x$2 -> x$2.snapshot());
                return new Tuple3(tx, querySnapshot, (Object)dbName);
            });
        });
        List askedForTransactions = ids.nonEmpty() ? allowedTransactions.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ShowTransactionsCommand.$anonfun$originalNameRows$6(ids, x0$1))) : allowedTransactions;
        HashMap handleQuerySnapshotsMap = new HashMap();
        askedForTransactions.foreach((Function1 & Serializable)x0$2 -> {
            Tuple3 tuple3 = x0$2;
            if (tuple3 != null) {
                KernelTransactionHandle transaction = (KernelTransactionHandle)tuple3._1();
                Optional querySnapshot = (Optional)tuple3._2();
                if (transaction != null) {
                    KernelTransactionHandle kernelTransactionHandle = transaction;
                    if (querySnapshot != null) {
                        Optional optional = querySnapshot;
                        return handleQuerySnapshotsMap.put(kernelTransactionHandle, optional);
                    }
                }
            }
            throw new MatchError((Object)tuple3);
        });
        TransactionDependenciesResolver transactionDependenciesResolver = new TransactionDependenciesResolver(handleQuerySnapshotsMap);
        ZoneId zoneId = this.getConfiguredTimeZone(ctx);
        List rows = askedForTransactions.map((Function1 & Serializable)x0$3 -> {
            Tuple3 tuple3 = x0$3;
            if (tuple3 != null) {
                KernelTransactionHandle transaction = (KernelTransactionHandle)tuple3._1();
                Optional querySnapshot = (Optional)tuple3._2();
                String dbName = (String)tuple3._3();
                if (transaction != null) {
                    KernelTransactionHandle kernelTransactionHandle = transaction;
                    if (querySnapshot != null) {
                        Optional optional = querySnapshot;
                        if (dbName != null) {
                            Tuple2 tuple2;
                            String string = dbName;
                            TransactionExecutionStatistic statistic = kernelTransactionHandle.transactionStatistic();
                            Optional clientInfo = kernelTransactionHandle.clientInfo();
                            String txId = TransactionId$.MODULE$.apply(string, kernelTransactionHandle.getTransactionSequenceNumber()).toString();
                            String username = kernelTransactionHandle.subject().executingUser();
                            String startTime = this.formatTimeString(kernelTransactionHandle.startTime(), zoneId);
                            Value elapsedTime = ShowTransactionsCommand.getDurationOrNullFromMillis$1(Predef$.MODULE$.long2Long(statistic.getElapsedTimeMillis()));
                            if (optional.isPresent()) {
                                QuerySnapshot snapshot = (QuerySnapshot)optional.get();
                                String currentQueryId = new QueryId(snapshot.internalQueryId()).toString();
                                String currentQuery = snapshot.obfuscatedQueryText().orElse("");
                                v0 = new Tuple2((Object)currentQueryId, (Object)currentQuery);
                            } else {
                                v0 = tuple2 = new Tuple2((Object)"", (Object)"");
                            }
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            String currentQueryId = (String)tuple2._1();
                            String currentQuery = (String)tuple2._2();
                            Tuple2 tuple22 = new Tuple2((Object)currentQueryId, (Object)currentQuery);
                            String currentQueryId2 = (String)tuple22._1();
                            String currentQuery2 = (String)tuple22._2();
                            String connectionId = clientInfo.map(x$4 -> x$4.connectionId()).orElse("");
                            String clientAddress = clientInfo.map(x$5 -> x$5.clientAddress()).orElse("");
                            Tuple2<String, String> tuple23 = this.getStatus(kernelTransactionHandle, transactionDependenciesResolver);
                            if (tuple23 == null) {
                                throw new MatchError(tuple23);
                            }
                            String status = (String)tuple23._1();
                            String statusDetails = (String)tuple23._2();
                            Tuple2 tuple24 = new Tuple2((Object)status, (Object)statusDetails);
                            String status2 = (String)tuple24._1();
                            String statusDetails2 = (String)tuple24._2();
                            scala.collection.immutable.Map briefResult = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"database"), (Object)Values.stringValue((String)string)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"transactionId"), (Object)Values.stringValue((String)txId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentQueryId"), (Object)Values.stringValue((String)currentQueryId2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"connectionId"), (Object)Values.stringValue((String)connectionId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clientAddress"), (Object)Values.stringValue((String)clientAddress)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"username"), (Object)Values.stringValue((String)username)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentQuery"), (Object)Values.stringValue((String)currentQuery2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"startTime"), (Object)Values.stringValue((String)startTime)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"status"), (Object)Values.stringValue((String)status2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"elapsedTime"), (Object)elapsedTime)}));
                            if (this.verbose()) {
                                Tuple15 tuple15;
                                if (optional.isPresent()) {
                                    String querySessionTransaction;
                                    QuerySnapshot query = (QuerySnapshot)optional.get();
                                    String parentDbName = query.parentDbName();
                                    long parentTransactionId = query.parentTransactionId();
                                    String querySessionDbName = parentDbName != null ? parentDbName : string;
                                    long querySessionTransactionId = parentTransactionId > -1L ? parentTransactionId : query.transactionId();
                                    String string2 = querySessionTransaction = TransactionId$.MODULE$.apply(querySessionDbName, querySessionTransactionId).toString();
                                    String string3 = txId;
                                    String outerTransactionId = !(string2 != null ? !string2.equals(string3) : string3 != null) ? "" : querySessionTransaction;
                                    MapValue parameters = query.obfuscatedQueryParameters().orElse(MapValue.EMPTY);
                                    String maybePlanner = query.planner();
                                    String planner = maybePlanner == null ? "" : maybePlanner;
                                    String maybeRuntime = query.runtime();
                                    String runtime = maybeRuntime == null ? "" : maybeRuntime;
                                    ListValue indexes = VirtualValues.list((AnyValue[])((AnyValue[])CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)query.indexes()).asScala().toList().map((Function1 & Serializable)m -> {
                                        scala.collection.mutable.Map scalaMap = CollectionConverters$.MODULE$.MapHasAsScala(m).asScala();
                                        String[] keys = (String[])scalaMap.keys().toArray(ClassTag$.MODULE$.apply(String.class));
                                        AnyValue[] vals = (AnyValue[])((IterableOnceOps)scalaMap.values().map((Function1 & Serializable)x$1 -> Values.stringValue((String)x$1))).toArray(ClassTag$.MODULE$.apply(AnyValue.class));
                                        return VirtualValues.map((String[])keys, (AnyValue[])vals);
                                    }).toArray(ClassTag$.MODULE$.apply(MapValue.class))));
                                    String queryStartTime = this.formatTimeString(query.startTimestampMillis(), zoneId);
                                    String queryStatus = query.status();
                                    LongValue queryActiveLockCount = Values.longValue((long)query.activeLockCount());
                                    Value queryElapsedTime = ShowTransactionsCommand.getDurationOrNullFromMicro$1(Predef$.MODULE$.long2Long(query.elapsedTimeMicros()));
                                    OptionalLong optionalCpuTime = query.cpuTimeMicros();
                                    Value queryCpuTime = optionalCpuTime.isPresent() ? ShowTransactionsCommand.getDurationOrNullFromMicro$1(Predef$.MODULE$.long2Long(optionalCpuTime.getAsLong())) : Values.NO_VALUE;
                                    DurationValue queryWaitTime = Values.durationValue((TemporalAmount)Duration.ofMillis(TimeUnit.MICROSECONDS.toMillis(query.waitTimeMicros())));
                                    OptionalLong optionalIdleTime = query.idleTimeMicros();
                                    Value queryIdleTime = optionalIdleTime.isPresent() ? ShowTransactionsCommand.getDurationOrNullFromMicro$1(Predef$.MODULE$.long2Long(optionalIdleTime.getAsLong())) : Values.NO_VALUE;
                                    long queryBytes = query.allocatedBytes();
                                    Value queryAllocatedBytes = queryBytes == -1L ? Values.NO_VALUE : ShowTransactionsCommand.getLongOrNull$1(Predef$.MODULE$.long2Long(queryBytes));
                                    LongValue queryPageHits = Values.longValue((long)query.pageHits());
                                    LongValue queryPageFaults = Values.longValue((long)query.pageFaults());
                                    v2 = new Tuple15((Object)outerTransactionId, (Object)parameters, (Object)planner, (Object)runtime, (Object)indexes, (Object)queryStartTime, (Object)queryStatus, (Object)queryActiveLockCount, (Object)queryElapsedTime, (Object)queryCpuTime, (Object)queryWaitTime, (Object)queryIdleTime, (Object)queryAllocatedBytes, (Object)queryPageHits, (Object)queryPageFaults);
                                } else {
                                    v2 = tuple15 = new Tuple15((Object)"", (Object)MapValue.EMPTY, (Object)"", (Object)"", (Object)VirtualValues.EMPTY_LIST, (Object)"", (Object)"", (Object)Values.NO_VALUE, (Object)Values.NO_VALUE, (Object)Values.NO_VALUE, (Object)Values.NO_VALUE, (Object)Values.NO_VALUE, (Object)Values.NO_VALUE, (Object)Values.NO_VALUE, (Object)Values.NO_VALUE);
                                }
                                if (tuple15 == null) {
                                    throw new MatchError((Object)tuple15);
                                }
                                String outerTransactionId = (String)tuple15._1();
                                MapValue parameters = (MapValue)tuple15._2();
                                String planner = (String)tuple15._3();
                                String runtime = (String)tuple15._4();
                                ListValue indexes = (ListValue)tuple15._5();
                                String queryStartTime = (String)tuple15._6();
                                String queryStatus = (String)tuple15._7();
                                Value queryActiveLockCount = (Value)tuple15._8();
                                Value queryElapsedTime = (Value)tuple15._9();
                                Value queryCpuTime = (Value)tuple15._10();
                                Value queryWaitTime = (Value)tuple15._11();
                                Value queryIdleTime = (Value)tuple15._12();
                                Value queryAllocatedBytes = (Value)tuple15._13();
                                Value queryPageHits = (Value)tuple15._14();
                                Value queryPageFaults = (Value)tuple15._15();
                                Tuple15 tuple152 = new Tuple15((Object)outerTransactionId, (Object)parameters, (Object)planner, (Object)runtime, (Object)indexes, (Object)queryStartTime, (Object)queryStatus, (Object)queryActiveLockCount, (Object)queryElapsedTime, (Object)queryCpuTime, (Object)queryWaitTime, (Object)queryIdleTime, (Object)queryAllocatedBytes, (Object)queryPageHits, (Object)queryPageFaults);
                                String outerTransactionId2 = (String)tuple152._1();
                                MapValue parameters2 = (MapValue)tuple152._2();
                                String planner2 = (String)tuple152._3();
                                String runtime2 = (String)tuple152._4();
                                ListValue indexes2 = (ListValue)tuple152._5();
                                String queryStartTime2 = (String)tuple152._6();
                                String queryStatus2 = (String)tuple152._7();
                                Value queryActiveLockCount2 = (Value)tuple152._8();
                                Value queryElapsedTime2 = (Value)tuple152._9();
                                Value queryCpuTime2 = (Value)tuple152._10();
                                Value queryWaitTime2 = (Value)tuple152._11();
                                Value queryIdleTime2 = (Value)tuple152._12();
                                Value queryAllocatedBytes2 = (Value)tuple152._13();
                                Value queryPageHits2 = (Value)tuple152._14();
                                Value queryPageFaults2 = (Value)tuple152._15();
                                MapValue metaData = ShowTransactionsCommand.getMapValue$1(kernelTransactionHandle.getMetaData());
                                String protocol = clientInfo.map(x$8 -> x$8.protocol()).orElse("");
                                String requestUri = clientInfo.map(x$9 -> x$9.requestURI()).orElse(null);
                                MapValue resourceInformation = ShowTransactionsCommand.getMapValue$1(optional.map(x$10 -> x$10.resourceInformation()).orElse(Collections.emptyMap()));
                                int activeLockCount = kernelTransactionHandle.activeLocks().size();
                                Value cpuTime = ShowTransactionsCommand.getDurationOrNullFromMillis$1(statistic.getCpuTimeMillis());
                                DurationValue waitTime = Values.durationValue((TemporalAmount)Duration.ofMillis(statistic.getWaitTimeMillis()));
                                Value idleTime = ShowTransactionsCommand.getDurationOrNullFromMillis$1(statistic.getIdleTimeMillis());
                                Value allocatedDirectBytes = ShowTransactionsCommand.getLongOrNull$1(statistic.getNativeAllocatedBytes());
                                Value estimatedUsedHeapMemory = ShowTransactionsCommand.getLongOrNull$1(statistic.getEstimatedUsedHeapMemory());
                                long pageHits = statistic.getPageHits();
                                long pageFaults = statistic.getPageFaults();
                                String initializationStackTrace = kernelTransactionHandle.transactionInitialisationTrace().getTrace();
                                return (scala.collection.immutable.Map)briefResult.$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"outerTransactionId"), (Object)Values.stringValue((String)outerTransactionId2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metaData"), (Object)metaData), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parameters"), (Object)parameters2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"planner"), (Object)Values.stringValue((String)planner2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"runtime"), (Object)Values.stringValue((String)runtime2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"indexes"), (Object)indexes2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentQueryStartTime"), (Object)Values.stringValue((String)queryStartTime2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"protocol"), (Object)Values.stringValue((String)protocol)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requestUri"), (Object)Values.stringOrNoValue((String)requestUri)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentQueryStatus"), (Object)Values.stringValue((String)queryStatus2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"statusDetails"), (Object)Values.stringValue((String)statusDetails2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"resourceInformation"), (Object)resourceInformation), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"activeLockCount"), (Object)Values.longValue((long)activeLockCount)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentQueryActiveLockCount"), (Object)queryActiveLockCount2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cpuTime"), (Object)cpuTime), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"waitTime"), (Object)waitTime), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"idleTime"), (Object)idleTime), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentQueryElapsedTime"), (Object)queryElapsedTime2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentQueryCpuTime"), (Object)queryCpuTime2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentQueryWaitTime"), (Object)queryWaitTime2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentQueryIdleTime"), (Object)queryIdleTime2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentQueryAllocatedBytes"), (Object)queryAllocatedBytes2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"allocatedDirectBytes"), (Object)allocatedDirectBytes), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"estimatedUsedHeapMemory"), (Object)estimatedUsedHeapMemory), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pageHits"), (Object)Values.longValue((long)pageHits)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pageFaults"), (Object)Values.longValue((long)pageFaults)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentQueryPageHits"), (Object)queryPageHits2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentQueryPageFaults"), (Object)queryPageFaults2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"initializationStackTrace"), (Object)Values.stringValue((String)initializationStackTrace))})));
                            }
                            return briefResult;
                        }
                    }
                }
            }
            throw new MatchError((Object)tuple3);
        });
        List<scala.collection.immutable.Map<String, AnyValue>> updatedRows = this.updateRowsWithPotentiallyRenamedColumns((List<scala.collection.immutable.Map<String, AnyValue>>)rows);
        return ClosingIterator$.MODULE$.apply(updatedRows.iterator());
    }

    private String formatTimeString(long startTime, ZoneId zoneId) {
        return this.formatTime(startTime, zoneId).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    private Tuple2<String, String> getStatus(KernelTransactionHandle handle, TransactionDependenciesResolver transactionDependenciesResolver) {
        return handle.terminationMark().map(info -> new Tuple2((Object)String.format(TransactionId$.MODULE$.TERMINATED_STATE(), info.getReason().code()), (Object)handle.getStatusDetails())).orElseGet(() -> this.getExecutingStatus(handle, transactionDependenciesResolver));
    }

    private String resolveStatusDetails(KernelTransactionHandle handle, String defaultDetails) {
        String handleDetails;
        block0: {
            handleDetails = handle.getStatusDetails();
            if (!StringUtils.isEmpty((CharSequence)handleDetails)) break block0;
            handleDetails = defaultDetails;
        }
        return handleDetails;
    }

    private Tuple2<String, String> getExecutingStatus(KernelTransactionHandle handle, TransactionDependenciesResolver transactionDependenciesResolver) {
        if (transactionDependenciesResolver.isBlocked(handle)) {
            return new Tuple2((Object)(TransactionId$.MODULE$.BLOCKED_STATE() + transactionDependenciesResolver.describeBlockingTransactions(handle)), (Object)handle.getStatusDetails());
        }
        if (handle.isCommitting()) {
            return new Tuple2((Object)TransactionId$.MODULE$.CLOSING_STATE(), (Object)this.resolveStatusDetails(handle, TransactionId$.MODULE$.COMMITTING_STATE()));
        }
        if (handle.isRollingback()) {
            return new Tuple2((Object)TransactionId$.MODULE$.CLOSING_STATE(), (Object)this.resolveStatusDetails(handle, TransactionId$.MODULE$.ROLLING_BACK_STATE()));
        }
        return new Tuple2((Object)TransactionId$.MODULE$.RUNNING_STATE(), (Object)handle.getStatusDetails());
    }

    public ShowTransactionsCommand copy(Either<List<String>, Expression> givenIds, boolean verbose, List<ShowColumn> defaultColumns, List<CommandResultItem> yieldColumns) {
        return new ShowTransactionsCommand(givenIds, verbose, defaultColumns, yieldColumns);
    }

    public Either<List<String>, Expression> copy$default$1() {
        return this.givenIds();
    }

    public boolean copy$default$2() {
        return this.verbose();
    }

    public List<ShowColumn> copy$default$3() {
        return this.defaultColumns();
    }

    public List<CommandResultItem> copy$default$4() {
        return this.yieldColumns();
    }

    public String productPrefix() {
        return "ShowTransactionsCommand";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.givenIds();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean((boolean)this.verbose());
            }
            case 2: {
                return this.defaultColumns();
            }
            case 3: {
                return this.yieldColumns();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ShowTransactionsCommand;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "givenIds";
            }
            case 1: {
                return "verbose";
            }
            case 2: {
                return "defaultColumns";
            }
            case 3: {
                return "yieldColumns";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.givenIds()));
        n = Statics.mix((int)n, (int)(this.verbose() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.defaultColumns()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.yieldColumns()));
        return Statics.finalizeHash((int)n, (int)4);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ShowTransactionsCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        ShowTransactionsCommand showTransactionsCommand = (ShowTransactionsCommand)x$1;
        if (this.verbose() != showTransactionsCommand.verbose()) return false;
        Either<List<String>, Expression> either = this.givenIds();
        Either<List<String>, Expression> either2 = showTransactionsCommand.givenIds();
        if (either == null) {
            if (either2 != null) {
                return false;
            }
        } else if (!either.equals(either2)) return false;
        List<ShowColumn> list = this.defaultColumns();
        List<ShowColumn> list2 = showTransactionsCommand.defaultColumns();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        List<CommandResultItem> list3 = this.yieldColumns();
        List<CommandResultItem> list4 = showTransactionsCommand.yieldColumns();
        if (list3 == null) {
            if (list4 != null) {
                return false;
            }
        } else if (!list3.equals(list4)) return false;
        if (!showTransactionsCommand.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$originalNameRows$1(DatabaseContext x$1) {
        return x$1.database().isStarted();
    }

    public static final /* synthetic */ boolean $anonfun$originalNameRows$3(AdminActionOnResource.DatabaseScope dbScope$1, SecurityContext securityContext$1, KernelTransactionHandle tx) {
        String username = tx.subject().executingUser();
        AdminActionOnResource action = new AdminActionOnResource(PrivilegeAction.SHOW_TRANSACTION, dbScope$1, (Segment)new UserSegment(username));
        return TransactionCommandHelper$.MODULE$.isSelfOrAllows(username, action, securityContext$1);
    }

    public static final /* synthetic */ boolean $anonfun$originalNameRows$6(List ids$1, Tuple3 x0$1) {
        Tuple3 tuple3 = x0$1;
        if (tuple3 != null) {
            KernelTransactionHandle transaction = (KernelTransactionHandle)tuple3._1();
            String dbName = (String)tuple3._3();
            if (transaction != null) {
                KernelTransactionHandle kernelTransactionHandle = transaction;
                if (dbName != null) {
                    String string = dbName;
                    String txId = TransactionId$.MODULE$.apply(string, kernelTransactionHandle.getTransactionSequenceNumber()).toString();
                    return ids$1.contains((Object)txId);
                }
            }
        }
        throw new MatchError((Object)tuple3);
    }

    private static final Value getLongOrNull$1(Long l) {
        Long l2 = l;
        if (l2 != null) {
            Long l3 = l2;
            return Values.longValue((long)Predef$.MODULE$.Long2long(l3));
        }
        return Values.NO_VALUE;
    }

    private static final Value getDurationOrNullFromMillis$1(Long l) {
        Long l2 = l;
        if (l2 != null) {
            Long l3 = l2;
            return Values.durationValue((TemporalAmount)Duration.ofMillis(Predef$.MODULE$.Long2long(l3)));
        }
        return Values.NO_VALUE;
    }

    private static final Value getDurationOrNullFromMicro$1(Long l) {
        Long l2 = l;
        if (l2 != null) {
            Long l3 = l2;
            return Values.durationValue((TemporalAmount)Duration.ofMillis(TimeUnit.MICROSECONDS.toMillis(Predef$.MODULE$.Long2long(l3))));
        }
        return Values.NO_VALUE;
    }

    private static final MapValue getMapValue$1(Map m) {
        scala.collection.mutable.Map scalaMap = CollectionConverters$.MODULE$.MapHasAsScala(m).asScala();
        String[] keys = (String[])scalaMap.keys().toArray(ClassTag$.MODULE$.apply(String.class));
        AnyValue[] vals = (AnyValue[])((IterableOnceOps)scalaMap.values().map((Function1 & Serializable)x$1 -> ValueUtils.of((Object)x$1))).toArray(ClassTag$.MODULE$.apply(AnyValue.class));
        return VirtualValues.map((String[])keys, (AnyValue[])vals);
    }

    public ShowTransactionsCommand(Either<List<String>, Expression> givenIds, boolean verbose, List<ShowColumn> defaultColumns, List<CommandResultItem> yieldColumns) {
        this.givenIds = givenIds;
        this.verbose = verbose;
        this.defaultColumns = defaultColumns;
        this.yieldColumns = yieldColumns;
        super(defaultColumns, yieldColumns);
        Product.$init$((Product)this);
    }
}

