/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands;

import java.io.Serializable;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.cypher.internal.ast.CommandResultItem;
import org.neo4j.cypher.internal.ast.ShowColumn;
import org.neo4j.cypher.internal.expressions.LogicalVariable;
import org.neo4j.cypher.internal.runtime.ClosingIterator;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.values.AnyValue;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005uc!\u0002\n\u0014\u0003\u0003!\u0003\u0002C\u0016\u0001\u0005\u000b\u0007I\u0011\u0002\u0017\t\u0011}\u0002!\u0011!Q\u0001\n5B\u0001\u0002\u0011\u0001\u0003\u0006\u0004%I!\u0011\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u0005\")q\t\u0001C\u0001\u0011\"9Q\n\u0001b\u0001\n\u0013a\u0003B\u0002(\u0001A\u0003%Q\u0006C\u0003P\u0001\u0019E\u0001\u000bC\u0003t\u0001\u0011\u0015A\u000fC\u0003x\u0001\u0011E\u0001\u0010C\u0004\u0002\u000e\u0001!\t\"a\u0004\t\u000f\u0005\u0015\u0002\u0001\"\u0005\u0002(!9\u0011Q\u0006\u0001\u0005\n\u0005=raBA\u001b'!\u0005\u0011q\u0007\u0004\u0007%MA\t!!\u000f\t\r\u001d{A\u0011AA\u001e\u0011!\tid\u0004C\t'\u0005}\"aB\"p[6\fg\u000e\u001a\u0006\u0003)U\tAb\u001d5po\u000e|W.\\1oINT!AF\f\u0002\u0011\r|W.\\1oINT!\u0001G\r\u0002\u0017%tG/\u001a:qe\u0016$X\r\u001a\u0006\u00035m\tqA];oi&lWM\u0003\u0002\u001d;\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u001f?\u000511-\u001f9iKJT!\u0001I\u0011\u0002\u000b9,w\u000e\u000e6\u000b\u0003\t\n1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0013\u0011\u0005\u0019JS\"A\u0014\u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0003\r\u0005s\u0017PU3g\u00039!WMZ1vYR\u001cu\u000e\\;n]N,\u0012!\f\t\u0004]YJdBA\u00185\u001d\t\u00014'D\u00012\u0015\t\u00114%\u0001\u0004=e>|GOP\u0005\u0002Q%\u0011QgJ\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0004H\u0001\u0003MSN$(BA\u001b(!\tQT(D\u0001<\u0015\ta4$A\u0002bgRL!AP\u001e\u0003\u0015MCwn^\"pYVlg.A\beK\u001a\fW\u000f\u001c;D_2,XN\\:!\u00031I\u0018.\u001a7e\u0007>dW/\u001c8t+\u0005\u0011\u0005c\u0001\u00187\u0007B\u0011!\bR\u0005\u0003\u000bn\u0012\u0011cQ8n[\u0006tGMU3tk2$\u0018\n^3n\u00035I\u0018.\u001a7e\u0007>dW/\u001c8tA\u00051A(\u001b8jiz\"2!S&M!\tQ\u0005!D\u0001\u0014\u0011\u0015YS\u00011\u0001.\u0011\u0015\u0001U\u00011\u0001C\u0003\u001d\u0019w\u000e\\;n]N\f\u0001bY8mk6t7\u000fI\u0001\u0011_JLw-\u001b8bY:\u000bW.\u001a*poN$2!\u00154o!\r\u00116+V\u0007\u00023%\u0011A+\u0007\u0002\u0010\u00072|7/\u001b8h\u0013R,'/\u0019;peB!aKW/a\u001d\t9\u0006\f\u0005\u00021O%\u0011\u0011lJ\u0001\u0007!J,G-\u001a4\n\u0005mc&aA'ba*\u0011\u0011l\n\t\u0003-zK!a\u0018/\u0003\rM#(/\u001b8h!\t\tG-D\u0001c\u0015\t\u0019w$\u0001\u0004wC2,Xm]\u0005\u0003K\n\u0014\u0001\"\u00118z-\u0006dW/\u001a\u0005\u0006O\"\u0001\r\u0001[\u0001\u0006gR\fG/\u001a\t\u0003S2l\u0011A\u001b\u0006\u0003W^\tQ\u0001]5qKNL!!\u001c6\u0003\u0015E+XM]=Ti\u0006$X\rC\u0003p\u0011\u0001\u0007\u0001/A\u0004cCN,'k\\<\u0011\u0005I\u000b\u0018B\u0001:\u001a\u0005%\u0019\u0015\u0010\u001d5feJ{w/\u0001\u0003s_^\u001cHcA)vm\")q-\u0003a\u0001Q\")q.\u0003a\u0001a\u0006)r-\u001a;D_:4\u0017nZ;sK\u0012$\u0016.\\3[_:,GcA=\u0002\u0004A\u0011!p`\u0007\u0002w*\u0011A0`\u0001\u0005i&lWMC\u0001\u007f\u0003\u0011Q\u0017M^1\n\u0007\u0005\u00051P\u0001\u0004[_:,\u0017\n\u001a\u0005\b\u0003\u000bQ\u0001\u0019AA\u0004\u0003\r\u0019G\u000f\u001f\t\u0004%\u0006%\u0011bAA\u00063\ta\u0011+^3ss\u000e{g\u000e^3yi\u0006Qam\u001c:nCR$\u0016.\\3\u0015\r\u0005E\u0011qCA\u0011!\rQ\u00181C\u0005\u0004\u0003+Y(AD(gMN,G\u000fR1uKRKW.\u001a\u0005\b\u00033Y\u0001\u0019AA\u000e\u0003%\u0019H/\u0019:u)&lW\rE\u0002'\u0003;I1!a\b(\u0005\u0011auN\\4\t\r\u0005\r2\u00021\u0001z\u0003\u0019QxN\\3JI\u00069S\u000f\u001d3bi\u0016\u0014vn^:XSRD\u0007k\u001c;f]RL\u0017\r\u001c7z%\u0016t\u0017-\\3e\u0007>dW/\u001c8t)\u0011\tI#a\u000b\u0011\u000792T\u000b\u0003\u0004t\u0019\u0001\u0007\u0011\u0011F\u0001\u000bO\u0016$8i\u001c7v[:\u001cH#B\u0017\u00022\u0005M\u0002\"B\u0016\u000e\u0001\u0004i\u0003\"\u0002!\u000e\u0001\u0004\u0011\u0015aB\"p[6\fg\u000e\u001a\t\u0003\u0015>\u0019\"aD\u0013\u0015\u0005\u0005]\u0012\u0001D3yiJ\f7\r\u001e(b[\u0016\u001cH\u0003CA!\u0003\u0007\nI&a\u0017\u0011\u000792T\fC\u0004\u0002FE\u0001\r!a\u0012\u0002\u000b9\fW.Z:\u0011\u000f9\nI%!\u0011\u0002N%\u0019\u00111\n\u001d\u0003\r\u0015KG\u000f[3s!\u0011\ty%!\u0016\u000e\u0005\u0005E#bAA*+\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\u0011\t9&!\u0015\u0003\u0015\u0015C\bO]3tg&|g\u000eC\u0003h#\u0001\u0007\u0001\u000eC\u0003p#\u0001\u0007\u0001\u000f")
public abstract class Command {
    private final List<ShowColumn> defaultColumns;
    private final List<CommandResultItem> yieldColumns;
    private final List<ShowColumn> columns;

    private List<ShowColumn> defaultColumns() {
        return this.defaultColumns;
    }

    private List<CommandResultItem> yieldColumns() {
        return this.yieldColumns;
    }

    private List<ShowColumn> columns() {
        return this.columns;
    }

    public abstract ClosingIterator<Map<String, AnyValue>> originalNameRows(QueryState var1, CypherRow var2);

    public final ClosingIterator<Map<String, AnyValue>> rows(QueryState state, CypherRow baseRow) {
        return this.originalNameRows(state, baseRow).map((Function1 & Serializable)map -> this.columns().map((Function1 & Serializable)x0$1 -> {
            ShowColumn showColumn = x0$1;
            if (showColumn != null) {
                LogicalVariable lv = showColumn.variable();
                String originalName = showColumn.name();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)lv.name()), map.apply((Object)originalName));
            }
            throw new MatchError((Object)showColumn);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public ZoneId getConfiguredTimeZone(QueryContext ctx) {
        return ((LogTimeZone)ctx.getConfig().get(GraphDatabaseSettings.db_timezone)).getZoneId();
    }

    public OffsetDateTime formatTime(long startTime, ZoneId zoneId) {
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(startTime), zoneId);
    }

    public List<Map<String, AnyValue>> updateRowsWithPotentiallyRenamedColumns(List<Map<String, AnyValue>> rows) {
        return rows.map((Function1 & Serializable)row -> (Map)row.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                AnyValue value = (AnyValue)tuple2._2();
                String newKey = (String)this.yieldColumns().find((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)Command.$anonfun$updateRowsWithPotentiallyRenamedColumns$3(key, c))).map((Function1 & Serializable)x$1 -> x$1.aliasedVariable().name()).getOrElse((Function0 & Serializable)() -> key);
                return new Tuple2((Object)newKey, (Object)value);
            }
            throw new MatchError((Object)tuple2);
        }));
    }

    private List<ShowColumn> getColumns(List<ShowColumn> defaultColumns, List<CommandResultItem> yieldColumns) {
        if (yieldColumns.nonEmpty()) {
            return yieldColumns.map((Function1 & Serializable)c -> {
                ShowColumn column = (ShowColumn)defaultColumns.find((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)Command.$anonfun$getColumns$2(c, s))).get();
                return new ShowColumn(c.aliasedVariable(), column.cypherType(), c.aliasedVariable().name());
            });
        }
        return defaultColumns;
    }

    public static final /* synthetic */ boolean $anonfun$updateRowsWithPotentiallyRenamedColumns$3(String key$1, CommandResultItem c) {
        return c.originalName().equals(key$1);
    }

    public static final /* synthetic */ boolean $anonfun$getColumns$2(CommandResultItem c$1, ShowColumn s) {
        return s.variable().name().equals(c$1.originalName());
    }

    public Command(List<ShowColumn> defaultColumns, List<CommandResultItem> yieldColumns) {
        this.defaultColumns = defaultColumns;
        this.yieldColumns = yieldColumns;
        this.columns = this.getColumns(defaultColumns, yieldColumns);
    }
}

