/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands;

import java.io.Serializable;
import org.neo4j.common.EntityType;
import org.neo4j.cypher.internal.ast.NodeExistsConstraints;
import org.neo4j.cypher.internal.ast.NodeExistsConstraints$;
import org.neo4j.cypher.internal.ast.NodeKeyConstraints$;
import org.neo4j.cypher.internal.ast.NodePropTypeConstraints$;
import org.neo4j.cypher.internal.ast.NodeUniqueConstraints$;
import org.neo4j.cypher.internal.ast.RelExistsConstraints;
import org.neo4j.cypher.internal.ast.RelExistsConstraints$;
import org.neo4j.cypher.internal.ast.RelKeyConstraints$;
import org.neo4j.cypher.internal.ast.RelPropTypeConstraints$;
import org.neo4j.cypher.internal.ast.RelUniqueConstraints$;
import org.neo4j.cypher.internal.ast.ShowColumn;
import org.neo4j.cypher.internal.ast.ShowConstraintType;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.ShowConstraintsCommand;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.ShowSchemaCommandHelper$;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.values.storable.Value;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class ShowConstraintsCommand$
implements Serializable {
    public static final ShowConstraintsCommand$ MODULE$ = new ShowConstraintsCommand$();

    public String org$neo4j$cypher$internal$runtime$interpreted$commands$showcommands$ShowConstraintsCommand$$createConstraintStatement(String name, ShowConstraintType constraintType, List<String> labelsOrTypes, List<String> properties, Option<String> providerName, Option<IndexConfig> indexConfig, Option<String> propertyType) {
        String labelsOrTypesWithColons = ShowSchemaCommandHelper$.MODULE$.asEscapedString(labelsOrTypes, ShowSchemaCommandHelper$.MODULE$.colonStringJoiner());
        String escapedName = ShowSchemaCommandHelper$.MODULE$.escapeBackticks(name);
        ShowConstraintType showConstraintType = constraintType;
        if (NodeUniqueConstraints$.MODULE$.equals(showConstraintType)) {
            String escapedProperties = ShowSchemaCommandHelper$.MODULE$.asEscapedString(properties, ShowSchemaCommandHelper$.MODULE$.propStringJoiner());
            String options = this.extractOptionsString(providerName, indexConfig, NodeUniqueConstraints$.MODULE$.prettyPrint());
            return "CREATE CONSTRAINT `" + escapedName + "` FOR (n" + labelsOrTypesWithColons + ") REQUIRE (" + escapedProperties + ") IS UNIQUE OPTIONS " + options;
        }
        if (RelUniqueConstraints$.MODULE$.equals(showConstraintType)) {
            String escapedProperties = ShowSchemaCommandHelper$.MODULE$.asEscapedString(properties, ShowSchemaCommandHelper$.MODULE$.relPropStringJoiner());
            String options = this.extractOptionsString(providerName, indexConfig, RelUniqueConstraints$.MODULE$.prettyPrint());
            return "CREATE CONSTRAINT `" + escapedName + "` FOR ()-[r" + labelsOrTypesWithColons + "]-() REQUIRE (" + escapedProperties + ") IS UNIQUE OPTIONS " + options;
        }
        if (NodeKeyConstraints$.MODULE$.equals(showConstraintType)) {
            String escapedProperties = ShowSchemaCommandHelper$.MODULE$.asEscapedString(properties, ShowSchemaCommandHelper$.MODULE$.propStringJoiner());
            String options = this.extractOptionsString(providerName, indexConfig, NodeKeyConstraints$.MODULE$.prettyPrint());
            return "CREATE CONSTRAINT `" + escapedName + "` FOR (n" + labelsOrTypesWithColons + ") REQUIRE (" + escapedProperties + ") IS NODE KEY OPTIONS " + options;
        }
        if (RelKeyConstraints$.MODULE$.equals(showConstraintType)) {
            String escapedProperties = ShowSchemaCommandHelper$.MODULE$.asEscapedString(properties, ShowSchemaCommandHelper$.MODULE$.relPropStringJoiner());
            String options = this.extractOptionsString(providerName, indexConfig, RelKeyConstraints$.MODULE$.prettyPrint());
            return "CREATE CONSTRAINT `" + escapedName + "` FOR ()-[r" + labelsOrTypesWithColons + "]-() REQUIRE (" + escapedProperties + ") IS RELATIONSHIP KEY OPTIONS " + options;
        }
        if (showConstraintType instanceof NodeExistsConstraints) {
            String escapedProperties = ShowSchemaCommandHelper$.MODULE$.asEscapedString(properties, ShowSchemaCommandHelper$.MODULE$.propStringJoiner());
            return "CREATE CONSTRAINT `" + escapedName + "` FOR (n" + labelsOrTypesWithColons + ") REQUIRE (" + escapedProperties + ") IS NOT NULL";
        }
        if (showConstraintType instanceof RelExistsConstraints) {
            String escapedProperties = ShowSchemaCommandHelper$.MODULE$.asEscapedString(properties, ShowSchemaCommandHelper$.MODULE$.relPropStringJoiner());
            return "CREATE CONSTRAINT `" + escapedName + "` FOR ()-[r" + labelsOrTypesWithColons + "]-() REQUIRE (" + escapedProperties + ") IS NOT NULL";
        }
        if (NodePropTypeConstraints$.MODULE$.equals(showConstraintType)) {
            String escapedProperties = ShowSchemaCommandHelper$.MODULE$.asEscapedString(properties, ShowSchemaCommandHelper$.MODULE$.propStringJoiner());
            String typeString = (String)propertyType.getOrElse((Function0 & Serializable)() -> {
                throw new IllegalArgumentException("Expected a property type for " + constraintType + " constraint.");
            });
            return "CREATE CONSTRAINT `" + escapedName + "` FOR (n" + labelsOrTypesWithColons + ") REQUIRE (" + escapedProperties + ") IS :: " + typeString;
        }
        if (RelPropTypeConstraints$.MODULE$.equals(showConstraintType)) {
            String escapedProperties = ShowSchemaCommandHelper$.MODULE$.asEscapedString(properties, ShowSchemaCommandHelper$.MODULE$.relPropStringJoiner());
            String typeString = (String)propertyType.getOrElse((Function0 & Serializable)() -> {
                throw new IllegalArgumentException("Expected a property type for " + constraintType + " constraint.");
            });
            return "CREATE CONSTRAINT `" + escapedName + "` FOR ()-[r" + labelsOrTypesWithColons + "]-() REQUIRE (" + escapedProperties + ") IS :: " + typeString;
        }
        throw new IllegalArgumentException("Did not expect constraint type " + constraintType.prettyPrint() + " for constraint create command.");
    }

    public Option<String> org$neo4j$cypher$internal$runtime$interpreted$commands$showcommands$ShowConstraintsCommand$$createConstraintStatement$default$5() {
        return None$.MODULE$;
    }

    public Option<IndexConfig> org$neo4j$cypher$internal$runtime$interpreted$commands$showcommands$ShowConstraintsCommand$$createConstraintStatement$default$6() {
        return None$.MODULE$;
    }

    public Option<String> org$neo4j$cypher$internal$runtime$interpreted$commands$showcommands$ShowConstraintsCommand$$createConstraintStatement$default$7() {
        return None$.MODULE$;
    }

    private String extractOptionsString(Option<String> maybeProviderName, Option<IndexConfig> maybeIndexConfig, String constraintType) {
        String providerName = (String)maybeProviderName.getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Expected a provider name for " + constraintType + " constraint.");
        });
        IndexConfig indexConfig = (IndexConfig)maybeIndexConfig.getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Expected an index configuration for " + constraintType + " constraint.");
        });
        String btreeOrEmptyConfig = ShowSchemaCommandHelper$.MODULE$.configAsString(indexConfig, (Function1<Value, String>)(Function1 & Serializable)value -> ShowSchemaCommandHelper$.MODULE$.pointConfigValueAsString((Value)value));
        return ShowSchemaCommandHelper$.MODULE$.optionsAsString(providerName, btreeOrEmptyConfig);
    }

    public ShowConstraintType org$neo4j$cypher$internal$runtime$interpreted$commands$showcommands$ShowConstraintsCommand$$getConstraintType(ConstraintType internalConstraintType, EntityType entityType) {
        Tuple2 tuple2 = new Tuple2((Object)internalConstraintType, (Object)entityType);
        if (tuple2 != null) {
            ConstraintType constraintType = (ConstraintType)tuple2._1();
            EntityType entityType2 = (EntityType)tuple2._2();
            if (ConstraintType.UNIQUE.equals(constraintType) && EntityType.NODE.equals(entityType2)) {
                return NodeUniqueConstraints$.MODULE$;
            }
        }
        if (tuple2 != null) {
            ConstraintType constraintType = (ConstraintType)tuple2._1();
            EntityType entityType3 = (EntityType)tuple2._2();
            if (ConstraintType.UNIQUE.equals(constraintType) && EntityType.RELATIONSHIP.equals(entityType3)) {
                return RelUniqueConstraints$.MODULE$;
            }
        }
        if (tuple2 != null) {
            ConstraintType constraintType = (ConstraintType)tuple2._1();
            EntityType entityType4 = (EntityType)tuple2._2();
            if (ConstraintType.UNIQUE_EXISTS.equals(constraintType) && EntityType.NODE.equals(entityType4)) {
                return NodeKeyConstraints$.MODULE$;
            }
        }
        if (tuple2 != null) {
            ConstraintType constraintType = (ConstraintType)tuple2._1();
            EntityType entityType5 = (EntityType)tuple2._2();
            if (ConstraintType.UNIQUE_EXISTS.equals(constraintType) && EntityType.RELATIONSHIP.equals(entityType5)) {
                return RelKeyConstraints$.MODULE$;
            }
        }
        if (tuple2 != null) {
            ConstraintType constraintType = (ConstraintType)tuple2._1();
            EntityType entityType6 = (EntityType)tuple2._2();
            if (ConstraintType.EXISTS.equals(constraintType) && EntityType.NODE.equals(entityType6)) {
                return new NodeExistsConstraints(NodeExistsConstraints$.MODULE$.apply$default$1());
            }
        }
        if (tuple2 != null) {
            ConstraintType constraintType = (ConstraintType)tuple2._1();
            EntityType entityType7 = (EntityType)tuple2._2();
            if (ConstraintType.EXISTS.equals(constraintType) && EntityType.RELATIONSHIP.equals(entityType7)) {
                return new RelExistsConstraints(RelExistsConstraints$.MODULE$.apply$default$1());
            }
        }
        if (tuple2 != null) {
            ConstraintType constraintType = (ConstraintType)tuple2._1();
            EntityType entityType8 = (EntityType)tuple2._2();
            if (ConstraintType.PROPERTY_TYPE.equals(constraintType) && EntityType.NODE.equals(entityType8)) {
                return NodePropTypeConstraints$.MODULE$;
            }
        }
        if (tuple2 != null) {
            ConstraintType constraintType = (ConstraintType)tuple2._1();
            EntityType entityType9 = (EntityType)tuple2._2();
            if (ConstraintType.PROPERTY_TYPE.equals(constraintType) && EntityType.RELATIONSHIP.equals(entityType9)) {
                return RelPropTypeConstraints$.MODULE$;
            }
        }
        throw new IllegalStateException("Invalid constraint combination: ConstraintType " + internalConstraintType + " and EntityType " + entityType + ".");
    }

    public ShowConstraintsCommand apply(ShowConstraintType constraintType, boolean verbose, List<ShowColumn> columns) {
        return new ShowConstraintsCommand(constraintType, verbose, columns);
    }

    public Option<Tuple3<ShowConstraintType, Object, List<ShowColumn>>> unapply(ShowConstraintsCommand x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3((Object)x$0.constraintType(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.verbose()), x$0.columns()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ShowConstraintsCommand$.class);
    }

    private ShowConstraintsCommand$() {
    }
}

