/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands;

import java.io.Serializable;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.cypher.internal.ast.ShowColumn;
import org.neo4j.cypher.internal.expressions.LogicalVariable;
import org.neo4j.cypher.internal.runtime.ClosingIterator;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.Command$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.values.AnyValue;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001db!B\u0006\r\u0003\u0003i\u0002\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\t\u000b]\u0002A\u0011\u0001\u001d\t\u000bq\u0002a\u0011A\u001f\t\u000b\u0001\u0004AQA1\t\u000b\u0011\u0004A\u0011C3\t\u000bM\u0004A\u0011\u0003;\b\r}d\u0001\u0012AA\u0001\r\u0019YA\u0002#\u0001\u0002\u0004!1q\u0007\u0003C\u0001\u0003\u000bAq!a\u0002\t\t\u0003\tIAA\u0004D_6l\u0017M\u001c3\u000b\u00055q\u0011\u0001D:i_^\u001cw.\\7b]\u0012\u001c(BA\b\u0011\u0003!\u0019w.\\7b]\u0012\u001c(BA\t\u0013\u0003-Ig\u000e^3saJ,G/\u001a3\u000b\u0005M!\u0012a\u0002:v]RLW.\u001a\u0006\u0003+Y\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003/a\taaY=qQ\u0016\u0014(BA\r\u001b\u0003\u0015qWm\u001c\u001bk\u0015\u0005Y\u0012aA8sO\u000e\u00011C\u0001\u0001\u001f!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0019\te.\u001f*fM\u000691m\u001c7v[:\u001c\bc\u0001\u0014/c9\u0011q\u0005\f\b\u0003Q-j\u0011!\u000b\u0006\u0003Uq\ta\u0001\u0010:p_Rt\u0014\"A\u0011\n\u00055\u0002\u0013a\u00029bG.\fw-Z\u0005\u0003_A\u0012A\u0001T5ti*\u0011Q\u0006\t\t\u0003eUj\u0011a\r\u0006\u0003iQ\t1!Y:u\u0013\t14G\u0001\u0006TQ><8i\u001c7v[:\fa\u0001P5oSRtDCA\u001d<!\tQ\u0004!D\u0001\r\u0011\u0015!#\u00011\u0001&\u0003Ay'/[4j]\u0006dg*Y7f%><8\u000fF\u0002?'n\u00032a\u0010!C\u001b\u0005\u0011\u0012BA!\u0013\u0005=\u0019En\\:j]\u001eLE/\u001a:bi>\u0014\b\u0003B\"H\u00156s!\u0001R#\u0011\u0005!\u0002\u0013B\u0001$!\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001*\u0013\u0002\u0004\u001b\u0006\u0004(B\u0001$!!\t\u00195*\u0003\u0002M\u0013\n11\u000b\u001e:j]\u001e\u0004\"AT)\u000e\u0003=S!\u0001\u0015\r\u0002\rY\fG.^3t\u0013\t\u0011vJ\u0001\u0005B]f4\u0016\r\\;f\u0011\u0015!6\u00011\u0001V\u0003\u0015\u0019H/\u0019;f!\t1\u0016,D\u0001X\u0015\tA\u0006#A\u0003qSB,7/\u0003\u0002[/\nQ\u0011+^3ssN#\u0018\r^3\t\u000bq\u001b\u0001\u0019A/\u0002\u000f\t\f7/\u001a*poB\u0011qHX\u0005\u0003?J\u0011\u0011bQ=qQ\u0016\u0014(k\\<\u0002\tI|wo\u001d\u000b\u0004}\t\u001c\u0007\"\u0002+\u0005\u0001\u0004)\u0006\"\u0002/\u0005\u0001\u0004i\u0016!F4fi\u000e{gNZ5hkJ,G\rV5nKj{g.\u001a\u000b\u0003M:\u0004\"a\u001a7\u000e\u0003!T!!\u001b6\u0002\tQLW.\u001a\u0006\u0002W\u0006!!.\u0019<b\u0013\ti\u0007N\u0001\u0004[_:,\u0017\n\u001a\u0005\u0006_\u0016\u0001\r\u0001]\u0001\u0004GRD\bCA r\u0013\t\u0011(C\u0001\u0007Rk\u0016\u0014\u0018pQ8oi\u0016DH/\u0001\u0006g_Jl\u0017\r\u001e+j[\u0016$2!\u001e=~!\t9g/\u0003\u0002xQ\nqqJ\u001a4tKR$\u0015\r^3US6,\u0007\"B=\u0007\u0001\u0004Q\u0018!C:uCJ$H+[7f!\ty20\u0003\u0002}A\t!Aj\u001c8h\u0011\u0015qh\u00011\u0001g\u0003\u0019QxN\\3JI\u000691i\\7nC:$\u0007C\u0001\u001e\t'\tAa\u0004\u0006\u0002\u0002\u0002\u0005aQ\r\u001f;sC\u000e$h*Y7fgRA\u00111BA\u0007\u0003G\t)\u0003E\u0002'])Cq!a\u0004\u000b\u0001\u0004\t\t\"A\u0003oC6,7\u000fE\u0004'\u0003'\tY!a\u0006\n\u0007\u0005U\u0001G\u0001\u0004FSRDWM\u001d\t\u0005\u00033\ty\"\u0004\u0002\u0002\u001c)\u0019\u0011Q\u0004\b\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0005\u0003C\tYB\u0001\u0006FqB\u0014Xm]:j_:DQ\u0001\u0016\u0006A\u0002UCQ\u0001\u0018\u0006A\u0002u\u0003")
public abstract class Command {
    private final List<ShowColumn> columns;

    public static List<String> extractNames(Either<List<String>, Expression> names, QueryState state, CypherRow baseRow) {
        return Command$.MODULE$.extractNames(names, state, baseRow);
    }

    public abstract ClosingIterator<Map<String, AnyValue>> originalNameRows(QueryState var1, CypherRow var2);

    public final ClosingIterator<Map<String, AnyValue>> rows(QueryState state, CypherRow baseRow) {
        return this.originalNameRows(state, baseRow).map((Function1 & Serializable)map -> $this.columns.map((Function1 & Serializable)x0$1 -> {
            ShowColumn showColumn = x0$1;
            if (showColumn != null) {
                LogicalVariable lv = showColumn.variable();
                String originalName = showColumn.name();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)lv.name()), map.apply((Object)originalName));
            }
            throw new MatchError((Object)showColumn);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public ZoneId getConfiguredTimeZone(QueryContext ctx) {
        return ((LogTimeZone)ctx.getConfig().get(GraphDatabaseSettings.db_timezone)).getZoneId();
    }

    public OffsetDateTime formatTime(long startTime, ZoneId zoneId) {
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(startTime), zoneId);
    }

    public Command(List<ShowColumn> columns) {
        this.columns = columns;
    }
}

