/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands;

import java.util.Objects;
import org.neo4j.configuration.helpers.DatabaseNameValidator;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.TransactionId;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class TransactionId$
implements Serializable {
    public static TransactionId$ MODULE$;
    private final String org$neo4j$cypher$internal$runtime$interpreted$commands$showcommands$TransactionId$$SEPARATOR;
    private final String EXPECTED_FORMAT_MSG;
    private final String RUNNING_STATE;
    private final String CLOSING_STATE;
    private final String BLOCKED_STATE;
    private final String TERMINATED_STATE;

    static {
        new TransactionId$();
    }

    public String org$neo4j$cypher$internal$runtime$interpreted$commands$showcommands$TransactionId$$SEPARATOR() {
        return this.org$neo4j$cypher$internal$runtime$interpreted$commands$showcommands$TransactionId$$SEPARATOR;
    }

    private String EXPECTED_FORMAT_MSG() {
        return this.EXPECTED_FORMAT_MSG;
    }

    public String RUNNING_STATE() {
        return this.RUNNING_STATE;
    }

    public String CLOSING_STATE() {
        return this.CLOSING_STATE;
    }

    public String BLOCKED_STATE() {
        return this.BLOCKED_STATE;
    }

    public String TERMINATED_STATE() {
        return this.TERMINATED_STATE;
    }

    public TransactionId apply(String dbName, long internalId) {
        if (internalId < 0L) {
            throw new InvalidArgumentsException(new StringBuilder(31).append("Negative ids are not supported ").append(this.EXPECTED_FORMAT_MSG()).toString());
        }
        return new TransactionId(new NormalizedDatabaseName(Objects.requireNonNull(dbName)), internalId);
    }

    public TransactionId parse(String transactionIdText) throws InvalidArgumentsException {
        try {
            int i = transactionIdText.lastIndexOf(this.org$neo4j$cypher$internal$runtime$interpreted$commands$showcommands$TransactionId$$SEPARATOR());
            if (i != -1) {
                NormalizedDatabaseName database = new NormalizedDatabaseName(transactionIdText.substring(0, i));
                DatabaseNameValidator.validateInternalDatabaseName((NormalizedDatabaseName)database);
                if (new StringOps(Predef$.MODULE$.augmentString(database.name())).nonEmpty()) {
                    String tid = transactionIdText.substring(i + this.org$neo4j$cypher$internal$runtime$interpreted$commands$showcommands$TransactionId$$SEPARATOR().length());
                    long internalId = new StringOps(Predef$.MODULE$.augmentString(tid)).toLong();
                    return this.apply(database.name(), internalId);
                }
            }
        }
        catch (NumberFormatException e) {
            throw new InvalidArgumentsException(new StringBuilder(19).append("Could not parse id ").append(this.EXPECTED_FORMAT_MSG()).toString(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidArgumentsException(e.getMessage(), (Throwable)e);
        }
        throw new InvalidArgumentsException(new StringBuilder(19).append("Could not parse id ").append(this.EXPECTED_FORMAT_MSG()).toString());
    }

    public TransactionId apply(NormalizedDatabaseName database, long internalId) {
        return new TransactionId(database, internalId);
    }

    public Option<Tuple2<NormalizedDatabaseName, Object>> unapply(TransactionId x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.database(), (Object)BoxesRunTime.boxToLong((long)x$0.internalId())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private TransactionId$() {
        MODULE$ = this;
        this.org$neo4j$cypher$internal$runtime$interpreted$commands$showcommands$TransactionId$$SEPARATOR = "-transaction-";
        this.EXPECTED_FORMAT_MSG = new StringBuilder(37).append("(expected format: <databasename>").append(this.org$neo4j$cypher$internal$runtime$interpreted$commands$showcommands$TransactionId$$SEPARATOR()).append("<id>)").toString();
        this.RUNNING_STATE = "Running";
        this.CLOSING_STATE = "Closing";
        this.BLOCKED_STATE = "Blocked by: ";
        this.TERMINATED_STATE = "Terminated with reason: %s";
    }
}

