/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands;

import java.io.Serializable;
import java.util.Optional;
import org.neo4j.cypher.internal.ast.CurrentUser$;
import org.neo4j.cypher.internal.ast.ExecutableBy;
import org.neo4j.cypher.internal.ast.User;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.ShowProcFuncCommandHelper;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.security.AdminActionOnResource;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.PrivilegeAction;
import org.neo4j.internal.kernel.api.security.SecurityAuthorizationHandler;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.kernel.api.security.Segment;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.VirtualValues;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class ShowProcFuncCommandHelper$ {
    public static ShowProcFuncCommandHelper$ MODULE$;

    static {
        new ShowProcFuncCommandHelper$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple2<Set<String>, Object> getRolesForUser(SecurityContext securityContext, SecurityAuthorizationHandler securityHandler, Option<GraphDatabaseService> systemGraph, Option<ExecutableBy> executableBy, String command) {
        ExecutableBy executableBy2;
        boolean bl = false;
        Some some = null;
        Option<ExecutableBy> option = executableBy;
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            ExecutableBy executableBy3 = (ExecutableBy)some.value();
            if (CurrentUser$.MODULE$.equals(executableBy3) && securityContext.subject().equals(AuthSubject.AUTH_DISABLED)) {
                return new Tuple2((Object)Predef$.MODULE$.Set().empty(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            }
        }
        if (bl && (executableBy2 = (ExecutableBy)some.value()) instanceof User) {
            User user = (User)executableBy2;
            String name = user.name();
            if (!securityContext.subject().hasUsername(name)) {
                boolean allowedShowUser = securityContext.allowsAdminAction(new AdminActionOnResource(PrivilegeAction.SHOW_USER, AdminActionOnResource.DatabaseScope.ALL, Segment.ALL));
                if (!allowedShowUser) {
                    String violationMessage = new StringBuilder(283).append("Permission denied for ").append(command).append(", requires SHOW USER privilege. ").append("Try executing SHOW USER PRIVILEGES to determine the missing or denied privileges. ").append("In case of missing privileges, they need to be granted (See GRANT). In case of denied privileges, they need to be revoked (See REVOKE) and granted.").toString();
                    throw securityHandler.logAndGetAuthorizationException(securityContext, violationMessage);
                }
                Transaction stx = ((GraphDatabaseService)systemGraph.get()).beginTx();
                ResourceIterator rolesResult = stx.execute(new StringBuilder(57).append("SHOW USERS YIELD user, roles WHERE user = '").append(name).append("' RETURN roles").toString()).columnAs("roles");
                Set rolesSet = rolesResult.hasNext() ? ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)rolesResult.next()).asScala()).toSet() : Predef$.MODULE$.Set().empty();
                stx.commit();
                return new Tuple2((Object)rolesSet, (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
        }
        if (bl) {
            return new Tuple2((Object)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(securityContext.roles()).asScala()).toSet(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        return new Tuple2((Object)Predef$.MODULE$.Set().empty(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public List<scala.collection.immutable.Map<String, String>> getSignatureValues(java.util.List<FieldSignature> fields) {
        return (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(fields).asScala()).toList().map((Function1 & Serializable & scala.Serializable)f -> {
            void var1_1;
            scala.collection.immutable.Map values = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)f.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)f.neo4jType().toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"description"), (Object)f.toString())}));
            Optional optional = f.defaultValue();
            return optional.isPresent() ? values.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"default"), (Object)((DefaultParameterValue)optional.get()).toString())}))) : var1_1;
        }, List$.MODULE$.canBuildFrom());
    }

    public ListValue fieldDescriptions(List<scala.collection.immutable.Map<String, String>> fields) {
        List fieldMaps = (List)fields.map((Function1 & Serializable & scala.Serializable)f -> {
            String[] keys = (String[])((Object[])new String[]{"name", "type", "description"});
            AnyValue[] values = (AnyValue[])((Object[])new AnyValue[]{Values.stringValue((String)((String)f.apply((Object)"name"))), Values.stringValue((String)((String)f.apply((Object)"type"))), Values.stringValue((String)((String)f.apply((Object)"description")))});
            Option option = f.get((Object)"default");
            return option.isDefined() ? VirtualValues.map((String[])((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])keys)).$colon$plus((Object)"default", ClassTag$.MODULE$.apply(String.class))), (AnyValue[])((AnyValue[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])values)).$colon$plus((Object)Values.stringValue((String)((String)option.get())), ClassTag$.MODULE$.apply(AnyValue.class)))) : VirtualValues.map((String[])keys, (AnyValue[])values);
        }, List$.MODULE$.canBuildFrom());
        return VirtualValues.fromList((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)fieldMaps).asJava()));
    }

    public Tuple2<ShowProcFuncCommandHelper.Privileges, Option<GraphDatabaseService>> getPrivileges(QueryState state, String executeSegment) {
        List list;
        GraphDatabaseService sg = ((DatabaseManagementService)state.query().graph().getDependencyResolver().resolveDependency(DatabaseManagementService.class)).database("system");
        Transaction stx = sg.beginTx();
        String execQuery = "SHOW ALL PRIVILEGES YIELD * WHERE action='execute' AND segment STARTS WITH $seg RETURN access, segment, collect(role) as roles";
        Result executePrivilegesRes = stx.execute(execQuery, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"seg"), (Object)executeSegment)}))).asJava());
        List executePrivileges = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter((java.util.Iterator)executePrivilegesRes).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(x$1).asScala()).toMap(Predef$.MODULE$.$conforms())).toList();
        String boostQuery = "SHOW ALL PRIVILEGES YIELD * WHERE action STARTS WITH 'execute_boosted' AND segment STARTS WITH $seg RETURN access, segment, collect(role) as roles";
        Result boostedExecutePrivilegesRes = stx.execute(boostQuery, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"seg"), (Object)executeSegment)}))).asJava());
        List boostedExecutePrivileges = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter((java.util.Iterator)boostedExecutePrivilegesRes).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(x$2).asScala()).toMap(Predef$.MODULE$.$conforms())).toList();
        if (executeSegment.equals("PROCEDURE")) {
            String adminQuery = "SHOW ALL PRIVILEGES YIELD * WHERE action='execute_admin' RETURN access, collect(role) as roles";
            list = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter((java.util.Iterator)stx.execute(adminQuery)).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(x$3).asScala()).toMap(Predef$.MODULE$.$conforms())).toList();
        } else {
            list = List$.MODULE$.empty();
        }
        List adminPrivileges = list;
        String allDbmsQuery = "SHOW ALL PRIVILEGES YIELD * WHERE action IN ['admin', 'dbms_actions'] RETURN access, collect(role) as roles";
        List allDbmsPrivileges = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter((java.util.Iterator)stx.execute(allDbmsQuery)).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(x$4).asScala()).toMap(Predef$.MODULE$.$conforms())).toList();
        stx.commit();
        return new Tuple2((Object)new ShowProcFuncCommandHelper.Privileges((List<scala.collection.immutable.Map<String, Object>>)executePrivileges, (List<scala.collection.immutable.Map<String, Object>>)boostedExecutePrivileges, (List<scala.collection.immutable.Map<String, Object>>)allDbmsPrivileges, (List<scala.collection.immutable.Map<String, Object>>)adminPrivileges), (Object)new Some((Object)sg));
    }

    public Tuple3<Set<String>, Set<String>, Object> roles(String name, boolean isAdmin, ShowProcFuncCommandHelper.Privileges privileges, Set<String> userRoles) {
        Tuple4 tuple4;
        Tuple4 tuple42;
        if (isAdmin) {
            Set grantedExecute = (Set)privileges.grantedAdminExecuteRoles().$plus$plus(privileges.grantedBoostedExecuteRoles(name));
            Set deniedBoosted = (Set)privileges.deniedAdminExecuteRoles().$plus$plus(privileges.deniedBoostedExecuteRoles(name));
            Set deniedExecute = (Set)privileges.deniedExecuteRoles(name).$plus$plus((GenTraversableOnce)deniedBoosted);
            tuple42 = new Tuple4((Object)grantedExecute, (Object)grantedExecute, (Object)deniedExecute, (Object)deniedBoosted);
        } else {
            Set<String> grantedExecute = privileges.grantedExecuteRoles(name);
            Set<String> grantedBoosted = privileges.grantedBoostedExecuteRoles(name);
            Set<String> deniedExecute = privileges.deniedExecuteRoles(name);
            Set<String> deniedBoosted = privileges.deniedBoostedExecuteRoles(name);
            tuple42 = tuple4 = new Tuple4(grantedExecute, grantedBoosted, deniedExecute, deniedBoosted);
        }
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        Set grantedExecuteRoles = (Set)tuple4._1();
        Set grantedBoostedRoles = (Set)tuple4._2();
        Set deniedExecuteRoles = (Set)tuple4._3();
        Set deniedBoostedRoles = (Set)tuple4._4();
        Tuple4 tuple43 = new Tuple4((Object)grantedExecuteRoles, (Object)grantedBoostedRoles, (Object)deniedExecuteRoles, (Object)deniedBoostedRoles);
        Tuple4 tuple44 = tuple43;
        Set grantedExecuteRoles2 = (Set)tuple44._1();
        Set grantedBoostedRoles2 = (Set)tuple44._2();
        Set deniedExecuteRoles2 = (Set)tuple44._3();
        Set deniedBoostedRoles2 = (Set)tuple44._4();
        Set allowedBoostedRoles = (Set)grantedBoostedRoles2.$minus$minus((GenTraversableOnce)deniedBoostedRoles2);
        Set allowedExecuteRoles = (Set)grantedExecuteRoles2.$plus$plus((GenTraversableOnce)allowedBoostedRoles).$minus$minus((GenTraversableOnce)deniedExecuteRoles2);
        boolean allowedExplicit = userRoles.exists((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)grantedExecuteRoles2.contains((Object)r))) && userRoles.forall((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)ShowProcFuncCommandHelper$.$anonfun$roles$2(deniedExecuteRoles2, r)));
        boolean allowedImplicit = userRoles.exists((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)grantedBoostedRoles2.contains((Object)r))) && userRoles.forall((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)ShowProcFuncCommandHelper$.$anonfun$roles$4(deniedBoostedRoles2, deniedExecuteRoles2, r)));
        boolean allowedExecute = allowedExplicit || allowedImplicit;
        return new Tuple3((Object)allowedExecuteRoles, (Object)allowedBoostedRoles, (Object)BoxesRunTime.boxToBoolean((boolean)allowedExecute));
    }

    public Tuple2<ListValue, ListValue> roleValues(Set<String> allowedExecuteRoles, Set<String> allowedBoostedRoles) {
        List allowedExecute = (List)((List)allowedExecuteRoles.toList().sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$1 -> Values.stringValue((String)x$1), List$.MODULE$.canBuildFrom());
        List allowedBoosted = (List)((List)allowedBoostedRoles.toList().sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$1 -> Values.stringValue((String)x$1), List$.MODULE$.canBuildFrom());
        return new Tuple2((Object)VirtualValues.fromList((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)allowedExecute).asJava())), (Object)VirtualValues.fromList((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)allowedBoosted).asJava())));
    }

    public static final /* synthetic */ boolean $anonfun$roles$2(Set deniedExecuteRoles$1, String r) {
        return !deniedExecuteRoles$1.contains((Object)r);
    }

    public static final /* synthetic */ boolean $anonfun$roles$4(Set deniedBoostedRoles$1, Set deniedExecuteRoles$1, String r) {
        return !deniedBoostedRoles$1.contains((Object)r) && !deniedExecuteRoles$1.contains((Object)r);
    }

    private ShowProcFuncCommandHelper$() {
        MODULE$ = this;
    }
}

