/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands;

import java.io.Serializable;
import org.neo4j.common.EntityType;
import org.neo4j.cypher.internal.ast.NodeExistsConstraints;
import org.neo4j.cypher.internal.ast.NodeExistsConstraints$;
import org.neo4j.cypher.internal.ast.NodeKeyConstraints$;
import org.neo4j.cypher.internal.ast.RelExistsConstraints;
import org.neo4j.cypher.internal.ast.RelExistsConstraints$;
import org.neo4j.cypher.internal.ast.ShowColumn;
import org.neo4j.cypher.internal.ast.ShowConstraintType;
import org.neo4j.cypher.internal.ast.UniqueConstraints$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.ShowConstraintsCommand;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.ShowSchemaCommandHelper$;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.values.storable.Value;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;

public final class ShowConstraintsCommand$
implements scala.Serializable {
    public static ShowConstraintsCommand$ MODULE$;

    static {
        new ShowConstraintsCommand$();
    }

    public String org$neo4j$cypher$internal$runtime$interpreted$commands$showcommands$ShowConstraintsCommand$$createConstraintStatement(String name, ShowConstraintType constraintType, List<String> labelsOrTypes, List<String> properties, Option<String> providerName, Option<IndexConfig> indexConfig) {
        String string;
        String labelsOrTypesWithColons = ShowSchemaCommandHelper$.MODULE$.asEscapedString(labelsOrTypes, ShowSchemaCommandHelper$.MODULE$.colonStringJoiner());
        ShowConstraintType showConstraintType = constraintType;
        if (UniqueConstraints$.MODULE$.equals(showConstraintType)) {
            String escapedProperties = ShowSchemaCommandHelper$.MODULE$.asEscapedString(properties, ShowSchemaCommandHelper$.MODULE$.propStringJoiner());
            String options = this.extractOptionsString(providerName, indexConfig, UniqueConstraints$.MODULE$.prettyPrint());
            string = new StringBuilder(56).append("CREATE CONSTRAINT `").append(name).append("` ON (n").append(labelsOrTypesWithColons).append(") ASSERT (").append(escapedProperties).append(") IS UNIQUE OPTIONS ").append(options).toString();
        } else if (NodeKeyConstraints$.MODULE$.equals(showConstraintType)) {
            String escapedProperties = ShowSchemaCommandHelper$.MODULE$.asEscapedString(properties, ShowSchemaCommandHelper$.MODULE$.propStringJoiner());
            String options = this.extractOptionsString(providerName, indexConfig, NodeKeyConstraints$.MODULE$.prettyPrint());
            string = new StringBuilder(58).append("CREATE CONSTRAINT `").append(name).append("` ON (n").append(labelsOrTypesWithColons).append(") ASSERT (").append(escapedProperties).append(") IS NODE KEY OPTIONS ").append(options).toString();
        } else if (showConstraintType instanceof NodeExistsConstraints) {
            String escapedProperties = ShowSchemaCommandHelper$.MODULE$.asEscapedString(properties, ShowSchemaCommandHelper$.MODULE$.propStringJoiner());
            string = new StringBuilder(49).append("CREATE CONSTRAINT `").append(name).append("` ON (n").append(labelsOrTypesWithColons).append(") ASSERT (").append(escapedProperties).append(") IS NOT NULL").toString();
        } else if (showConstraintType instanceof RelExistsConstraints) {
            String escapedProperties = ShowSchemaCommandHelper$.MODULE$.asEscapedString(properties, ShowSchemaCommandHelper$.MODULE$.relPropStringJoiner());
            string = new StringBuilder(55).append("CREATE CONSTRAINT `").append(name).append("` ON ()-[r").append(labelsOrTypesWithColons).append("]-() ASSERT (").append(escapedProperties).append(") IS NOT NULL").toString();
        } else {
            throw new IllegalArgumentException(new StringBuilder(62).append("Did not expect constraint type ").append(constraintType.prettyPrint()).append(" for constraint create command.").toString());
        }
        return string;
    }

    public Option<String> org$neo4j$cypher$internal$runtime$interpreted$commands$showcommands$ShowConstraintsCommand$$createConstraintStatement$default$5() {
        return None$.MODULE$;
    }

    public Option<IndexConfig> org$neo4j$cypher$internal$runtime$interpreted$commands$showcommands$ShowConstraintsCommand$$createConstraintStatement$default$6() {
        return None$.MODULE$;
    }

    private String extractOptionsString(Option<String> maybeProviderName, Option<IndexConfig> maybeIndexConfig, String constraintType) {
        String providerName = (String)maybeProviderName.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(41).append("Expected a provider name for ").append(constraintType).append(" constraint.").toString());
        });
        IndexConfig indexConfig = (IndexConfig)maybeIndexConfig.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(48).append("Expected an index configuration for ").append(constraintType).append(" constraint.").toString());
        });
        String btreeConfig = ShowSchemaCommandHelper$.MODULE$.configAsString(indexConfig, (Function1<Value, String>)(Function1 & Serializable & scala.Serializable)value -> ShowSchemaCommandHelper$.MODULE$.btreeConfigValueAsString((Value)value));
        return ShowSchemaCommandHelper$.MODULE$.optionsAsString(providerName, btreeConfig);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ShowConstraintType org$neo4j$cypher$internal$runtime$interpreted$commands$showcommands$ShowConstraintsCommand$$getConstraintType(ConstraintType internalConstraintType, EntityType entityType) {
        Tuple2 tuple2 = new Tuple2((Object)internalConstraintType, (Object)entityType);
        if (tuple2 != null) {
            ConstraintType constraintType = (ConstraintType)tuple2._1();
            EntityType entityType2 = (EntityType)tuple2._2();
            if (ConstraintType.UNIQUE.equals(constraintType) && EntityType.NODE.equals(entityType2)) {
                return UniqueConstraints$.MODULE$;
            }
        }
        if (tuple2 != null) {
            ConstraintType constraintType = (ConstraintType)tuple2._1();
            EntityType entityType3 = (EntityType)tuple2._2();
            if (ConstraintType.UNIQUE_EXISTS.equals(constraintType) && EntityType.NODE.equals(entityType3)) {
                return NodeKeyConstraints$.MODULE$;
            }
        }
        if (tuple2 != null) {
            ConstraintType constraintType = (ConstraintType)tuple2._1();
            EntityType entityType4 = (EntityType)tuple2._2();
            if (ConstraintType.EXISTS.equals(constraintType) && EntityType.NODE.equals(entityType4)) {
                return new NodeExistsConstraints(NodeExistsConstraints$.MODULE$.apply$default$1());
            }
        }
        if (tuple2 == null) throw new IllegalStateException(new StringBuilder(64).append("Invalid constraint combination: ConstraintType ").append(internalConstraintType).append(" and EntityType ").append(entityType).append(".").toString());
        ConstraintType constraintType = (ConstraintType)tuple2._1();
        EntityType entityType5 = (EntityType)tuple2._2();
        if (!ConstraintType.EXISTS.equals(constraintType)) throw new IllegalStateException(new StringBuilder(64).append("Invalid constraint combination: ConstraintType ").append(internalConstraintType).append(" and EntityType ").append(entityType).append(".").toString());
        if (!EntityType.RELATIONSHIP.equals(entityType5)) throw new IllegalStateException(new StringBuilder(64).append("Invalid constraint combination: ConstraintType ").append(internalConstraintType).append(" and EntityType ").append(entityType).append(".").toString());
        return new RelExistsConstraints(RelExistsConstraints$.MODULE$.apply$default$1());
    }

    public ShowConstraintsCommand apply(ShowConstraintType constraintType, boolean verbose, Set<ShowColumn> columns) {
        return new ShowConstraintsCommand(constraintType, verbose, columns);
    }

    public Option<Tuple3<ShowConstraintType, Object, Set<ShowColumn>>> unapply(ShowConstraintsCommand x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.constraintType(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.verbose()), x$0.columns()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ShowConstraintsCommand$() {
        MODULE$ = this;
    }
}

