/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation;

import java.io.Serializable;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import org.neo4j.cypher.internal.runtime.ExecutionContext;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.AggregationFunction;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.NumericOrDurationAggregationExpression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.NumericOrDurationAggregationExpression$AggregatingDurations$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.NumericOrDurationAggregationExpression$AggregatingNumbers$;
import org.neo4j.exceptions.InternalException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.utils.ValueMath;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001B\u0001\u0003\u0001M\u00111\"\u0011<h\rVt7\r^5p]*\u00111\u0001B\u0001\fC\u001e<'/Z4bi&|gN\u0003\u0002\u0006\r\u0005)\u0001/\u001b9fg*\u0011q\u0001C\u0001\fS:$XM\u001d9sKR,GM\u0003\u0002\n\u0015\u00059!/\u001e8uS6,'BA\u0006\r\u0003!Ig\u000e^3s]\u0006d'BA\u0007\u000f\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011q\u0002E\u0001\u0006]\u0016|GG\u001b\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0006\r\u0011\u0005U1R\"\u0001\u0002\n\u0005]\u0011!aE!hOJ,w-\u0019;j_:4UO\\2uS>t\u0007CA\u000b\u001a\u0013\tQ\"A\u0001\u0014Ok6,'/[2Pe\u0012+(/\u0019;j_:\fum\u001a:fO\u0006$\u0018n\u001c8FqB\u0014Xm]:j_:D\u0001\u0002\b\u0001\u0003\u0006\u0004%\t!H\u0001\u0006m\u0006dW/Z\u000b\u0002=A\u0011q\u0004J\u0007\u0002A)\u0011\u0011EI\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002$\r\u0005A1m\\7nC:$7/\u0003\u0002&A\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u0011\u001d\u0002!\u0011!Q\u0001\ny\taA^1mk\u0016\u0004\u0003\"B\u0015\u0001\t\u0003Q\u0013A\u0002\u001fj]&$h\b\u0006\u0002,YA\u0011Q\u0003\u0001\u0005\u00069!\u0002\rA\b\u0005\u0006]\u0001!\taL\u0001\u0005]\u0006lW-F\u00011!\t\td'D\u00013\u0015\t\u0019D'\u0001\u0003mC:<'\"A\u001b\u0002\t)\fg/Y\u0005\u0003oI\u0012aa\u0015;sS:<\u0007bB\u001d\u0001\u0001\u0004%IAO\u0001\u0006G>,h\u000e^\u000b\u0002wA\u0011AhP\u0007\u0002{)\ta(A\u0003tG\u0006d\u0017-\u0003\u0002A{\t!Aj\u001c8h\u0011\u001d\u0011\u0005\u00011A\u0005\n\r\u000b\u0011bY8v]R|F%Z9\u0015\u0005\u0011;\u0005C\u0001\u001fF\u0013\t1UH\u0001\u0003V]&$\bb\u0002%B\u0003\u0003\u0005\raO\u0001\u0004q\u0012\n\u0004B\u0002&\u0001A\u0003&1(\u0001\u0004d_VtG\u000f\t\u0005\b\u0019\u0002\u0001\r\u0011\"\u0003N\u0003AiwN\u001c;igJ+hN\\5oO\u00063x-F\u0001O!\tat*\u0003\u0002Q{\t1Ai\\;cY\u0016DqA\u0015\u0001A\u0002\u0013%1+\u0001\u000bn_:$\bn\u001d*v]:LgnZ!wO~#S-\u001d\u000b\u0003\tRCq\u0001S)\u0002\u0002\u0003\u0007a\n\u0003\u0004W\u0001\u0001\u0006KAT\u0001\u0012[>tG\u000f[:Sk:t\u0017N\\4Bm\u001e\u0004\u0003b\u0002-\u0001\u0001\u0004%I!T\u0001\u000fI\u0006L8OU;o]&tw-\u0011<h\u0011\u001dQ\u0006\u00011A\u0005\nm\u000b!\u0003Z1zgJ+hN\\5oO\u00063xm\u0018\u0013fcR\u0011A\t\u0018\u0005\b\u0011f\u000b\t\u00111\u0001O\u0011\u0019q\u0006\u0001)Q\u0005\u001d\u0006yA-Y=t%Vtg.\u001b8h\u0003Z<\u0007\u0005C\u0004a\u0001\u0001\u0007I\u0011B'\u0002#M,7m\u001c8egJ+hN\\5oO\u00063x\rC\u0004c\u0001\u0001\u0007I\u0011B2\u0002+M,7m\u001c8egJ+hN\\5oO\u00063xm\u0018\u0013fcR\u0011A\t\u001a\u0005\b\u0011\u0006\f\t\u00111\u0001O\u0011\u00191\u0007\u0001)Q\u0005\u001d\u0006\u00112/Z2p]\u0012\u001c(+\u001e8oS:<\u0017I^4!\u0011\u001dA\u0007\u00011A\u0005\n5\u000bqB\\1o_N\u0014VO\u001c8j]\u001e\feo\u001a\u0005\bU\u0002\u0001\r\u0011\"\u0003l\u0003Mq\u0017M\\8t%Vtg.\u001b8h\u0003Z<w\fJ3r)\t!E\u000eC\u0004IS\u0006\u0005\t\u0019\u0001(\t\r9\u0004\u0001\u0015)\u0003O\u0003Aq\u0017M\\8t%Vtg.\u001b8h\u0003Z<\u0007\u0005C\u0003q\u0001\u0011\u0005\u0013/\u0001\u0004sKN,H\u000e\u001e\u000b\u0003ej\u0004\"a\u001d=\u000e\u0003QT!!\u001e<\u0002\u0011M$xN]1cY\u0016T!a\u001e\b\u0002\rY\fG.^3t\u0013\tIHOA\u0003WC2,X\rC\u0003|_\u0002\u0007A0A\u0003ti\u0006$X\r\u0005\u0002~}6\tA!\u0003\u0002\u0000\t\tQ\u0011+^3ssN#\u0018\r^3\t\u000f\u0005\r\u0001\u0001\"\u0011\u0002\u0006\u0005)\u0011\r\u001d9msR)A)a\u0002\u0002\u0014!A\u0011\u0011BA\u0001\u0001\u0004\tY!\u0001\u0003eCR\f\u0007\u0003BA\u0007\u0003\u001fi\u0011\u0001C\u0005\u0004\u0003#A!\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011\u0019Y\u0018\u0011\u0001a\u0001y\"9\u0011q\u0003\u0001\u0005\u0002\u0005e\u0011AE1qa2Lh+\u00197vK\u0012K'/Z2uYf$2\u0001RA\u000e\u0011!\ti\"!\u0006A\u0002\u0005}\u0011A\u0001<m!\u0011\t\t#a\t\u000e\u0003YL1!!\nw\u0005!\te.\u001f,bYV,\u0007BBA\u0015\u0001\u0011\u0005!(\u0001\nbO\u001e\u0014XmZ1uK\u0012\u0014vn^\"pk:$\b")
public class AvgFunction
extends AggregationFunction
implements NumericOrDurationAggregationExpression {
    private final Expression value;
    private long count;
    private double monthsRunningAvg;
    private double daysRunningAvg;
    private double secondsRunningAvg;
    private double nanosRunningAvg;
    private volatile NumericOrDurationAggregationExpression$AggregatingNumbers$ AggregatingNumbers$module;
    private volatile NumericOrDurationAggregationExpression$AggregatingDurations$ AggregatingDurations$module;
    private NumberValue sumNumber;
    private DurationValue sumDuration;
    private Option<NumericOrDurationAggregationExpression.AggregatingType> aggregatingType;

    @Override
    public void actOnNumberOrDuration(AnyValue vl, Function1<NumberValue, BoxedUnit> aggNumber, Function1<DurationValue, BoxedUnit> aggDuration) {
        NumericOrDurationAggregationExpression.actOnNumberOrDuration$(this, vl, aggNumber, aggDuration);
    }

    @Override
    public NumericOrDurationAggregationExpression$AggregatingNumbers$ AggregatingNumbers() {
        if (this.AggregatingNumbers$module == null) {
            this.AggregatingNumbers$lzycompute$1();
        }
        return this.AggregatingNumbers$module;
    }

    @Override
    public NumericOrDurationAggregationExpression$AggregatingDurations$ AggregatingDurations() {
        if (this.AggregatingDurations$module == null) {
            this.AggregatingDurations$lzycompute$1();
        }
        return this.AggregatingDurations$module;
    }

    @Override
    public NumberValue sumNumber() {
        return this.sumNumber;
    }

    @Override
    public void sumNumber_$eq(NumberValue x$1) {
        this.sumNumber = x$1;
    }

    @Override
    public DurationValue sumDuration() {
        return this.sumDuration;
    }

    @Override
    public void sumDuration_$eq(DurationValue x$1) {
        this.sumDuration = x$1;
    }

    @Override
    public Option<NumericOrDurationAggregationExpression.AggregatingType> aggregatingType() {
        return this.aggregatingType;
    }

    @Override
    public void aggregatingType_$eq(Option<NumericOrDurationAggregationExpression.AggregatingType> x$1) {
        this.aggregatingType = x$1;
    }

    @Override
    public Expression value() {
        return this.value;
    }

    @Override
    public String name() {
        return "AVG";
    }

    private long count() {
        return this.count;
    }

    private void count_$eq(long x$1) {
        this.count = x$1;
    }

    private double monthsRunningAvg() {
        return this.monthsRunningAvg;
    }

    private void monthsRunningAvg_$eq(double x$1) {
        this.monthsRunningAvg = x$1;
    }

    private double daysRunningAvg() {
        return this.daysRunningAvg;
    }

    private void daysRunningAvg_$eq(double x$1) {
        this.daysRunningAvg = x$1;
    }

    private double secondsRunningAvg() {
        return this.secondsRunningAvg;
    }

    private void secondsRunningAvg_$eq(double x$1) {
        this.secondsRunningAvg = x$1;
    }

    private double nanosRunningAvg() {
        return this.nanosRunningAvg;
    }

    private void nanosRunningAvg_$eq(double x$1) {
        this.nanosRunningAvg = x$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Value result(QueryState state) {
        boolean bl = false;
        Some some = null;
        Option<NumericOrDurationAggregationExpression.AggregatingType> option = this.aggregatingType();
        if (None$.MODULE$.equals(option)) {
            return Values.NO_VALUE;
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            NumericOrDurationAggregationExpression.AggregatingType aggregatingType = (NumericOrDurationAggregationExpression.AggregatingType)some.value();
            if (this.AggregatingNumbers().equals(aggregatingType)) {
                return this.sumNumber();
            }
        }
        if (!bl) throw new InternalException(new StringBuilder(25).append("invalid aggregation type ").append(this.aggregatingType()).toString());
        NumericOrDurationAggregationExpression.AggregatingType aggregatingType = (NumericOrDurationAggregationExpression.AggregatingType)some.value();
        if (!this.AggregatingDurations().equals(aggregatingType)) throw new InternalException(new StringBuilder(25).append("invalid aggregation type ").append(this.aggregatingType()).toString());
        return DurationValue.approximate((double)this.monthsRunningAvg(), (double)this.daysRunningAvg(), (double)this.secondsRunningAvg(), (double)this.nanosRunningAvg()).normalize();
    }

    @Override
    public void apply(ExecutionContext data, QueryState state) {
        AnyValue vl = this.value().apply(data, state);
        this.applyValueDirectly(vl);
    }

    public void applyValueDirectly(AnyValue vl) {
        this.actOnNumberOrDuration(vl, (Function1<NumberValue, BoxedUnit>)(Function1 & Serializable & scala.Serializable)number -> {
            AvgFunction.$anonfun$applyValueDirectly$1(this, number);
            return BoxedUnit.UNIT;
        }, (Function1<DurationValue, BoxedUnit>)(Function1 & Serializable & scala.Serializable)duration -> {
            AvgFunction.$anonfun$applyValueDirectly$2(this, duration);
            return BoxedUnit.UNIT;
        });
    }

    public long aggregatedRowCount() {
        return this.count();
    }

    private final void AggregatingNumbers$lzycompute$1() {
        AvgFunction avgFunction = this;
        synchronized (avgFunction) {
            if (this.AggregatingNumbers$module == null) {
                this.AggregatingNumbers$module = new NumericOrDurationAggregationExpression$AggregatingNumbers$(this);
            }
        }
    }

    private final void AggregatingDurations$lzycompute$1() {
        AvgFunction avgFunction = this;
        synchronized (avgFunction) {
            if (this.AggregatingDurations$module == null) {
                this.AggregatingDurations$module = new NumericOrDurationAggregationExpression$AggregatingDurations$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$applyValueDirectly$1(AvgFunction $this, NumberValue number) {
        $this.count_$eq($this.count() + 1L);
        NumberValue diff = number.minus($this.sumNumber());
        NumberValue next = diff.dividedBy((double)$this.count());
        $this.sumNumber_$eq(ValueMath.overflowSafeAdd((NumberValue)$this.sumNumber(), (NumberValue)next));
    }

    public static final /* synthetic */ void $anonfun$applyValueDirectly$2(AvgFunction $this, DurationValue duration) {
        $this.count_$eq($this.count() + 1L);
        $this.monthsRunningAvg_$eq($this.monthsRunningAvg() + ((double)duration.get((TemporalUnit)ChronoUnit.MONTHS) - $this.monthsRunningAvg()) / (double)$this.count());
        $this.daysRunningAvg_$eq($this.daysRunningAvg() + ((double)duration.get((TemporalUnit)ChronoUnit.DAYS) - $this.daysRunningAvg()) / (double)$this.count());
        $this.secondsRunningAvg_$eq($this.secondsRunningAvg() + ((double)duration.get((TemporalUnit)ChronoUnit.SECONDS) - $this.secondsRunningAvg()) / (double)$this.count());
        $this.nanosRunningAvg_$eq($this.nanosRunningAvg() + ((double)duration.get((TemporalUnit)ChronoUnit.NANOS) - $this.nanosRunningAvg()) / (double)$this.count());
    }

    public AvgFunction(Expression value) {
        this.value = value;
        NumericOrDurationAggregationExpression.$init$(this);
        this.count = 0L;
        this.monthsRunningAvg = 0.0;
        this.daysRunningAvg = 0.0;
        this.secondsRunningAvg = 0.0;
        this.nanosRunningAvg = 0.0;
    }
}

