/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.pipes;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.cypher.internal.ast.SubqueryCall;
import org.neo4j.cypher.internal.runtime.QueryStatistics;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.ExponentialBackoffRetryLogic;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.ExponentialBackoffRetryLogic$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.NonRecoverableError$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.OnErrorBreakTxPipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.OnErrorContinueTxPipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.OnErrorFailTxPipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.OnErrorRetryThenBreakTxPipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.OnErrorRetryThenContinueTxPipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.OnErrorRetryThenFailTxPipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.Pipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.PipeHelper$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.RetryDecision;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.RetryDecision$NotApplicable$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.RetryDecision$NotRetryable$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.RetryDecision$RetryTimeout$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.Rollback;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.TransactionBatch;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.TransactionPipeWrapper;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.TransactionRetryLogic;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.TransactionRetryPolicy;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.TransactionStatus;
import org.neo4j.cypher.internal.runtime.interpreted.profiler.InterpretedProfileInformation;
import org.neo4j.exceptions.CypherExecutionInterruptedException;
import org.neo4j.exceptions.InternalException;
import org.neo4j.exceptions.TransactionRetryAbortedException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.logging.InternalLog;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;

public final class TransactionPipeWrapper$ {
    public static final TransactionPipeWrapper$ MODULE$ = new TransactionPipeWrapper$();

    public TransactionPipeWrapper apply(SubqueryCall.InTransactionsOnErrorBehaviour error, int outerId, Pipe inner, boolean concurrentAccess, Option<TransactionRetryLogic> retryLogic) {
        SubqueryCall.InTransactionsOnErrorBehaviour inTransactionsOnErrorBehaviour;
        SubqueryCall.InTransactionsOnErrorBehaviour inTransactionsOnErrorBehaviour2;
        SubqueryCall.InTransactionsOnErrorBehaviour inTransactionsOnErrorBehaviour3;
        SubqueryCall.InTransactionsOnErrorBehaviour inTransactionsOnErrorBehaviour4;
        Tuple2 tuple2 = new Tuple2((Object)error, retryLogic);
        if (tuple2 != null && SubqueryCall.InTransactionsOnErrorBehaviour$.OnErrorContinue$.MODULE$.equals(inTransactionsOnErrorBehaviour4 = (SubqueryCall.InTransactionsOnErrorBehaviour)tuple2._1())) {
            return new OnErrorContinueTxPipe(outerId, inner, concurrentAccess);
        }
        if (tuple2 != null && SubqueryCall.InTransactionsOnErrorBehaviour$.OnErrorBreak$.MODULE$.equals(inTransactionsOnErrorBehaviour3 = (SubqueryCall.InTransactionsOnErrorBehaviour)tuple2._1())) {
            return new OnErrorBreakTxPipe(outerId, inner, concurrentAccess);
        }
        if (tuple2 != null && SubqueryCall.InTransactionsOnErrorBehaviour$.OnErrorFail$.MODULE$.equals(inTransactionsOnErrorBehaviour2 = (SubqueryCall.InTransactionsOnErrorBehaviour)tuple2._1()) && concurrentAccess) {
            return new OnErrorBreakTxPipe(outerId, inner, concurrentAccess);
        }
        if (tuple2 != null && SubqueryCall.InTransactionsOnErrorBehaviour$.OnErrorFail$.MODULE$.equals(inTransactionsOnErrorBehaviour = (SubqueryCall.InTransactionsOnErrorBehaviour)tuple2._1())) {
            return new OnErrorFailTxPipe(outerId, inner, concurrentAccess);
        }
        if (tuple2 != null) {
            SubqueryCall.InTransactionsOnErrorBehaviour inTransactionsOnErrorBehaviour5 = (SubqueryCall.InTransactionsOnErrorBehaviour)tuple2._1();
            Option option = (Option)tuple2._2();
            if (SubqueryCall.InTransactionsOnErrorBehaviour$.OnErrorRetryThenContinue$.MODULE$.equals(inTransactionsOnErrorBehaviour5) && option instanceof Some) {
                Some some = (Some)option;
                TransactionRetryLogic retryLogic2 = (TransactionRetryLogic)some.value();
                return new OnErrorRetryThenContinueTxPipe(outerId, inner, concurrentAccess, retryLogic2);
            }
        }
        if (tuple2 != null) {
            SubqueryCall.InTransactionsOnErrorBehaviour inTransactionsOnErrorBehaviour6 = (SubqueryCall.InTransactionsOnErrorBehaviour)tuple2._1();
            Option option = (Option)tuple2._2();
            if (SubqueryCall.InTransactionsOnErrorBehaviour$.OnErrorRetryThenBreak$.MODULE$.equals(inTransactionsOnErrorBehaviour6) && option instanceof Some) {
                Some some = (Some)option;
                TransactionRetryLogic retryLogic3 = (TransactionRetryLogic)some.value();
                return new OnErrorRetryThenBreakTxPipe(outerId, inner, concurrentAccess, retryLogic3);
            }
        }
        if (tuple2 != null) {
            SubqueryCall.InTransactionsOnErrorBehaviour inTransactionsOnErrorBehaviour7 = (SubqueryCall.InTransactionsOnErrorBehaviour)tuple2._1();
            Option option = (Option)tuple2._2();
            if (SubqueryCall.InTransactionsOnErrorBehaviour$.OnErrorRetryThenFail$.MODULE$.equals(inTransactionsOnErrorBehaviour7) && option instanceof Some) {
                Some some = (Some)option;
                TransactionRetryLogic retryLogic4 = (TransactionRetryLogic)some.value();
                return new OnErrorRetryThenFailTxPipe(outerId, inner, concurrentAccess, retryLogic4);
            }
        }
        throw new UnsupportedOperationException("Unsupported error behaviour " + error + " with retry logic " + retryLogic);
    }

    public long evaluateBatchSize(Expression batchSize, QueryState state) {
        return PipeHelper$.MODULE$.evaluateStaticLongOrThrow(batchSize, 1L, state, "OF ... ROWS", " Must be a positive integer.");
    }

    public long evaluateConcurrency(Option<Expression> concurrency, QueryState state) {
        int effectiveConcurrency;
        block4: {
            long l;
            Option<Expression> option = concurrency;
            if (option instanceof Some) {
                Some some = (Some)option;
                Expression c = (Expression)some.value();
                l = PipeHelper$.MODULE$.evaluateStaticLongOrThrow(c, Long.MIN_VALUE, state, "IN ... CONCURRENT TRANSACTIONS", "");
            } else if (None$.MODULE$.equals(option)) {
                l = 0L;
            } else {
                throw new MatchError(option);
            }
            long concurrencyLong = l;
            int numberOfProcessors = Runtime.getRuntime().availableProcessors();
            int maxConcurrency = numberOfProcessors * 20;
            effectiveConcurrency = Math.clamp(concurrencyLong, Integer.MIN_VALUE, maxConcurrency);
            if (effectiveConcurrency > 0) break block4;
            effectiveConcurrency = Math.max(numberOfProcessors + effectiveConcurrency, 1);
        }
        return effectiveConcurrency;
    }

    public void assertTransactionStateIsEmpty(QueryState state) {
        if (state.query().transactionalContext().dataRead().transactionStateHasChanges()) {
            throw InternalException.internalError((String)this.getClass().getSimpleName(), (String)"Expected transaction state to be empty when calling transactional subquery.");
        }
    }

    public void org$neo4j$cypher$internal$runtime$interpreted$pipes$TransactionPipeWrapper$$logError(QueryState state, String innerTxId, Throwable t) {
        String outerTxId = state.query().transactionalContext().userTransactionId();
        InternalLog log = state.query().logProvider().getLog(this.getClass());
        log.info("Recover error in inner transaction " + innerTxId + " (outer transaction " + outerTxId + ")", t);
    }

    public Option<TransactionRetryLogic> createRetryLogic(SubqueryCall.InTransactionsOnErrorBehaviour onErrorBehaviour, TransactionRetryPolicy retryPolicy, QueryState state) {
        SubqueryCall.InTransactionsOnErrorBehaviour inTransactionsOnErrorBehaviour = onErrorBehaviour;
        if (SubqueryCall.InTransactionsOnErrorBehaviour$.OnErrorRetryThenContinue$.MODULE$.equals(inTransactionsOnErrorBehaviour) ? true : (SubqueryCall.InTransactionsOnErrorBehaviour$.OnErrorRetryThenBreak$.MODULE$.equals(inTransactionsOnErrorBehaviour) ? true : SubqueryCall.InTransactionsOnErrorBehaviour$.OnErrorRetryThenFail$.MODULE$.equals(inTransactionsOnErrorBehaviour))) {
            TransactionRetryPolicy transactionRetryPolicy = retryPolicy;
            if (transactionRetryPolicy instanceof TransactionRetryPolicy.RetryFor) {
                TransactionRetryPolicy.RetryFor retryFor = (TransactionRetryPolicy.RetryFor)transactionRetryPolicy;
                Option<Expression> maybeDurationInSeconds = retryFor.maybeDurationInSeconds();
                long maxRetryTimeNanos = this.evaluateRetryTimeoutNanos(maybeDurationInSeconds, state);
                return new Some((Object)new ExponentialBackoffRetryLogic(maxRetryTimeNanos, ExponentialBackoffRetryLogic$.MODULE$.$lessinit$greater$default$2(), ExponentialBackoffRetryLogic$.MODULE$.$lessinit$greater$default$3(), ExponentialBackoffRetryLogic$.MODULE$.$lessinit$greater$default$4(), ExponentialBackoffRetryLogic$.MODULE$.$lessinit$greater$default$5()));
            }
            throw new IllegalArgumentException("Unsupported retry policy " + retryPolicy);
        }
        return None$.MODULE$;
    }

    public long evaluateRetryTimeoutNanos(Option<Expression> retryTimeout, QueryState state) {
        Option<Expression> option = retryTimeout;
        if (option instanceof Some) {
            Some some = (Some)option;
            Expression t = (Expression)some.value();
            return PipeHelper$.MODULE$.evaluateStaticSecondsToNanosOrThrow(t, 0L, state, "FOR ... SECONDS", "");
        }
        if (None$.MODULE$.equals(option)) {
            return ((Duration)state.query().getConfig().get(GraphDatabaseSettings.cypher_default_subquery_transaction_retry_timeout)).toNanos();
        }
        throw new MatchError(option);
    }

    public void updateStatisticsAndProfileInformation(TransactionStatus status, QueryState queryState) {
        InterpretedProfileInformation profileInformation;
        QueryStatistics statistics = status.queryStatistics();
        if (statistics != null) {
            queryState.query().addStatistics(statistics);
        }
        if ((profileInformation = status.profileInformation()) != null) {
            queryState.profileInformation().merge(profileInformation);
            return;
        }
    }

    public Tuple2<TransactionStatus, Throwable> handleRetry(RetryDecision retryDecision, TransactionStatus resultStatus, SubqueryCall.InTransactionsOnErrorBehaviour onErrorBehaviour, TransactionBatch batch) {
        TransactionStatus transactionStatus;
        Tuple3 tuple3 = new Tuple3((Object)resultStatus, (Object)onErrorBehaviour, (Object)retryDecision);
        if (tuple3 != null) {
            TransactionStatus transactionStatus2 = (TransactionStatus)tuple3._1();
            SubqueryCall.InTransactionsOnErrorBehaviour inTransactionsOnErrorBehaviour = (SubqueryCall.InTransactionsOnErrorBehaviour)tuple3._2();
            RetryDecision retryDecision2 = (RetryDecision)tuple3._3();
            if (transactionStatus2 instanceof Rollback) {
                Rollback rollback = (Rollback)transactionStatus2;
                Throwable failure = rollback.failure();
                if (SubqueryCall.InTransactionsOnErrorBehaviour$.OnErrorRetryThenFail$.MODULE$.equals(inTransactionsOnErrorBehaviour) && RetryDecision$RetryTimeout$.MODULE$.equals(retryDecision2)) {
                    return new Tuple2((Object)resultStatus, (Object)TransactionRetryAbortedException.transactionRetryAborted((Throwable)failure, (int)batch.retriedCount(), (double)batch.retryTimeout().toUnit(TimeUnit.SECONDS)));
                }
            }
        }
        if (tuple3 != null) {
            Rollback rollback;
            Throwable ex;
            TransactionStatus transactionStatus3 = (TransactionStatus)tuple3._1();
            SubqueryCall.InTransactionsOnErrorBehaviour inTransactionsOnErrorBehaviour = (SubqueryCall.InTransactionsOnErrorBehaviour)tuple3._2();
            if (transactionStatus3 instanceof Rollback && (ex = (rollback = (Rollback)transactionStatus3).failure()) instanceof CypherExecutionInterruptedException) {
                CypherExecutionInterruptedException cypherExecutionInterruptedException = (CypherExecutionInterruptedException)ex;
                if (SubqueryCall.InTransactionsOnErrorBehaviour$.OnErrorRetryThenFail$.MODULE$.equals(inTransactionsOnErrorBehaviour)) {
                    Status status = cypherExecutionInterruptedException.status();
                    Status.Transaction transaction = Status.Transaction.QueryExecutionFailedOnTransaction;
                    if (!(status != null ? !status.equals(transaction) : transaction != null)) {
                        return new Tuple2((Object)resultStatus, null);
                    }
                }
            }
        }
        if (tuple3 != null) {
            TransactionStatus transactionStatus4 = (TransactionStatus)tuple3._1();
            SubqueryCall.InTransactionsOnErrorBehaviour inTransactionsOnErrorBehaviour = (SubqueryCall.InTransactionsOnErrorBehaviour)tuple3._2();
            RetryDecision retryDecision3 = (RetryDecision)tuple3._3();
            if (transactionStatus4 instanceof Rollback) {
                Rollback rollback = (Rollback)transactionStatus4;
                Throwable failure = rollback.failure();
                if (SubqueryCall.InTransactionsOnErrorBehaviour$.OnErrorRetryThenFail$.MODULE$.equals(inTransactionsOnErrorBehaviour) && (RetryDecision$NotRetryable$.MODULE$.equals(retryDecision3) ? true : RetryDecision$NotApplicable$.MODULE$.equals(retryDecision3))) {
                    return new Tuple2((Object)resultStatus, (Object)failure);
                }
            }
        }
        if (tuple3 != null) {
            TransactionStatus transactionStatus5 = (TransactionStatus)tuple3._1();
            SubqueryCall.InTransactionsOnErrorBehaviour inTransactionsOnErrorBehaviour = (SubqueryCall.InTransactionsOnErrorBehaviour)tuple3._2();
            if (transactionStatus5 instanceof Rollback) {
                Rollback rollback = (Rollback)transactionStatus5;
                Throwable failure = rollback.failure();
                if (SubqueryCall.InTransactionsOnErrorBehaviour$.OnErrorFail$.MODULE$.equals(inTransactionsOnErrorBehaviour)) {
                    return new Tuple2((Object)resultStatus, (Object)failure);
                }
            }
        }
        if (tuple3 != null) {
            TransactionStatus r = (TransactionStatus)tuple3._1();
            SubqueryCall.InTransactionsOnErrorBehaviour inTransactionsOnErrorBehaviour = (SubqueryCall.InTransactionsOnErrorBehaviour)tuple3._2();
            RetryDecision retryDecision4 = (RetryDecision)tuple3._3();
            if (r instanceof Rollback) {
                Rollback rollback = (Rollback)r;
                Throwable failure = rollback.failure();
                if ((SubqueryCall.InTransactionsOnErrorBehaviour$.OnErrorRetryThenBreak$.MODULE$.equals(inTransactionsOnErrorBehaviour) ? true : SubqueryCall.InTransactionsOnErrorBehaviour$.OnErrorRetryThenContinue$.MODULE$.equals(inTransactionsOnErrorBehaviour)) && RetryDecision$RetryTimeout$.MODULE$.equals(retryDecision4)) {
                    TransactionRetryAbortedException x$1 = TransactionRetryAbortedException.transactionRetryAborted((Throwable)failure, (int)batch.retriedCount(), (double)batch.retryTimeout().toUnit(TimeUnit.SECONDS));
                    String x$2 = rollback.copy$default$1();
                    QueryStatistics x$3 = rollback.copy$default$3();
                    InterpretedProfileInformation x$4 = rollback.copy$default$4();
                    return new Tuple2((Object)rollback.copy(x$2, (Throwable)x$1, x$3, x$4), null);
                }
            }
        }
        if (tuple3 != null && NonRecoverableError$.MODULE$.equals(transactionStatus = (TransactionStatus)tuple3._1())) {
            throw new IllegalStateException("Unexpected handling of non-recoverable error status");
        }
        return new Tuple2((Object)resultStatus, null);
    }

    private TransactionPipeWrapper$() {
    }
}

