/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.pipes;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.SubqueryCall;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.Commit;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.NotRun$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.Pipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.Rollback;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.TransactionForeachPipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.TransactionRetryPolicy;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.TransactionStatus;
import org.neo4j.cypher.internal.util.attribution.Id$;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.NoValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple6;
import scala.runtime.ModuleSerializationProxy;

public final class TransactionForeachPipe$
implements Serializable {
    public static final TransactionForeachPipe$ MODULE$ = new TransactionForeachPipe$();
    private static final MapValue notRunStatus = MODULE$.statusMap((Option<String>)None$.MODULE$, false, false, (Option<String>)None$.MODULE$);

    public int $lessinit$greater$default$7(Pipe source, Pipe inner, Expression batchSize, SubqueryCall.InTransactionsOnErrorBehaviour onErrorBehaviour, Option<String> statusVariableOpt, TransactionRetryPolicy retryPolicy) {
        return Id$.MODULE$.INVALID_ID();
    }

    private MapValue notRunStatus() {
        return notRunStatus;
    }

    public AnyValue toStatusMap(TransactionStatus status) {
        TransactionStatus transactionStatus = status;
        if (transactionStatus instanceof Commit) {
            Commit commit = (Commit)transactionStatus;
            String transactionId = commit.transactionId();
            return this.statusMap((Option<String>)new Some((Object)transactionId), true, true, (Option<String>)None$.MODULE$);
        }
        if (transactionStatus instanceof Rollback) {
            Rollback rollback = (Rollback)transactionStatus;
            String transactionId = rollback.transactionId();
            Throwable failure = rollback.failure();
            return this.statusMap((Option<String>)new Some((Object)transactionId), true, false, (Option<String>)new Some((Object)failure.getMessage()));
        }
        if (NotRun$.MODULE$.equals(transactionStatus)) {
            return this.notRunStatus();
        }
        throw new MatchError((Object)transactionStatus);
    }

    private MapValue statusMap(Option<String> txId, boolean started, boolean committed, Option<String> error) {
        MapValueBuilder builder = new MapValueBuilder(4);
        builder.add("transactionId", (AnyValue)txId.map((Function1 & Serializable)x$1 -> Values.stringValue((String)x$1)).getOrElse((Function0 & Serializable)() -> NoValue.NO_VALUE));
        builder.add("started", (AnyValue)Values.booleanValue((boolean)started));
        builder.add("committed", (AnyValue)Values.booleanValue((boolean)committed));
        builder.add("errorMessage", (AnyValue)error.map((Function1 & Serializable)x$1 -> Values.stringValue((String)x$1)).getOrElse((Function0 & Serializable)() -> NoValue.NO_VALUE));
        return builder.build();
    }

    public TransactionForeachPipe apply(Pipe source, Pipe inner, Expression batchSize, SubqueryCall.InTransactionsOnErrorBehaviour onErrorBehaviour, Option<String> statusVariableOpt, TransactionRetryPolicy retryPolicy, int id) {
        return new TransactionForeachPipe(source, inner, batchSize, onErrorBehaviour, statusVariableOpt, retryPolicy, id);
    }

    public int apply$default$7(Pipe source, Pipe inner, Expression batchSize, SubqueryCall.InTransactionsOnErrorBehaviour onErrorBehaviour, Option<String> statusVariableOpt, TransactionRetryPolicy retryPolicy) {
        return Id$.MODULE$.INVALID_ID();
    }

    public Option<Tuple6<Pipe, Pipe, Expression, SubqueryCall.InTransactionsOnErrorBehaviour, Option<String>, TransactionRetryPolicy>> unapply(TransactionForeachPipe x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple6((Object)x$0.source(), (Object)x$0.inner(), (Object)x$0.batchSize(), (Object)x$0.onErrorBehaviour(), x$0.statusVariableOpt(), (Object)x$0.retryPolicy()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TransactionForeachPipe$.class);
    }

    private TransactionForeachPipe$() {
    }
}

