/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import org.neo4j.csv.reader.BufferOverflowException;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.CharSeekers;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.csv.reader.Mark;
import org.neo4j.cypher.internal.runtime.ResourceManager;
import org.neo4j.cypher.internal.runtime.interpreted.CSVResource;
import org.neo4j.cypher.internal.runtime.interpreted.CSVResources$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.ExternalCSVResource;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.LoadCsvIterator;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.util.InsecureProtocol$;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.exceptions.CypherExecutionException;
import org.neo4j.exceptions.LoadExternalResourceException;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.lang.AutoCloseablePlus;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005-r!\u0002\t\u0012\u0011\u0003qb!\u0002\u0011\u0012\u0011\u0003\t\u0003\"\u0002\u0015\u0002\t\u0003I\u0003b\u0002\u0016\u0002\u0005\u0004%\ta\u000b\u0005\u0007_\u0005\u0001\u000b\u0011\u0002\u0017\t\u000fA\n!\u0019!C\u0001c!1Q'\u0001Q\u0001\nIBqAN\u0001C\u0002\u0013\u00051\u0006\u0003\u00048\u0003\u0001\u0006I\u0001\f\u0005\u0006q\u0005!I!\u000f\u0004\u0005AE\u0001\u0011\n\u0003\u0005Q\u0015\t\u0005\t\u0015!\u0003R\u0011\u0015A#\u0002\"\u0001V\u0011\u0015A&\u0002\"\u0011Z\u0011\u001dI(\"%A\u0005\u0002iDq!a\u0003\u000b\t\u0013\ti!\u0001\u0007D'Z\u0013Vm]8ve\u000e,7O\u0003\u0002\u0013'\u0005Y\u0011N\u001c;feB\u0014X\r^3e\u0015\t!R#A\u0004sk:$\u0018.\\3\u000b\u0005Y9\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005aI\u0012AB2za\",'O\u0003\u0002\u001b7\u0005)a.Z85U*\tA$A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002 \u00035\t\u0011C\u0001\u0007D'Z\u0013Vm]8ve\u000e,7o\u0005\u0002\u0002EA\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0010\u00021\u0011+e)Q+M)~3\u0015*\u0012'E?R+%+T%O\u0003R{%+F\u0001-!\t\u0019S&\u0003\u0002/I\t!1\t[1s\u0003e!UIR!V\u0019R{f)S#M\t~#VIU'J\u001d\u0006#vJ\u0015\u0011\u0002'\u0011+e)Q+M)~\u0013UK\u0012$F%~\u001b\u0016JW#\u0016\u0003I\u0002\"aI\u001a\n\u0005Q\"#aA%oi\u0006!B)\u0012$B+2#vLQ+G\r\u0016\u0013vlU%[\u000b\u0002\n!\u0003R#G\u0003VcEkX)V\u001fR+ul\u0011%B%\u0006\u0019B)\u0012$B+2#v,U+P)\u0016{6\tS!SA\u000511m\u001c8gS\u001e$2A\u000f\"H!\tY\u0004)D\u0001=\u0015\tid(\u0001\u0004sK\u0006$WM\u001d\u0006\u0003\u007fe\t1aY:w\u0013\t\tEHA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\u0006\u0007&\u0001\r\u0001R\u0001\u0017Y\u0016<\u0017mY=DgZ\fVo\u001c;f\u000bN\u001c\u0017\r]5oOB\u00111%R\u0005\u0003\r\u0012\u0012qAQ8pY\u0016\fg\u000eC\u0003I\u0013\u0001\u0007!'A\u0007dgZ\u0014UO\u001a4feNK'0Z\n\u0004\u0015\tR\u0005CA&O\u001b\u0005a%BA'\u0012\u0003\u0015\u0001\u0018\u000e]3t\u0013\tyEJA\nFqR,'O\\1m\u0007N3&+Z:pkJ\u001cW-A\bsKN|WO]2f\u001b\u0006t\u0017mZ3s!\t\u00116+D\u0001\u0014\u0013\t!6CA\bSKN|WO]2f\u001b\u0006t\u0017mZ3s)\t1v\u000b\u0005\u0002 \u0015!)\u0001\u000b\u0004a\u0001#\u0006qq-\u001a;DgZLE/\u001a:bi>\u0014Hc\u0002.^U>$Xo\u001e\t\u0003\u0017nK!\u0001\u0018'\u0003\u001f1{\u0017\rZ\"tm&#XM]1u_JDQAX\u0007A\u0002}\u000b\u0011\"\u001e:m'R\u0014\u0018N\\4\u0011\u0005\u0001<gBA1f!\t\u0011G%D\u0001d\u0015\t!W$\u0001\u0004=e>|GOP\u0005\u0003M\u0012\na\u0001\u0015:fI\u00164\u0017B\u00015j\u0005\u0019\u0019FO]5oO*\u0011a\r\n\u0005\u0006W6\u0001\r\u0001\\\u0001\u0006gR\fG/\u001a\t\u0003\u00176L!A\u001c'\u0003\u0015E+XM]=Ti\u0006$X\rC\u0003q\u001b\u0001\u0007\u0011/A\bgS\u0016dG\rV3s[&t\u0017\r^8s!\r\u0019#oX\u0005\u0003g\u0012\u0012aa\u00149uS>t\u0007\"B\"\u000e\u0001\u0004!\u0005\"\u0002<\u000e\u0001\u0004\u0011\u0014A\u00032vM\u001a,'oU5{K\"9\u00010\u0004I\u0001\u0002\u0004!\u0015a\u00025fC\u0012,'o]\u0001\u0019O\u0016$8i\u001d<Ji\u0016\u0014\u0018\r^8sI\u0011,g-Y;mi\u00122T#A>+\u0005\u0011c8&A?\u0011\u0007y\f9!D\u0001\u0000\u0015\u0011\t\t!a\u0001\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0003I\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0007\u0005%qPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0011d\u00195fG.4uN]+og\u0016\u001cWO]3Qe>$xnY8mgR1\u0011qBA\u000b\u0003S\u00012aIA\t\u0013\r\t\u0019\u0002\n\u0002\u0005+:LG\u000fC\u0004\u0002\u0018=\u0001\r!!\u0007\u0002\u0007U\u0014\u0018\u000e\u0005\u0003\u0002\u001c\u0005\u0015RBAA\u000f\u0015\u0011\ty\"!\t\u0002\u00079,GO\u0003\u0002\u0002$\u0005!!.\u0019<b\u0013\u0011\t9#!\b\u0003\u0007U\u0013\u0016\nC\u0003l\u001f\u0001\u0007A\u000e")
public class CSVResources
implements ExternalCSVResource {
    private final ResourceManager resourceManager;

    public static char DEFAULT_QUOTE_CHAR() {
        return CSVResources$.MODULE$.DEFAULT_QUOTE_CHAR();
    }

    public static int DEFAULT_BUFFER_SIZE() {
        return CSVResources$.MODULE$.DEFAULT_BUFFER_SIZE();
    }

    public static char DEFAULT_FIELD_TERMINATOR() {
        return CSVResources$.MODULE$.DEFAULT_FIELD_TERMINATOR();
    }

    @Override
    public LoadCsvIterator getCsvIterator(String urlString, QueryState state, Option<String> fieldTerminator, boolean legacyCsvQuoteEscaping, int bufferSize, boolean headers) {
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            URI uri = new URI(urlString);
            this.checkForUnsecureProtocols(uri, state);
            return new Tuple2((Object)uri, (Object)state.query().getImportDataConnection(uri));
        });
        if (!(try_ instanceof Success)) {
            Throwable error;
            Throwable error2;
            if (try_ instanceof Failure) {
                bl = true;
                failure = (Failure)try_;
                Throwable error3 = failure.exception();
                if (error3 instanceof AuthorizationViolationException) {
                    AuthorizationViolationException authorizationViolationException = (AuthorizationViolationException)error3;
                    throw authorizationViolationException;
                }
            }
            if (bl && (error2 = failure.exception()) instanceof URISyntaxException) {
                URISyntaxException uRISyntaxException = (URISyntaxException)error2;
                throw LoadExternalResourceException.invalidUrl((String)urlString, (Throwable)uRISyntaxException);
            }
            if (bl && (error = failure.exception()) instanceof URLAccessValidationError) {
                URLAccessValidationError uRLAccessValidationError = (URLAccessValidationError)error;
                if (uRLAccessValidationError.getMessage().contains("unknown protocol:")) {
                    throw LoadExternalResourceException.withInnerErrorMessage((String)urlString, (Throwable)uRLAccessValidationError);
                }
                throw LoadExternalResourceException.cannotLoadFromUrl((String)urlString, (Throwable)uRLAccessValidationError);
            }
            if (bl) {
                Throwable error4 = failure.exception();
                throw LoadExternalResourceException.cannotLoadFromUrl((String)urlString, (Throwable)error4);
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        Tuple2 readable = (Tuple2)success.value();
        Tuple2 tuple2 = readable;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        URI uri = (URI)tuple2._1();
        CharReadable reader = (CharReadable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)uri, (Object)reader);
        URI uri2 = (URI)tuple22._1();
        CharReadable reader2 = (CharReadable)tuple22._2();
        char delimiter = BoxesRunTime.unboxToChar((Object)fieldTerminator.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToCharacter((char)x$2.charAt(0))).getOrElse((Function0)(JFunction0.mcC.sp & Serializable)() -> CSVResources$.MODULE$.DEFAULT_FIELD_TERMINATOR()));
        CharSeeker seeker = CharSeekers.charSeeker((CharReadable)reader2, (Configuration)CSVResources$.MODULE$.org$neo4j$cypher$internal$runtime$interpreted$CSVResources$$config(legacyCsvQuoteEscaping, bufferSize), (boolean)false);
        Extractor extractor = new Extractors(delimiter).textValue();
        char intDelimiter = delimiter;
        Mark mark = new Mark();
        CSVResource resource = new CSVResource(uri2, (AutoCloseable)seeker);
        this.resourceManager.trace((AutoCloseablePlus)resource);
        return new LoadCsvIterator(null, resource, seeker, mark, intDelimiter, extractor){
            private long lastProcessed;
            private boolean readAll;
            private Value[] nextRow;
            private final CSVResource resource$1;
            private final CharSeeker seeker$1;
            private final Mark mark$1;
            private final int intDelimiter$1;
            private final Extractor extractor$1;

            public long lastProcessed() {
                return this.lastProcessed;
            }

            private void lastProcessed_$eq(long x$1) {
                this.lastProcessed = x$1;
            }

            public boolean readAll() {
                return this.readAll;
            }

            private void readAll_$eq(boolean x$1) {
                this.readAll = x$1;
            }

            public void closeMore() {
                this.resource$1.close();
            }

            private Value[] readNextRow() {
                ArrayBuffer buffer = new ArrayBuffer();
                try {
                    while (this.seeker$1.seek(this.mark$1, this.intDelimiter$1)) {
                        Value value = (Value)this.seeker$1.tryExtract(this.mark$1, this.extractor$1);
                        buffer.$plus$eq((Object)(!this.extractor$1.isEmpty((Object)value) ? value : Values.NO_VALUE));
                        if (!this.mark$1.isEndOfLine()) continue;
                        if (buffer.isEmpty()) {
                            return null;
                        }
                        return (Value[])buffer.toArray(ClassTag$.MODULE$.apply(Value.class));
                    }
                }
                catch (BufferOverflowException e) {
                    throw CypherExecutionException.csvBufferSizeOverflow((Throwable)e);
                }
                if (buffer.isEmpty()) {
                    return null;
                }
                return (Value[])buffer.toArray(ClassTag$.MODULE$.apply(Value.class));
            }

            private Value[] nextRow() {
                return this.nextRow;
            }

            private void nextRow_$eq(Value[] x$1) {
                this.nextRow = x$1;
            }

            public boolean innerHasNext() {
                return this.nextRow() != null;
            }

            public Value[] next() {
                Object object = !this.hasNext() ? package$.MODULE$.Iterator().empty().next() : BoxedUnit.UNIT;
                Value[] row = this.nextRow();
                this.nextRow_$eq(this.readNextRow());
                this.lastProcessed_$eq(this.lastProcessed() + 1L);
                this.readAll_$eq(!this.hasNext());
                return row;
            }
            {
                this.resource$1 = resource$1;
                this.seeker$1 = seeker$1;
                this.mark$1 = mark$1;
                this.intDelimiter$1 = intDelimiter$1;
                this.extractor$1 = extractor$1;
                this.lastProcessed = 0L;
                this.readAll = false;
                this.nextRow = this.readNextRow();
            }
        };
    }

    @Override
    public boolean getCsvIterator$default$6() {
        return false;
    }

    private void checkForUnsecureProtocols(URI uri, QueryState state) {
        block6: {
            String scheme = uri.getScheme().toLowerCase(Locale.ROOT);
            String string = scheme;
            switch (string == null ? 0 : string.hashCode()) {
                case 101730: {
                    if ("ftp".equals(string)) {
                        break;
                    }
                    break block6;
                }
                case 3213448: {
                    if ("http".equals(string)) {
                        break;
                    }
                    break block6;
                }
                default: {
                    break block6;
                }
            }
            state.newRuntimeNotification((InternalNotification)InsecureProtocol$.MODULE$);
        }
    }

    public CSVResources(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }
}

