/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.RendererBridge;
import org.neo4j.cypherdsl.core.ast.Visitable;

@API(status=API.Status.STABLE, since="1.0")
public enum Operator implements Visitable
{
    ADDITION("+"),
    SUBTRACTION("-"),
    UNARY_MINUS("-", Type.PREFIX),
    UNARY_PLUS("+", Type.PREFIX),
    MULTIPLICATION("*"),
    DIVISION("/"),
    MODULO_DIVISION("%"),
    EXPONENTIATION("^"),
    EQUALITY("="),
    INEQUALITY("<>"),
    LESS_THAN("<"),
    GREATER_THAN(">"),
    LESS_THAN_OR_EQUAL_TO("<="),
    GREATER_THAN_OR_EQUAL_TO(">="),
    IS_NULL("IS NULL", Type.POSTFIX),
    IS_NOT_NULL("IS NOT NULL", Type.POSTFIX),
    STARTS_WITH("STARTS WITH"),
    ENDS_WITH("ENDS WITH"),
    CONTAINS("CONTAINS"),
    AND("AND"),
    OR("OR"),
    XOR("XOR"),
    NOT("NOT", Type.PREFIX),
    CONCAT("+"),
    MATCHES("=~"),
    IN("IN"),
    SET("=", Type.PROPERTY),
    GET(".", Type.PROPERTY),
    MUTATE("+=", Type.PROPERTY),
    SET_LABEL("", Type.LABEL),
    REMOVE_LABEL("", Type.LABEL),
    ASSIGMENT("="),
    PIPE("|");

    private final String representation;
    private final Type type;

    private Operator(String representation) {
        this(representation, Type.BINARY);
    }

    private Operator(String representation, Type type) {
        this.representation = representation;
        this.type = type;
    }

    @API(status=API.Status.INTERNAL)
    public String getRepresentation() {
        return this.representation;
    }

    boolean isUnary() {
        return this.type != Type.BINARY;
    }

    @API(status=API.Status.INTERNAL)
    public Type getType() {
        return this.type;
    }

    @Override
    public String toString() {
        return RendererBridge.render(this);
    }

    public static enum Type {
        BINARY,
        PREFIX,
        POSTFIX,
        PROPERTY,
        LABEL;

    }
}

