/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.neo4j.cypherdsl.core.Literal;
import org.neo4j.cypherdsl.core.LiteralBase;

@API(status=API.Status.STABLE, since="2021.1.0")
public final class TemporalLiteral
extends LiteralBase<TemporalAccessor> {
    private final String value;

    TemporalLiteral(TemporalAccessor content) {
        super(content);
        DateTimeFormatter formatter;
        String method;
        if (content instanceof LocalDate) {
            method = "date";
            formatter = DateTimeFormatter.ISO_LOCAL_DATE;
        } else if (content instanceof LocalDateTime) {
            method = "localdatetime";
            formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        } else if (content instanceof ZonedDateTime) {
            method = "datetime";
            formatter = DateTimeFormatter.ISO_ZONED_DATE_TIME;
        } else if (content instanceof LocalTime) {
            method = "localtime";
            formatter = DateTimeFormatter.ISO_LOCAL_TIME;
        } else if (content instanceof OffsetTime) {
            method = "time";
            formatter = DateTimeFormatter.ISO_OFFSET_TIME;
        } else {
            throw new Literal.UnsupportedLiteralException(content);
        }
        this.value = String.format("%s('%s')", method, formatter.format(content));
    }

    @Override
    @NotNull
    public String asString() {
        return this.value;
    }
}

