/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.internal.StatementContext;

@API(status=API.Status.INTERNAL, since="2021.1.0")
final class StatementContextImpl
implements StatementContext {
    private final AtomicInteger parameterCount = new AtomicInteger();
    private final Map<Parameter<?>, String> parameterNames = new ConcurrentHashMap();
    private boolean renderConstantsAsParameters = false;

    StatementContextImpl() {
    }

    @Override
    public String getParameterName(Parameter parameter) {
        return this.parameterNames.computeIfAbsent(parameter, p -> p.isAnon() ? String.format("pcdsl%02d", this.parameterCount.incrementAndGet()) : p.getName());
    }

    @Override
    public boolean isRenderConstantsAsParameters() {
        return this.renderConstantsAsParameters;
    }

    void setRenderConstantsAsParameters(boolean renderConstantsAsParameters) {
        this.renderConstantsAsParameters = renderConstantsAsParameters;
    }
}

