/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.TimeZone;
import org.apiguardian.api.API;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.neo4j.cypherdsl.core.BuiltInFunctions;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.FunctionInvocation;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.NamedPath;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.NumberLiteral;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.Reduction;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.RelationshipPattern;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public final class Functions {
    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation id(@NotNull Node node) {
        Assertions.notNull(node, "The node for id() is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.ID, node.getRequiredSymbolicName());
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation id(@NotNull Relationship relationship) {
        Assertions.notNull(relationship, "The relationship for id() is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.ID, relationship.getRequiredSymbolicName());
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation keys(@NotNull Node node) {
        Assertions.notNull(node, "The node parameter is required.");
        return Functions.keys(node.getRequiredSymbolicName());
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation keys(@NotNull Relationship relationship) {
        Assertions.notNull(relationship, "The relationship parameter is required.");
        return Functions.keys(relationship.getRequiredSymbolicName());
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation keys(@NotNull Expression expression) {
        Assertions.notNull(expression, "The expression parameter is required.");
        Expression param = expression instanceof Named ? ((Named)((Object)expression)).getRequiredSymbolicName() : expression;
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Lists.KEYS, param);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation labels(@NotNull Node node) {
        Assertions.notNull(node, "The node parameter is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Lists.LABELS, node.getRequiredSymbolicName());
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation type(@NotNull Relationship relationship) {
        Assertions.notNull(relationship, "The relationship parameter is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.TYPE, relationship.getRequiredSymbolicName());
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation count(@NotNull Node node) {
        Assertions.notNull(node, "The node parameter is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Aggregates.COUNT, node.getRequiredSymbolicName());
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation count(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Aggregates.COUNT, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation countDistinct(@NotNull Node node) {
        Assertions.notNull(node, "The node parameter is required.");
        return FunctionInvocation.createDistinct(BuiltInFunctions.Aggregates.COUNT, node.getRequiredSymbolicName());
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation countDistinct(Expression expression) {
        return FunctionInvocation.createDistinct(BuiltInFunctions.Aggregates.COUNT, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation properties(Node node) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.PROPERTIES, node.getRequiredSymbolicName());
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation properties(Relationship relationship) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.PROPERTIES, relationship.getRequiredSymbolicName());
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation properties(MapExpression map) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.PROPERTIES, map);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation coalesce(Expression ... expressions) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.COALESCE, expressions);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation toLower(@NotNull Expression expression) {
        Assertions.notNull(expression, "The expression is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Strings.TO_LOWER, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation trim(@NotNull Expression expression) {
        Assertions.notNull(expression, "The expression is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Strings.TRIM, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation split(@NotNull Expression expression, @NotNull Expression delimiter) {
        Assertions.notNull(expression, "The expression is required.");
        Assertions.notNull(delimiter, "The delimiter is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Strings.SPLIT, expression, delimiter);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation split(@NotNull Expression expression, @NotNull String delimiter) {
        Assertions.notNull(expression, "The expression is required.");
        Assertions.notNull(delimiter, "The delimiter is required.");
        return Functions.split(expression, Cypher.literalOf(delimiter));
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation size(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.SIZE, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation size(RelationshipPattern pattern) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.SIZE, pattern);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation exists(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Predicates.EXISTS, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation distance(@NotNull Expression point1, @NotNull Expression point2) {
        Assertions.notNull(point1, "The distance function requires two points.");
        Assertions.notNull(point2, "The distance function requires two points.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Spatials.DISTANCE, point1, point2);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation point(MapExpression parameterMap) {
        return Functions.point((Expression)parameterMap);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation point(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Spatials.POINT, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation point(Parameter parameter) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Spatials.POINT, parameter);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation avg(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Aggregates.AVG, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation avgDistinct(Expression expression) {
        return FunctionInvocation.createDistinct(BuiltInFunctions.Aggregates.AVG, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation collect(@NotNull Named variable) {
        Assertions.notNull(variable, "The variable parameter is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Aggregates.COLLECT, variable.getRequiredSymbolicName());
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation collectDistinct(@NotNull Named variable) {
        Assertions.notNull(variable, "The variable parameter is required.");
        return FunctionInvocation.createDistinct(BuiltInFunctions.Aggregates.COLLECT, variable.getRequiredSymbolicName());
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation collect(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Aggregates.COLLECT, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation collectDistinct(Expression expression) {
        return FunctionInvocation.createDistinct(BuiltInFunctions.Aggregates.COLLECT, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation max(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Aggregates.MAX, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation maxDistinct(Expression expression) {
        return FunctionInvocation.createDistinct(BuiltInFunctions.Aggregates.MAX, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation min(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Aggregates.MIN, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation minDistinct(Expression expression) {
        return FunctionInvocation.createDistinct(BuiltInFunctions.Aggregates.MIN, expression);
    }

    private static void assertPercentileArguments(BuiltInFunctions.Aggregates builtIn, Expression expression, Number percentile) {
        Assertions.notNull(expression, "The numeric expression for " + builtIn.getImplementationName() + " is required.");
        Assertions.notNull(percentile, "The percentile for " + builtIn.getImplementationName() + " is required.");
        double p = percentile.doubleValue();
        Assertions.isTrue(p >= 0.0 && p <= 1.0, "The percentile for " + builtIn.getImplementationName() + " must be between 0.0 and 1.0.");
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation percentileCont(Expression expression, Number percentile) {
        Functions.assertPercentileArguments(BuiltInFunctions.Aggregates.PERCENTILE_CONT, expression, percentile);
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Aggregates.PERCENTILE_CONT, expression, new NumberLiteral(percentile));
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation percentileContDistinct(Expression expression, Number percentile) {
        Functions.assertPercentileArguments(BuiltInFunctions.Aggregates.PERCENTILE_CONT, expression, percentile);
        return FunctionInvocation.createDistinct(BuiltInFunctions.Aggregates.PERCENTILE_CONT, expression, new NumberLiteral(percentile));
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation percentileDisc(Expression expression, Number percentile) {
        Functions.assertPercentileArguments(BuiltInFunctions.Aggregates.PERCENTILE_DISC, expression, percentile);
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Aggregates.PERCENTILE_DISC, expression, new NumberLiteral(percentile));
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation percentileDiscDistinct(Expression expression, Number percentile) {
        Functions.assertPercentileArguments(BuiltInFunctions.Aggregates.PERCENTILE_DISC, expression, percentile);
        return FunctionInvocation.createDistinct(BuiltInFunctions.Aggregates.PERCENTILE_DISC, expression, new NumberLiteral(percentile));
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation stDev(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Aggregates.ST_DEV, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation stDevDistinct(Expression expression) {
        return FunctionInvocation.createDistinct(BuiltInFunctions.Aggregates.ST_DEV, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation stDevP(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Aggregates.ST_DEV_P, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation stDevPDistinct(Expression expression) {
        return FunctionInvocation.createDistinct(BuiltInFunctions.Aggregates.ST_DEV_P, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation sum(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Aggregates.SUM, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation sumDistinct(Expression expression) {
        return FunctionInvocation.createDistinct(BuiltInFunctions.Aggregates.SUM, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation range(Integer start, Integer end) {
        return Functions.range(Cypher.literalOf(start), Cypher.literalOf(end));
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation range(@NotNull Expression start, @NotNull Expression end) {
        return Functions.range(start, end, null);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation range(@NotNull Integer start, @NotNull Integer end, Integer step) {
        return Functions.range(Cypher.literalOf(start), Cypher.literalOf(end), Cypher.literalOf(step));
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation range(@NotNull Expression start, @NotNull Expression end, Expression step) {
        Assertions.notNull(start, "The expression for range is required.");
        Assertions.notNull(end, "The expression for range is required.");
        if (step == null) {
            return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Lists.RANGE, start, end);
        }
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Lists.RANGE, start, end, step);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation head(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.HEAD, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation last(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.LAST, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation nodes(@NotNull NamedPath path) {
        Assertions.notNull(path, "The path for nodes is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Lists.NODES, path.getSymbolicName().orElseThrow(() -> new IllegalArgumentException("The path needs to be named!")));
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation nodes(@NotNull SymbolicName symbolicName) {
        Assertions.notNull(symbolicName, "The symbolic name of the path for nodes is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Lists.NODES, symbolicName);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation relationships(@NotNull NamedPath path) {
        Assertions.notNull(path, "The path for relationships is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Lists.RELATIONSHIPS, path.getSymbolicName().orElseThrow(() -> new IllegalArgumentException("The path needs to be named!")));
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation relationships(@NotNull SymbolicName symbolicName) {
        Assertions.notNull(symbolicName, "The symbolic name of the path for relationships is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Lists.RELATIONSHIPS, symbolicName);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation startNode(@NotNull Relationship relationship) {
        Assertions.notNull(relationship, "The relationship for endNode is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.START_NODE, relationship.getSymbolicName().orElseThrow(() -> new IllegalArgumentException("The relationship needs to be named!")));
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation endNode(@NotNull Relationship relationship) {
        Assertions.notNull(relationship, "The relationship for endNode is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.END_NODE, relationship.getSymbolicName().orElseThrow(() -> new IllegalArgumentException("The relationship needs to be named!")));
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation date() {
        return FunctionInvocation.create(BuiltInFunctions.Temporals.DATE);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation calendarDate(Integer year, Integer month, Integer day) {
        Assertions.notNull(year, "The year is required.");
        Assertions.notNull(month, "The month is required.");
        Assertions.notNull(day, "The year is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DATE, Cypher.mapOf("year", Cypher.literalOf(year), "month", Cypher.literalOf(month), "day", Cypher.literalOf(day)));
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation weekDate(Integer year, Integer week, Integer dayOfWeek) {
        Assertions.notNull(year, "The year is required.");
        Object[] parameters = new Object[2 + (week == null ? 0 : 2) + (dayOfWeek == null ? 0 : 2)];
        int i = 0;
        parameters[i++] = "year";
        parameters[i++] = Cypher.literalOf(year);
        if (week != null) {
            parameters[i++] = "week";
            parameters[i++] = Cypher.literalOf(week);
        }
        if (dayOfWeek != null) {
            if (week == null) {
                throw new IllegalArgumentException("week is required when using dayOfWeek.");
            }
            parameters[i++] = "dayOfWeek";
            parameters[i++] = Cypher.literalOf(dayOfWeek);
        }
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DATE, Cypher.mapOf(parameters));
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation quarterDate(Integer year, Integer quarter, Integer dayOfQuarter) {
        Assertions.notNull(year, "The year is required.");
        Object[] parameters = new Object[2 + (quarter == null ? 0 : 2) + (dayOfQuarter == null ? 0 : 2)];
        int i = 0;
        parameters[i++] = "year";
        parameters[i++] = Cypher.literalOf(year);
        if (quarter != null) {
            parameters[i++] = "quarter";
            parameters[i++] = Cypher.literalOf(quarter);
        }
        if (dayOfQuarter != null) {
            if (dayOfQuarter == null) {
                throw new IllegalArgumentException("quarter is required when using dayOfQuarter.");
            }
            parameters[i++] = "dayOfQuarter";
            parameters[i++] = Cypher.literalOf(dayOfQuarter);
        }
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DATE, Cypher.mapOf(parameters));
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation ordinalDate(Integer year, Integer ordinalDay) {
        Assertions.notNull(year, "The year is required.");
        Object[] parameters = new Object[2 + (ordinalDay == null ? 0 : 2)];
        int i = 0;
        parameters[i++] = "year";
        parameters[i++] = Cypher.literalOf(year);
        if (ordinalDay != null) {
            parameters[i++] = "ordinalDay";
            parameters[i++] = Cypher.literalOf(ordinalDay);
        }
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DATE, Cypher.mapOf(parameters));
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation date(@NotNull MapExpression components) {
        Assertions.notNull(components, "The components is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DATE, components);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation date(@NotNull String temporalValue) {
        Assertions.hasText(temporalValue, "The temporalValue is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DATE, Cypher.literalOf(temporalValue));
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation date(@NotNull Expression temporalValue) {
        Assertions.notNull(temporalValue, "The temporalValue is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DATE, temporalValue);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation datetime() {
        return FunctionInvocation.create(BuiltInFunctions.Temporals.DATETIME);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation datetime(@NotNull TimeZone timeZone) {
        Assertions.notNull(timeZone, "The timezone is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DATETIME, Functions.timezoneMapLiteralOf(timeZone));
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation datetime(@NotNull MapExpression components) {
        Assertions.notNull(components, "The components is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DATETIME, components);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation datetime(@NotNull String temporalValue) {
        Assertions.hasText(temporalValue, "The temporalValue is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DATETIME, Cypher.literalOf(temporalValue));
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation datetime(@NotNull Expression temporalValue) {
        Assertions.notNull(temporalValue, "The temporalValue is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DATETIME, temporalValue);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation localdatetime() {
        return FunctionInvocation.create(BuiltInFunctions.Temporals.LOCALDATETIME);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation localdatetime(@NotNull TimeZone timeZone) {
        Assertions.notNull(timeZone, "The timezone is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.LOCALDATETIME, Functions.timezoneMapLiteralOf(timeZone));
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation localdatetime(@NotNull MapExpression components) {
        Assertions.notNull(components, "The components is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.LOCALDATETIME, components);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation localdatetime(@NotNull String temporalValue) {
        Assertions.hasText(temporalValue, "The temporalValue is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.LOCALDATETIME, Cypher.literalOf(temporalValue));
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation localdatetime(@NotNull Expression temporalValue) {
        Assertions.notNull(temporalValue, "The temporalValue is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.LOCALDATETIME, temporalValue);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation localtime() {
        return FunctionInvocation.create(BuiltInFunctions.Temporals.LOCALTIME);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation localtime(@NotNull TimeZone timeZone) {
        Assertions.notNull(timeZone, "The timezone is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.LOCALTIME, Functions.timezoneMapLiteralOf(timeZone));
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation localtime(@NotNull MapExpression components) {
        Assertions.notNull(components, "The components is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.LOCALTIME, components);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation localtime(@NotNull String temporalValue) {
        Assertions.hasText(temporalValue, "The temporalValue is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.LOCALTIME, Cypher.literalOf(temporalValue));
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation localtime(@NotNull Expression temporalValue) {
        Assertions.notNull(temporalValue, "The temporalValue is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.LOCALTIME, temporalValue);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation time() {
        return FunctionInvocation.create(BuiltInFunctions.Temporals.TIME);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation time(@NotNull TimeZone timeZone) {
        Assertions.notNull(timeZone, "The timezone is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.TIME, Functions.timezoneMapLiteralOf(timeZone));
    }

    private static Expression timezoneMapLiteralOf(TimeZone timeZone) {
        return Cypher.mapOf("timezone", Cypher.literalOf(timeZone.getID()));
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation time(@NotNull MapExpression components) {
        Assertions.notNull(components, "The components is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.TIME, components);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation time(@NotNull String temporalValue) {
        Assertions.hasText(temporalValue, "The temporalValue is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.TIME, Cypher.literalOf(temporalValue));
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation time(@NotNull Expression temporalValue) {
        Assertions.notNull(temporalValue, "The temporalValue is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.TIME, temporalValue);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation duration(@NotNull MapExpression components) {
        Assertions.notNull(components, "The components is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DURATION, components);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation duration(@NotNull String temporalAmount) {
        Assertions.hasText(temporalAmount, "The temporalAmount is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DURATION, Cypher.literalOf(temporalAmount));
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation duration(@NotNull Expression temporalAmount) {
        Assertions.notNull(temporalAmount, "The temporalAmount is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DURATION, temporalAmount);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation shortestPath(Relationship relationship) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.SHORTEST_PATH, relationship);
    }

    @NotNull
    @Contract(pure=true)
    public static Reduction.OngoingDefinitionWithVariable reduce(@NotNull SymbolicName variable) {
        return Reduction.of(variable);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation abs(@NotNull Expression expression) {
        Assertions.notNull(expression, "The expression is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.ABS, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation ceil(@NotNull Expression expression) {
        Assertions.notNull(expression, "The expression is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.CEIL, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation floor(@NotNull Expression expression) {
        Assertions.notNull(expression, "The expression is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.FLOOR, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation rand() {
        return FunctionInvocation.create(BuiltInFunctions.MathematicalFunctions.RAND);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation round(Expression value, Expression ... expression) {
        if (expression == null || expression.length == 0) {
            return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.ROUND, value);
        }
        if (expression.length == 1) {
            return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.ROUND, value, expression[0]);
        }
        if (expression.length == 2) {
            return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.ROUND, value, expression[0], expression[1]);
        }
        throw new IllegalArgumentException("round() must be called with 1, 2 or 3 arguments (value, value + precision or value + precision + rounding mode.");
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation sign(@NotNull Expression expression) {
        Assertions.notNull(expression, "The expression is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.SIGN, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation e() {
        return FunctionInvocation.create(BuiltInFunctions.MathematicalFunctions.E);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation exp(@NotNull Expression expression) {
        Assertions.notNull(expression, "The expression is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.EXP, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation log(@NotNull Expression expression) {
        Assertions.notNull(expression, "The expression is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.LOG, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation log10(@NotNull Expression expression) {
        Assertions.notNull(expression, "The expression is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.LOG10, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation sqrt(@NotNull Expression expression) {
        Assertions.notNull(expression, "The expression is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.SQRT, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation acos(@NotNull Expression expression) {
        Assertions.notNull(expression, "The expression is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.ACOS, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation asin(@NotNull Expression expression) {
        Assertions.notNull(expression, "The expression is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.ASIN, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation atan(@NotNull Expression expression) {
        Assertions.notNull(expression, "The expression is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.ATAN, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation atan2(@NotNull Expression y, @NotNull Expression x) {
        Assertions.notNull(y, "y is required.");
        Assertions.notNull(x, "x is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.ATAN2, y, x);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation cos(@NotNull Expression expression) {
        Assertions.notNull(expression, "The expression is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.COS, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation cot(@NotNull Expression expression) {
        Assertions.notNull(expression, "The expression is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.COT, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation degrees(@NotNull Expression expression) {
        Assertions.notNull(expression, "The expression is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.DEGREES, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation haversin(@NotNull Expression expression) {
        Assertions.notNull(expression, "The expression is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.HAVERSIN, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation pi() {
        return FunctionInvocation.create(BuiltInFunctions.MathematicalFunctions.PI);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation radians(@NotNull Expression expression) {
        Assertions.notNull(expression, "The expression is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.RADIANS, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation sin(@NotNull Expression expression) {
        Assertions.notNull(expression, "The expression is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.SIN, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation tan(@NotNull Expression expression) {
        Assertions.notNull(expression, "The expression is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.TAN, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation toInteger(@NotNull Expression expression) {
        Assertions.notNull(expression, "The expression is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.TO_INTEGER, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation toFloat(@NotNull Expression expression) {
        Assertions.notNull(expression, "The expression is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.TO_FLOAT, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation toBoolean(@NotNull Expression expression) {
        Assertions.notNull(expression, "The expression is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.TO_BOOLEAN, expression);
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation linenumber() {
        return FunctionInvocation.create(() -> "linenumber");
    }

    @NotNull
    @Contract(pure=true)
    public static FunctionInvocation file() {
        return FunctionInvocation.create(() -> "file");
    }
}

