/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Expressions;
import org.neo4j.cypherdsl.core.NestedExpression;
import org.neo4j.cypherdsl.core.Operator;
import org.neo4j.cypherdsl.core.ast.Visitor;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public final class Comparison
implements Condition {
    private final Expression left;
    private final Operator comparator;
    private final Expression right;

    static Comparison create(Operator operator, Expression expression) {
        Assertions.isTrue(operator.isUnary(), "Operator must be unary.");
        Assertions.notNull(expression, "Expression must not be null.");
        switch (operator.getType()) {
            case PREFIX: {
                return new Comparison(null, operator, expression);
            }
            case POSTFIX: {
                return new Comparison(expression, operator, null);
            }
        }
        throw new IllegalArgumentException("Invalid operator type " + (Object)((Object)operator.getType()));
    }

    static Comparison create(Expression lhs, Operator operator, Expression rhs) {
        Assertions.notNull(lhs, "Left expression must not be null.");
        Assertions.notNull(operator, "Operator must not be empty.");
        Assertions.notNull(rhs, "Right expression must not be null.");
        return new Comparison(lhs, operator, rhs);
    }

    private static Expression nestedIfCondition(Expression expression) {
        return expression instanceof Condition ? new NestedExpression(expression) : expression;
    }

    private Comparison(Expression left, Operator operator, Expression right) {
        this.left = Comparison.nestedIfCondition(left);
        this.comparator = operator;
        this.right = Comparison.nestedIfCondition(right);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        if (this.left != null) {
            Expressions.nameOrExpression(this.left).accept(visitor);
        }
        this.comparator.accept(visitor);
        if (this.right != null) {
            Expressions.nameOrExpression(this.right).accept(visitor);
        }
        visitor.leave(this);
    }
}

