/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.ExposesProperties;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.MapProjection;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.Properties;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.PropertyContainer;
import org.neo4j.cypherdsl.core.RelationshipChain;
import org.neo4j.cypherdsl.core.RelationshipLength;
import org.neo4j.cypherdsl.core.RelationshipPattern;
import org.neo4j.cypherdsl.core.RelationshipTypes;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.support.Visitable;
import org.neo4j.cypherdsl.core.support.Visitor;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public final class Relationship
implements RelationshipPattern,
PropertyContainer,
ExposesProperties<Relationship> {
    private final Node left;
    private final Node right;
    private final Details details;

    static Relationship create(Node left, Direction direction, Node right, String ... types) {
        Assertions.notNull(left, "Left node is required.");
        Assertions.notNull(right, "Right node is required.");
        List<String> listOfTypes = Arrays.stream(types).filter(type -> type != null && !type.isEmpty()).collect(Collectors.toList());
        Details details = Details.create(Optional.ofNullable(direction).orElse(Direction.UNI), null, listOfTypes.isEmpty() ? null : new RelationshipTypes(listOfTypes));
        return new Relationship(left, details, right);
    }

    Relationship(Node left, Details details, Node right) {
        this.left = left;
        this.right = right;
        this.details = details;
    }

    Node getLeft() {
        return this.left;
    }

    Node getRight() {
        return this.right;
    }

    @API(status=API.Status.INTERNAL)
    public Details getDetails() {
        return this.details;
    }

    public Relationship named(String newSymbolicName) {
        return new Relationship(this.left, this.details.named(newSymbolicName), this.right);
    }

    public Relationship named(SymbolicName newSymbolicName) {
        return new Relationship(this.left, this.details.named(newSymbolicName), this.right);
    }

    public Relationship unbounded() {
        return new Relationship(this.left, this.details.unbounded(), this.right);
    }

    public Relationship min(Integer minimum) {
        return new Relationship(this.left, this.details.min(minimum), this.right);
    }

    public Relationship max(Integer maximum) {
        return new Relationship(this.left, this.details.max(maximum), this.right);
    }

    public Relationship length(Integer minimum, Integer maximum) {
        return new Relationship(this.left, this.details.min(minimum).max(maximum), this.right);
    }

    @Override
    public Relationship withProperties(MapExpression newProperties) {
        if (newProperties == null && this.details.getProperties() == null) {
            return this;
        }
        return new Relationship(this.left, this.details.with(newProperties == null ? null : new Properties(newProperties)), this.right);
    }

    @Override
    public Relationship withProperties(Object ... keysAndValues) {
        MapExpression newProperties = null;
        if (keysAndValues != null && keysAndValues.length != 0) {
            newProperties = MapExpression.create(keysAndValues);
        }
        return this.withProperties(newProperties);
    }

    @Override
    public Property property(String ... names) {
        return Property.create(this, names);
    }

    @Override
    public Optional<SymbolicName> getSymbolicName() {
        return this.details.getSymbolicName();
    }

    @Override
    public SymbolicName getRequiredSymbolicName() {
        return this.details.getRequiredSymbolicName();
    }

    @Override
    public RelationshipChain relationshipTo(Node other, String ... types) {
        return RelationshipChain.create(this).add(this.right.relationshipTo(other, types));
    }

    @Override
    public RelationshipChain relationshipFrom(Node other, String ... types) {
        return RelationshipChain.create(this).add(this.right.relationshipFrom(other, types));
    }

    @Override
    public RelationshipChain relationshipBetween(Node other, String ... types) {
        return RelationshipChain.create(this).add(this.right.relationshipBetween(other, types));
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.left.accept(visitor);
        this.details.accept(visitor);
        this.right.accept(visitor);
        visitor.leave(this);
    }

    public MapProjection project(Object ... entries) {
        return MapProjection.create(this.getRequiredSymbolicName(), entries);
    }

    @API(status=API.Status.INTERNAL, since="1.0")
    public static final class Details
    implements Visitable {
        private final Direction direction;
        private volatile SymbolicName symbolicName;
        private final RelationshipTypes types;
        private final RelationshipLength length;
        private final Properties properties;

        static Details create(Direction direction, SymbolicName symbolicName, RelationshipTypes types) {
            return new Details(direction, symbolicName, types, null, null);
        }

        private Details(Direction direction, SymbolicName symbolicName, RelationshipTypes types, RelationshipLength length, Properties properties) {
            this.direction = direction;
            this.symbolicName = symbolicName;
            this.types = types;
            this.length = length;
            this.properties = properties;
        }

        public boolean hasContent() {
            return this.symbolicName != null || this.types != null || this.length != null || this.properties != null;
        }

        Details named(String newSymbolicName) {
            Assertions.hasText(newSymbolicName, "Symbolic name is required.");
            return this.named(SymbolicName.of(newSymbolicName));
        }

        Details named(SymbolicName newSymbolicName) {
            Assertions.notNull(newSymbolicName, "Symbolic name is required.");
            return new Details(this.direction, newSymbolicName, this.types, this.length, this.properties);
        }

        Details with(Properties newProperties) {
            return new Details(this.direction, this.symbolicName, this.types, this.length, newProperties);
        }

        Details unbounded() {
            return new Details(this.direction, this.symbolicName, this.types, new RelationshipLength(), this.properties);
        }

        Details min(Integer minimum) {
            if (minimum == null && (this.length == null || this.length.getMinimum() == null)) {
                return this;
            }
            RelationshipLength newLength = Optional.ofNullable(this.length).map(l -> new RelationshipLength(minimum, l.getMaximum())).orElseGet(() -> new RelationshipLength(minimum, null));
            return new Details(this.direction, this.symbolicName, this.types, newLength, this.properties);
        }

        Details max(Integer maximum) {
            if (maximum == null && (this.length == null || this.length.getMaximum() == null)) {
                return this;
            }
            RelationshipLength newLength = Optional.ofNullable(this.length).map(l -> new RelationshipLength(l.getMinimum(), maximum)).orElseGet(() -> new RelationshipLength(null, maximum));
            return new Details(this.direction, this.symbolicName, this.types, newLength, this.properties);
        }

        @API(status=API.Status.INTERNAL)
        public Direction getDirection() {
            return this.direction;
        }

        Optional<SymbolicName> getSymbolicName() {
            return Optional.ofNullable(this.symbolicName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SymbolicName getRequiredSymbolicName() {
            SymbolicName requiredSymbolicName = this.symbolicName;
            if (requiredSymbolicName == null) {
                Details details = this;
                synchronized (details) {
                    requiredSymbolicName = this.symbolicName;
                    if (requiredSymbolicName == null) {
                        requiredSymbolicName = this.symbolicName = SymbolicName.unresolved();
                    }
                }
            }
            return requiredSymbolicName;
        }

        @API(status=API.Status.INTERNAL)
        public RelationshipTypes getTypes() {
            return this.types;
        }

        @API(status=API.Status.INTERNAL)
        public Properties getProperties() {
            return this.properties;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.enter(this);
            Visitable.visitIfNotNull(this.symbolicName, visitor);
            Visitable.visitIfNotNull(this.types, visitor);
            Visitable.visitIfNotNull(this.length, visitor);
            Visitable.visitIfNotNull(this.properties, visitor);
            visitor.leave(this);
        }
    }

    public static enum Direction {
        LTR("-", "->"),
        RTL("<-", "-"),
        UNI("-", "-");

        private final String symbolLeft;
        private final String symbolRight;

        private Direction(String symbolLeft, String symbolRight) {
            this.symbolLeft = symbolLeft;
            this.symbolRight = symbolRight;
        }

        @API(status=API.Status.INTERNAL)
        public String getSymbolLeft() {
            return this.symbolLeft;
        }

        @API(status=API.Status.INTERNAL)
        public String getSymbolRight() {
            return this.symbolRight;
        }
    }
}

