/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Objects;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Assert;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public final class SymbolicName
implements Expression {
    private final String value;

    static SymbolicName create(String name) {
        Assert.hasText(name, "Name must not be empty.");
        Assert.isTrue(Cypher.isIdentifier(name), "Name must be a valid identifier.");
        return new SymbolicName(name);
    }

    private SymbolicName(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public SymbolicName concat(String otherValue) {
        Assert.notNull(otherValue, "Value to concat must not be null.");
        if (otherValue.isEmpty()) {
            return this;
        }
        return SymbolicName.create(this.value + otherValue);
    }

    public String toString() {
        return "SymbolicName{name='" + this.value + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SymbolicName that = (SymbolicName)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

