/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Assert;
import org.neo4j.cypherdsl.core.ExposesProperties;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.MapProjection;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.Properties;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.PropertyContainer;
import org.neo4j.cypherdsl.core.RelationshipChain;
import org.neo4j.cypherdsl.core.RelationshipDetail;
import org.neo4j.cypherdsl.core.RelationshipPattern;
import org.neo4j.cypherdsl.core.RelationshipTypes;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.support.Visitor;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public final class Relationship
implements RelationshipPattern,
PropertyContainer,
ExposesProperties<Relationship> {
    private final Node left;
    private final Node right;
    private final RelationshipDetail details;

    static Relationship create(Node left, Direction direction, Node right, String ... types) {
        Assert.notNull(left, "Left node is required.");
        Assert.notNull(right, "Right node is required.");
        List<String> listOfTypes = Arrays.stream(types).filter(type -> type != null && !type.isEmpty()).collect(Collectors.toList());
        RelationshipDetail details = RelationshipDetail.create(Optional.ofNullable(direction).orElse(Direction.UNI), null, listOfTypes.isEmpty() ? null : new RelationshipTypes(listOfTypes));
        return new Relationship(left, details, right);
    }

    Relationship(Node left, RelationshipDetail details, Node right) {
        this.left = left;
        this.right = right;
        this.details = details;
    }

    Node getLeft() {
        return this.left;
    }

    Node getRight() {
        return this.right;
    }

    public RelationshipDetail getDetails() {
        return this.details;
    }

    public Relationship named(String newSymbolicName) {
        return new Relationship(this.left, this.details.named(newSymbolicName), this.right);
    }

    public Relationship named(SymbolicName newSymbolicName) {
        return new Relationship(this.left, this.details.named(newSymbolicName), this.right);
    }

    public Relationship unbounded() {
        return new Relationship(this.left, this.details.unbounded(), this.right);
    }

    public Relationship min(Integer minimum) {
        return new Relationship(this.left, this.details.min(minimum), this.right);
    }

    public Relationship max(Integer maximum) {
        return new Relationship(this.left, this.details.max(maximum), this.right);
    }

    public Relationship length(Integer minimum, Integer maximum) {
        return new Relationship(this.left, this.details.min(minimum).max(maximum), this.right);
    }

    @Override
    public Relationship withProperties(MapExpression<?> newProperties) {
        if (newProperties == null && this.details.getProperties() == null) {
            return this;
        }
        return new Relationship(this.left, this.details.with(newProperties == null ? null : new Properties(newProperties)), this.right);
    }

    @Override
    public Relationship withProperties(Object ... keysAndValues) {
        MapExpression<?> newProperties = null;
        if (keysAndValues != null && keysAndValues.length != 0) {
            newProperties = MapExpression.create(keysAndValues);
        }
        return this.withProperties((MapExpression)newProperties);
    }

    @Override
    public Property property(String name) {
        return Property.create(this, name);
    }

    @Override
    public Optional<SymbolicName> getSymbolicName() {
        return this.details.getSymbolicName();
    }

    @Override
    public RelationshipChain relationshipTo(Node other, String ... types) {
        return RelationshipChain.create(this).add(this.right.relationshipTo(other, types));
    }

    @Override
    public RelationshipChain relationshipFrom(Node other, String ... types) {
        return RelationshipChain.create(this).add(this.right.relationshipFrom(other, types));
    }

    @Override
    public RelationshipChain relationshipBetween(Node other, String ... types) {
        return RelationshipChain.create(this).add(this.right.relationshipBetween(other, types));
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.left.accept(visitor);
        this.details.accept(visitor);
        this.right.accept(visitor);
        visitor.leave(this);
    }

    public MapProjection project(Object ... entries) {
        return MapProjection.create(this.getRequiredSymbolicName(), entries);
    }

    public static enum Direction {
        LTR("-", "->"),
        RTL("<-", "-"),
        UNI("-", "-");

        private final String symbolLeft;
        private final String symbolRight;

        private Direction(String symbolLeft, String symbolRight) {
            this.symbolLeft = symbolLeft;
            this.symbolRight = symbolRight;
        }

        public String getSymbolLeft() {
            return this.symbolLeft;
        }

        public String getSymbolRight() {
            return this.symbolRight;
        }
    }
}

